# The LearningOnline Network
# User Authentication Module
#
# $Id: lonremote.pm,v 1.34 2009/10/01 23:02:11 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::lonremote;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonmenu();
use Apache::lonlocal;

sub launchremote {
    my ($r,$lowerurl)=@_;
    &Apache::lonnet::put('environment',{'remote' => 'on'});
    &Apache::lonnet::appenv({'environment.remote' => 'on'});
# -------------------------------------------------------- Menu script and info
    my $brcrum = [{href=>"/adm/preferences",text=>"Set User Preferences"},
                  {href=>"/adm/remote?url=/adm/preferences&action=launch",text=>"Launch Remote Control"}];
    my $windowinfo=&Apache::lonmenu::open($env{'browser.os'});
    my $startupremote=&Apache::lonmenu::startupremote($lowerurl);
    my $start_page = &Apache::loncommon::start_page('Launch Remote Control',
                                                    $startupremote,
                                                    {'bread_crumbs' => $brcrum,});
    my $end_page   = &Apache::loncommon::end_page();
    my $remoteinfo=&Apache::lonmenu::load_remote_msg($lowerurl);
    my $setflags=&Apache::lonmenu::setflags();
    my $maincall=&Apache::lonmenu::maincall();
    my $message='<p class="LC_info">'
               .&mt('Launching of the Remote Control menu will fail if pop-up window filters are active.'
                   .' To use the Remote Control, disable the filter for this site.')
               .'</p>';
    $r->print(<<ENDLAUNCH);
$start_page
$setflags
$windowinfo
$message
$remoteinfo
$maincall
$end_page
ENDLAUNCH
}

sub collapseremote {
    my ($r,$lowerurl)=@_;
# -------------------------------------------------------- Menu script and info
    my $brcrum = [{href=>"/adm/preferences",text=>"Set User Preferences"},
                  {href=>"/adm/remote?url=/adm/preferences&action=collapse",text=>"Collapse Remote Control"}];
    my $start_page = 
        &Apache::loncommon::start_page('Collapse Remote Control',
                                       undef,
                                       {'bread_crumbs' => $brcrum,
                                        'no_inline_link' => 1,});
    my $end_page  =  &Apache::loncommon::end_page();
    my $windowinfo=&Apache::lonmenu::close();
#    my $switch='<meta HTTP-EQUIV="Refresh" CONTENT="0.5; url='.$lowerurl.'" />';
    my $message='<div class="LC_warning"><b>'.&mt('The external menu (Remote Control) has been disabled, and you will be working with the smaller inline menu.').'</b></div>'."\n".
                '<p>'.&mt('You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser.').'<br />'."\n".
                &mt('To use the Remote Control, disable the filter for this site, and re-launch the Remote Control.').'</p>'."\n".
                '<table><tr><td><fieldset><legend>'.&mt('Actions').'</legend><table><tr>'."\n".
                '<td class="LC_menubuttons_text" align="left">'.
                '<a class="LC_menubuttons_link" href="/adm/remote?action=launch"><img alt="Launch Remote Control" src="/res/adm/pages/remotecontrol.png" class="LC_noBorder" />'.
                &mt('Re-launch Remote Control').'</a></td><td>'.('&nbsp;'x3).'</td>'.
                '<td class="LC_menubuttons_text" align="right">'.
                '<a class="LC_menubuttons_link" href="'.$lowerurl.'"><img alt="Launch Remote Control" src="/res/adm/pages/forw.png" class="LC_noBorder" />'.
                &mt('Continue without Remote Control').'</a></td></tr></table>'.
                '</fieldset></td></tr></table>'."\n".
                '<p>'.&mt('Assuming no pop-up blocking, the Remote Control can be launched at any time from the [_1]Set User Preferences[_2] page, linked to in the [_3]Main Menu[_2].','<a href="/adm/preferences">','</a>','<a href="/adm/menu">').'</span></p>';
    $r->print(<<ENDCOLLAPSE);
$start_page
$windowinfo
$message
$end_page
ENDCOLLAPSE
    &Apache::lonnet::put('environment',{'remote' => 'off'});
    &Apache::lonnet::appenv({'environment.remote' => 'off'});
}

sub handler {
    my $r = shift;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['action','url']);
    unless ($env{'form.action'}) {
	if ($env{'environment.remote'} ne 'off') {
	    $env{'form.action'}='collapse';
        } else {
	    $env{'form.action'}='launch';
        }
    }

    my $lowerurl=$env{'form.url'};
    unless ($lowerurl) { $lowerurl='/adm/menu'; }

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    if ($env{'form.action'} eq 'launch') {
	&launchremote($r,$lowerurl);
    } else {
        &collapseremote($r,$lowerurl);
    }
    return OK;
}

1;
__END__


