# The LearningOnline Network with CAPA
# Japanese Localization Lexicon
#
# $Id: ja.pm,v 1.33 2014/02/28 19:23:30 bisitz Exp $
#
# Copyright i-Learning Limited Partnership Company
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::ja;
use base qw(Apache::localize);
%Lexicon=('_AUTO' => 1,
'language_code' => 'ja',
'char_encoding' => 'UTF-8',
'date_locale'  =>
      '$weekday, $day.$month.$year, $twentyfour:$minutes:$seconds',
'date_months'  => '1,2,3,4,5,6,7,8,9,10,11,12',
'date_days'    => '日,月,火,水,木,金,土',
'date_am' => 'am',
'date_pm' => 'pm',
'htmlarea_lang' => 'ja-utf8',

   'Deutsch - UTF' # do not translate
=> 'Deutsch - UTF',

   'English - UTF' # do not translate
=> 'English - UTF',

   'Português - UTF' # do not translate
=> 'Português - UTF',

   'español (castellano) - UTF' # do not translate
=> 'español (castellano) - UTF',

   'français - UTF' # do not translate
=> 'français - UTF',

   'türkçe - UTF' # do not translate
=> 'türkçe - UTF',

   'Русский - UTF' # do not translate
=> 'Русский - UTF',

   'עברית - UTF' # do not translate
=> 'עברית - UTF',

   '日本語 - UTF' # do not translate
=> '日本語 - UTF',

   '简体中文 - UTF' # do not translate
=> '简体中文 - UTF',

   'ﺍیﺭﺎﻧی - UTF' # do not translate
=> 'ﺍیﺭﺎﻧی - UTF',

   'ﺎﻠﻋﺮﺒﻳﺓ - UTF' # do not translate
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'Swedish Chef - UTF'
=> 'Swedish Chef - UTF',

   'Domain'
=> 'ドメイン',

   'Server'
=> 'サーバ',

   'Load'
=> '負荷',

   'User Load'
=> 'ユーザ負荷',

   'Help'
=> 'ヘルプ',

   'Log in'
=> 'ログイン',

   'Username'
=> 'ユーザ名',

   'Password'
=> 'パスワード',

   'choose'
=> '選択',

   'enter'
=> '入力',

   'view'
=> '閲覧',

   'calendar'
=> 'カレンダ',

   'prefer-'
=> '個人',

   'ences'
=> '設定',

   'role'
=> '役割',

   'course'
=> 'コース',

   'create'
=> '作成',

   'grades'
=> '成績',

   'commu-'
=> 'コミュニ',

   'nication'
=> 'ケーション',

   'enroll'
=> '出席',

   'navigate'
=> 'ナビゲート',

   'Announcements and Calendar'
=> 'お知らせとカレンダ',

   'Author'
=> '作成者',

   'Change Your Preferences'
=> 'お気に入りを変更する',

   'Choose the user role'
=> 'ユーザの役割を選ぶ',

   'Co-Author'
=> '共同作成者',

   'Communication and Messages'
=> 'コミュニケーションツール',

   'Course Coordinator'
=> 'コーディネータ',

   'Course Statistics and Charts'
=> 'コースの統計と図表',

   'Course announcements and my calendar'
=> 'コースのお知らせとカレンダ',

   'Create Users, Change User Privileges'
=> 'ユーザを作り、権限を変更する',

   'Domain Coordinator'
=> 'ドメイン管理者',

   'Enrollment Manager'
=> '履修管理者',

   'Enter grades from check-out assessment resources'
=> '成績を入力する',

   'Exam Proctor'
=> '試験官',

   'Exit LON-CAPA'
=> 'LON-CAPAを終了する',

   'Grades Spreadsheet'
=> '成績表をつける',

   'Grading'
=> '採点',

   'Instructor'
=> 'インストラクタ',

   'Launch Remote Control'
=> 'リモコンパネルを使う',

   'Main Menu'
=> 'メインメニュー',

   'Navigate Course Contents'
=> 'コースをナビゲートする',

   'No Role, Cumulative Privileges'
=> '役割・権限の設定なし',

   'Return to Last Location'
=> '最後に戻る',

   'Send and receive messages'
=> 'メッセージを送受信する',

   'Set my user preferences'
=> '個人設定を変更する',

   'Student'
=> '学生',

   'Switch to another user role'
=> '他の役割に切り替える',

   'Teaching Assistant'
=> 'ＴＡ',

   'Use or edit my bookmark collection'
=> 'ブックマークを使う／編集する',

   'User Roles'
=> '役割',

   'Calculate course grades (Spreadsheet)'
=> 'コースの成績を計算する(スプレッドシート)',

   'Enter the chatroom for the course'
=> 'コース・チャットルームに入る',

   'Navigate the table of contents for this course'
=> 'コースの目次をナビゲートする',

   'Syllabus'
=> 'シラバス',

   'View the course assessment progress chart'
=> '成績の伸長グラフを見る',

   'Class Hours'
=> '講義時間',

   'Course Description'
=> 'コースの内容',

   'Coursepack'
=> 'コースパック',

   'Current Month'
=> '今月',

   'Deadlines'
=> '締め切り',

   'Fri'
=> '金',

   'Grading Information'
=> '採点情報',

   'Helproom Hours'
=> '支援室サービス時間',

   'Instructor Information'
=> 'インストラクタ情報',

   'Mon'
=> '月',

   'Next Month'
=> '来月',

   'Office Hours'
=> 'オフィスアワー',

   'Prerequisites'
=> '前提条件',

   'Previous Month'
=> '前月',

   'Readings'
=> '読み物',

   'Sat'
=> '土',

   'January'
=> '１月',

   'February'
=> '２月',

   'March'
=> '３月',

   'April'
=> '４月',

   'May'
=> '５月',

   'June'
=> '６月',

   'August'
=> '８月',

   'September'
=> '９月',

   'October'
=> '10月',

   'November'
=> '11月',

   'December'
=> '12月',

   'Sun'
=> '日',

   'Textbook'
=> 'テキスト',

   'Thu'
=> '木',

   'Tue'
=> '火',

   'Web Links'
=> 'リンク',

   'Wed'
=> '水',

   'Drop/Add students in this course'
=> 'コースに／から学生を追加／削除する',

   'You have entered that answer before'
=> '前にもこの回答を入力しています',

   'A score has been assigned.'
=> '採点されました。',

   'You are correct.'
=> '正解です。',

   'Your receipt is'
=> 'あなたの受領するものは',

   'You are excused from the problem.'
=> 'その問題は受験しなくて良いです。',

   'Incorrect'
=> '間違い',

   'Some parts were not submitted.'
=> 'いくつかの部分が提出されていません。',

   'An error occurred while grading your answer.'
=> 'あなたの回答を採点しているときにエラーが起きました。',

   'The submitted answer was too long.'
=> '回答が長すぎます。',

   'This question expects a numeric answer.'
=> 'この質問では数字の回答を期待しています。',

   'You have provided an invalid ranking'
=> '無効な成績ランクをつけました',

   'please refer to'
=> '次のものを参照せよ：',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'アップロードしたファイルの拡張子は禁止されています。',

   'Please adjust significant figures.'
=> '数字が大きすぎます。',

   'Units incorrect.'
=> '単位が間違っています。',

   'Only a number required.'
=> '数字だけが要求されています。',

   'Units required'
=> '単位が必要です',

   'Unable to understand formula'
=> '数式を解釈できません',

   'Your submission has been recorded.'
=> '提出されたものは記録されました。',

   'Unknown message'
=> '定義されていないメッセージです',

   'Answer Submitted'
=> '提出された回答',

   'Tries'
=> '受験回数',

   'Submit Answer'
=> '回答を提出する',

   'Prepare a printable document'
=> '印刷用ドキュメントを用意します',

   'Go To My First Homework Problem'
=> '最初の問題に戻る',

   'Discussions'
=> 'ディスカッション',

   'New discussion since'
=> '次の日付以降の未読のメッセージ：',

   'Goodbye'
=> 'さようなら',


#SYNC Fri Sep 26 14:41:18 2003
   ', or the next time you log in.'
=> '、または次回のログイン。',

   ', select a template from the pull-down menu below'
=> ', 下のプルダウンメニューからテンプレートを選択する',

   'Abstract'
=> 'アブストラクト',

   'Access and Usage Statistics'
=> '統計の表示と説明',

   'Actions'
=> 'アクション',

   'All homework is currently completed'
=> 'すべての宿題は完了しています',

   'Analyze Progress'
=> '進歩状況を分析する',

   'Analyzing a problem'
=> '問題を分析する',

   'Answer'
=> '回答',

   'Answer available'
=> '正解が公開されています',

   'Answer submitted'
=> '回答は提出されています',

   'Answer submitted, not yet graded'
=> '回答は提出されていますが、採点されていません',

   'Back to Directory'
=> 'ディレクトリに戻る',

   'Discussion Board'
=> '掲示板',

   'Cancel'
=> 'キャンセル',

   'Changes will become active for your current session after'
=> '変更は次にログインしたときに有効になります',

   'Authoring Space Directory'
=> 'Authoring Space Directory', # 'コンストラクション・スペース・ディレクトリ',

   'Contact'
=> 'コンタクト',

   'Copying file'
=> 'ファイルをコピー',

   'Course'
=> 'コース',

   'Create'
=> '作成',

   'Create a user or modify the roles and privileges of a user'
=> 'ユーザを追加、役割・権限を変更',

   'Currently not available'
=> '現在、提供されていません',

   'Currently selected. '
=> '現在、選択されています。',

   'Date'
=> '日付',

   'Discard Edits and View'
=> '編集を止めて見る',

   'Display'
=> '表示する',

   'Done'
=> '完了',

   'Edit'
=> '編集',

   'EditXML'
=> 'ＸＭＬを編集',

   'Empty'
=> 'クリア',

   'End'
=> '終了',

   'Evaluation Comments'
=> '評価コメント',

   'Evaluation Data'
=> '評価データ',

   'Excused by instructor'
=> 'インストラクタによって許可されました',

   'Extent'
=> '拡張子',

   'File'
=> 'ファイル',

   'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.'
=> 'この問題の中に分析できない部分があります。現在、数字と数式と文字しかサポートされていません。',

   'Frequency'
=> '頻度',

   'Getting Problem Variants'
=> '問題の変形を得る',

   'Go Back'
=> '戻る',

   'Import'
=> 'インポート',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'このファイルを触る前にウィルススキャナーでチェックしてください。',

   'July'
=> '７月',

   'Language'
=> '言語',

   'Last Modified'
=> '最終変更',

   'List of possible answers'
=> '選択肢リスト',

   'Main Course Documents'
=> 'メイン・コース・ドキュメント',

   'Map'
=> 'マップ',

   'Map contents are not shown in order.'
=> 'マップの内容は順不同です。',

   'Name'
=> '名前',

   'Navigate Contents'
=> 'コンテンツをナビゲートする',

   'New Folder'
=> 'フォルダを作る',

   'New Messages'
=> 'メッセージを作成する',

   'New Search'
=> '新規の検索',

   'No content modifications yet.'
=> '変更されたものはありません。',

   'No due date'
=> '締め切りはありません',

   'No role specified'
=> '役割は指定されていません',

   'No upload file specified.'
=> 'アップロードするファイルを指定していません。',

   'No write permission to user directory, FAIL'
=> '書き込み権限がありません、失敗しました',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> '注意：すべてのユーザに変更の結果が行き渡るのに１０分位かかります。',

   'Notes'
=> '（注）',

   'Open, no due date'
=> '締め切りなし',

   'Page'
=> 'ページ',

   'Part'
=> 'パート',

   'Part is not open to be viewed. It'
=> 'パートがオープンされていません。',

   'Path'
=> 'パス',

   'Please use browser "Back" button and pick a filename'
=> 'ブラウザの"戻る"ボタンで戻って、ファイル名を指定してください',

   'Processing'
=> '処理中',

   'Re-Initialize'
=> '再度初期化する',

   'Remark'
=> '再度採点する',

   'Rename'
=> 'リネームする',

   'Save'
=> '保存する',

   'Saving Modifications to'
=> '変更を保存する：',

   'Search'
=> '検索する',

   'Searching'
=> '検索中',

   'Section/Group'
=> '章／グループ',

   'Select'
=> '選択する',

   'Select Course'
=> 'コースを選択する',

   'Select User'
=> 'ユーザを選択する',

   'Select a'
=> '選択する：',

   'Select the Authoring Space'
=> 'Select the Authoring Space', # 'コンストラクション・スペースを選択する',

   'Sequence'
=> 'シーケンス',

   'Server Administration'
=> 'サーバ管理',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> '締め切りを設定し、その他の試験のパラメータ、コース環境を変更します',

   'Show Only Uncompleted Homework'
=> '完了していない宿題のみ表示する',

   'Simple Page'
=> 'シンプルページ',

   'Simple Problem'
=> 'シンプル問題',

   'Special Documents'
=> '特別ドキュメント',

   'Start'
=> 'スタート',

   'Status'
=> '状態',

   'Save uploaded file as '
=> 'アップロードされたファイルを保存する：',

   'Submit'
=> '提出する',

   'Submit Changes'
=> '変更を保存する',

   'Submit Changes and View'
=> '変更を保存して結果を見る',

   'Supplemental Course Documents'
=> '補助教材',

   'Switch Server'
=> 'サーバを切替える',

   'System'
=> 'システム',

   'System Administration'
=> 'システム管理',

   'The target is an existing directory.'
=> 'ディレクトリは存在しています。',

   'Then'
=> 'それから',

   'Title'
=> 'タイトル',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'ネットワークの障害のため、このリソースが締め切りなしかどうか決定できません。後でもう一度試してください。',

   'Unable to find'
=> '見つかりません',

   'Unable to make backup'
=> 'バックアップを作成できません',

   'Unable to undo, unable to switch'
=> '取り消し、切替えることが出来ません',

   'Unable to write to'
=> '書き込むことが出来ません：',

   'Uncompleted Homework'
=> '完成していない宿題',

   'Undid changes, Switched'
=> '変更をキャンセルし、切り替えました',

   'Upload Document'
=> 'ドキュメントをアップロードする',

   'Uploaded Document'
=> 'ドキュメントをアップロードしました',

   'User Role'
=> '役割',

   'View All Messages'
=> 'すべてのメッセージを見る',

   'View course assessment statistics'
=> 'コースのテストの統計を見る',

   'Was due'
=> 'は締め切りになりました',

   'Yes'
=> 'はい',

   'You did not select a template.'
=> 'テンプレートを選択していませんでした。',

   'You do not have authoring privileges for this resource'
=> 'このコースの編集権限を持っていません。',

   'You have no unread messages'
=> '未読メッセージはありません',

   'an indeterminate date'
=> '中間締め切り',

   'an unknown date'
=> '？？？？／？？／？？',

   'could not be copied.'
=> 'コピーできません。',

   'is closed but you are allowed to view it'
=> '締め切られましたが見ることは出来ます',

   'is due at [_1]'
=> 'の締切りは [_1]',

   'is in under construction'
=> 'は作成中です',

   'is not analyzable at this time'
=> 'は現在分析できません',

   'last month'
=> '先月',

   'last problem'
=> '最後の問題',

   'last six months'
=> 'この６ヶ月',

   'last three months'
=> 'この３ヶ月',

   'last week'
=> '先週',

   'last year'
=> '昨年',

   'may open later.'
=> 'は後で公開されます。',

   'never'
=> '決して',

   'not displayed'
=> '表示されません',

   're-initializing course'
=> '再度初期化されたコース',

   'system wide'
=> 'システム全体',

   'today'
=> '今日',

   'undo'
=> 'やり直し',

   'was due on [_1], and answers will be available on [_2]'
=> 'は締め切られました：[_1], 正解は次のリンクにあります [_2]',

   'will open on [_1]'
=> 'は公開されます：[_1]',

#SYNC Fri Sep 26 16:57:10 2003
   ', is reserved internally by LON-CAPA.'
=> ',はＬＯＮ－ＣＡＰＡの内部で予約されています。',

   'Back to'
=> '戻る⇒',

   'Back to Source'
=> 'ソースへ戻る',

   'Back to Source Directory'
=> 'ソースディレクトリに戻る',

   'Became this version on ...'
=> 'このバージョンになったのは ...',

   'Browse published resources'
=> '公開されたリソースを見る',

   'Choose the course to work on'
=> 'コースを稼動させるために選択する',

   'Create a new course'
=> '新しいコースを作成する',

   'Customized right of use ...'
=> '使用権限をカスタマイズする ...',

   'Delete messages from discussion boards'
=> '掲示板からメッセージを削除する',

   'Domain only - use limited to courses in the domain'
=> 'フォメイン限定 － ドメインを限定してコースを使う',

   'Dynamic Metadata'
=> 'ダイナミック・メタデータ',

   'Edit and view documents included in this course'
=> 'このコースに含まれているドキュメントを編集・閲覧する',

   'Edit/Modify DOCS'
=> '編集 DOCS',

   'Enter my Authoring Space'
=> 'Enter my Authoring Space', # '自分のコンストラクション・スペースに入る',

   'FAIL'
=> '失敗',

   'Failed to copy source'
=> 'ソースをコピーすることに失敗しました',

   'Failed to write metadata copy'
=> 'メタデータを書き込むことに失敗しました',

   'File copied.'
=> 'ファイルをコピーしました。',

   'Finalize Publication'
=> '出版を完結する',

   'Grant/revoke role of Co-Author'
=> '共同作成者の役割を付与／剥奪する',

   'Grant/revoke role of Domain Coordinator'
=> 'ドメイン管理者の役割を付与／剥奪する',

   'Grant/revoke role of Exam Proctor'
=> '試験官の役割を付与／剥奪する',

   'Grant/revoke role of Instructor'
=> 'インストラクタの役割を付与／剥奪する',

   'Grant/revoke role of Student'
=> '学生の役割を付与／剥奪する',

   'Grant/revoke role of Superuser'
=> 'スーパーユーザの役割を付与／剥奪する',

   'Illegal filename.'
=> '禁止されたファイル名です。',

   'Name starting with'
=> '次の名前で始まる：',

   'No previous versions published.'
=> '以前のバージョンはありません。',

   'No write permission to'
=> '書き込み権限はありません：',

   'Please pick a version to retrieve'
=> '取り出すバージョンを選んでください',

   'Private - visible to author only for testing purposes'
=> '非公開 － 作成中で作成者にしか見えない',

   'Private Publication - did not synchronize database'
=> '非公開 － データベースと同期しません',

   'Public - no authentication or authorization required for use'
=> '公開 － 認証や認可無しに使用できます',

   'Retrieval of an old version will overwrite the file currently in Authoring Space.'
=> 'Retrieval of an old version will overwrite the file currently in Authoring Space.', # '古いバージョンを取り込むと、現在コンストラクション・スペースにあるファイルを上書きします',

   'Retrieve previous versions of'
=> '前のバージョンを取り出す：',

   'Retrieve version'
=> 'バージョンを取り出す',

   'Rule'
=> '役割',

   'Search the contents of this course'
=> 'コースコンテンツを検索する',

   'Search the database of published resources'
=> '公開されたリソースのデータベースを検索する',

   'Send broadcast and receipt-required email'
=> 'ブロードキャストや受信確認要求のあるメールを送る',

   'Show Problem Completeness'
=> '問題の完全性を見る',

   'Switch to another course'
=> '他のコースに切り替える',

   'System wide - can be used for any courses system wide'
=> 'システム全体 － システム全体のコースを使用することができる',

   'System wide - open source to all authors'
=> 'システム全体 － ソースをすべての作成者に公開する',

   'The extension on this file'
=> 'このファイルの拡張子',

   'This resource has been marked obsolete by the author(s)'
=> 'このリソースは採点されました',

   'Unsupported character combination'
=> 'サポートされていない文字の組合せです',

   'Uploaded'
=> 'アップロードしました',

   'Users with Roles Assigned by'
=> '次の役割を持ったユーザ：',

   'View documents included in this course'
=> 'このコースの中のドキュメントを見る',

   'View file'
=> 'ファイルを閲覧する',

   'untitled'
=> '無題',

#SYNC Sun Sep 28 12:06:11 2003
   'Additional Keywords'
=> '追加のキーワード',

   'Additional Metadata (non-standard, parameters, exports)'
=> '追加のメタデータ (非標準, パラメータ, エキスポート)',

   'All versions'
=> 'すべてのバージョン',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> '作成者と共同作成者の役割はホームサーバ以外では提供されません。',

   'Author(s)'
=> '著者',

   'Average number of tries till solved'
=> '正解までの平均受験回数',

   'Browse Resources'
=> 'リソースを見る',

   'Catalog Information'
=> 'カタログ情報',

   'Collapse Remote Control'
=> 'リモコン・パネルを消します',

   'Authoring Space'
=> 'Authoring Space', # 'コンストラクション・スペース',

   'Content changed'
=> 'コンテンツが変更されました',

   'Copied metadata'
=> 'メタデータはコピーされました',

   'Copied source file'
=> 'ファイルはコピーされました',

   'Copyright/Distribution'
=> '著作権／ディストリビューション',

   'Could not write metadata'
=> 'メタデータを書き込めませんでした',

   'Course Documents'
=> 'コースドキュメント',

   'Creation Date'
=> '作成日',

   'Custom Distribution File'
=> '配布するファイルをカスタマイズする',

   'Default Cataloging Information for Directory'
=> 'デフォルトのディレクトリ用カタログ情報',

   'Degree of difficulty'
=> '困難度',

   'Differences'
=> '違い',

   'Copy Course Content to Authoring Space'
=> 'Copy Course Content to Authoring Space', # 'コンストラクション・スペースにＤＯＣＳをダンプする',

   'Entering course ...'
=> 'コースに入る ...',

   'Error Messages'
=> 'エラーメッセージ',

   'Exam Information'
=> '試験情報',

   'External Resource'
=> '外部リソース',

   'Generate new role ...'
=> '新しい役割を生成する ...',

   'Go to the next resource in the course sequence'
=> 'このコースのシーケンス上の次のリソースに進む',

   'Go to the previous resource in the course sequence'
=> 'このコースのシーケンス上の前のリソースに戻る',

   'Import a published document'
=> '公開されているドキュメントをインポートする',

   'Keyword(s)'
=> 'キーワード',

   'Last Week'
=> '先週',

   'Load Map'
=> 'マップをロードする',

   'Logged Out'
=> 'ログアウトしました',

   'MIME Type'
=> 'ＭＩＭＥタイプ',

   'Make notes and annotations about this resource'
=> 'このリソースのノートを取ります',

   'Material appears to be correct'
=> '素材は正しく思えます',

   'Material covered with sufficient depth'
=> '素材は充分にカバーしています',

   'Material is helpful'
=> '素材は助けになります',

   'Material presented in clear way'
=> '素材は明瞭な方法で示されています',

   'Metadata Information'
=> 'メタデータ情報',

   'Modification Date'
=> '変更日付',

   'My Personal Info'
=> '個人情報',

   'Network-wide number of accesses (hits)'
=> 'ネットワーク全体のアクセス(ヒット数)',

   'Network-wide number of courses using resource'
=> 'リソースを使用しているネットワーク全体のコースの数',

   'Number of resources that follow this resource in maps'
=> 'マップの中でこのリソースに従っているリソースの数',

   'Number of resources that lead up to this resource in maps'
=> 'マップの中でこのリソースに従えているリソースの数',

   'Number of resources using or importing resource'
=> 'このリソースを使っている／インポートしているリソースの数',

   'Obsolete'
=> '旧',

   'Parent Directory'
=> '親ディレクトリ',

   'Please either'
=> 'どちらも',

   'Project Information'
=> 'プロジェクト情報',

   'Publisher/Owner'
=> '出版社／所有者',

   'Publishing'
=> '公開',

   'Resource Publication'
=> 'リソースを公開する',

   'Resource is technically correct'
=> 'リソースは技術的に正しい',

   'Score Upload Form'
=> 'アップロードされたフォームの得点',

   'Select Map'
=> 'マップを選択する',

   'Set a bookmark for this resource'
=> 'このリソースのブックマークをセットする',

   'Show all roles'
=> '役割をすべて表示する',

   'Since Start of Course'
=> 'コースの最初から',

   'Since Yesterday'
=> '昨日から',

   'Special documents'
=> '特別教材',

   'Save Catalog Information'
=> 'カタログ情報を保存する',

   'Subject'
=> '表題',

   'Successful Login'
=> '正常にログインしました',

   'Suggested Replacement for Obsolete File'
=> '古いファイルの置換えを薦めます',

   'Switching Role'
=> '役割を切替える',

   'Target'
=> 'ターゲット',

   'This syllabus can be publicly viewed at'
=> 'このシラバスは次の場所で公開されます：',

   'Total number of students who have worked on this problem'
=> 'この問題の全受験者数',

   'URLs To Include in Syllabus'
=> 'シラバスに含むＵＲＬ',

   'Update Display'
=> '表示を更新する',

   'Upload a new main course document'
=> '新しいメイン・コースドキュメントをアップロードする',

   'Upload a new supplemental course document'
=> '新しい補助教材をアップロードする',

   'User'
=> 'ユーザ',

   'Verify Course Documents'
=> 'コースドキュメントをべリファイしました',

   'Version'
=> 'バージョン',

   'Wrote Metadata'
=> 'メタデータを書き込みました',

   'Your home server is '
=> 'ホームサーバは：',

   'access denied'
=> 'アクセスは拒否されました',

   'anno-'
=> 'アノ',

   'announce'
=> 'お知らせ',

   'backward'
=> '後',

   'bookmark'
=> 'ブックマーク',

   'chart'
=> '図',

   'chat'
=> 'チャット',

   'close this window'
=> 'ウィンドウを閉じる',

   'con-'
=> 'con-',

   'connection down'
=> '接続が切れました',

   'docs'
=> 'docs',

   'during the last'
=> '前',

   'edit crs'
=> 'コースを編集',

   'exit'
=> '終了',

   'fas'
=> 'fas',

   'forward'
=> '次へ',

   'library'
=> 'ライブラリ',

   'log in again'
=> '再度ログインしてください',

   'my'
=> '私の',

   'not found'
=> '見つかりません',

   'or'
=> 'または',

   'parms'
=> 'パラメータ',

   'prepare'
=> '準備する',

   'printout'
=> '印刷する',

   'resource'
=> 'リソース',

   'roles'
=> '役割',

   'search'
=> '検索する',

   'set'
=> 'セットする',

   'space'
=> 'スペース',

   'stats'
=> '状態',

   'struct'
=> '作成する',

   'switch'
=> '切替える',

   'tations'
=> 'テーション',

   'updated periodically'
=> '周期的に更新されます',

   'user'
=> 'ユーザ',

   'visible to author and co-authors only'
=> '作成者と共同作成者に限り見ることが出来ます',

   'warning(s)'
=> '警告',

   "Click to download or use your browser's Save Link function"
=> "Click to download or use your browser's Save Link function",


# ----

   'calendar[_1]'
=> 'カレンダ',

   'announce[_1]'
=> 'お知らせ',


# ----

   'commu-[_1]'
=> 'コミュニ',

   'nication[_1]'
=> 'ケーション',


# ----

   'course[_10]'
=> 'コース',

   'chat[_1]'
=> 'チャット',


# ----

   'search[_1]'
=> '検索する',

   'course[_11]'
=> 'コース',


# ----

   'search[_2]'
=> '検索する',

   'library[_1]'
=> 'ライブラリ',


# ----

   'prefer-[_1]'
=> '個人',

   'ences[_1]'
=> '設定',


# ----

   'exit[_1]'
=> '終了',

   ' [_1]'
=> '',


# ----

   'switch[_2]'
=> '切替える',

   'role[_1]'
=> '役割',


# ----

   'choose[_2]'
=> '選択',

   'role[_2]'
=> '役割',


# ----

   'choose[_1]'
=> '選択',

   'course[_1]'
=> 'コース',


# ----

   'switch[_1]'
=> '切替える',

   'course[_2]'
=> 'コース',


# ----

   'course[_3]'
=> 'コース',

   'docs[_1]'
=> 'docs',


# ----

   'edit crs[_1]'
=> 'コースを編集',

   'docs[_2]'
=> 'docs',


# ----

   'navigate[_1]'
=> 'ナビゲート',

   'contents[_1]'
=> 'コンテンツ',


# ----

   'my[_1]'
=> '私の',

   'grades[_1]'
=> '成績',


# ----

   'course[_4]'
=> 'コース',

   'grades[_2]'
=> '成績',


# ----

   'course[_5]'
=> 'コース',

   'chart[_1]'
=> '図',


# ----

   'course[_6]'
=> 'コース',

   'stats[_1]'
=> '状態',


# ----

   'course[_7]'
=> 'コース',

   'enroll[_1]'
=> '出席',


# ----

   'manage[_1]'
=> 'manage (553)',

   'acc keys[_1]'
=> 'acc keys (515)',


# ----

   'user[_1]'
=> 'ユーザ',

   'roles[_1]'
=> '役割',


# ----

   'create[_1]'
=> '作成',

   'course[_8]'
=> 'コース',


# ----

   'course[_9]'
=> 'コース',

   'parms[_1]'
=> 'パラメータ',


# ----

   'con-[_1]'
=> 'con-',

   'struct[_1]'
=> '作成する',


# ----

   'co con-[_1]'
=> 'co con- (530)',

   'struct[_2]'
=> '作成する',


# ----

   'resource[_1]'
=> 'リソース',

   'space[_1]'
=> 'スペース',


# ----

   'co res[_1]'
=> 'co res (531)',

   'space[_2]'
=> 'スペース',


# ----

   'enter[_1]'
=> '入力',

# ----

   'view[_1]'
=> '閲覧',

   'bookmark[_1]'
=> 'ブックマーク',

#SYNCMARKER
);

1;

