# The LearningOnline Network with CAPA
# Build menu bar for Advanced RAT. Uses javascript code originally in
# static file: rat/client/code.html, now in  rat/client/ratcode.js  
#
# $Id: lonratmenu.pm,v 1.18.8.4 2016/08/05 20:09:49 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
package Apache::lonratmenu;

use strict;
use Apache::Constants qw(:common);
use Apache::File;
use Apache::loncommon;
use Apache::lonhtmlcommon;
use Apache::lonlocal;
use Apache::lonnet;

sub handler {
    my $r = shift;
    my $include = $Apache::lonnet::perlvar{'lonIncludes'};
    my $jsh=Apache::File->new($include."/ratcode.js");
    my $js = join('',<$jsh>);
    my %loaditem = ('onunload' => "leave();",);

    my $readfile=$r->uri;
    $readfile=~s/\/loadonly\/adveditmenu$//;

    # Breadcrumbs
    my $brcrum = [{'href' => &Apache::loncommon::authorspace($r->uri),
                   'text' => 'Authoring Space',
                   'target' => '_top'},
                  {'href' => '',
                   'text' => 'RAT'},
                  {'href' => '',
                   'text' => 'Advanced Editor'}];

    my $help=&Apache::loncommon::help_open_menu(
        'Sequence_Advanced_Editor_Creation',
        'Sequence_Advanced_Editor_Creation',6,'RAT');


    # Compile available Advanced RAT functions
    my $functions = '<div class="LC_columnSection">';

    $functions .= $help; # FIXME: Move help to bread_crumbs_component

    $functions .=
       &Apache::lonhtmlcommon::start_funclist(&mt('Display Actions'))
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:togglemode();">'
          .&mt('Toggle display').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:if (zscale>1) { zscale--; draw();}">'
          .&mt('Zoom out').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:if (zscale<3) { zscale++; draw();}">'
          .&mt('Zoom in').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:condense();draw();">'
          .&mt('Condense').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:graphopt();draw();">'
          .&mt('Straighten').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:revert();">'
          .&mt('Revert').'</a>')
      .&Apache::lonhtmlcommon::end_funclist();

    $functions .=
       &Apache::lonhtmlcommon::start_funclist(&mt('Version Actions'))
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:undo();">'
          .&mt('Undo').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:redo();">'
          .&mt('Redo').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:groupopen(\''.$readfile.'\');">'
          .&mt('Recover deleted').'</a>')
      .&Apache::lonhtmlcommon::end_funclist();

    $functions .=
       &Apache::lonhtmlcommon::start_funclist(&mt('Import'))
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:groupsearch();">'
          .&mt('Search').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:groupimport();">'
          .&mt('Import').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:open_StoredLinks_Import('."'advanced'".');">'
          .&mt('Import from Stored Links').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:groupcopy();">'
          .&mt('Copy').'</a>')
      .&Apache::lonhtmlcommon::end_funclist();

    $functions .=
       &Apache::lonhtmlcommon::start_funclist(&mt('Save'))
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:graphdef=\'no\';save();storechange();">'
          .&mt('Save map').'</a>')
      .&Apache::lonhtmlcommon::add_item_funclist(
           '<a href="javascript:storechange();">'
          .&mt('Save map and layout').'</a>')
      .&Apache::lonhtmlcommon::end_funclist();

    $functions .= '</div>'; # End: LC_columnSection

    $functions .= &Apache::lonhtmlcommon::scripttag('main();');


    # Print Advanced RAT page header
    $r->send_http_header('text/html');

    $r->print(
        &Apache::loncommon::start_page(
            'Advanced Editor',
            $js,
            {'add_entries' => \%loaditem,
             'bread_crumbs' => $brcrum,})

       .&Apache::loncommon::head_subbox(
            &Apache::loncommon::CSTR_pageheader()
           .$functions)

       .&Apache::loncommon::end_page()
    );

    return OK;
}

1;

