/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeDate
extends IdScriptableObject {
    static final long serialVersionUID = -8307438915861678966L;
    private static final Object DATE_TAG = "Date";
    private static final String js_NaN_date_str = "Invalid Date";
    private static final double HalfTimeDomain = 8.64E15;
    private static final double HoursPerDay = 24.0;
    private static final double MinutesPerHour = 60.0;
    private static final double SecondsPerMinute = 60.0;
    private static final double msPerSecond = 1000.0;
    private static final double MinutesPerDay = 1440.0;
    private static final double SecondsPerDay = 86400.0;
    private static final double SecondsPerHour = 3600.0;
    private static final double msPerDay = 8.64E7;
    private static final double msPerHour = 3600000.0;
    private static final double msPerMinute = 60000.0;
    private static final boolean TZO_WORKAROUND = false;
    private static final int MAXARGS = 7;
    private static final int ConstructorId_now = -3;
    private static final int ConstructorId_parse = -2;
    private static final int ConstructorId_UTC = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toTimeString = 3;
    private static final int Id_toDateString = 4;
    private static final int Id_toLocaleString = 5;
    private static final int Id_toLocaleTimeString = 6;
    private static final int Id_toLocaleDateString = 7;
    private static final int Id_toUTCString = 8;
    private static final int Id_toSource = 9;
    private static final int Id_valueOf = 10;
    private static final int Id_getTime = 11;
    private static final int Id_getYear = 12;
    private static final int Id_getFullYear = 13;
    private static final int Id_getUTCFullYear = 14;
    private static final int Id_getMonth = 15;
    private static final int Id_getUTCMonth = 16;
    private static final int Id_getDate = 17;
    private static final int Id_getUTCDate = 18;
    private static final int Id_getDay = 19;
    private static final int Id_getUTCDay = 20;
    private static final int Id_getHours = 21;
    private static final int Id_getUTCHours = 22;
    private static final int Id_getMinutes = 23;
    private static final int Id_getUTCMinutes = 24;
    private static final int Id_getSeconds = 25;
    private static final int Id_getUTCSeconds = 26;
    private static final int Id_getMilliseconds = 27;
    private static final int Id_getUTCMilliseconds = 28;
    private static final int Id_getTimezoneOffset = 29;
    private static final int Id_setTime = 30;
    private static final int Id_setMilliseconds = 31;
    private static final int Id_setUTCMilliseconds = 32;
    private static final int Id_setSeconds = 33;
    private static final int Id_setUTCSeconds = 34;
    private static final int Id_setMinutes = 35;
    private static final int Id_setUTCMinutes = 36;
    private static final int Id_setHours = 37;
    private static final int Id_setUTCHours = 38;
    private static final int Id_setDate = 39;
    private static final int Id_setUTCDate = 40;
    private static final int Id_setMonth = 41;
    private static final int Id_setUTCMonth = 42;
    private static final int Id_setFullYear = 43;
    private static final int Id_setUTCFullYear = 44;
    private static final int Id_setYear = 45;
    private static final int MAX_PROTOTYPE_ID = 45;
    private static final int Id_toGMTString = 8;
    private static TimeZone thisTimeZone;
    private static double LocalTZA;
    private static DateFormat timeZoneFormatter;
    private static DateFormat localeDateTimeFormatter;
    private static DateFormat localeDateFormatter;
    private static DateFormat localeTimeFormatter;
    private double date;

    static void init(Scriptable scriptable, boolean bl) {
        NativeDate nativeDate = new NativeDate();
        nativeDate.date = ScriptRuntime.NaN;
        nativeDate.exportAsJSClass(45, scriptable, bl);
    }

    private NativeDate() {
        if (thisTimeZone == null) {
            thisTimeZone = TimeZone.getDefault();
            LocalTZA = thisTimeZone.getRawOffset();
        }
    }

    @Override
    public String getClassName() {
        return "Date";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz == null) {
            clazz = ScriptRuntime.StringClass;
        }
        return super.getDefaultValue(clazz);
    }

    double getJSTimeValue() {
        return this.date;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, DATE_TAG, -3, "now", 0);
        this.addIdFunctionProperty(idFunctionObject, DATE_TAG, -2, "parse", 1);
        this.addIdFunctionProperty(idFunctionObject, DATE_TAG, -1, "UTC", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toTimeString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "toDateString";
                break;
            }
            case 5: {
                n2 = 0;
                string = "toLocaleString";
                break;
            }
            case 6: {
                n2 = 0;
                string = "toLocaleTimeString";
                break;
            }
            case 7: {
                n2 = 0;
                string = "toLocaleDateString";
                break;
            }
            case 8: {
                n2 = 0;
                string = "toUTCString";
                break;
            }
            case 9: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 10: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            case 11: {
                n2 = 0;
                string = "getTime";
                break;
            }
            case 12: {
                n2 = 0;
                string = "getYear";
                break;
            }
            case 13: {
                n2 = 0;
                string = "getFullYear";
                break;
            }
            case 14: {
                n2 = 0;
                string = "getUTCFullYear";
                break;
            }
            case 15: {
                n2 = 0;
                string = "getMonth";
                break;
            }
            case 16: {
                n2 = 0;
                string = "getUTCMonth";
                break;
            }
            case 17: {
                n2 = 0;
                string = "getDate";
                break;
            }
            case 18: {
                n2 = 0;
                string = "getUTCDate";
                break;
            }
            case 19: {
                n2 = 0;
                string = "getDay";
                break;
            }
            case 20: {
                n2 = 0;
                string = "getUTCDay";
                break;
            }
            case 21: {
                n2 = 0;
                string = "getHours";
                break;
            }
            case 22: {
                n2 = 0;
                string = "getUTCHours";
                break;
            }
            case 23: {
                n2 = 0;
                string = "getMinutes";
                break;
            }
            case 24: {
                n2 = 0;
                string = "getUTCMinutes";
                break;
            }
            case 25: {
                n2 = 0;
                string = "getSeconds";
                break;
            }
            case 26: {
                n2 = 0;
                string = "getUTCSeconds";
                break;
            }
            case 27: {
                n2 = 0;
                string = "getMilliseconds";
                break;
            }
            case 28: {
                n2 = 0;
                string = "getUTCMilliseconds";
                break;
            }
            case 29: {
                n2 = 0;
                string = "getTimezoneOffset";
                break;
            }
            case 30: {
                n2 = 1;
                string = "setTime";
                break;
            }
            case 31: {
                n2 = 1;
                string = "setMilliseconds";
                break;
            }
            case 32: {
                n2 = 1;
                string = "setUTCMilliseconds";
                break;
            }
            case 33: {
                n2 = 2;
                string = "setSeconds";
                break;
            }
            case 34: {
                n2 = 2;
                string = "setUTCSeconds";
                break;
            }
            case 35: {
                n2 = 3;
                string = "setMinutes";
                break;
            }
            case 36: {
                n2 = 3;
                string = "setUTCMinutes";
                break;
            }
            case 37: {
                n2 = 4;
                string = "setHours";
                break;
            }
            case 38: {
                n2 = 4;
                string = "setUTCHours";
                break;
            }
            case 39: {
                n2 = 1;
                string = "setDate";
                break;
            }
            case 40: {
                n2 = 1;
                string = "setUTCDate";
                break;
            }
            case 41: {
                n2 = 2;
                string = "setMonth";
                break;
            }
            case 42: {
                n2 = 2;
                string = "setUTCMonth";
                break;
            }
            case 43: {
                n2 = 3;
                string = "setFullYear";
                break;
            }
            case 44: {
                n2 = 3;
                string = "setUTCFullYear";
                break;
            }
            case 45: {
                n2 = 1;
                string = "setYear";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(DATE_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(DATE_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case -3: {
                return ScriptRuntime.wrapNumber(NativeDate.now());
            }
            case -2: {
                String string = ScriptRuntime.toString(objectArray, 0);
                return ScriptRuntime.wrapNumber(NativeDate.date_parseString(string));
            }
            case -1: {
                return ScriptRuntime.wrapNumber(NativeDate.jsStaticFunction_UTC(objectArray));
            }
            case 1: {
                if (scriptable2 != null) {
                    return NativeDate.date_format(NativeDate.now(), 2);
                }
                return NativeDate.jsConstructor(objectArray);
            }
        }
        if (!(scriptable2 instanceof NativeDate)) {
            throw NativeDate.incompatibleCallError(idFunctionObject);
        }
        NativeDate nativeDate = (NativeDate)scriptable2;
        double d = nativeDate.date;
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                if (d == d) {
                    return NativeDate.date_format(d, n);
                }
                return js_NaN_date_str;
            }
            case 5: 
            case 6: 
            case 7: {
                if (d == d) {
                    return NativeDate.toLocale_helper(d, n);
                }
                return js_NaN_date_str;
            }
            case 8: {
                if (d == d) {
                    return NativeDate.js_toUTCString(d);
                }
                return js_NaN_date_str;
            }
            case 9: {
                return "(new Date(" + ScriptRuntime.toString(d) + "))";
            }
            case 10: 
            case 11: {
                return ScriptRuntime.wrapNumber(d);
            }
            case 12: 
            case 13: 
            case 14: {
                if (d == d) {
                    if (n != 14) {
                        d = NativeDate.LocalTime(d);
                    }
                    d = NativeDate.YearFromTime(d);
                    if (n == 12) {
                        if (context.hasFeature(1)) {
                            if (1900.0 <= d && d < 2000.0) {
                                d -= 1900.0;
                            }
                        } else {
                            d -= 1900.0;
                        }
                    }
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 15: 
            case 16: {
                if (d == d) {
                    if (n == 15) {
                        d = NativeDate.LocalTime(d);
                    }
                    d = NativeDate.MonthFromTime(d);
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 17: 
            case 18: {
                if (d == d) {
                    if (n == 17) {
                        d = NativeDate.LocalTime(d);
                    }
                    d = NativeDate.DateFromTime(d);
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 19: 
            case 20: {
                if (d == d) {
                    if (n == 19) {
                        d = NativeDate.LocalTime(d);
                    }
                    d = NativeDate.WeekDay(d);
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 21: 
            case 22: {
                if (d == d) {
                    if (n == 21) {
                        d = NativeDate.LocalTime(d);
                    }
                    d = NativeDate.HourFromTime(d);
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 23: 
            case 24: {
                if (d == d) {
                    if (n == 23) {
                        d = NativeDate.LocalTime(d);
                    }
                    d = NativeDate.MinFromTime(d);
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 25: 
            case 26: {
                if (d == d) {
                    if (n == 25) {
                        d = NativeDate.LocalTime(d);
                    }
                    d = NativeDate.SecFromTime(d);
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 27: 
            case 28: {
                if (d == d) {
                    if (n == 27) {
                        d = NativeDate.LocalTime(d);
                    }
                    d = NativeDate.msFromTime(d);
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 29: {
                if (d == d) {
                    d = (d - NativeDate.LocalTime(d)) / 60000.0;
                }
                return ScriptRuntime.wrapNumber(d);
            }
            case 30: {
                nativeDate.date = d = NativeDate.TimeClip(ScriptRuntime.toNumber(objectArray, 0));
                return ScriptRuntime.wrapNumber(d);
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                nativeDate.date = d = NativeDate.makeTime(d, objectArray, n);
                return ScriptRuntime.wrapNumber(d);
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                nativeDate.date = d = NativeDate.makeDate(d, objectArray, n);
                return ScriptRuntime.wrapNumber(d);
            }
            case 45: {
                double d2 = ScriptRuntime.toNumber(objectArray, 0);
                if (d2 != d2 || Double.isInfinite(d2)) {
                    d = ScriptRuntime.NaN;
                } else {
                    d = d != d ? 0.0 : NativeDate.LocalTime(d);
                    if (d2 >= 0.0 && d2 <= 99.0) {
                        d2 += 1900.0;
                    }
                    double d3 = NativeDate.MakeDay(d2, NativeDate.MonthFromTime(d), NativeDate.DateFromTime(d));
                    d = NativeDate.MakeDate(d3, NativeDate.TimeWithinDay(d));
                    d = NativeDate.internalUTC(d);
                    d = NativeDate.TimeClip(d);
                }
                nativeDate.date = d;
                return ScriptRuntime.wrapNumber(d);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static double Day(double d) {
        return Math.floor(d / 8.64E7);
    }

    private static double TimeWithinDay(double d) {
        double d2 = d % 8.64E7;
        if (d2 < 0.0) {
            d2 += 8.64E7;
        }
        return d2;
    }

    private static boolean IsLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    private static double DayFromYear(double d) {
        return 365.0 * (d - 1970.0) + Math.floor((d - 1969.0) / 4.0) - Math.floor((d - 1901.0) / 100.0) + Math.floor((d - 1601.0) / 400.0);
    }

    private static double TimeFromYear(double d) {
        return NativeDate.DayFromYear(d) * 8.64E7;
    }

    private static int YearFromTime(double d) {
        int n = (int)Math.floor(d / 8.64E7 / 366.0) + 1970;
        int n2 = (int)Math.floor(d / 8.64E7 / 365.0) + 1970;
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        while (n2 > n) {
            int n4 = (n2 + n) / 2;
            if (NativeDate.TimeFromYear(n4) > d) {
                n2 = n4 - 1;
                continue;
            }
            n = n4 + 1;
            if (!(NativeDate.TimeFromYear(n) > d)) continue;
            return n4;
        }
        return n;
    }

    private static double DayFromMonth(int n, int n2) {
        int n3 = n * 30;
        n3 = n >= 7 ? (n3 += n / 2 - 1) : (n >= 2 ? (n3 += (n - 1) / 2 - 1) : (n3 += n));
        if (n >= 2 && NativeDate.IsLeapYear(n2)) {
            ++n3;
        }
        return n3;
    }

    private static int MonthFromTime(double d) {
        int n;
        int n2 = NativeDate.YearFromTime(d);
        int n3 = (int)(NativeDate.Day(d) - NativeDate.DayFromYear(n2));
        if ((n3 -= 59) < 0) {
            return n3 < -28 ? 0 : 1;
        }
        if (NativeDate.IsLeapYear(n2)) {
            if (n3 == 0) {
                return 1;
            }
            --n3;
        }
        int n4 = n3 / 30;
        switch (n4) {
            case 0: {
                return 2;
            }
            case 1: {
                n = 31;
                break;
            }
            case 2: {
                n = 61;
                break;
            }
            case 3: {
                n = 92;
                break;
            }
            case 4: {
                n = 122;
                break;
            }
            case 5: {
                n = 153;
                break;
            }
            case 6: {
                n = 184;
                break;
            }
            case 7: {
                n = 214;
                break;
            }
            case 8: {
                n = 245;
                break;
            }
            case 9: {
                n = 275;
                break;
            }
            case 10: {
                return 11;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        return n3 >= n ? n4 + 2 : n4 + 1;
    }

    private static int DateFromTime(double d) {
        int n;
        int n2;
        int n3 = NativeDate.YearFromTime(d);
        int n4 = (int)(NativeDate.Day(d) - NativeDate.DayFromYear(n3));
        if ((n4 -= 59) < 0) {
            return n4 < -28 ? n4 + 31 + 28 + 1 : n4 + 28 + 1;
        }
        if (NativeDate.IsLeapYear(n3)) {
            if (n4 == 0) {
                return 29;
            }
            --n4;
        }
        switch (n4 / 30) {
            case 0: {
                return n4 + 1;
            }
            case 1: {
                n2 = 31;
                n = 31;
                break;
            }
            case 2: {
                n2 = 30;
                n = 61;
                break;
            }
            case 3: {
                n2 = 31;
                n = 92;
                break;
            }
            case 4: {
                n2 = 30;
                n = 122;
                break;
            }
            case 5: {
                n2 = 31;
                n = 153;
                break;
            }
            case 6: {
                n2 = 31;
                n = 184;
                break;
            }
            case 7: {
                n2 = 30;
                n = 214;
                break;
            }
            case 8: {
                n2 = 31;
                n = 245;
                break;
            }
            case 9: {
                n2 = 30;
                n = 275;
                break;
            }
            case 10: {
                return n4 - 275 + 1;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        if ((n4 -= n) < 0) {
            n4 += n2;
        }
        return n4 + 1;
    }

    private static int WeekDay(double d) {
        double d2 = NativeDate.Day(d) + 4.0;
        if ((d2 %= 7.0) < 0.0) {
            d2 += 7.0;
        }
        return (int)d2;
    }

    private static double now() {
        return System.currentTimeMillis();
    }

    private static double DaylightSavingTA(double d) {
        Date date;
        if (d < 0.0 || d > 2.1459168E12) {
            int n = NativeDate.EquivalentYear(NativeDate.YearFromTime(d));
            double d2 = NativeDate.MakeDay(n, NativeDate.MonthFromTime(d), NativeDate.DateFromTime(d));
            d = NativeDate.MakeDate(d2, NativeDate.TimeWithinDay(d));
        }
        if (thisTimeZone.inDaylightTime(date = new Date((long)d))) {
            return 3600000.0;
        }
        return 0.0;
    }

    private static int EquivalentYear(int n) {
        int n2 = (int)NativeDate.DayFromYear(n) + 4;
        if ((n2 %= 7) < 0) {
            n2 += 7;
        }
        if (NativeDate.IsLeapYear(n)) {
            switch (n2) {
                case 0: {
                    return 1984;
                }
                case 1: {
                    return 1996;
                }
                case 2: {
                    return 1980;
                }
                case 3: {
                    return 1992;
                }
                case 4: {
                    return 1976;
                }
                case 5: {
                    return 1988;
                }
                case 6: {
                    return 1972;
                }
            }
        } else {
            switch (n2) {
                case 0: {
                    return 1978;
                }
                case 1: {
                    return 1973;
                }
                case 2: {
                    return 1974;
                }
                case 3: {
                    return 1975;
                }
                case 4: {
                    return 1981;
                }
                case 5: {
                    return 1971;
                }
                case 6: {
                    return 1977;
                }
            }
        }
        throw Kit.codeBug();
    }

    private static double LocalTime(double d) {
        return d + LocalTZA + NativeDate.DaylightSavingTA(d);
    }

    private static double internalUTC(double d) {
        return d - LocalTZA - NativeDate.DaylightSavingTA(d - LocalTZA);
    }

    private static int HourFromTime(double d) {
        double d2 = Math.floor(d / 3600000.0) % 24.0;
        if (d2 < 0.0) {
            d2 += 24.0;
        }
        return (int)d2;
    }

    private static int MinFromTime(double d) {
        double d2 = Math.floor(d / 60000.0) % 60.0;
        if (d2 < 0.0) {
            d2 += 60.0;
        }
        return (int)d2;
    }

    private static int SecFromTime(double d) {
        double d2 = Math.floor(d / 1000.0) % 60.0;
        if (d2 < 0.0) {
            d2 += 60.0;
        }
        return (int)d2;
    }

    private static int msFromTime(double d) {
        double d2 = d % 1000.0;
        if (d2 < 0.0) {
            d2 += 1000.0;
        }
        return (int)d2;
    }

    private static double MakeTime(double d, double d2, double d3, double d4) {
        return ((d * 60.0 + d2) * 60.0 + d3) * 1000.0 + d4;
    }

    private static double MakeDay(double d, double d2, double d3) {
        d += Math.floor(d2 / 12.0);
        if ((d2 %= 12.0) < 0.0) {
            d2 += 12.0;
        }
        double d4 = Math.floor(NativeDate.TimeFromYear(d) / 8.64E7);
        double d5 = NativeDate.DayFromMonth((int)d2, (int)d);
        return d4 + d5 + d3 - 1.0;
    }

    private static double MakeDate(double d, double d2) {
        return d * 8.64E7 + d2;
    }

    private static double TimeClip(double d) {
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Math.abs(d) > 8.64E15) {
            return ScriptRuntime.NaN;
        }
        if (d > 0.0) {
            return Math.floor(d + 0.0);
        }
        return Math.ceil(d + 0.0);
    }

    private static double date_msecFromDate(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = NativeDate.MakeDay(d, d2, d3);
        double d9 = NativeDate.MakeTime(d4, d5, d6, d7);
        double d10 = NativeDate.MakeDate(d8, d9);
        return d10;
    }

    private static double date_msecFromArgs(Object[] objectArray) {
        double[] dArray = new double[7];
        int n = 0;
        while (n < 7) {
            if (n < objectArray.length) {
                double d = ScriptRuntime.toNumber(objectArray[n]);
                if (d != d || Double.isInfinite(d)) {
                    return ScriptRuntime.NaN;
                }
                dArray[n] = ScriptRuntime.toInteger(objectArray[n]);
            } else {
                dArray[n] = n == 2 ? 1.0 : 0.0;
            }
            ++n;
        }
        if (dArray[0] >= 0.0 && dArray[0] <= 99.0) {
            dArray[0] = dArray[0] + 1900.0;
        }
        return NativeDate.date_msecFromDate(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]);
    }

    private static double jsStaticFunction_UTC(Object[] objectArray) {
        return NativeDate.TimeClip(NativeDate.date_msecFromArgs(objectArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double date_parseString(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        char c = '\u0000';
        char c2 = '\u0000';
        int n7 = 0;
        int n8 = -1;
        double d = -1.0;
        char c3 = '\u0000';
        int n9 = 0;
        boolean bl = false;
        n9 = string.length();
        block13: while (n7 < n9) {
            int n10;
            int n11;
            c = string.charAt(n7);
            ++n7;
            if (c <= ' ' || c == ',' || c == '-') {
                if (n7 >= n9) continue;
                c2 = string.charAt(n7);
                if (c != '-' || '0' > c2 || c2 > '9') continue;
                c3 = c;
                continue;
            }
            if (c == '(') {
                n11 = 1;
                while (n7 < n9) {
                    c = string.charAt(n7);
                    ++n7;
                    if (c == '(') {
                        ++n11;
                        continue;
                    }
                    if (c == ')' && --n11 <= 0) continue block13;
                }
                continue;
            }
            if ('0' <= c && c <= '9') {
                n8 = c - 48;
                while (n7 < n9 && '0' <= (c = string.charAt(n7)) && c <= '9') {
                    n8 = n8 * 10 + c - 48;
                    ++n7;
                }
                if (c3 == '+' || c3 == '-') {
                    bl = true;
                    n8 = n8 < 24 ? (n8 *= 60) : n8 % 100 + n8 / 100 * 60;
                    if (c3 == '+') {
                        n8 = -n8;
                    }
                    if (d != 0.0 && d != -1.0) {
                        return ScriptRuntime.NaN;
                    }
                    d = n8;
                } else if (n8 >= 70 || c3 == '/' && n2 >= 0 && n3 >= 0 && n < 0) {
                    if (n >= 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (c > ' ' && c != ',' && c != '/' && n7 < n9) return ScriptRuntime.NaN;
                    n = n8 < 100 ? n8 + 1900 : n8;
                } else if (c == ':') {
                    if (n4 < 0) {
                        n4 = n8;
                    } else {
                        if (n5 >= 0) return ScriptRuntime.NaN;
                        n5 = n8;
                    }
                } else if (c == '/') {
                    if (n2 < 0) {
                        n2 = n8 - 1;
                    } else {
                        if (n3 >= 0) return ScriptRuntime.NaN;
                        n3 = n8;
                    }
                } else {
                    if (n7 < n9 && c != ',' && c > ' ' && c != '-') {
                        return ScriptRuntime.NaN;
                    }
                    if (bl && n8 < 60) {
                        d = d < 0.0 ? (d -= (double)n8) : (d += (double)n8);
                    } else if (n4 >= 0 && n5 < 0) {
                        n5 = n8;
                    } else if (n5 >= 0 && n6 < 0) {
                        n6 = n8;
                    } else {
                        if (n3 >= 0) return ScriptRuntime.NaN;
                        n3 = n8;
                    }
                }
                c3 = '\u0000';
                continue;
            }
            if (c == '/' || c == ':' || c == '+' || c == '-') {
                c3 = c;
                continue;
            }
            n11 = n7 - 1;
            while (n7 < n9) {
                c = string.charAt(n7);
                if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z')) break;
                ++n7;
            }
            if ((n10 = n7 - n11) < 2) {
                return ScriptRuntime.NaN;
            }
            String string2 = "am;pm;monday;tuesday;wednesday;thursday;friday;saturday;sunday;january;february;march;april;may;june;july;august;september;october;november;december;gmt;ut;utc;est;edt;cst;cdt;mst;mdt;pst;pdt;";
            int n12 = 0;
            int n13 = 0;
            while (true) {
                int n14;
                if ((n14 = string2.indexOf(59, n13)) < 0) {
                    return ScriptRuntime.NaN;
                }
                if (string2.regionMatches(true, n13, string, n11, n10)) break;
                n13 = n14 + 1;
                ++n12;
            }
            if (n12 < 2) {
                if (n4 > 12 || n4 < 0) {
                    return ScriptRuntime.NaN;
                }
                if (n12 == 0) {
                    if (n4 != 12) continue;
                    n4 = 0;
                    continue;
                }
                if (n4 == 12) continue;
                n4 += 12;
                continue;
            }
            if ((n12 -= 2) < 7) continue;
            if ((n12 -= 7) < 12) {
                if (n2 >= 0) return ScriptRuntime.NaN;
                n2 = n12;
                continue;
            }
            switch (n12 -= 12) {
                case 0: {
                    d = 0.0;
                    break;
                }
                case 1: {
                    d = 0.0;
                    break;
                }
                case 2: {
                    d = 0.0;
                    break;
                }
                case 3: {
                    d = 300.0;
                    break;
                }
                case 4: {
                    d = 240.0;
                    break;
                }
                case 5: {
                    d = 360.0;
                    break;
                }
                case 6: {
                    d = 300.0;
                    break;
                }
                case 7: {
                    d = 420.0;
                    break;
                }
                case 8: {
                    d = 360.0;
                    break;
                }
                case 9: {
                    d = 480.0;
                    break;
                }
                case 10: {
                    d = 420.0;
                    break;
                }
                default: {
                    Kit.codeBug();
                }
            }
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            return ScriptRuntime.NaN;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        double d2 = NativeDate.date_msecFromDate(n, n2, n3, n4, n5, n6, 0.0);
        if (d != -1.0) return d2 + d * 60000.0;
        return NativeDate.internalUTC(d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String date_format(double d, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(60);
        double d2 = NativeDate.LocalTime(d);
        if (n != 3) {
            NativeDate.appendWeekDayName(stringBuffer, NativeDate.WeekDay(d2));
            stringBuffer.append(' ');
            NativeDate.appendMonthName(stringBuffer, NativeDate.MonthFromTime(d2));
            stringBuffer.append(' ');
            NativeDate.append0PaddedUint(stringBuffer, NativeDate.DateFromTime(d2), 2);
            stringBuffer.append(' ');
            n2 = NativeDate.YearFromTime(d2);
            if (n2 < 0) {
                stringBuffer.append('-');
                n2 = -n2;
            }
            NativeDate.append0PaddedUint(stringBuffer, n2, 4);
            if (n != 4) {
                stringBuffer.append(' ');
            }
        }
        if (n != 4) {
            NativeDate.append0PaddedUint(stringBuffer, NativeDate.HourFromTime(d2), 2);
            stringBuffer.append(':');
            NativeDate.append0PaddedUint(stringBuffer, NativeDate.MinFromTime(d2), 2);
            stringBuffer.append(':');
            NativeDate.append0PaddedUint(stringBuffer, NativeDate.SecFromTime(d2), 2);
            n2 = (int)Math.floor((LocalTZA + NativeDate.DaylightSavingTA(d)) / 60000.0);
            int n3 = n2 / 60 * 100 + n2 % 60;
            if (n3 > 0) {
                stringBuffer.append(" GMT+");
            } else {
                stringBuffer.append(" GMT-");
                n3 = -n3;
            }
            NativeDate.append0PaddedUint(stringBuffer, n3, 4);
            if (timeZoneFormatter == null) {
                timeZoneFormatter = new SimpleDateFormat("zzz");
            }
            if (d < 0.0 || d > 2.1459168E12) {
                int n4 = NativeDate.EquivalentYear(NativeDate.YearFromTime(d2));
                double d3 = NativeDate.MakeDay(n4, NativeDate.MonthFromTime(d), NativeDate.DateFromTime(d));
                d = NativeDate.MakeDate(d3, NativeDate.TimeWithinDay(d));
            }
            stringBuffer.append(" (");
            Date date = new Date((long)d);
            DateFormat dateFormat = timeZoneFormatter;
            synchronized (dateFormat) {
                stringBuffer.append(timeZoneFormatter.format(date));
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static Object jsConstructor(Object[] objectArray) {
        NativeDate nativeDate = new NativeDate();
        if (objectArray.length == 0) {
            nativeDate.date = NativeDate.now();
            return nativeDate;
        }
        if (objectArray.length == 1) {
            Object object = objectArray[0];
            if (object instanceof Scriptable) {
                object = ((Scriptable)object).getDefaultValue(null);
            }
            double d = object instanceof String ? NativeDate.date_parseString((String)object) : ScriptRuntime.toNumber(object);
            nativeDate.date = NativeDate.TimeClip(d);
            return nativeDate;
        }
        double d = NativeDate.date_msecFromArgs(objectArray);
        if (!Double.isNaN(d) && !Double.isInfinite(d)) {
            d = NativeDate.TimeClip(NativeDate.internalUTC(d));
        }
        nativeDate.date = d;
        return nativeDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toLocale_helper(double d, int n) {
        DateFormat dateFormat;
        switch (n) {
            case 5: {
                if (localeDateTimeFormatter == null) {
                    localeDateTimeFormatter = DateFormat.getDateTimeInstance(1, 1);
                }
                dateFormat = localeDateTimeFormatter;
                break;
            }
            case 6: {
                if (localeTimeFormatter == null) {
                    localeTimeFormatter = DateFormat.getTimeInstance(1);
                }
                dateFormat = localeTimeFormatter;
                break;
            }
            case 7: {
                if (localeDateFormatter == null) {
                    localeDateFormatter = DateFormat.getDateInstance(1);
                }
                dateFormat = localeDateFormatter;
                break;
            }
            default: {
                dateFormat = null;
            }
        }
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            return dateFormat.format(new Date((long)d));
        }
    }

    private static String js_toUTCString(double d) {
        StringBuffer stringBuffer = new StringBuffer(60);
        NativeDate.appendWeekDayName(stringBuffer, NativeDate.WeekDay(d));
        stringBuffer.append(", ");
        NativeDate.append0PaddedUint(stringBuffer, NativeDate.DateFromTime(d), 2);
        stringBuffer.append(' ');
        NativeDate.appendMonthName(stringBuffer, NativeDate.MonthFromTime(d));
        stringBuffer.append(' ');
        int n = NativeDate.YearFromTime(d);
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        }
        NativeDate.append0PaddedUint(stringBuffer, n, 4);
        stringBuffer.append(' ');
        NativeDate.append0PaddedUint(stringBuffer, NativeDate.HourFromTime(d), 2);
        stringBuffer.append(':');
        NativeDate.append0PaddedUint(stringBuffer, NativeDate.MinFromTime(d), 2);
        stringBuffer.append(':');
        NativeDate.append0PaddedUint(stringBuffer, NativeDate.SecFromTime(d), 2);
        stringBuffer.append(" GMT");
        return stringBuffer.toString();
    }

    private static void append0PaddedUint(StringBuffer stringBuffer, int n, int n2) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n3 = 1;
        --n2;
        if (n >= 10) {
            if (n < 1000000000) {
                int n4;
                while (n >= (n4 = n3 * 10)) {
                    --n2;
                    n3 = n4;
                }
            } else {
                n2 -= 9;
                n3 = 1000000000;
            }
        }
        while (n2 > 0) {
            stringBuffer.append('0');
            --n2;
        }
        while (n3 != 1) {
            stringBuffer.append((char)(48 + n / n3));
            n %= n3;
            n3 /= 10;
        }
        stringBuffer.append((char)(48 + n));
    }

    private static void appendMonthName(StringBuffer stringBuffer, int n) {
        String string = "JanFebMarAprMayJunJulAugSepOctNovDec";
        n *= 3;
        int n2 = 0;
        while (n2 != 3) {
            stringBuffer.append(string.charAt(n + n2));
            ++n2;
        }
    }

    private static void appendWeekDayName(StringBuffer stringBuffer, int n) {
        String string = "SunMonTueWedThuFriSat";
        n *= 3;
        int n2 = 0;
        while (n2 != 3) {
            stringBuffer.append(string.charAt(n + n2));
            ++n2;
        }
    }

    private static double makeTime(double d, Object[] objectArray, int n) {
        int n2;
        boolean bl = true;
        switch (n) {
            case 32: {
                bl = false;
            }
            case 31: {
                n2 = 1;
                break;
            }
            case 34: {
                bl = false;
            }
            case 33: {
                n2 = 2;
                break;
            }
            case 36: {
                bl = false;
            }
            case 35: {
                n2 = 3;
                break;
            }
            case 38: {
                bl = false;
            }
            case 37: {
                n2 = 4;
                break;
            }
            default: {
                Kit.codeBug();
                n2 = 0;
            }
        }
        double[] dArray = new double[4];
        if (d != d) {
            return d;
        }
        if (objectArray.length == 0) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        int n3 = 0;
        while (n3 < objectArray.length && n3 < n2) {
            dArray[n3] = ScriptRuntime.toNumber(objectArray[n3]);
            if (dArray[n3] != dArray[n3] || Double.isInfinite(dArray[n3])) {
                return ScriptRuntime.NaN;
            }
            dArray[n3] = ScriptRuntime.toInteger(dArray[n3]);
            ++n3;
        }
        double d2 = bl ? NativeDate.LocalTime(d) : d;
        n3 = 0;
        int n4 = objectArray.length;
        double d3 = n2 >= 4 && n3 < n4 ? dArray[n3++] : (double)NativeDate.HourFromTime(d2);
        double d4 = n2 >= 3 && n3 < n4 ? dArray[n3++] : (double)NativeDate.MinFromTime(d2);
        double d5 = n2 >= 2 && n3 < n4 ? dArray[n3++] : (double)NativeDate.SecFromTime(d2);
        double d6 = n2 >= 1 && n3 < n4 ? dArray[n3++] : (double)NativeDate.msFromTime(d2);
        double d7 = NativeDate.MakeTime(d3, d4, d5, d6);
        double d8 = NativeDate.MakeDate(NativeDate.Day(d2), d7);
        if (bl) {
            d8 = NativeDate.internalUTC(d8);
        }
        d = NativeDate.TimeClip(d8);
        return d;
    }

    private static double makeDate(double d, Object[] objectArray, int n) {
        double d2;
        int n2;
        boolean bl = true;
        switch (n) {
            case 40: {
                bl = false;
            }
            case 39: {
                n2 = 1;
                break;
            }
            case 42: {
                bl = false;
            }
            case 41: {
                n2 = 2;
                break;
            }
            case 44: {
                bl = false;
            }
            case 43: {
                n2 = 3;
                break;
            }
            default: {
                Kit.codeBug();
                n2 = 0;
            }
        }
        double[] dArray = new double[3];
        if (objectArray.length == 0) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        int n3 = 0;
        while (n3 < objectArray.length && n3 < n2) {
            dArray[n3] = ScriptRuntime.toNumber(objectArray[n3]);
            if (dArray[n3] != dArray[n3] || Double.isInfinite(dArray[n3])) {
                return ScriptRuntime.NaN;
            }
            dArray[n3] = ScriptRuntime.toInteger(dArray[n3]);
            ++n3;
        }
        if (d != d) {
            if (objectArray.length < 3) {
                return ScriptRuntime.NaN;
            }
            d2 = 0.0;
        } else {
            d2 = bl ? NativeDate.LocalTime(d) : d;
        }
        n3 = 0;
        int n4 = objectArray.length;
        double d3 = n2 >= 3 && n3 < n4 ? dArray[n3++] : (double)NativeDate.YearFromTime(d2);
        double d4 = n2 >= 2 && n3 < n4 ? dArray[n3++] : (double)NativeDate.MonthFromTime(d2);
        double d5 = n2 >= 1 && n3 < n4 ? dArray[n3++] : (double)NativeDate.DateFromTime(d2);
        d5 = NativeDate.MakeDay(d3, d4, d5);
        double d6 = NativeDate.MakeDate(d5, NativeDate.TimeWithinDay(d2));
        if (bl) {
            d6 = NativeDate.internalUTC(d6);
        }
        d = NativeDate.TimeClip(d6);
        return d;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 6: {
                string2 = "getDay";
                n = 19;
                break;
            }
            case 7: {
                switch (string.charAt(3)) {
                    case 'D': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getDate";
                            n = 17;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setDate";
                        n = 39;
                        break block0;
                    }
                    case 'T': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getTime";
                            n = 11;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setTime";
                        n = 30;
                        break block0;
                    }
                    case 'Y': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getYear";
                            n = 12;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setYear";
                        n = 45;
                        break block0;
                    }
                    case 'u': {
                        string2 = "valueOf";
                        n = 10;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string.charAt(3)) {
                    case 'H': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getHours";
                            n = 21;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setHours";
                        n = 37;
                        break block0;
                    }
                    case 'M': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getMonth";
                            n = 15;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setMonth";
                        n = 41;
                        break block0;
                    }
                    case 'o': {
                        string2 = "toSource";
                        n = 9;
                        break block0;
                    }
                    case 't': {
                        string2 = "toString";
                        n = 2;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                string2 = "getUTCDay";
                n = 20;
                break;
            }
            case 10: {
                char c = string.charAt(3);
                if (c == 'M') {
                    c = string.charAt(0);
                    if (c == 'g') {
                        string2 = "getMinutes";
                        n = 23;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setMinutes";
                    n = 35;
                    break;
                }
                if (c == 'S') {
                    c = string.charAt(0);
                    if (c == 'g') {
                        string2 = "getSeconds";
                        n = 25;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setSeconds";
                    n = 33;
                    break;
                }
                if (c != 'U') break;
                c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCDate";
                    n = 18;
                    break;
                }
                if (c != 's') break;
                string2 = "setUTCDate";
                n = 40;
                break;
            }
            case 11: {
                switch (string.charAt(3)) {
                    case 'F': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getFullYear";
                            n = 13;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setFullYear";
                        n = 43;
                        break block0;
                    }
                    case 'M': {
                        string2 = "toGMTString";
                        n = 8;
                        break block0;
                    }
                    case 'T': {
                        string2 = "toUTCString";
                        n = 8;
                        break block0;
                    }
                    case 'U': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            c = string.charAt(9);
                            if (c == 'r') {
                                string2 = "getUTCHours";
                                n = 22;
                                break block0;
                            }
                            if (c != 't') break block0;
                            string2 = "getUTCMonth";
                            n = 16;
                            break block0;
                        }
                        if (c != 's') break block0;
                        c = string.charAt(9);
                        if (c == 'r') {
                            string2 = "setUTCHours";
                            n = 38;
                            break block0;
                        }
                        if (c != 't') break block0;
                        string2 = "setUTCMonth";
                        n = 42;
                        break block0;
                    }
                    case 's': {
                        string2 = "constructor";
                        n = 1;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                char c = string.charAt(2);
                if (c == 'D') {
                    string2 = "toDateString";
                    n = 4;
                    break;
                }
                if (c != 'T') break;
                string2 = "toTimeString";
                n = 3;
                break;
            }
            case 13: {
                char c = string.charAt(0);
                if (c == 'g') {
                    c = string.charAt(6);
                    if (c == 'M') {
                        string2 = "getUTCMinutes";
                        n = 24;
                        break;
                    }
                    if (c != 'S') break;
                    string2 = "getUTCSeconds";
                    n = 26;
                    break;
                }
                if (c != 's') break;
                c = string.charAt(6);
                if (c == 'M') {
                    string2 = "setUTCMinutes";
                    n = 36;
                    break;
                }
                if (c != 'S') break;
                string2 = "setUTCSeconds";
                n = 34;
                break;
            }
            case 14: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCFullYear";
                    n = 14;
                    break;
                }
                if (c == 's') {
                    string2 = "setUTCFullYear";
                    n = 44;
                    break;
                }
                if (c != 't') break;
                string2 = "toLocaleString";
                n = 5;
                break;
            }
            case 15: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getMilliseconds";
                    n = 27;
                    break;
                }
                if (c != 's') break;
                string2 = "setMilliseconds";
                n = 31;
                break;
            }
            case 17: {
                string2 = "getTimezoneOffset";
                n = 29;
                break;
            }
            case 18: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCMilliseconds";
                    n = 28;
                    break;
                }
                if (c == 's') {
                    string2 = "setUTCMilliseconds";
                    n = 32;
                    break;
                }
                if (c != 't') break;
                c = string.charAt(8);
                if (c == 'D') {
                    string2 = "toLocaleDateString";
                    n = 7;
                    break;
                }
                if (c != 'T') break;
                string2 = "toLocaleTimeString";
                n = 6;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

