# The LearningOnline Network
# Cookie Based Access Handler for Authoring Spaces
# (lonacc: 5/21/99,5/22,5/29,5/31 Gerd Kortemeyer)
#
# $Id: loncacc.pm,v 1.61 2013/06/04 23:12:13 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

=pod

=head1 NAME

Apache::lonacc - Cookie Based Access Handler for Authoring Spaces 

=head1 SYNOPSIS

Invoked (for various locations) by /etc/httpd/conf/loncapa_apache.conf:

 PerlAccessHandler       Apache::loncacc

=head1 INTRODUCTION

This module enables cookie based authentication for construction area
and is used to control access for the following two types of URI 
(one for files, and one for directories):

 <LocationMatch "^/priv.*">
 <LocationMatch "^/priv.*/$">

Whenever the client sends the cookie back to the server, 
if the cookie is missing or invalid, the user is re-challenged
for login information.

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 HANDLER SUBROUTINE

This routine is called by Apache and mod_perl.

=over 4

=item *

load POST parameters

=item *

store where they wanted to go (first url entered)

=back

=cut


package Apache::loncacc;

use strict;
use Apache::Constants qw(:common :http :methods REDIRECT);
use Fcntl qw(:flock);
use Apache::lonlocal;
use Apache::lonnet;
use Apache::lonacc;
use LONCAPA qw(:DEFAULT :match);

sub handler {
    my $r = shift;
    my $requrl=$r->uri;
    $env{'request.editurl'}=$requrl;

    my $handle =  &Apache::lonnet::check_for_valid_session($r);
    if ($handle ne '') {

# ------------------------------------------------------ Initialize Environment
        my $lonidsdir=$r->dir_config('lonIDsDir');
	&Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);

# --------------------------------------------------------- Initialize Language
 
	&Apache::lonlocal::get_language_handle($r);

# -------------------------------------------------------------- Resource State

	$env{'request.state'}    = "construct";
	$env{'request.filename'} = $r->filename;

	my $allowed;
	my ($ownername,$ownerdom,$ownerhome) = 
            &Apache::lonnet::constructaccess($requrl,'setpriv');
        if (($ownername ne '') && ($ownerdom ne '') && ($ownerhome ne '')) {
            unless ($ownerhome eq 'no_host') {
                my @hosts = &Apache::lonnet::current_machine_ids();
                if (grep(/^\Q$ownerhome\E$/,@hosts)) {
                    $allowed = 1;
                }
            }
        }

        unless ($allowed) {
	    $r->log_reason("Unauthorized $requrl", $r->filename); 
	    return HTTP_NOT_ACCEPTABLE;
	}

# -------------------------------------------------------- Load POST parameters

	&Apache::lonacc::get_posted_cgi($r);

	return OK; 
    } else {
	$r->log_reason("Cookie $handle not valid", $r->filename) 
    }

# ----------------------------------------------- Store where they wanted to go

    $env{'request.firsturl'}=$requrl;
    return FORBIDDEN;
}

1;
__END__

