#!/usr/bin/perl
# ping cgi-script
# $Id: ping.pl,v 1.9 2011/10/17 17:23:25 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;
$|=1;

use lib '/home/httpd/lib/perl/';
use Apache::lonnet;
use LONCAPA::loncgi;
use LONCAPA::lonauthcgi;

print("Content-type: text/plain\n\n");

&main();

sub main {
    my $remote_ip = $ENV{'REMOTE_ADDR'};
    my $allowed;
    my @hosts = &Apache::lonnet::get_hosts_from_ip($remote_ip);
    if (@hosts > 0) {
        $allowed = 1;
    } elsif (&LONCAPA::lonauthcgi::check_ipbased_access('ping',$remote_ip)) {
        $allowed = 1;
    } elsif (&LONCAPA::loncgi::check_cookie_and_load_env()) {
        if (&LONCAPA::lonauthcgi::can_view('ping')) {
            $allowed = 1;
        }
    }
    if ($allowed) {
        my $testhost=$ENV{'QUERY_STRING'};
        $testhost=~s/\W//g;
        if (&Apache::lonnet::hostname($testhost) ne '') {
            print &Apache::lonnet::reply('ping',$testhost)."\n";
        } else {
            print 'unknown_host';
        }
    } else {
        print 'forbidden';
    }
    return;
}
