#!/usr/bin/perl
# CGI-script to allow download of all essay submissions of 
# multiple students.
#
# $Id: multidownload.pl,v 1.43 2020/09/02 14:52:08 raeburn Exp $
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use lib '/home/httpd/lib/perl';
use LONCAPA::loncgi;
use File::Path;
use File::Basename;
use File::Copy;
use Archive::Zip qw( :ERROR_CODES );
use Apache::lonhtmlcommon();
use Apache::lonnavmaps();
use Apache::loncommon();
use Apache::lonlocal;
use Apache::lonmsg();
use Apache::lonnet;
use LONCAPA::Enrollment;
use LONCAPA;
use strict;

sub is_flat {
    my ($partlist, $res) = @_;
    my $flat_part = 1;
    my $flat_resp = 1;
    if (scalar(@$partlist) > 1) {
        $flat_part = 0;
    }
    foreach my $partid (@$partlist) {
        my @ids = $res->responseIds($partid);
        if (scalar(@ids) > 1 ) {
            $flat_resp = 0;
        }
    }
    return ($flat_part, $flat_resp);
}


sub get_part_resp_path {
    my ($flat_part, $flat_resp, $part_id, $resp_id) = @_;
    my $part_resp_path = "";
    if (!$flat_part) {
        $part_resp_path = "part$part_id/";
    } 
    if (!$flat_resp) {
        $part_resp_path .= "resp$resp_id/";
    }
    $part_resp_path =~ s/\/^//; 
    return('/'.$part_resp_path);
}


$|=1;
&Apache::lonlocal::get_language_handle();
&Apache::loncommon::content_type(undef,'text/html');
my ($nocookie,$identifier,$unique_path,$scope,$unique_user);
if (! &LONCAPA::loncgi::check_cookie_and_load_env()) {
    print(&LONCAPA::loncgi::missing_cookie_msg());
    $nocookie = 1;
}

unless ($nocookie) {
    $scope = $env{'request.course.id'};
    if ($env{'request.course.sec'}) {
        $scope .= '/'.$env{'request.course.sec'};
    }
    if ($ENV{'QUERY_STRING'} =~ /^\d+_\d+_\d+$/) {
        $identifier = $ENV{'QUERY_STRING'};
        $unique_path = $identifier.time();
    }
    if (($env{'user.name'} =~ /^$LONCAPA::match_username$/) &&
        ($env{'user.domain'} =~ /^$LONCAPA::match_domain$/)) {
        $unique_user = $env{'user.name'}.':'.$env{'user.domain'};
    }
    print(&Apache::loncommon::start_page('Multiple Downloads'));
}
if ($scope eq '') {
    print(&mt('Invalid course context: you need to reselect your course role.'));
} elsif ($identifier eq '') {
    unless ($nocookie) {
        if (&Apache::lonnet::allowed('vgr',$scope) eq 'F') {
            print(&mt('Invalid query string; unable to download submissions.'));
        } else {
            print(&mt('You are not authorized to download student submissions.'));
        }
    }
} elsif ($unique_user eq '') {
    unless ($nocookie) {
        if (&Apache::lonnet::allowed('vgr',$scope) eq 'F') {
            print(&mt('Characters in your username and/or domain prevent download of submissions.'));
        } else {
            print(&mt('You are not authorized to download student submissions.'));
        }
    }
} elsif (&Apache::lonnet::allowed('vgr',$scope) eq 'F') {
    my $symb = $env{'cgi.'.$identifier.'.symb'};
    my $navmap = Apache::lonnavmaps::navmap->new();
    my $res = $navmap->getBySymb($symb);
    my $partlist = $res->parts();
    my ($flat_part, $flat_resp) = &is_flat($partlist, $res);
    my ($zipout) = ($symb =~ /^.*\/(.+)\.problem$/);
    $zipout =~ s/\s/_/g;
    $zipout =~ s/[^\w.\-]+//g;
    $zipout .= "$identifier.zip";
    my $courseid = $env{'request.course.id'};
    my @stuchecked = split(/\n/,$env{'cgi.'.$identifier.'.students'});
    my $number_of_students = scalar(@stuchecked);
    my %prog_state=&Apache::lonhtmlcommon::Create_PrgWin('',$number_of_students);
    my @parts = split(/\n/,$env{'cgi.'.$identifier.'.parts'});
    my @getparts;
    if (ref($partlist) eq 'ARRAY') {
        if (@parts) {
            foreach my $posspart (@{$partlist}) {
                if (grep(/^\Q$posspart\E$/,@parts)) {
                    unless (grep(/^\Q$posspart\E$/,@getparts)) {
                        push(@getparts,$posspart);
                    }
                }
            }
        } else {
            @getparts = @{$partlist};
        }
    }
    if (!@getparts) {
        print(&mt('No problem parts specified for retrieval of submissions.'));
    } elsif (!$number_of_students) {
        print(&mt('No students selected for retrieval of submissions.'));
    } else {
        my $doc_zip_root = $Apache::lonnet::perlvar{'lonZipDir'};
        my $manifest;
        unless (-d "$doc_zip_root/zipdir/$unique_user/$unique_path") {
            &File::Path::mkpath($doc_zip_root."/zipdir/$unique_user/$unique_path",0,0700);
        }
        if (open(MANIFEST,'>',"$doc_zip_root/zipdir/$unique_user/$unique_path/manifest.txt")) {
            $manifest = 1;
            print MANIFEST (&mt("Zip file generated on [_1]",&Apache::lonlocal::locallocaltime(time()))."\n");
            print MANIFEST (&mt("Course: [_1]",$env{"course.$courseid.description"})."\n");
            print MANIFEST (&mt("Problem: [_1]",$res->compTitle)."\n");
            print MANIFEST (&mt("Files contained in this zip:")."\n");
        } else {
            &Apache::lonnet::logthis("Problem making manifest");
        }
        my $file_problem = 0;
        my $current_student = 0;
        foreach my $stu (@stuchecked) {
            $current_student ++;
            &Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state,&mt("Processing student [_1] of [_2]",$current_student,$number_of_students));
            my %files_saved;
            my ($stuname,$studom,$fullname) = split(/:/,$stu);
            my %record = &Apache::lonnet::restore($symb,$courseid,$studom,$stuname);
            my $port_url = '/uploaded/'.$studom.'/'.$stuname.'/portfolio';
            if ($manifest) {
                print MANIFEST ($fullname."\n");
            }

            my $submission_count = 0;
            foreach my $partid (@getparts) {
                my @ids = $res->responseIds($partid);
                foreach my $respid (@ids) {
                    my $part_resp_path = &get_part_resp_path($flat_part,$flat_resp, $partid, $respid);
                    &File::Path::mkpath($doc_zip_root."/zipdir/$unique_user/$unique_path/$stuname/$part_resp_path",0,0700);
                    foreach my $origin ('portfiles','uploadedurl') {
                        my @files;
                        if ($record{"resource.$partid.$respid.$origin"} ne '') {
                            if ($origin eq 'portfiles') {
                                @files = (split(',',$record{"resource.$partid.$respid.$origin"}));
                            } else {
                                @files = ($record{"resource.$partid.$respid.$origin"});
                            }
                        }
                        foreach my $file (@files) {
                            if ($origin eq 'portfiles') { 
                                $file = $port_url.$file;
                            }
                            my ($file_name_only) = ($file =~ m{.*/([^/]+)$});
                            if ($manifest) {
                                print MANIFEST ("\t$file_name_only (".&mt("Part [_1]",$partid).
                                                ") (".&mt("Response [_1]",$respid).")"."\n");
                            }
                            $submission_count ++;
                            &Apache::lonnet::repcopy($file);
                            my $source = &Apache::lonnet::filelocation("",$file);
                            my $destination = "$doc_zip_root/zipdir/$unique_user/$unique_path/$stuname$part_resp_path/$file_name_only";
                            if (exists($files_saved{$destination})) {
                                # file has already been saved once
                                my ($file_name,$file_ext) = 
                                    ($destination =~ /(^.*)(\..+$)/);
                                $destination = $file_name.$files_saved{$destination}.$file_ext;
                                $files_saved{$destination}++;
                            }
                            $files_saved{$destination}++;
                            if (!&copy($source,$destination)) {
                                if (!$file_problem) {
                                    print('<br /><span class="LC_error">'.&mt("Unable to create: ")."</span><br />");
                                    $file_problem = 1;
                                }
                                print('<span class="LC_filename">'."$stuname/part$partid/resp$respid/$file_name_only".'</span><br />');
                            }
                        }
                    }
                }
            }
            if ((!$submission_count) && ($manifest)) {
                print MANIFEST ("\t".&mt("No Files Submitted")."\n");
            }
        }
        if ($manifest) {
            close(MANIFEST);
        }
        my $madezip;
        unless (-d "$doc_zip_root/zipout/$unique_user") {
            &File::Path::mkpath($doc_zip_root."/zipout/$unique_user",0,0700);
        }
        if ((-d "$doc_zip_root/zipout/$unique_user") &&
            (-d "$doc_zip_root/zipdir/$unique_user/$unique_path")) {
            if (!-e "$doc_zip_root/zipout/$unique_user/$zipout") {
                my $zip = Archive::Zip->new();
                $zip->addTree("$doc_zip_root/zipdir/$unique_user/$unique_path");
                if ($zip->writeToFileNamed("$doc_zip_root/zipout/$unique_user/$zipout") == AZ_OK) {
                    $madezip = 1;
                }
            } else {
                $madezip = 1;
                # should happen only if user reloads page
                &Apache::lonnet::logthis("$zipout is already there");
            }
            &File::Path::remove_tree("$doc_zip_root/zipdir/$unique_user/$unique_path",{ safe => 1, });
        }
        &Apache::lonhtmlcommon::Close_PrgWin('',\%prog_state);
        if ($madezip) {
            print('<p><a href="/zipspool/zipout/'.$unique_user.'/'.$zipout.'">'.
                  &mt("Click to download").'</a></p><br />');
        } else {
            print('<p class="LC_error">'.
                  &mt('Failed to create zip archive of student submissions').
                  '</p>');
        }
    }
} else {
    print('<p class="LC_error">'.
          &mt('You are not authorized to download student submissions.').
          '</p>');
}
unless ($nocookie) {
    print(&Apache::loncommon::end_page());
}
1;
__END__;
