/* This header defines Application Interface to the     
   CAPA system.  It needs capaParser.h and capaToken.h 
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/*    Date Oct 23 1995                                    */
/*   Isaac Tsai                                           */
/*                                                        */
/*   Get rid of old style structure definition *_t        */
/*   Make all structure definition begin with T_          */
/**********************************************************/

#ifndef   CAPA_COMMON_H
#define   CAPA_COMMON_H

#include <stdio.h>
#ifdef linux
#include <stdlib.h>
#endif
#ifdef NeXT
#include <stdlib.h>
#include <libc.h>
#else
#include <malloc.h>
#include <unistd.h>
#endif

#include <math.h>
#include <string.h>
#include <time.h>
#include <sys/fcntl.h>    /* lockf()  */
#include <sys/file.h>     /* flock()  */
#include <sys/types.h>
#include "capaParser.h"

#ifndef    MAX
#define    MAX(a,b) ((a>b)? (a):(b))
#endif

#define    MAX_SECTION_SIZE    10240    /* Max # of students in the class */
#define    MAX_SECTION_COUNT   1024
#define    MAX_NAME_CHAR       30      /* Student's name max length      */
#define    MAX_STUDENT_NUMBER   9      /* Student Number length          */
#define    MAX_EMAIL_CHAR      40      /* Email address */
#define    FILE_NAME_LENGTH    1024
#define    MAX_PIN_CHAR        4
#define    MAX_BUFFER_SIZE     2048
#define    TMP_LINE_LENGTH     2048     /* used to read in log.db set.db dates.db */
#define    SMALL_LINE_BUFFER   128     /* used to read classl, active.db */
#define    SETDB_BUF_SIZE      (256*1024)
/*  user input string length now in capaParser.h*/
/*#define    ANSWER_STRING_LENG       81*/
/*#define    UNIT_STRING_LENG         64*/
#define    FORMAT_STRING_LENG       32

/* -------- used in check_date() */
#define    CHECK_OPEN_DATE      1
#define    CHECK_DUE_DATE       2
#define    CHECK_ANS_DATE       3



/******************************************************************************/
/* STRUCTURE FOR THE HEADER OF A DATABASE FILE                                */
/******************************************************************************/

typedef struct {
  char   num_questions[FORMAT_STRING_LENG];
  char   *weight;
  char   *partial_credit;
}  T_header;

/******************************************************************************/
/* STRUCTURE FOR A NORMAL DATABASE FILE ENTRY                                 */
/******************************************************************************/

typedef struct {
 char    student_number[MAX_STUDENT_NUMBER+1]; /* Student number */
 int     e_probs;
 char   *answers; /* String of answers */
 char   *tries;
} T_entry;

/******************************************************************************/
/* STRUCTURE FOR A STUDENT IN THE STUDENT ARRAY                               */
/******************************************************************************/

typedef struct _student {
   struct _student *s_next;
   struct _student *s_prev;
   int    s_sec;
   int    s_scores;
   char   s_key[MAX_NAME_CHAR+MAX_NAME_CHAR+2]; /* sorting key */
   char   s_sn[MAX_STUDENT_NUMBER+1];
   char   s_nm[MAX_NAME_CHAR+1];
   char   s_email[MAX_EMAIL_CHAR+1];
   int    s_capaid;
}  T_student;

/******************************************************************************/
/* STRUCTURE FOR Login dates for a set                                        */
/******************************************************************************/
/*section number DATE_DEFAULTs contains the default dates an assignment is due*/ 
#define DATE_DEFAULTS 0
#define OPEN_OFFSET 0
#define DUE_OFFSET 17
#define ANSWER_OFFSET 34
#define DATE_LENGTH 16
#define DATE_BUFFER 17
#define OPTION_INHIBIT_RESPONSE 100
#define OPTION_VIEW_PROBLEMS_AFTER_DUE 101
typedef struct _date {
  struct _date *s_next;
  int    section_start;
  int    section_end;
  char   open_date[DATE_BUFFER];
  char   due_date[DATE_BUFFER];
  char   answer_date[DATE_BUFFER];
  char   duration[DATE_BUFFER];
  int    inhibit_response;
  int    view_problems_after_due;
} T_dates;

/******************************************************************************/
/* STRUCTURE FOR Login history for a student                                  */
/******************************************************************************/
typedef struct {
 int     count;  /* Number of questions */
 char   *answers; /* String of answers   */
} login_history_t;

#define	leap_year(yr) ((yr) <= 1752 ? !((yr) % 4) : !((yr) % 4) && (((yr) % 100) || !((yr) % 400)))

#define	centuries_since_1700(yr) ((yr) > 1700 ? (yr) / 100 - 17 : 0)

#define	quad_centuries_since_1700(yr)  ((yr) > 1600 ? ((yr) - 1600) / 400 : 0)

#define	leap_years_since_year_1(yr)  ((yr) / 4 - centuries_since_1700(yr) + quad_centuries_since_1700(yr))

/*=============================================================================*/
/* CAPA PROTOTYPES FOR FUNCTIONS IN COMMON.C                                   */
/*=============================================================================*/
/*-----------------------------------------------------------------------------*/
int   capa_get_section  CAPA_ARG((T_student **student_pp, int section));
int   capa_sorted_section  CAPA_ARG((T_student **student_pp, int section));
void  msort_main        CAPA_ARG((T_student **head_pp));
void  msort_split       CAPA_ARG((T_student *a_sp, T_student **b_pp));
void  msort_merge       CAPA_ARG((T_student *a_sp, T_student *b_sp, T_student **c_pp));
int   capa_get_student  CAPA_ARG((char *student_number,T_student *student_p));
int   capa_student_byname  CAPA_ARG((char *student_name,T_student *student_p));
int   capa_pick_student CAPA_ARG((int  section, T_student *student_p));
int   capa_add_student  CAPA_ARG((T_student *student_p));
int   capa_parse        CAPA_ARG((int  set,Problem_t **problem,char *student_number,int *num_questions,void (*func_ptr)()));
int   capa_parse_student CAPA_ARG((int  set,Problem_t **problem,T_student *astudent,int *num_questions,void (*func_ptr)()));
void  free_problems     CAPA_ARG((Problem_t *problem_p));
void  free_students     CAPA_ARG((T_student *student_p));
void  free_units        CAPA_ARG(());
int   read_capa_config  CAPA_ARG((char* key_word, char *value));
int   capa_access       CAPA_ARG((const char *pathname, int mode));
/*-----------------------------------------------------------------------------*/
void  capa_seed         CAPA_ARG((long *seed1, long *seed2, char *student_number));
int   capa_PIN          CAPA_ARG((char *student_number, int set, int guess));
char* capa_id_plus      CAPA_ARG((char *student_number, int set, int plus));
int   capa_set_header   CAPA_ARG((T_header *header, int set));
int   capa_get_header   CAPA_ARG((T_header *header, int set));

int   capa_set_entry    CAPA_ARG((T_entry *entry, char *student_number, int set, long offset));
int   capa_change_entry    CAPA_ARG((T_entry *entry, char *student_number, int set));
long  capa_append_entry CAPA_ARG((T_entry *entry, char *student_number, int set));
long  capa_get_entry    CAPA_ARG((T_entry *entry, char *student_number, int set));
int   capa_excuse       CAPA_ARG((int set, int prob, int section));
int   capa_get_score    CAPA_ARG((char *student_number, int set, int *valid_scores, char **answers_pp));
char* capa_get_seat     CAPA_ARG((char *studentnum, char *seatfile));
/*-----------------------------------------------------------------------------*/
int   capa_get_login_count    CAPA_ARG((char *student_number,int set));
int   capa_get_login_db       CAPA_ARG((T_entry *login_item,int *num_probs,int set));
int   capa_get_section_count  CAPA_ARG((int *cnt_arry));
int   login_check       CAPA_ARG((char *student_number));
int   logout_check      CAPA_ARG((char *student_number));
/*-----------------------------------------------------------------------------*/
int   flockstream_sh    CAPA_ARG((FILE *fp));
int   flockstream       CAPA_ARG((FILE *fp));
int   funlockstream     CAPA_ARG((FILE *fp));
/*-----------------------------------------------------------------------------*/
time_t convertTime       CAPA_ARG((char *dateStr,char *timeStr));
int    weekday           CAPA_ARG((int year, int month, int day));
int    julianday         CAPA_ARG((int year, int month, int day));
/*int    compare_datetime  CAPA_ARG((time_t time,char *datetime));*/
int    capa_check_date   CAPA_ARG((int which,char *student_number,int section,int set));
int    capa_get_date     CAPA_ARG((int which,char *student_number,int section,int set,char *date_str));
void   free_dates        CAPA_ARG((T_dates *dates));
int    capa_get_all_dates CAPA_ARG((int set, T_dates **dates));
int    capa_set_all_dates CAPA_ARG((int set, T_dates *dates));
int    capa_get_section_dates CAPA_ARG((int section,int set,T_dates** dates));
T_dates* add_date_info    CAPA_ARG((int lowsec,int highsec, char *dateinfo));
int    capa_get_login_time CAPA_ARG((char *student_number,int set,time_t *logintime));
int    capa_set_login_time CAPA_ARG((char *student_number,int set));
int    capa_get_duration  CAPA_ARG((char *student_number,int section,int set));
int    capa_check_option  CAPA_ARG((int option,int set,int section));
int    check_int          CAPA_ARG((char *an_int ));
int    check_real         CAPA_ARG((char *a_real ));
char  *answers_string     CAPA_ARG((int mode, Problem_t  *p ));
int    capa_check_ans     CAPA_ARG((AnswerInfo_t *ai, char *answer, char **error));
int    capa_check_answer  CAPA_ARG((Problem_t *p, char *answer, char **error));
int    capa_check_answers CAPA_ARG((Problem_t *p, char **answers,int cnt, char **error));
int    check_formula_ans  CAPA_ARG((char *fml_str,char *input_str,char *var_list,PointsList_t *pts_list,int tol_type,double tol));
int    check_for_unit_fail CAPA_ARG((int result));

int    is_all_ws          CAPA_ARG((char *answer));
int    split_num_unit     CAPA_ARG((char *buf, double *num, char *num_p, char *unit_p));
void   trim_response_ws   CAPA_ARG((char *answer));
void   throwaway_line     CAPA_ARG((FILE* fp));
void   protect_log_string CAPA_ARG((char* log_string));
int    calc_ansrange  CAPA_ARG((int type,int calc_type,char *input,char *fmt,int tol_type,double tol,char *lower,char *upper));
/*-----------------------------------------------------------------------------*/
int    capa_set_subjective CAPA_ARG((int set,int problem,char *student_num,char* response));
char*  capa_get_subjective CAPA_ARG((int set,int problem,char *student_num));
/*============================================================================*/

#endif  /* CAPA_COMMON_H  */

