# The LearningOnline Network with CAPA 
# makefile for capa wrapper
#
# $Id: Makefile.PL,v 1.14 2024/04/29 15:03:33 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# File : Makefile.pl
# MakeMaker file for a SWIG module.  Use this file if you are
# producing a module for general use or distribution.
#
# 1.  Modify the file as appropriate. Replace $module with the
#     real name of your module and wrapper file.
# 2.  Run perl as 'perl Makefile.pl'
# 3.  Type 'make' to build your module
# 4.  Type 'make install' to install your module.
#
# See "Programming Perl", 2nd. Ed, for more gory details than
# you ever wanted to know.
 
$capadir = "../../../CAPA";

use ExtUtils::MakeMaker;
WriteMakefile(
     'NAME' => 'capa',            # Name of your module
     'INC' => "-I$capadir/pProj",
     'LIBS' => ["-lfl"], # Custom libraries (if any)
     'DEFINE' => '-g -O1 -D_GNU_SOURCE -DPERL_POLLUTE',
     'dynamic_lib' => {
         OTHERLDFLAGS => '-Wl,--allow-multiple-definition',
      },
     'OBJECT' => 'capa_wrap.o caparesponse.o capaFunctions/*.o'    # Object files
);     
