%module capa
%{
#include "caparesponse.h"
%}

%typemap(in) char** reterror (char* cvalue) {
  SV* tempsv;
  long unsigned int len;
  if (!SvROK($input)) {
    croak("expected a reference\n");
  }
  tempsv = SvRV($input);
  if ((!SvPOK(tempsv))) {
    croak("expected a double reference\n");
  }
  cvalue = SvPV(tempsv,len);
  $1 = &cvalue;
}

%typemap(argout) char ** reterror {
  SV *tempsv;
  tempsv = SvRV($arg);
  if (($1!=NULL) && (*$1!=NULL)) {
    sv_setpv(tempsv, *$1);
    free(*$1);
  }
}

%typemap(in) double* scaled {
  double *temp;
  if (!SvROK($input)) {
    croak("expected a reference\n");
  }
  SV* tempsv;
  tempsv = SvRV($input);
  if (!SvPOK(tempsv) && !SvIOK(tempsv) && !SvNOK(tempsv)) {
    croak("expected a single reference to a scalar\n");
  }
  temp = malloc(sizeof(double));
  *temp = SvNV(tempsv);
  $1 = temp;
}

%typemap(argout) double* scaled {
  SV *tempsv;
  tempsv = SvRV($arg);
  sv_setnv(tempsv, *$1);
  free($1);
}


extern int caparesponse_capa_check_answer(char *response,char *correct,
				   int type,int tol_type,double tolerance,
				   int sig_lbound,int sig_ubound, 
				   char *ans_fmt, char *unit_str,
				   int calc, char *id_list, char *pts_list,
				   char *rndseed, char** reterror);

extern int caparesponse_get_real_response(char* unit_str, char* answer,
					  double* scaled);
