# The LearningOnline Network
# Communicate
#
# $Id: loncommunicate.pm,v 1.48 2022/01/18 17:33:13 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::loncommunicate;

use strict;
use Apache::Constants qw(:common);
use Apache::lonmsgdisplay();
use Apache::loncommon;
use Apache::lonlocal;
use Apache::lonnet;

sub menu {
    my $r=shift;
    my $crstype = 'course';
    my $usertype = 'student';
    if (defined($env{'course.'.$env{'request.course.id'}.'.type'})) {
        $crstype = $env{'course.'.$env{'request.course.id'}.'.type'};
        if ($crstype eq 'Community') {
            $usertype = 'member';
        }   
    }

    my $clientip = &Apache::lonnet::get_requestor_ip($r);
    my %setters;
    my ($startblock,$endblock,$triggerblock,$by_ip,$blockdom) =
        &Apache::loncommon::blockcheck(\%setters,'com',$clientip);
    if ($by_ip) {
        my $showdom = &Apache::lonnet::domain($blockdom);
        if ($showdom eq '') {
            $showdom = $blockdom;
        }
        $r->print('<p class="LC_warning">'.
                  &mt('Sending of LON-CAPA messages is blocked for your current IP address: [_1].',$clientip).'</p>'.
                  '<ul><li>'.&mt('Note: communication is being blocked for certain IP address(es).').
                  '</li><li>'.
                  &mt('This restriction was set by an administrator in the [_1] LON-CAPA domain.',$showdom).
                  '</li></ul><br />');
    }

# ------------------------------------------------------------------------ Menu
    my ($can_srm,$can_dcm,$can_dff);
    if ($env{'request.course.id'}) {
        if ((&Apache::lonnet::allowed('srm',$env{'request.course.id'})) ||
            (&Apache::lonnet::allowed('srm',$env{'request.course.id'}.'/'.
                                           $env{'request.course.sec'}))) {
            $can_srm = 1;
        }
        if ((&Apache::lonnet::allowed('dcm',$env{'request.course.id'})) ||
            (&Apache::lonnet::allowed('dcm',$env{'request.course.id'}.'/'.
                                           $env{'request.course.sec'}))) {
            $can_dcm = 1;
        }
        if ((&Apache::lonnet::allowed('dff',$env{'request.course.id'})) ||
            (&Apache::lonnet::allowed('dff',$env{'request.course.id'}.'/'.
                                           $env{'request.course.sec'}))) {
            $can_dff = 1;
        }
    }

    my @reports;
    unless ($by_ip) {
        @reports = (
            {categorytitle => 'Send Messages',
             items => [
            {url => '/adm/email?compose=individual',
			 permission => 'F',
			 icon => 'mail-message-new.png',
             linktext => 'New Message',
             linktitle => 'Send a message to users.'},
       
            {url => '/adm/email?compose=group',
			 permission => "$can_srm",
             icon => 'mail-reply-all.png',
             linktext => 'New Broadcast Message',
			 help => 'Course_Broadcast_Message',
             linktitle => "Send a broadcast message to members of this $crstype and/or other users."},
			 
			{url => '/adm/email?compose=upload',
			 permission => "$can_srm",
             icon => 'fromfile.png',
             linktext => 'New Messages from File',
			 linktitle => 'Create a message from file and send to users.'},
             ]},
        );
    }
		
    if ($can_dff || $can_dcm ){
        push(@reports,{categorytitle => 'Message Administration',
             items => [
            {url => '/adm/email?recordftf=query',
			 permission => "$can_dff",
             icon => 'messalog.png',
             linktext => 'Message Log for Selected Users',
			 help => 'Course_Face_To_Face_Records,Course_Critical_Message',
             linktitle => "User notes, records of face-to-face discussions, critical messages, broadcast messages and archived messages in $crstype."},
                    
            {url => '/adm/setblock?caller=email',
			 permission => "$can_dcm",
             icon => 'comblock.png',
			 linktext => 'Communication Blocking',
             linktitle => "Blocking of $usertype communication during exams."},
             ]});
    }
    if (@reports) {
        $r->print(&Apache::lonhtmlcommon::generate_menu(@reports));
    }
    return;
}

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
#
# Start document
#

# ----------------------------------------------------------------- Breadcrumbs
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"/adm/communicate",
          text=>"Communication/Messages",
          faq=>12,bug=>'Communication Tools',});

# ---------------------------------------------------------------------- Header
    &Apache::lonmsgdisplay::header($r);
    &menu($r);
    &Apache::lonmsgdisplay::disall($r);
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

1;
__END__
