# The LearningOnline Network with CAPA
# gerenates a lon-capa CSS response
#
# $Id: loncss.pm,v 1.9 2011/05/27 21:53:41 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
package Apache::loncss;

use strict;
use Apache::lonnet;
use Apache::loncommon;
use Apache::Constants qw(:common);
use POSIX qw(strftime);
use LONCAPA;

sub handler {
    my ($r) = @_;

    my $url = $r->uri;
    $url =~ s{^/adm/css/}{};
    $url =~ s{ \.css $ }{}xms; 
	      
    my ($uname,$udom,$version,$timestamp,$function,$domain,$bgcolor) = 
	split(':',$url);

    $r->content_type('text/css');
    my $date=strftime("%a, %d %b %Y %H:%M:%S GMT",gmtime(time+86400));
    $r->header_out("Expires" => $date);
    $r->header_out("Cache-Control" =>  "public, no-transform");
    $r->send_http_header;
    
    my $handle = &Apache::lonnet::check_for_valid_session($r);
    if ($handle ne '' ) {
	&Apache::lonnet::transfer_profile_to_env($r->dir_config('lonIDsDir'),
						 $handle);
    }

    $r->print(&Apache::loncommon::standard_css($function,$domain,$bgcolor));

    return OK;
}

1;
__END__
