# The LearningOnline Network
# Evaluate
#
# $Id: lonevaluate.pm,v 1.30 2014/01/17 17:10:12 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#



package Apache::lonevaluate;

use strict;
use Apache::lonnet;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonenc();
use Apache::lonlocal;
use LONCAPA();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    &Apache::loncommon::no_cache($r);
    
    $r->send_http_header;
    return OK if $r->header_only;

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['postdata']);
    my $feedurl=$env{'form.postdata'};
    $feedurl=~s/^https?\:\/\///;
    $feedurl=~s/^$ENV{'SERVER_NAME'}//;
    $feedurl=~s/^$ENV{'HTTP_HOST'}//;

    $feedurl=&Apache::lonnet::declutter($feedurl);

    my $title=&Apache::lonnet::gettitle($feedurl);
    my $showurl=&Apache::lonenc::check_encrypt($feedurl);

    my ($rdomain,$rauth)=($feedurl=~/^($LONCAPA::domain_re)\/($LONCAPA::username_re)\//);

    my $prefix=$env{'user.name'}.'@'.$env{'user.domain'}.'___'.
	$feedurl.'___';

    my @items=('correct','helpful','depth','clear','technical','comments',
               'timestamp');

    my @retrieve=map{ $prefix.$_ } @items;

    my %currenteval=
       &Apache::lonnet::get('nohist_resevaldata',\@retrieve,$rdomain,$rauth);

    my $already=($currenteval{$prefix.'timestamp'} ne '');

    $env{'form.timestamp'}=time;

    my $warning='';

    if ($env{'form.submiteval'} eq 'true') {
# ------------------------------------------------ User is submitting something
        my $complete=1;
	foreach my $item (@items) {
	    if ($env{'form.'.$item}) {
		$currenteval{$prefix.$item}=$env{'form.'.$item};
            } elsif ($item ne 'comments') {
                $complete=0;
            }
        }
        if ($complete) {
	    my $showurl=&Apache::lonenc::check_encrypt(&Apache::lonnet::clutter($feedurl));
            my $js = &Apache::lonhtmlcommon::scripttag(<<ENDJS);
    function goback() {
        if ((window.name=='loncapaclient')) {
            window.location='$showurl';
        } else {
            self.close();
        }
    }
ENDJS

            # Breadcrumbs
            my $brcrum = [{'href' => '/adm/evaluate',
                           'text' => 'Evaluate Resource'},
                          {'href' => '',
                           'text' => 'Done'}];

            my $start_page = &Apache::loncommon::start_page('Evaluate Resource',
                                                            $js,
                                                            {'bread_crumbs' => $brcrum,});

            $r->print($start_page
                     .'<p class="LC_success">'
                     .&mt('Saving feedback: [_1]'
                          ,&Apache::lonnet::put(
                               'nohist_resevaldata',\%currenteval,$rdomain,$rauth))
                     .'</p>'
            );
           unless ($already) {
               $r->print('<p>'.&mt('Logging first evaluation').'</p>');
           }
           $r->print('<p><b>'.&mt('Thank you for your input!').'</b></p>'
                    .&Apache::lonhtmlcommon::scripttag(
                        'setTimeout("goback()",2000);')
                    .&Apache::loncommon::end_page()
           );
           return OK;
        } else {
            $warning=&mt('Please fill out all required fields below!');
        }
   
    }

# ---------------------------------------------------------- Dial in old values
    my $dialold='';
    my $oldcomments='';

    foreach my $item (@items) {
       unless ($item eq 'comments') {
           unless (($item eq 'timestamp') || 
                   (!defined($currenteval{$prefix.$item}))) {
              $dialold.=
                   'document.evaluation.'.$item.'.selectedIndex='.
                   $currenteval{$prefix.$item}.";\n";
	   }
       } else {
           $oldcomments=$currenteval{$prefix.$item};
       }       
    }
# ------------------------------------------------------- Print out eval screen
    my %lt=&Apache::lonlocal::texthash('a' => 'Strongly Disagree',
				       'b' => 'Disagree',
				       'c' => 'Neutral',
				       'd' => 'Agree',
				       'e' => 'Strongly Agree',);
    my $standardoptions='';
    $standardoptions = (<<ENDOPTIONS);
<option value="0">-</option>
<option value="1">$lt{'a'}</option>
<option value="2">$lt{'b'}</option>
<option value="3">$lt{'c'}</option>
<option value="4">$lt{'d'}</option>
<option value="5">$lt{'e'}</option>
ENDOPTIONS

    # Breadcrumbs
    my $brcrum = [{'href' => '/adm/evaluate',
                   'text' => 'Evaluate Resource'}];

    my $start_page = &Apache::loncommon::start_page('Evaluate Resource',
                                                    undef,
                                                    {'bread_crumbs' => $brcrum,});
    my $end_page   = &Apache::loncommon::end_page();

    %lt=&Apache::lonlocal::texthash(
       'pleaserank' => 'Please rank the following criteria:',
       'required'   => '(All fields marked with * are required.)',
       'correct'    => 'The material appears to be correct',
       'helpful'    => 'The material is helpful',
       'depth'      => 'The material is covered with sufficient depth',
       'clear'      => 'The material is presented in a clear way',
       'technical'  => 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc)',
       'comments'   => 'Comments',
       'submit'     => 'Submit Evaluation',
    );
    $r->print(
        $start_page
       .'<h2>'.$title.'</h2>');

    if ($warning) {
        $r->print(
            &Apache::loncommon::confirmwrapper(
                &Apache::lonhtmlcommon::confirm_success(
            $warning,1)));
    }
    $r->print(
        '<form method="post" name="evaluation" action="/adm/evaluate">'
       .'<input type="hidden" name="submiteval" value="true" />'
       .'<input type="hidden" name="postdata" value="'.$showurl.'" />'
    );
    $r->print(
        &Apache::lonhtmlcommon::start_pick_box()
       .&Apache::lonhtmlcommon::row_headline()
       .$lt{'pleaserank'}.'<br />'
       .'<span class="LC_info">'.$lt{'required'}.'</span>'
       .&Apache::lonhtmlcommon::row_closure()
    );

    foreach my $key ('correct', 'helpful', 'depth', 'clear', 'technical') {
        $r->print(
            &Apache::lonhtmlcommon::row_title(
                '<span title="'.&mt('required').'">'.$lt{$key}
               .' <span class="LC_info">*</span></span>')
           .'<select name="'.$key.'">'
           .$standardoptions
           .'</select>'
           .&Apache::lonhtmlcommon::row_closure()
        );
    }

    $r->print(
        &Apache::lonhtmlcommon::row_title($lt{'comments'})
       .'<textarea name="comments" cols="40" rows="5">'
       .$oldcomments
       .'</textarea>'
       .&Apache::lonhtmlcommon::row_closure(1)
       .&Apache::lonhtmlcommon::end_pick_box()
       .'<p>'
       .'<input type="submit" value="'.$lt{'submit'}.'" />'
       .'</p>'
    );

    $r->print(
        &Apache::lonhtmlcommon::scripttag($dialold)
       .'</form>'
       .$end_page
    );

    return OK;
} 

1;
__END__

=pod

=head1 NAME

Apache::lonevaluate.pm

=head1 SYNOPSIS

Handles evaluation.

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 OVERVIEW

None

=cut
