# The LearningOnline Network with CAPA
# Turkish Localization Lexicon
#
# $Id: tr.pm,v 1.29.2.1 2014/05/06 12:31:43 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::tr;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,

'char_encoding'=> 'UTF-8',
'language_code'=> 'tr',
'date_locale'  =>
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds',
'date_months'  => 'Ocak,Þubat,Mart,Nisan,Mayýs,Haziran,Temmuz,Aðustos,Eylül,Ekim,Kasým,Aralýk',
'date_days'    => 'Pazar,Pazartesi,Salý,Çarþamba,Perþembe,Cuma,Cumartesi',
'date_am' => 'Öðleden Önce',
'date_pm' => 'Öðleden Sonra',

   'Deutsch - UTF' # do not translate
=> 'Deutsch - UTF',

   'English - UTF' # do not translate
=> 'English - UTF',

   'Português - UTF' # do not translate
=> 'Português - UTF',

   'español (castellano) - UTF' # do not translate
=> 'español (castellano) - UTF',

   'français - UTF' # do not translate
=> 'français - UTF',

   'türkçe - UTF' # do not translate
=> 'türkçe - UTF',

   'Русский - UTF' # do not translate
=> 'Русский - UTF',

   'עברית - UTF' # do not translate
=> 'עברית - UTF',

   '日本語 - UTF' # do not translate
=> '日本語 - UTF',

   '简体中文 - UTF' # do not translate
=> '简体中文 - UTF',

   'ﺍیﺭﺎﻧی - UTF' # do not translate
=> 'ﺍیﺭﺎﻧی - UTF',

   'ﺎﻠﻋﺮﺒﻳﺓ - UTF' # do not translate
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'Swedish Chef - UTF'
=> 'Swedish Chef - UTF',

   'Domain'
=> 'Alan',

   'Server'
=> 'Sunucu',

   'Load'
=> 'Yükleme',

   'User Load'
=> 'Yüklü Kullanýcý',

   'Help'
=> 'Yardým',

   'Log in'
=> 'Oturum Aç',

   'Username'
=> 'Kullanýcý Adý',

   'Password'
=> 'Þifre',

   'choose'
=> 'Seçme',

   'enter'
=> 'Giriþ',

   'view'
=> 'Görünüm',

   'calendar'
=> 'Takvim',

   'prefer-'
=> 'tercih-',

   'ences'
=> 'renzen',

   'role'
=> 'rol',

   'course'
=> 'kurs',

   'Course'
=> 'Kurs',

   'Section/Group'
=> 'Bölüm/Grup',

   'today'
=> 'Bugün',

   'last week'
=> 'Geçen Hafta',

   'last month'
=> 'Geçen Ay',

   'last three months'
=> 'Son Üç Ay',

   'last six months'
=> 'Son Altý Ay',

   'last year'
=> 'Geçen Yýl',

   'Submit'
=> 'Gönder',

   'Rename'
=> 'Yeniden Adlandýr',

   'Save'
=> 'Kaydet', # 'Depolama',

   'Done'
=> 'Bitti',

   'Select User'
=> 'Kullanýcý Seç',

   'Select Course'
=> 'Kurs Seç',

   'Changes will become active for your current session after'
=> 'Deðiþiklikler sonraki oturumda geçerli hale getirilecek',

   're-initializing course'
=> 'Kurs yeniden baþlatýlýyor',

   ', or the next time you log in.'
=> 'ya da bir dahaki sefer giriþini yap',

   'Uploaded Document'
=> 'Güncellenmiþ doküman',

   'No content modifications yet.'
=> 'Ýçeriði henüz deðiþtiremezsin.',

   'Part is not open to be viewed. It'
=> 'Görüntülenecek Kýsým Açýlamýyor',

'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Eðer bu kaynak network problemleriyle açýlýrsa, belirlenemez.Lütfen daha sonra tekrar dene.',

'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Not: ütün kullanýcýlarýn deðiþikliklerini gerçekleþtirmeleri için 10 dakikalarý var.',

   'Language'
=> 'Dil',

   'Notes'
=> 'Not Sayýsý',

   'Abstract'
=> 'Özet',

   'Create a user or modify the roles and privileges of a user'
=> 'Bir kullanýcýnýn imtiyazlarýný ve rollerini deðiþtir ya da bir kullanýcý yarat',

   'View course assessment statistics'
=> 'Kurs deðer istatistiklerini göster',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Son mühdetini ve diðer deðer biçtiðin parametrelerini belirle,ders durumunu deðiþtir',

   'New Folder'
=> 'Yeni Klasör',

   'Simple Page'
=> 'Basit Sayfa',

   'Simple Problem'
=> 'Basit Sorun',

   'Upload Document'
=> 'Döküman Güncelleme',

   'Search'
=> 'Arama',

   'Import'
=> 'Veri Al',

   'Main Course Documents'
=> 'Baþlýca Kurs Dökümanlarý',

   'Supplemental Course Documents'
=> 'Tamamlayýcý Kurs Dökümanlarý',

   'Discussion Board'
=> 'Bülten Tahtasý',

   'Special Documents'
=> 'Özel Dökümanlar',

   'create'
=> 'Oluþtur',

   'grades'
=> 'Derece',


   'commu-'
=> 'komü-',


   'nication'
=>  'nikasyon',


   'enroll'
=> 'Üye Olmak',

   'navigate'
=> 'Yönlendirmek',

   'contents'
=> 'Ýçerik',

   'Navigate Contents'
=> 'Ýçerikte Gez',

   'Announcements and Calendar'
=> 'Duyurular ve Takvim',

   'Author'
=> 'Yazar',

   'Change Your Preferences'
=> 'Tercihlerini Deðiþtir',

   'Choose the user role'
=> 'Kullanýcý Rolü Seç',

   'Co-Author'
=> 'Yardýmcý Yazar',

   'Communication and Messages'
=> 'Ýletiþim ve Mesajlar',

   'Course Coordinator'
=> 'Kurs koordinatörü',

   'Course Statistics and Charts'
=> 'Kurs Ýstatistiði ve Grafikleri',

   'Course announcements and my calendar'
=> 'Kurs Duyurularý ve Takvimim',

   'Create Users, Change User Privileges'
=> 'Kullanýcý Oluþtur,Kullanýcý Haklarýný Deðiþtir',

   'Domain Coordinator'
=> 'Alan Koordinatörü',

   'Enrollment Manager'
=> 'Üyelik Yöneticisi',

   'Enter grades from check-out assessment resources'
=> 'Sunulan kaynaklarý incelemeden dereceleri gir',

   'Exam Proctor'
=> 'Sýnav Memuru',

   'Exit LON-CAPA'
=> 'Çýkýþ LON-CAPA',

   'Grades Spreadsheet'
=> 'Spreadsheed dereceleri',

   'Grading'
=> 'Basamak',

   'Instructor'
=> 'Öðretmen',

   'Launch Remote Control'
=> 'Uzaktan Kontrolü Baþlat',

   'Main Menu'
=> 'Ana Menü',

   'Navigate Course Contents'
=> 'Kurs Ýçeriðinde Gez',

   'No Role, Cumulative Privileges'
=> 'Rol yok, Gittikçe artan imtiyazlar',

   'Return to Last Location'
=> 'Son Konuma Dön',

   'Send and receive messages'
=> 'Mesaj al ve gönder',

   'Set my user preferences'
=> 'Kullanýcý Haklarýma Ekle',

   'Student'
=> 'Öðrenci',

   'Switch to another user role'
=> 'Diðer Kullancýya Dön',

   'Teaching Assistant'
=> 'Asistan Öðretmen',

   'Use or edit my bookmark collection'
=> 'Yer Ýþaretlerimi Düzenle Veya Kullan',

   'User Roles'
=> 'Kullanýcý Rolleri',

   'Calculate course grades (Spreadsheet)'
=> 'Kurs Derecelerini Hesaplama (Spreadsheet)',

   'Enter the chatroom for the course'
=> 'Kurs Chat Odasýna Giriþ',

   'Navigate the table of contents for this course'
=> 'Kursun Ýçerik Tablolarýný Gez',

   'Syllabus'
=> 'Müfredat Programý',

   'View the course assessment progress chart'
=> 'Kurs ilerleme grafiðini göster',

   'Class Hours'
=> 'Ders Saatleri',

   'Course Description'
=> 'Kurs Tanýmý',

   'Coursepack'
=> 'Kurs Paketi',

   'Current Month'
=> 'Geçerli Ay',

   'Deadlines'
=> 'Son Teslim Tarihi',

   'Fri'
=> 'Cuma',

   'Grading Information'
=> 'Derece Bilgisi',

   'Helproom Hours'
=> 'Yardým Saatleri',

   'Instructor Information'
=> 'Öðretmen Bilgisi',

   'Mon'
=> 'Pazartesi',

   'Next Month'
=> 'Gelecek Ay',

   'Office Hours'
=> 'Çalýþma Saatleri',

   'Prerequisites'
=> 'Ön Gereksinimler',

   'Previous Month'
=> 'Önceki Ay',

   'Readings'
=> 'Okuma',

   'Sat'
=> 'Cumartesi',

   'January'
=> 'Ocak',

   'February'
=> 'Þubat',

   'March'
=> 'Mart',

   'April'
=> 'Nisan',

   'May'
=> 'Mayýs',

   'June'
=> 'Haziran',

   'August'
=> 'Aðustos',

   'September'
=> 'Eylül',

   'October'
=> 'Ekim',

   'November'
=> 'Kasým',

   'December'
=> 'Aralýk',

   'Sun'
=> 'Pazar',

   'Textbook'
=> 'Ders Kitabý',

   'Thu'
=> 'Perþembe',

   'Tue'
=> 'Salý',

   'Web Links'
=> 'Web Baðlantýlarý',

   'Wed'
=> 'Çarþamba',

   'Drop/Add students in this course'
=> 'Öðrenci Ýptal Et/Ekle',

   'You have entered that answer before'
=> 'Bu cevabý daha önce verdiniz',

   'A score has been assigned.'
=> 'Puan Belirlendi',

   'You are correct.'
=> 'Doðru',

   'Your receipt is'
=> 'Makbuzunuz',

   'You are excused from the problem.'
=> 'Bu problemden muafsýnýz',

   'Incorrect'
=> 'Yanlýþ',

   'Some parts were not submitted.'
=> 'Bazý bölümler onaylanmadý',

   'An error occurred while grading your answer.'
=> 'Cevabýnýz derecelendirirken hata oluþtu',

   'Due'
=> 'Yeterli',

   'The submitted answer was too long.'
=> 'Verdiðiniz Cevap Çok uzun',

   'This question expects a numeric answer.'
=> 'Bu sorunun cevabý sayýsal bir deðer',

   'You have provided an invalid ranking'
=> 'Geçersiz bir sýralama gerçekleþtirdiniz',

   'please refer to'
=> 'Lütfen Baþvurun',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'Güncellediðiniz dosyanýn büyüklüðü uygun deðil.',

   'Units incorrect.'
=> 'Ölçü birimi doðru deðil',

   'Only a number required.'
=> 'Sadece Bir numara gerekli',

   'Units required'
=> 'Ölçü birimi gerekli',

   'Unable to understand formula'
=> 'Formül anlaþýlamýyor',

   'Your submission has been recorded.'
=> 'Öneriniz kayýt edildi',

   'Unknown message'
=> 'Bilinmeyen Mesaj',

   'Answer Submitted'
=> 'Cevap Onaylandý',

   'Tries'
=> 'Denemeler',


   'Submit Answer'
=> 'Cevabý onayla',

   'Prepare a printable document'
=> 'Yazýlabilir döküman hazýrla',

   'Go To My First Homework Problem'
=> 'Ýlk ödevime git',

   'Cancel'
=> 'iptal',

   'Discussions'
=> 'Tartýþmalar',

   'New discussion since'
=> 'Yeni tartýþma',

   'Goodbye'
=> 'Hoþçakal',

   'Select'
=> 'Seç',

   'Re-Initialize'
=> 'Yeniden Baþlatýlýyor',

   'Currently selected. '
=> 'Seçili',

   'Switch Server'
=> 'Açýk Sunucu',

   'system wide'
=> 'Sistem geniþliði',

   'Currently not available'
=> 'Ulaþýlamýyor',

   'No role specified'
=> 'Belirtilmemiþ role',

   'Remark'
=> 'Açýklama',

   'Extent'
=> 'Ölçü',

   'User Role'
=> 'Kullanýcý Rolü',

   'Start'
=> 'Baþla',

   'End'
=> 'Son',

   'System'
=> 'Sistem',

   'Display'
=> 'Görüntüle',

   "an unknown date"
=> 'Bilinmeyen Tarih',

   "an indeterminate date"
=> 'Belirsiz Tarih',

   'will open on [_1]'
=> 'açýlacak [_1]',


   'is due at [_1]'
=> 'uygun [_1]', # ?

   'was due on [_1], and answers will be available on [_2]'
=> 'uygundu [_1] ve cevaplara ulaþýlabilir [_2]',

   'is closed but you are allowed to view it'
=> "kapatýldý fakat incelemeye izin verildi",

   "Undid changes, Switched"
=> "Deðiþiklikler geri alýndý, Deðiþtirildi",

   "Unable to undo, unable to switch"
=> "Yok etme yapýlamaz, Deðiþim yapýlamaz",

   "Unable to make backup"
=> "Yedekleme yapýlamaz",

   "Saving Modifications to"
=> "Deðiþiklikler kaydediliyor",

   "Unable to write to"
=> "Yazýlamaz",

   "Analyzing a problem"
=> "Bir problem analizi",

   "EditXML"
=> "XML Editör",

   'Discard Edits and View'
=> 'Editörleri atmak ve incelemek',

   'Submit Changes'
=> 'Deðiþiklikleri sunmak',

   'Submit Changes and View'
=> 'Deðiþiklikleri ve incelemeyi sunmak',

   'Edit'
=> 'Düzenle',

   ', select a template from the pull-down menu below'
=> ', aþaðý açýlan pencereden bir þablon seç ',

   'undo'
=> 'Geri Al',

   'Answer'
=> 'Cevapla',

   'Frequency'
=> 'Frekans',

   'You did not select a template.'
=> 'Þablon Seçmediniz',

   'Analyze Progress'
=> 'Ýlerleme Analizi',

   'Getting Problem Variants'
=> 'Problem Seçenekleri',

   'last problem'
=> 'Son problem',

   "may open later."
=> 'Sonra Açýlabilir',

   "Select a"
=> "Seç",

   'Unable to find'
=> 'Bulunamadý',

   'Part'
=> 'Bölüm',

   "Then"
=> 'Sonra',

   'Create'
=> 'Oluþtur',

   'is in under construction'
=> 'Yapým Aþamasýnda',

   'List of possible answers'
=> 'Olasý cevaplar listesi',

'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.'
=> 'Bu problem içinde analiz edilebilir bölümler bulunamadý, sadece sayýsal akýþ, formül ve kelime karþýlýðý desteklendi.',

   'is not analyzable at this time'
=> 'Analiz Edilemiyor',

   'Title'
=> 'Baþlýk',

   'Path'
=> 'Yol',

   'New Search'
=> 'Yeni Arama',

   'Go Back'
=> 'Geri',

   'File'
=> 'Dosya',

   'Date'
=> 'Tarih',

   'You have no unread messages'
=> 'Okunmamýþ mesajýnýz yok',

   'New Messages'
=> 'Yeni Mesajlar',

   'View All Messages'
=> 'Tüm mesajlar',

   'Map'
=> 'Harita',

   'Page'
=> 'Sayfa',

   'Sequence'
=> 'Sýra',

   'Map contents are not shown in order.'
=> 'Harita içeriði gösterilemiyor',

   'Empty'
=> 'Boþalt',

   'could not be copied.'
=> 'Kopyalanamadý',

   'Back to Directory'
=> 'Dizine Geri dön',

   'No upload file specified.'
=> 'Gönderilemeyecek dosyalar belirtildi.',

   'The target is an existing directory.'
=> 'Hedef mevcut bir dizin',

   'Please use browser "Back" button and pick a filename'
=> 'Lütfen bir dosya ismi seç ve "Geri" tuþunu kullan',

   "You do not have authoring privileges for this resource"
=> "Bu kaynak için özel haklara sahip deðilsin.",

   'Copying file'
=> 'Dosya kopyalanýyor',

   'No write permission to user directory, FAIL'
=> 'Kullanýcý dizinine yazma izniniz yok, BAÞARISIZ',

   'Actions'
=> 'Ýþlemler',

   'Name'
=> 'Ýsim',

   'Status'
=> 'Konum',

   'Last Modified'
=> 'Son deðiþiklik',

   'Yes'
=> 'Evet',

   'Authoring Space Directory'
=> 'Authoring Space Directory', # 'Dizin Yapýmý',

   'Contact'
=> 'Baðlantý',

   'Save uploaded file as '
=> 'Güncellenmiþ Dosyalar',

   'Searching'
=> 'Aranýyor',

   'Select the Authoring Space'
=> 'Select the Authoring Space', # 'Alan seç',

'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Bu dosyayý açmadan önce güncel bir virüs tarayýcýsý kullanman önerilir.',

   'not displayed'
=> 'Görüntülenemiyor',

   "Open, no due date"
=> "Aç,tarih uygun deðil",

   "Uncompleted Homework"
=> "Tamamlanmamýþ Ödev",

   "Show Only Uncompleted Homework"
=> "Sadece tamamlanmamýþ ödevleri göster",

   "All homework is currently completed"
=> "Tüm ödevler tamamlandý",

   "Was due"
=> "Uygun",

   "Answer available"
=> "Uygun cevap",

   "Excused by instructor"
=> "Öðretmen muaf etti",

   "Answer submitted, not yet graded"
=> "Cevap onaylandý,Henüz derecelendirilmedi",

   "No due date"
=> "Tarih uygun deðil",

   'never'
=> 'Asla',

   'Answer submitted'
=> 'Cevap onaylandý',

   'Processing'
=> 'Ýþlem gerçekleþiyor',

   'Access and Usage Statistics'
=> 'Eriþim ve kullaným istatistiði',

   'Evaluation Comments'
=> 'Deðerlendirme Yorumlarý',

   'Evaluation Data'
=> 'Deðerlendirme Bilgisi',

   'July'
=> 'Temmuz',

   'Server Administration'
=> 'Sunucu Yönetimi',

   'System Administration'
=> 'Sistem Yönetimi',

   'Users with Roles Assigned by'
=> 'Belirlenen Rollerle Kullanýcýlar',

   'Name starting with'
=> 'Adý baþlar  ',

   'This resource has been marked obsolete by the author(s)'
=> 'Yazar tarafýndan bu kaynaðýn eskimiþliði göze çarpmýþ.',

   'Uploaded'
=> 'Güncellendi',

   'Dynamic Metadata'
=> 'Dinamik Metadata',

   'View file'
=> 'Dosya Görüntüleniyor',

   'Illegal filename.'
=> 'Dosya ismi uygun deðil',

   'Rule'
=> 'Kural',

   'Back to Source Directory'
=> 'Ana dizine dön',

   'Back to Source'
=> 'Geri',

   'File copied.'
=> 'Dosya kopyalandý',

   'FAIL'
=> 'BAÞARISIZ',

   'Back to'
=> 'Geri',

   'untitled'
=> 'Baþlýksýz',

   ', is reserved internally by LON-CAPA.'
=> ', LON-CAPA tarafýndan dahili olarak ayrýldý.',

   'Became this version on ...'
=> 'Bu versiyon uydu ...',

   'Browse published resources'
=> 'Yayýmlanmýþ kaynaklara gözat',

   'Choose the course to work on'
=> 'Kurs Seç',

   'Create a new course'
=> 'Yeni kurs oluþtur',

   'Delete messages from discussion boards'
=> 'Ýþaretli Mesajlarý Sil',

   'Domain only - use limited to courses in the domain'
=> 'Alan içindeki kurslara sadece kullaným sýnýrlandý.',

   'Edit and view documents included in this course'
=> 'Kursla ilgili dökümanlarý Düzenle ve göster',

   'Edit/Modify DOCS'
=> 'Düzenle/Deðiþtir DOCS',

   'Enter my Authoring Space'
=> 'Enter my Authoring Space', # 'Kaynaðýmý yapý alanýna gir',

   'Failed to copy source'
=> 'Kaynak kopyalanamadý',

   'Failed to write metadata copy'
=> 'Baþarýsýz Kopyalama',

   'Finalize Publication'
=> 'Yayýmlama sonu',

   'Grant/revoke role of Co-Author'
=> 'Yardýmcý yazarýn rolünü onayla/kaldýr',

   'Grant/revoke role of Domain Coordinator'
=> 'Etkin koordinatörün rolünü onayla/kaldýr',

   'Grant/revoke role of Exam Proctor'
=> 'Sýnav memurunun rolünü onayla/kaldýr',

   'Grant/revoke role of Instructor'
=> 'Öðretmenin rolünü onayla/kaldýr',

   'Grant/revoke role of Student'
=> 'Öðrencinin rolünü onayla/kaldýr',

   'Grant/revoke role of Superuser'
=> 'Süper kullanýcýnýn rolünü onayla/kaldýr',

   'No previous versions published.'
=> 'Önceki sürümler yayýmda deðil',

   'No write permission to'
=> 'Yazma iznin yok',

   'Please pick a version to retrieve'
=> 'Lütfen telafi etmek için bir versiyon seç.',

   'Private - visible to author only for testing purposes'
=> 'Özel - test amaçlý olarak sadece yazara görülebilir',

   'Private Publication - did not synchronize database'
=> 'Özel Yayým-eþ zamanlý veritabaný deðil',

   'Public - no authentication or authorization required for use'
=> 'Kamusal - kullaným için gerekli izin ya da teþvik verilemez.',

   'Retrieval of an old version will overwrite the file currently in Authoring Space.'
=> 'Retrieval of an old version will overwrite the file currently in Authoring Space.', # 'Yapý alanýndaki dosyayý eski versiyonunun üzerine yaz.',

   'Retrieve previous versions of'
=> 'Önceki versiyonu düzeltmek',

   'Retrieve version'
=> 'Versiyon düzeltmek',

   'Search the contents of this course'
=> 'Bu kursun içindekileri aramak',

   'Search the database of published resources'
=> 'Yayýnlanan kaynaklarýn veritabanýný aramak',

   'Send broadcast and receipt-required email'
=> 'Fatura isteme emaili ve yayýn gönderme',

   'Show Problem Completeness'
=> 'Tamamlanmamýþ Problem Göstermek',

   'Switch to another course'
=> 'Diðer kursa geçmek',

   'System wide - can be used for any courses system wide'
=> 'System wide - can be used for any courses system wide',

   'System wide - open source to all authors'
=> 'System wide - open source to all authors',

   'The extension on this file'
=> 'Bu dosya üzerindeki büyüme',

   'Unsupported character combination'
=> 'Desteklenmeyen karakter kombinasyonu',

   'View documents included in this course'
=> 'Bu kurs içindeki dökümanlar',

   'Additional Keywords'
=> 'Ek anahtar kelimeler',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Ek Metadata(standart olmayan, parametreler, ihracatlar)',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Yazar ve yardýmcý yazar rolleri, senin ana server ýndan baþka serverlar üzerinde uygun olmayabilir.',

   'Author(s)'
=> 'Yazar(lar)',

   'Average number of tries till solved'
=> 'Çözülene kadar olan denemelerin ortalama sayýsý',

   'Browse Resources'
=> 'Kaynak tarama',

   'Catalog Information'
=> 'Katalog Bilgisi',

   'Collapse Remote Control'
=> 'Uzaktan Kontrolü Çöktürmek',

   'Authoring Space'
=> 'Authoring Space', # 'Boþ Alan',

   'Copied metadata'
=> 'Metadata kopyalandý',

   'Copied source file'
=> 'Kaynak dosya kopyalandý',

   'Copyright/Distribution'
=> 'Telif Hakký/Daðýtým',

   'Course Documents'
=> 'Kurs Dökümanlarý',

   'Creation Date'
=> 'Tarih Yaratma',

   'Custom Distribution File'
=> 'Dosya daðýtým geleneði',

   'Degree of difficulty'
=> 'Zorluk derecesi',

   'Copy Course Content to Authoring Space'
=> 'Copy Course Content to Authoring Space', # 'Yapý alanýna kurs DOCS indirmek',

   'Entering course ...'
=> 'Kurs üyeliði ...',

   'Exam Information'
=> 'Sýnav Bilgisi',

   'External Resource'
=> 'Harici Kaynak',

   'Generate new role ...'
=> 'Yeni rol oluþturmak ...',

   'Go to the next resource in the course sequence'
=> 'Kurs düzeni içinde bir sonraki kaynaða gitmek',

   'Go to the previous resource in the course sequence'
=> 'Kurs düzeni içinde bir önceki kaynaða gitmek',

   'Import a published document'
=> 'Bir yayým dökümaný eklemek',

   'Keyword(s)'
=> 'Anahtar Kelime(ler)',

   'Load Map'
=> 'Harita Yükleme',

   'Logged Out'
=> 'Üyelik Çýkýþý',

   'MIME Type'
=> 'MIME Tipi',

   'Make notes and annotations about this resource'
=> 'Bu kaynak hakkýnda açýklamalar ve notlar yapmak',

   'Material appears to be correct'
=> 'Das Material scheint korrekt zu sein',

   'Material covered with sufficient depth'
=> 'Yeterli derinlikle materyal gözlendi',

   'Material is helpful'
=> 'Yardýmcý materyal',

   'Material presented in clear way'
=> 'Materyal açýk bir yöntemle sunuldu',

   'Metadata Information'
=> 'Metadata Bilgisi',

   'My Personal Info'
=> 'Kiþisel Bilgilerim',

   'Network-wide number of accesses (hits)'
=> 'Network boyutu eriþim numarasý("Hits")',

   'Network-wide number of courses using resource'
=> 'Network boyutu kurs kullaným kaynaklarýnýn numarasý',

   'Number of resources that follow this resource in maps'
=> 'Haritalarda bu kaynaðý izleyen kaynaklarýn sayýsý',

   'Number of resources that lead up to this resource in maps'
=> 'Haritalarda bu kaynaða rehberlik eden kaynaklarýn sayýsý',

   'Number of resources using or importing resource'
=> 'Ýndirilen ya da kullanýlan kaynaklarýn sayýsý',

   'Obsolete'
=> 'Eskimiþ',

   'Parent Directory'
=> 'Ebeveyn Dizin',

   'Please either'
=> 'Lütfen her ikisi',

   'Project Information'
=> 'Proje Bilgisi',

   'Publisher/Owner'
=> 'Yayýmcý/Sahip',

   'Publishing'
=> 'Yayýmlama',

   'Resource Publication'
=> 'Kaynak Yayýmlama',

   'Resource is technically correct'
=> 'Kaynakta teknik düzeltme',

   'Score Upload Form'
=> 'Güncellenen form sayýsý',

   'Select Map'
=> 'Harita Seç',

   'Set a bookmark for this resource'
=> 'Bu kaynak için bir ayýraç koy',

   'Show all roles'
=> 'Bütün rolleri göster',

   'Special documents'
=> 'Özel belgeler',

   'Subject'
=> 'Konu',

   'Successful Login'
=> 'Baþarýlý baðlantý',

   'Suggested Replacement for Obsolete File'
=> 'Eski dosyalar için yenisiyle deðiþtirmeyi öner',

   'Switching Role'
=> 'Deðiþken rol',

   'Target'
=> 'Hedef',

   'This syllabus can be publicly viewed at'
=> 'Bu müfredat herkesce bilinen kanýda olmalý',

   'Total number of students who have worked on this problem'
=> 'Bu problem üstünde çalýþmýþ olan öðrencilerin toplam sayýsý',

   'URLs To Include in Syllabus'
=> 'Müfredat URLs kapsar ',

   'Upload a new main course document'
=> 'Yeni bir temel kurs dökümaný gönder',

   'Upload a new supplemental course document'
=> 'Yeni bir ilave kurs dökümaný gönder',

   'User'
=> 'Kullanýcý',

   'Wrote Metadata'
=> 'Metadata yazdý',

   'Your home server is '
=> 'Ana Server ',

   'anno-'
=> 'bemerk-',

   'announce'
=> 'Ýlan etmek',

   'backward'
=> 'geri',

   'bookmark'
=> 'ayýraç',

   'chart'
=> 'Grafik',

   'chat'
=> 'Sohbet',

   'close this window'
=> 'Bu pencereyi kapat',

   'con-'
=> 'con-',

   'docs'
=> 'dökümanlar',

   'edit crs'
=> 'crs editör',

   'exit'
=> 'Çýkýþ',

   'fas'
=> 'fas',

   'forward'
=> 'göndermek',

   'library'
=> 'kütüphane',

   'log in again'
=> 'Tekrar baðlan',

   'my'
=> 'benim',

   'or'
=> 'veya',

   'parms'
=> 'parms',

   'prepare'
=> 'hazýrlamak',

   'printout'
=> 'çýktý almak',

   'resource'
=> 'kaynak',

   'roles'
=> 'roller',

   'search'
=> 'aramak',

   'set'
=> 'koymak',

   'space'
=> 'boþluk',

   'stats'
=> 'stats',

   'struct'
=> 'yapý',

   'switch'
=> 'deðiþtirmek',

   'tations'
=> 'ungen',

   'updated periodically'
=> 'periyodik güncelleme',

   'user'
=> 'kullanýcý',

   'visible to author and co-authors only'
=> 'Sadece yazar ve yardýmcýsýna görünür',

   'All versions'
=> 'Bütün versiyonlarý',

   'Could not write metadata'
=> 'Metadata yazýlamaz',

   'Default Cataloging Information for Directory'
=> 'Dizin için Katalog Bilgisi Yapmama',

   'Error Messages'
=> 'Hata Mesajlarý',

   'Save Catalog Information'
=> 'Katalog Bilgisi Depolamak',

   'Update Display'
=> 'Güncelleme Göstermek',

   'Content changed'
=> 'Deðiþtirilen içerik',

   'Differences'
=> 'Farklar',

   'Last Week'
=> 'En son hafta',

   'Modification Date'
=> 'Deðiþiklik Tarihi',

   'Since Start of Course'
=> 'Kursun baþlangýcýndan bu yana',

   'Since Yesterday'
=> 'Dünden beri',

   'Verify Course Documents'
=> 'Kurs dökümanlarýnýn doðruluðunu kanýtlamak',

   'Version'
=> 'Versiyon',

   'access denied'
=> 'giriþ reddedildi',

   'connection down'
=> 'baðlantý düþtü',

   'during the last'
=> 'devam ederken',

   'not found'
=> 'bulunamadý',

   'warning(s)'
=> 'uyarý(lar)',

   'Advanced Catalog Search'
=> 'Geliþmiþ Katalog Tarama',

   'Advanced Search'
=> 'Geliþmiþ Arama',

   'Any Language'
=> 'Dil yok',

   'Any category'
=> 'Kategori yok',

   'Any copyright/distribution'
=> 'Telif Hakký/Daðýtým yok',

   'Broadcast Message to Course'
=> 'Kursa mesaj bildirmek',

   "Click to download or use your browser's Save Link function"
=> "Download' a týkla ya da tarayýcýnýn link koruma fonksiyonunu kullan.",

   'Close'
=> 'Kapat',

   'Compact View'
=> 'Yoðun görünüm',

   'Detailed Citation View'
=> 'Detaylý alýntý görünümü',

   'Distribute Messages from Uploaded File to Course'
=> 'Kursa gönderilen dosyadan daðýtým mesajlarý',

   'Edit Catalog Information'
=> 'Katalog bilgisini düzenlemek',

   'Edit Content of a Map'
=> 'Bir haritanýn içeriðini düzenlemek',

   'Edit Directory Catalog Information'
=> 'Dizin katalog bilgisini düzenlemek',

   'Evaluate Resource'
=> 'Kaynaðý deðerlendirmek',

   'Failed Access to Authoring Space'
=> 'Failed Access to Authoring Space', # 'Yapý alanýna giriþ baþarýsýz',

   'Fielded Format'
=> 'Alaný formatlamak',

   'File Category'
=> 'Dosya kategorisi',

   'Force publication of unmodified files'
=> 'Deðiþtirilemeyen dosyalarýn yayýnlanma gücü',

   'Keywords'
=> 'Anahtar kelimeler',

   'Last access'
=> 'En son giriþ',

   'Last modified'
=> 'En son deðiþiklik',

   'Limit by copyright/distribution'
=> 'Telif Hakký/Daðýtým Sýnýrý',

   'Limit by language'
=> 'Dil sýnýrý',

   'Open'
=> 'Aç',

   'Per Page'
=> 'Sayfada',

   'Printing Helper'
=> 'Yazdýrma Yardýmcýsý',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Geri bildirim mesajlarý ver ya da bu kaynak hakkýnda kurs tartýþmalarýna katýl.',

   'Provide my evaluation of this resource'
=> 'Bu kaynaðýn beni deðerlendirmesini saðlamak',

   'Publish'
=> 'Yayýnlama',

   'Publish Directory'
=> 'Dizin yayýnlama',

   'Publish Directory and Sub Directories'
=> 'Dizin ve alt dizinleri yayýnlama',

   'Related'
=> 'Ýliþkili',

   'Resource Feedback and Discussion'
=> 'Kaynak geri bildirimi ve tartýþma',

   'Search Complete'
=> 'Arama tamamlandý',

   'Send Message to User(s)'
=> 'Kullanýcýya ya da kullanýcýlara mesaj gönder',

   'Show catalog information'
=> 'Katalog bilgisi göster',

   'Show resource'
=> 'Kaynaðý göster',

   'Size'
=> 'Boyut',

   'Statistics'
=> 'Ýstatistik',

   'Summary View'
=> 'Özet göster',

   'There are currently no results'
=> 'Sonuçlanmayan durum var',

   'URL'
=> 'URL',

   'Unpublished'
=> 'Yayýnlanmadý',

   'Up'
=> 'Yukarý',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'Kullanýcý Notlarý, Yüz yüze Tartýþmalarýn Kayýtlarý, ve Kritik Mesajlar',

   'View'
=> 'Görünüm',

   'View Critical Messages'
=> 'Kritik Mesajlarý Göster',

   'Words'
=> 'Kelimeler',

   'XML/SGML'
=> 'XML/SGML',

   'abstract'
=> 'özet',

   'audio'
=> 'audio',

   'author'
=> 'yazar',

   'catalog'
=> 'katalog',

   'copyright'
=> 'telif hakký',

   'customdistributionfile'
=> 'customdistributionfile',

   'directory'
=> 'dizin',

   'discuss'
=> 'tartýþmak',

   'evaluate'
=> 'deðerlendirmek',

   'feedback'
=> 'geri bildirim',

   'info'
=> 'iç',

   'keywords'
=> 'anahtar kelimeler',

   'language'
=> 'dil',

   'movies'
=> 'filmler',

   'notes'
=> 'notlar',

   'obsolete'
=> 'eskimiþ',

   'obsoletereplacement'
=> 'eskisini yenisiyle deðiþtirme',

   'pages'
=> 'sayfalar',

   'pictures'
=> 'resimler',

   'problem'
=> 'problem',

   'resources'
=> 'kaynaklar',

   'sequence'
=> 'sýra',

   'subject'
=> 'konu',

   'this'
=> 'bu',

   'title'
=> 'baþlýk',

   'About Me'
=> 'Benim hakkýmda',

   'Discussion Board/Discussion'
=> 'Ýlan/Tartýþma Tahtasý',

   'Clear All'
=> 'Tümünü temizle',

   'Close All Folders'
=> 'Bütün dosyalarý kapat',

   'Authoring Space File Operation'
=> 'Authoring Space File Operation', # 'Yapý alaný dosya çalýþmasý',

   'Contact Information'
=> 'Baðlantý bilgisi',

   'Copied old metadata'
=> 'eski metadatayý kopyaladý',

   'Copied old target file'
=> 'Önceki hedef dosyayý kopyaladý',

   'Copyright'
=> 'Telif hakký',

   'Could Not Process Request'
=> 'Verilerin denetlenmesi istenemez',

   'Default'
=> 'Eksik',

   'Discard Selected'
=> 'Seçili olaný at',

   'EMail and Messages'
=> 'EMail ve Mesajlar',

   'Edit this resource'
=> 'Bu kaynaðý düzenle',

   'Enter Authoring Space as a co-author'
=> 'Enter Authoring Space as a co-author', # 'Bir yardýmcý yazar gibi yapý alaný gir',

   'Host'
=> 'Sunucu',

   'Last updated'
=> 'Son güncelleme',

   'Mime type'
=> 'MIME Tipi',

   'Modified'
=> 'Deðiþtirildi',

   'Modify deadlines, etc, for this assessment resource'
=> 'Bu deðer biçilen kaynak için son teslim tarihleri v.s. deðiþtir',

   'Modify user grades for this assessment resource'
=> 'Bu deðer biçilen kaynak için kullanýcý derecelerini deðiþtir',

   'Move Down'
=> 'Aþaðý ilerle',

   'Move Up'
=> 'Yukarý ilerle',

   'New Title'
=> 'Yeni baþlýk',

   'Open All Folders'
=> 'Bütün dosyalarý aç',

   'Owner/Publisher'
=> 'Sahip/Yayýncý',

   'Personal Information'
=> 'Kiþisel bilgi',

   'Privacy Note'
=> 'Gizli not',

   'Published'
=> 'Yayýnlandý',

   'Reading results from'
=> 'Okuma alanýndan sonuçlar ',

   'Retrieve'
=> 'Düzeltmek',

   'Revert to Last Saved'
=> 'En son kurtarmayý eski haline döndür',

   'Revision Date'
=> 'Düzeltme tarihi',

   'Shared by course faculty and staff'
=> 'Kurs yetkisi ve elemaný tarafýndan paylaþtýrýldý',

   'Synchronized SQL metadata database'
=> 'SQL metadata veritabaný sekronize edildi',

   'Task'
=> 'Görev',

   'Temporary Assembly Workspace'
=> 'Geçici çalýþma alaný kur',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'Bilgiyi LON-CAPA ya üye olan bir kiþi görebilir.Herkesle paylaþmaya hazýr deðilsen bilgiyi vermez.',

   'Topic'
=> 'Konu',

   'Upload a Photo'
=> 'Bir resim gönder',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'Kullanýcý notlarý, Yüz yüze tartýþma kayýtlarý, ve kurs içindeki eleþtiri mesajlarý',

   'Version Number'
=> 'Versiyon numarasý',

   'View Published Version'
=> 'Yayýnlanan versiyonunu göster',

   'View user submissions for this assessment resource'
=> 'Bu deðeri biçilen kaynaðýn kullanýcý üyeliklerini göster',

   'Web References'
=> 'Web referanslarý',

   'co con-'
=> 'co con-',

   'co res'
=> 'co res',

   'contacting'
=> 'baðlantý',

   'edit'
=> 'düzenle',

   'interface available'
=> 'arayüz uygunluðu',

   'missions'
=> 'misyonlar',

   'view sub-'
=> 'göster alt-',
# sehe sub-
   'waiting on'
=> 'bekle',

#SYNC Wed Oct  8 14:13:34 2003
   '#Stdnts'
=> '#Stdnts',

   '#YES'
=> '#EVET',

   '%Wrng'
=> '%Wrng',

   'Brief view of each students performance in course.'
=> 'Kursdaki herbir öðrenci performansýný özet olarak göster',

   'Clear Caches'
=> 'Bellektekileri temizle',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Veritabaný tekrar baþlatýlana kadar kurs istatistikleri ve grafikler düzeltilemez. Verin bozulmamýþ fakat bu kez de gösterilemez.',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Problemler üzerindeki öðrenci performanslarýnýn grafikleri ve istatistikleri detaylandý.',

   'DoDiff'
=> 'DoDiff',

   'Enrollment Status'
=> 'Üyelik konumu',

   'Generate Statistics'
=> 'Ýstatistikler oluþturmak',

   'Max Tries'
=> 'Maksimum denemeler',

   'Mean Tries'
=> 'Vasat denemeler',

   'Output'
=> 'Çýktý',

   'Overall Problem Statistics'
=> 'Geniþ kapsamlý problem istatistikleri',

   'Please notify the server administrator '
=> 'Lütfen server yöneticisine bildir.',

   'Please select a report to generate.'
=> 'Lütfen bir rapor oluþturmayý seç.',

   'Preparing Excel Spreadsheet'
=> 'Excel sayfasý hazýrla',

   'Problem Status Chart'
=> 'Problem durum grafiði',

   'Problems occurred in creating the new Excel file.'
=> 'Problemler yeni Excel dosyasý yaratýyor.',

   'This error has been logged.'
=> 'Bu hata kaydedildi.',

   'Please alert your LON-CAPA administrator.'
=> 'Lütfen LON-CAPA yöneticini uyar.',

   'S.D. tries'
=> 'S.D. denemeler',

   'Sections'
=> 'Bölümler',

   'Sequence or Folder'
=> 'Sýra ya da dosya',

   'Sequences and Folders'
=> 'Sýralar ya da dosyalar',

   'Skew Tries'
=> 'Yan denemeler',

   'Statistics and Problem Analysis'
=> 'Ýstatistikler ve problem analizi',

   'Student performance statistics on all problems.'
=> 'Bütün problemler üzerinde öðrenci performans istatistikleri',

   'Unable to connect to database!'
=> 'Veri tabanýna baðlantý yapýlamaz',

   'Your Excel Spreadsheet'
=> 'Excel sayfan',

   'part'
=> 'bölüm',

   'problem statistics grouped by sequence'
=> 'sýrayla problem istatistikleri sýralandý',

   'problem statistics ungrouped'
=> 'grupsuz problem istatistikleri',

   'problem statistics, Excel'
=> 'problem istatistikleri, Excel',


   'Significant figures are incorrect, submission was not graded.'
=> 'Anlamlý þekiller yanlýþ, baðlýlýk derecelendirilmedi.',


   '. . . for a particular section'
=> 'ayrýntýlý bir bölüm için...',

   '. . . for all students in the course'
=> 'kursdaki bütün öðrenciler için...',

   '. . . for an individual student'
=> 'tek bir öðrenci için...',

   '12 am' # midnight
=> '00:00',

   'midnight'
=> 'Gece yarýsý',

   '1 am'
=> '1:00',

   '2 am'
=> '2:00',

   '3 am'
=> '3:00',

   '4 am'
=> '4:00',

   '5 am'
=> '5:00',

   '6 am'
=> '6:00',

   '7 am'
=> '7:00',

   '8 am'
=> '8:00',

   '9 am'
=> '9:00',

   '10 am'
=> '10:00',

   '11 am'
=> '11:00',

   '12 noon'
=> '12:00',

   'noon'
=> 'Öðle',

   '1 pm'
=> '13:00',

   '2 pm'
=> '14:00',

   '3 pm'
=> '15:00',

   '4 pm'
=> '16:00',

   '5 pm'
=> '17:00',

   '6 pm'
=> '18:00',

   '7 pm'
=> '19:00',

   '8 pm'
=> '20:00',

   '9 pm'
=> '21:00',

   '10 pm'
=> '22:00',

   '11 pm'
=> '23:00',

   '<- Previous'
=> '<- Önceki',

   'ALL'
=> 'BÜTÜN',

   'All Maps or Folders'
=> 'Bütün haritalar ya da dosyalar',

   'Any User'
=> 'Herhangi bir kullanýcý',

   'Assessment URL and Title'
=> 'URL ve baþlýk deðeri',

   'Assigned User Roles'
=> 'Kullanýcý rolleri belirlendi',

   'Browse resources'
=> 'Kaynaklarý tarama',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Bütün öðrenciler sisteme baðlanmadan 10 dakika önce deðiþiklikler yapýlabilir.',

   'Course Assessment Parameter - Helper Mode'
=> 'Kurs deðer parametresi - Yardýmcý mod',

   'Course Assessment Parameters - Overview Mode'
=> 'Kurs deðer parametreleri - Üstünde gösterme modu',

   'Course Assessments Parameters - Table Mode'
=> 'Kurs deðer parametreleri - tablo modu',

   'Course Environment Parameters'
=> 'Kurs ortam parametreleri',

   'Course Parameter Helper'
=> 'Kurs parametre yardýmcýsý',

   'Create New Environment Variable'
=> 'Yeni uygun ortam yarat',

   'Current Session Value'
=> 'Geçerli oturum deðeri',

   'Default Value'
=> 'Harici deðer',

   'Delete a role'
=> 'Bir rol silme',

   'Disable all communication among students'
=> 'Öðrenciler arasýndaki bütün iletiþim zarar gördü.',

   'Enclosing Map or Folder'
=> 'Harita ya da dosya iliþtirmek',

   'Every problem in a particular folder'
=> 'Belirli bir dosyada herbir problem',

   'Every problem in the course'
=> 'Kursdaki herbir problem',

   'Folder'
=> 'Dosya',

   'For User'
=> 'Kullanýcý için',

   'Grant/revoke Course Custom Role'
=> 'Vermek/Geri Almak Kurs Gelenekse Rolü',

   'Grant/revoke role of Administrator'
=> 'Yöneticinin rolünü Onayla/Kaldýr',

   'Grant/revoke role of Author'
=> 'Yazarýn rolünü Onayla/Kaldýr',

   'Grant/revoke role of Course Coordinator'
=> 'Kurs koordinatörünün rolünü Onayla/Kaldýr',

   'Grant/revoke role of Domain Guest'
=> 'Alan misafirinin rolünü Onayla/Kaldýr',

   'Grant/revoke role of Librarian'
=> 'Kütüphanecinin rolünü Onayla/Kaldýr',

   'Grant/revoke role of Teaching Assistant'
=> 'Öðretim görevlisinin rolünü Onayla/Kaldýr',

   'Internally authenticated'
=> 'Internally authenticated',

   'Kerberos authenticated'
=> 'Kerberos authenticated',

   'LON-CAPA Helper:'
=> 'LON-CAPA yardýmcýsý',

   'Lock and unlock assessments'
=> 'Deðerleri kilitle ve kilidi aç',

   'Manage Access Keys'
=> 'Giriþ anahtarlarý yönetimi',

   'Manage access keys'
=> 'Giriþ anahtarlarý yönetimi',

   'Max Possible To Date'
=> 'Olabilecek maksimum tarih',

   'Modify Course Assessment Parameters'
=> 'Kurs deðer parametrelerini deðiþtirmek',

   'Modify authentication mechanism and data for a user'
=> 'Bir kullanýcý için veri ve mekanizma doðruluðunu deðiþtirmek',

   'Modify grades'
=> 'Dereceleri deðiþtirmek',

   'Next ->'
=> 'Bir sonraki ->',

   'One particular problem'
=> 'Diðerlerinden farklý bir problem',

   'Parameter Name'
=> 'Parametre ismi',

   'Parameter Type'
=> 'Parametre tipi',

   'Parameter in Effect'
=> 'Sonuçtaki parametre',

   'Please select a problem to analyze'
=> 'Lütfen analize bir problem seç',

   'Post anonymously'
=> 'Adýný koymadan ilan etmek',

   'Post discussion on course resources'
=> 'Kurs kaynaklarý üzerindeki tartýþmayý ilan etmek',

   'Post system frontpage announcements'
=> 'Sistem önsayfa ilanlarýný ilan etmek',

   'Post to live chatrooms'
=> 'Canlý sohbet odalarýný ilan etmek',
   'Problems Not Contained In A Folder'
=> 'Problemler bir dosyada tutulmaz',

   'Quick Completed Problems Display'
=> 'Problemler gösterisi hýzlý tamamlandý',

   'Resource Level'
=> 'Kaynak düzeyi',

   'Section'
=> 'Bölüm',

   'Select Date'
=> 'Tarih seç',

   'Select Enclosing Map or Folder'
=> 'Harita veya dizin seç',

   'Select Parameter Level'
=> 'Parametre düzeyi seç',

   'Send internal email'
=> 'Ýnternal email gönder',

   'Set Course Environment Parameters'
=> 'Çevresel kurs parametreleri ata',

   'Set Date'
=> 'Tarih belirle',

   'Set Defaults for All Resources in Course'
=> 'Kurstaki tüm kaynaklar için defaultlar belirle',

   'Set a due date'
=> 'Uygun tarihi belirle',

   'Set an answer open date'
=> 'Açýlýþ tarihi cevabý belirle',

   'Set an open date'
=> 'Açýlýþ tarihi belirle',

   'Set opening datefor all problems in the course for. . .'
=> 'Kurs problemleri için açýlýþ tarihi belirle',

   'Set the number of tries'
=> 'Deneyimleri numaralandýr',

   'Set the problem weight'
=> 'Problem zorluðunu belirle',

   'Set/Modify Course Assessment Parameter'
=> 'Belirle/Deðiþtir Kurs deðer parametresi',

   'Set/Modify Course Assessment Parameters'
=> 'Belirle/Deðiþtir Kurs deðer parametresi',

   'Set/Modify Course Parameters'
=> 'Belirle/Deðiþtir kurs parametreleri',

   'Show More Options'
=> 'Daha Fazla seçenek göster',

   'Students Affected'
=> 'Sahte Öðrenciler',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'Bu yardýmcý sana problemlerin cevap tarihleri ve gerekli, açýk ayarlar için yardýmcý olacak, ya da problemlerin deneme sayýlarýný belirler. Hangi problemin parametrelerini belirlemeyi istediðini sorabileceksin, o zaman parametreyi belirlemeyi istersin, o zaman sahte ayarlarý seçeceksin. Yardýmcý bittikten sonra, seçtiðin parametreleri ayarlayabileceksin, böylece doðruca yapabilirsin. Bas ileri -&gt; baþla; ya da seç &lt; Önceki ekrana geri git.',

   'Total'
=> 'Tüm',

   'Total Parts In Course'
=> 'Kursun Tüm kýsýmlarý',

   'Type'
=> 'Tipi',

   'UNIX authenticated'
=> 'UNIX doðrulamasý',

   'USERS'
=> 'Kullanýcýlar',

   'Unknown ID'
=> 'Bilinmeyen ID',

   'Unknown user'
=> 'Bilinmeyen Kullanýcý',

   'Update Course Assessment Parameter Display'
=> 'Kurs deðer parametre gösterisini güncelle',

   'Update Section or Specific User'
=> 'Güncelleme kýsmý veya Özel kullanýcý',

   'Verify Selection'
=> 'Seçimi onayla',

   'Welcome to the Assignment Parameter Helper'
=> 'Yardýmcý parametre tayinine hoþgeldiniz',

   'What parameter do you want to set for all problems in the course?'
=> 'Kurstaki tüm problemler için hangi parametreyi atamak istersiniz?',

   'What should the opening date be set to?'
=> 'Açýlýþ tarihinde ne belirlenmeli?',

   'Which Problem or Problems?'
=> 'Hangi problem veya problemler?',

   'Which problems do you wish to set a parameter for?'
=> 'Hangi problemler için parametre atamak istersiniz?',

   'You need to choose another user role or enter a specific course for this function'
=> 'Bu amaç için özel bir kurs gir ya da baþka bir kullanýcý rolü seçmen gerekir.',
# You need to wähle another benutzer rolle oder eingeben a specific kurs foder Diese function

   'a.m.'
=> 'Öðleden önce',

   'acc keys'
=> 'Eriþim tuþlarý',

   'according to course preferences'
=> 'Kurs haklarýna göre',
# accoderding to kurs preferrenzen
   'according to resource settings'
=> 'Kaynak ayarlarýna göre',
# accoderding to resource setzetings
   'according to user session state'
=> 'Kullanýcý oturumu durumuna göre',
# accoderding to benutzer session state

   'all'
=> 'Bütün',

   'at'
=> '-de',

   'at Domain'
=> 'Etki Alanýnda',

   'at domain'
=> 'Etki Alanýnda',

   'default'
=> 'Eksiklik',

   'for Enclosing Map or Folder'
=> 'Harita veya dizin için',

   'for Resource'
=> 'Kaynak için',

   'from Enclosing Map or Folder'
=> 'Harita veya Dizinden',

   'general'
=> 'Genel',

   'in Course'
=> 'Kursta',

   'in Section/Group'
=> 'Bölümde/Grupta',

   'manage'
=> 'Ýdare',

   'num_override'
=> 'Geçersiz Sayý',

   'of'
=> '-in',

   'or ID'
=> 'Veya ID',

   'p.m.'
=> 'Öðleden sonra',

   'percent'
=> 'yüzde',

   'unless locked'
=> 'Kilitli Deðil',

   'users in'
=> 'Kullanýcý Giriþi',

   'Access Key Management'
=> 'Eriþim Tuþu Yönetimi',

   'Assessment'
=> 'Deðer',

   'Calculations'
=> 'Hesaplamalar',

   'Comma Separated Values'
=> 'Virgülle Ayrýlan Deðerler',

   'Course ID'
=> 'Kurs ID',

   'Course level sheet'
=> 'Kurs Seviye Sayfasý',

   'Detailed Problem Analysis'
=> 'Detaylý Problem Analizi',

   'End Helper'
=> 'Yardýmcýyý Kapat',

   'Excel'
=> 'Excel',

   'Finish Course Initialization'
=> 'Kurs Baþlangýcýný Bitir',

   'Generate Spreadsheet'
=> 'Spreadsheet Üret',

   'Grant/revoke role of Bubblesheet Operator'
=> 'Grant/revoke role of Bubblesheet Operator', # 'Scantron operatörünün rolünü onayla/kaldýr',

   'HTML'
=> 'HTML',

   'Invalid date entry'
=> 'Geçersiz Tarih',

   'Load:'
=> 'Yükleme',

   'No changes were made to the current settings.'
=> 'Ayarlarýnýzda deðiþiklik yapýlmadý',

   'Output Format'
=> 'Çýktý Formatý',

   'Processing course structure'
=> 'Kurs planý iþleme geçiriliyor',

   'Processing first student'
=> 'Ýlk öðrenci iþleme geçiriliyor',

   'Row'
=> 'Satýr',

   'Save as'
=> 'Farklý Kaydet',

   'Save as & Make This Sheet the Default'
=> 'Bu sayfayý default yap & Farklý kaydet',

   'Bubblesheet Scanning Operator'
=> 'Bubblesheet Scanning Operator', # 'Scantron operatörü',

   'Select All'
=> 'Tümünü Seç',

   'Select All Students'
=> 'Tüm öðrencileri seç',

   'Select Spreadsheet File'
=> 'Excel dosyasý seç',

   'Send bubblesheet data to a course'
=> 'Kursa Scantron bilgi gönder',

   'Spreadsheet Computation'
=> 'Sayfa Hesabý',

   'Spreadsheet Computation Status'
=> 'Sayfa Hesap Durumu',

   'Student level sheet'
=> 'Öðrenci seviyesi Sayfasý',

   'Summary'
=> 'Özet',

   'Template'
=> 'Þablon',

   'Unselect All'
=> 'Tümü seçilmemiþ',

   'Unselect All Students'
=> 'Seçilmemiþ tüm öðrenciler',

   'Upload bubblesheet data'
=> 'Bubblesheet veri güncelle',

   'You must choose at least one student to continue.'
=> 'Devam etmek için en az bir öðrenci seçmelisin',

   'You must choose one or more choices to continue.'
=> 'Devam etmek için birini veya daha fazlasýný seçmelisin',

   'last student'
=> 'Son Öðrenci',

   'may be open from a different computer.'
=> 'Baþka bilgisayarda açýk olabilir',

   'minutes'
=> 'Dakikalar',

   'remaining'
=> 'Kalan',

   'second'
=> 'Saniye',

   'seconds'
=> 'Saniyeler',

   'seconds for'
=> 'Saniye kala',

   'Additional Recipients'
=> 'Ek Alýcý',

   'Analyze Over '
=> 'Analiz Et',

   'Analyze Problem'
=> 'Problemi analiz et',

   'Analyze Problem Again'
=>  'Problemi tekrar analiz et',

   'Analyze as '
=> 'Analiz et',

   'Browsing resource, all submissions are temporary.'
=> 'Kaynak taranýyor,tüm öneriler geçici',

   'By'
=> '-tarafýndan',

   'Check All'
=> 'Tümünü onayla',

   'Check for All'
=> 'Tümünü onayla',

   'Check for None'
=> 'Hiçbirini onaylama',

   'Check for Section/Group'
=> 'Bölüm/Grup onayla',

   'Choose a different resource'
=> 'Baþka kaynak seç',

   'Concepts'
=> 'Kavramlar',

   'Critical Messages'
=> 'Kritik mesaj',

   'Delete'
=> 'Sil',

   'Delete Checked'
=> 'Ýþaretlileri Sil',

   'Display All Messages'
=> 'Tüm mesajlarý Görüntüle',

   'Display all Messages'
=> 'Tüm mesajlarý Görüntüle',

   'Foils'
=> 'Önlemler',

   'Forward'
=> 'Yönlendir',

   'Forwarded message from'
=> 'Yönlendirilmiþ mesaj',

   'Forwarding'
=> 'Yönlendiriliyor',

   'From'
=> '-dan',

   'Functions'
=> 'Fonksiyonlar',

   'Mail'
=> 'Posta',

   'Mark Unread'
=> 'Okunmadý',

   'New Problem Variation'
=> 'Yeni Problem Varyasyonu',

   'New Randomization'
=> 'Yeni Rastgele Seçim',

   'Next'
=> 'Sonraki',

   'Number of Plots:'
=> 'Çizim numarasý',

   'Option Response Problem Analysis'
=> 'Problem yanýt seçeneði analizi',

   'Previous'
=> 'Önceki',

   'Re'
=> 'Tekrar',

   'Record'
=> 'Kayýt',

    'Reply'
 => 'Cevap Ver',

   'Reset Submissions'
=> 'Önerileri Sýfýrla',

   'Select a course'
=> 'Kurs Seç',

   'Selecting a User'
=> 'Kullanýcý seç',

   'Send New'
=> 'Yeni Gönder',

   'Send Reply'
=> 'Cevap Ver',

   'Send as critical message'
=>'Kritik mesaj gönder',

   'Simple Problem Editor'
=> 'Basit Problem Editörü',

   'Starting'
=> 'Baþlýyor',

   'Student Data Compilation Progress'
=> 'Öðrenci Bilgisi Derleme Süreci',

   'Student Data Compilation Status'
=> 'Öðrenci Bilgisi Derleme Durumu',

   'There is no student data for this problem.'
=> 'Öðrenci bilgisi yok',

   'Time'
=> 'Zaman',

   'To'
=> '-e',

   'Uncheck All'
=> 'Tümü kontroldýþý',

   'Unsuccessful Login'
=> 'Baþarýsýz Giriþ',

   'Update Student Data'
=> 'Öðrenci bilgilerini güncelle',

   'You have no critical messages.'
=> 'Kritik mesajýnýz yok',

   'and return receipt'
=> 'Alýndýya dön',

   'can not be accessed from your location.'
=> 'Konumunuza ulaþýlamadý',


#SYNC Tue Aug 15 14:23:51 2006
   ' [_1]'
=> ' [_1]',

   '"[_1]" for default hiding'
=> '"[_1]" for default hiding',
# "[_1]" fveya Eksiklik hiding
   '"[_1]" for visible separation'
=> '"[_1]" for visible separation',
# "[_1]" fveya visible separ-deion
   '"[_1]" if allowed, anything else if not'
=> '"[_1]" if allowed, anything else if not',
# "[_1]" if BütünoÇarþamba, anything else if not
   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',
# "[_1]" -e disable, anything else if not
   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Show&nbsp;All&nbsp;Foils',
# &nbsp;Show&nbsp;Bütün&nbsp;Önlemler
   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.',
# &quot; [_1] &quot; is not an acceptable number -in Denemeler. Denemeler must be a positive number with no decimal point.
   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.',

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',
# (Giriþ maximum [_1] collabveya-deveyas using kullanýcýÝsim veya kullanýcýÝsim@Alan, e.g. smithje veya smithje@[_2].)
   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',
# (Hand in a Dosya you have hazýrlamakd on your computer)
   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',
# , Seç templ-dee -dan the pull-down menu below.
   '1 minute'
=> '1 minute',

   '1 out of N multiple choice (radio button)'
=> '1 out of N multiple choice (radio button)',
# 1 out -in N multiple choice (radio but-en)
   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',
# <*Tekrarsponse>s aTekrar both inside -in <bölüm> and outside -in <bölüm>, bu is not a valid problem, errveyas in Basamak Mayýs occur.
   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',
# <b>HTML BütünoÇarþamba</b>: tartýþmakion bölümicipants can use limited HTML in their postings.
   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',
# <b>HTML banned</b>: HTML will not be BütünoÇarþamba in tartýþmakion postings.
   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',
# <b>Inyapýveya</b> - inyapýveyas will not be able -e bölümicip-dee in tartýþmakions
   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',
# <b>Inyapýveya</b> - inyapýveyas will not be able -e use veya Görünüm the Sohbet room
   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',
# <b>ÖðTekrarncis</b> - ÖðTekrarncis will not be able -e bölümicip-dee in tartýþmakions
   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',
# <b>ÖðTekrarncis</b> - ÖðTekrarncis will not be able -e use veya Görünüm the Sohbet room.
   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',
# <b>Asistan ÖðTekrartmens</b> - Asistan ÖðTekrartmens will not be able -e bölümicip-dee in tartýþmakions
   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',
# <b>Asistan ÖðTekrartmens</b> - Asistan ÖðTekrartmens will not be able use veya Görünüm the Sohbet room
   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Unable to enroll: [_2]',
# <b>[_1]</b>:  Unable -e Üye Olmak: [_2]
   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Unable to enroll.  No password specified.',
# <b>[_1]</b>: Unable -e Üye Olmak.  No passwveyad specified.
   'Unacceptable username [_1] for user [_2] [_3] [_4] [_5]'
=> 'Unacceptable username [_1] for user [_2] [_3] [_4] [_5]',
# Unacceptable kullanýcýÝsim [_1] fveya kullanýcý [_2] [_3] [_4] [_5]
   'Unacceptable domain [_1] for user [_2] [_3] [_4] [_5]'
=> 'Unacceptable domain [_1] for user [_2] [_3] [_4] [_5]',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>',
# <p>Your curTekrarnt LON-CAPA Alan is &quot;<b>[_1]</b>&quot;.</p>
   'ABSTRACT'
=> 'ABSTRACT',
# özet
   'Access Control'
=> 'Access Control',

   'Activate'
=> 'Activate',
# Activ-dee
   'Add Roles'
=> 'Add Roles',
# Add roller
   'Add new option'
=> 'Add new option',

   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",
# Add one Boþalt Sayfa/column after each ÖðTekrarnci's assignment
   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",
# Add thTekrare Boþalt sayfalar/column after each ÖðTekrarnci's assignment
   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",
# Add two Boþalt sayfalar/column after each ÖðTekrarnci's assignment
   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',
# Additional koymaktings, if specified below, will override cloned koymaktings
   'Administrator'
=> 'Administrator',
# Öðleden öncenistr-deveya
   'Advanced Edit'
=> 'Advanced Edit',
# Advanced düzenle
   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',
# Advanced: You can sSon the geri bildirim -dan diffeTekrarnt Bölümler -e diffeTekrarnt people, -tarafýndan doing the following: Separ-dee each entry with a comma. -e sSon geri bildirim -e a certain addTekrarss fveya diffeTekrarnt Bölümler, appSon the Bölüm Ýsim veya Ýsims (separ-deed -tarafýndan semi-colons) in a paTekrarntheBoyutd list after the kullanýcý:Alan. Fveya example, john102:msu(001;002;003),bob293:msu(004;005;006),madeYukarýÝsim:heTekrar(007;008;009) will route kurs geri bildirim -e &quot;john102&quot; fveya Bölümler 1, 2, and 3, -e &quot;bob293&quot; fveya 4, 5, and 6, and -e &quot;madeYukarýÝsim:heTekrar&quot; fveya 7, 8, and 9. Note theTekrar is no TekrarquiTekrarment th-de the addTekrarsses be in any bölümicular Alan.
   'All Documents in Course'
=> 'All Documents in Course',
# Bütün Documents Kursta
   'All Resources'
=> 'All Resources',
# Bütün kaynaklar
   'All Resources (possibly large output)'
=> 'All Resources (possibly large output)',
# Bütün kaynaklar (possibly large Çýktý)
   'All Students'
=> 'All Students',
# Bütün ÖðTekrarncis
   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',
# Bütünow limited HTML in tartýþmakion posts
   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',
# Bütünow problems -e be split over sayfalar
   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',
# BütünoÇarþamba Dosya Extensions fveya GüncellSoni Dosyas (GüncellSoniDosyaTipis)
   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',
# BütünoÇarþamba DosyaTipis: <b>[_1]</b>
   'An error occurred during the attempt to change the section for this student.'
=> 'An error occurred during the attempt to change the section for this student.',
# An errveya occuTekrard during the -detempt -e change the Bölüm fveya bu ÖðTekrarnci.
   'An error occurred during the attempt to change the role information for this student.'
=> 'An error occurred during the attempt to change the role information for this student.',
# An errveya occurTekrard during the -detempt -e change the rol infveyam-deion fveya bu ÖðTekrarnci.
   'Analyzing Results'
=> 'Analyzing Results',
# Analyzing Tekrarsults
   'Anonymous'
=> 'Anonymous',

   'Anonymous contribution to course discussion of resource'
=> 'Anonymous contribution to course discussion of resource',
# Anonymous contribution -e kurs tartýþmakion -in kaynak
   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',
# Cevapla D-dee (Cevaplad-dee)
   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',
# Cevapla Gönderted: Your final submission will be graded after the Yeterli d-dee.
   'Answer:'
=> 'Answer:',
# Cevapla:
   'Answerable'
=> 'Answerable',
# Cevaplaable
   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).',
# As a Genel Kural, only authveyas veya co-authveyas should be DosyaSistem auSonratic-deed (which Bütünows access -e the Sunucu DosyaSistem).
   'Assessment Parameters'
=> 'Assessment Parameters',
# Deðer Parameters
   'Associate columns with student attributes.'
=> 'Associate columns with student attributes.',
# Associ-dee columns with ÖðTekrarnci -detributes.
   'Attachment'
=> 'Attachment',
# -detachment
   'Attribute'
=> 'Attribute',
# -detribute
   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',
# Au-em-deed Üye OlmÖðleden öncent ÝTarihkrarr
   'Automated adds'
=> 'Automated adds',
# Au-em-deed adds
   'Automated drops'
=> 'Automated drops',
# Au-em-deed drops
   'Automated enrollment settings'
=> 'Automated enrollment settings',
# Au-em-deed Üye OlmÖðleden öncent koymaktings
   'Bad Filename'
=> 'Bad Filename',
# Bad DosyaÝsim
   'Begin Enrollment'
=> 'Begin Enrollment',
# Begin Üye OlmÖðleden öncent
   'Binary File'
=> 'Binary File',
# Binary Dosya
   'Blank'
=> 'Blank',

   'Browse'
=> 'Browse',
# BSatýrse
   'CSV (comma separated values, spreadsheet)'
=> 'CSV (comma separated values, spreadsheet)',
# CSV (comma separ-deed values, spTekraradsheet)
   'CSV format'
=> 'CSV format',
# CSV fveyam-de
   'Calculate answers'
=> 'Calculate answers',
# Calcul-dee Cevaplas
   'Cannot publish directory'
=> 'Cannot publish directory',
# Cannot Yayýnlama diTekrarctveyay
   'Cannot retrieve directory'
=> 'Cannot retrieve directory',
# Cannot Düzeltmek diTekrarctveyay
   'Catalog Search'
=> 'Catalog Search',
# k-dealog aramak
   'Change'
=> 'Change',

   'Change Random Seed To:'
=> 'Change Random Seed To:',
# Change Random Seed -e:
   'Change User Privileges'
=> 'Change User Privileges',
# Change kullanýcý Privileges
   'Change Your Language Preferences'
=> 'Change Your Language Preferences',
# Change Your dil PTekrarferTekrarnzen
   'Changed discussion view mode'
=> 'Changed discussion view mode',
# Changed tartýþmakion Görünüm mode
   'Chat Participation'
=> 'Chat Participation',
# Sohbet bölümicip-deion
   'Check Course Document Versions'
=> 'Check Course Document Versions',
# Check kurs Document Versiyons
   'Check/Set Resource Versions'
=> 'Check/Set Resource Versions',
# Check/koymak kaynak Versiyons
   'Chronological View'
=> 'Chronological View',
# Chronological Görünüm
   'Click here for FAQ'
=> 'Click here for FAQ',
# Click heTekrar fveya FAQ
   'Click here for help'
=> 'Click here for help',
# Click heTekrar fveya Yardým
   'Click here to report bugs'
=> 'Click here to report bugs',
# Click heTekrar -e Tekrarpvey-de bugs
   'Click here to return to the chart.'
=> 'Click here to return to the chart.',
# Click heTekrar -e Tekrarturn -e the Grafik.
   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',
# Client IP/Ýsim Access Control (acc)
   'Clone an existing course'
=> 'Clone an existing course',
# Clone an existing kurs
   'Close This Window'
=> 'Close This Window',
# Kapat bu Window
   'Closed'
=> 'Closed',
# Kapatd
   'Column'
=> 'Column',

   'Column&nbsp;[_1]'
=> 'Column&nbsp;[_1]',

   'Communication'
=> 'Communication',
# Communikasyon
   'Compare versions of'
=> 'Compare versions of',
# CompaTekrar Versiyons -in
   'Completed'
=> 'Completed',

   'Completely new course'
=> 'Completely new course',
# Completely new kurs
   'Concept:'
=> 'Concept:',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.',
# Confirm th-de bu infveyam-deion is cveyaTekrarct, Sonra click &quot;Finish Yardýmer&quot; -e complete koymakting the parameter.
   'Authoring Space Version'
=> 'Authoring Space Version',
# Conyapýion boþluk Versiyon
   'Continue'
=> 'Continue',

   'Continue enrollment?'
=> 'Continue enrollment?',
# Continue Üye OlmÖðleden öncent?
   'Contribution to course discussion of resource'
=> 'Contribution to course discussion of resource',
# Contribution -e kurs tartýþmakion -in kaynak
   'Copy current file to'
=> 'Copy current file to',
# Copy curTekrarnt Dosya -e
   'Copy selected'
=> 'Copy selected',
# Copy Seçed
   'Correct Option:'
=> 'Correct Option:',
# CveyaTekrarct Option:
   'Course Code'
=> 'Course Code',
# kurs Code
   'Course Content'
=> 'Course Content',
# kurs Content
   'Course Data'
=> 'Course Data',
# kurs D-dea
   'Course Home Server'
=> 'Course Home Server',
# kurs Home Sunucu
   'Course ID or number'
=> 'Course ID or number',
# kurs ID veya number
   'Course ID/Number'
=> 'Course ID/Number',
# kurs ID/Number
   'Course Information'
=> 'Course Information',
# kurs Infveyam-deion
   'Course Initialization Helper'
=> 'Course Initialization Helper',
# kurs Initializ-deion Yardýmer
   'Course Level'
=> 'Course Level',
# kurs Level
   'Course Search'
=> 'Course Search',
# kurs aramak
   'Course Title'
=> 'Course Title',
# kurs baþlýk
   'Course default for all problems'
=> 'Course default for all problems',
# kurs Eksiklik fveya Bütün problems
   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',
# kurs members can provide geri bildirim about the kurs. You can Seçme who will Tekrarceive the geri bildirim, such as a diffeTekrarnt inyapýveya veya a TA. Please Giriþ their LON-CAPA addTekrarss below, in the fveyam kullanýcý:Alan, wheTekrar &quot;kullanýcý&quot; and &quot;Alan&quot; aTekrar both the LON-CAPA kullanýcýÝsim and LON-CAPA Alan, not an ePosta addTekrarss.
   'Courses'
=> 'Courses',
# kurss
   'Create New User'
=> 'Create New User',
# Oluþtur New kullanýcý
   'Create User'
=> 'Create User',
# Oluþtur kullanýcý
   'Create a New Course'
=> 'Create a New Course',
# Oluþtur a New kurs
   'Creating a new'
=> 'Creating a new',
# CTekrar-deing a new
   'Crosslisted courses'
=> 'Crosslisted courses',
# Crosslisted kurss
   'Current'
=> 'Current',
# CurTekrarnt
   'Current Class List'
=> 'Current Class List',
# CurTekrarnt Class List
   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',
# CurTekrarnt Soning D-dee: [_1]
   'Current Ending Date: not set'
=> 'Current Ending Date: not set',
# CurTekrarnt Soning D-dee: not koymak
   'Current Resource'
=> 'Current Resource',
# CurTekrarnt kaynak
   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',
# CurTekrarnt Baþlýyor D-dee: [_1]
   'Current Starting Date: not set'
=> 'Current Starting Date: not set',
# CurTekrarnt Baþlýyor D-dee: not koymak
   'Current Version'
=> 'Current Version',
# CurTekrarnt Versiyon
   'Currently no active roles or courses'
=> 'Currently no active roles or courses',
# CurTekrarntly no active roller veya kurss
   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',
# CurTekrarntly no additional roller veya kurss
   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',
# CurTekrarntly Gönderted: <tt>[_1]</tt>
   'Custom Role Editor'
=> 'Custom Role Editor',
# Cus-em rol düzenleveya
   'Customized right of use ...'
=> 'Customized right of use ...',
# Cus-emized right -in use ...
   'Cut selected'
=> 'Cut selected',
# Cut Seçed
   'Decompress'
=> 'Decompress',
# DecompTekrarss
   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',
# Eksiklik Deðer SpTekraradsheet
   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',
# Eksiklik kurs SpTekraradsheet
   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',
# Eksiklik ÖðTekrarnci SpTekraradsheet
   'Default XML Style File'
=> 'Default XML Style File',
# Eksiklik XML Style Dosya
   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',
# Eksiklik beginning d-dee when Üye Olmaking ÖðTekrarncis
   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',
# Eksiklik Soning d-dee when Üye Olmaking ÖðTekrarncis
   'Default for new courses is'
=> 'Default for new courses is',
# Eksiklik fveya new kurss is
   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',
# Eksiklik koymak -in options -e pass -e tth/m when converting tex
   'Default:'
=> 'Default:',
# Eksiklik:
   'Define Role'
=> 'Define Role',
# Define rol
   'Delete an option'
=> 'Delete an option',
# Sil an option
   'Delete:'
=> 'Delete:',
# Sil:
   'Dependencies'
=> 'Dependencies',
# DepSonencies
   'Description:'
=> 'Description:',

   'Diffs'
=> 'Diffs',

   'Diffs with Current Version'
=> 'Diffs with Current Version',
# Diffs with CurTekrarnt Versiyon
   'Diffs with Version'
=> 'Diffs with Version',
# Diffs with Versiyon
   'Diffs with current Version'
=> 'Diffs with current Version',
# Diffs with curTekrarnt Versiyon
   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)',
# Disable ID/ÖðTekrarnci Number Safeguard and Fveyace Change -in Conflicting IDs (only do if you know wh-de you aTekrar doing)
   'Disable display of problem receipts'
=> 'Disable display of problem receipts',
# Disable Görüntüle -in problem Tekrarceipts
   'Disable student resource discussion'
=> 'Disable student resource discussion',
# Disable ÖðTekrarnci kaynak tartýþmakion
   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',
# Disable ÖðTekrarnci use -in Sohbetrooms
   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',
# DisBütünow kaynak tartýþmakion fveya roller
   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',
# DisBütünow kaynak tartýþmakion fveya kullanýcýs
   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',
# DisBütünow live Sohbetroom use fveya roller
   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',
# DisBütünow live Sohbetroom use fveya kullanýcýs
   'Discussion Contributions'
=> 'Discussion Contributions',
# tartýþmakion Contributions
   'Discussion Participation'
=> 'Discussion Participation',
# tartýþmakion bölümicip-deion
   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments.',
# Görüntüle and analysis -in submission Zamans on Deðers.
   'Display file attributes'
=> 'Display file attributes',
# Görüntüle Dosya -detributes
   'Display foils in order given'
=> 'Display foils in order given',
# Görüntüle Önlemler in veyader given
   'Display foils in random order'
=> 'Display foils in random order',
# Görüntüle Önlemler in random veyader
   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',
# Do NOT gener-dee as standard kurs
   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',

   'Domain Guest'
=> 'Domain Guest',
# Alan Guest
   'Domain Level'
=> 'Domain Level',
# Alan Level
   "Don't Show Feedback"
=> "Don't Show Feedback",
# Don't Show geri bildirim
   'Drop Students'
=> 'Drop Students',
# Drop ÖðTekrarncis
   'Dropped [_1]'
=> 'Dropped [_1]',

   'Dropped [_1] student(s).'
=> 'Dropped [_1] student(s).',
# Dropped [_1] ÖðTekrarnci(s).
   'Dropping Students'
=> 'Dropping Students',
# Dropping ÖðTekrarncis
   'Due Date (contentclose)'
=> 'Due Date (contentclose)',
# Yeterli D-dee (contentKapat)
   'Due Date (duedate)'
=> 'Due Date (duedate)',
# Yeterli D-dee (Yeterlid-dee)
   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',
# Dur-deion -in au-em-deed classlist Yukarýd-dees
   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',
# Dynamic Metad-dea (periyodik güncelleme)
   'EMail Address'
=> 'EMail Address',
# EPosta AddTekrarss
   'ERROR'
=> 'ERROR',
# ERRveya
   'Edit Custom Role Privileges'
=> 'Edit Custom Role Privileges',
# düzenle Cus-em rol Privileges
   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.',
# düzenleveya Errveyas - these errveyas might not effect the running -in the problem, but they will likely cause problems with further use -in the düzenle mode. Please use the düzenleXML mode -e fix these errveyas.
   'End Time'
=> 'End Time',
# Son Zaman
   'Ending Date'
=> 'Ending Date',
# Soning D-dee
   'Enroll One Student'
=> 'Enroll One Student',
# Üye Olmak One ÖðTekrarnci
   'Enroll a single student'
=> 'Enroll a single student',
# Üye Olmak a single ÖðTekrarnci
   'Enroll as student'
=> 'Enroll as student',
# Üye Olmak as ÖðTekrarnci
   'Enrolling'
=> 'Enrolling',
# Üye Olmaking
   'Enrolling Student'
=> 'Enrolling Student',
# Üye Olmaking ÖðTekrarnci
   'Enrolling Students'
=> 'Enrolling Students',
# Üye Olmaking ÖðTekrarncis
   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',
# Giriþ as many fields as you can. The Sistem will infveyam you and bring you back -e bu Sayfa if the d-dea Seçed is insufficient -e Üye Olmak ÖðTekrarncis in your class.
   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below',
# Giriþ terms veya phrases separ-deed -tarafýndan AND, veya, veya NOT Sonra pTekrarss aramak below
   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Enter terms or phrases separated by search operators such as AND, OR, or NOT',
# Giriþ terms veya phrases separ-deed -tarafýndan aramak oper-deveyas such as AND, veya, veya NOT
   'Entering Authoring Space'
=> 'Entering Authoring Space',
# Giriþing Conyapýion boþluk
   'Error'
=> 'Error',
# Errveya
   'Error dropping [_1]:[_2]'
=> 'Error dropping [_1]:[_2]',
# Errveya dropping [_1]:[_2]
   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',
# Errveya: DiTekrarctveyay Non Boþalt
   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',
# Errveya: destin-deion fveya oper-deion is an existing diTekrarctveyay.
   'Essay, open end'
=> 'Essay, open end',
# Essay, Aç Son
   'Evaluation Error '
=> 'Evaluation Error ',
# Evalu-deion Errveya
   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',
# Every problem in a bölümicular Dosya (overrides kurs Eksiklik)
   'Exam Problem'
=> 'Exam Problem',

   'Excel format'
=> 'Excel format',
# Excel fveyam-de
   'Exit'
=> 'Exit',
# Çýkýþ
   'False'
=> 'False',

   'Feedback Addresses for Course Content'
=> 'Feedback Addresses for Course Content',
# geri bildirim AddTekrarsses fveya kurs Content
   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',
# geri bildirim AddTekrarsses fveya kurs Content Comments
   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',
# geri bildirim AddTekrarsses fveya kurs Policy
   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',
# geri bildirim AddTekrarsses fveya kaynak Content Question
   'Field'
=> 'Field',

   'Filenames in Authoring Space'
=> 'Filenames in Authoring Space',
# DosyaÝsims in Conyapýion boþluk
   'Finish Helper'
=> 'Finish Helper',
# Finish Yardýmer
   'First'
=> 'First',

   'First Name'
=> 'First Name',
# First Ýsim
   'First Resource'
=> 'First Resource',
# First kaynak
   'Foil'
=> 'Foil',

   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',
# Foil Ýsim <b><tt>[_1]</tt></b> appears mveyae than once. Foil Ýsims need -e be unique.
   'Folder in Authoring Space'
=> 'Folder in Authoring Space',
# Dosya in Conyapýion boþluk
   'Folder/Map'
=> 'Folder/Map',
# Dosya/Harita
   'For one or more students'
=> 'For one or more students',
# Fveya one veyÖðleden önceeyae ÖðTekrarncis
   'Format:'
=> 'Format:',
# Fveyam-de:
   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',
# Found a <*Tekrarsponse> outside -in a <bölüm> in a <bölüm>ed problem
   'Full Update'
=> 'Full Update',
# Full Yukarýd-dee
   'Full update (also print list of users not enrolled anymore)'
=> 'Full update (also print list of users not enrolled anymore)',
# Full Yukarýd-dee (also print list -in kullanýcýs not Üye Olmaked anymveyae)
   'Generate messages from a file'
=> 'Generate messages from a file',
# Gener-dee messages -dan a Dosya
   'Generation'
=> 'Generation',
# Gener-deion
   'Go'
=> 'Go',

   'Go to ...'
=> 'Go to ...',
# Go -e ...
   'Group/Section'
=> 'Group/Section',
# GroYukarý/Bölüm
   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',
# HTML can be BütünoÇarþamba veya banned inside -Kursta tartýþmakion.
   'HTML in Discussions'
=> 'HTML in Discussions',
# HTML in tartýþmakions
   'HTML/XML'
=> 'HTML/XML',

   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Height(pixel):'
=> 'Height(pixel):',

   'Help on Creating Courses'
=> 'Help on Creating Courses',
# Yardým on CTekrar-deing kurss
   'Hide'
=> 'Hide',

   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',
# Hide Boþalt Satýrs in SpTekraradsheets
   'Hint Text'
=> 'Hint Text',

   'Home Server'
=> 'Home Server',
# Home Sunucu
   'Homework problem'
=> 'Homework problem',
# Homewveyak problem
   'How do I create a CSV file from a spreadsheet'
=> 'How do I create a CSV file from a spreadsheet',
# How do I Oluþtur a CSV Dosya -dan a spTekraradsheet
   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',
# How do I Oluþtur a class list -dan a spTekraradsheet
   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',
# How many Denemeler should be koymak fveya Bütün problems in the kurs?
   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',
# How many Denemeler should be koymak fveya the Seçed Dosya?
   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',
# How many Denemeler should be koymak fveya the Seçed problem?
   'How should the results be printed?'
=> 'How should the results be printed?',
# How should the Tekrarsults be printed?
   'ID/Student Number'
=> 'ID/Student Number',
# ID/ÖðTekrarnci Number
   'Identify fields'
=> 'Identify fields',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA.',
# If active, the new rol will be available when the ÖðTekrarncis Sonraki Oturum Aç -e LON-CAPA.
   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible.',
# If bu kaynak is in active use, ÖðTekrarnci perfveyamance d-dea -dan the pTekrarvious Versiyon Mayýs become inaccessible.
   'Ignore First Line'
=> 'Ignore First Line',
# Ignveyae First Line
   'Image:'
=> 'Image:',

   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',
# Immedi-deely expiTekrar own rol as kurs Coveyadin-deveya
   'Import and Paste Area'
=> 'Import and Paste Area',
# Impvey-de and Paste ATekrara
   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',
# Include Tekrartrieval -in ÖðTekrarnci pho-egraphs?
   'Incorrect Answers:'
=> 'Incorrect Answers:',
# IncveyaTekrarct Cevaplas:
   'Initial Password'
=> 'Initial Password',
# Initial Passwveyad
   'Institutional Information'
=> 'Institutional Information',
# Institutional Infveyam-deion
   'Internal Filename'
=> 'Internal Filename',
# Internal DosyaÝsim
   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',
# Invalid Significant figuTekrars detected
   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',
# Invalid characters in Tekrarquested Ýsim have been Tekrarmoved.
   'Invalid home server specified'
=> 'Invalid home server specified',
# Invalid home Sunucu specified
   'Invalid login mode or password.'
=> 'Invalid login mode or password.',
# Invalid login mode veya passwveyad.
   'Invalid username or domain'
=> 'Invalid username or domain',
# Invalid kullanýcýÝsim veya Alan
   'KEYWORDS'
=> 'KEYWORDS',
# KEYWveyaDS
   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default)',
# Keep Bütün kaynaklar Yukarý--e-d-dee with most Tekrarcent Versiyons (Eksiklik)
   'LON-CAPA Domain for Students'
=> 'LON-CAPA Domain for Students',
# LON-CAPA Alan fveya ÖðTekrarncis
   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager',
# LON-CAPA Üye OlmÖðleden öncent ÝTarihkrarr
   'LON-CAPA domain: [_1]'
=> 'LON-CAPA domain: [_1]',
# LON-CAPA Alan: [_1]
   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',
# LON-CAPA has live Sohbet functionality. bu kurs will Tekrarceive its own Sohbet room. You Mayýs deny ÖðTekrarncis, TAs, veya inyapýveyas the right -e access the Sohbet room.
   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',
# LON-CAPA Sunucus tartýþmakions on Bütün kaynaklar in a kurs. -tarafýndan Eksiklik, Bütün kullanýcýs aTekrar BütünoÇarþamba -e bölümicip-dee in these tartýþmakions. If you do not wish certain Tipis -in kullanýcýs -e be able -e use the tartýþmakion fe-deuTekrars, Seç those Tipis below. Note your class Mayýs not have Bütün -in these roller; you Mayýs safely ignveyae roller you do not intSon -e use. (Fveya instance, &quot;Exam Proctveya&quot; is Genelly useful only fveya large kurss.) Tipis -in kullanýcýs not BütünoÇarþamba -e bölümicip-dee in tartýþmakion can still Görünüm any tartýþmakion th-de other kullanýcýs post.
   'LaTeX batchmode'
=> 'LaTeX batchmode',
# L-deeX b-dechmode
   'LaTeX mode:'
=> 'LaTeX mode:',
# L-deeX mode:
   'Languages used'
=> 'Languages used',
# dils used
   'Last'
=> 'Last',

   'Last Name'
=> 'Last Name',
# Last Ýsim
   'Last Name, First Names'
=> 'Last Name, First Names',
# Last Ýsim, First Ýsims
   'Last accessed'
=> 'Last accessed',
# En son giriþed
   'Leave blank on scoring form'
=> 'Leave blank on scoring form',
# Leave blank on scveyaing fveyam
   'Librarian'
=> 'Librarian',

   'List Directory'
=> 'List Directory',
# List DiTekrarctveyay
   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',
# List -in hidden bölüms (hiddenbölüms)
   'Location'
=> 'Location',
# Loc-deion
   'Login Data'
=> 'Login Data',
# Login D-dea
   'Login Type'
=> 'Login Type',
# Login Tipi
   'Logout'
=> 'Logout',

   'Make new directory'
=> 'Make new directory',
# Make new diTekrarctveyay
   'Make new file'
=> 'Make new file',
# Make new Dosya
   'Making Backup to'
=> 'Making Backup to',
# Making BackYukarý -e
   'Manual Grading'
=> 'Manual Grading',
# Manual Basamak
   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',
# Harita has branchings. Use advanced düzenleveya.
   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',
# Harita has conditions. Use advanced düzenleveya.
   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',
# Harita has kaynak parameters. Use advanced düzenleveya.
   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',
# Harita has unconnected kaynaklar. Use advanced düzenleveya.
   'Max Number Of Shown Foils:'
=> 'Max Number Of Shown Foils:',
# Max Number -in Shown Önlemler:
   'Max number of foils displayed'
=> 'Max number of foils displayed',
# Max number -in Önlemler Görüntüleed
   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',
# Maximum Number -in Collabveya-deveyas
   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',
# Maximum Number -in Collabveya-deveyas (maxcollabveya-deveyas)
   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',
# Maximum Number -in Denemeler (maxDenemeler)
   'Messaging'
=> 'Messaging',

   'Metadata'
=> 'Metadata',
# Metad-dea
   'Metadata Version'
=> 'Metadata Version',
# Metad-dea Versiyon
   'Metadata current version'
=> 'Metadata current version',
# Metad-dea curTekrarnt Versiyon
   'Middle'
=> 'Middle',

   'Middle Name'
=> 'Middle Name',
# Middle Ýsim
   'Middle Names/Initials'
=> 'Middle Names/Initials',
# Middle Ýsims/Initials
   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',
# Missing Kerberos Alan infveyam-deion.
   'Modification may make assessment data inaccessible'
=> 'Modification may make assessment data inaccessible',
# Modific-deion Mayýs make Deðer d-dea inaccessible
   'Modify Enrollment for'
=> 'Modify Enrollment for',
# Modify Üye OlmÖðleden öncent fveya
   'Modify Parameters'
=> 'Modify Parameters',

   'Modify User'
=> 'Modify User',
# Modify kullanýcý
   'Modify another students data'
=> 'Modify another students data',
# Modify another ÖðTekrarncis d-dea
   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',
# Modify Son Teslim Tarihi, etc, fveya bu kaynak
   'Modify student data'
=> 'Modify student data',
# Modify ÖðTekrarnci d-dea
   'Modifying data for user'
=> 'Modifying data for user',
# Modifying d-dea fveya kullanýcý
   'Modifying this will make problems'
=> 'Modifying this will make problems',
# Modifying bu will make problems
   'Most recently published Version'
=> 'Most recently published Version',
# Most Tekrarcently Yayýnlandý Versiyon
   'Move current file to'
=> 'Move current file to',
# Move curTekrarnt Dosya -e
   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',
# Must Oluþtur new subdiTekrarctveyay inside a diTekrarctveyay
   'Name of Role'
=> 'Name of Role',
# Ýsim -in rol
   'Name:'
=> 'Name:',
# Ýsim:
   'New Directory'
=> 'New Directory',
# New DiTekrarctveyay
   'New HTML file'
=> 'New HTML file',
# New HTML Dosya
   'New Resource'
=> 'New Resource',
# New kaynak
   'New Role'
=> 'New Role',
# New rol
   'New User'
=> 'New User',
# New kullanýcý
   'New Value'
=> 'New Value',

   'New assembled page'
=> 'New assembled page',
# New assembled Sayfa
   'New assembled sequence'
=> 'New assembled sequence',
# New assembled sýra
   'New custom rights file'
=> 'New custom rights file',
# New cus-em rights Dosya
   'New file'
=> 'New file',
# New Dosya
   'New parameters or saved values'
=> 'New parameters or saved values',
# New parameters veya stveyaed values
   'New problem'
=> 'New problem',

   'New style file'
=> 'New style file',
# New style Dosya
   'New subdirectory'
=> 'New subdirectory',
# New subdiTekrarctveyay
   'Next    '
=> 'Next    ',
# Sonraki
   'No'
=> 'No',

   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',
# No Access veya Usages St-deistics aTekrar available fveya bu kaynak.
   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',
# No Deðer St-deistical D-dea is available fveya bu kaynak
   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',
# No Evalu-deion D-dea is available fveya bu kaynak.
   'No Kerberos domain was specified.'
=> 'No Kerberos domain was specified.',
# No Kerberos Alan was specified.
   'No language preference'
=> 'No language preference',
# No dil pTekrarfeTekrarnce
   'No new filename specified.'
=> 'No new filename specified.',
# No new DosyaÝsim specified.
   'No section assigned'
=> 'No section assigned',
# No Bölüm assigned
   'No such file'
=> 'No such file',
# No such Dosya
   'None Found'
=> 'None Found',

   'Not Allowed'
=> 'Not Allowed',
# Not BütünoÇarþamba
   'Not applicable - '
=> 'Not applicable - ',

   'Not open to be viewed'
=> 'Not open to be viewed',
# Not Aç -e be Görünümed
   'Not set - '
=> 'Not set - ',
# Not koymak -
   'Not shown, not used'
=> 'Not shown, not used',

   'Note: for large courses, this operation may be time consuming'
=> 'Note: for large courses, this operation may be time consuming',
# Note: fveya large kurss, bu oper-deion Mayýs be Zaman consuming
   'Note: this will not take effect if the user already exists'
=> 'Note: this will not take effect if the user already exists',
# Note: bu will not take effect if the kullanýcý alTekrarady exists
   'Notification of enrollment changes'
=> 'Notification of enrollment changes',
# Notific-deion -in Üye OlmÖðleden öncent changes
   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',
# Notific-deion -e kurs coveyadin-deveya via LON-CAPÖðleden öncessage when Üye OlmÖðleden öncent changes occur during the au-em-deed Yukarýd-dee?
   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',
# Number -in Denemeler befveyae hints appear (hintDenemeler)
   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',
# Number -in assignments printed -de the same Zaman:
   'Number of bubbles in exam mode (numbubbles)'
=> 'Number of bubbles in exam mode (numbubbles)',
# Number -in bubbles in exam mode (numbubbles)
   'Number of columns'
=> 'Number of columns',
# Number -in columns
   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',
# Numerical -elerance (-el)
   'Obsolete parameters or saved values'
=> 'Obsolete parameters or saved values',
# eskimiþ parameters veya stveyaed values
   'Old Value'
=> 'Old Value',

   'One particular problem (overrides folder and course defaults)'
=> 'One particular problem (overrides folder and course defaults)',
# One bölümicular problem (overrides Dosya and kurs Eksikliks)
   'Online Help'
=> 'Online Help',
# Online Yardým
   'Only Answers'
=> 'Only Answers',
# Only Cevaplas
   'Only domain coordinators can change a users password.'
=> 'Only domain coordinators can change a users password.',
# Only Alan coveyadin-deveyas can change a kullanýcýs passwveyad.
   'Open Course'
=> 'Open Course',
# Aç kurs
   'Open all assessments'
=> 'Open all assessments',
# Aç Bütün Deðers
   'Open and correct'
=> 'Open and correct',
# Aç and cveyaTekrarct
   'Open with full tries'
=> 'Open with full tries',
# Aç with full Denemeler
   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',
# Açing D-dee (conten-epen)
   'Opening Date (opendate)'
=> 'Opening Date (opendate)',
# Açing D-dee (Açd-dee)
   'Option response'
=> 'Option response',
# Option Tekrarsponse
   'Output Format: [_1]'
=> 'Output Format: [_1]',
# Çýktý Fveyam-de: [_1]
   'Page layout'
=> 'Page layout',
# Sayfa layout
   'Paper type'
=> 'Paper type',
# Paper Tipi
   'Parameter'
=> 'Parameter',

   'Part Description (display)'
=> 'Part Description (display)',
# bölüm Description (Görüntüle)
   'Paste after selected'
=> 'Paste after selected',
# Paste after Seçed
   'Personal Data'
=> 'Personal Data',
# Personal D-dea
   'Please adjust significant figures.'
=> 'Please adjust significant figures.',
# Please adjust significant figuTekrars.
   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',
# Please Seçme the Eksiklik auSonratic-deion method -e be used -tarafýndan new kullanýcýs added -e bu LON-CAPA Alan -tarafýndan the au-em-deed Üye OlmÖðleden öncent process
   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',
# Please click Back on your bSatýrser and Seçnother kullanýcý, veya
   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',
# Please Baðlantý your LON-CAPA Öðleden öncenistr-deveya Tekrargarding bu situ-deion.
   'Please do not reply to this address.'
=> 'Please do not reply to this address.',
# Please do not Cevap Ver -e bu addTekrarss.
   'Please select a report to generate'
=> 'Please select a report to generate',
# Please Seç Tekrarpvey-de -e gener-dee
   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',
# Please Seçn auSonratic-deion mechanism
   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',
# Please Seç the auSonratic-deion mechanism
   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',
# Please Seç the Bölüm you wish -e koymak the Cevapla Aç d-dee fveya:
   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',
# Please Seç the Bölüm you wish -e koymak the Yeterli d-dee fveya:
   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',
# Please Seç the Bölüm you wish -e koymak the number -in Denemeler fveya:
   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',
# Please Seç the Bölüm you wish -e koymak the Açing d-dee fveya:
   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',
# Please Seç the Bölüm you wish -e koymak the problem weight fveya:
   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',
# Please Seç the ÖðTekrarnci you wish -e koymak the Cevapla Aç d-dee fveya:
   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',
# Please Seç the ÖðTekrarnci you wish -e koymak the Yeterli d-dee fveya:
   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',
# Please Seç the ÖðTekrarnci you wish -e koymak the number -in Denemeler fveya:
   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',
# Please Seç the ÖðTekrarnci you wish -e koymak the Açing d-dee fveya:
   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',
# Please Seç the ÖðTekrarnci you wish -e koymak the problem weight fveya:
   'Please stand by.'
=> 'Please stand by.',
# Please stand -tarafýndan.
   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",
# Please use bSatýrser 'Back' but-en and pick a DosyaÝsim
   'Position'
=> 'Position',

   'Preferred language'
=> 'Preferred language',
# PTekrarferTekrard dil
   'Preparing Printout'
=> 'Preparing Printout',
# PTekrarparing çýktý Öðleden öncek
   'Print'
=> 'Print',

   'Print Index:'
=> 'Print Index:',

   'Print Table of Contents:'
=> 'Print Table of Contents:',
# Print Table -in Ýçerik:
   'Print:'
=> 'Print:',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',
# Privileged kullanýcýs th-de should not be hidden on staff listings
   'Problems'
=> 'Problems',

   'Problems from entire course'
=> 'Problems from entire course',
# problems -dan entiTekrar kurs
   'Processed [_1] student(s).'
=> 'Processed [_1] student(s).',
# Processed [_1] ÖðTekrarnci(s).
   'Processed file'
=> 'Processed file',
# Processed Dosya
   'Produce Excel Output'
=> 'Produce Excel Output',
# Produce Excel Çýktý
   'Publish this Resource'
=> 'Publish this Resource',
# Yayýnlama bu kaynak
   'Question Text'
=> 'Question Text',

   'Question Type'
=> 'Question Type',
# Question Tipi
   'Question Type (type)'
=> 'Question Type (type)',
# Question Tipi (Tipi)
   'Random position'
=> 'Random position',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',
# Random seed fveya randomly picking number -in kaynaklar (optional, only koymak if you know wh-de you aTekrar doing) (randompickseed)
   'Randomization algorithm used'
=> 'Randomization algorithm used',
# Randomiz-deion algveyaithm used
   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',
# Randomly pick number -in kaynaklar (randompick)
   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data.',
# Tekrar-Üye OlmÖðleden öncent will Tekrar-activ-dee d-dea.
   'Reading results from [_1]'
=> 'Reading results from [_1]',
# Okuma alanýndan sonuçlar  [_1]
   'Receipt algorithm used'
=> 'Receipt algorithm used',
# Tekrarceipt algveyaithm used
   'Receiving results from [_1]'
=> 'Receiving results from [_1]',
# Tekrarceiving Tekrarsults -dan [_1]
   'Recent'
=> 'Recent',
# Tekrarcent
   'Registering'
=> 'Registering',
# Tekrargistering
   'Rename current file to'
=> 'Rename current file to',
# Yeniden Adlandýr curTekrarnt Dosya -e
   'Report a Bug'
=> 'Report a Bug',
# Tekrarpvey-de a Bug
   'Resource'
=> 'Resource',
# kaynak
   'Resource Differences'
=> 'Resource Differences',
# kaynak DifferTekrarnzen
   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',
# kaynak Hidden -dan ÖðTekrarncis (hiddenkaynak)
   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',
# kaynak alias Ýsim fveya conditions (Haritaalias)
   'Resources'
=> 'Resources',
# kaynaklar
   'Resources from selected sequence in course'
=> 'Resources from selected sequence in course',
# kaynaklar -dan Seçed sýra Kursta
   'Response'
=> 'Response',
# Tekrarsponse
   'Retrieve Old Version'
=> 'Retrieve Old Version',
# Düzeltmek Old Versiyon
   'Retrieve Published Resources'
=> 'Retrieve Published Resources',
# Düzeltmek Yayýnlandý kaynaklar
   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',
# Tekrartrieving curTekrarnt (most Tekrarcent) Versiyon
   'Return to DOCS'
=> 'Return to DOCS',
# Tekrarturn -e dökümanlar
   'Reverse Association'
=> 'Reverse Association',
# Tekrarverse Associ-deion
   'Revoke'
=> 'Revoke',
# Tekrarvoke
   'Revoke Existing Roles'
=> 'Revoke Existing Roles',
# Tekrarvoke Existing roller
   'Role'
=> 'Role',
# rol
   'Role Information'
=> 'Role Information',
# rol Infveyam-deion
   'Sample Points:'
=> 'Sample Points:',

   'Samples'
=> 'Samples',

   'Save as ...'
=> 'Save as ...',
# Farklý Kaydet ...
   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',
# Kaydet Sonenemeler below as a draft Cevapla (not Gönderting them fveya crdüzenle yet)
   'Search Complete [_1]'
=> 'Search Complete [_1]',
# aramak Complete [_1]
   'Search: [_1]'
=> 'Search: [_1]',
# aramak: [_1]
   'Select Action'
=> 'Select Action',
# Seçction
   'Select All Files'
=> 'Select All Files',
# Seç Bütün Dosyas
   'Select All Published'
=> 'Select All Published',
# Seç Bütün Yayýnlandý
   'Select All Resources'
=> 'Select All Resources',
# Seç Bütün kaynaklar
   'Select Folder'
=> 'Select Folder',
# Seç Dosya
   'Select Only Current Students'
=> 'Select Only Current Students',
# Seç Only CurTekrarnt ÖðTekrarncis
   'Select Printing Options:'
=> 'Select Printing Options:',
# Seç Printing Options:
   'Select Problem'
=> 'Select Problem',
# Seç problem
   'Select Problem(s) to print'
=> 'Select Problem(s) to print',
# Seç problem(s) -e print
   'Select Resource(s) to print'
=> 'Select Resource(s) to print',
# Seç kaynak(s) -e print
   'Select Resources To Print'
=> 'Select Resources To Print',
# Seç kaynaklar -e Print
   'Select Section'
=> 'Select Section',
# Seç Bölüm
   'Select Sequence To Print From'
=> 'Select Sequence To Print From',
# Seç sýra -e Print -dan
   'Select Student'
=> 'Select Student',
# Seç ÖðTekrarnci
   'Select Students and Resources'
=> 'Select Students and Resources',
# Seç ÖðTekrarncis and kaynaklar
   'Select Style File'
=> 'Select Style File',
# Seç Style Dosya
   'Select a user name to modify the students information'
=> 'Select a user name to modify the students information',
# Seç kullanýcý Ýsim -e modify the ÖðTekrarncis infveyam-deion
   'Select a user name to view the users personal page.'
=> 'Select a user name to view the users personal page.',
# Seç kullanýcý Ýsim -e Görünüm the kullanýcýs personal Sayfa.
   'Select for Section/Group'
=> 'Select for Section/Group',
# Seç fveya Bölüm/GroYukarý
   'Select resources for the assignment'
=> 'Select resources for the assignment',
# Seç kaynaklar fveya the assignment
   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',
# Seç the Dosya you wish -e koymak the parameter fveya:
   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',
# Seç the problem you wish -e koymak the parameter fveya:
   'Set'
=> 'Set',
# koymak
   'Set Course Environment'
=> 'Set Course Environment',
# koymak kurs Environment
   'Set End Date'
=> 'Set End Date',
# koymak Son D-dee
   'Set Individual User Roles'
=> 'Set Individual User Roles',
# koymak Individual kullanýcý roller
   'Set Problem Tries'
=> 'Set Problem Tries',
# koymak problem Denemeler
   'Set Problem Weight'
=> 'Set Problem Weight',
# koymak problem Weight
   'Set Start Date'
=> 'Set Start Date',
# koymak Baþla D-dee
   'Set Version to be used in Course'
=> 'Set Version to be used in Course',
# koymak Versiyon -e be used Kursta
   'Set Versions to be used in Course according to Selections below'
=> 'Set Versions to be used in Course according to Selections below',
# koymak Versiyons -e be used Kursta accveyading -e Seçions below
   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions)',
# koymak Bütün kaynak Versiyons -e curTekrarnt Versiyon (Fix Versiyons)
   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',
# koymak Cevapla Aç d-dee fveya Bütün problems in the kurs fveya ...
   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',
# koymak Cevapla Aç d-dee fveya the Seçed Dosya fveya ...
   'Set answer open date for the selected problem for ...'
=> 'Set answer open date for the selected problem for ...',
# koymak Cevapla Aç d-dee fveya the Seçed problem fveya ...
   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',
# koymak content geri bildirim -e kurs Coveyadin-deveya
   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',
# koymak kurs policy geri bildirim -e kurs Coveyadin-deveya
   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',
# koymak Yeterli d-dee fveya Bütün problems in the kurs fveya ...
   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',
# koymak Yeterli d-dee fveya the Seçed Dosya fveya ...
   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',
# koymak Yeterli d-dee fveya the Seçed problem fveya ...
   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',
# koymak number -in Denemeler fveya Bütün problems in the kurs fveya ...
   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',
# koymak number -in Denemeler fveya the Seçed Dosya fveya ...
   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',
# koymak number -in Denemeler fveya the Seçed problem fveya ...
   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',
# koymak Açing d-dee fveya Bütün problems in the kurs fveya ...
   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',
# koymak Açing d-dee fveya Bütün problems in the kurs fveya. . .
   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',
# koymak Açing d-dee fveya the Seçed Dosya fveya ...
   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',
# koymak Açing d-dee fveya the Seçed problem fveya ...
   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',
# koymak problem weight fveya Bütün problems in the kurs fveya ...
   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',
# koymak problem weight fveya the Seçed Dosya fveya ...
   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',
# koymak problem weight fveya the Seçed problem fveya ...
   'Set to ...'
=> 'Set to ...',
# koymak -e ...
   'Set value to "[_1]" to allow'
=> 'Set value to "[_1]" to allow',
# koymak value -e "[_1]" -e Bütünow
   'Setting the [_1]'
=> 'Setting the [_1]',
# koymakting the [_1]
   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',
# koymakting the [_1] -e [_2]
   'Short string response'
=> 'Short string response',
# Shvey-de string Tekrarsponse
   'Show Answer'
=> 'Show Answer',
# Show Cevapla
   'Show Feedback'
=> 'Show Feedback',
# Show geri bildirim
   'Show Preview'
=> 'Show Preview',
# Show PTekrarGörünüm
   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',
# Show problem St-deus (problemst-deus)
   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',
# Show Units - Disable Entry (turn-infunit)
   'Show always at bottom position'
=> 'Show always at bottom position',
# Show always -de bot-em position
   'Show always at top position'
=> 'Show always at top position',
# Show always -de -ep position
   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Simple Edit'
=> 'Simple Edit',
# Simple düzenle
   'Size:'
=> 'Size:',
# Boyut:
   'Some items were not submitted'
=> 'Some items were not submitted',
# Some items weTekrar not Gönderted
   'Space separated'
=> 'Space separated',
# boþluk separ-deed
   'Start Time'
=> 'Start Time',
# Baþla Zaman
   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",
# Baþla each ÖðTekrarnci's assignment on a new Sayfa/column (add a Sayfafeed after each assignment)
   'Starting Date'
=> 'Starting Date',
# Baþlýyor D-dee
   'Starting and Ending Dates'
=> 'Starting and Ending Dates',
# Baþlýyor and Soning D-dees
   'Save Changes'
=> 'Save Changes',
# Stveyae Changes
   'Student ID'
=> 'Student ID',
# ÖðTekrarnci ID
   'Student Information'
=> 'Student Information',
# ÖðTekrarnci Infveyam-deion
   'Student Name'
=> 'Student Name',
# ÖðTekrarnci Ýsim
   'Student Number'
=> 'Student Number',
# ÖðTekrarnci Number
   'Student Sheet Links'
=> 'Student Sheet Links',
# ÖðTekrarnci Sheet Links
   'Student Status'
=> 'Student Status',
# ÖðTekrarnci St-deus
   'Student Status: [_1]'
=> 'Student Status: [_1]',
# ÖðTekrarnci St-deus: [_1]
   'Student information updated successfully.'
=> 'Student information updated successfully.',
# ÖðTekrarnci infveyam-deion Yukarýd-deed successfully.
   'Students need access key to enter course'
=> 'Students need access key to enter course',
# ÖðTekrarncis need access key -e Giriþ kurs
   'Students with expired roles'
=> 'Students with expired roles',
# ÖðTekrarncis with expiTekrard roller
   'Subject:'
=> 'Subject:',
# konu:
   'Submission Time Analysis'
=> 'Submission Time Analysis',
# Submission Zaman Analysis
   'Submissions'
=> 'Submissions',
# Submisyonlar
   'Submit Changes and Edit'
=> 'Submit Changes and Edit',
# Deðiþiklikleri sunmak and düzenle
   'Submit Modifications'
=> 'Submit Modifications',
# Gönder Modific-deions
   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',
# Gönder Sonenemeler below as Cevapla -e Tekrarceive crdüzenle
   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',
# SÇarþambaish Chef
   'System Level'
=> 'System Level',
# Sistem Level
   'Tabulator separated'
=> 'Tabulator separated',
# Tabul-deveya separ-deed
   'Target Edit Map'
=> 'Target Edit Map',
# Hedef düzenle Harita
   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',
# TeX unconverted Yeterli -e errveyas
   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',
# TeX unconverted Yeterli -e pTekrarvious errveyas
   'TeXWidth(mm):'
=> 'TeXWidth(mm):',

   'Text'
=> 'Text',

   'Text Block'
=> 'Text Block',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.',
# The &quot;kurs Description&quot; is the Ýsim -in the kurs th-de will be seen -tarafýndan the ÖðTekrarncis. You Mayýs now modify the description and hit &quot;Sonraki -&gt;&quot; -e continue.
   'The error reported was'
=> 'The error reported was',
# The errveya Tekrarpvey-deed was
   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',
# The following Sonenemeler will be used -e identify the kurs accveyading -e the naming scheme adopted -tarafýndan your institution. Your choices will be used -e Harita an internal LON-CAPA kurs ID -e the cveyaTekrarsponding kurs Bölüm ID(s) used -tarafýndan the -infice Tekrarsponsible fveya providing -inficial class lists fveya kurss -de your institution. bu Haritaping is TekrarquiTekrard if you Seçme -e employ au-em-deic popul-deion -in class lists.
   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",
# The following koymaktings control au-em-deic Üye OlmÖðleden öncent -in ÖðTekrarncis in bu class based on infveyam-deion available fveya bu specific kurs -dan your institution's -inficial classlists.
   'The optional email address field was not specified.'
=> 'The optional email address field was not specified.',
# The optional ePosta addTekrarss field was not specified.
   'The optional name field was not specified.'
=> 'The optional name field was not specified.',
# The optional Ýsim field was not specified.
   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified.',
# The optional Bölüm veya groYukarý field was not specified.
   'The optional student number field was not specified.'
=> 'The optional student number field was not specified.',
# The optional ÖðTekrarnci number field was not specified.
   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',
# The question can not be gotten cveyaTekrarct, the following Önlemler in the &lt;optionTekrarsponse&gt; have invalid cveyaTekrarct options
   'The requested file'
=> 'The requested file',
# The Tekrarquested Dosya
   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',
# The ÖðTekrarnci must log out and Tekrar baðlan -e see these changes.
   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',
# TheTekrar aTekrar curTekrarntly no ErrveyÖðleden öncessages fveya bu kaynak.
   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',
# TheTekrar aTekrar no Evalu-deion Comments on bu kaynak.
   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',
# TheTekrar aTekrar no curTekrarntly Üye Olmaked ÖðTekrarncis in the kurs.
   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',
# TheTekrar aTekrar no curTekrarntly Üye Olmaked ÖðTekrarncis in the Seçed Bölümler.
   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',
# TheTekrar aTekrar no pTekrarviously Üye Olmaked ÖðTekrarncis in the kurs.
   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',
# TheTekrar aTekrar no pTekrarviously Üye Olmaked ÖðTekrarncis in the Seçed Bölümler.
   'There are no students currently enrolled.'
=> 'There are no students currently enrolled.',
# TheTekrar aTekrar no ÖðTekrarncis curTekrarntly Üye Olmaked.
   'There are no students in the course.'
=> 'There are no students in the course.',
# TheTekrar aTekrar no ÖðTekrarncis in the kurs.
   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',
# TheTekrar aTekrar no ÖðTekrarncis in the Seçed Bölümler.
   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',
# TheTekrar was an errveya determining the environment values fveya
   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',
# bu controls how Tekrarceipt numbers aTekrar gener-deed.
   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',
# bu Yardýmer will koymak Yukarý your LON-CAPA kurs and Seçme which fe-deuTekrars will be active.
   'This is an automatic message generated by the LON-CAPA system.'
=> 'This is an automatic message generated by the LON-CAPA system.',
# bu is an au-em-deic message gener-deed -tarafýndan the LON-CAPA Sistem.
   'Threaded View'
=> 'Threaded View',
# ThTekraraded Görünüm
   'To create a new'
=> 'To create a new',
# -e Oluþtur a new
   'Top Level Map'
=> 'Top Level Map',
# -ep Level Harita
   'Total number of records found in file: [_1].'
=> 'Total number of records found in file: [_1].',
# Tüm number -in Tekrarcveyads found in Dosya: [_1].
   'True'
=> 'True',

   'Type Name Here'
=> 'Type Name Here',
# Tipi Ýsim HeTekrar
   'Type in value'
=> 'Type in value',
# Tipi in value
   'Type-in value'
=> 'Type-in value',
# Tipi-in value
   'Type:'
=> 'Type:',
# Tipi:
   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',
# UNGörüntüleABLE
   'Unable to enroll'
=> 'Unable to enroll',
# Unable -e Üye Olmak
   'Unable to enroll students'
=> 'Unable to enroll students',
# Unable -e Üye Olmak ÖðTekrarncis
   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',
# Unable -e Yayýnlama Dosya, it contains dYukarýlic-deed ID(s), ID(s) need -e be unique. The dYukarýlic-deed ID(s) aTekrar
   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',
# Unable -e Düzeltmek environment d-dea fveya
   'Unable to set default dates for course'
=> 'Unable to set default dates for course',
# Unable -e koymak Eksiklik d-dees fveya kurs
   'Unavailable course'
=> 'Unavailable course',
# Unavailable kurs
   'Unit:'
=> 'Unit:',

   'Unknown Action'
=> 'Unknown Action',

   'Unselect All Files'
=> 'Unselect All Files',
# UnSeç Bütün Dosyas
   'Unselect All Published'
=> 'Unselect All Published',
# UnSeç Bütün Yayýnlandý
   'Unselect All Resources'
=> 'Unselect All Resources',
# UnSeç Bütün kaynaklar
   'Unselect for Section/Group'
=> 'Unselect for Section/Group',
# UnSeç fveya Bölüm/GroYukarý
   'Updating discussion time'
=> 'Updating discussion time',
# Yukarýd-deing tartýþmakion Zaman
   'Upload file'
=> 'Upload file',
# YukarýYükleme Dosya
   'Upload file to Authoring Space'
=> 'Upload file to Authoring Space',
# YukarýYükleme Dosya -e Conyapýion boþluk
   'Uploading Class List'
=> 'Uploading Class List',
# YukarýYüklemeing Class List
   'VIEW'
=> 'VIEW',
# Görünüm
   'Value'
=> 'Value',

   'Verify Content'
=> 'Verify Content',

   'Version changes since Yesterday'
=> 'Version changes since Yesterday',
# Versiyon changes since Evetterday
   'Version changes since last Month'
=> 'Version changes since last Month',
# Versiyon changes since Geçen Ay
   'Version changes since last Week'
=> 'Version changes since last Week',
# Versiyon changes since Geçen Hafta
   'Version changes since start of Course'
=> 'Version changes since start of Course',
# Versiyon changes since Baþla -Kursta
   'Version used in Course'
=> 'Version used in Course',
# Versiyon used Kursta
   'View Class List'
=> 'View Class List',
# Görünüm Class List
   'View the FAQ'
=> 'View the FAQ',
# Görünüm the FAQ
   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',
# Visibly Separ-dee Items on sayfalar
   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',
# WARNING: The metad-dea table does not exist in the LON-CAPA d-deabase.
   'Warning!'
=> 'Warning!',

   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',
# Warning: change -in MIME Tipi!
   'Warning: target file exists!'
=> 'Warning: target file exists!',
# Warning: Hedef Dosya exists!
   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',
# Warning: Hedef Dosya exists, and has been Yayýnlandý!
   'Weight (weight)'
=> 'Weight (weight)',

   'Welcome'
=> 'Welcome',

   'Welcome to Your New LON-CAPA Course'
=> 'Welcome to Your New LON-CAPA Course',
# Welcome -e Your New LON-CAPA kurs
   'Welcome to the Learning[_1]Online[_2] Network with CAPA. Please wait while your session is being set up'
=> 'Welcome to the Learning[_1]Online[_2] Network with CAPA. Please wait while your session is being set up',
# Welcome -e the Learning[_1]Online[_2] Netwveyak with CAPA. Please wait while your session is being koymak Yukarý
   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',
# Wh-de parameter do you want -e koymak fveya the Seçed Dosya?
   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',
# Wh-de parameter do you want -e koymak fveya the Seçed problem?
   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',
# Wh-de should the Cevapla Aç d-dee be koymak -e?
   'What should the due date be set to?'
=> 'What should the due date be set to?',
# Wh-de should the Yeterli d-dee be koymak -e?
   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',
# Wh-de weight should be koymak fveya Bütün problems in the kurs?
   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',
# Wh-de weight should be koymak fveya the Seçed Dosya?
   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',
# Wh-de weight should be koymak fveya the Seçed problem?
   'Width'
=> 'Width',

   'Width(pixel):'
=> 'Width(pixel):',

   'With Answers'
=> 'With Answers',
# With Cevaplas
   'Without Answers'
=> 'Without Answers',
# Without Cevaplas
   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',
# You aTekrar wveyaking with an unKaydetd Versiyon -in your Harita.
   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',
# You changed the ÖðTekrarncis id but did not disable the ID change safeguard. The ÖðTekrarncis id will not be changed.
   'You must choose an authentication type.'
=> 'You must choose an authentication type.',
# You must Seçme an auSonratic-deion Tipi.
   'You need to specify the Kerberos domain.'
=> 'You need to specify the Kerberos domain.',
# You need -e specify the Kerberos Alan.
   'You need to specify the initial password.'
=> 'You need to specify the initial password.',
# You need -e specify the initial passwveyad.
   'You need to specify the username field.'
=> 'You need to specify the username field.',
# You need -e specify the kullanýcýÝsim field.
   'Your Version Settings have been Saved'
=> 'Your Version Settings have been Saved',
# Your Versiyon koymaktings have been Stveyaed
   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',
# Your Tekrarquest -e change the rol infveyam-deion fveya bu ÖðTekrarnci was Tekrarfused. You do not appear -e have sufficient authveyaity -e change ÖðTekrarnci infveyam-deion.
   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',
# [_1] (wh-de you just saw on the scTekraren)
   '[_1] Do not change login data'
=> '[_1] Do not change login data',
# [_1] Do not change login d-dea
   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2])',
# [_1] DosyaSistem AuSonratic-deed (with initial passwveyad [_2])
   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Internally authenticated (with initial password [_2])',
# [_1] InternBütüny auSonratic-deed (with initial passwveyad [_2])
   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5',
# [_1] Kerberos auSonratic-deed with Alan [_2] [_3] Versiyon 4 [_4] Versiyon 5
   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local Authentication with arguement [_2]',
# [_1] Local AuSonratic-deion with arguement [_2]
   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',
# [_1] Local AuSonratic-deion with argument [_2]
   '[_1] Records per Page'
=> '[_1] Records per Page',
# [_1] Tekrarcveyads Sayfada
   '[_1] minutes'
=> '[_1] minutes',
# [_1] Dakikalar
   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',
# [_1] Dakikalar, [_2] Saniyeler
   '[_1] with value [_2]'
=> '[_1] with value [_2]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# [_1]pTekrarv[_2] &nbsp; [_3]TekrarYükleme[_4] &nbsp; [_5]Sonraki[_6]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',
# [_1]pTekrarv[_2] &nbsp; [_3]TekrarYükleme[_4] &nbsp; Sonraki
   '[_2] seconds'
=> '[_2] seconds',
# [_2] Saniyeler
   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',
# a comma separ-deed list -Kursta Bölümler crosslisted with the curTekrarnt kurs, with each entry including the institutional kurs Bölüm Ýsim folloÇarþamba -tarafýndan a colon and Sonra the (optional) groYukarýID -e be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2
   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',
# a comma separ-deed list -in institutional Bölüm numbers, each separ-deed -tarafýndan a colon -dan the (optional) cveyaTekrarsponding Bölüm/groYukarý ID -e be used in LON-CAPA e.g., 001:1,002:2
   'acc keys[_1]'
=> 'acc keys[_1]',
# Eriþim tuþlarý[_1]
   'after selected'
=> 'after selected',
# after Seçed
   'all resources in the course'
=> 'all resources in the course',
# Bütün kaynaklar in the kurs
   'all students in course'
=> 'all students in course',
# Bütün ÖðTekrarncis Kursta
   'and'
=> 'and',

   'anno-[_1]'
=> 'anno-[_1]',
# bemerk-[_1]
   'announce[_1]'
=> 'announce[_1]',
# Ýlan etmek[_1]
   'anonymous'
=> 'anonymous',

   'anonymous students'
=> 'anonymous students',
# anonymous ÖðTekrarncis
   'answer date'
=> 'answer date',
# Cevapla d-dee
   'backward[_1]'
=> 'backward[_1]',
# geri[_1]
   'between'
=> 'between',

   'bookmark[_1]'
=> 'bookmark[_1]',
# ayýraç[_1]
   'bookmark[_2]'
=> 'bookmark[_2]',
# ayýraç[_2]
   'button'
=> 'button',
# but-en
   'by'
=> 'by',
# -tarafýndan
   'bytes'
=> 'bytes',
# -tarafýndantes
   'calendar[_1]'
=> 'calendar[_1]',
# Takvim[_1]
   'catalog[_1]'
=> 'catalog[_1]',
# k-dealog[_1]
   'changes will not show until next login'
=> 'changes will not show until next login',
# changes will not show until Sonraki login
   'chart[_1]'
=> 'chart[_1]',
# Grafik[_1]
   'chat[_1]'
=> 'chat[_1]',
# Sohbet[_1]
   'check all'
=> 'check all',
# check Bütün
   'chmod error'
=> 'chmod error',
# chmod errveya
   'choose[_1]'
=> 'choose[_1]',
# Seçme[_1]
   'choose[_2]'
=> 'choose[_2]',
# Seçme[_2]
   'click on the'
=> 'click on the',

   'co con-[_1]'
=> 'co con-[_1]',

   'co res[_1]'
=> 'co res[_1]',
# co Tekrars[_1]
   'commu-[_1]'
=> 'commu-[_1]',
# komü-[_1]
   'con-[_1]'
=> 'con-[_1]',

   'contacting [_1]'
=> 'contacting [_1]',
# baðlantý [_1]
   'contents[_1]'
=> 'contents[_1]',
# Ýçerik[_1]
   'copy Error'
=> 'copy Error',
# copy Errveya
   'course[_10]'
=> 'course[_10]',
# kurs[_10]
   'course[_11]'
=> 'course[_11]',
# kurs[_11]
   'course[_1]'
=> 'course[_1]',
# kurs[_1]
   'course[_2]'
=> 'course[_2]',
# kurs[_2]
   'course[_3]'
=> 'course[_3]',
# kurs[_3]
   'course[_4]'
=> 'course[_4]',
# kurs[_4]
   'course[_5]'
=> 'course[_5]',
# kurs[_5]
   'course[_6]'
=> 'course[_6]',
# kurs[_6]
   'course[_7]'
=> 'course[_7]',
# kurs[_7]
   'course[_8]'
=> 'course[_8]',
# kurs[_8]
   'course[_9]'
=> 'course[_9]',
# kurs[_9]
   'create[_1]'
=> 'create[_1]',
# Oluþtur[_1]
   'currently does not exist'
=> 'currently does not exist',
# curTekrarntly does not exist
   'custom'
=> 'custom',
# cus-em
   'custom distribution file'
=> 'custom distribution file',
# cus-em distribution Dosya
   'discuss[_1]'
=> 'discuss[_1]',
# tartýþmak[_1]
   'docs[_1]'
=> 'docs[_1]',
# dökümanlar[_1]
   'docs[_2]'
=> 'docs[_2]',
# dökümanlar[_2]
   'domain'
=> 'domain',
# Alan
   'due date'
=> 'due date',
# Yeterli d-dee
   'edit crs[_1]'
=> 'edit crs[_1]',
# crs düzenleör[_1]
   'ences[_1]'
=> 'ences[_1]',
# Tekrarnzen[_1]
   'enroll[_1]'
=> 'enroll[_1]',
# Üye Olmak[_1]
   'enter[_1]'
=> 'enter[_1]',
# Giriþ[_1]
   'evaluate[_1]'
=> 'evaluate[_1]',
# deðerlSonirmek[_1]
   'exit[_1]'
=> 'exit[_1]',
# Çýkýþ[_1]
   'expired or revoked'
=> 'expired or revoked',
# expiTekrard veya Tekrarvoked
   'extension'
=> 'extension',

   'external'
=> 'external',

   'feedback[_1]'
=> 'feedback[_1]',
# geri bildirim[_1]
   'file<br />extension'
=> 'file<br />extension',
# Dosya<br />extension
   'first name'
=> 'first name',
# first Ýsim
   'for'
=> 'for',
# fveya
   'for <b>all resources in the course</b>'
=> 'for <b>all resources in the course</b>',
# fveya <b>Bütün kaynaklar in the kurs</b>
   'for <b>all students in course</b>'
=> 'for <b>all students in course</b>',
# fveya <b>Bütün ÖðTekrarncis Kursta</b>
   'for [_1]'
=> 'for [_1]',
# fveya [_1]
   'for section [_1]'
=> 'for section [_1]',
# fveya Bölüm [_1]
   'for the map named [_1]'
=> 'for the map named [_1]',
# fveya the Harita Ýsimd [_1]
   'for the resource named [_1]'
=> 'for the resource named [_1]',
# fveya the kaynak Ýsimd [_1]
   'for visible separation'
=> 'for visible separation',
# fveya visible separ-deion
   'forward[_1]'
=> 'forward[_1]',
# fveyaward[_1]
   'from'
=> 'from',
# -dan
   'from current subdirectory'
=> 'from current subdirectory',
# -dan curTekrarnt subdiTekrarctveyay
   'generation'
=> 'generation',
# gener-deion
   'grades[_1]'
=> 'grades[_1]',
# DeTekrarce[_1]
   'grades[_2]'
=> 'grades[_2]',
# DeTekrarce[_2]
   'have different numbers and answers'
=> 'have different numbers and answers',
# have diffeTekrarnt numbers and Cevaplas
   'helper'
=> 'helper',
# Yardýmer
   'htmlarea_lang'
=> 'htmlarea_lang',
# HTMLaTekrara_lang
   'in'
=> 'in',

   'in domain'
=> 'in domain',
# in Alan
   'instructor'
=> 'instructor',
# inyapýveya
   'internal'
=> 'internal',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',
# is in bu st-dee -tarafýndan royal decTekrare.
   'is ready for download'
=> 'is ready for download',
# is Tekrarady fveya downYükleme
   'last name'
=> 'last name',
# last Ýsim
   'library[_1]'
=> 'library[_1]',
# kütüphane[_1]
   'loginproblems.html'
=> 'loginproblems.html',

   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',
# make these d-dees the Eksiklik fveya futuTekrar Üye OlmÖðleden öncent
   'manage[_1]'
=> 'manage[_1]',
# ÝTarihkrar[_1]
   'middle name'
=> 'middle name',
# middle Ýsim
   'most recent'
=> 'most recent',
# most Tekrarcent
   'my[_1]'
=> 'my[_1]',
# benim[_1]
   'name'
=> 'name',
# Ýsim
   'name only visible to course faculty'
=> 'name only visible to course faculty',
# Ýsim only visible -e kurs faculty
   'navigate[_1]'
=> 'navigate[_1]',
# YönlSonirmek[_1]
   'nication[_1]'
=> 'nication[_1]',
# nikasyon[_1]
   'no ending date'
=> 'no ending date',
# no Soning d-dee
   'number'
=> 'number',

   'number of tries'
=> 'number of tries',
# number -in Denemeler
   'obsolete replacement'
=> 'obsolete replacement',
# eskimiþ Tekrarplacement
   'only check if you know what you are doing'
=> 'only check if you know what you are doing',
# only check if you know wh-de you aTekrar doing
   'only search domain'
=> 'only search domain',
# only aramak Alan
   'opening date'
=> 'opening date',
# Açing d-dee
   'optional'
=> 'optional',

   'or any other value'
=> 'or any other value',
# veya any other value
   'parms[_1]'
=> 'parms[_1]',
# pÖðleden önce[_1]
   'prefer-[_1]'
=> 'prefer-[_1]',
# tercih-[_1]
   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# pTekrarv &nbsp; [_3]TekrarYükleme[_4] &nbsp; [_5]Sonraki[_6]
   'private'
=> 'private',
# priv-dee
   'problem weight'
=> 'problem weight',

   'public'
=> 'public',

   'publisher<br />owner'
=> 'publisher<br />owner',
# Yayýnlamaer<br />owner
   'resource[_1]'
=> 'resource[_1]',
# kaynak[_1]
   'role,role,...'
=> 'role,role,...',
# rol,rol,...
   'role[_1]'
=> 'role[_1]',
# rol[_1]
   'role[_2]'
=> 'role[_2]',
# rol[_2]
   'roles[_1]'
=> 'roles[_1]',
# roller[_1]
   'search[_1]'
=> 'search[_1]',
# aramak[_1]
   'search[_2]'
=> 'search[_2]',
# aramak[_2]
   'section'
=> 'section',
# Bölüm
   'selected students'
=> 'selected students',
# Seçed ÖðTekrarncis
   'send[_1]'
=> 'send[_1]',
# sSon[_1]
   'set[_1]'
=> 'set[_1]',
# koymak[_1]
   'space[_1]'
=> 'space[_1]',
# boþluk[_1]
   'space[_2]'
=> 'space[_2]',
# boþluk[_2]
   'spellcheck_lang'
=> 'spellcheck_lang',

   'standard'
=> 'standard',

   'standard LaTeX mode'
=> 'standard LaTeX mode',
# standard L-deeX mode
   'standard courses only'
=> 'standard courses only',
# standard kurss only
   'stats[_1]'
=> 'stats[_1]',
# st-des[_1]
   'struct[_1]'
=> 'struct[_1]',
# yapý[_1]
   'struct[_2]'
=> 'struct[_2]',
# yapý[_2]
   'student'
=> 'student',
# ÖðTekrarnci
   'student name'
=> 'student name',
# ÖðTekrarnci Ýsim
   'switch[_1]'
=> 'switch[_1]',
# deðiþtirmek[_1]
   'switch[_2]'
=> 'switch[_2]',
# deðiþtirmek[_2]
   'template'
=> 'template',
# templ-dee
   'to'
=> 'to',
# -e
   'to [_1] ([_2])'
=> 'to [_1] ([_2])',
# -e [_1] ([_2])
   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',
# -e interface with institutional d-dea, e.g., fs03glg231 fveya FBütün 2003 Geology 231
   'unable to enroll'
=> 'unable to enroll',
# unable -e Üye Olmak
   'uncheck all'
=> 'uncheck all',
# uncheck Bütün
   'use related words'
=> 'use related words',
# use Tekrarl-deed wveyads
   'user[_1]'
=> 'user[_1]',
# kullanýcý[_1]
   'username'
=> 'username',
# kullanýcýÝsim
   'versions of this problem'
=> 'versions of this problem',
# Versiyons -in bu problem
   'versus'
=> 'versus',

   'view[_1]'
=> 'view[_1]',
# Görünüm[_1]
   'waiting on [_1]'
=> 'waiting on [_1]',
# bekle [_1]
   'what you just saw on the screen'
=> 'what you just saw on the screen',
# wh-de you just saw on the scTekraren
   'with server'
=> 'with server',
# with Sunucu
   'yes'
=> 'yes',
# Evet


#SYNC Tue Aug 15 14:43:22 2006
   'Enter my portfolio space'
=> 'Enter my portfolio space',
# Giriþ benim pvey-defolio boþluk
   'No syllabus information provided.'
=> 'No syllabus information provided.',
# No MüfTekrardat Programý infveyam-deion provided.
   'Post Discussion'
=> 'Post Discussion',
# Post tartýþmakion
   'Sorry ...'
=> 'Sorry ...',
# Sveyary ...
   'This resource might be part of another course.'
=> 'This resource might be part of another course.',
# bu kaynak might be bölüm -in aNother kurs.


#SYNC Tue Aug 15 16:12:15 2006
   'Agree'
=> 'Agree',
# AgTekrare
   'Any comments? '
=> 'Any comments? ',

   'Copy this column'
=> 'Copy this column',
# Copy bu Column
   'Disagree'
=> 'Disagree',
# DisagTekrare
   'General Intro'
=> 'General Intro',
# Genel intro
   'Greek Symbols'
=> 'Greek Symbols',
# GTekrarek Symbols
   'HTML character enties'
=> 'HTML character enties',

   'Highest Grade Level'
=> 'Highest Grade Level',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',
# If you aTekrar Görünüming bu online, copy and paste the Text -dan any -in the right Columns in-e your Text aTekrara -e get the symbol on the left.
   'LON-CAPA Help'
=> 'LON-CAPA Help',
# LON-CAPA Yardým
   'Landscape'
=> 'Landscape',

   'Launch navigation window'
=> 'Launch navigation window',
# Launch navig-deion window
   'Lowest Grade Level'
=> 'Lowest Grade Level',

   'Mark all posts read'
=> 'Mark all posts read',
# Mark Bütün posts Tekrarad
   'My question/comment/feedback:'
=> 'My question/comment/feedback:',
# benim question/comment/geri bildirim:
   'Not set -'
=> 'Not set -',
# Not koymak -
   'Other Symbols'
=> 'Other Symbols',

   'Please check at least one of the following feedback types:'
=> 'Please check at least one of the following feedback types:',
# Please check -de least one -in the following geri bildirim Tipis:
   'Please rank the following criteria:'
=> 'Please rank the following criteria:',

   'Portrait'
=> 'Portrait',
# Pvey-derait
   'Question about resource content'
=> 'Question about resource content',
# Question about kaynak content
   'Question/Comment/Feedback about course policy'
=> 'Question/Comment/Feedback about course policy',
# Question/Comment/geri bildirim about kurs policy
   'Select a Course to Enter'
=> 'Select a Course to Enter',
# Seç kurs -e Giriþ
   'Sending Messages'
=> 'Sending Messages',
# SSoning Messages
   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',
# Show Me benim First Homewveyak problem
   'Standards'
=> 'Standards',

   'Strongly Agree'
=> 'Strongly Agree',
# Strongly AgTekrare
   'Strongly Disagree'
=> 'Strongly Disagree',
# Strongly DisagTekrare
   'Symbol'
=> 'Symbol',

   'The material appears to be correct '
=> 'The material appears to be correct ',
# The m-deerial appears -e be cveyaTekrarct
   'The material is helpful '
=> 'The material is helpful ',
# The m-deerial is Yardýmful
   'The material is presented in a clear way '
=> 'The material is presented in a clear way ',
# The m-deerial is pTekrarsented in a clear way
   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) ',
# The kaynak is technicBütüny cveyaTekrarct (Yüklemes fast eNough, does Not produce errveyas, links wveyak, etc)


#SYNC Tue Aug 15 18:55:42 2006


#SYNC Fri Aug 18 20:46:55 2006
   'HTML character entities'
=> 'HTML character entities',


#SYNCMARKER
);

1;

