/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;

class NWChemReader
extends AtomSetCollectionReader {
    private static final float AU2ANGSTROM = 0.52917725f;
    private int taskNumber = 1;
    private int equivalentAtomSets = 0;
    private String energyKey = "";
    private String energyValue = "";
    private boolean converged;
    private boolean haveEnergy;
    private boolean haveAt;
    private boolean inInput;

    NWChemReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("nwchem");
        this.init();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("          Step")) {
                    this.init();
                    continue;
                }
                if (line.startsWith("      Symmetry information")) {
                    this.readSymmetry(reader);
                    continue;
                }
                if (line.indexOf("Total") >= 0) {
                    this.readTotal(reader, line);
                    continue;
                }
                if (line.indexOf("@") >= 0) {
                    this.readAtSign(reader, line);
                    continue;
                }
                if (line.startsWith("      Optimization converged")) {
                    this.converged = true;
                    continue;
                }
                if (line.indexOf("Output coordinates in angstroms") >= 0) {
                    ++this.equivalentAtomSets;
                    this.readAtoms(reader);
                    continue;
                }
                if (line.indexOf("ENERGY GRADIENTS") >= 0) {
                    ++this.equivalentAtomSets;
                    this.readGradients(reader);
                    continue;
                }
                if (line.indexOf("NWChem Nuclear Hessian and Frequency Analysis") >= 0) {
                    this.readFrequencies(reader);
                    continue;
                }
                if (line.startsWith(" Task  times")) {
                    this.init();
                    ++this.taskNumber;
                    continue;
                }
                if (line.trim().startsWith("NWChem")) {
                    this.readNWChemLine(reader, line);
                    continue;
                }
                if (!line.startsWith("  Mulliken analysis of the total density") || this.equivalentAtomSets <= 0) continue;
                this.readPartialCharges(reader);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    private void init() {
        this.haveEnergy = false;
        this.haveAt = false;
        this.converged = false;
        this.inInput = false;
        this.equivalentAtomSets = 0;
    }

    private void setEnergies(String key, String value, int nAtomSets) {
        this.energyKey = key;
        this.energyValue = value;
        this.atomSetCollection.setAtomSetProperties(this.energyKey, this.energyValue, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyValue, this.equivalentAtomSets);
        this.haveEnergy = true;
    }

    private void setEnergy(String key, String value) {
        this.energyKey = key;
        this.energyValue = value;
        this.atomSetCollection.setAtomSetProperty(this.energyKey, this.energyValue);
        this.atomSetCollection.setAtomSetName(this.energyKey + " = " + this.energyValue);
        this.haveEnergy = true;
    }

    private void readSymmetry(BufferedReader reader) throws Exception {
        this.discardLines(reader, 2);
        String[] tokens = this.getTokens(reader.readLine());
        this.atomSetCollection.setAtomSetProperties("Symmetry group name", tokens[tokens.length - 1], this.equivalentAtomSets);
    }

    private void readNWChemLine(BufferedReader reader, String line) {
        this.inInput = line.indexOf("NWChem Input Module") >= 0;
    }

    private void readTotal(BufferedReader reader, String line) {
        String[] tokens = this.getTokens(line);
        try {
            if (tokens[2].startsWith("energy") && !this.haveAt) {
                this.setEnergies("E(" + tokens[1] + ")", tokens[tokens.length - 1], this.equivalentAtomSets);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void readAtSign(BufferedReader reader, String line) throws Exception {
        if (line.charAt(2) == 'S') {
            this.discardLines(reader, 1);
            line = reader.readLine();
        }
        String[] tokens = this.getTokens(line);
        if (!this.haveEnergy) {
            this.setEnergies("E", tokens[2], this.equivalentAtomSets);
        } else {
            this.setEnergies(this.energyKey, this.energyValue, this.equivalentAtomSets);
        }
        this.atomSetCollection.setAtomSetProperties("Step", tokens[1], this.equivalentAtomSets);
        this.haveAt = true;
    }

    private void readAtoms(BufferedReader reader) throws Exception {
        String line;
        this.discardLines(reader, 3);
        this.haveEnergy = false;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetProperty(".PATH", "Task " + this.taskNumber + (this.inInput ? SmarterJmolAdapter.PATH_SEPARATOR + "Input" : SmarterJmolAdapter.PATH_SEPARATOR + "Geometry"));
        while ((line = reader.readLine()).length() > 0) {
            String[] tokens = this.getTokens(line);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(tokens[1]);
            atom.x = this.parseFloat(tokens[3]);
            atom.y = this.parseFloat(tokens[4]);
            atom.z = this.parseFloat(tokens[5]);
        }
        if (this.converged) {
            this.setEnergy(this.energyKey, this.energyValue);
            this.atomSetCollection.setAtomSetProperty("Step", "converged");
        } else if (this.inInput) {
            this.atomSetCollection.setAtomSetName("Input");
        }
    }

    private void readGradients(BufferedReader reader) throws Exception {
        String line;
        this.discardLines(reader, 3);
        this.atomSetCollection.newAtomSet();
        if (this.equivalentAtomSets > 1) {
            this.atomSetCollection.cloneLastAtomSetProperties();
        }
        this.atomSetCollection.setAtomSetProperty("vector", "gradient");
        this.atomSetCollection.setAtomSetProperty(".PATH", "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Gradients");
        while ((line = reader.readLine()).length() > 0) {
            String[] tokens = this.getTokens(line);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(tokens[1]);
            atom.x = this.parseFloat(tokens[2]) * 0.52917725f;
            atom.y = this.parseFloat(tokens[3]) * 0.52917725f;
            atom.z = this.parseFloat(tokens[4]) * 0.52917725f;
            atom.vectorX = -this.parseFloat(tokens[5]);
            atom.vectorY = -this.parseFloat(tokens[6]);
            atom.vectorZ = -this.parseFloat(tokens[7]);
        }
    }

    private void readFrequencies(BufferedReader reader) throws Exception {
        String[] tokens;
        this.discardLinesUntilContains(reader, "Atom information");
        this.discardLines(reader, 2);
        String line = reader.readLine();
        this.atomSetCollection.newAtomSet();
        do {
            tokens = this.getTokens(line);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = tokens[0];
            atom.x = this.parseFloat(tokens[2]) * 0.52917725f;
            atom.y = this.parseFloat(tokens[3]) * 0.52917725f;
            atom.z = this.parseFloat(tokens[4]) * 0.52917725f;
        } while ((line = reader.readLine()) != null && line.indexOf("---") < 0);
        int firstFrequencyAtomSetIndex = this.atomSetCollection.currentAtomSetIndex;
        int totalFrequencies = 0;
        int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
        boolean firstTime = true;
        this.discardLinesUntilContains(reader, "(Projected Frequencies expressed in cm-1)");
        this.discardLines(reader, 3);
        while ((line = reader.readLine()) != null && line.indexOf("P.Frequency") >= 0) {
            int fIndex;
            tokens = this.getTokens(line, 12);
            int nFreq = tokens.length;
            int n = fIndex = firstTime ? 1 : 0;
            while (fIndex < nFreq) {
                this.atomSetCollection.cloneLastAtomSet();
                ++fIndex;
            }
            firstTime = false;
            int firstModelAtom = this.atomSetCollection.atomCount - nFreq * atomCount;
            this.discardLines(reader, 1);
            for (int i = 0; i < atomCount * 3; ++i) {
                line = reader.readLine();
                tokens = this.getTokens(line);
                block9: for (int j = 0; j < nFreq; ++j) {
                    Atom atom = this.atomSetCollection.atoms[firstModelAtom + j * atomCount + i / 3];
                    float val = this.parseFloat(tokens[j + 1]);
                    switch (i % 3) {
                        case 0: {
                            atom.vectorX = val;
                            continue block9;
                        }
                        case 1: {
                            atom.vectorY = val;
                            continue block9;
                        }
                        case 2: {
                            atom.vectorZ = val;
                        }
                    }
                }
            }
            totalFrequencies += nFreq;
            this.discardLines(reader, 3);
        }
        this.discardLinesUntilContains(reader, "Projected Infra Red Intensities");
        this.discardLines(reader, 2);
        String path = "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies";
        int i = totalFrequencies;
        int idx = firstFrequencyAtomSetIndex;
        while (--i >= 0) {
            line = reader.readLine();
            tokens = this.getTokens(line);
            String frequencyString = tokens[1] + " cm**-1";
            this.atomSetCollection.setAtomSetName(frequencyString, idx);
            this.atomSetCollection.setAtomSetProperty("Frequency", frequencyString, idx);
            this.atomSetCollection.setAtomSetProperty("IR Intensity", tokens[5] + " KM/mol", idx);
            this.atomSetCollection.setAtomSetProperty(".PATH", path, idx);
            ++idx;
        }
    }

    void readPartialCharges(BufferedReader reader) throws Exception {
        this.discardLines(reader, 4);
        for (int i = this.atomSetCollection.getLastAtomSetAtomIndex(); i < this.atomSetCollection.atomCount; ++i) {
            while (this.atomSetCollection.atoms[i].elementNumber == 0) {
                ++i;
            }
            String[] tokens = this.getTokens(reader.readLine());
            this.atomSetCollection.atoms[i].partialCharge = (float)this.parseInt(tokens[2]) - this.parseFloat(tokens[3]);
        }
    }

    private String fixTag(String tag) {
        if (tag.toLowerCase().startsWith("bq")) {
            return tag.substring(2) + "-Bq";
        }
        return tag;
    }
}

