#!/usr/bin/perl


use strict;
use warnings;
use lib '/home/httpd/lib/perl';
use GDBM_File;
use File::Find;
use LONCAPA;
use LONCAPA::Configuration;
use Fcntl qw(:flock);

my $dump_db = '/home/httpd/perl/debug/dump_db_static_32';
my $create_db = '/home/httpd/perl/debug/create_db_dynamic_64';
if (!-x $dump_db || !-x $create_db) {
    print("Unable to run needed helper programs\n $dump_db\n $create_db\n.");
    exit(-1);
}

my  %perlvar=%{&LONCAPA::Configuration::read_conf('loncapa.conf')};

my $do_locks = 1;
{
    sub lock_db {
        my ($fname) = @_;
        my $sym;
        if ($do_locks) {
            open($sym,">>$fname.lock");
            flock($sym,(LOCK_EX));
        }
        return $sym;
    }

    sub unlock_db {
        my ($sym) = @_;
        if (ref($sym)) {
            flock($sym,(LOCK_UN));
        }
    }
}

my $count=0;
sub count_db {
    return if ($_!~m/\.db$/);
    $count++;
}

my $done=0;
my $skip=0;
my $starttime;
my $last_100_start_time;
sub process_db {
    return if ($_!~m/\.db$/);
    if (!-e "$_.old") {
	my $file = $_;
	my $dbref =&lock_db($file);
	#print("attempting $file\n");
	system("$dump_db -f $file|$create_db -f $file.new");
#    print("finishing $dbref\n");
	rename($file,"$file.old");
	rename("$file.new","$file");
	&unlock_db($dbref);
    } else {
	#print("skip $_\n");
	$skip++;
    }
    $done++;
    if (!($done %100)) {
        print("$_\n");
        my $took = time()-$starttime;
        my $togo = int(($took/$done) * ($count-$done));
        my $total = $togo+$took;
	my $per = ($done-$skip)?$took/($done-$skip):0;
        my $last_per = (time()-$last_100_start_time)/100;
        printf("%6d (%6d) in %6d, togo %6d, overall %6d, %.3f (each), %.3f\n",
	       $done,$skip,$took,$togo,$total,$per,$last_per);
        $last_100_start_time = time();
    }
}

sub main {
    my $dir = $perlvar{'lonUsersDir'}.'/temp/y/';
    print("Doing $dir\n");
    &find({ no_chdir   => 1,
            wanted     => \&count_db, },
          $dir);
    print("Found $count db to do\n");
    $last_100_start_time = $starttime = time();
    &find({ no_chdir   => 1,
            wanted     => \&process_db, },
          $dir);

}

&main();
