#!/usr/bin/perl
#
#Automated Enrollment script
# $Id: Autoenroll.pl,v 1.22 2006/07/21 17:47:36 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
    use strict;
    use lib '/home/httpd/lib/perl';
    use localenroll;
    use LONCAPA::Configuration;
    use LONCAPA::Enrollment;
    use Apache::lonnet;
    use Apache::loncoursedata;
    use Apache::lonmsg;
    use Apache::longroup;
    use Apache::loncommon;
    use HTML::Entities;

# Determine the library server's domain and hostID
    my $perlvarref = LONCAPA::Configuration::read_conf('loncapa.conf');
    my $logfile = $$perlvarref{'lonDaemons'}.'/logs/autoenroll.log';
    my @domains = &Apache::lonnet::current_machine_domains();
    my @hostids = &Apache::lonnet::current_machine_ids();

# Determine the present time;
    my $timenow = time();

# For each domain ......
    foreach my $dom (@domains) {
    #only run if configured to
        if (! &localenroll::run($dom)) { next; }
        $env{'user.domain'} = $dom;
    # Determine the courses
        my %courses = &Apache::lonnet::courseiddump($dom,'.',1,'.','.','.',1,\@hostids,'Course'); 
        my %affiliates = ();
        my %enrollvar = ();
        my %reply = ();
        my %LC_code = ();
        foreach my $key (sort keys %courses) {
            my $crs;
            if ($key =~ m/^($dom)_(\w+)$/) {
                $crs = $2;
            }

# Get course settings
            my %settings = &Apache::lonnet::dump('environment',$dom,$crs);
            %{$enrollvar{$crs}} = ();
            @{$affiliates{$crs}} = ();
            %{$LC_code{$crs}} = ();
            foreach my $item (keys %settings) {
                if ($item =~ m/^internal\.(.+)$/) {
                    $enrollvar{$crs}{$1} = $settings{$item};
                } elsif ($item eq 'description') {
                    $enrollvar{$crs}{$item} = &HTML::Entities::decode($settings{$item});  
                } elsif ($item eq 'default_enrollment_start_date') {
                    $enrollvar{$crs}{startdate} = $settings{$item};
                }  elsif ($item eq 'default_enrollment_end_date') {
                    $enrollvar{$crs}{enddate} = $settings{$item};
                }
            }
            if (($enrollvar{$crs}{autostart} <= $timenow) && ( ($enrollvar{$crs}{autoend} > $timenow) || ($enrollvar{$crs}{autoend} == 0) ) ) {
                if ( ($enrollvar{$crs}{autoadds} == 1) || ($enrollvar{$crs}{autodrops} == 1) ) {
# Add to list of classes for retrieval
                    $enrollvar{$crs}{sectionnums} =~ s/ //g;
                    $enrollvar{$crs}{crosslistings} =~ s/ //g;
                    my @sections = ();
                    my @crosslistings = ();
                    if ($enrollvar{$crs}{sectionnums} =~ m/,/) {
                        @sections = split/,/,$enrollvar{$crs}{sectionnums};
                    } else {
                        $sections[0] = $enrollvar{$crs}{sectionnums};
                    }
                    if ($enrollvar{$crs}{crosslistings} =~ m/,/) {
                        @crosslistings = split/,/,$enrollvar{$crs}{crosslistings}
                    } else {
                        @crosslistings = $enrollvar{$crs}{crosslistings};
                    }
                    foreach my $sec (@sections) {
                        if ($sec =~ m/^(\w+):(\w*)$/ ) {
                            my $course_id = $enrollvar{$crs}{coursecode}.$1;
                            my $gp = $2;
                            if (!grep/^$course_id$/,@{$affiliates{$crs}}) {
                                push @{$affiliates{$crs}}, $course_id;
                                $LC_code{$crs}{$course_id} = $gp; 
                            }
                        }
                    }
                    foreach my $xlist (@crosslistings) {
                        if ($xlist =~ m/^([^:]+):(\w*)$/) {
                            my $course_id = $1;
                            my $gp = $2;
                            if (!grep/^$course_id$/,@{$affiliates{$crs}}) {
                                push @{$affiliates{$crs}}, $course_id;
                                $LC_code{$crs}{$course_id} = $gp;
                            }
                        }
                    }
                }
            }
        }
        my $outcome = &Apache::lonnet::fetch_enrollment_query('automated',\%affiliates,\%reply,$dom);

# Now go through classes and perform required enrollment changes.
        open (my $fh,">>$logfile");
        print $fh "********************\n".localtime(time)." Enrollment messages start --\n";
        print $fh "Response from fetch_enrollment_query was $outcome\n";
        foreach my $crs (sort keys %enrollvar) {
            my $logmsg = '';
            my $newusermsg = '';
            if ($reply{$crs} > 0) {
                if ( ($enrollvar{$crs}{autostart} < $timenow) && ( ($enrollvar{$crs}{autoend} > $timenow) || ($enrollvar{$crs}{autoend} == 0) ) ) {
                    if (($enrollvar{$crs}{autoadds} == 1) || ($enrollvar{$crs}{autodrops} == 1)) {
                        my ($changecount,$response) = &LONCAPA::Enrollment::update_LC($dom,$crs,$enrollvar{$crs}{autoadds},$enrollvar{$crs}{autodrops},$enrollvar{$crs}{startdate},$enrollvar{$crs}{enddate},$enrollvar{$crs}{authtype},$enrollvar{$crs}{autharg},\@{$affiliates{$crs}},\%{$LC_code{$crs}},\$logmsg,\$newusermsg,'automated');
                        print $fh "Messages start for $crs\n";
                        print $fh "$logmsg\n";
                        print $fh "Messages end for $crs\n";
                        if ($changecount > 0) {
                            unless ($enrollvar{$crs}{notifylist}  eq '') {
# Send message about enrollment changes to notifylist.
# Set $env{'user.name'}, $env{'user.home'} for use by logging in lonmsg
                                unless ( ($enrollvar{$crs}{'courseowner'} eq '') || (!defined($enrollvar{$crs}{'courseowner'}) )  ) {
                                    $env{'user.name'} = $enrollvar{$crs}{'courseowner'};
                                    $env{'user.home'} = &Apache::lonnet::homeserver($env{'user.name'},$dom);

                                    my $subject = "Student enrollment changes in $enrollvar{$crs}{coursecode}";
                                    my $message = "The following $changecount change(s) occurred in $enrollvar{$crs}{description} - $enrollvar{$crs}{coursecode} as a result of the automated classlist update:\n\n".$response;
                                    unless ($newusermsg eq '') { 
                                        $message .= "\n".$newusermsg;
                                    }
                                    my @to_notify = ();
                                    if ($enrollvar{$crs}{notifylist} =~ m/,/) {
                                        @to_notify = split/,/,$enrollvar{$crs}{notifylist};
                                    } else {
                                        $to_notify[0] = $enrollvar{$crs}{notifylist};
                                    }
                                    foreach my $cc (@to_notify) {
                                        my ($ccname,$ccdom);
                                        if ($cc =~ /:/) {
                                            ($ccname,$ccdom) = split(/:/,$cc);
                                        } elsif ($cc =~ /\@/) {
                                            ($ccname,$ccdom) = split(/\@/,$cc);
                                        }
                                        my $status =  &Apache::lonmsg::user_normal_msg($ccname,$ccdom,$subject,$message);
                                    }
                                    if ( ($enrollvar{$crs}{notifylist} eq '') && ($newusermsg ne '') ) {
                                        my $subject = "New user accounts in  $enrollvar{$crs}{'coursecode'}";
                                        my $status =  &Apache::lonmsg::user_normal_msg($env{'user.name'},$dom,$subject,$newusermsg);
                                    }
                                    delete($env{'user.name'});
                                    delete($env{'user.home'});
                                }
                            }
                        }
                    }
                }
            } else {
                if ( ($enrollvar{$crs}{autoadds} == 1) || ($enrollvar{$crs}{autodrops} == 1) ) {
                    if ( ($enrollvar{$crs}{autostart} < $timenow) && ( ($enrollvar{$crs}{autoend} > $timenow) || ($enrollvar{$crs}{autoend} == 0) ) ) {
                        print $fh "No institutional classlist data could be retrieved for $crs\n";
                    } else {
                        print $fh "Not within time window for auto-enrollment in $crs\n";
                    }
                } else {
                    print $fh "Auto-enrollment not currently enabled for $crs\n";
                }
            }
        }
        print $fh "-- ".localtime(time)." Enrollment messages end\n*******************\n\n";
        close($fh);
        delete($env{'user.domain'});
# Check for photos
    }

1;
