# The LearningOnline Network with CAPA
# This will take annotations and then plug them into a page.
#
# $Id: admannotations.pm,v 1.26 2006/04/20 04:19:55 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
##################

package Apache::admannotations;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonlocal;

# --------------------------------------------------------------Put annotation

sub write_annotation {
    my ($urlold, $annotation) = @_;
    if ($annotation) { 
	&Apache::lonnet::put('nohist_annotations',{$urlold => $annotation});
    }
    return;
}

# --------------------------------------------------------------Get annotation

sub get_annotation {
    my ($urlnew) = @_;
    my %annotation=&Apache::lonnet::get('nohist_annotations',[$urlnew]);
    return %annotation;
}

# ------------------------------------------------------------Construct editor
sub js_get_url {
    return <<ENDJS;
function get_url() {
    var url;
    if (typeof(window.opener.clientwindow) != 'undefined') {
	url=window.opener.clientwindow.location.href;
    } else {
	url=window.opener.location.href;
    }
    return url;
}
ENDJS
}

sub construct_editor {
    my ($annotation,$urlnew) = @_;
    if ($annotation=~/^error:/) { $annotation=''; }

    my $get_url = &js_get_url();

    my $js = <<ENDJS;
<script type="text/javascript">
var timeout;

$get_url

function changed() {
    var urlnew=get_url();
    if (urlnew!=document.annotInfo.urlold.value) {
	document.annotInfo.urlnew.value=urlnew;
        document.annotInfo.submit();
    }
    timeout=setTimeout('changed();','1000');
}
</script>
ENDJS

    my %load_items = ('onload'   => "timeout=setTimeout('changed()','1000')",
		      'onunload' => 'clearTimeout(timeout);');
    my $start_page =
	&Apache::loncommon::start_page('Annotations',$js,
				       {'only_body'   => 1,
					'add_entries' => \%load_items,});

    my $end_page =
        &Apache::loncommon::end_page();
    
    my %lt = ( 'close no save' => "Close (no save)",
	       'save'          => "Save and Update",);
    %lt = &Apache::lonlocal::texthash(%lt);
	 
    return(<<END_HTML)
$start_page
 <center>
  <form name="annotInfo" method="post" action="/adm/annotations">
    <textarea name="annotation" wrap="on" rows="12" cols="36">$annotation</textarea><br />
    <input type="hidden" name="urlold" value="$urlnew" />
    <input type="hidden" name="urlnew" value="" />
    <input type="button" name="send" value="$lt{'save'}"
           onclick="javascript:this.form.urlnew.value=get_url();this.form.submit();" />
    <input type="button" name="close" value="$lt{'close no save'}" 
           onclick="javascript:window.close();" />
  </form>
 </center>
$end_page
END_HTML
}

# ----------------------------------------------------Constructs error window

sub construct_error {
    my ($annot_error,$button_name) = @_;

    my $get_url = &js_get_url();
    my $js = <<ENDJS;
<script type="text/javascript">
$get_url
</script>
ENDJS

    my $start_page = &Apache::loncommon::start_page('Annotations',$js,
						    {'only_body'   => 1,});
    my $end_page =  &Apache::loncommon::end_page();

    my %lt = ( 'close'  => "Close",
	       'button' => $button_name,);
    %lt = &Apache::lonlocal::texthash(%lt);

    return(<<END_HTML2)
$start_page
 <center>
  <form name="annotInfo" method="post" action="/adm/annotations">
<table bgcolor="#FFFFFF" width="100%" height="90%" align="center">
<td>
<font size="+1"><i>
$annot_error
</i></font>
</td>
</table>
    <input type="hidden" name="urlold" value="" />
    <input type="hidden" name="urlnew" value="" />
    <input type="button" name="send" value="$lt{'button'}"
           onclick="javascript:this.form.urlnew.value=get_url();this.form.submit();" />
    <input type="button" name="close" value="$lt{'close'}" 
           onclick="javascript:window.close();" />
  </form>
 </center>
$end_page
END_HTML2
}

# ---------------------------------------------------------------Main Handler

sub handler {
    my ($r) = @_;

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;


    my $page;
    my %annot_hash;

    my $urlold=$env{'form.urlold'};
    $urlold=~s/^http\:\/\///;
    $urlold=~s/^[^\/]+//;
    $urlold=~s/\?.*$//;
    my $urlnew=$env{'form.urlnew'};
    $urlnew=~s/^http\:\/\///;
    $urlnew=~s/^[^\/]+//;
    $urlnew=~s/\?.*$//;
    my $annotation=$env{'form.annotation'};

    if ($urlold) {
	&write_annotation($urlold,$annotation);
    }
    if (exists($env{'form.urlnew'})) {
	unless ($urlnew) {
	    $page=&construct_error(&mt("Cannot annotate current window. Please point your browser to a LON-CAPA page and then 'continue'."),"continue");
	} else {
	    if ($urlold eq $urlnew) {
		$annot_hash{$urlnew}=$annotation;
	    } else {
		%annot_hash=&get_annotation($urlnew);
	    }
	    $page=&construct_editor($annot_hash{$urlnew},$env{'form.urlnew'});
	}
    }
    $r->print($page);
    return OK;
}

1;
__END__

