# The LearningOnline Network with CAPA
# Handler to drop and add students in courses 
#
# $Id: londropadd.pm,v 1.151 2006/12/10 23:48:44 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#
###############################################################
##############################################################

package Apache::londropadd;

use strict;
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonhtmlcommon();
use Apache::Constants qw(:common :http REDIRECT);
use Spreadsheet::WriteExcel;
use Apache::lonstathelpers();
use Apache::lonlocal;
use Apache::longroup;

###############################################################
###############################################################
sub header {
    my $start_page=&Apache::loncommon::start_page('Enrollment Manager');
    return(<<ENDHEAD);
$start_page
<form method="post" enctype="multipart/form-data"  
      action="/adm/dropadd" name="studentform">
ENDHEAD
}

###############################################################
###############################################################
# Drop student from all sections of a course, except optional $csec
sub modifystudent {
    my ($udom,$unam,$courseid,$csec,$desiredhost)=@_;
    # if $csec is undefined, drop the student from all the courses matching
    # this one.  If $csec is defined, drop them from all other sections of 
    # this course and add them to section $csec
    my $cdom = $env{'course.'.$courseid.'.domain'};
    my $cnum = $env{'course.'.$courseid.'.num'};
    my %roles = &Apache::lonnet::dump('roles',$udom,$unam);
    my ($tmp) = keys(%roles);
    # Bail out if we were unable to get the students roles
    return "$1" if ($tmp =~ /^(con_lost|error|no_such_host)/i);
    # Go through the roles looking for enrollment in this course
    my $result = '';
    foreach my $course (keys(%roles)) {
        if ($course=~m{^/\Q$cdom\E/\Q$cnum\E(?:\/)*(?:\s+)*(\w+)*\_st$}) {
            # We are in this course
            my $section=$1;
            $section='' if ($course eq "/$cdom/$cnum".'_st');
            if (defined($csec) && $section eq $csec) {
                $result .= 'ok:';
            } elsif ( ((!$section) && (!$csec)) || ($section ne $csec) ) {
                my (undef,$end,$start)=split(/\_/,$roles{$course});
                my $now=time;
                # if this is an active role
                if (!($start && ($now<$start)) || !($end && ($now>$end))) {
                    my $reply=&Apache::lonnet::modifystudent
                        # dom  name  id mode pass     f     m     l     g
                        ($udom,$unam,'',  '',  '',undef,undef,undef,undef,
                         $section,time,undef,undef,$desiredhost);
                    $result .= $reply.':';
                }
            }
        }
    }
    if ($result eq '') {
        $result = 'Unable to find section for this student';
    } else {
        $result =~ s/(ok:)+/ok/g;
    }
    return $result;
}

###############################################################
###############################################################
# build a domain and server selection form
sub domain_form {
    my ($defdom) = @_;
    # Set up domain and server selection forms
    #
    # Get the domains
    my @domains = &Apache::loncommon::get_domains();
    # build up the menu information to be passed to 
    # &Apache::loncommon::linked_select_forms
    my %select_menus;
    foreach my $dom (@domains) {
        # set up the text for this domain
        $select_menus{$dom}->{'text'}= $dom;
        # we want a choice of 'default' as the default in the second menu
        $select_menus{$dom}->{'default'}= 'default';
        $select_menus{$dom}->{'select2'}->{'default'} = 'default';
        # Now build up the other items in the second menu
        my %servers = &Apache::loncommon::get_library_servers($dom);
        foreach my $server (keys(%servers)) {
            $select_menus{$dom}->{'select2'}->{$server} 
                                            = "$server $servers{$server}";
        }
    }
    my $result  = &Apache::loncommon::linked_select_forms
        ('studentform',' with home server ',$defdom,
         'lcdomain','lcserver',\%select_menus);
    return $result;
}

###############################################################
###############################################################
#  Menu Phase One
sub print_main_menu {
    my ($r,$enrl_permission,$view_permission,$grp_manage_permission,
        $grp_view_permission)=@_;
    #
    my $cid =$env{'request.course.id'};
    my $cdom=$env{'course.'.$cid.'.domain'};
    my $cnum=$env{'course.'.$cid.'.num'};
    my @menu = 
        ( 
          { text => 'Upload a class list', 
            help => 'Course_Create_Class_List',
            action => 'upload',
            permission => $enrl_permission,
            },
          { text => 'Enroll a single student', 
            help => 'Course_Add_Student',
            action => 'enrollstudent',
            permission => $enrl_permission,
            },
          { text => 'Modify student data', 
            help => 'Course_Modify_Student_Data',
            action => 'modifystudent',
            permission => $enrl_permission,
            },
          { text => 'View Class List', 
            help => 'Course_View_Class_List',
            action => 'classlist',
            permission => $view_permission,
            },
          { text => 'Drop Students', 
            help => 'Course_Drop_Student',
            action => 'drop',
            permission => $enrl_permission,
            },
          { text => 'Automated Enrollment Manager', 
            permission => &Apache::lonnet::auto_run($cnum,$cdom),
            url  => '/adm/populate',
            },
          { text => 'Create a new group',
            help => 'Course_Create_Group',
            permission => $grp_manage_permission,
            url => '/adm/coursegroups?refpage=enrl&action=create',
            },
          { text => 'Modify an existing group',
            help => 'Course_Modify_Group',
            permission => $grp_manage_permission,
            url => '/adm/coursegroups?refpage=enrl&action=modify',
            },
#          { text => 'Delete an existing group',
#            help => 'Course_Delete_Group',
#            permission => $grp_manage_permission,
#            url => '/adm/coursegroups?refpage=enrl&action=delete',
#            },
          { text => 'Enter an existing group',
            help => 'Course_Display_Group',
            permission => $grp_view_permission,
            url => '/adm/coursegroups?refpage=enrl&action=view',
            },
          );
    my $menu_html = '';
    foreach my $menu_item (@menu) {
        next if (! $menu_item->{'permission'});
        $menu_html.='<p>';
        $menu_html.='<font size="+1">';
        if (exists($menu_item->{'url'})) {
            $menu_html.=qq{<a href="$menu_item->{'url'}">};
        } else {
            $menu_html.=
                qq{<a href="/adm/dropadd?action=$menu_item->{'action'}">};
        }
        $menu_html.= &mt($menu_item->{'text'}).'</a></font>';
        if (exists($menu_item->{'help'})) {
            $menu_html.=
                &Apache::loncommon::help_open_topic($menu_item->{'help'});
        }
        $menu_html.='</p>'.$/;
    }
    $r->print($menu_html);
    return;
}

###############################################################
###############################################################
sub hidden_input {
    my ($name,$value) = @_;
    return '<input type="hidden" name="'.$name.'" value="'.$value.'" />'."\n";
}

sub print_upload_manager_header {
    my ($r,$datatoken,$distotal,$krbdefdom)=@_;
    my $javascript;
    #
    if (! exists($env{'form.upfile_associate'})) {
        $env{'form.upfile_associate'} = 'forward';
    }
    if ($env{'form.associate'} eq 'Reverse Association') {
        if ( $env{'form.upfile_associate'} ne 'reverse' ) {
            $env{'form.upfile_associate'} = 'reverse';
        } else {
            $env{'form.upfile_associate'} = 'forward';
        }
    }
    if ($env{'form.upfile_associate'} eq 'reverse') {
	$javascript=&upload_manager_javascript_reverse_associate();
    } else {
	$javascript=&upload_manager_javascript_forward_associate();
    }
    #
    # Deal with restored settings
    my $password_choice = '';
    if (exists($env{'form.ipwd_choice'}) &&
        $env{'form.ipwd_choice'} ne '') {
        # If a column was specified for password, assume it is for an
        # internal password.  This is a bug waiting to be filed (could be
        # local or krb auth instead of internal) but I do not have the 
        # time to mess around with this now.
        $password_choice = 'int';        
    }
    #
    my $javascript_validations=&javascript_validations('auth',$krbdefdom,
                                    $password_choice);
    my $checked=(($env{'form.noFirstLine'})?' checked="checked" ':'');
    $r->print('<h3>'.&mt('Uploading Class List')."</h3>\n".
              "<hr>\n".
              '<h3>'.&mt('Identify fields')."</h3>\n");
    $r->print("<p>\n".
              &mt('Total number of records found in file: [_1].',$distotal).
              "\n".
              "</p><hr>\n");
    $r->print(&mt('Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.')."<hr>\n");
    $r->print(&hidden_input('action','upload').
              &hidden_input('state','got_file').
              &hidden_input('associate','').
              &hidden_input('datatoken',$datatoken).
              &hidden_input('fileupload',$env{'form.fileupload'}).
              &hidden_input('upfiletype',$env{'form.upfiletype'}).
              &hidden_input('upfile_associate',$env{'form.upfile_associate'}));
    $r->print('<input type="button" value="Reverse Association" '.
              'name="'.&mt('Reverse Association').'" '.
              'onClick="javascript:this.form.associate.value=\'Reverse Association\';submit(this.form);" />');
    $r->print('<label><input type="checkbox" name="noFirstLine"'.$checked.'/>'.
              &mt('Ignore First Line').'</label>');
    $r->print("<hr />\n".
              '<script type="text/javascript" language="Javascript">'."\n".
              $javascript."\n".$javascript_validations.'</script>');
}

###############################################################
###############################################################
sub javascript_validations {
    my ($mode,$krbdefdom,$curr_authtype,$curr_authfield)=@_;
    my $authheader;
    if ($mode eq 'auth') {
        my %param = ( formname => 'studentform',
                      kerb_def_dom => $krbdefdom,
                      curr_authtype => $curr_authtype);
        $authheader = &Apache::loncommon::authform_header(%param);
    } elsif ($mode eq 'createcourse') {
        my %param = ( formname => 'ccrs',
                  kerb_def_dom => $krbdefdom,
                      curr_authtype => $curr_authtype );
        $authheader = &Apache::loncommon::authform_header(%param);
    } elsif ($mode eq 'modifycourse') {
        my %param = ( formname => 'cmod',
                  kerb_def_dom => $krbdefdom,
                  mode => 'modifycourse',
                  curr_authtype => $curr_authtype,
                  curr_autharg => $curr_authfield );
        $authheader = &Apache::loncommon::authform_header(%param);
    }

    
    my %alert = &Apache::lonlocal::texthash
        (username => 'You need to specify the username field.',
         authen   => 'You must choose an authentication type.',
         krb      => 'You need to specify the Kerberos domain.',
         ipass    => 'You need to specify the initial password.',
         name     => 'The optional name field was not specified.',
         snum     => 'The optional student number field was not specified.',
         section  => 'The optional section field was not specified.', 
         email    => 'The optional email address field was not specified.',
         continue => 'Continue enrollment?',
         );
    
#    my $pjump_def = &Apache::lonhtmlcommon::pjump_javascript_definition();
    my $function_name =(<<END);
function verify_message (vf,founduname,foundpwd,foundname,foundid,foundsec,foundemail) {
END
    my $auth_checks;
    if ($mode eq 'createcourse') {
        $auth_checks .= (<<END);
    if (vf.autoadds[0].checked == true) {
        if (current.radiovalue == null || current.radiovalue == 'nochange') {
            alert('$alert{'authen'}');
            return;
        }
    }
END
    } else {
        $auth_checks .= (<<END);
    var foundatype=0;
    if (founduname==0) {
	alert('$alert{'username'}');
        return;
    }
    // alert('current.radiovalue = '+current.radiovalue);
    if (current.radiovalue == null || current.radiovalue == '' || current.radiovalue == 'nochange') {
        // They did not check any of the login radiobuttons.
        alert('$alert{'authen'}');
        return;
    }
END
    }
    if ($mode eq 'createcourse') {
        $auth_checks .= "
    if ( (vf.autoadds[0].checked == true) &&
         (vf.elements[current.argfield].value == null || vf.elements[current.argfield].value == '') ) {
";
    } elsif ($mode eq 'modifycourse') {
        $auth_checks .= " 
    if (vf.elements[current.argfield].value == null || vf.elements[current.argfield].value == '') {
";
    }
    if ( ($mode eq 'createcourse') || ($mode eq 'modifycourse') ) {
        $auth_checks .= (<<END);
        var alertmsg = '';
        switch (current.radiovalue) {
            case 'krb':
                alertmsg = '$alert{'krb'}';
                break;
            default:
                alertmsg = '';
        }
        if (alertmsg != '') {
            alert(alertmsg);
            return;
        }
    }
END
    } else {
        $auth_checks .= (<<END);
    foundatype=1;
    if (current.argfield == null || current.argfield == '') {
        var alertmsg = '';
        switch (current.value) {
            case 'krb': 
                alertmsg = '$alert{'krb'}';
                break;
            case 'loc':
            case 'fsys':
                alertmsg = '$alert{'ipass'}';
                break;
            case 'fsys':
                alertmsg = '';
                break;
            default: 
                alertmsg = '';
        }
        if (alertmsg != '') {
            alert(alertmsg);
            return;
        }
    }
END
    }
    my $section_checks;
    my $optional_checks = '';
    if ( ($mode eq 'createcourse') || ($mode eq 'modifycourse') ) {
        $optional_checks = (<<END);
    vf.submit();
}
END
    } else {
        $section_checks = &section_check_js();
        $optional_checks = (<<END);
    var message='';
    if (foundname==0) { 
        message='$alert{'name'}';
    }
    if (foundid==0) { 
        if (message!='') { 
            message+='\\n'; 
        }
        message+='$alert{'snum'}';
    }
    if (foundsec==0) {
        if (message!='') {
            message+='\\n';
        } 
        message+='$alert{'section'}';
    }
    if (foundemail==0) {
        if (message!='') {
            message+='\\n';
        }
        message+='$alert{'email'}';
    }
    if (message!='') {
        message+= '\\n$alert{'continue'}';
        if (confirm(message)) {
            vf.state.value='enrolling';
            vf.submit();
        }
    } else {
        vf.state.value='enrolling';
        vf.submit();
    }
}
END
    }
    my $result = $function_name;
    if ( ($mode eq 'auth') || ($mode eq 'createcourse') || ($mode eq 'modifycourse')  ) {
        $result .= $auth_checks;
    }
    $result .= $optional_checks."\n".$section_checks;
    if ( ($mode eq 'auth') || ($mode eq 'createcourse') || ($mode eq 'modifycourse')  ) {
        $result .= $authheader;
    }
    return $result;
}

###############################################################
###############################################################
sub upload_manager_javascript_forward_associate {
    return(<<ENDPICK);
function verify(vf,sec_caller) {
    var founduname=0;
    var foundpwd=0;
    var foundname=0;
    var foundid=0;
    var foundsec=0;
    var foundemail=0;
    var tw;
    for (i=0;i<=vf.nfields.value;i++) {
        tw=eval('vf.f'+i+'.selectedIndex');
        if (tw==1) { founduname=1; }
        if ((tw>=2) && (tw<=6)) { foundname=1; }
        if (tw==7) { foundid=1; }
        if (tw==8) { foundsec=1; }
        if (tw==9) { foundpwd=1; }
        if (tw==10) { foundemail=1; }
    }
    verify_message(vf,founduname,foundpwd,foundname,foundid,foundsec,foundemail);
}

//
// vf = this.form
// tf = column number
//
// values of nw
//
// 0 = none
// 1 = username
// 2 = names (lastname, firstnames)
// 3 = fname (firstname)
// 4 = mname (middlename)
// 5 = lname (lastname)
// 6 = gen   (generation)
// 7 = id
// 8 = section
// 9 = ipwd  (password)
// 10 = email address

function flip(vf,tf) {
   var nw=eval('vf.f'+tf+'.selectedIndex');
   var i;
   // make sure no other columns are labeled the same as this one
   for (i=0;i<=vf.nfields.value;i++) {
      if ((i!=tf) && (eval('vf.f'+i+'.selectedIndex')==nw)) {
          eval('vf.f'+i+'.selectedIndex=0;')
      }
   }
   // If we set this to 'lastname, firstnames', clear out all the ones
   // set to 'fname','mname','lname','gen' (3,4,5,6) currently.
   if (nw==2) {
      for (i=0;i<=vf.nfields.value;i++) {
         if ((eval('vf.f'+i+'.selectedIndex')>=3) &&
             (eval('vf.f'+i+'.selectedIndex')<=6)) {
             eval('vf.f'+i+'.selectedIndex=0;')
         }
      }
   }
   // If we set this to one of 'fname','mname','lname','gen' (3,4,5,6),
   // clear out any that are set to 'lastname, firstnames' (2)
   if ((nw>=3) && (nw<=6)) {
      for (i=0;i<=vf.nfields.value;i++) {
         if (eval('vf.f'+i+'.selectedIndex')==2) {
             eval('vf.f'+i+'.selectedIndex=0;')
         }
      }
   }
   // If we set the password, make the password form below correspond to 
   // the new value.
   if (nw==9) {
       changed_radio('int',document.studentform);
       set_auth_radio_buttons('int',document.studentform);
       vf.intarg.value='';
       vf.krbarg.value='';
       vf.locarg.value='';
   }
}

function clearpwd(vf) {
    var i;
    for (i=0;i<=vf.nfields.value;i++) {
        if (eval('vf.f'+i+'.selectedIndex')==9) {
            eval('vf.f'+i+'.selectedIndex=0;')
        }
    }
}

ENDPICK
}

###############################################################
###############################################################
sub upload_manager_javascript_reverse_associate {
    return(<<ENDPICK);
function verify(vf,sec_caller) {
    var founduname=0;
    var foundpwd=0;
    var foundname=0;
    var foundid=0;
    var foundsec=0;
    var tw;
    for (i=0;i<=vf.nfields.value;i++) {
        tw=eval('vf.f'+i+'.selectedIndex');
        if (i==0 && tw!=0) { founduname=1; }
        if (((i>=1) && (i<=5)) && tw!=0 ) { foundname=1; }
        if (i==6 && tw!=0) { foundid=1; }
        if (i==7 && tw!=0) { foundsec=1; }
        if (i==8 && tw!=0) { foundpwd=1; }
    }
    verify_message(vf,founduname,foundpwd,foundname,foundid,foundsec);
}

function flip(vf,tf) {
   var nw=eval('vf.f'+tf+'.selectedIndex');
   var i;
   // picked the all one one name field, reset the other name ones to blank
   if (tf==1 && nw!=0) {
      for (i=2;i<=5;i++) {
         eval('vf.f'+i+'.selectedIndex=0;')
      }
   }
   //picked one of the piecewise name fields, reset the all in
   //one field to blank
   if ((tf>=2) && (tf<=5) && (nw!=0)) {
      eval('vf.f1.selectedIndex=0;')
   }
   // intial password specified, pick internal authentication
   if (tf==8 && nw!=0) {
       changed_radio('int',document.studentform);
       set_auth_radio_buttons('int',document.studentform);
       vf.krbarg.value='';
       vf.intarg.value='';
       vf.locarg.value='';
   }
}

function clearpwd(vf) {
    var i;
    if (eval('vf.f8.selectedIndex')!=0) {
        eval('vf.f8.selectedIndex=0;')
    }
}
ENDPICK
}

###############################################################
###############################################################
sub print_upload_manager_footer {
    my ($r,$i,$keyfields,$defdom,$today,$halfyear)=@_;

    my ($krbdef,$krbdefdom) =
        &Apache::loncommon::get_kerberos_defaults($defdom);
    my %param = ( formname => 'document.studentform',
                  kerb_def_dom => $krbdefdom,
                  kerb_def_auth => $krbdef
                  );
    if (exists($env{'form.ipwd_choice'}) &&
        defined($env{'form.ipwd_choice'}) &&
        $env{'form.ipwd_choice'} ne '') {
        $param{'curr_authtype'} = 'int';
    }
    my $krbform = &Apache::loncommon::authform_kerberos(%param);
    my $intform = &Apache::loncommon::authform_internal(%param);
    my $locform = &Apache::loncommon::authform_local(%param);
    my $domform = &domain_form($defdom);
    my $date_table = &date_setting_table();
    my $Str = "</table>\n";
    $Str .= &hidden_input('nfields',$i);
    $Str .= &hidden_input('keyfields',$keyfields);
    $Str .= '<h3>'.&mt('Login Type')."</h3>\n";
    $Str .= "<p>\n".
        &mt('Note: this will not take effect if the user already exists').
	&Apache::loncommon::help_open_topic('Auth_Options').
        "</p><p>\n";
    $Str .= $krbform."\n</p><p>\n".
        $intform."\n</p><p>\n".
        $locform."\n</p>\n";
    $Str .= '<h3>'.&mt('LON-CAPA Domain for Students')."</h3>\n";
    $Str .= "<p>\n".&mt('LON-CAPA domain: [_1]',$domform)."\n</p>\n";
    $Str .= "<h3>".&mt('Starting and Ending Dates')."</h3>\n";
    $Str .= "<p>\n".$date_table."</p>\n";
    $Str .= "<h3>".&mt('Full Update')."</h3>\n";
    $Str .= '<label><input type="checkbox" name="fullup" value="yes">'.
        ' '.&mt('Full update (also print list of users not enrolled anymore)').
        "</label></p>\n";
    $Str .= "<h3>".&mt('Student Number')."</h3>\n";
    $Str .= "<p>\n".'<label><input type="checkbox" name="forceid" value="yes">';
    $Str .= &mt('Disable ID/Student Number Safeguard and Force Change '.
                'of Conflicting IDs (only do if you know what you are doing)').
                "</label>\n</p><p>\n";
    $Str .= '<input type="button"'. 
              'onClick="javascript:verify(this.form,this.form.csec)" '.
        'value="Update Class List" />'."<br />\n";
    $Str .= &mt('Note: for large courses, this operation may be time '.
                'consuming');
    $r->print($Str);
    return;
}

###############################################################
###############################################################
sub print_upload_manager_form {
    my $r=shift;

    my $firstLine;
    my $datatoken;
    if (!$env{'form.datatoken'}) {
        $datatoken=&Apache::loncommon::upfile_store($r);
    } else {
        $datatoken=$env{'form.datatoken'};
        &Apache::loncommon::load_tmp_file($r);
    }
    my @records=&Apache::loncommon::upfile_record_sep();
    if($env{'form.noFirstLine'}){
        $firstLine=shift(@records);
    }
    my $total=$#records;
    my $distotal=$total+1;
    my $today=time;
    my $halfyear=$today+15552000;
    #
    # Restore memorized settings
    &Apache::loncommon::restore_course_settings
        ('enrollment_upload',{ 'username_choice' => 'scalar', # column settings
                               'names_choice' => 'scalar',
                               'fname_choice' => 'scalar',
                               'mname_choice' => 'scalar',
                               'lname_choice' => 'scalar',
                               'gen_choice' => 'scalar',
                               'id_choice' => 'scalar',
                               'sec_choice' => 'scalar',
                               'ipwd_choice' => 'scalar',
                               'email_choice' => 'scalar',
                           });
    #
    # Determine kerberos parameters as appropriate
    my $defdom=$env{'course.'.$env{'request.course.id'}.'.domain'};
    my ($krbdef,$krbdefdom) =
        &Apache::loncommon::get_kerberos_defaults($defdom);
    #
    &print_upload_manager_header($r,$datatoken,$distotal,$krbdefdom);
    my $i;
    my $keyfields;
    if ($total>=0) {
        my @field=
            (['username',&mt('Username'),     $env{'form.username_choice'}],
             ['names',&mt('Last Name, First Names'),$env{'form.names_choice'}],
             ['fname',&mt('First Name'),      $env{'form.fname_choice'}],
             ['mname',&mt('Middle Names/Initials'),$env{'form.mname_choice'}],
             ['lname',&mt('Last Name'),       $env{'form.lname_choice'}],
             ['gen',  &mt('Generation'),      $env{'form.gen_choice'}],
             ['id',   &mt('ID/Student Number'),$env{'form.id_choice'}],
             ['sec',  &mt('Section'),          $env{'form.sec_choice'}],
             ['ipwd', &mt('Initial Password'),$env{'form.ipwd_choice'}],
             ['email',&mt('EMail Address'),   $env{'form.email_choice'}]);
	if ($env{'form.upfile_associate'} eq 'reverse') {	
	    &Apache::loncommon::csv_print_samples($r,\@records);
	    $i=&Apache::loncommon::csv_print_select_table($r,\@records,
                                                          \@field);
	    foreach (@field) { 
                $keyfields.=$_->[0].','; 
            }
	    chop($keyfields);
	} else {
	    unshift(@field,['none','']);
	    $i=&Apache::loncommon::csv_samples_select_table($r,\@records,
                                                            \@field);
	    my %sone=&Apache::loncommon::record_sep($records[0]);
	    $keyfields=join(',',sort(keys(%sone)));
	}
    }
    &print_upload_manager_footer($r,$i,$keyfields,$defdom,$today,$halfyear);
}

###############################################################
###############################################################
sub enroll_single_student {
    my $r=shift;
    # Remove non alphanumeric values from section
    $env{'form.csec'}=~s/\W//g;
    #
    # We do the dates first because the action of making them the defaul
    # in the course is entirely separate from the action of enrolling the
    # student.  Also, a failure in setting the dates as default is not fatal
    # to the process of enrolling / modifying a student.
    my ($startdate,$enddate) = &get_dates_from_form();
    if ($env{'form.makedatesdefault'}) {
        $r->print(&make_dates_default($startdate,$enddate));
    }

    $r->print('<h3>'.&mt('Enrolling Student').'</h3>');
    $r->print('<p>'.&mt('Enrolling').' '.$env{'form.cuname'}." \@ ".
              $env{'form.lcdomain'}.'</p>');
    if (($env{'form.cuname'})
	&& ($env{'form.cuname'} 
	    eq &LONCAPA::clean_username($env{'form.cuname'}))
	&& ($env{'form.lcdomain'})
	&& ($env{'form.lcdomain'}
	    eq &LONCAPA::clean_domain($env{'form.lcdomain'}))) {
        # Deal with home server selection
        my $domain=$env{'form.lcdomain'};
        my $desiredhost = $env{'form.lcserver'};
        if (lc($desiredhost) eq 'default') {
            $desiredhost = undef;
        } else {
            my %home_servers =&Apache::loncommon::get_library_servers($domain);
            if (! exists($home_servers{$desiredhost})) {
                $r->print('<font color="#ff0000">'.&mt('Error').':</font>'.
                          &mt('Invalid home server specified'));
                return;
            }
        }
        $r->print(" ".&mt('with server')." $desiredhost :") if (defined($desiredhost));
        # End of home server selection logic
	my $amode='';
        my $genpwd='';
        if ($env{'form.login'} eq 'krb') {
           $amode='krb';
	   $amode.=$env{'form.krbver'};
           $genpwd=$env{'form.krbarg'};
        } elsif ($env{'form.login'} eq 'int') {
           $amode='internal';
           $genpwd=$env{'form.intarg'};
        }  elsif ($env{'form.login'} eq 'loc') {
	    $amode='localauth';
	    $genpwd=$env{'form.locarg'};
	    if (!$genpwd) { $genpwd=" "; }
	}
        my $home = &Apache::lonnet::homeserver($env{'form.cuname'},
                                                   $env{'form.lcdomain'});
        if ((($amode) && ($genpwd)) || ($home ne 'no_host')) {
            # Clean out any old roles the student has in this class.
            &modifystudent($env{'form.lcdomain'},$env{'form.cuname'},
                           $env{'request.course.id'},$env{'form.csec'},
                            $desiredhost);
            my $login_result = &Apache::lonnet::modifystudent
                ($env{'form.lcdomain'},$env{'form.cuname'},
                 $env{'form.cstid'},$amode,$genpwd,
                 $env{'form.cfirst'},$env{'form.cmiddle'},
                 $env{'form.clast'},$env{'form.cgen'},
                 $env{'form.csec'},$enddate,
                 $startdate,$env{'form.forceid'},
                 $desiredhost,$env{'form.emailaddress'});
            if ($login_result =~ /^ok/) {
                $r->print($login_result);
                $r->print("<p> ".&mt('If active, the new role will be available when the student next logs in to LON-CAPA.')."</p>");
            } else {
                $r->print(&mt('unable to enroll').": ".$login_result);
            }
	} else {
            $r->print('<p><font color="#ff0000">'.&mt('ERROR').'</font>&nbsp;');
            if ($amode =~ /^krb/) {
                $r->print(&mt('Missing Kerberos domain information.').'  ');
            } else {
                $r->print(&mt('Invalid login mode or password.').'  ');
            }
            $r->print('<b>'.&mt('Unable to enroll').' '.$env{'form.cuname'}.'.</b></p>');
        }
    } else {
        $r->print(&mt('Invalid username or domain'));
    }    
}

sub setup_date_selectors {
    my ($starttime,$endtime,$mode) = @_;
    if (! defined($starttime)) {
        $starttime = time;
        unless ($mode eq 'create_enrolldates' || $mode eq 'create_defaultdates') {
            if (exists($env{'course.'.$env{'request.course.id'}.
                            '.default_enrollment_start_date'})) {
                $starttime = $env{'course.'.$env{'request.course.id'}.
                                  '.default_enrollment_start_date'};
            }
        }
    }
    if (! defined($endtime)) {
        $endtime = time+(6*30*24*60*60); # 6 months from now, approx
        unless ($mode eq 'createcourse') {
            if (exists($env{'course.'.$env{'request.course.id'}.
                            '.default_enrollment_end_date'})) {
                $endtime = $env{'course.'.$env{'request.course.id'}.
                                '.default_enrollment_end_date'};
            }
        }
    }
    my $startdateform = &Apache::lonhtmlcommon::date_setter('studentform',
                                                            'startdate',
                                                            $starttime);
    my $enddateform = &Apache::lonhtmlcommon::date_setter('studentform',
                                                          'enddate',
                                                          $endtime);
    if ($mode eq 'create_enrolldates') {
        $startdateform = &Apache::lonhtmlcommon::date_setter('ccrs',
                                                            'startenroll',
                                                            $starttime);
        $enddateform = &Apache::lonhtmlcommon::date_setter('ccrs',
                                                          'endenroll',
                                                          $endtime);
    }
    if ($mode eq 'create_defaultdates') {
        $startdateform = &Apache::lonhtmlcommon::date_setter('ccrs',
                                                            'startaccess',
                                                            $starttime);
        $enddateform = &Apache::lonhtmlcommon::date_setter('ccrs',
                                                          'endaccess',
                                                          $endtime);
    }
    return ($startdateform,$enddateform);
}

sub get_dates_from_form {
    my $startdate = &Apache::lonhtmlcommon::get_date_from_form('startdate');
    my $enddate   = &Apache::lonhtmlcommon::get_date_from_form('enddate');
    if ($env{'form.no_end_date'}) {
        $enddate = 0;
    }
    return ($startdate,$enddate);
}

sub date_setting_table {
    my ($starttime,$endtime,$mode) = @_;
    my ($startform,$endform)=&setup_date_selectors($starttime,$endtime,$mode);
    my $dateDefault = '<nobr>'.
        '<label><input type="checkbox" name="makedatesdefault" /> '.
        &mt('make these dates the default for future enrollment').'</label>';
    if ($mode eq 'create_enrolldates' || $mode eq 'create_defaultdates') {
        $dateDefault = '&nbsp;';
    }
    my $perpetual = '<nobr><label><input type="checkbox" name="no_end_date"';
    if (defined($endtime) && $endtime == 0) {
        $perpetual .= ' checked';
    }
    $perpetual.= ' /> '.&mt('no ending date').'</label></nobr>';
    if ($mode eq 'create_enrolldates') {
        $perpetual = '&nbsp;';
    }
    my $result = '';
    $result .= "<table>\n";
    $result .= '<tr><td align="right">'.&mt('Starting Date').'</td>'.
        '<td>'.$startform.'</td>'.
        '<td>'.$dateDefault.'</td>'."</tr>\n";
    $result .= '<tr><td align="right">'.&mt('Ending Date').'</td>'.
        '<td>'.$endform.'</td>'.
        '<td>'.$perpetual.'</td>'."</tr>\n";
    $result .= "</table>\n";
    return $result;
}

sub make_dates_default {
    my ($startdate,$enddate) = @_;
    my $result = '';
    my $dom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    my $crs = $env{'course.'.$env{'request.course.id'}.'.num'};
    my $put_result = &Apache::lonnet::put('environment',
            {'default_enrollment_start_date'=>$startdate,
             'default_enrollment_end_date'  =>$enddate},$dom,$crs);
    if ($put_result eq 'ok') {
        $result .= "Set default start and end dates for course<br />";
        #
        # Refresh the course environment
        &Apache::lonnet::coursedescription($env{'request.course.id'},
					   {'freshen_cache' => 1});
    } else {
        $result .= &mt('Unable to set default dates for course').":".$put_result.
            '<br />';
    }
    return $result;
}

##
## Single student enrollment routines (some of them)
##
sub get_student_username_domain_form {
    my $r = shift;
    my $domform = &Apache::loncommon::select_dom_form
        ($env{'course.'.$env{'request.course.id'}.'.domain'},'cudomain',0);
    my %lt=&Apache::lonlocal::texthash(
		    'eos'  => "Enroll One Student",
		    'usr'  => "Username",
                    'dom'  => "Domain",
                    'been' => "Begin Enrollment",
				       );
    $r->print(<<END);
<input type="hidden" name="action" value="enrollstudent" />
<input type="hidden" name="state"  value="gotusername" />
<h3>$lt{'eos'}</h3>
<table>
<tr><th>$lt{'usr'}:</th>
    <td><input type="text" name="cuname"  size="15" /></td></tr>
<tr><th>$lt{'dom'}:</th>
    <td>$domform</td></tr>
<tr><th>&nbsp;</th>
    <td>
    <input type="submit" name="Begin Enrollment" value="$lt{'been'}" />
    </td></tr>
</table>
<script type="text/javascript">
// the if prevents the script error if the browser can not handle this
if ( document.studentform.cuname ) { document.studentform.cuname.focus(); }
</script>
END
    return;
}

sub print_enroll_single_student_form {
    my $r=shift;
    $r->print("<h3>".&mt('Enroll One Student')."</h3>");
    #
    my $username = &LONCAPA::clean_username($env{'form.cuname'});
    my $domain   = &LONCAPA::clean_domain($env{'form.cudomain'});
    my $home = &Apache::lonnet::homeserver($username,$domain);
    # $new_user flags whether we are creating a new user or using an old one
    my $new_user = 1;
    if ($home ne 'no_host') {
        $new_user = 0;
    }
    #
    my $user_data_html = '';
    my $javascript_validations = '';
    if ($new_user) {
        my $defdom=$env{'course.'.$env{'request.course.id'}.'.domain'};
        # Set up authentication forms
        my ($krbdef,$krbdefdom) =
            &Apache::loncommon::get_kerberos_defaults($domain);
        $javascript_validations=&javascript_validations('auth',$krbdefdom);
        my %param = ( formname => 'document.studentform',
                      kerb_def_dom => $krbdefdom,
                      kerb_def_auth => $krbdef
                      );
        my $krbform = &Apache::loncommon::authform_kerberos(%param);
        my $intform = &Apache::loncommon::authform_internal(%param);
        my $locform = &Apache::loncommon::authform_local(%param);
        #
        # Set up domain selection form
        my $homeserver_form = '';
        my %servers = &Apache::loncommon::get_library_servers($domain);
        $homeserver_form = '<select name="lcserver" size="1">'."\n".
            '<option value="default" selected>default</option>'."\n";
        while (my ($servername,$serverdescription) = each (%servers)) {
            $homeserver_form .= '<option value="'.$servername.'">'.
                $serverdescription."</option>\n";
        }
        $homeserver_form .= "</select>\n";
        #
        #
	my %lt=&Apache::lonlocal::texthash(
		       'udf'  => "User Data for",
                       'fn'   => "First Name",
                       'mn'   => "Middle Name",
                       'ln'   => "Last Name",
                       'gen'  => "Generation",
                       'hs'   => "Home Server",
                       'pswd' => "Password",
		       'psam' => "Please select an authentication mechanism",
                       'mail' => "Email Address"
					   );
	my $authhelp=&Apache::loncommon::help_open_topic('Auth_Options');
        $user_data_html = <<END;
<h3>$lt{'udf'} $username\@$domain</h3>
<table>
<tr><th>$lt{'fn'}:</th>
    <td><input type="text" name="cfirst"  size="15"></td></tr>
<tr><th>$lt{'mn'}:</th>
    <td><input type="text" name="cmiddle" size="15"></td></tr>
<tr><th>$lt{'ln'}:</th>
    <td><input type="text" name="clast"   size="15"></td></tr>
<tr><th>$lt{'gen'}:</th>
    <td><input type="text" name="cgen"    size="5"> </td></tr>
<tr><th>$lt{'hs'}:</th>
    <td>$homeserver_form</td></tr>
<tr><th>$lt{'mail'}:</th>
    <td><input type="text" name="emailaddress" size="20" /></td></tr>
</table>
<h3>$lt{'pswd'}</h3>
$lt{'psam'}$authhelp
<table>
<p>
$krbform
<br />
$intform
<br />
$locform
</p>
END
    } else {
        # User already exists.  Do not worry about authentication
        my %uenv = &Apache::lonnet::dump('environment',$domain,$username);
        $javascript_validations = &javascript_validations('noauth');
	my %lt=&Apache::lonlocal::texthash(
		       'udf'  => "User Data for",
                       'fn'   => "First Name",
                       'mn'   => "Middle Name",
                       'ln'   => "Last Name",
                       'gen'  => "Generation",
                       'mail' => "Email Address",
					   );
        $user_data_html = <<END;
<h3>$lt{'udf'} $username\@$domain</h3>
<input type="hidden" name="lcserver" value="default" />
<table>
<tr><th>$lt{'fn'}:</th>
    <td>
    <input type="text" name="cfirst" value="$uenv{'firstname'}" size="15" />
    </td></tr>
<tr><th>$lt{'mn'}:</th>
    <td>
    <input type="text" name="cmiddle" value="$uenv{'middlename'}" size="15" />
    </td></tr>
<tr><th>$lt{'ln'}:</th>
    <td>
    <input type="text" name="clast"value="$uenv{'lastname'}" size="15" />
    </td></tr>
<tr><th>$lt{'gen'}:</th>
    <td>
    <input type="text" name="cgen" value="$uenv{'generation'}" size="5" />
    </td></tr>
<tr><th>$lt{'mail'}:</th>
    <td>
    <input type="text" name="emailaddress" value="$uenv{'permanentemail'}" size="20" />
    </td></tr>
</table>
END
    }
    my $date_table = &date_setting_table();
        # Print it all out
    my %lt=&Apache::lonlocal::texthash(
		   'cd'   => "Course Data",
                   'gs'   => "Section",
                   'idsn' => "ID/Student Number",
                   'disn' => "Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)",
                   'eas'  => "Enroll as student",
				       );
    $r->print(<<END);
<input type="hidden" name="action" value="enrollstudent" />
<input type="hidden" name="state"  value="done" />
<input type="hidden" name="cuname" value="$username" />
<input type="hidden" name="lcdomain" value="$domain" />
<script type="text/javascript" language="Javascript">
function verify(vf,sec_caller) {
    var founduname=0;
    var foundpwd=0;
    var foundname=0;
    var foundid=0;
    var foundsec=0;
    var tw;
    if ((typeof(vf.cuname.value) !="undefined") && (vf.cuname.value!='') && 
	(typeof(vf.lcdomain.value)!="undefined") && (vf.lcdomain.value!='')) {
        founduname=1;
    }
    if ((typeof(vf.cfirst.value)!="undefined") && (vf.cfirst.value!='') &&
	(typeof(vf.clast.value) !="undefined") && (vf.clast.value!='')) {
        foundname=1;
    }
    if ((typeof(vf.csec.value)!="undefined") && (vf.csec.value!='')) {
        foundsec=1;
        if (validate(sec_caller) == "error") {
            return;
        }
    }
    if ((typeof(vf.cstid.value)!="undefined") && (vf.cstid.value!='')) {
	foundid=1;
    }
    if (founduname==0) {
	alert('You need to specify at least the username and domain fields');
        return;
    }
    verify_message(vf,founduname,foundpwd,foundname,foundid,foundsec);
}

$javascript_validations

function clearpwd(vf) {
    //nothing else needs clearing
}

</script>

$user_data_html

<h3>$lt{'cd'}</h3>

<p>$lt{'gs'}: <input type="text" name="csec" size="5" />
<p>
$date_table
</p>
<h3>$lt{'idsn'}</h3>
<p>
$lt{'idsn'}: <input type="text" name="cstid" size="10">
</p><p>
<label>
<input type="checkbox" name="forceid" value="yes"> 
$lt{'disn'}
</label>
</p><p>
<input type="button" onClick="verify(this.form,this.form.csec)" value="$lt{'eas'}">
</p>
END
    return;
}

# ========================================================= Menu Phase Two Drop
sub print_drop_menu {
    my $r=shift;
    $r->print("<h3>".&mt('Drop Students')."</h3>");
    my $cid=$env{'request.course.id'};
    my ($classlist,$keylist) = &Apache::loncoursedata::get_classlist();
    if (! defined($classlist)) {
        $r->print(&mt('There are no students currently enrolled.')."\n");
        return;
    }
    # Print out the available choices
    &show_drop_list($r,$classlist,$keylist);
    return;
}

# ============================================== view classlist
sub print_html_classlist {
    my ($r,$mode) = @_;
    if (! exists($env{'form.sortby'})) {
        $env{'form.sortby'} = 'username';
    }
    if ($env{'form.Status'} !~ /^(Any|Expired|Active|Future)$/) {
        $env{'form.Status'} = 'Active';
    }
    my $status_select = &Apache::lonhtmlcommon::StatusOptions
        ($env{'form.Status'});
    my $cid =$env{'request.course.id'};
    my $cdom=$env{'course.'.$cid.'.domain'};
    my $cnum=$env{'course.'.$cid.'.num'};
    #
    # List course personnel
    my %coursepersonnel=&Apache::lonnet::get_course_adv_roles($cdom.'/'.$cnum);
    #
    if (! defined($env{'form.output'}) ||
        $env{'form.output'} !~ /^(csv|excel|html)$/ ) {
        $env{'form.output'} = 'html';
    }
    #
    $r->print('<br />'.&Apache::loncommon::start_data_table());
    foreach my $role (sort keys %coursepersonnel) {
        next if ($role =~ /^\s*$/);
	$r->print(&Apache::loncommon::start_data_table_row().
		  '<td>'.$role.'</td><td>');
        foreach my $user (split(',',$coursepersonnel{$role})) {
	    my ($puname,$pudom)=split(':',$user);
	    $r->print(' '.&Apache::loncommon::aboutmewrapper(
                                    &Apache::loncommon::plainname($puname,
                                                                  $pudom),
                                                             $puname,$pudom));
	}
        $r->print('</td>'.&Apache::loncommon::end_data_table_row());
    }
    $r->print(&Apache::loncommon::end_data_table());
    #
    # Interface output
    $r->print('<input type="hidden" name="action" value="'.
              $env{'form.action'}.'" />');
    $r->print("<p>\n");
    if ($env{'form.action'} ne 'modifystudent') {
	my %lt=&Apache::lonlocal::texthash('csv' => "CSV",
                                           'excel' => "Excel",
                                           'html'  => 'HTML');
        my $output_selector = '<select size="1" name="output" >';
        foreach my $outputformat ('html','csv','excel') {
            my $option = '<option value="'.$outputformat.'" ';
            if ($outputformat eq $env{'form.output'}) {
                $option .= 'selected ';
            }
            $option .='>'.$lt{$outputformat}.'</option>';
            $output_selector .= "\n".$option;
        }
        $output_selector .= '</select>';
        $r->print(&mt('Output Format: [_1]',$output_selector).('&nbsp;'x3));
    }
    $r->print(&mt('Student Status: [_1]',$status_select)."\n");
    $r->print('<input type="submit" value="'.&mt('Update Display').'" />'.
              "\n</p>\n");
    #
    # Print the classlist
    $r->print('<h2>'.&mt('Current Class List').'</h2>');
    my ($classlist,$keylist)=&Apache::loncoursedata::get_classlist();
    if (! defined($classlist)) {
        $r->print(&mt('There are no students currently enrolled.')."\n");
    } else {
        # Print out the available choices
        if ($env{'form.action'} eq 'modifystudent') {
            &show_class_list($r,'view','modify',
                             $env{'form.Status'},$classlist,$keylist);
        } else {
            &show_class_list($r,$env{'form.output'},'aboutme',
                             $env{'form.Status'},$classlist,$keylist);
        }
    }
}

# =================================================== Show student list to drop
sub show_class_list {
    my ($r,$mode,$linkto,$statusmode,$classlist,$keylist)=@_;
    my $cid=$env{'request.course.id'};
    my $cdom = $env{'course.'.$cid.'.domain'};
    my $cnum = $env{'course.'.$cid.'.num'};
    my ($classgroups) = &Apache::loncoursedata::get_group_memberships(
                                              $classlist,$keylist,$cdom,$cnum);
    #
    # Variables for excel output
    my ($excel_workbook, $excel_sheet, $excel_filename,$row,$format);
    #
    # Variables for csv output
    my ($CSVfile,$CSVfilename);
    #
    my $sortby = $env{'form.sortby'};
    if ($sortby !~ /^(username|domain|section|groups|fullname|id|start|end|type)$/) {
        $sortby = 'username';
    }
    if (! exists($env{'form.displayphotos'})) {
        $env{'form.displayphotos'} = 'off';
    }
    my $displayphotos = $env{'form.displayphotos'};

    # Print out header 
    unless ($mode eq 'autoenroll') {
        $r->print(<<END);
<input type="hidden" name="state" value="$env{'form.state'}" />
END
    }
    $r->print(<<END);
<input type="hidden" name="sortby" value="$sortby" />
<input type="hidden" name="displayphotos" value="$displayphotos" />
END
    if ($mode eq 'html' || $mode eq 'view' || $mode eq 'autoenroll') {
        if ($linkto eq 'aboutme') {
            $r->print(&mt("Select a user name to view the user's personal page."));
        } elsif ($linkto eq 'modify') {
            $r->print(&mt("Select a user name to modify the student's information"));
        }
	my %lt=&Apache::lonlocal::texthash(
                                           'usrn'   => "username",
                                           'dom'    => "domain",
                                           'sn'     => "student name",
                                           'sec'    => "section",
                                           'grp'    => "active groups",
                                           'start'  => "start date",
                                           'end'    => "end date",
                                           'type'   => "enroll type/action",
                                           'photo'  => "photo",
					   );
        unless ($mode eq 'autoenroll') {
            $r->print(<<END);
<input type="hidden" name="sname"  value="" />
<input type="hidden" name="sdom"   value="" />
END
        }
        if ($env{'course.'.$env{'request.course.id'}.'.internal.showphoto'}) {
            $r->print('
<script type="text/javascript">
function photowindow(photolink) {
    var title = "Photo_Viewer";
    var options = "scrollbars=1,resizable=1,menubar=0";
    options += ",width=240,height=240";
    stdeditbrowser = open(photolink,title,options,"1");
    stdeditbrowser.focus();
}
</script>
           ');
        }
        $r->print("
<p>
".&Apache::loncommon::start_data_table()."
<tr>
        ");
        if ($mode eq 'autoenroll') {
            $r->print("
 <th><a href=\"javascript:document.studentform.sortby.value='type';document.studentform.submit();\">$lt{'type'}</a></th>
            ");
        } else {
            $r->print("
<th>Count</th>
            ");
        }
        $r->print(<<END);
    <th>
       <a href="javascript:document.studentform.sortby.value='username';document.studentform.submit();">$lt{'usrn'}</a>
    </th><th>
       <a href="javascript:document.studentform.sortby.value='domain';document.studentform.submit();">$lt{'dom'}</a>
    </th><th>
       <a href="javascript:document.studentform.sortby.value='id';document.studentform.submit();">ID</a>
    </th><th>
       <a href="javascript:document.studentform.sortby.value='fullname';document.studentform.submit();">$lt{'sn'}</a>
    </th><th>
       <a href="javascript:document.studentform.sortby.value='section';document.studentform.submit();">$lt{'sec'}</a>
    </th><th>
       <a href="javascript:document.studentform.sortby.value='start';document.studentform.submit();">$lt{'start'}</a>
    </th><th>
       <a href="javascript:document.studentform.sortby.value='end';document.studentform.submit();">$lt{'end'}</a>
    </th><th>
       <a href="javascript:document.studentform.sortby.value='groups';document.studentform.submit();">$lt{'grp'}</a>
    </th>
END
        if ($env{'course.'.$env{'request.course.id'}.'.internal.showphoto'}) {
            my %photo_options = &Apache::lonlocal::texthash(
                                                            'on' => 'Show',
                                                            'off' => 'Hide',
                                                            );
            my $photochg = 'on';
            if ($displayphotos eq 'on') {
                $photochg = 'off';
            }
            $r->print('    <th>'."\n".'     '. 
            '<a href="javascript:document.studentform.displayphotos.value='.
                      "'".$photochg."'".';document.studentform.submit();">'.
                      $photo_options{$photochg}.'</a>&nbsp;'.$lt{'photo'}."\n".
                      '    </th>'."\n");
        }
        $r->print("  </tr>\n");
    } elsif ($mode eq 'csv') {
	#
	# Open a file
	$CSVfilename = '/prtspool/'.
	    $env{'user.name'}.'_'.$env{'user.domain'}.'_'.
            time.'_'.rand(1000000000).'.csv';
	unless ($CSVfile = Apache::File->new('>/home/httpd'.$CSVfilename)) {
	    $r->log_error("Couldn't open $CSVfilename for output $!");
	    $r->print("Problems occured in writing the csv file.  ".
		      "This error has been logged.  ".
		      "Please alert your LON-CAPA administrator.");
	    $CSVfile = undef;
	}
	#
	# Write headers and data to file
        if($statusmode eq 'Expired') {
            print $CSVfile '"'.&mt('Students with expired roles').'"'."\n";
        }
        if($statusmode eq 'Future') {
            print $CSVfile '"'.&mt('Students with future roles').'"'."\n";
        }
        if ($statusmode eq 'Any') {
            print $CSVfile '"'.join('","',map {
		&Apache::loncommon::csv_translate(&mt($_))
                } ("username","domain","ID","student name",
                   "section","start date","end date","status","active groups"))
                  .'"'."\n";
        } else {
            print $CSVfile '"'.join('","',map {
		&Apache::loncommon::csv_translate(&mt($_))
                } ("username","domain","ID","student name",
                   "section","start date","end date","active groups")).'"'."\n";
        }
    } elsif ($mode eq 'excel') {
        # Create the excel spreadsheet
        ($excel_workbook,$excel_filename,$format) = 
            &Apache::loncommon::create_workbook($r);
        return if (! defined($excel_workbook));
        $excel_sheet = $excel_workbook->addworksheet('classlist');
        #
        my $description = 'Class List for '.
            $env{'course.'.$env{'request.course.id'}.'.description'};
        $excel_sheet->write($row++,0,$description,$format->{'h1'});
        #
        $excel_sheet->write($row++,0,["username","domain","ID",
                                      "student name","section",
                                      "start date","end date","status",
                                      "active groups"],
                            $format->{'bold'});
    }
    #
    # Sort the students
    my %index;
    my $i;
    foreach (@$keylist) {
        $index{$_} = $i++;
    }
    $index{'groups'} = scalar(@{$keylist});
    my $index  = $index{$sortby};
    my $second = $index{'username'};
    my $third  = $index{'domain'};
    my @Sorted_Students = sort {
        lc($classlist->{$a}->[$index])  cmp lc($classlist->{$b}->[$index])
            ||
        lc($classlist->{$a}->[$second]) cmp lc($classlist->{$b}->[$second])
            ||
        lc($classlist->{$a}->[$third]) cmp lc($classlist->{$b}->[$third])
        } (keys(%$classlist));
    my $studentcount = 0;
    my $autocount = 0;
    my $manualcount = 0;
    my $unlockcount = 0;
    my $lockcount = 0;
    foreach my $student (@Sorted_Students) {
        my $sdata = $classlist->{$student};
        my $groups = $classgroups->{$student};
        my $username = $sdata->[$index{'username'}];
        my $domain   = $sdata->[$index{'domain'}];
        my $section  = $sdata->[$index{'section'}];
        my $active_groups;
        if (ref($groups->{active}) eq 'HASH') {
            $active_groups = join(', ',keys(%{$groups->{'active'}}));
        }
        my $name     = $sdata->[$index{'fullname'}];
        my $id       = $sdata->[$index{'id'}];
        my $status   = $sdata->[$index{'status'}];
        my $start    = $sdata->[$index{'start'}];
        my $end      = $sdata->[$index{'end'}];
        my $type     = $sdata->[$index{'type'}];
        next if (($statusmode ne 'Any') && ($status ne $statusmode));
        if ($mode eq 'view' || $mode eq 'html' || $mode eq 'autoenroll') {
            if (! defined($start) || $start == 0) {
                $start = &mt('none');
            } else {
                $start = &Apache::lonlocal::locallocaltime($start);
            }
            if (! defined($end) || $end == 0) {
                $end = &mt('none');
            } else {
                $end = &Apache::lonlocal::locallocaltime($end);
            }
	    $r->print(&Apache::loncommon::start_data_table_row());
            if ($mode eq 'autoenroll') {
                my $lockedtype = $sdata->[$index{'lockedtype'}];
                $studentcount++;
                my $cellentry;
                if ($type eq 'auto') {
                    $cellentry = '<b>'.&mt('auto').'</b>&nbsp;<label><input type="checkbox" name="chgauto" value="'.$username.':'.$domain.'" />&nbsp;Change</label>';
                    $autocount ++;
                } else {
                    $cellentry = '<table border="0" cellspacing="0"><tr><td rowspan="2"><b>'.&mt('manual').'</b></td><td><nobr><label><input type="checkbox" name="chgmanual" value="'.$username.':'.$domain.'" />&nbsp;Change</label></nobr></td></tr><tr><td><nobr>';
                    $manualcount ++;
                    if ($lockedtype) {
                        $cellentry .= '<label><input type="checkbox" name="unlockchg" value="'.$username.':'.$domain.'" />&nbsp;'.&mt('Unlock').'</label>';
                        $unlockcount ++;
                    } else {
                        $cellentry .= '<label><input type="checkbox" name="lockchg" value="'.$username.':'.$domain.'" />&nbsp;'.&mt('Lock').'</label>';
                        $lockcount ++;
                    }
                    $cellentry .= '</nobr></td></tr></table>';
                }
                $r->print("<td>$cellentry<td>\n    ");
            } else {
                $r->print("<td>".(++$studentcount)."</td><td>\n    ");
            }
            if ($linkto eq 'nothing') {
                $r->print($username);
            } elsif ($linkto eq 'aboutme') {
                $r->print(&Apache::loncommon::aboutmewrapper($username,
                                                             $username,
                                                             $domain));
            } elsif ($linkto eq 'modify') {
                $r->print('<a href="'.
                          "javascript:document.studentform.sname.value='".
                          $username.
                          "';document.studentform.sdom.value='".$domain.
                          "';document.studentform.state.value='selected".
                          "';document.studentform.submit();".'">'.
                          $username."</a>\n");
            }
            $r->print(<<"END");
    </td>
    <td>$domain</td>
    <td>$id</td>
    <td>$name</td>
    <td>$section</td>
    <td>$start</td>
    <td>$end</td>
    <td>$active_groups</td>
END
            if ($env{'course.'.$env{'request.course.id'}.
			 '.internal.showphoto'}) {
                if ($displayphotos eq 'on') {
                    my $imgurl = 
			&Apache::lonnet::retrievestudentphoto($domain,
							      $username,'gif',
							      'thumbnail');
                
                    $r->print('    <td align="right"><a href="javascript:photowindow('."'".&Apache::lonnet::studentphoto($domain,$username,'jpg')."'".')"><img src="'.$imgurl.'" border="1"></a></td>');
                } else {
                    $r->print('    <td>&nbsp;</td>  ');
                }
            }
	    $r->print(&Apache::loncommon::end_data_table_row());
        } elsif ($mode eq 'csv') {
            next if (! defined($CSVfile));
            # no need to bother with $linkto
            if (! defined($start) || $start == 0) {
                $start = &mt('none');
            } else {
                $start = &Apache::lonlocal::locallocaltime($start);
            }
            if (! defined($end) || $end == 0) {
                $end = &mt('none');
            } else {
                $end = &Apache::lonlocal::locallocaltime($end);
            }
            my @line = ();
            foreach ($username,$domain,$id,$name,$section,$start,$end) {
                push @line,&Apache::loncommon::csv_translate($_);
            }
            if ($statusmode eq 'Any') {
                push @line,&Apache::loncommon::csv_translate($status);
            }
            push @line,&Apache::loncommon::csv_translate($active_groups);
            print $CSVfile '"'.join('","',@line).'"'."\n";
        } elsif ($mode eq 'excel') {
            $excel_sheet->write($row,0,[$username,$domain,$id,
                                          $name,$section]);
            my $col = 5;
            foreach my $time ($start,$end) {
                if (defined($time) && $time != 0) {
                    $excel_sheet->write($row,$col++,
                                   &Apache::lonstathelpers::calc_serial($time),
                                    $format->{'date'});
                } else {
                    $excel_sheet->write($row,$col++,'none');
                }                    
            }
            $excel_sheet->write($row,$col++,$status);
            $excel_sheet->write($row,$col++,$active_groups);
            $row++;
        }
    }
    if ($mode eq 'view' || $mode eq 'html' || $mode eq 'autoenroll') {
	$r->print(&Apache::loncommon::end_data_table().'<br />');
    } elsif ($mode eq 'excel') {
        $excel_workbook->close();
        $r->print('<p><a href="'.$excel_filename.'">'.
                  &mt('Your Excel spreadsheet').'</a> '.&mt('is ready for download').'.</p>'."\n");
    } elsif ($mode eq 'csv') {
        close($CSVfile);
        $r->print('<a href="'.$CSVfilename.'">'.
                  &mt('Your CSV file').'</a> is ready for download.'.
                  "\n");
        $r->rflush();
    }
    if ($mode eq 'autoenroll') {
        return ($studentcount,$autocount,$manualcount,$lockcount,$unlockcount);
    }
    return;
}


#
# print out form for modification of a single students data
#
sub print_modify_student_form {
    my $r = shift();
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['sdom','sname']);    
    my $sname  = $env{'form.sname'};
    my $sdom   = $env{'form.sdom'};
    my $sortby = $env{'form.sortby'};
    # determine the students name information
    my %info=&Apache::lonnet::get('environment',
                                  ['firstname','middlename',
                                   'lastname','generation','id'],
                                  $sdom, $sname);
    my ($tmp) = keys(%info);
    if ($tmp =~ /^(con_lost|error|no_such_host)/i) {
        $r->print('<font color="#ff0000" size="+2">'.&mt('Error').'</font>'.
                  '<p>'.
                  &mt('Unable to retrieve environment data for').' '.$sname.
                  &mt('in domain').' '.$sdom.'</p><p>'.
                  &mt('Please contact your LON-CAPA administrator regarding this situation.').'</p>'.&Apache::loncommon::end_page());
        return;
    }
    # determine the students starting and ending times and section
    my ($starttime,$endtime,$section) = &get_enrollment_data($sname,$sdom);
    if ($starttime =~ /^error/) {
        $r->print('<h2>'&mt('Error').'</h2>');
        $r->print('<p>'.$starttime.'</p>');
        return;
    }
    #
    # Deal with date forms
    my $current_date_description = '';
    my $textdate = '';

    if (! defined($starttime) || $starttime == 0) {
        $current_date_description = &mt('Current Starting Date: not set').
            '<br />';
    } else {
        $current_date_description = 
            &mt('Current Starting Date: [_1]',
                &Apache::lonlocal::locallocaltime($starttime)).'<br />';
    }
    if (! defined($endtime) || $endtime == 0) {
        $current_date_description.= &mt('Current Ending Date: not set').
            '<br />';
    } else {
        $current_date_description.= 
            &mt('Current Ending Date: [_1]',
                &Apache::lonlocal::locallocaltime($endtime)).'<br />';

    }
    my $date_table = &date_setting_table($starttime,$endtime);
    #
    if (! exists($env{'form.Status'}) || 
        $env{'form.Status'} !~ /^(Any|Expired|Active|Future)$/) {
        $env{'form.Status'} = 'crap';
    }
    # Make sure student is enrolled in course
    my %lt=&Apache::lonlocal::texthash(
	           'mef'   => "Modify Enrollment for",
                   'odcc'  => "Only domain coordinators can change a users password.",
                   'sn'    => "Student Name",
                   'fn'    => "First",
                   'mn'    => "Middle",
                   'ln'    => "Last",
                   'gen'   => "Generation",
                   'sid'   => "Student ID",
                   'disn'  => "Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)",
                   'sec'   => "Section",
                   'sm'    => "Submit Modifications",
				       );
# Check if section name is valid
    my $section_check = &section_check_js();
    $r->print(<<"END");
<script type="text/javascript">
$section_check
function secverify(formname,caller) {
    if (validate(caller) == "error") {
        return;
    } else {
        formname.submit();
    }
}
</script>
<p>
<font size="+1">
$lt{'odcc'}
</font>
</p>
<input type="hidden" name="slogin"  value="$sname"  />
<input type="hidden" name="sdomain" value="$sdom" />
<input type="hidden" name="action"  value="modifystudent" />
<input type="hidden" name="state"   value="done" />
<input type="hidden" name="sortby"  value="$sortby" />
<input type="hidden" name="Status"  value="$env{'form.Status'}" />
<h2>$lt{'mef'} $info{'firstname'} $info{'middlename'} 
$info{'lastname'} $info{'generation'}, $sname\@$sdom</h2>
<p>
<b>$lt{'sn'}</b>
<table>
<tr><th>$lt{'fn'}</th><th>$lt{'mn'}</th><th>$lt{'ln'}</th><th>$lt{'gen'}</th></tr>
<tr><td>
<input type="text" name="firstname"  value="$info{'firstname'}"  /></td><td>
<input type="text" name="middlename" value="$info{'middlename'}" /></td><td>
<input type="text" name="lastname"   value="$info{'lastname'}"   /></td><td>
<input type="text" name="generation" value="$info{'generation'}" /></td></tr>
</table>
</p><p>
<b>$lt{'sid'}</b>: <input type="text" name="id" value="$info{'id'}" size="12"/>
</p><p>
<label>
<input type="checkbox" name="forceid" > 
$lt{'disn'}
</label>
</p><p>
<b>$lt{'sec'}</b>: <input type="text" name="section" value="$section" size="14"/>
</p>
<p>$current_date_description</p>
<p>$date_table</p>
<input type="button" value="$lt{'sm'}" onClick="secverify(this.form,this.form.section)" />
END
    $r->print(&Apache::loncommon::end_page());
    return;
}

#
# modify a single students section 
#
sub modify_single_student {
    my ($r) = @_;
    #
    # Remove non alphanumeric values from the section
    $env{'form.section'} =~ s/\W//g;
    #
    # Do the date defaults first
    my ($starttime,$endtime) = &get_dates_from_form();
    if ($env{'form.makedatesdefault'}) {
        $r->print(&make_dates_default($starttime,$endtime));
    }
    # Get the 'sortby' and 'Status' variables so the user goes back to their
    # previous screen
    my $sortby = $env{'form.sortby'};
    my $status = $env{'form.Status'};
    #
    # We always need this information
    my $slogin     = $env{'form.slogin'};
    my $sdom       = $env{'form.sdomain'};
    #
    # Get the old data
    my %old=&Apache::lonnet::get('environment',
                                 ['firstname','middlename',
                                  'lastname','generation','id'],
                                 $sdom, $slogin);
    $old{'section'} = &Apache::lonnet::getsection($sdom,$slogin,
                                                  $env{'request.course.id'});
    my ($tmp) = keys(%old);
    if ($tmp =~ /^(con_lost|error|no_such_host)/i) {
        $r->print(&mt('There was an error determining the environment values for')." $slogin \@ $sdom.");
        return;
    }
    undef $tmp;
    #
    # Get the new data
    my $firstname  = $env{'form.firstname'};
    my $middlename = $env{'form.middlename'};
    my $lastname   = $env{'form.lastname'};
    my $generation = $env{'form.generation'};
    my $section    = $env{'form.section'};
    my $courseid   = $env{'request.course.id'};
    my $sid        = $env{'form.id'};
    my $displayable_starttime = localtime($starttime);
    my $displayable_endtime   = localtime($endtime);
    # 
    # check for forceid override
    if ((defined($old{'id'})) && ($old{'id'} ne '') && 
        ($sid ne $old{'id'}) && (! exists($env{'form.forceid'}))) {
        $r->print("<font color=\"ff0000\">".&mt('You changed the students id but did not disable the ID change safeguard. The students id will not be changed.')."</font>");
        $sid = $old{'id'};
    }
    #
    # talk to the user about what we are going to do
    my %lt=&Apache::lonlocal::texthash(
	           'mdu'   => "Modifying data for user",
                   'si'    => "Student Information",
                   'fd'    => "Field",
                   'ov'    => "Old Value",
                   'nv'    => "New Value",
                   'fn'    => "First name",
                   'mn'    => "Middle name",
                   'ln'    => "Last name",
                   'gen'   => "Generation",
                   'sec'   => "Section",
                   'ri'    => "Role Information",
                   'st'    => "Start Time",
                   'et'    => "End Time",
				       );
    $r->print(<<END);
    <h2>$lt{'mdu'} $slogin \@ $sdom </h2>
<h3>$lt{'si'}</h3>
<table rules="rows" border="1" cellpadding="3" >
<tr>
    <th> $lt{'fd'} </th>
    <th> $lt{'ov'} </th>
    <th> $lt{'nv'} </th>
</tr>
<tr>
    <td> <b>$lt{'fn'}</b> </td>
    <td> $old{'firstname'} </td>
    <td> $firstname </td>
</tr><tr>
    <td> <b>$lt{'mn'}</b> </td>
    <td> $old{'middlename'} </td>
    <td> $middlename </td>
</tr><tr>
    <td> <b>$lt{'ln'}</b> </td>
    <td> $old{'lastname'} </td>
    <td> $lastname </td>
</tr><tr>
    <td> <b>$lt{'gen'}</b> </td>
    <td> $old{'generation'} </td>
    <td> $generation </td>
</tr><tr>
    <td> <b>ID</b> </td>
    <td> $old{'id'} </td>
    <td> $sid </td>
</tr><tr>
    <td> <b>$lt{'sec'}</b> </td>
    <td> $old{'section'} </td>
    <td> $section</td>
</tr>
</table>
<h3>$lt{'ri'}</h3>
<table>
<tr><td align="right"><b>$lt{'st'}:</b></td><td> $displayable_starttime </td></tr>
<tr><td align="right"><b>$lt{'et'}:</b></td><td> $displayable_endtime   </td></tr>
</table>
<p>
END
    #
    # Send request(s) to modify data (final undef is for 'desiredhost',
    # which is a moot point because the student already has an account.
    my $modify_section_results = &modifystudent($sdom,$slogin,
                                                $env{'request.course.id'},
                                                $section,undef);
    if ($modify_section_results !~ /^ok/) {
        $r->print(&mt('An error occured during the attempt to change the section for this student.')."<br />");
    }
    my $roleresults = &Apache::lonnet::modifystudent
        ($sdom,$slogin,$sid,undef,undef,$firstname,$middlename,$lastname,
         $generation,$section,$endtime,$starttime,$env{'form.forceid'});
    if ($roleresults eq 'refused' ) {
        $r->print(&mt('Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'));
    } elsif ($roleresults !~ /ok/) {
        $r->print(&mt('An error occurred during the attempt to change the role information for this student.')."  <br />".
                  &mt('The error reported was')." ".
                  $roleresults);
        &Apache::lonnet::logthis("londropadd:failed attempt to modify student".
                                 " data for ".$slogin." \@ ".$sdom." by ".
                                 $env{'user.name'}." \@ ".$env{'user.domain'}.
                                 ":".$roleresults);
    } else { # everything is okay!
        $r->print(&mt('Student information updated successfully.')." <br />".
                  &mt('The student must log out and log in again to see these changes.'));
    }
    my $Masd=&mt('Modify another students data');
    $r->print(<<END);
</p><p>
<input type="hidden" name="action" value="modifystudent" />
<input type="hidden" name="sortby" value="$sortby" />
<input type="hidden" name="Status" value="$status" />
<a href="javascript:document.studentform.submit();">$Masd</a>
END
    $r->print(&Apache::loncommon::end_page());
    return;
}

sub get_enrollment_data {
    my ($sname,$sdomain) = @_;
    my $courseid = $env{'request.course.id'};
    my $cdom = $env{'course.'.$courseid.'.domain'};
    my $cnum = $env{'course.'.$courseid.'.num'};
    my %roles = &Apache::lonnet::dump('roles',$sdomain,$sname);
    my ($tmp) = keys(%roles);
    # Bail out if we were unable to get the students roles
    return ('error'.$tmp) if ($tmp =~ /^(con_lost|error|no_such_host)/i);
    # Go through the roles looking for enrollment in this course
    my ($end,$start) = (undef,undef);
    my $section = '';
    my $count = scalar(keys(%roles));
    while (my ($course,$role) = each(%roles)) {
        if ($course=~m{^/\Q$cdom\E/\Q$cnum\E/*\s*(\w+)*_st$} ) {
            #
            # Get active role
            $section=$1;
            (undef,$end,$start)=split(/\_/,$role);
            my $now=time;
            my $notactive=0;
            if ($start) {
                if ($now<$start) { $notactive=1; }
            }
            if ($end) {
                if ($now>$end) { $notactive=1; }
            } 
            unless ($notactive) { return ($start,$end,$section); }
        }
    }
    return ($start,$end,$section);
}

#################################################
#################################################

=pod

=item show_drop_list

Display a list of students to drop
Inputs: 

=over 4

=item $r, Apache request

=item $classlist, hash pointer returned from loncoursedata::get_classlist();

=item $keylist, array pointer returned from loncoursedata::get_classlist() 
which describes the order elements are stored in the %$classlist values.

=item $nosort, if true, sorting links are omitted.

=back

=cut

#################################################
#################################################
sub show_drop_list {
    my ($r,$classlist,$keylist,$nosort)=@_;
    my $cid=$env{'request.course.id'};
    if (! exists($env{'form.sortby'})) {
        &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                                ['sortby']);
    }
    my $sortby = $env{'form.sortby'};
    if ($sortby !~ /^(username|domain|section|groups|fullname|id|start|end)$/) {
        $sortby = 'username';
    }
    my $cdom = $env{'course.'.$cid.'.domain'};
    my $cnum = $env{'course.'.$cid,'.num'};
    my ($classgroups) = &Apache::loncoursedata::get_group_memberships(
                                              $classlist,$keylist,$cdom,$cnum);
    #
    my $action = "drop";
    $r->print(<<END);
<input type="hidden" name="sortby" value="$sortby" />
<input type="hidden" name="action" value="$action" />
<input type="hidden" name="state"  value="done" />
<script>
function checkAll(field) {
    for (i = 0; i < field.length; i++)
        field[i].checked = true ;
}

function uncheckAll(field) {
    for (i = 0; i < field.length; i++)
        field[i].checked = false ;
}
</script>
<p>
<input type="hidden" name="phase" value="four">
END

my %lt=&Apache::lonlocal::texthash('usrn'   => "username",
                                   'dom'    => "domain",
                                   'sn'     => "student name",
                                   'sec'    => "section",
                                   'start'  => "start date",
                                   'end'    => "end date",
                                   'groups' => "active groups",
                                   );
    if ($nosort) {
	$r->print(&Apache::loncommon::start_data_table());
        $r->print(<<END);
<tr>
    <th>&nbsp;</th>
    <th>$lt{'usrn'}</th>
    <th>$lt{'dom'}</th>
    <th>ID</th>
    <th>$lt{'sn'}</th>
    <th>$lt{'sec'}</th>
    <th>$lt{'start'}</th>
    <th>$lt{'end'}</th>
    <th>$lt{'groups'}</th>
</tr>
END

    } else  {
	$r->print(&Apache::loncommon::start_data_table());
        $r->print(<<END);
<tr><th>&nbsp;</th>
    <th>
       <a href="/adm/dropadd?action=$action&sortby=username">$lt{'usrn'}</a>
    </th><th>
       <a href="/adm/dropadd?action=$action&sortby=domain">$lt{'dom'}</a>
    </th><th>
       <a href="/adm/dropadd?action=$action&sortby=id">ID</a>
    </th><th>
       <a href="/adm/dropadd?action=$action&sortby=fullname">$lt{'sn'}</a>
    </th><th>
       <a href="/adm/dropadd?action=$action&sortby=section">$lt{'sec'}</a>
    </th><th>
       <a href="/adm/dropadd?action=$action&sortby=start">$lt{'start'}</a>
    </th><th>
       <a href="/adm/dropadd?action=$action&sortby=end">$lt{'end'}</a>
    </th><th>
       <a href="/adm/dropadd?action=$action&sortby=groups">$lt{'groups'}</a>
    </th>
</tr>
END
    }
    #
    # Sort the students
    my %index;
    my $i;
    foreach (@$keylist) {
        $index{$_} = $i++;
    }
    $index{'groups'} = scalar(@$keylist);
    my $index  = $index{$sortby};
    my $second = $index{'username'};
    my $third  = $index{'domain'};
    my @Sorted_Students = sort {
        lc($classlist->{$a}->[$index])  cmp lc($classlist->{$b}->[$index])
            ||
        lc($classlist->{$a}->[$second]) cmp lc($classlist->{$b}->[$second])
            ||
        lc($classlist->{$a}->[$third]) cmp lc($classlist->{$b}->[$third])
        } (keys(%$classlist));
    foreach my $student (@Sorted_Students) {
        my $error;
        my $sdata = $classlist->{$student};
        my $username = $sdata->[$index{'username'}];
        my $domain   = $sdata->[$index{'domain'}];
        my $section  = $sdata->[$index{'section'}];
        my $name     = $sdata->[$index{'fullname'}];
        my $id       = $sdata->[$index{'id'}];
        my $start    = $sdata->[$index{'start'}];
        my $end      = $sdata->[$index{'end'}];
        my $groups = $classgroups->{$student};
        my $active_groups;
        if (ref($groups->{active}) eq 'HASH') {
            $active_groups = join(', ',keys(%{$groups->{'active'}}));
        }
        if (! defined($start) || $start == 0) {
            $start = &mt('none');
        } else {
            $start = &Apache::lonlocal::locallocaltime($start);
        }
        if (! defined($end) || $end == 0) {
            $end = &mt('none');
        } else {
            $end = &Apache::lonlocal::locallocaltime($end);
        }
        my $status   = $sdata->[$index{'status'}];
        next if ($status ne 'Active');
        #
        $r->print(&Apache::loncommon::start_data_table_row());
        $r->print(<<"END");
    <td><input type="checkbox" name="droplist" value="$student"></td>
    <td>$username</td>
    <td>$domain</td>
    <td>$id</td>
    <td>$name</td>
    <td>$section</td>
    <td>$start</td>
    <td>$end</td>
    <td>$active_groups</td>
END
        $r->print(&Apache::loncommon::end_data_table_row());
    }
    $r->print(&Apache::loncommon::end_data_table().'<br />');
    %lt=&Apache::lonlocal::texthash(
	               'dp'   => "Drop Students",
                       'ca'   => "check all",
                       'ua'   => "uncheck all",
				       );
    $r->print(<<"END");
</p><p>
<input type="button" value="$lt{'ca'}" onclick="javascript:checkAll(document.studentform.droplist)"> &nbsp;
<input type="button" value="$lt{'ua'}" onclick="javascript:uncheckAll(document.studentform.droplist)"> 
<p><input type=submit value="$lt{'dp'}"></p>
END
    return;
}

#
# Print out the initial form to get the courselist file
#
sub print_first_courselist_upload_form {
    my $r=shift;
    my $str;
    $str  = '<input type="hidden" name="phase" value="two">';
    $str .= '<input type="hidden" name="action" value="upload" />';
    $str .= '<input type="hidden"   name="state"  value="got_file" />';
    $str .= "<h3>".&mt('Upload a class list')."</h3>\n";
    $str .= &Apache::loncommon::upfile_select_html();
    $str .= "<p>\n";
    $str .= '<input type="submit" name="fileupload" value="'.
        &mt('Upload class list').'">'."\n";
    $str .= '<label><input type="checkbox" name="noFirstLine" /> '.
        &mt('Ignore First Line')."</label></p>\n";
    $str .= &Apache::loncommon::help_open_topic("Course_Create_Class_List",
                         &mt("How do I create a class list from a spreadsheet")).
                             "<br />\n";
    $str .= &Apache::loncommon::help_open_topic("Course_Convert_To_CSV",
                           &mt("How do I create a CSV file from a spreadsheet")).
                               "<br />\n";
    $str .= &Apache::loncommon::end_page();
    $r->print($str);
    return;
}

# ================================================= Drop/Add from uploaded file
sub upfile_drop_add {
    my $r=shift;
    &Apache::loncommon::load_tmp_file($r);
    my @studentdata=&Apache::loncommon::upfile_record_sep();
    if($env{'form.noFirstLine'}){shift(@studentdata);}
    my @keyfields = split(/\,/,$env{'form.keyfields'});
    my $cid = $env{'request.course.id'};
    my %fields=();
    for (my $i=0; $i<=$env{'form.nfields'}; $i++) {
        if ($env{'form.upfile_associate'} eq 'reverse') {
            if ($env{'form.f'.$i} ne 'none') {
                $fields{$keyfields[$i]}=$env{'form.f'.$i};
            }
        } else {
            $fields{$env{'form.f'.$i}}=$keyfields[$i];
        }
    }
    #
    # Store the field choices away
    foreach my $field (qw/username names 
                       fname mname lname gen id sec ipwd email/) {
        $env{'form.'.$field.'_choice'}=$fields{$field};
    }
    &Apache::loncommon::store_course_settings('enrollment_upload',
                                              { 'username_choice' => 'scalar',
                                                'names_choice' => 'scalar',
                                                'fname_choice' => 'scalar',
                                                'mname_choice' => 'scalar',
                                                'lname_choice' => 'scalar',
                                                'gen_choice' => 'scalar',
                                                'id_choice' => 'scalar',
                                                'sec_choice' => 'scalar',
                                                'ipwd_choice' => 'scalar',
                                                'email_choice' => 'scalar' });

    #
    my ($startdate,$enddate) = &get_dates_from_form();
    if ($env{'form.makedatesdefault'}) {
        $r->print(&make_dates_default($startdate,$enddate));
    }
    # Determine domain and desired host (home server)
    my $domain=$env{'form.lcdomain'};
    my $desiredhost = $env{'form.lcserver'};
    if (lc($desiredhost) eq 'default') {
        $desiredhost = undef;
    } else {
        my %home_servers = &Apache::loncommon::get_library_servers($domain);
        if (! exists($home_servers{$desiredhost})) {
            $r->print('<font color="#ff0000">'.&mt('Error').'</font>'.
                      &mt('Invalid home server specified'));
            $r->print(&Apache::loncommon::end_page());
            return;
        }
    }
    # Determine authentication mechanism
    my $amode  = '';
    my $genpwd = '';
    if ($env{'form.login'} eq 'krb') {
        $amode='krb';
	$amode.=$env{'form.krbver'};
        $genpwd=$env{'form.krbarg'};
    } elsif ($env{'form.login'} eq 'int') {
        $amode='internal';
        if ((defined($env{'form.intarg'})) && ($env{'form.intarg'})) {
            $genpwd=$env{'form.intarg'};
        }
    } elsif ($env{'form.login'} eq 'loc') {
        $amode='localauth';
        if ((defined($env{'form.locarg'})) && ($env{'form.locarg'})) {
            $genpwd=$env{'form.locarg'};
        }
    }
    if ($amode =~ /^krb/) {
        if (! defined($genpwd) || $genpwd eq '') {
            $r->print('<font color="red" size="+1">'.
                      &mt('Unable to enroll students').'</font>  '.
                      &mt('No Kerberos domain was specified.').'</p>');
            $amode = ''; # This causes the loop below to be skipped
        }
    }
    if ( $domain eq &clean_domain($domain)
	&& ($amode ne '')) {
        #######################################
        ##         Enroll Students           ##
        #######################################
        $r->print('<h3>'.&mt('Enrolling Students')."</h3>\n<p>\n");
        my $count=0;
        my $flushc=0;
        my %student=();
        # Get information about course groups
        my %curr_groups = &Apache::longroup::coursegroups();
        # Get new classlist
        foreach (@studentdata) {
            my %entries=&Apache::loncommon::record_sep($_);
            # Determine student name
            unless (($entries{$fields{'username'}} eq '') ||
                    (!defined($entries{$fields{'username'}}))) {
                my ($fname, $mname, $lname,$gen) = ('','','','');
                if (defined($fields{'names'})) {
                    ($lname,$fname,$mname)=($entries{$fields{'names'}}=~
                                            /([^\,]+)\,\s*(\w+)\s*(.*)$/);
                } else {
                    if (defined($fields{'fname'})) {
                        $fname=$entries{$fields{'fname'}};
                    }
                    if (defined($fields{'mname'})) {
                        $mname=$entries{$fields{'mname'}};
                    }
                    if (defined($fields{'lname'})) {
                        $lname=$entries{$fields{'lname'}};
                    }
                    if (defined($fields{'gen'})) {
                        $gen=$entries{$fields{'gen'}};
                    }
                }
                if ($entries{$fields{'username'}}
		    ne &LONCAPA::clean_username($entries{$fields{'username'}})) {
                    $r->print('<br />'.
      &mt('<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]',
          $entries{$fields{'username'}},$fname,$mname,$lname,$gen).
                              '</b>');
                } else {
                    # determine section number
                    my $sec='';
                    my $username=$entries{$fields{'username'}};
                    if (defined($fields{'sec'})) {
                        if (defined($entries{$fields{'sec'}})) {
                            $sec=$entries{$fields{'sec'}};
                        }
                    }
                    # remove non alphanumeric values from section
                    $sec =~ s/\W//g;
                    if ($sec eq "none" || $sec eq 'all') {
                        $r->print('<br />'.
      &mt('<b>[_1]</b>: Unable to enroll: section name "[_2]" for user [_3] [_4] [_5] [_6] is a reserved word.',
                        $username,$sec,$fname,$mname,$lname,$gen));
                        next;
                    } elsif (($sec ne '') && (exists($curr_groups{$sec}))) {
                        $r->print('<br />'.
      &mt('<b>[_1]</b>: Unable to enroll: section name "[_2]" for user [_3] [_4] [_5] [_6] is a course group. Section names and group names must be distinct.',
                        $username,$sec,$fname,$mname,$lname,$gen));
                        next;
                    }
                    # determine student id number
                    my $id='';
                    if (defined($fields{'id'})) {
                        if (defined($entries{$fields{'id'}})) {
                            $id=$entries{$fields{'id'}};
                        }
                        $id=~tr/A-Z/a-z/;
                    }
                    # determine email address
                    my $email='';
                    if (defined($fields{'email'})) {
                        if (defined($entries{$fields{'email'}})) {
                            $email=$entries{$fields{'email'}};
                            unless ($email=~/^[^\@]+\@[^\@]+$/) { $email=''; }
                        }
                    }
                    # determine student password
                    my $password='';
                    if ($genpwd) { 
                        $password=$genpwd; 
                    } else {
                        if (defined($fields{'ipwd'})) {
                            if ($entries{$fields{'ipwd'}}) {
                                $password=$entries{$fields{'ipwd'}};
                            }
                        }
                    }
                    # Clean up whitespace
                    foreach (\$domain,\$username,\$id,\$fname,\$mname,
                             \$lname,\$gen,\$sec) {
                        $$_ =~ s/(\s+$|^\s+)//g;
                    }
                    if ($password || $env{'form.login'} eq 'loc') {
                        &modifystudent($domain,$username,$cid,$sec,
                                       $desiredhost);
                        my $reply=&Apache::lonnet::modifystudent
                            ($domain,$username,$id,$amode,$password,
                             $fname,$mname,$lname,$gen,$sec,$enddate,
                             $startdate,$env{'form.forceid'},$desiredhost,
                             $email);
                        if ($reply ne 'ok') {
                            $reply =~ s/^error://;
                            $r->print('<br />'.
                &mt('<b>[_1]</b>:  Unable to enroll: [_2]',$username,$reply));
         		} else {
                            $count++; $flushc++;
                            $student{$username}=1;
                            $r->print('. ');
                            if ($flushc>15) {
				$r->rflush;
                                $flushc=0;
                            }
                        }
                    } else {
                        $r->print('<br />'.
      &mt('<b>[_1]</b>: Unable to enroll.  No password specified.',$username)
                                  );
                    }
                }
            }
        } # end of foreach (@studentdata)
        $r->print("</p>\n<p>\n".&mt('Processed [_1] student(s).',$count).
                  "</p>\n");
        $r->print("<p>\n".
                  &mt('If active, the new role will be available when the '.
                  'students next log in to LON-CAPA.')."</p>\n");
        #####################################
        #           Drop students           #
        #####################################
        if ($env{'form.fullup'} eq 'yes') {
            $r->print('<h3>'.&mt('Dropping Students')."</h3>\n");
            #  Get current classlist
            my ($classlist,$keylist)=&Apache::loncoursedata::get_classlist();
            if (! defined($classlist)) {
                $r->print(&mt('There are no students currently enrolled.').
                          "\n");
            } else {
                # Remove the students we just added from the list of students.
                foreach (@studentdata) {
                    my %entries=&Apache::loncommon::record_sep($_);
                    unless (($entries{$fields{'username'}} eq '') ||
                            (!defined($entries{$fields{'username'}}))) {
                        delete($classlist->{$entries{$fields{'username'}}.
                                                ':'.$domain});
                    }
                }
                # Print out list of dropped students.
                &show_drop_list($r,$classlist,$keylist,'nosort');
            }
        }
    } # end of unless
}

# ================================================================== Phase four
sub drop_student_list {
    my $r=shift;
    my $count=0;
    my @droplist = &Apache::loncommon::get_env_multiple('form.droplist');
    foreach (@droplist) {
        my ($uname,$udom)=split(/\:/,$_);
        # drop student
        my $result = &modifystudent($udom,$uname,$env{'request.course.id'});
        if ($result eq 'ok' || $result eq 'ok:') {
            $r->print(&mt('Dropped [_1]',$uname.'@'.$udom).'<br>');
            $count++;
        } else {
            $r->print(
          &mt('Error dropping [_1]:[_2]',$uname.'@'.$udom,$result).
                      '<br />');
        }
    }
    $r->print('<p><b>'.&mt('Dropped [_1] student(s).',$count).'</b></p>');
    $r->print('<p>'.&mt('Re-enrollment will re-activate data.')) if ($count);
}

sub section_check_js {
    my $groupslist;
    my %curr_groups = &Apache::longroup::coursegroups();
    if (%curr_groups) {
        $groupslist = join('","',sort(keys(%curr_groups)));
    }
    return <<"END";
function validate(caller) {
    var groups = new Array("$groupslist");
    var secname = caller.value;
    if ((secname == 'all') || (secname == 'none')) {
        alert("'"+secname+"' may not be used as the name for a section, as it is a reserved word.\\nPlease choose a different section name.");
        return 'error';
    }
    if (secname != '') {
        for (var k=0; k<groups.length; k++) {
            if (secname == groups[k]) {
                alert("'"+secname+"' may not be used as the name for a section, as it is the name of a course group.\\nSection names and group names must be distinct. Please choose a different section name.");
                return 'error';
            }
        }
    }
    return 'ok';
}
END
}

###################################################################
###################################################################

=pod

=item &handler

The typical handler you see in all these modules.  Takes $r, the
http request, as an argument.  

The response to the request is governed by two form variables

 form.action      form.state     response
 ---------------------------------------------------
 undefined        undefined      print main menu
 upload           undefined      print courselist upload menu
 upload           got_file       deal with uploaded file,
                                 print the upload managing menu
 upload           enrolling      enroll students based on upload
 drop             undefined      print the classlist ready to drop
 drop             done           drop the selected students
 enrollstudent    undefined      print student username domain form
 enrollstudent    gotusername    print single student enroll menu
 enrollstudent    enrolling      enroll student
 classlist        undefined      print html classlist
 classlist        csv            print csv classlist
 modifystudent    undefined      print classlist to select student to modify
 modifystudent    selected       print modify student menu
 modifystudent    done           make modifications to student record

=cut

###################################################################
###################################################################
sub handler {
    my $r=shift;
    if ($r->header_only) {
        &Apache::loncommon::content_type($r,'text/html');
        $r->send_http_header;
        return OK;
    }
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['action','state']);

    &Apache::lonhtmlcommon::clear_breadcrumbs();
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"/adm/dropadd",
          text=>"Enrollment Manager",
          faq=>9,bug=>'Instructor Interface',});
    #  Needs to be in a course
    if (! ($env{'request.course.fn'})) {
        # Not in a course
        $env{'user.error.msg'}=
            "/adm/dropadd:cst:0:0:Cannot manage or view course groups, ".
                                  "or drop or add students";
        return HTTP_NOT_ACCEPTABLE; 
    }
    #
    my $view_permission = 
        &Apache::lonnet::allowed('vcl',$env{'request.course.id'});
    my $enrl_permission = 
        &Apache::lonnet::allowed('cst',$env{'request.course.id'});

    my $grp_view_permission =
        &Apache::lonnet::allowed('vcg',$env{'request.course.id'});
    my $grp_manage_permission =
        &Apache::lonnet::allowed('mdg',$env{'request.course.id'});


    if (! $grp_view_permission && ! $grp_manage_permission && 
                                  ! $view_permission && ! $enrl_permission) {
        $env{'user.error.msg'}=
     "/adm/coursegroups:cst:0:0:Cannot manage or view course groups, ".
                                 "or drop or add students";
        return HTTP_NOT_ACCEPTABLE;
    }

    #
    # Only output the header information if they did not request csv format
    #
    # Start page
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    $r->print(&header());
    #
    # Main switch on form.action and form.state, as appropriate
    if (! exists($env{'form.action'})) {
        $r->print(&Apache::lonhtmlcommon::breadcrumbs('Enrollment Manager'));
        &print_main_menu($r,$enrl_permission,$view_permission,$grp_manage_permission,
                         $grp_view_permission);
    } elsif ($env{'form.action'} eq 'upload' && $enrl_permission) {
        &Apache::lonhtmlcommon::add_breadcrumb
            ({href=>'/adm/dropadd?action=upload&state=',
              text=>"Upload Classlist"});
        $r->print(&Apache::lonhtmlcommon::breadcrumbs('Upload Classlist',
						      'Course_Create_Class_List'));
        if (! exists($env{'form.state'})) {
            &print_first_courselist_upload_form($r);            
        } elsif ($env{'form.state'} eq 'got_file') {
            &print_upload_manager_form($r);
        } elsif ($env{'form.state'} eq 'enrolling') {
            if ($env{'form.datatoken'}) {
                &upfile_drop_add($r);
            } else {
                # Hmmm, this is an error
            }
        } else {
            &print_first_courselist_upload_form($r);            
        }
    } elsif ($env{'form.action'} eq 'drop' && $enrl_permission) {
        &Apache::lonhtmlcommon::add_breadcrumb
            ({href=>'/adm/dropadd?action=drop',
              text=>"Drop Students"});
        $r->print(&Apache::lonhtmlcommon::breadcrumbs('Drop Students',
						      'Course_Drop_Student'));
        if (! exists($env{'form.state'})) {
            &print_drop_menu($r);
        } elsif ($env{'form.state'} eq 'done') {
            &drop_student_list($r);
        } else {
            &print_drop_menu($r);
        }
    } elsif ($env{'form.action'} eq 'enrollstudent' && $enrl_permission) {
        &Apache::lonhtmlcommon::add_breadcrumb
            ({href=>'/adm/dropadd?action=enrollstudent',
              text=>"Enroll Student"});
        $r->print(&Apache::lonhtmlcommon::breadcrumbs('Enroll Student',
						      'Course_Add_Student'));
        if (! exists($env{'form.state'})) {
            &get_student_username_domain_form($r);
        } elsif ($env{'form.state'} eq 'gotusername') {
            &print_enroll_single_student_form($r);
        } elsif ($env{'form.state'} eq 'enrolling') {
            &enroll_single_student($r);
        } else {
            &get_student_username_domain_form($r);
        }
    } elsif ($env{'form.action'} eq 'classlist' && $view_permission) {
        &Apache::lonhtmlcommon::add_breadcrumb
            ({href=>'/adm/dropadd?action=classlist',
              text=>"View Classlist"});
        $r->print(&Apache::lonhtmlcommon::breadcrumbs('View Classlist',
						      'Course_View_Class_List'));
        if (! exists($env{'form.state'})) {
            &print_html_classlist($r,undef);
        } elsif ($env{'form.state'} eq 'csv') {
            &print_html_classlist($r,'csv');
        } elsif ($env{'form.state'} eq 'excel') {
            &print_html_classlist($r,'excel');
        } else {
            &print_html_classlist($r,undef);
        }
    } elsif ($env{'form.action'} eq 'modifystudent' && $enrl_permission) {
        &Apache::lonhtmlcommon::add_breadcrumb
            ({href=>'/adm/dropadd?action=modifystudent',
              text=>"Modify Student Data"});
        $r->print(&Apache::lonhtmlcommon::breadcrumbs('Modify Student Data',
						      'Course_Modify_Student_Data'));
        if (! exists($env{'form.state'})) {
            &print_html_classlist($r);
        } elsif ($env{'form.state'} eq 'selected') {
            &print_modify_student_form($r);
        } elsif ($env{'form.state'} eq 'done') {
            &modify_single_student($r);
        } else {
            &print_html_classlist($r);
        }        
    } else {
        # We should not end up here, but I guess it is possible
        &Apache::lonnet::logthis("Undetermined state in londropadd.pm.  ".
                                 "form.action = ".$env{'form.action'}.
                                 "Someone should fix this.");
        $r->print(&Apache::lonhtmlcommon::breadcrumbs('Enrollment Manager'));
        &print_main_menu($r,$enrl_permission,$view_permission);
    }
    #
    # Finish up
    $r->print('</form>'.&Apache::loncommon::end_page());
    return OK;
}

###################################################################
###################################################################

1;
__END__


