#!/usr/bin/perl
# CGI-script to run LaTeX, dvips, ps2ps, ps2pdf etc.
#
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use lib '/home/httpd/lib/perl';
use LONCAPA::loncgi;
use File::Path;
use File::Basename;
use File::Copy;
use IO::File;
use Image::Magick;
use Apache::lonhtmlcommon();
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonlocal;
use Apache::lonmsg();
use LONCAPA::Enrollment;

use strict;


#   Determine if a user is operating as a student for this course/domain.
#Parameters:
#    none
#Implicit:
#    $env{request.role} contains the role under which this user operated this
#                       this request.
sub is_student {
    return ($env{'request.role'}=~/^st\./);
}

#
#   Debugging:  Dump the environment for debugging.
#
sub dumpenv  {
    print "<br />-------------------<br />";
    foreach my $key (sort (keys %env)) {
	print "<br />$key -> $env{$key}";
    }
    print "<br />-------------------<br />";
}

#
#   This sub sends a message to the appropriate person if there was an error
#   rendering the latex  At present, there's only one case to consider:
#   a student printing inside a course results in messages to the course coordinator.
#Parmaeters:
#    identifier -  The unique identifier of this cgi request.
#    badresource-  Filepath to most likely failing 
#    logfile    -  The contents of the log file (included in the message).
#    texfile    -  reference to an array containing the LaTeX input file
#                  (included in the message).
#Implicit inputs:
#   From the environment:
#       cgi.$identifier.user     - User doing the printing.
#       cgi.$identifier.domain   - Domain the user is logged in on with printing.
#       cgi.$identifier.courseid - Id of the course (if this is a course).
#       cgi.$identifier.coursedom- Domain in which course was constituted.
#       cgi.$identifier.resources - List of resource URL's for which the print
#                                  was attempted.
# 
sub send_error_mail {
    my ($identifier, $badresource, $logfile, $texfile) = @_;
    my $user     = $env{"cgi.$identifier.user"};
    my $domain   = $env{"cgi.$identifier.domain"};
    my $courseid = $env{"cgi.$identifier.courseid"};
    my $coursedom= $env{"cgi.$identifier.coursedom"};
    my $resources= $env{"cgi.$identifier.resources"};

    #  resource file->URL
    #
    my $badurl = &Apache::lonnet::declutter($badresource);

    # &dumpenv();



    #  Only continue if there is a user, domain, courseid, course domain
    #  and resources:

    if(defined($user)       && defined($domain) && defined($courseid) &&
       defined($coursedom)  && defined($resources) ){
	   
	#  Only mail if the conditions are ripe for it:
	#  The user is a student in the course:
	#
	
	if (&is_student()) {
	    # build the subject and message body:
	    # print "sending message to course coordinators.<br />";

	    # Todo: Convert badurl into a url from file path:

	    my $subject  = "Error [$badurl] Print failed for $user".'@'.$domain;
	    my $message .= "Print failed to render LaTeX for $user".'@'."$domain\n";
	    $message    .= "  User was attempting to print: \n";
	    foreach my $resource (split(/:/,$resources)) {
		$message    .= "       $resource\n";
	    }
	    $message    .= "--------------------LaTeX logfile:------------ \n";
	    $message    .= $logfile;
	    $message    .= "-----------------LaTeX source file: ------------\n";
	    
	    foreach my $line (@$texfile) {
		$message .= "$line\n";
	    }
	    my (undef, %receivers) = &Apache::lonfeedback::decide_receiver(undef, 0,
									  1,1,1);
	    # print "<br /> sending...section:  $env{'request.course.sec'}";
	    foreach my $dest (keys %receivers) {
		# print "<br /> dest is $dest";
		my @destinfo = split(/:/,$dest);
		my $user = $destinfo[0];
		my $dom  = $destinfo[1];

		&Apache::lonmsg::user_normal_msg($user, $dom,
						 $subject, $message);
		
		# No point in looking at the return status as there's no good
		# error action I can think of right now (log maybe?).
	    }
	}
    }
}

$|=1;
if (! &LONCAPA::loncgi::check_cookie_and_load_env()) {
    print <<END;
Content-type: text/html

<html>
<head><title>Bad Cookie</title></head>
<body>
Your cookie information is incorrect.
</body>
</html>
END
    return;
}
 &Apache::lonlocal::get_language_handle();
 &Apache::loncommon::content_type(undef,'text/html');

  print(&Apache::loncommon::start_page('Creating PDF'));

  my $identifier = $ENV{'QUERY_STRING'};
  my $texfile = $env{'cgi.'.$identifier.'.file'};
  my $laystyle = $env{'cgi.'.$identifier.'.layout'};
  my $numberofcolumns = $env{'cgi.'.$identifier.'.numcol'};
  my $paper = $env{'cgi.'.$identifier.'.paper'};
  my $selectionmade = $env{'cgi.'.$identifier.'.selection'};
  my $tableofcontents = $env{'cgi.'.$identifier.'.tableofcontents'};
  my $tableofindex = $env{'cgi.'.$identifier.'.tableofindex'};
  my $advanced_role = $env{'cgi.'.$identifier.'.role'};
  my $number_of_files = $env{'cgi.'.$identifier.'.numberoffiles'}+1;
  my $student_names = $env{'cgi.'.$identifier.'.studentnames'};
  my $backref = &Apache::lonnet::unescape($env{'cgi.'.$identifier.'.backref'});

  
  my @names_pack=();
  if ($student_names=~/_END_/) {  
      @names_pack=split(/_ENDPERSON_/,$student_names);
  }

print "<a href=\"$backref\"><b>Return</b></a> to last resource.<br /><br />";

  my $figfile = $texfile;
  $figfile =~ s/^([^\.]+printout)[^t]+\.tex/$1\.dat/;
  my $duefile = $texfile;
  $duefile =~ s/^([^\.]+printout)[^t]+\.tex/$1\.due/;
  #do we have figures?
  # print "Figure file: $figfile\n";
  if (-e $figfile) {
      # print "$figfile exists\n";
      my %done_conversion;
      my $temporary_file=IO::File->new($figfile) || die "Couldn't open fig file $figfile for reading: $!\n";
      my @content_of_file = <$temporary_file>;
      close $temporary_file;  
      my $noteps;
      my %prog_state;
      if ($advanced_role) { %prog_state=&Apache::lonhtmlcommon::Create_PrgWin('','Coverting Images to EPS','Picture Conversion Status',$#content_of_file,'inline','80');  }
      print('<br />');
      foreach my $not_eps (@content_of_file) {
	  chomp($not_eps);
	  if ($not_eps ne '') {
	       # print "Converting $not_eps"; # Debugging.
              my $status_statement='EPS picture for '.$not_eps;
	      # print "$status_statement\n";
	      $not_eps=~s|\/\.\/|\/|g;
	      my $eps_f = $not_eps;
	      # $eps_f =~ s/\.[^.]*$/\.eps/i;
	      if ($eps_f=~/\/home\/([^\/]+)\/public_html\//) {
                  $eps_f=~s/\/home\/([^\/]+)\/public_html/$1/;
		  $eps_f = '/home/httpd/prtspool/'.$eps_f;
	      } elsif ($eps_f=~/$Apache::lonnet::perlvar{'lonDocRoot'}\/res\//) {
		  $eps_f=~m/$Apache::lonnet::perlvar{'lonDocRoot'}\/res\/(.+)/;
		  $eps_f = '/home/httpd/prtspool/'.$1;
	      } elsif ($eps_f=~/$Apache::lonnet::perlvar{'lonUsersDir'}\//) {
		  $eps_f=~/$Apache::lonnet::perlvar{'lonUsersDir'}\/([^\/]+)\/\w\/\w\/\w\/(.+)/;
		  $eps_f = '/home/httpd/prtspool/'.$1.'/'.$2;
	      }
	      $eps_f  =~ s/ /\_/g; # Spaces are problematic for system commands and LaTeX.
	      # 
	      # If the file is already an .eps or .ps file,
	      # We really just need to copy it from where it was to prtspool
	      # but with the spaces substituted to _'s.
	      #
	      my ($nsname,$path, $sext) = &fileparse($eps_f, qr/\.(ps|eps)/i);
	      if ($sext =~/ps$/i) {
		  # print "$not_eps is a postscript file. copy to $path\n";
		  &File::Path::mkpath($path,0,0777);
		  #print("Made path: $path");
		  #$not_eps =~ s/^\s+//;
		  #$not_eps =~ s/\s+$//;
		  #$not_eps =~ s/ /\__/g;
		  #print("Copying $not_eps to $eps_f\n");
		  copy("$not_eps", "$eps_f"); 
		  # print "Copy complete\n";
	      } else {
	      
		  $eps_f .= '.eps';	# Just append the eps ext.
		  my $path=$eps_f;
		  $path =~ s/\/([^\/]+)\.eps$//;
		  # print "Final file path: $path "; # Debugging
		  &File::Path::mkpath($path,0,0777);
		  $not_eps =~ s/^\s+//;
		  $not_eps =~ s/\s+$//;
		  $not_eps =~ s/ /\\ /g;
		  if ( exists($done_conversion{$not_eps})) { next; }
		  if ($advanced_role) {
		      my $prettyname=$not_eps;
		      $prettyname=~s|/home/([^/]+)/public_html|/priv/$1|;
		      $prettyname=~s|$Apache::lonnet::perlvar{'lonDocRoot'}/|/|;
		      &Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state,
							    'Converting to EPS '.$prettyname);
		  }
		  $done_conversion{$not_eps}=1;
		  # print "Converting $not_eps -> $eps_f"; # Debugging
		  system("convert $not_eps $eps_f");
		  # check is eps exist in prtspool
		  if (not -e $eps_f) {
		      # converting an animated gif creates either:
		      # anim.gif.eps.0
		      # or
		      # anim.gif-0.eps
		      for (my $i=0;$i<10000;$i++) {
			  if (-e $eps_f.'.'.$i) {
			      rename($eps_f.'.'.$i, $eps_f);
			      last;
			  }
			  my $anim_eps = $eps_f;
			  $anim_eps =~ s/(\.[^.]*)\.eps$/$1-$i\.eps/i;
			  if (-e $anim_eps) {
			      rename($anim_eps, $eps_f);
			      last;
			  }
		      }
		  }
		  
		  # imagemagick 6.2.0-6.2.7 fails to properly handle
		  # convert anim.gif anim.gif.eps
		  # it creates anim.eps instead. 
		  if (not -e $eps_f) {
		      my $eps_f2 = $eps_f;
		      $eps_f2 =~ s/\.[^.]*\.eps$/\.eps/i;
		      if(-e $eps_f2) {
			  rename($eps_f2,$eps_f);
		      }
		  }
	      }

	  }
      }
      if ($advanced_role) { 
	  &Apache::lonhtmlcommon::Close_PrgWin('',\%prog_state); 
      }
      unlink($figfile);
  }
  #print "$texfile\n"; #name of the tex file for debugging only   
  my @texfile=($texfile);
  if ($number_of_files>1) {
      @texfile=();
      for (my $i=1;$i<=$number_of_files;$i++) {
	  my $new_texfile=$texfile;
	  $new_texfile=~s/\.tex//;
	  $new_texfile = sprintf("%s_%03d.tex", $new_texfile,$i);
	  push @texfile,$new_texfile;
      } 
  }

my $ind=-1;
my %prog_state;
if ($advanced_role) { %prog_state=&Apache::lonhtmlcommon::Create_PrgWin('','Print Status','Class Print Status',$number_of_files,'inline','80'); }
print "<br />";
my $num_files = @texfile;
foreach $texfile (@texfile) {
  my $status_statement='';
  my $link_text='download PDF';
  $ind++;
  my @stud_info=split(/_END_/,$names_pack[$ind]);
  my @tempo_array=split(/:/,$stud_info[0]);
  my $name;
  my $name_range='';
  if ($tempo_array[3]) {
      $name=$tempo_array[3];
      ($name_range) = split(/,/,$name, 2);
  } else {
      $name=$tempo_array[0].'@'.$tempo_array[1];
      $name_range = $tempo_array[0];
  }
  if (($name ne "") && ($name ne '@') ) { # Could be printing codes...
      $link_text='<b>'.$name.'</b>';
      $status_statement.=$name;
  }
  if ($#stud_info>0) {
      @tempo_array=split(/:/,$stud_info[-1]);
      if ($tempo_array[3]) {
	  $name=$tempo_array[3];
	  my ($lastname) = split(/,/, $name,2);
	  $name_range .= "-".$lastname;
      } else {
	  $name=$tempo_array[0].'@'.$tempo_array[1];
	  $name_range .= '-'.$tempo_array[0];
      }
      if (($name ne "") && ($name ne '@')) {
	  $link_text.=' - <b>'.$name.'</b>';
	  $status_statement.=' -  '.$name;
  
      }
  }
  if(($num_files > 1) && ($link_text eq 'download PDF')) { # Printing codes
      $link_text = '<b>'.basename($texfile,'.tex').'.pdf</b>';
      $status_statement .= basename($texfile);
  }
  $name_range =~ s/'//g;	# O'Neil -> ONeil e.g.
  print "<br/>";
  if ($advanced_role) { &Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state,'Creating PDF for '.$status_statement); }
  #  This little piece of dirt puts username ranges into the original tex
  #  Tex filename from which they'll propagate into the other filenames as well.
  #
  if (-e $texfile) {
      if (($name_range ne '') && ($num_files > 1)) {
	  my $newtexfile = $texfile;
	  $newtexfile    =~ s/\.tex/$name_range\.tex/;
	  rename($texfile, $newtexfile);
	  $texfile       = $newtexfile;
      }
      $texfile =~ m/^(.*)\/([^\/]+)$/; 
      my $name_file = $2;
      my $path_file = $1.'/';
      chdir $path_file;
      my $dvi_file= $name_file; $dvi_file =~ s/\.tex/$name_range\.dvi/;
      &busy_wait_command("latex $name_file 1>/dev/null 2>/dev/null",
			 "for $status_statement now LaTeXing file",
			 \%prog_state,$dvi_file);
      if ($tableofcontents eq 'yes') {
      &busy_wait_command("latex $name_file 1>/dev/null 2>/dev/null",
			 "for $status_statement First LaTeX of file for table of contents",
			 \%prog_state,$dvi_file);
      &busy_wait_command("latex $name_file 1>/dev/null 2>/dev/null",
			 "for $status_statement Second LaTeX of file for table of contents",
			 \%prog_state,$dvi_file);
      } #to create table of contents
      my $idxname=$name_file;
      $idxname=~s/\.tex$/\.idx/;
      if ($tableofindex eq 'yes') {
	  &busy_wait_command("makeindex $idxname",
			     "making index file",
			     \%prog_state,$idxname);
	  &busy_wait_command("latex $name_file 1>/dev/null 2>/dev/null",
			     "for $status_statement now LaTeXing file for index section",
			     \%prog_state,$dvi_file);
      } #to create index
      #Do we have a latex error in the log file?
      my $logfilename = $texfile; $logfilename =~ s/\.tex$/\.log/;
      my $temporary_file=IO::File->new($logfilename) || die "Couldn't open log file $logfilename for reading: $!\n";
      my @content_of_file = <$temporary_file>;
      close $temporary_file; 
      my $body_log_file = join(' ',@content_of_file);
      $logfilename =~ s/\.log$/\.html/;
      $temporary_file = IO::File->new('>'.$logfilename); 
      print $temporary_file '<html><head><title>LOGFILE</title></head><body><pre>'.$body_log_file.'</pre></body></html>'."\n";
      if ($body_log_file=~m/!\s+Emergency stop/) {
	  my $whereitbegins = rindex $body_log_file,'STAMPOFPASSEDRESOURCESTART';
	  my $whereitends = rindex $body_log_file,'STAMPOFPASSEDRESOURCEEND';
	  my $badresource;
	  my $badtext;
	  if ($whereitbegins!=-1 and $whereitends!=-1) {
	      $badtext = substr($body_log_file,$whereitbegins+26, $whereitends-$whereitbegins-26);
	      $whereitbegins  = rindex $badtext,'located in';
	      if ($whereitbegins != -1) {
		  
		  $badresource = substr($badtext, $whereitbegins+27, 
					length($badtext) - $whereitbegins - 48);
		  # print "<br />failing resourcename: $badresource<br />";
	      }
	  }
	  
          if ($advanced_role) {  
	      #LaTeX failed to parse tex file 
	      print "<h2>LaTeX could not successfully parse your tex file.</h2>";
	      print "It probably has errors in it.<br />";
	      print "With very high probability this error occured in ".$badtext."<br /><br />";
	      print "Here are the error messages in the LaTeX log file<br /><pre>";

	      my $sygnal = 0;
	      for (my $i=0;$i<=$#content_of_file;$i++) {
		  if ($content_of_file[$i]=~m/^Runaway argument?/ or $content_of_file[$i]=~m/^!/) {
		      $sygnal = 1;
		  } 
		  if ($content_of_file[$i]=~m/Here is how much of/) {
		      $sygnal = 0;
		  } 
		  if ($sygnal) {
		      print "$content_of_file[$i]";
		  }  
	      }
	      print "</pre>\n";
	      # print "<br /> Advanced role <br />";
              print "<b><big>The link to ";
              $logfilename=~s/\/home\/httpd//;
	      print "<a href=\"$logfilename\">Your log file </a></big></b>";
	      print "\n";
              #link tooriginal LaTeX file (included according Michael Hamlin desire)
	      my $tex_temporary_file=IO::File->new($texfile) || die "Couldn't open tex file $texfile for reading: $!\n";
	      my @tex_content_of_file = <$tex_temporary_file>;
	      close $tex_temporary_file; 
	      my $body_tex_file = join(' ',@tex_content_of_file);
	      $texfile =~ s/\.tex$/aaaaa\.html/;
	      $tex_temporary_file = IO::File->new('>'.$texfile); 
	      print $tex_temporary_file '<html><head><title>LOGFILE</title></head><body><pre>'.$body_tex_file.'</pre></body></html>'."\n";
	      print "<br /><br />";
	      print "<b><big>The link to ";
	      $texfile=~s/\/home\/httpd//;
	      print "<a href=\"$texfile\">Your original LaTeX file </a></big></b>";
	      print "\n";
	      my $help_text = &Apache::loncommon::help_open_topic("Print_Resource", "Help on printing");
	      print ("$help_text");

	  } else {		# Student role...
	      #  at this point:
	      #    $body_log_file - contains the log file.
              #    $name_file     - is the name of the LaTeX file.
              #    $identifier    - is the unique LaTeX identifier.l

	      print "<br />There are errors in $badtext";
	      print "<br />These errors prevent this resource from printing correctly";
	      my $tex_handle = IO::File->new($name_file);
	      my @tex_contents = <$tex_handle>;
	      &send_error_mail($identifier, $badresource, $body_log_file, \@tex_contents);
	      print "<br />A message has been sent to the instructor describing this failure<br />";
	      my $help_text = &Apache::loncommon::help_open_topic("Print_Resource", "Help on printing");
	      print  ("$help_text");

	  }

      } elsif ($body_log_file=~m/<inserted text>/) {
	  my $whereitbegins = index $body_log_file,'<inserted text>';
	  print "You are running LaTeX in <b>batch mode</b>.";
	  while ($whereitbegins != -1) {
	      my $tempobegin=$whereitbegins;
	      $whereitbegins = rindex $body_log_file,'STAMPOFPASSEDRESOURCESTART',$whereitbegins;
	      my $whereitends = index $body_log_file,'STAMPOFPASSEDRESOURCEEND',$whereitbegins;
	      print "<br />It has found an error in".substr($body_log_file,$whereitbegins+26,$whereitends-$whereitbegins-26)." <br /> and corrected it.\n";
	      print "Usually this correction is valid but you probably need to check the indicated resource one more time and implement neccessary corrections by yourself.\n";
	      $whereitbegins = index $body_log_file,'<inserted text>',$tempobegin+10;
	  }
	  $name_file =~ s/\.tex/\.dvi/;
	  my $new_name_file = $name_file;
	  $new_name_file =~ s/\.dvi/\.ps/;
	  my $papera=$paper;
	  if ($papera eq 'letter') {$papera='';}
	  if ($papera ne '') {$papera='-t'.$papera;}
	  my $comma = "dvips $papera -Ppdf -G0 -o $new_name_file";
	  &busy_wait_command("$comma $name_file 1>/dev/null 2>/dev/null",
			     "for $status_statement now Converting to PS",
			     \%prog_state,$new_name_file);
	  if (-e $new_name_file) {
	      my $latex_file = $name_file;
	      $latex_file    =~ s/\.dvi/\.tex/;
	      &repaginate($new_name_file, $latex_file, $numberofcolumns);
	      #
	      #  Now have to re-latex, re dvips again to 
	      #  get the repaginated postscript.
	      #
	      &busy_wait_command("latex $latex_file 1>/dev/null 2>/dev/null",
				 "for $status_statement first latex to repaginate",
				 \%prog_state, $name_file);
	      if ($tableofcontents eq 'yes') {
		  &busy_wait_command("latex $latex_file 1>/dev/null 2>/dev/null",
				     "for $status_statement second latex to repaginate",
				     \%prog_state, $name_file);
		  &busy_wait_command("latex $latex_file 1>/dev/null 2>/dev/null",
				     "for $status_statement third latex to repaginate",
				     \%prog_state, $name_file);
	      }
	      if ($tableofindex eq 'yes') {
		  my $idxname = $latex_file;
		  $idxname =~ s/\.tex$/\.idx/;
		  &busy_wait_command("makindex $idxname",
				     "Re-creating index file",
				     \%prog_state, $idxname);
		  &busy_wait_command("latex $latex_file 1>/dev/null 2>/dev/null",
				     "for $status_statement now Recreting index (latex)",
				     \%prog_state, $dvi_file);

	      }
	      &busy_wait_command("$comma $name_file 1>dev/null 2>/dev/null",
				 "for $status_statement dvips to repaginate",
				 \%prog_state, $new_name_file);
	      #
	      #  One last little hinky kinky thing.
	      #  It's just possible that some fonts could not be maded
	      #  at the resolution of the pdf print driver.
	      #  In that case a file called missfont.log will have been
	      #  created that will contain the commands that were attempted
	      # to create the missing fonts.  If we basically
	      # take all the 8000 strings in that file, and
	      # replace them with 600 (the ljfour resolution)
	      # run the commands in that file and redvips,
	      # we'll be able to print the missing glyphs at 600dpi.
	      #
	      # Supposedly it is possible to tune TeX/Metafont to do this
	      # right but I failed to get that to work when following the
	      # docs at the tug site, hence this rather kludgey fix.
	      #
	      #  We make the (I think) reasonable assumption that
	      #  missing glyphs won't change the pagination and I think
	      #  this is true because TeX/dvips will leave a space
	      #  instead of these glyphs based on the font metrics
	      #  (fancy way to say there will be a blank the size of the missing
	      #  glyphs).
	      #
	      my $print_directory = dirname($name_file);
	      my $missfonts_file  = $print_directory."/missfont.log";
	      #print("<br /> Missing fonts file is: $missfonts_file");
	      if (-e $missfonts_file) {
		  #print("<br />Missing fonts file exists\n");
		  &create_missing_fonts($missfonts_file);
		  unlink($missfonts_file, \%prog_state);
		  &busy_wait_command("$comma $name_file 1>dev/null 2>/dev/null",
				     "for $status_statement dvips generated missing fonts",
				     \%prog_state, $new_name_file);
	      }

	      #
	      print "\n<h1>PDF output file (see link below)</h1>\n";
	      $new_name_file =~ m/^(.*)\./;
	      my $ps_file = my $tempo_file = $1.'temporar.ps';
	      my $pdf_file = $1.'.pdf';
	      if ($laystyle eq 'album' and $numberofcolumns eq '2') {
		  my $papera=$paper;
                  if ($papera eq 'letter') {$papera='';}
		  if ($papera ne '') {$papera='-p'.$papera;}
		  $comma = "psnup $papera -2 -s1.0 $new_name_file";
		  &busy_wait_command("$comma $tempo_file 1>/dev/null 2>/dev/null",
				     "for $status_statement now Modifying PS layout",
				     \%prog_state,$tempo_file); 
	      } elsif ($laystyle eq 'book' and $numberofcolumns eq '2') {
		  my $papera=$paper;
                  if ($papera eq 'letter') {$papera='';}
		  if ($papera ne '') {$papera='-p'.$papera;}
		  $comma = 'pstops '.$papera.' "2:0+1(0.48w,0)"';
		  &busy_wait_command("$comma $new_name_file $tempo_file 1>/dev/null 2>/dev/null",
				     "for $status_statement now Modifying PS layout",
				     \%prog_state,$tempo_file); 

	      } else {
		  $ps_file=$new_name_file;
	      }	    
	      &busy_wait_command("ps2pdf $ps_file $pdf_file 1>/dev/null 2>/dev/null",
				 "for $status_statement now Converting PS to PDF",
				 \%prog_state, $pdf_file);

	      my $texlog = $texfile;
	      my $texaux = $texfile;
	      my $texdvi = $texfile;
	      my $texps = $texfile;
	      $texlog =~ s/\.tex/\.log/;
	      $texaux =~ s/\.tex/\.aux/;
	      $texdvi =~ s/\.tex/\.dvi/;
	      $texps =~ s/\.tex/\.ps/;
	      my @garb = ($texaux,$texdvi,$texps);
#	  unlink @garb;
	      unlink $duefile;
	      print "<a href=\"/prtspool/$pdf_file\">Your PDF document</a>";
	  }
	  if ($advanced_role) {  
	      print "<br /><br />";
	      print "<b><big>The link to ";
	      $logfilename=~s/\/home\/httpd//;
	      print "<a href=\"$logfilename\">Your log file </a></big></b>";
	      print "\n";
	      #link tooriginal LaTeX file (included according Michael Hamlin desire)
	      my $tex_temporary_file=IO::File->new($texfile) || die "Couldn't open tex file $texfile for reading: $!\n";
	      my @tex_content_of_file = <$tex_temporary_file>;
	      close $tex_temporary_file; 
	      my $body_tex_file = join(' ',@tex_content_of_file);
	      $texfile =~ s/\.tex$/aaaaa\.html/;
	      $tex_temporary_file = IO::File->new('>'.$texfile); 
	      print $tex_temporary_file '<html><head><title>LOGFILE</title></head><body><pre>'.$body_tex_file.'</pre></body></html>'."\n";
	      print "<br /><br />";
	      print "<b><big>The link to ";
	      $texfile=~s/\/home\/httpd//;
	      print "<a href=\"$texfile\">Your original LaTeX file </a></big></b>";
	      print "\n";
	  }
      } else {
	  #LaTeX successfully parsed tex file 
	  $name_file =~ s/\.tex/\.dvi/;
	  my $new_name_file = $name_file;
	  $new_name_file =~ s/\.dvi/\.ps/;
	  my $papera=$paper;
	  if ($papera eq 'letter') {$papera='';}
	  if ($papera ne '') {$papera='-t'.$papera;}
	  my $comma = "dvips $papera -Ppdf -G0 -o $new_name_file";
	  &busy_wait_command("$comma $name_file 1>/dev/null 2>/dev/null",
			     "for $status_statement now Converting to PS",
			     \%prog_state,$new_name_file);
	  #
	  #  One last little hinky kinky thing.
	  #  It's just possible that some fonts could not be maded
	  #  at the resolution of the pdf print driver.
	  #  In that case a file called missfont.log will have been
	  #  created that will contain the commands that were attempted
	  # to create the missing fonts.  If we basically
	  # take all the 8000 strings in that file, and
	  # replace them with 600 (the ljfour resolution)
	  # run the commands in that file and redvips,
	  # we'll be able to print the missing glyphs at 600dpi.
	  #
	  # Supposedly it is possible to tune TeX/Metafont to do this
	  # right but I failed to get that to work when following the
	  # docs at the tug site, hence this rather kludgey fix.
	  #
	  #  We make the (I think) reasonable assumption that
	  #  missing glyphs won't change the pagination and I think
	  #  this is true because TeX/dvips will leave a space
	  #  instead of these glyphs based on the font metrics
	  #  (fancy way to say there will be a blank the size of the missing
	  #  glyphs).
	  #
	  my $print_directory = dirname($name_file);
	  my $missfonts_file  = $print_directory."/missfont.log";
	  #print("<br /> Missing fonts file is: $missfonts_file");
	  if (-e $missfonts_file) {
	      #print("<br />Missing fonts file exists\n");
	      &create_missing_fonts($missfonts_file);
	      unlink($missfonts_file, \%prog_state);
	      &busy_wait_command("$comma $name_file 1>dev/null 2>/dev/null",
				 "for $status_statement dvips generated missing fonts",
				 \%prog_state, $new_name_file);
	  }
	  if (-e $new_name_file) {
	      my $latex_file = $name_file;
	      $latex_file =~ s/\.dvi/\.tex/;
	      &repaginate($new_name_file, $latex_file,  $numberofcolumns);
	      &busy_wait_command("latex $latex_file 1>/dev/null 2>/dev/null",
				 "for $status_statement first latex to repaginate",
				 \%prog_state, $name_file);
	      if ($tableofcontents eq 'yes') {
		  &busy_wait_command("latex $latex_file 1>/dev/null 2>/dev/null",
				     "for $status_statement second latex to repaginate",
				     \%prog_state, $name_file);
		  &busy_wait_command("latex $latex_file 1>/dev/null 2>/dev/null",
				     "for $status_statement third latex to repaginate",
				     \%prog_state, $name_file);
	      }
	      if ($tableofindex eq 'yes') {
		  my $idxname = $latex_file;
		  $idxname    =~ s/\.tex$/\.idx/;
		  &busy_wait_command("makeindex $idxname",
				     "Re-creating index file",
				     \%prog_state, $idxname);
		  &busy_wait_command("latex $latex_file 1>/dev/null 2>/dev/null",
				     "for $status_statement now Recreting index (latex)",
				     \%prog_state, $dvi_file);
	      }
	      &busy_wait_command("$comma $name_file 1>/dev/null 2>/dev/null",
				 "for $status_statement dvips to repaginate",
				 \%prog_state, $new_name_file);

	      print "<br />";
	      $new_name_file =~ m/^(.*)\./;
	      my $ps_file = my $tempo_file = $1.'temporar.ps';
	      my $pdf_file = $1.'.pdf';
	      $papera=~s/t/p/;
	      if ($laystyle eq 'album' and $numberofcolumns eq '2') {
		  $comma = "psnup $papera -2 -s1.0 $new_name_file";
		  &busy_wait_command("$comma $tempo_file 1>/dev/null 2>/dev/null",
				     "for $status_statement now Modifying PS layout",
				     \%prog_state,$tempo_file);
	      } elsif ($laystyle eq 'book' and $numberofcolumns eq '2') {
		  $comma = 'pstops '.$papera.' "2:0+1(0.48w,0)"';
		  &busy_wait_command("$comma $new_name_file $tempo_file 1>/dev/null 2>/dev/null",
				     "for $status_statement now Modifying PS layout",
				     \%prog_state,$tempo_file); 
	      } else {
		  $ps_file=$new_name_file;
	      }
	      my $addtoPSfile={'legal'=>'<< /PageSize [612 1008] >> setpagedevice',
                               'tabloid'=>'<< /PageSize [792 1224] >> setpagedevice',
                               'executive'=>,'<< /PageSize [540 720] >> setpagedevice',
                               'a2'=>'<< /PageSize [1195.02 1690.09] >> setpagedevice',
                               'a3'=>'<< /PageSize [842 1195.02] >> setpagedevice',
                               'a4'=>'<< /PageSize [595.2 842] >> setpagedevice',
                               'a5'=>'<< /PageSize [421.1 595.2] >> setpagedevice',
                               'a6'=>'<< /PageSize [298.75 421.1] >> setpagedevice',
			   };
	      if ($paper ne 'letter') {
		  open(FFH,'<',$ps_file) || die "Couldn't open ps file $ps_file for reading: $!\n";
		  my $new_ps_file='new'.$ps_file;
		  open(FFHS,'>',$new_ps_file) || die "Couldn't open new ps file $new_ps_file for reading: $!\n";
		  print FFHS $addtoPSfile->{$paper}."\n";
		  while (<FFH>) {
		      print FFHS $_;
		  }
		  close(FFH);
		  close(FFHS);
		  $ps_file=$new_ps_file;	  
	      }
	      &busy_wait_command("ps2pdf $ps_file $pdf_file 1>/dev/null 2>/dev/null",
				 "for $status_statement now Converting PS to PDF",
				 \%prog_state,$pdf_file);
	    
	      my $texlog = $texfile;
	      my $texaux = $texfile;
	      my $texdvi = $texfile;
	      my $texps = $texfile;
	      $texlog =~ s/\.tex/\.log/;
	      $texaux =~ s/\.tex/\.aux/;
	      $texdvi =~ s/\.tex/\.dvi/;
	      $texps =~ s/\.tex/\.ps/;
	      my @garb = ($texlog,$texaux,$texdvi,$texps);
#	  unlink @garb;
	      unlink $duefile;
	      print "<a href=\"/prtspool/$pdf_file\">$link_text - click here to download pdf</a>";
	      print "\n";
	  }
      }  
  } else {
      print "LaTeX file $texfile was not created successfully";
  }
}
print "<br />";
if ($number_of_files>1) {
    my $zipfile=$texfile[0];
    $zipfile=~s/\.tex/\.zip/;
    my $statement="zip $zipfile";
    foreach my $file (@texfile) {
	$file=~s/\.tex/.\pdf/;
	$statement.=' '.$file; 
    }
    print("<pre>Zip Output:\n");
    system($statement);
    print("</pre>");
    $zipfile=~s/\/home\/httpd//;
    print "<br /> A <a href=\"$zipfile\">ZIP file</a> of all the PDFs.";
}
if ($advanced_role) { &Apache::lonhtmlcommon::Close_PrgWin('',\%prog_state); }
print(&Apache::loncommon::end_page());
my $done;

sub REAPER {
    $done=1;
}

sub busy_wait_command {
    my ($command,$message,$progress_win,$output_file)=@_;
    
    $SIG{CHLD} = \&REAPER;
    $done=0;
    my $pid=open(CMD,"$command |");
    if ($advanced_role) {
	&Apache::lonhtmlcommon::Update_PrgWin('',$progress_win,$message);
    }
    while(!$done) {
	sleep 1;
	my $extra_msg;
	if ($output_file) {
	    my $size=(stat($output_file))[7];
	    $extra_msg=", $size bytes generated";
	}
	if ($advanced_role) {
	    &Apache::lonhtmlcommon::Update_PrgWin('',$progress_win,
						  $message.$extra_msg);
	}
    }
    $SIG{CHLD}='IGNORE';
    close(CMD);
}

#  Repagninate
#  What we need to do:
#   - Count the number of pages in each student.
#   - Rewrite the latex file replacing the \specials that
#     mark the end of student with an appropriate number of newlines.
#   parameters:
#     psfile     - Postscript filename
#     latexfile  - LaTeX filename
#     columns    - number of columns.
sub repaginate {

    # We will try to do this in 2 passes through the postscript since
    # the postscript is potentially large, to do 2 passes, the first pass
    # must be able to calculate the total number of document pages so that
    # at the beginning of the second pass we already know how to replace
    #  %%Pages:

    #  Figure out
    #    1. Number of pages in the document
    #    2. Maximum number of pages in a student
    #    3. Number of pages in each student.

    my ($postscript_filename, $latex_filename, $num_columns) = @_;
    open(PSFILE, "<$postscript_filename");
    my $line;
    my $total_pages;		# Total pages in document.
    my $seen_pages        = 0;	# There are several %%Pages only the first is useful
    my @pages_in_student;	# For each student his/her initial page count.
    my $max_pages = 0;		# Pages in 'longest' student.
    my $page_number = 0;
    &Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state, 
					  &mt("Counting pages for student: [_1]",1));

    while ($line = <PSFILE>) {
	
	# Check for total pages (%%Pages:)

	if (($line =~ /^%%Pages:/) && (!$seen_pages)) {
	    my @pageinfo = split(/ /,$line);
	    $total_pages = $pageinfo[1];
	    $seen_pages  = 1;
	}
	#  Check for %%Page: n m  $page_number will be the
	#  biggest of these until we see an endofstudent.
	#  Note that minipages generate spurious %Page: 1 1's so
	#  we only are looking for the largest n (n is page number at the
	#  bottom of the page, m the page number within the document.
	#

	if ($line =~ /^%%Page:/) {
	    my @pageinfo = split(/ /, $line);
	    if ($page_number < $pageinfo[1]) {
		$page_number = $pageinfo[1];
	    } elsif ($pageinfo[2] ne 1) {
		#  current page count reset, and it's not because of a 
		#    minipage 
		# - save the page_number, reset and, if necessary
		#    update max_pages.
		push(@pages_in_student, $page_number);
		&Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state, 
						      &mt("Counting pages for student: [_1]", scalar(@pages_in_student)));
		if ($page_number > $max_pages) {
		    $max_pages = $page_number;
		}
		$page_number = $pageinfo[1];
	    }
	}

	
    }
    # file ended so one more student
    push(@pages_in_student, $page_number);
    &Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state, 
					  &mt("Counting pages for student: [_1]",scalar(@pages_in_student)));
    if ($page_number > $max_pages) {
	$max_pages = $page_number;
    }
    $page_number = 0;
    
    close(PSFILE);

    #  If 2 columns, max_pages must go to an even number of columns:

   
    if ($num_columns == 2) {
	if ($max_pages % 2) {
	    $max_pages++;
	}
    }
    
    #  Now rewrite the LaTex file, substituting our \special
    #  with an appropriate number of \newpage directives.

    my $outfilename = $latex_filename."temp";

    open(LATEXIN, "<$latex_filename");
    open(LATEXOUT, ">$outfilename");


    my $student_number    = 0;	# Index of student we're working on.
    &Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state, 
					  "Repaginating student ".$student_number+1);

    while (my $line = <LATEXIN>) {
	if ($line eq "\\special{ps:ENDOFSTUDENTSTAMP}\n") {
	    # only end of student stamp if next line is ENDOFSTUDENTSTAMP:


	    # End of student replace with 0 or more newpages.
	    
	    my $addlines = $max_pages - $pages_in_student[$student_number];
	    while($addlines)  {
		print LATEXOUT '\clearpage \strut \clearpage';

		$addlines--;
	    }
	    
	    $student_number++;
	    &Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state, 
						  "Repaginating student ".$student_number+1);
	    
	} else {
	    print LATEXOUT $line;
	}
    }

    close(LATEXIN);
    close(LATEXOUT);
    rename($outfilename, $latex_filename);

}

#
#   Create missing fonts given a latex missfonts.log file.
#   This file will have lines like:
#
#   mktexpk --mfmode ljfour --bdpi 8000 --mag 1+0/8000 --dpi 8000 tcrm0500
#
#  We want to execute those lines with the 8000's changed to 600's
#  in order to match the resolution of the ljfour printer.
#  Of course if some wiseguy has changed the default printer from ljfour
#  in the dvips's config.ps file that will break so we'll also
#  ensure that --mfmode is ljfour.
#
sub create_missing_fonts {
    my ($fontfile, $state) = @_;

    # Open and read in the font file..we'll read it into the array
    #  font_commands.
    #
    my $font_handle = IO::File->new($fontfile);
    my @font_commands = <$font_handle>;
    

    #  Now process each command replacing the appropriate 8000's with
    #  600's ensuring that font names with 8000's in them are not corrupted.
    #  and if the --mfmode is not ljfour we turn it into ljfour.
    #   Then we execute the command.
    #

    foreach my $command (@font_commands) {
	#print("<br />Raw command: $command");
	$command =~ s/ 8000/ 600/g;    # dpi directives.
	$command =~ s/\/8000/\/600/g;  # mag directives.
	#print("<br />After dpi replacements: $command");

	my @cmdarray = split(/ /,$command);
	for (my $i =0; $i < scalar(@cmdarray); $i++) {
	    if ($cmdarray[$i] eq '--mfmode') {
		$cmdarray[$i+1] = "ljfour";
	    }
	}
	#print("<br /> before reassembly : (@cmdarray)");
	$command = join(" ", (@cmdarray));

	#print("<br />Creating fonts via command: $command");
	&busy_wait_command("$command 1>dev/null 2>/dev/null",
			   "Creating missing font",
			   $state, $command);
			   
    }

}
