# The LearningOnline Network
# Unauthorized to access construction space
#
# $Id: lonunauthorized.pm,v 1.6 2006/12/06 22:22:39 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonunauthorized;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::loncacc;
use Apache::lonlocal;
use LONCAPA();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

# ------------------------------------------------------------ Print the screen
# Figure out who the user is and what they wanted to access

    my ($ownername,$ownerdomain)=
     &Apache::loncacc::constructaccess($env{'request.editurl'},$r->dir_config('lonDefDomain'));
# print header
    $r->print(&Apache::loncommon::start_page("Failed Access to Construction Space",
					     undef,
					     {'domain' => $ownerdomain,}));
# figure out what went wrong

    if ($ownerdomain) {
	$r->print('<h1>'.&mt('Choose another server').'</h1><p>'.
&mt('The constuction space for this resource is located on another server.').
'</p>');
        my $ownerhome=&Apache::lonnet::homeserver($ownername,$ownerdomain);
        unless ($ownerhome eq 'no_host') {
	    $r->print(
 "<p>".&mt('Please log into')." <tt>".$Apache::lonnet::hostname{$ownerhome}.
 "</tt> ".&mt('to edit.')."</p>");
        }
    } else {
        $r->print(
            "<h1>".
	&mt("You do not have authoring privileges for this resource")."</h1>");
        my ($realownername)=
	    ($env{'request.editurl'}=~m{/(?:~|priv/|home/)($LONCAPA::username_re)});
        my $realownerhome=
	    &Apache::lonnet::homeserver($realownername,
					$r->dir_config('lonDefDomain'));
        unless ($realownerhome eq 'no_host') {
	    $r->print("<p>".&mt('Contact')." ".
    &Apache::loncommon::aboutmewrapper(
     &Apache::loncommon::plainname($realownername,
                               $r->dir_config('lonDefDomain')).' ('.
                               $realownername.&mt(' at ').
                               $r->dir_config('lonDefDomain').')',
			       $realownername,$r->dir_config('lonDefDomain')).
           ' for access.</p>');
        }
    }
    
    $r->print(&Apache::loncommon::end_page());
    return OK;
} 

1;
__END__
