/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Circle3D;
import org.jmol.g3d.Colix;
import org.jmol.g3d.Cylinder3D;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Hermite3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Platform3D;
import org.jmol.g3d.Shade3D;
import org.jmol.g3d.Sphere3D;
import org.jmol.g3d.Text3D;
import org.jmol.g3d.Triangle3D;
import org.jmol.g3d.Xyzd;

public final class Graphics3D {
    Platform3D platform;
    Line3D line3d;
    Circle3D circle3d;
    Sphere3D sphere3d;
    Triangle3D triangle3d;
    Cylinder3D cylinder3d;
    Hermite3D hermite3d;
    boolean isFullSceneAntialiasingEnabled;
    boolean antialiasThisFrame;
    boolean tPaintingInProgress;
    int windowWidth;
    int windowHeight;
    int width;
    int height;
    int slab;
    int depth;
    int xLast;
    int yLast;
    int[] pbuf;
    short[] zbuf;
    short colixBackground;
    int argbBackground;
    short colixBackgroundContrast;
    private final Rectangle rectClip = new Rectangle();
    int argbCurrent;
    int argbNoisyUp;
    int argbNoisyDn;
    Font3D font3dCurrent;
    static final int ZBUFFER_BACKGROUND = Short.MAX_VALUE;
    int[] imageBuf = new int[0];
    boolean currentlyRendering;
    int intensity = 0;
    int foo = 0;
    public static final byte ENDCAPS_NONE = 0;
    public static final byte ENDCAPS_OPEN = 1;
    public static final byte ENDCAPS_FLAT = 2;
    public static final byte ENDCAPS_SPHERICAL = 3;
    public static final short NULL = 0;
    public static final short BLACK = 1;
    public static final short ORANGE = 2;
    public static final short PINK = 3;
    public static final short BLUE = 4;
    public static final short WHITE = 5;
    public static final short AQUA = 6;
    public static final short CYAN = 6;
    public static final short RED = 7;
    public static final short GREEN = 8;
    public static final short GRAY = 9;
    public static final short SILVER = 10;
    public static final short LIGHTGRAY = 10;
    public static final short LIME = 11;
    public static final short MAROON = 12;
    public static final short NAVY = 13;
    public static final short OLIVE = 14;
    public static final short PURPLE = 15;
    public static final short TEAL = 16;
    public static final short MAGENTA = 17;
    public static final short FUCHSIA = 17;
    public static final short YELLOW = 18;
    public static final short HOTPINK = 19;
    static Color[] colorsPredefined;
    short[] changableColixMap = new short[16];
    public static final byte shadeMax = 64;
    public static final byte shadeLast = 63;
    public static final byte shadeNormal;
    public static final byte intensitySpecularSurfaceLimit;
    private final Vector3f vectorAB = new Vector3f();
    private final Vector3f vectorAC = new Vector3f();
    private final Vector3f vectorNormal = new Vector3f();
    public static final String[] colorNames;
    public static final int[] colorArgbs;
    private static final Hashtable mapJavaScriptColors;

    public Graphics3D(Component awtComponent) {
        this.platform = Platform3D.createInstance(awtComponent);
        this.line3d = new Line3D(this);
        this.circle3d = new Circle3D(this);
        this.sphere3d = new Sphere3D(this);
        this.triangle3d = new Triangle3D(this);
        this.cylinder3d = new Cylinder3D(this);
        this.hermite3d = new Hermite3D(this);
    }

    public void setSize(Dimension dim, boolean enableFullSceneAntialiasing) {
        if (dim.width == this.windowWidth && dim.height == this.windowHeight && enableFullSceneAntialiasing == this.isFullSceneAntialiasingEnabled) {
            return;
        }
        this.windowWidth = dim.width;
        this.windowHeight = dim.height;
        this.isFullSceneAntialiasingEnabled = enableFullSceneAntialiasing;
        this.width = -1;
        this.height = -1;
        this.pbuf = null;
        this.zbuf = null;
        this.platform.releaseBuffers();
    }

    public boolean fullSceneAntialiasRendering() {
        return false;
    }

    public int getWindowWidth() {
        return this.width;
    }

    public int getWindowHeight() {
        return this.height;
    }

    public int getRenderWidth() {
        return this.width;
    }

    public int getRenderHeight() {
        return this.height;
    }

    public void setBackground(short colix) {
        this.colixBackground = colix;
        this.argbBackground = this.getArgb(colix);
        this.platform.setBackground(this.argbBackground);
        this.colixBackgroundContrast = (short)(Graphics3D.calcGrayscaleFromRgb(this.argbBackground) < 128 ? 5 : 1);
    }

    public short getColixBackgroundContrast() {
        return this.colixBackgroundContrast;
    }

    public static int calcGrayscaleFromRgb(int rgb) {
        return ((2989 * (rgb >> 16) & 0xFF) + (5870 * (rgb >> 8) & 0xFF) + 1140 * (rgb & 0xFF) + 500) / 1000;
    }

    public void setSlabAndDepthValues(int slabValue, int depthValue) {
        int n = slabValue < 0 ? 0 : (this.slab = slabValue > Short.MAX_VALUE ? Short.MAX_VALUE : slabValue);
        this.depth = depthValue < 0 ? 0 : (depthValue > Short.MAX_VALUE ? Short.MAX_VALUE : depthValue);
    }

    private void downSampleFullSceneAntialiasing() {
        int[] pbuf1 = this.pbuf;
        int[] pbuf4 = this.pbuf;
        int width4 = this.width;
        int offset1 = 0;
        int offset4 = 0;
        int i = this.windowHeight;
        while (--i >= 0) {
            int j = this.windowWidth;
            while (--j >= 0) {
                int argb = pbuf4[offset4] >> 2 & 0x3F3F3F3F;
                argb += pbuf4[offset4 + width4] >> 2 & 0x3F3F3F3F;
                argb += pbuf4[++offset4] >> 2 & 0x3F3F3F3F;
                argb += pbuf4[offset4 + width4] >> 2 & 0x3F3F3F3F;
                argb += (argb & 0xC0C0C0C0) >> 6;
                pbuf1[offset1] = argb |= 0xFF000000;
                ++offset1;
                ++offset4;
            }
            offset4 += width4;
        }
    }

    public boolean hasContent() {
        return this.platform.hasContent();
    }

    public void setColor(Color color) {
        this.argbNoisyUp = this.argbNoisyDn = color.getRGB();
        this.argbCurrent = this.argbNoisyDn;
    }

    public void setColorArgb(int argb) {
        this.argbNoisyUp = this.argbNoisyDn = argb;
        this.argbCurrent = this.argbNoisyDn;
    }

    public void setColorNoisy(short colix, int intensity) {
        int[] shades = this.getShades(colix);
        this.argbCurrent = shades[intensity];
        this.argbNoisyUp = shades[intensity < 63 ? intensity + 1 : 63];
        this.argbNoisyDn = shades[intensity > 0 ? intensity - 1 : 0];
    }

    public void setColix(short colix) {
        this.argbNoisyUp = this.argbNoisyDn = this.getArgb(colix);
        this.argbCurrent = this.argbNoisyDn;
    }

    public void drawImage(Image image, int x, int y, int z) {
        int imageHeight;
        int imageWidth = image.getWidth(null);
        int imageSize = imageWidth * (imageHeight = image.getHeight(null));
        if (imageSize > this.imageBuf.length) {
            this.imageBuf = new int[imageSize];
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, imageWidth, imageHeight, this.imageBuf, 0, imageWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.out.println("pg.grabPixels Interrupted");
        }
        int offsetSrc = 0;
        if (x >= 0 && y >= 0 && x + imageWidth <= this.width && y + imageHeight <= this.height) {
            do {
                this.plotPixelsUnclipped(this.imageBuf, offsetSrc, imageWidth, x, y, z);
                offsetSrc += imageWidth;
                ++y;
            } while (--imageHeight > 0);
        } else {
            do {
                this.plotPixelsClipped(this.imageBuf, offsetSrc, imageWidth, x, y, z);
                offsetSrc += imageWidth;
                ++y;
            } while (--imageHeight > 0);
        }
    }

    public void drawCircleCentered(short colix, long xyzd) {
        this.drawCircleCentered(colix, Xyzd.getD(xyzd), Xyzd.getX(xyzd), Xyzd.getY(xyzd), Xyzd.getZ(xyzd));
    }

    public void drawCircleCentered(short colix, int diameter, int x, int y, int z) {
        if (z < this.slab || z > this.depth) {
            return;
        }
        int r = (diameter + 1) / 2;
        this.argbCurrent = this.getArgb(colix);
        if (x >= r && x + r < this.width && y >= r && y + r < this.height) {
            switch (diameter) {
                case 2: {
                    this.plotPixelUnclipped(x, y - 1, z);
                    this.plotPixelUnclipped(x - 1, y - 1, z);
                    this.plotPixelUnclipped(x - 1, y, z);
                }
                case 1: {
                    this.plotPixelUnclipped(x, y, z);
                }
                case 0: {
                    break;
                }
                default: {
                    this.circle3d.plotCircleCenteredUnclipped(x, y, z, diameter);
                    break;
                }
            }
        } else {
            switch (diameter) {
                case 2: {
                    this.plotPixelClipped(x, y - 1, z);
                    this.plotPixelClipped(x - 1, y - 1, z);
                    this.plotPixelClipped(x - 1, y, z);
                }
                case 1: {
                    this.plotPixelClipped(x, y, z);
                }
                case 0: {
                    break;
                }
                default: {
                    this.circle3d.plotCircleCenteredClipped(x, y, z, diameter);
                }
            }
        }
    }

    public void fillScreenedCircleCentered(short colixFill, int diameter, int x, int y, int z) {
        if (diameter == 0 || z < this.slab || z > this.depth) {
            return;
        }
        int r = (diameter + 1) / 2;
        this.argbCurrent = this.getArgb(colixFill);
        if (x >= r && x + r < this.width && y >= r && y + r < this.height) {
            this.circle3d.plotFilledCircleCenteredUnclipped(x, y, z, diameter, true);
            this.circle3d.plotCircleCenteredUnclipped(x, y, z, diameter);
        } else {
            this.circle3d.plotFilledCircleCenteredClipped(x, y, z, diameter, true);
            this.circle3d.plotCircleCenteredClipped(x, y, z, diameter);
        }
    }

    public void fillCircleCentered(short colixFill, int diameter, int x, int y, int z) {
        if (diameter == 0 || z < this.slab || z > this.depth) {
            return;
        }
        int r = (diameter + 1) / 2;
        this.argbCurrent = this.getArgb(colixFill);
        if (x >= r && x + r < this.width && y >= r && y + r < this.height) {
            this.circle3d.plotFilledCircleCenteredUnclipped(x, y, z, diameter, false);
        } else {
            this.circle3d.plotFilledCircleCenteredClipped(x, y, z, diameter, false);
        }
    }

    public void fillSphereCentered(short colix, long xyzd) {
        this.fillSphereCentered(colix, Xyzd.getD(xyzd), Xyzd.getX(xyzd), Xyzd.getY(xyzd), Xyzd.getZ(xyzd));
    }

    public void fillSphereCentered(short colix, Point3i center, int diameter) {
        this.fillSphereCentered(colix, diameter, center.x, center.y, center.z);
    }

    public void fillSphereCentered(short colix, int diameter, int x, int y, int z) {
        if (diameter <= 1) {
            this.plotPixelClipped(colix, x, y, z);
        } else {
            this.sphere3d.render(colix, diameter, x, y, z);
        }
    }

    public void fillSphereCentered(short colix, int diameter, Point3i screen) {
        this.fillSphereCentered(colix, diameter, screen.x, screen.y, screen.z);
    }

    public void fillSphereCentered(short colix, int diameter, Point3f screen) {
        this.fillSphereCentered(colix, diameter, (int)screen.x, (int)screen.y, (int)screen.z);
    }

    public void drawRect(short colix, int x, int y, int z, int width, int height) {
        this.argbCurrent = this.getArgb(colix);
        int xRight = x + width - 1;
        this.line3d.drawHLine(this.argbCurrent, x, y, z, width - 1, true);
        int yBottom = y + height - 1;
        this.line3d.drawVLine(this.argbCurrent, x, y, z, height - 1, true);
        this.line3d.drawVLine(this.argbCurrent, xRight, y, z, height - 1, true);
        this.line3d.drawHLine(this.argbCurrent, x, yBottom, z, width, true);
    }

    public void drawRectNoSlab(short colix, int x, int y, int z, int width, int height) {
        this.argbCurrent = this.getArgb(colix);
        int xRight = x + width - 1;
        this.line3d.drawHLine(this.argbCurrent, x, y, z, width - 1, false);
        int yBottom = y + height - 1;
        this.line3d.drawVLine(this.argbCurrent, x, y, z, height - 1, false);
        this.line3d.drawVLine(this.argbCurrent, xRight, y, z, height - 1, false);
        this.line3d.drawHLine(this.argbCurrent, x, yBottom, z, width, false);
    }

    public void drawString(String str, short colix, int xBaseline, int yBaseline, int z) {
        this.drawString(str, this.font3dCurrent, colix, (short)0, xBaseline, yBaseline, z);
    }

    public void drawString(String str, Font3D font3d, short colix, short bgcolix, int xBaseline, int yBaseline, int z) {
        this.font3dCurrent = font3d;
        this.argbCurrent = this.getArgb(colix);
        if (z < this.slab || z > this.depth) {
            return;
        }
        Text3D.plot(xBaseline, yBaseline - font3d.fontMetrics.getAscent(), z, this.argbCurrent, this.getArgb(bgcolix), str, this.font3dCurrent, this);
    }

    public void drawStringNoSlab(String str, Font3D font3d, short colix, short bgcolix, int xBaseline, int yBaseline, int z) {
        this.font3dCurrent = font3d;
        this.argbCurrent = this.getArgb(colix);
        Text3D.plot(xBaseline, yBaseline - font3d.fontMetrics.getAscent(), z, this.argbCurrent, this.getArgb(bgcolix), str, this.font3dCurrent, this);
    }

    public void setFontOfSize(int fontsize) {
        this.font3dCurrent = this.getFont3D(fontsize);
    }

    public void setFont(byte fid) {
        this.font3dCurrent = Font3D.getFont3D(fid);
    }

    public void setFont(Font3D font3d) {
        this.font3dCurrent = font3d;
    }

    public Font3D getFont3DCurrent() {
        return this.font3dCurrent;
    }

    public byte getFontFidCurrent() {
        return this.font3dCurrent.fid;
    }

    public FontMetrics getFontMetrics() {
        return this.font3dCurrent.fontMetrics;
    }

    private void setRectClip(Rectangle clip) {
        if (clip == null) {
            this.rectClip.y = 0;
            this.rectClip.x = 0;
            this.rectClip.width = this.width;
            this.rectClip.height = this.height;
        } else {
            this.rectClip.setBounds(clip);
            if (this.rectClip.x < 0) {
                this.rectClip.x = 0;
            }
            if (this.rectClip.y < 0) {
                this.rectClip.y = 0;
            }
            if (this.rectClip.x + this.rectClip.width > this.windowWidth) {
                this.rectClip.width = this.windowWidth - this.rectClip.x;
            }
            if (this.rectClip.y + this.rectClip.height > this.windowHeight) {
                this.rectClip.height = this.windowHeight - this.rectClip.y;
            }
            if (this.antialiasThisFrame) {
                this.rectClip.x *= 2;
                this.rectClip.y *= 2;
                this.rectClip.width *= 2;
                this.rectClip.height *= 2;
            }
        }
    }

    public void beginRendering(Rectangle rectClip, boolean antialiasThisFrame) {
        if (this.currentlyRendering) {
            this.endRendering();
        }
        this.antialiasThisFrame = antialiasThisFrame &= this.isFullSceneAntialiasingEnabled;
        this.currentlyRendering = true;
        if (this.pbuf == null) {
            this.platform.allocateBuffers(this.windowWidth, this.windowHeight, this.isFullSceneAntialiasingEnabled);
            this.pbuf = this.platform.pBuffer;
            this.zbuf = this.platform.zBuffer;
            this.width = this.windowWidth;
            this.xLast = this.width - 1;
            this.height = this.windowHeight;
            this.yLast = this.height - 1;
        }
        this.width = this.windowWidth;
        this.height = this.windowHeight;
        if (antialiasThisFrame) {
            this.width *= 2;
            this.height *= 2;
        }
        this.xLast = this.width - 1;
        this.yLast = this.height - 1;
        this.setRectClip(rectClip);
        this.platform.obtainScreenBuffer();
    }

    public void endRendering() {
        if (this.currentlyRendering) {
            if (this.antialiasThisFrame) {
                this.downSampleFullSceneAntialiasing();
            }
            this.platform.notifyEndOfRendering();
            this.currentlyRendering = false;
        }
    }

    public Image getScreenImage() {
        return this.platform.imagePixelBuffer;
    }

    public void releaseScreenImage() {
        this.platform.clearScreenBufferThreaded();
    }

    public void drawDashedLine(short colix, int run, int rise, int x1, int y1, int z1, int x2, int y2, int z2) {
        int argb = this.getArgb(colix);
        this.line3d.drawDashedLine(argb, argb, run, rise, x1, y1, z1, x2, y2, z2);
    }

    public void drawDottedLine(short colix, int x1, int y1, int z1, int x2, int y2, int z2) {
        int argb = this.getArgb(colix);
        this.line3d.drawDashedLine(argb, argb, 2, 1, x1, y1, z1, x2, y2, z2);
    }

    public void drawDashedLine(short colix1, short colix2, int run, int rise, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.line3d.drawDashedLine(this.getArgb(colix1), this.getArgb(colix2), run, rise, x1, y1, z1, x2, y2, z2);
    }

    public void drawLine(Point3i pointA, Point3i pointB) {
        this.line3d.drawLine(this.argbCurrent, this.argbCurrent, pointA.x, pointA.y, pointA.z, pointB.x, pointB.y, pointB.z);
    }

    public void drawLine(short colix, Point3i pointA, Point3i pointB) {
        int argb = this.getArgb(colix);
        this.line3d.drawLine(argb, argb, pointA.x, pointA.y, pointA.z, pointB.x, pointB.y, pointB.z);
    }

    public void drawDottedLine(short colix, Point3i pointA, Point3i pointB) {
        this.drawDashedLine(colix, 2, 1, pointA, pointB);
    }

    public void drawDashedLine(short colix, int run, int rise, Point3i pointA, Point3i pointB) {
        int argb = this.getArgb(colix);
        this.line3d.drawDashedLine(argb, argb, run, rise, pointA.x, pointA.y, pointA.z, pointB.x, pointB.y, pointB.z);
    }

    public void drawDashedLine(int run, int rise, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.line3d.drawDashedLine(this.argbCurrent, this.argbCurrent, run, rise, x1, y1, z1, x2, y2, z2);
    }

    public void drawLine(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.line3d.drawLine(this.argbCurrent, this.argbCurrent, x1, y1, z1, x2, y2, z2);
    }

    public void drawLine(short colix, int x1, int y1, int z1, int x2, int y2, int z2) {
        int argb = this.getArgb(colix);
        this.line3d.drawLine(argb, argb, x1, y1, z1, x2, y2, z2);
    }

    public void drawLine(short colix1, short colix2, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.line3d.drawLine(this.getArgb(colix1), this.getArgb(colix2), x1, y1, z1, x2, y2, z2);
    }

    public void drawPolygon4(int[] ax, int[] ay, int[] az) {
        this.drawLine(ax[0], ay[0], az[0], ax[3], ay[3], az[3]);
        int i = 3;
        while (--i >= 0) {
            this.drawLine(ax[i], ay[i], az[i], ax[i + 1], ay[i + 1], az[i + 1]);
        }
    }

    public void fillQuadrilateral(short colix, Point3f screenA, Point3f screenB, Point3f screenC, Point3f screenD) {
        this.setColorNoisy(colix, this.calcIntensityScreen(screenA, screenB, screenC));
        this.fillTriangle(screenA, screenB, screenC);
        this.fillTriangle(screenA, screenC, screenD);
    }

    public void fillTriangle(short colix, Point3i screenA, Point3i screenB, Point3i screenC) {
        this.calcSurfaceShade(colix, screenA, screenB, screenC);
        int[] t = this.triangle3d.ax;
        t[0] = screenA.x;
        t[1] = screenB.x;
        t[2] = screenC.x;
        t = this.triangle3d.ay;
        t[0] = screenA.y;
        t[1] = screenB.y;
        t[2] = screenC.y;
        t = this.triangle3d.az;
        t[0] = screenA.z;
        t[1] = screenB.z;
        t[2] = screenC.z;
        this.triangle3d.fillTriangleNoisy();
    }

    public void fillTriangle(short colix, Point3f screenA, Point3f screenB, Point3f screenC) {
        this.setColorNoisy(colix, this.calcIntensityScreen(screenA, screenB, screenC));
        this.fillTriangle(screenA, screenB, screenC);
    }

    public void fillQuadrilateral(int argb, Point3i screenA, Point3i screenB, Point3i screenC, Point3i screenD) {
        this.fillTriangle(argb, screenA, screenB, screenC);
        this.fillTriangle(argb, screenA, screenC, screenD);
    }

    public void fillTriangle(int argb, Point3i screenA, Point3i screenB, Point3i screenC) {
        this.argbNoisyUp = this.argbNoisyDn = argb;
        this.argbCurrent = this.argbNoisyDn;
        int[] t = this.triangle3d.ax;
        t[0] = screenA.x;
        t[1] = screenB.x;
        t[2] = screenC.x;
        t = this.triangle3d.ay;
        t[0] = screenA.y;
        t[1] = screenB.y;
        t[2] = screenC.y;
        t = this.triangle3d.az;
        t[0] = screenA.z;
        t[1] = screenB.z;
        t[2] = screenC.z;
        this.triangle3d.fillTriangleNoisy();
    }

    public void fillTriangle(Point3i screenA, Point3i screenB, Point3i screenC) {
        int[] t = this.triangle3d.ax;
        t[0] = screenA.x;
        t[1] = screenB.x;
        t[2] = screenC.x;
        t = this.triangle3d.ay;
        t[0] = screenA.y;
        t[1] = screenB.y;
        t[2] = screenC.y;
        t = this.triangle3d.az;
        t[0] = screenA.z;
        t[1] = screenB.z;
        t[2] = screenC.z;
        this.triangle3d.fillTriangleNoisy();
    }

    public void fillTriangle(Point3f screenA, Point3f screenB, Point3f screenC) {
        int[] t = this.triangle3d.ax;
        t[0] = (int)screenA.x;
        t[1] = (int)screenB.x;
        t[2] = (int)screenC.x;
        t = this.triangle3d.ay;
        t[0] = (int)screenA.y;
        t[1] = (int)screenB.y;
        t[2] = (int)screenC.y;
        t = this.triangle3d.az;
        t[0] = (int)screenA.z;
        t[1] = (int)screenB.z;
        t[2] = (int)screenC.z;
        this.triangle3d.fillTriangleNoisy();
    }

    void diff(Vector3f v, Point3i s1, Point3i s2) {
        v.x = s1.x - s2.x;
        v.y = s1.y - s2.y;
        v.z = s1.z - s2.z;
    }

    public void calcSurfaceShade(short colix, Point3i screenA, Point3i screenB, Point3i screenC) {
        this.diff(this.vectorAB, screenB, screenA);
        this.diff(this.vectorAC, screenC, screenA);
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        int intensity = this.vectorNormal.z >= 0.0f ? Graphics3D.calcIntensity(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : Graphics3D.calcIntensity(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
        this.setColorNoisy(colix, intensity);
    }

    public void calcSurfaceShade(short colix, Point3f screenA, Point3f screenB, Point3f screenC) {
        this.vectorAB.sub(screenB, screenA);
        this.vectorAC.sub(screenC, screenA);
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        int intensity = this.vectorNormal.z >= 0.0f ? Graphics3D.calcIntensity(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : Graphics3D.calcIntensity(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
        this.argbCurrent = this.getShades(colix)[intensity];
    }

    public void drawfillTriangle(short colix, int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC) {
        int argb = this.argbCurrent = this.getArgb(colix);
        this.line3d.drawLine(argb, argb, xA, yA, zA, xB, yB, zB);
        this.line3d.drawLine(argb, argb, xA, yA, zA, xC, yC, zC);
        this.line3d.drawLine(argb, argb, xB, yB, zB, xC, yC, zC);
        int[] t = this.triangle3d.ax;
        t[0] = xA;
        t[1] = xB;
        t[2] = xC;
        t = this.triangle3d.ay;
        t[0] = yA;
        t[1] = yB;
        t[2] = yC;
        t = this.triangle3d.az;
        t[0] = zA;
        t[1] = zB;
        t[2] = zC;
        this.triangle3d.fillTriangleNoisy();
    }

    public void fillTriangle(short colix, int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC) {
        this.argbCurrent = this.getArgb(colix);
        int[] t = this.triangle3d.ax;
        t[0] = xA;
        t[1] = xB;
        t[2] = xC;
        t = this.triangle3d.ay;
        t[0] = yA;
        t[1] = yB;
        t[2] = yC;
        t = this.triangle3d.az;
        t[0] = zA;
        t[1] = zB;
        t[2] = zC;
        this.triangle3d.fillTriangleNoisy();
    }

    public void drawTriangle(short colix, int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC) {
        int argb = this.getArgb(colix);
        this.line3d.drawLine(argb, argb, xA, yA, zA, xB, yB, zB);
        this.line3d.drawLine(argb, argb, xA, yA, zA, xC, yC, zC);
        this.line3d.drawLine(argb, argb, xB, yB, zB, xC, yC, zC);
    }

    public void fillCylinder(short colixA, short colixB, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.cylinder3d.render(colixA, colixB, endcaps, diameter, xA, yA, zA, xB - xA, yB - yA, zB - zA);
    }

    public void fillCylinder(short colix, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.cylinder3d.render(colix, colix, endcaps, diameter, xA, yA, zA, xB - xA, yB - yA, zB - zA);
    }

    public void fillCylinder(short colix, byte endcaps, int diameter, Point3i screenA, Point3i screenB) {
        this.cylinder3d.render(colix, colix, endcaps, diameter, screenA.x, screenA.y, screenA.z, screenB.x - screenA.x, screenB.y - screenA.y, screenB.z - screenA.z);
    }

    public void fillCone(short colix, byte endcap, int diameter, int xBase, int yBase, int zBase, int xTip, int yTip, int zTip) {
        this.cylinder3d.renderCone(colix, endcap, diameter, xBase, yBase, zBase, xTip, yTip, zTip);
    }

    public void fillCone(short colix, byte endcap, int diameter, Point3i screenBase, Point3i screenTip) {
        this.cylinder3d.renderCone(colix, endcap, diameter, screenBase.x, screenBase.y, screenBase.z, screenTip.x, screenTip.y, screenTip.z);
    }

    public void fillHermite(short colix, int tension, int diameterBeg, int diameterMid, int diameterEnd, Point3i s0, Point3i s1, Point3i s2, Point3i s3) {
        this.hermite3d.render(true, colix, tension, diameterBeg, diameterMid, diameterEnd, s0, s1, s2, s3);
    }

    public void drawHermite(short colix, int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3) {
        this.hermite3d.render(false, colix, tension, 0, 0, 0, s0, s1, s2, s3);
    }

    public void drawHermite(boolean fill, short colix, int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3, Point3i s4, Point3i s5, Point3i s6, Point3i s7) {
        this.hermite3d.render2(fill, colix, tension, s0, s1, s2, s3, s4, s5, s6, s7);
    }

    public void fillRect(short colix, int x, int y, int z, int widthFill, int heightFill) {
        this.argbCurrent = this.getArgb(colix);
        if (x < 0) {
            if ((widthFill += x) <= 0) {
                return;
            }
            x = 0;
        }
        if (x + widthFill > this.width && (widthFill = this.width - x) == 0) {
            return;
        }
        if (y < 0) {
            if ((heightFill += y) <= 0) {
                return;
            }
            y = 0;
        }
        if (y + heightFill > this.height) {
            heightFill = this.height - y;
        }
        while (--heightFill >= 0) {
            this.plotPixelsUnclipped(widthFill, x, y++, z, false);
        }
    }

    public void drawPixel(Point3i point) {
        this.plotPixelClipped(point);
    }

    public void drawPixel(int x, int y, int z) {
        this.plotPixelClipped(x, y, z);
    }

    void plotPixelClipped(int x, int y, int z) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height || z < this.slab || z > this.depth) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = (short)z;
            this.pbuf[offset] = this.argbCurrent;
        }
    }

    void plotPixelClipped(Point3i screen) {
        int x = screen.x;
        if (x < 0 || x >= this.width) {
            return;
        }
        int y = screen.y;
        if (y < 0 || y >= this.height) {
            return;
        }
        int z = screen.z;
        if (z < this.slab || z > this.depth) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = (short)z;
            this.pbuf[offset] = this.argbCurrent;
        }
    }

    void plotPixelClipped(int argb, int x, int y, int z) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height || z < this.slab || z > this.depth) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = (short)z;
            this.pbuf[offset] = argb;
        }
    }

    void plotPixelClipped(short colix, int x, int y, int z) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height || z < this.slab || z > this.depth) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = (short)z;
            this.pbuf[offset] = this.getArgb(colix);
        }
    }

    void forcePixel(Color co, int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        int offset = y * this.width + x;
        this.zbuf[offset] = 0;
        this.pbuf[offset] = co.getRGB();
    }

    void plotPixelUnclipped(int x, int y, int z) {
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = (short)z;
            this.pbuf[offset] = this.argbCurrent;
        }
    }

    void plotPixelUnclipped(int argb, int x, int y, int z) {
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = (short)z;
            this.pbuf[offset] = argb;
        }
    }

    void plotPixelsClipped(int count, int x, int y, int z, boolean tScreened) {
        if (y < 0 || y >= this.height || x >= this.width || z < this.slab || z > this.depth) {
            return;
        }
        if (x < 0) {
            if ((count += x) <= 0) {
                return;
            }
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        int offsetPbuf = y * this.width + x;
        int offsetMax = offsetPbuf + count;
        int step = 1;
        if (tScreened) {
            step = 2;
            if (((x ^ y) & 1) != 0 && ++offsetPbuf == offsetMax) {
                return;
            }
        }
        do {
            if (z >= this.zbuf[offsetPbuf]) continue;
            this.zbuf[offsetPbuf] = (short)z;
            this.pbuf[offsetPbuf] = this.argbCurrent;
        } while ((offsetPbuf += step) < offsetMax);
    }

    void plotNoisyPixelsClipped(int count, int x, int y, int zAtLeft, int zPastRight) {
        if (count <= 0 || y < 0 || y >= this.height || x >= this.width || zAtLeft < this.slab && zPastRight < this.slab || zAtLeft > this.depth && zPastRight > this.depth) {
            return;
        }
        int seed = (x << 16) + (y << 1) ^ 0x33333333;
        int zScaled = (zAtLeft << 10) + 512;
        int dz = zPastRight - zAtLeft;
        int roundFactor = count / 2;
        int zIncrementScaled = ((dz << 10) + (dz >= 0 ? roundFactor : -roundFactor)) / count;
        if (x < 0) {
            x = -x;
            zScaled += zIncrementScaled * x;
            if ((count -= x) <= 0) {
                return;
            }
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        int offsetPbuf = y * this.width + x;
        while (--count >= 0) {
            int z = zScaled >> 10;
            if (z >= this.slab && z <= this.depth && z < this.zbuf[offsetPbuf]) {
                this.zbuf[offsetPbuf] = (short)z;
                int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                this.pbuf[offsetPbuf] = bits == 0 ? this.argbNoisyDn : (bits == 1 ? this.argbNoisyUp : this.argbCurrent);
            }
            ++offsetPbuf;
            zScaled += zIncrementScaled;
        }
    }

    void plotPixelsUnclipped(int count, int x, int y, int z, boolean tScreened) {
        int offsetPbuf = y * this.width + x;
        if (!tScreened) {
            while (--count >= 0) {
                if (z < this.zbuf[offsetPbuf]) {
                    this.zbuf[offsetPbuf] = (short)z;
                    this.pbuf[offsetPbuf] = this.argbCurrent;
                }
                ++offsetPbuf;
            }
        } else {
            int offsetMax = offsetPbuf + count;
            if (((x ^ y) & 1) != 0 && ++offsetPbuf == offsetMax) {
                return;
            }
            do {
                if (z >= this.zbuf[offsetPbuf]) continue;
                this.zbuf[offsetPbuf] = (short)z;
                this.pbuf[offsetPbuf] = this.argbCurrent;
            } while ((offsetPbuf += 2) < offsetMax);
        }
    }

    void plotPixelsClipped(int[] pixels, int offset, int count, int x, int y, int z) {
        if (y < 0 || y >= this.height || x >= this.width || z < this.slab || z > this.depth) {
            return;
        }
        if (x < 0) {
            if ((count += x) < 0) {
                return;
            }
            offset -= x;
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        int offsetPbuf = y * this.width + x;
        while (--count >= 0) {
            int pixel;
            int alpha;
            if ((alpha = (pixel = pixels[offset++]) & 0xFF000000) >= Integer.MIN_VALUE && z < this.zbuf[offsetPbuf]) {
                this.zbuf[offsetPbuf] = (short)z;
                this.pbuf[offsetPbuf] = pixel;
            }
            ++offsetPbuf;
        }
    }

    void plotPixelsUnclipped(int[] pixels, int offset, int count, int x, int y, int z) {
        int offsetPbuf = y * this.width + x;
        while (--count >= 0) {
            int pixel;
            int alpha;
            if (((alpha = (pixel = pixels[offset++]) & 0xFF000000) & Integer.MIN_VALUE) != 0 && z < this.zbuf[offsetPbuf]) {
                this.zbuf[offsetPbuf] = (short)z;
                this.pbuf[offsetPbuf] = pixel;
            }
            ++offsetPbuf;
        }
    }

    void plotLineDelta(int[] shades1, int[] shades2, int fp8Intensity, int x, int y, int z, int dx, int dy, int dz) {
        if (x < 0 || x >= this.width || x + dx < 0 || x + dx >= this.width || y < 0 || y >= this.height || y + dy < 0 || y + dy >= this.height || z < this.slab || z + dz < this.slab || z > this.depth || z + dz > this.depth) {
            this.line3d.plotLineDeltaClipped(shades1, shades2, fp8Intensity, x, y, z, dx, dy, dz);
        } else {
            this.line3d.plotLineDeltaUnclipped(shades1, shades2, fp8Intensity, x, y, z, dx, dy, dz);
        }
    }

    void plotLineDelta(int argb1, int argb2, int x, int y, int z, int dx, int dy, int dz) {
        if (x < 0 || x >= this.width || x + dx < 0 || x + dx >= this.width || y < 0 || y >= this.height || y + dy < 0 || y + dy >= this.height || z < this.slab || z + dz < this.slab || z > this.depth || z + dz > this.depth) {
            this.line3d.plotLineDeltaClipped(argb1, argb2, x, y, z, dx, dy, dz);
        } else {
            this.line3d.plotLineDeltaUnclipped(argb1, argb2, x, y, z, dx, dy, dz);
        }
    }

    public void plotPoints(short colix, int count, int[] coordinates) {
        int argb = this.argbCurrent = this.getArgb(colix);
        int i = count * 3;
        while (i > 0) {
            int offset;
            int x;
            int z = coordinates[--i];
            int y = coordinates[--i];
            if ((x = coordinates[--i]) < 0 || x >= this.width || y < 0 || y >= this.height || z < this.slab || z > this.depth || z >= this.zbuf[offset = y * this.width + x]) continue;
            this.zbuf[offset] = (short)z;
            this.pbuf[offset] = argb;
        }
    }

    public void plotPoints(int count, short colix, byte[] intensities, int[] coordinates) {
        int[] shades = this.getShades(colix);
        int i = count * 3;
        int j = count - 1;
        while (i > 0) {
            int offset;
            int x;
            int z = coordinates[--i];
            int y = coordinates[--i];
            if ((x = coordinates[--i]) >= 0 && x < this.width && y >= 0 && y < this.height && z >= this.slab && z <= this.depth && z < this.zbuf[offset = y * this.width + x]) {
                this.zbuf[offset] = (short)z;
                this.pbuf[offset] = shades[intensities[j]];
            }
            --j;
        }
    }

    void averageOffsetArgb(int offset, int argb) {
        this.pbuf[offset] = (this.pbuf[offset] >> 1 & 0x7F7F7F) + (argb >> 1 & 0xFF7F7F7F) | argb & 0xFF010101;
    }

    public int getArgb(short colix) {
        return Colix.getArgb(colix >= 0 ? colix : this.changableColixMap[-colix]);
    }

    public int[] getShades(short colix) {
        return Colix.getShades(colix >= 0 ? colix : this.changableColixMap[-colix]);
    }

    public short getColix(int argb) {
        return Colix.getColix(argb);
    }

    public short getColix(Color color) {
        return Colix.getColix(color);
    }

    public short getColix(String colorName) {
        return this.getColix(Graphics3D.getColorFromString(colorName));
    }

    public short getColix(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Color) {
            return this.getColix((Color)obj);
        }
        if (obj instanceof Integer) {
            return this.getColix((Integer)obj);
        }
        if (obj instanceof String) {
            return this.getColix((String)obj);
        }
        System.out.println("?? getColix(" + obj + ")");
        return 19;
    }

    public Color getColor(short colix) {
        return Colix.getColor(colix >= 0 ? colix : this.changableColixMap[-colix]);
    }

    public short getChangableColix(short id, int argb) {
        if ((id = (short)(id + 1)) >= this.changableColixMap.length) {
            short[] t = new short[id + 16];
            System.arraycopy(this.changableColixMap, 0, t, 0, this.changableColixMap.length);
            this.changableColixMap = t;
        }
        if (this.changableColixMap[id] == 0) {
            this.changableColixMap[id] = this.getColix(argb);
        }
        return -id;
    }

    public void changeColixArgb(short id, int argb) {
        if ((id = (short)(id + 1)) < this.changableColixMap.length && this.changableColixMap[id] != 0) {
            this.changableColixMap[id] = this.getColix(argb);
        }
    }

    public void flushShadesAndImageCaches() {
        Colix.flushShades();
        Sphere3D.flushImageCache();
    }

    public void setSpecular(boolean specular) {
        Shade3D.setSpecular(specular);
    }

    public boolean getSpecular() {
        return Shade3D.getSpecular();
    }

    public void setSpecularPower(int specularPower) {
        Shade3D.setSpecularPower(specularPower);
    }

    public void setAmbientPercent(int ambientPercent) {
        Shade3D.setAmbientPercent(ambientPercent);
    }

    public void setDiffusePercent(int diffusePercent) {
        Shade3D.setDiffusePercent(diffusePercent);
    }

    public void setSpecularPercent(int specularPercent) {
        Shade3D.setSpecularPercent(specularPercent);
    }

    public void setLightsourceZ(float dist) {
        Shade3D.setLightsourceZ(dist);
    }

    public int calcIntensityScreen(Point3f screenA, Point3f screenB, Point3f screenC) {
        this.vectorAB.sub(screenB, screenA);
        this.vectorAC.sub(screenC, screenA);
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        return this.vectorNormal.z >= 0.0f ? Shade3D.calcIntensity(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : Shade3D.calcIntensity(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
    }

    public static int calcIntensity(float x, float y, float z) {
        return Shade3D.calcIntensity(x, y, z);
    }

    public Font3D getFont3D(int fontSize) {
        return Font3D.getFont3D(0, 0, fontSize, this.platform);
    }

    public Font3D getFont3D(String fontFace, int fontSize) {
        return Font3D.getFont3D(Font3D.getFontFaceID(fontFace), 0, fontSize, this.platform);
    }

    public Font3D getFont3D(String fontFace, String fontStyle, int fontSize) {
        return Font3D.getFont3D(Font3D.getFontFaceID(fontFace), Font3D.getFontStyleID(fontStyle), fontSize, this.platform);
    }

    public byte getFontFid(int fontSize) {
        return this.getFont3D((int)fontSize).fid;
    }

    public byte getFontFid(String fontFace, int fontSize) {
        return this.getFont3D((String)fontFace, (int)fontSize).fid;
    }

    public byte getFontFid(String fontFace, String fontStyle, int fontSize) {
        return this.getFont3D((String)fontFace, (String)fontStyle, (int)fontSize).fid;
    }

    public static int getArgbFromString(String strColor) {
        if (strColor != null) {
            if (strColor.length() == 7 && strColor.charAt(0) == '#') {
                try {
                    int red = Integer.parseInt(strColor.substring(1, 3), 16);
                    int grn = Integer.parseInt(strColor.substring(3, 5), 16);
                    int blu = Integer.parseInt(strColor.substring(5, 7), 16);
                    return 0xFF000000 | (red & 0xFF) << 16 | (grn & 0xFF) << 8 | blu & 0xFF;
                }
                catch (NumberFormatException e) {}
            } else {
                Color color = (Color)mapJavaScriptColors.get(strColor.toLowerCase());
                if (color != null) {
                    return color.getRGB();
                }
            }
        }
        return 0;
    }

    public static Color getColorFromString(String strColor) {
        if (strColor != null) {
            if (strColor.length() == 7 && strColor.charAt(0) == '#') {
                try {
                    int red = Integer.parseInt(strColor.substring(1, 3), 16);
                    int grn = Integer.parseInt(strColor.substring(3, 5), 16);
                    int blu = Integer.parseInt(strColor.substring(5, 7), 16);
                    return new Color(red, grn, blu);
                }
                catch (NumberFormatException e) {}
            } else {
                Color color = (Color)mapJavaScriptColors.get(strColor.toLowerCase());
                if (color != null) {
                    return color;
                }
            }
        }
        System.out.println("error converting string to color:" + strColor);
        return Color.pink;
    }

    static {
        int i;
        colorsPredefined = new Color[]{Color.black, Color.orange, Color.pink, Color.blue, Color.white, Color.cyan, Color.red, new Color(0, 128, 0), Color.gray, Color.lightGray, Color.green, new Color(128, 0, 0), new Color(0, 0, 128), new Color(128, 128, 0), new Color(128, 0, 128), new Color(0, 128, 128), Color.magenta, Color.yellow, new Color(255, 105, 180)};
        for (i = 0; i < colorsPredefined.length; ++i) {
            Colix.getColix(colorsPredefined[i]);
        }
        shadeNormal = Shade3D.shadeNormal;
        intensitySpecularSurfaceLimit = Shade3D.intensitySpecularSurfaceLimit;
        colorNames = new String[]{"aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen", "bluetint", "greenblue", "greentint", "grey", "pinktint", "redorange", "yellowtint", "pecyan", "pepurple", "pegreen", "peblue", "peviolet", "pebrown", "pepink", "peyellow", "pedarkgreen", "peorange", "pelightblue", "pedarkcyan", "pedarkgray", "pewhite"};
        colorArgbs = new int[]{-984833, -332841, -16711681, -8388652, -983041, -657956, -6972, -16777216, -5171, -16776961, -7722014, -5952982, -2180985, -10510688, -8388864, -2987746, -32944, -10185235, -1828, -2354116, -16711681, -16777077, -16741493, -4684277, -5658199, -16751616, -4343957, -7667573, -11179217, -29696, -6737204, -7667712, -1468806, -7357297, -12042869, -13676721, -16724271, -7077677, -60269, -16728065, -9868951, -14774017, -5103070, -1296, -14513374, -65281, -2302756, -460545, -10496, -2448096, -8355712, -16744448, -5374161, -983056, -38476, -3318692, -11861886, -16, -989556, -1644806, -3851, -8586240, -1331, -5383962, -1015680, -2031617, -329006, -7278960, -2894893, -18751, -24454, -14634326, -7876870, -8943463, -5192482, -32, -16711936, -13447886, -331546, -65281, -8388608, -10039894, -16777011, -4565549, -7114533, -12799119, -8689426, -16713062, -12004916, -3730043, -15132304, -655366, -6943, -6987, -8531, -16777088, -133658, -8355840, -9728477, -23296, -47872, -2461482, -1120086, -6751336, -5247250, -2396013, -4139, -9543, -3308225, -16181, -2252579, -5185306, -8388480, -65536, -4419697, -12490271, -7650029, -360334, -744352, -13726889, -2578, -6270419, -4144960, -7876885, -9807155, -9404272, -1286, -16711809, -12156236, -2968436, -16744320, -2572328, -40121, -12525360, -1146130, -663885, -1, -657931, -256, -6632142, -5253121, -13726889, -6750285, -8355712, -21573, -47872, -592267, -16711681, -3137281, -16711936, -10460929, -32576, -6021080, -10024, -256, -16728064, -20480, -5197569, -16736096, -10461088, -1};
        mapJavaScriptColors = new Hashtable();
        i = colorNames.length;
        while (--i >= 0) {
            mapJavaScriptColors.put(colorNames[i], new Color(colorArgbs[i]));
        }
    }
}

