/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.viewer.Viewer;

class SelectionManager {
    Viewer viewer;
    private final BitSet bsNull = new BitSet();
    final BitSet bsSelection = new BitSet();
    static final int TRUE = 1;
    static final int FALSE = 0;
    static final int UNKNOWN = -1;
    int empty = 1;

    SelectionManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void addSelection(int atomIndex) {
        this.bsSelection.set(atomIndex);
        this.empty = 0;
    }

    void addSelection(BitSet set) {
        this.bsSelection.or(set);
        if (this.empty == 1) {
            this.empty = -1;
        }
    }

    void toggleSelection(int atomIndex) {
        if (this.bsSelection.get(atomIndex)) {
            this.bsSelection.clear(atomIndex);
        } else {
            this.bsSelection.set(atomIndex);
        }
        this.empty = this.empty == 1 ? 0 : -1;
    }

    boolean isSelected(int atomIndex) {
        return this.bsSelection.get(atomIndex);
    }

    boolean isEmpty() {
        if (this.empty != -1) {
            return this.empty == 1;
        }
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.bsSelection.get(i)) continue;
            this.empty = 0;
            return false;
        }
        this.empty = 1;
        return true;
    }

    void selectAll() {
        int count = this.viewer.getAtomCount();
        this.empty = count == 0 ? 1 : 0;
        int i = count;
        while (--i >= 0) {
            this.bsSelection.set(i);
        }
    }

    void clearSelection() {
        this.bsSelection.and(this.bsNull);
        this.empty = 1;
    }

    void delete(int iDeleted) {
        if (this.empty == 1) {
            return;
        }
        int numAfterDelete = this.viewer.getAtomCount() - 1;
        for (int i = iDeleted; i < numAfterDelete; ++i) {
            if (this.bsSelection.get(i + 1)) {
                this.bsSelection.set(i);
                continue;
            }
            this.bsSelection.clear(i);
        }
        this.empty = -1;
    }

    void setSelection(int atomIndex) {
        this.bsSelection.and(this.bsNull);
        this.bsSelection.set(atomIndex);
        this.empty = 0;
    }

    void setSelectionSet(BitSet set) {
        this.bsSelection.and(this.bsNull);
        this.bsSelection.or(set);
        this.empty = -1;
    }

    void toggleSelectionSet(BitSet bs) {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0 && (!bs.get(i) || this.bsSelection.get(i))) {
        }
        if (i < 0) {
            i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.bsSelection.clear(i);
            }
            this.empty = -1;
        } else {
            do {
                if (!bs.get(i)) continue;
                this.bsSelection.set(i);
                this.empty = 0;
            } while (--i >= 0);
        }
    }

    void invertSelection() {
        this.empty = 1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (this.bsSelection.get(i)) {
                this.bsSelection.clear(i);
                continue;
            }
            this.bsSelection.set(i);
            this.empty = 0;
        }
    }

    void excludeSelectionSet(BitSet setExclude) {
        if (this.empty == 1) {
            return;
        }
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!setExclude.get(i)) continue;
            this.bsSelection.clear(i);
        }
        this.empty = -1;
    }

    int getSelectionCount() {
        if (this.empty == 1) {
            return 0;
        }
        int count = 0;
        this.empty = 1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.bsSelection.get(i)) continue;
            ++count;
        }
        if (count > 0) {
            this.empty = 0;
        }
        return count;
    }
}

