# The LearningOnline Network with CAPA
# Routines to control the menu
#
# $Id: lonmenu.pm,v 1.207 2006/12/06 11:34:37 foxr Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#
# There are two parameters controlling the action of this module:
#
# browser.interface - if this is 'textual', it overrides the second parameter
# and goes to screen reader PDA mode
#
# environment.remote - if this is 'on', the routines controll the remote
# control, otherwise they render the main window controls; ignored it
# browser.interface is 'textual'
#

package Apache::lonmenu;

use strict;
use Apache::lonnet;
use Apache::lonhtmlcommon();
use Apache::loncommon();
use Apache::lonenc();
use Apache::lonlocal;
use LONCAPA qw(:DEFAULT :match);

use vars qw(@desklines $readdesk);


my @inlineremote;



# ================================================================ Little texts

sub initlittle {
    return &Apache::lonlocal::texthash('ret' => 'Return to Last Location',
				       'nav' => 'Navigate Contents',
				       'main' => 'Main Menu',
                                       'roles' => ($env{'user.adv'}?
                                                    'Roles':'Courses'),
                                       'docs' => 'Course Documents',
                                       'exit' => 'Exit',
                                       'login' => 'Log In',
				       'launch' => 'Launch Remote Control',
                                       'groups' => 'Groups',
                                       'gdoc' => 'Group Documents',
                                       );
}

# ============================= This gets called at the top of the body section

sub menubuttons {
    my $forcereg=shift;
    my $registration=shift;
    my $titletable=shift;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
					    ['inhibitmenu']);
    if (($env{'form.inhibitmenu'} eq 'yes') ||
        ($ENV{'REQUEST_URI'} eq '/adm/logout')) { return ''; }

    if ($env{'request.noversionuri'} =~ m{^/res/adm/pages/}) { return ''; }

    my %lt=&initlittle();
    my $navmaps='';
    my $reloadlink='';
    my $docs='';
    my $groups='';
    my $showgroups=0;
    my $escurl=&escape(&Apache::lonenc::check_encrypt($env{'request.noversionuri'}));
    my $escsymb=&escape(&Apache::lonenc::check_encrypt($env{'request.symb'}));

    my $logo=&Apache::loncommon::lonhttpdurl("/adm/lonIcons/minilogo.gif");
    $logo = '<td class="LC_top_nav_logo"><a href="/adm/about.html"><img src="'.
	$logo.'" alt="LON-CAPA Logo" /></a></td>';

    if ($env{'request.state'} eq 'construct') {
        if (($env{'request.noversionuri'} eq '') || (!defined($env{'request.noversionuri'}))) {
            my $returnurl = $env{'request.filename'};
            $returnurl =~ s:^/home/([^/]+)/public_html/(.*)$:/priv/$1/$2:;
            $escurl = &escape($returnurl);
        }
    }
    if ($env{'request.course.id'}) {
        my %coursegroups;
        my $viewgrps_permission =
	    &Apache::lonnet::allowed('vcg',$env{'request.course.id'}.($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''));
        if (!$viewgrps_permission) {
            %coursegroups = &Apache::lonnet::get_active_groups($env{'user.domain'},$env{'user.name'},$env{'course.'.$env{'request.course.id'}.'.domain'}, $env{'course.'.$env{'request.course.id'}.'.num'});
	}
        if ((keys(%coursegroups) > 0) || ($viewgrps_permission)) {
            $showgroups = 1;
        }
    }

    if ($env{'browser.interface'} eq 'textual') {
# Textual display only
        if ($env{'request.course.id'}) {
	    $navmaps=(<<ENDNAV);
<a href="/adm/navmaps?postdata=$escurl&amp;postsymb=$escsymb" target="_top">$lt{'nav'}</a>
ENDNAV
            if (($env{'request.noversionuri'}=~/^\/adm\//) &&
         ($env{'request.noversionuri'}!~/^\/adm\/wrapper\//) &&
         ($env{'request.noversionuri'}!~/^\/adm\/.*\/(smppg|bulletinboard|aboutme)(\?|$)/)) {
                my $escreload=&escape('return:');
                $reloadlink=(<<ENDRELOAD);
<a href="/adm/flip?postdata=$escreload" target="_top">$lt{'ret'}</a>
ENDRELOAD
            }
	    if (&Apache::lonnet::allowed('mdc',$env{'request.course.id'})) {
               $docs=(<<ENDDOCS);
<a href="/adm/coursedocs" target="_top">$lt{'docs'}</a>
ENDDOCS
            }
            if ($showgroups) {
                $groups =(<<ENDGROUPS);
<a href="/adm/coursegroups" target="_top">$lt{'groups'}</a>
ENDGROUPS
            }
	}
        my $form=&serverform();
        my $utility=&utilityfunctions();
	my $output=(<<ENDMAINMENU);
<script type="text/javascript">
// BEGIN LON-CAPA Internal
$utility
</script>
<div id="LC_top_nav">
<a href="/adm/menu" target="_top">$lt{'main'}</a>
$reloadlink $navmaps $docs $groups
<a href="/adm/roles" target="_top">$lt{'roles'}</a>
<a href="/adm/logout" target="_top">$lt{'exit'}</a>
</div>
<br />
<script type="text/javascript">
// END LON-CAPA Internal
</script>
$form
ENDMAINMENU
        if ($registration) { $output.=&innerregister($forcereg); }
	return $output."<hr />";
    } elsif ($env{'environment.remote'} eq 'off') {
# Remote Control is switched off
# figure out colors
	my %lt=&initlittle();

        my $domain=&Apache::loncommon::determinedomain();
	my $function =&Apache::loncommon::get_users_function();
        my $link=&Apache::loncommon::designparm($function.'.link',$domain);
        my $alink=&Apache::loncommon::designparm($function.'.alink',$domain);
        my $vlink=&Apache::loncommon::designparm($function.'.vlink',$domain);
        my $sidebg=&Apache::loncommon::designparm($function.'.sidebg',$domain);
	if ($env{'user.name'} eq 'public' && $env{'user.domain'} eq 'public') {
	    return (<<ENDINLINEMENU);
   <table id="LC_top_nav">
    <tr>
      $logo
      <td></td>
      <td class="LC_top_nav_login">
        <a href="/adm/roles" target="_top">$lt{'login'}</a>
     </td>
    </tr>
  </table>
</font>
ENDINLINEMENU
        }
# Do we have a NAV link?
        if ($env{'request.course.id'}) {
	    my $link='/adm/navmaps?postdata='.$escurl.'&amp;postsymb='.
		$escsymb;
	    if ($env{'environment.remotenavmap'} eq 'on') {
		$link="javascript:gonav('".$link."')";
	    }
	    $navmaps=(<<ENDNAV);
<td><a href="$link" target="_top">$lt{'nav'}</a></td>
ENDNAV
my $is_group = (&Apache::loncommon::course_type() eq 'Group');
	    if (&Apache::lonnet::allowed('mdc',$env{'request.course.id'})) {
                my $text = ($is_group) ? $lt{'gdoc'} : $lt{'docs'};
		$docs=(<<ENDDOCS);
<td><a href="/adm/coursedocs" target="_top">$text</a></td>
ENDDOCS
            }
            if ($showgroups) {
                $groups =(<<ENDGROUPS);
<td><a href="/adm/coursegroups" target="_top">$lt{'groups'}</a></td>
ENDGROUPS
            }
	    if (
		($env{'request.noversionuri'}=~m[^/(res|public)/] &&
		 $env{'request.symb'} eq '')
		||
		(($env{'request.noversionuri'}=~/^\/adm\//) &&
		 ($env{'request.noversionuri'}!~/^\/adm\/wrapper\//) &&
		 ($env{'request.noversionuri'}!~
		        m[^/adm/.*/(smppg|bulletinboard|aboutme)($|\?)])
		  )
		 ) {
                my $escreload=&escape('return:');
                $reloadlink=(<<ENDRELOAD);
<td><a href="/adm/flip?postdata=$escreload" target="_top">$lt{'ret'}</a></td>
ENDRELOAD
            }
        }
	if (($env{'request.state'} eq 'construct') && ($env{'request.course.id'})) {
	    my $escreload=&escape('return:');
	    $reloadlink=(<<ENDCRELOAD);
<td><a href="/adm/flip?postdata=$escreload" target="_top">$lt{'ret'}</a></td>
ENDCRELOAD
        }
        my $reg='';
        if ($registration) {
           $reg=&innerregister($forcereg,$titletable);
        }
        my $form=&serverform();
	my $utility=&utilityfunctions();
	my $remote;
	if ($env{'user.adv'}) {
	    $remote = '<td><a href="/adm/remote?action=launch&amp;url='.$escurl.'" target="_top">'.$lt{'launch'}.'</a></td>'
	}

        my $helplink=&Apache::loncommon::top_nav_help('Help');
	return (<<ENDINLINEMENU);
<script type="text/javascript">
// BEGIN LON-CAPA Internal
// <![CDATA[
$utility
// ]]>
</script>
<table id="LC_top_nav">
<tr>
$logo
<td><a href="/adm/menu" target="_top">$lt{'main'}</a></td>
$reloadlink
$navmaps
$docs
$groups
$remote
<td><a href="/adm/roles" target="_top">$lt{'roles'}</a></td>
<td class="LC_top_nav_help">$helplink</td>
<td class="LC_top_nav_exit"><a href="/adm/logout" target="_top">$lt{'exit'}</a></td>
</tr>
</table>
$form
<script type="text/javascript">
// END LON-CAPA Internal
</script>
$reg
ENDINLINEMENU
    } else {
	return '';
    }
}

# ====================================== This gets called in the header section

sub registerurl {
    my ($forcereg) = @_;
    my $result = '';
    if ($env{'request.noversionuri'} =~ m{^/res/adm/pages/}) { return ''; }
    my $force_title='';
    if ($env{'request.state'} eq 'construct') {
	$force_title=&Apache::lonxml::display_title();
    }
    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off') ||
        ((($env{'request.publicaccess'}) || 
         (!&Apache::lonnet::is_on_map(
	   &unescape($env{'request.noversionuri'})))) &&
        (!$forcereg))) {
 	return $result.
          '<script type="text/javascript">function LONCAPAreg(){;} function LONCAPAstale(){}</script>'.$force_title;
    }
# Graphical display after login only
    if ($env{'request.registered'} && !$forcereg) { return ''; }
    $result.=&innerregister($forcereg);
    return $result.$force_title;
}

# =========== This gets called in order to register a URL, both with the Remote
# =========== and in the body of the document

sub innerregister {
    my ($forcereg, $titletable) = @_;
    my $result = '';
    my ($uname,$thisdisfn);
    my $const_space = ($env{'request.state'} eq 'construct');
    my $is_const_dir = 0;

    if ($env{'request.noversionuri'} =~ m{^/res/adm/pages/}) { return ''; }

    $env{'request.registered'} = 1;

    my $textinter=($env{'browser.interface'} eq 'textual');
    my $noremote=($env{'environment.remote'} eq 'off');
    
    my $textual=($textinter || $noremote);

    undef(@inlineremote);

    my $reopen=&Apache::lonmenu::reopenmenu();

    my $newmail='';
    if ($noremote) {
	$newmail='<table id="LC_nav_location"><tr>';
    }
    if (&Apache::lonmsg::newmail()) { 
	if ($textual) {
	    $newmail.= '<td class="LC_new_mail">
                   <a href="/adm/communicate" target="_top">'.
		   &mt('You have new messages').'</a></td>';
	} else {
	    $newmail= 'swmenu.setstatus("you have","messages");';
	}
    } elsif (($textual) 
	     && ($env{'request.symb'}) 
	     && ($env{'request.course.id'})) {
	$newmail.= '<td class="LC_current_location">';
	my ($mapurl,$rid,$resurl)=
	    &Apache::lonnet::decode_symb(&Apache::lonnet::symbread());
        $newmail.=$env{'course.'.$env{'request.course.id'}.'.description'};
        my $maptitle=&Apache::lonnet::gettitle($mapurl);
	my $restitle=&Apache::lonnet::gettitle(&Apache::lonnet::symbread());
        if ($maptitle && $maptitle ne 'default.sequence') {
	    $newmail.=', '.$maptitle;
        }
        if ($restitle) {
	    $newmail.=': '.$restitle;
        }
        $newmail.='&nbsp;&nbsp;&nbsp;</td>';
    }
    if ($env{'request.state'} eq 'construct') {
        $newmail = $titletable;
    } else {
	if ($noremote) {
	    $newmail.='</tr></table>';
	}
    }
    my $timesync=($textual?'':'swmenu.syncclock(1000*'.time.');');
    my $tablestart=($noremote?'<table id="LC_menubuttons">':'').
	($textinter?'<br /><a href="#content">'.&mt('Skip to Content').'</a><br />':'');
    my $tableend=($noremote?'</table>':'').($textinter?'<a name="content" />':'');
# =============================================================================
# ============================ This is for URLs that actually can be registered
    if (($env{'request.noversionuri'}!~m|^/(res/)*adm/|) || ($forcereg)) {
# -- This applies to homework problems for users with grading privileges
	my $crs='/'.$env{'request.course.id'};
	if ($env{'request.course.sec'}) {
	    $crs.='_'.$env{'request.course.sec'};
	}
	$crs=~s/\_/\//g;

        my $hwkadd='';
        if ($env{'request.symb'} ne '' &&
	    $env{'request.filename'}=~/\.(problem|exam|quiz|assess|survey|form|task)$/) {
	    if (&Apache::lonnet::allowed('mgr',$crs)) {
		$hwkadd.=&switch('','',7,2,'pgrd.gif','problem[_1]','grades[_3]',
                       "gocmd('/adm/grades','gradingmenu')",
                       'Modify user grades for this assessment resource');
            } elsif (&Apache::lonnet::allowed('vgr',$crs)) {
		$hwkadd.=&switch('','',7,2,'subm.gif','view sub-[_1]','missions[_1]',
                       "gocmd('/adm/grades','submission')",
		       'View user submissions for this assessment resource');
            }
	}
	if ($env{'request.symb'} ne '' &&
	    &Apache::lonnet::allowed('opa',$crs)) {
	    $hwkadd.=&switch('','',7,3,'pparm.gif','problem[_2]','parms[_2]',
			     "gocmd('/adm/parmset','set')",
			     'Modify parameter settings for this resource');
	}
# -- End Homework
        ###
        ### Determine whether or not to display the 'cstr' button for this
        ### resource
        ###
        my $editbutton = '';
        if ($env{'user.author'}) {
            if ($env{'request.role'}=~/^(ca|au)/) {
                # Set defaults for authors
                my ($top,$bottom) = ('con-','struct');
                my $action = "go('/priv/".$env{'user.name'}."');";
                my $cadom  = $env{'request.role.domain'};
                my $caname = $env{'user.name'};
                my $desc = "Enter my resource construction space";
                # Set defaults for co-authors
                if ($env{'request.role'} =~ /^ca/) { 
                    ($cadom,$caname)=($env{'request.role'}=~/($match_domain)\/($match_username)$/);
                    ($top,$bottom) = ('co con-','struct');
                    $action = "go('/priv/".$caname."');";
                    $desc = "Enter construction space as co-author";
                }
                # Check that we are on the correct machine
                my $home = &Apache::lonnet::homeserver($caname,$cadom);
		my $allowed=0;
		my @ids=&Apache::lonnet::current_machine_ids();
		foreach my $id (@ids) { if ($id eq $home) { $allowed=1; } }
		if (!$allowed) {
		    $editbutton=&switch('','',6,1,$top,,$bottom,$action,$desc);
                }
            }
            ##
            ## Determine if user can edit url.
            ##
            my $cfile='';
            my $cfuname='';
            my $cfudom='';
            if ($env{'request.filename'}) {
                my $file=&Apache::lonnet::declutter($env{'request.filename'});
                $file=~s/^($match_domain)\/($match_username)/\/priv\/$2/;
                # Check that the user has permission to edit this resource
                ($cfuname,$cfudom)=&Apache::loncacc::constructaccess($file,$1);
                if (defined($cfudom)) {
		    my $home=&Apache::lonnet::homeserver($cfuname,$cfudom);
		    my $allowed=0;
		    my @ids=&Apache::lonnet::current_machine_ids();
		    foreach my $id (@ids) { if ($id eq $home) { $allowed=1; } }
		    if ($allowed) {
                        $cfile=$file;
                    }
                }
            }        
            # Finally, turn the button on or off
            if ($cfile && !$const_space) {
                $editbutton=&switch
                    ('','',6,1,'cstr.gif','edit[_1]','resource[_2]',
                     "go('".$cfile."');","Edit this resource");
            } elsif ($editbutton eq '') {
                $editbutton=&clear(6,1);
            }
        }
        ###
        ###
# Prepare the rest of the buttons
        my $menuitems;
        if ($const_space) {
	    my ($uname,$thisdisfn) =
		($env{'request.filename'}=~m|^/home/([^/]+)/public_html/(.*)|);
            my $currdir = '/priv/'.$uname.'/'.$thisdisfn;
            if ($currdir =~ m-/$-) {
                $is_const_dir = 1;
            } else {
                $currdir =~ s#[^/]+$##;
		my $cleandisfn = &Apache::loncommon::escape_single($thisdisfn);
                $menuitems=(<<ENDMENUITEMS);
s&6&1&list.gif&list[_1]&dir[_1]&golist('$currdir')&List current directory
s&6&2&rtrv.gif&retrieve[_1]&version[_1]&gocstr('/adm/retrieve','/~$uname/$cleandisfn')&Retrieve old version
s&6&3&pub.gif&publish[_1]&resource[_1]&gocstr('/adm/publish','/~$uname/$cleandisfn')&Publish this resource
s&7&1&del.gif&delete[_1]&resource[_2]&gocstr('/adm/cfile?action=delete','/~$uname/$cleandisfn')&Delete this resource
s&7&2&prt.gif&prepare[_1]&printout[_1]&gocstr('/adm/printout','/~$uname/$cleandisfn')&Prepare a printable document
ENDMENUITEMS
            }
        } elsif ( defined($env{'request.course.id'}) && 
		 $env{'request.symb'} ne '' ) {
	    $menuitems=(<<ENDMENUITEMS);
c&3&1
s&2&1&back.gif&backward[_1]&&gopost('/adm/flip','back:'+currentURL)&Go to the previous resource in the course sequence&1
s&2&3&forw.gif&forward[_1]&&gopost('/adm/flip','forward:'+currentURL)&Go to the next resource in the course sequence&3
c&6&3
c&8&1
c&8&2
s&8&3&prt.gif&prepare[_1]&printout[_1]&gopost('/adm/printout',currentURL)&Prepare a printable document
s&9&1&sbkm.gif&set[_1]&bookmark[_2]&set_bookmark()&Set a bookmark for this resource&1
s&9&3&anot.gif&anno-[_1]&tations[_1]&annotate()&Make notes and annotations about this resource&1
ENDMENUITEMS
            unless ($env{'request.noversionuri'}=~/\/(bulletinboard|smppg|navmaps|syllabus|aboutme)(\?|$)/) {
	        $menuitems.=(<<ENDREALRES);
s&6&3&catalog.gif&catalog[_1]&info[_1]&catalog_info()&Show catalog information
s&8&1&eval.gif&evaluate[_1]&this[_1]&gopost('/adm/evaluate',currentURL,1)&Provide my evaluation of this resource
s&8&2&fdbk.gif&feedback[_1]&discuss[_1]&gopost('/adm/feedback',currentURL,1)&Provide feedback messages or contribute to the course discussion about this resource
ENDREALRES
	    }
        }
	if ($env{'request.uri'} =~ /^\/res/) {
	    $menuitems .= (<<ENDMENUITEMS);
s&8&3&prt.gif&prepare[_1]&printout[_1]&gopost('/adm/printout',currentURL)&Prepare a printable document
ENDMENUITEMS
	}
        my $buttons='';
        foreach (split(/\n/,$menuitems)) {
	    my ($command,@rest)=split(/\&/,$_);
            if ($command eq 's') {
		$buttons.=&switch('','',@rest);
            } else {
                $buttons.=&clear(@rest);
            }
        }

        if ($textual) {
	    my $addremote=0;
	    foreach (@inlineremote) { if ($_ ne '') { $addremote=1; } }
	    my $inlinebuttons='';
	    if ($addremote) {
# Registered, textual output

		if ($env{'browser.interface'} eq 'textual') {
		    $inlinebuttons=
                        join('',map { (defined($_)?$_:'') } @inlineremote);
		} else {
		    $inlinebuttons=(<<ENDINLINE);
<tr><td>$inlineremote[21]</td><td>&nbsp;</td><td>$inlineremote[23]</td></tr>
<tr><td>$inlineremote[61]</td><td>$inlineremote[62]</td><td>$inlineremote[63]</td></tr>
<tr><td>$inlineremote[71]</td><td>$inlineremote[72]</td><td>$inlineremote[73]</td></tr>
<tr><td>$inlineremote[81]</td><td>$inlineremote[82]</td><td>$inlineremote[83]</td></tr>
<tr><td>$inlineremote[91]</td><td>$inlineremote[92]</td><td>$inlineremote[93]</td></tr>
ENDINLINE
                }
	    }
	    $result =(<<ENDREGTEXT);
<script type="text/javascript">
// BEGIN LON-CAPA Internal
</script>
$timesync
$newmail
$tablestart
$inlinebuttons
$tableend
<script type="text/javascript">
// END LON-CAPA Internal
</script>

ENDREGTEXT
# Registered, graphical output
        } else {
	    my $requri=&Apache::lonnet::clutter(&Apache::lonnet::fixversion((split(/\?/,$env{'request.noversionuri'}))[0]));
	    $requri=&Apache::lonenc::check_encrypt(&unescape($requri));
	    my $cursymb=&Apache::lonenc::check_encrypt($env{'request.symb'});
	    my $navstatus=&get_nav_status();
	    my $clearcstr;

	    if ($env{'user.adv'}) { $clearcstr='clearbut(6,1)'; }
	    $result = (<<ENDREGTHIS);
     
<script type="text/javascript">
// BEGIN LON-CAPA Internal
var swmenu=null;

    function LONCAPAreg() {
	  swmenu=$reopen;
          swmenu.clearTimeout(swmenu.menucltim);
          $timesync
          $newmail
          $buttons
	  swmenu.currentURL="$requri";
          swmenu.reloadURL=swmenu.currentURL+window.location.search;
          swmenu.currentSymb="$cursymb";
          swmenu.reloadSymb="$cursymb";
          swmenu.currentStale=0;
	  $navstatus
          $hwkadd
          $editbutton
    }

    function LONCAPAstale() {
	  swmenu=$reopen
          swmenu.currentStale=1;
          if (swmenu.reloadURL!='' && swmenu.reloadURL!= null) { 
             swmenu.switchbutton
             (3,1,'reload.gif','return','location','go(reloadURL)','Return to the last known location in the course sequence');
	  }
          swmenu.clearbut(7,2);
          swmenu.clearbut(7,3);
          swmenu.menucltim=swmenu.setTimeout(
 'clearbut(2,1);clearbut(2,3);clearbut(8,1);clearbut(8,2);clearbut(8,3);'+
 'clearbut(9,1);clearbut(9,3);clearbut(6,3);$clearcstr',
			  2000);
      }

// END LON-CAPA Internal 
</script>
ENDREGTHIS
        }
# =============================================================================
    } else {
# ========================================== This can or will not be registered
        if ($textual) {
# Not registered, textual
	    $result= (<<ENDDONOTREGTEXT);
ENDDONOTREGTEXT
        } else {
# Not registered, graphical
           $result = (<<ENDDONOTREGTHIS);

<script type="text/javascript">
// BEGIN LON-CAPA Internal
var swmenu=null;

    function LONCAPAreg() {
	  swmenu=$reopen
          $timesync
          swmenu.currentStale=1;
          swmenu.clearbut(2,1);
          swmenu.clearbut(2,3);
          swmenu.clearbut(8,1);
          swmenu.clearbut(8,2);
          swmenu.clearbut(8,3);
          if (swmenu.currentURL) {
             swmenu.switchbutton
              (3,1,'reload.gif','return','location','go(currentURL)');
 	  } else {
	      swmenu.clearbut(3,1);
          }
    }

    function LONCAPAstale() {
    }

// END LON-CAPA Internal
</script>
ENDDONOTREGTHIS
       }
# =============================================================================
    }
    return $result;
}

sub loadevents() {
    if ($env{'request.state'} eq 'construct' ||
	$env{'request.noversionuri'} =~ m{^/res/adm/pages/}) { return ''; }
    return 'LONCAPAreg();';
}

sub unloadevents() {
    if ($env{'request.state'} eq 'construct' ||
	$env{'request.noversionuri'} =~ m{^/res/adm/pages/}) { return ''; }
    return 'LONCAPAstale();';
}

# ============================================================= Start up remote

sub startupremote {
    my ($lowerurl)=@_;
    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off')) {
     return ('<meta HTTP-EQUIV="Refresh" CONTENT="0.5; url='.$lowerurl.'" />');
    }
#
# The Remote actually gets launched!
#
    my $configmenu=&rawconfig();
    my $esclowerurl=&escape($lowerurl);
    my $message=&mt('"Waiting for Remote Control window to load: "+[_1]','waited');
    return(<<ENDREMOTESTARTUP);
<script type="text/javascript">
var timestart;
function wheelswitch() {
    if (typeof(document.wheel) != 'undefined') {
	if (typeof(document.wheel.spin) != 'undefined') {
	    var date=new Date();
	    var waited=Math.round(30-((date.getTime()-timestart)/1000));
	    document.wheel.spin.value=$message;
	}
    }
   if (window.status=='|') { 
      window.status='/'; 
   } else {
      if (window.status=='/') {
         window.status='-';
      } else {
         if (window.status=='-') { 
            window.status='\\\\'; 
         } else {
            if (window.status=='\\\\') { window.status='|'; }
         }
      }
   } 
}

// ---------------------------------------------------------- The wait function
var canceltim;
function wait() {
   if ((menuloaded==1) || (tim==1)) {
      window.status='Done.';
      if (tim==0) {
         clearTimeout(canceltim);
         $configmenu
         window.location='$lowerurl';  
      } else {
	  window.location='/adm/remote?action=collapse&url=$esclowerurl';
      }
   } else {
      wheelswitch();
      setTimeout('wait();',200);
   }
}

function main() {
   canceltim=setTimeout('tim=1;',30000);
   window.status='-';
   var date=new Date();
   timestart=date.getTime();
   wait();
}

</script>
ENDREMOTESTARTUP
}

sub setflags() {
    return(<<ENDSETFLAGS);
<script type="text/javascript">
    menuloaded=0;
    tim=0;
</script>
ENDSETFLAGS
}

sub maincall() {
    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off')) { return ''; }
    return(<<ENDMAINCALL);
<script type="text/javascript">
    main();
</script>
ENDMAINCALL
}

sub load_remote_msg {
    my ($lowerurl)=@_;

    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off')) { return ''; }

    my $esclowerurl=&escape($lowerurl);
    my $link=&mt('<a href="[_1]">Continue</a> on in Inline Menu mode',
		 "/adm/remote?action=collapse&amp;url=$esclowerurl");
    return(<<ENDREMOTEFORM);
<p>
<form name="wheel">
<input name="spin" type="text" size="60" />
</form>
</p>
<p>$link</p>
ENDREMOTEFORM
}
# ================================================================= Reopen menu

sub reopenmenu {
   if (($env{'browser.interface'} eq 'textual') ||
       ($env{'environment.remote'} eq 'off')) { return ''; }
   my $menuname='LCmenu'.$Apache::lonnet::perlvar{'lonHostID'};
   my $nothing = &Apache::lonhtmlcommon::javascript_nothing();
   return('window.open('.$nothing.',"'.$menuname.'","",false);');
} 

# =============================================================== Open the menu

sub open {
    my $returnval='';
    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off')) { 
	return '<script type="text/javascript">self.name="loncapaclient";</script>';
    }
    my $menuname='LCmenu'.$Apache::lonnet::perlvar{'lonHostID'};
    unless (shift eq 'unix') {
# resizing does not work on linux because of virtual desktop sizes
       $returnval.=(<<ENDRESIZE);
if (window.screen) {
    self.resizeTo(screen.availWidth-215,screen.availHeight-55);
    self.moveTo(190,15);
}
ENDRESIZE
    }
    $returnval.=(<<ENDOPEN);
window.status='Opening LON-CAPA Remote Control';
var menu=window.open("/res/adm/pages/menu.html","$menuname",
"height=375,width=150,scrollbars=no,menubar=no,top=5,left=5,screenX=5,screenY=5");
self.name='loncapaclient';
ENDOPEN
    return '<script type="text/javascript">'.$returnval.'</script>';
}


# ================================================================== Raw Config

sub clear {
    my ($row,$col)=@_;
    unless (($env{'browser.interface'} eq 'textual') ||
            ($env{'environment.remote'} eq 'off')) {
       return "\n".qq(window.status+='.';swmenu.clearbut($row,$col););
   } else { 
       $inlineremote[10*$row+$col]='';
       return ''; 
   }
}

# ============================================ Switch a button or create a link
# Switch acts on the javascript that is executed when a button is clicked.  
# The javascript is usually similar to "go('/adm/roles')" or "cstrgo(..)".

sub switch {
    my ($uname,$udom,$row,$col,$img,$top,$bot,$act,$desc,$nobreak)=@_;
    $act=~s/\$uname/$uname/g;
    $act=~s/\$udom/$udom/g;
    $top=&mt($top);
    $bot=&mt($bot);
    $desc=&mt($desc);
    $img=&mt($img);

    unless (($env{'browser.interface'} eq 'textual')  ||
            ($env{'environment.remote'} eq 'off')) {
# Remote
       return "\n".
 qq(window.status+='.';swmenu.switchbutton($row,$col,"$img","$top","$bot","$act","$desc"););
   } elsif ($env{'browser.interface'} eq 'textual') {
# Accessibility
       if ($nobreak==2) { return ''; }
       my $text=$top.' '.$bot;
       $text=~s/\s*\-\s*//gs;
       if ($nobreak) {
	   $inlineremote[10*$row+$col]=
	       '<a href="javascript:'.$act.';">'.$text.'</a>';
       } else {
	   $inlineremote[10*$row+$col]="\n<br />".
	       $desc.' <a href="javascript:'.$act.';">'.$text.'</a>';
       }
   } else {
# Inline Remote
       if ($nobreak==2) { return ''; }
       my $text=$top.' '.$bot;
       $text=~s/\s*\-\s*//gs;

       my $lonhttpdPort=$Apache::lonnet::perlvar{'lonhttpdPort'};
       if (!defined($lonhttpdPort)) { $lonhttpdPort='8080'; }
       my $pic=
	   '<img alt="'.$text.'" src="http://'.$ENV{'HTTP_HOST'}.
	   ':'.$lonhttpdPort.'/res/adm/pages/'.$img.'" align="'.
	   ($nobreak==3?'right':'left').'" />';
       if ($env{'browser.interface'} eq 'faketextual') {
# Accessibility
	   if ($nobreak==3) {
	       $inlineremote[10*$row+$col]="\n".
		   '<td class="LC_menubuttons_text" align="right">'.$text.
		   '</td><td class="LC_menubuttons_img" align="left">'.
		   '<a href="javascript:'.$act.';">'.$pic.'</a></td></tr>';
	   } elsif ($nobreak) {
	       $inlineremote[10*$row+$col]="\n<tr>".
		   '<td class="LC_menubuttons_img" align="left">'.
		   '<a href="javascript:'.$act.';">'.$pic.'</a></td>
                    <td class="LC_menubuttons_text" align="left">'.$text.'</td>';
	   } else {
	       $inlineremote[10*$row+$col]="\n<tr>".
		   '<td class="LC_menubuttons_img" align="left">'.
		   '<a href="javascript:'.$act.';">'.$pic.
		   '</a></td><td class="LC_menubuttons_text" colspan="3">'.
		   $desc.'</td></tr>';
	   }
       } else {
# Inline Menu
	   $inlineremote[10*$row+$col]=
		   '<a href="javascript:'.$act.';">'.$pic.
		   '</a><span class="LC_menubuttons_inline_text">'.$desc.'</span>';
       }
   }
    return '';
}

sub secondlevel {
    my $output='';
    my 
    ($uname,$udom,$rol,$crs,$pub,$con,$row,$col,$prt,$img,$top,$bot,$act,$desc)=@_;
    if ($prt eq 'any') {
	   $output.=switch($uname,$udom,$row,$col,$img,$top,$bot,$act,$desc);
    } elsif ($prt=~/^r(\w+)/) {
        if ($rol eq $1) {
           $output.=switch($uname,$udom,$row,$col,$img,$top,$bot,$act,$desc);
        }
    }
    return $output;
}

sub openmenu {
    my $menuname='LCmenu'.$Apache::lonnet::perlvar{'lonHostID'};
    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off')) { return ''; }
    my $nothing = &Apache::lonhtmlcommon::javascript_nothing();
    return "window.open(".$nothing.",'".$menuname."');";
}

sub inlinemenu {
    @inlineremote=();
    undef @inlineremote;
    &rawconfig(1);
    return join('',map { (defined($_)?$_:'') } @inlineremote);
}

sub rawconfig {
    my $textualoverride=shift;
    my $output='';
    unless (($env{'browser.interface'} eq 'textual') ||
            ($env{'environment.remote'} eq 'off')) {
       $output.=
 "window.status='Opening Remote Control';var swmenu=".&openmenu().
"\nwindow.status='Configuring Remote Control ';";
    } else {
       unless ($textualoverride) { return ''; }
    }
    my $uname=$env{'user.name'};
    my $udom=$env{'user.domain'};
    my $adv=$env{'user.adv'};
    my $author=$env{'user.author'};
    my $crs='';
    if ($env{'request.course.id'}) {
       $crs='/'.$env{'request.course.id'};
       if ($env{'request.course.sec'}) {
	   $crs.='_'.$env{'request.course.sec'};
       }
       $crs=~s/\_/\//g;
    }
    my $pub=($env{'request.state'} eq 'published');
    my $con=($env{'request.state'} eq 'construct');
    my $rol=$env{'request.role'};
    my $requested_domain = $env{'request.role.domain'};
    foreach my $line (@desklines) {
        my ($row,$col,$pro,$prt,$img,$top,$bot,$act,$desc)=split(/\:/,$line);
        $prt=~s/\$uname/$uname/g;
        $prt=~s/\$udom/$udom/g;
        $prt=~s/\$crs/$crs/g; 
        $prt=~s/\$requested_domain/$requested_domain/g;
        my $type = &Apache::loncommon::course_type();
        if ($type eq 'Group') {
            $desc = &convert_menu_function($desc,$type);
        }
        if ($pro eq 'clear') {
	    $output.=&clear($row,$col);
        } elsif ($pro eq 'any') {
               $output.=&secondlevel(
	  $uname,$udom,$rol,$crs,$pub,$con,$row,$col,$prt,$img,$top,$bot,$act,$desc);
	} elsif ($pro eq 'smp') {
            unless ($adv) {
               $output.=&secondlevel(
          $uname,$udom,$rol,$crs,$pub,$con,$row,$col,$prt,$img,$top,$bot,$act,$desc);
            }
        } elsif ($pro eq 'adv') {
            if ($adv) {
               $output.=&secondlevel(
	  $uname,$udom,$rol,$crs,$pub,$con,$row,$col,$prt,$img,$top,$bot,$act,$desc);
            }
        } elsif (($pro=~/^p(\w+)/) && ($prt)) {
	    if (&Apache::lonnet::allowed($1,$prt)) {
               $output.=switch($uname,$udom,$row,$col,$img,$top,$bot,$act,$desc);
            }
        } elsif ($pro eq 'course') {
            if ($env{'request.course.fn'}) {
               $output.=switch($uname,$udom,$row,$col,$img,$top,$bot,$act,$desc);
	    }
        } elsif ($pro =~ /^courseenv_(.*)$/) {
            my $key = $1;
            if ($env{'course.'.$env{'request.course.id'}.'.'.$key}) {
                $output.=switch($uname,$udom,$row,$col,$img,$top,$bot,$act,$desc);
            }
        } elsif ($pro =~ /^course_(.*)$/) {
            # Check for permissions inside of a course
            if (($env{'request.course.id'}) &&
                (&Apache::lonnet::allowed($1,$env{'request.course.id'}.
            ($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''))
                 )) {
                $output.=switch($uname,$udom,$row,$col,$img,$top,$bot,$act,$desc);
	    }
        } elsif ($pro eq 'author') {
            if ($author) {
                if ((($prt eq 'rca') && ($env{'request.role'}=~/^ca/)) ||
                    (($prt eq 'rau') && ($env{'request.role'}=~/^au/))) {
                    # Check that we are on the correct machine
                    my $cadom=$requested_domain;
                    my $caname=$env{'user.name'};
                    if ($prt eq 'rca') {
		       ($cadom,$caname)=
                               ($env{'request.role'}=~/($match_domain)\/($match_username)$/);
                    }                       
                    $act =~ s/\$caname/$caname/g;
                    my $home = &Apache::lonnet::homeserver($caname,$cadom);
		    my $allowed=0;
		    my @ids=&Apache::lonnet::current_machine_ids();
		    foreach my $id (@ids) { if ($id eq $home) { $allowed=1; } }
		    if ($allowed) {
                        $output.=switch($caname,$cadom,
                                        $row,$col,$img,$top,$bot,$act,$desc);
                    }
                }
            }
        }
    }
    unless (($env{'browser.interface'} eq 'textual') ||
            ($env{'environment.remote'} eq 'off')) {
       $output.="\nwindow.status='Synchronizing Time';swmenu.syncclock(1000*".time.");\nwindow.status='Remote Control Configured.';";
       if (&Apache::lonmsg::newmail()) { 
	   $output.='swmenu.setstatus("you have","messages");';
       }
    }

    return $output;
}

# ======================================================================= Close

sub close {
    if (($env{'browser.interface'} eq 'textual') ||
        ($env{'environment.remote'} eq 'off')) { return ''; }
    my $menuname='LCmenu'.$Apache::lonnet::perlvar{'lonHostID'};
    return(<<ENDCLOSE);
<script type="text/javascript">
window.status='Accessing Remote Control';
menu=window.open("/adm/rat/empty.html","$menuname",
                 "height=350,width=150,scrollbars=no,menubar=no");
window.status='Disabling Remote Control';
menu.active=0;
menu.autologout=0;
window.status='Closing Remote Control';
menu.close();
window.status='Done.';
</script>
ENDCLOSE
}

# ====================================================================== Footer

sub footer {

}

sub nav_control_js {
    my $nav=($env{'environment.remotenavmap'} eq 'on');
    return (<<NAVCONTROL);
    var w_loncapanav_flag="$nav";


function gonav(url) {
   if (w_loncapanav_flag != 1) {
      gopost(url,'');
   }  else {
      navwindow=window.open(url,
                  "loncapanav","height=600,width=400,scrollbars=1"); 
   }
}
NAVCONTROL
}

sub utilityfunctions {
    my $caller = shift;
    unless (($env{'browser.interface'} eq 'textual')  ||
        ($env{'environment.remote'} eq 'off') || ($caller eq '/adm/menu')) { return ''; }
    my $currenturl=&Apache::lonnet::clutter(&Apache::lonnet::fixversion((split(/\?/,$env{'request.noversionuri'}))[0]));
    $currenturl=&Apache::lonenc::check_encrypt(&unescape($currenturl));
    
    my $currentsymb=&Apache::lonenc::check_encrypt($env{'request.symb'});
    my $nav_control=&nav_control_js();

    my $start_page_annotate = 
        &Apache::loncommon::start_page('Annotator',undef,
				       {'only_body' => 1,
					'js_ready'  => 1,
					'bgcolor'   => '#BBBBBB',
					'add_entries' => {
					    'onload' => 'javascript:document.goannotate.submit();'}});

    my $end_page_annotate = 
        &Apache::loncommon::end_page({'js_ready' => 1});

    my $start_page_bookmark = 
        &Apache::loncommon::start_page('Bookmarks',undef,
				       {'only_body' => 1,
					'js_ready'  => 1,
					'bgcolor'   => '#BBBBBB',});

    my $end_page_bookmark = 
        &Apache::loncommon::end_page({'js_ready' => 1});

return (<<ENDUTILITY)

    var currentURL="$currenturl";
    var reloadURL="$currenturl";
    var currentSymb="$currentsymb";

$nav_control

function go(url) {
   if (url!='' && url!= null) {
       currentURL = null;
       currentSymb= null;
       window.location.href=url;
   }
}

function gopost(url,postdata) {
   if (url!='') {
      this.document.server.action=url;
      this.document.server.postdata.value=postdata;
      this.document.server.command.value='';
      this.document.server.url.value='';
      this.document.server.symb.value='';
      this.document.server.submit();
   }
}

function gocmd(url,cmd) {
   if (url!='') {
      this.document.server.action=url;
      this.document.server.postdata.value='';
      this.document.server.command.value=cmd;
      this.document.server.url.value=currentURL;
      this.document.server.symb.value=currentSymb;
      this.document.server.submit();
   }
}

function gocstr(url,filename) {
    if (url == '/adm/cfile?action=delete') {
        this.document.cstrdelete.filename.value = filename
        this.document.cstrdelete.submit();
        return;
    }
    if (url == '/adm/printout') {
        this.document.cstrprint.postdata.value = filename
        this.document.cstrprint.curseed.value = 0;
        this.document.cstrprint.problemtype.value = 0;
        if (this.document.lonhomework) {
            if ((this.document.lonhomework.rndseed) && (this.document.lonhomework.rndseed.value != null) && (this.document.lonhomework.rndseed.value != '')) {
                this.document.cstrprint.curseed.value = this.document.lonhomework.rndseed.value
            }
            if (this.document.lonhomework.problemtype) {
		if (this.document.lonhomework.problemtype.value) {
		    this.document.cstrprint.problemtype.value = 
			this.document.lonhomework.problemtype.value;
		} else if (this.document.lonhomework.problemtype.options) {
		    for (var i=0; i<this.document.lonhomework.problemtype.options.length; i++) {
			if (this.document.lonhomework.problemtype.options[i].selected) {
			    if (this.document.lonhomework.problemtype.options[i].value != null && this.document.lonhomework.problemtype.options[i].value != '') { 
				this.document.cstrprint.problemtype.value = this.document.lonhomework.problemtype.options[i].value
				}
			}
		    }
		}
	    }
	}
        this.document.cstrprint.submit();
        return;
    }
    if (url !='') {
        this.document.constspace.filename.value = filename;
        this.document.constspace.action = url;
        this.document.constspace.submit();
    }
}

function golist(url) {
   if (url!='' && url!= null) {
       currentURL = null;
       currentSymb= null;
       top.location.href=url;
   }
}



function catalog_info() {
   loncatinfo=window.open(window.location.pathname+'.meta',"LONcatInfo",'height=320,width=280,resizable=yes,scrollbars=yes,location=no,menubar=no,toolbar=no');
}

function chat_win() {
   lonchat=window.open('/res/adm/pages/chatroom.html',"LONchat",'height=320,width=280,resizable=yes,location=no,menubar=no,toolbar=no');
}

function group_chat(group) {
   var url = '/adm/groupchat?group='+group;
   var winName = 'LONchat_'+group;
   grpchat=window.open(url,winName,'height=320,width=280,resizable=yes,location=no,menubar=no,toolbar=no');
}

function edit_bookmarks() {
   go('');
   w_BookmarkPal_flag=1;
   bookmarkpal=window.open("/adm/bookmarks",
               "BookmarkPal", "width=400,height=505,scrollbars=0");
}

function annotate() {
   w_Annotator_flag=1;
   annotator=window.open('','Annotator','width=365,height=265,scrollbars=0');
   annotator.document.write(
   '$start_page_annotate'
  +"<form name='goannotate' target='Annotator' method='post' "
  +"action='/adm/annotations'>"
  +"<input type='hidden' name='urlnew' value='"+currentURL+"' />"
  +"<\\/form>"
  +'$end_page_annotate');
   annotator.document.close();
}

function set_bookmark() {
   go('');
   clienttitle=document.title;
   clienthref=location.pathname;
   w_bmquery_flag=1;
   bmquery=window.open('','bmquery','width=365,height=165,scrollbars=0');
   bmquery.document.write(
   '$start_page_bookmark'
   +"<center><form method='post'"
   +" name='newlink' action='/adm/bookmarks' target='bmquery' "
   +">\\n <table width=340 height=150 "
   +"bgcolor='ffffff' align=center><tr><td>Link Name:<br /><input "
   +"type='text' name='title' size=45 value='"+clienttitle+"' />"
   +"<br />Address:<br /><input type='text' name='address' size='45' "
   +"value='"+clienthref+"' /><br /><center><input type='submit' "
   +"value='Save' /> <input type='button' value='Close (no save)' "
   +"onclick='javascript:window.close();' /><\\/center><\\/td>"
   +"<\\/tr><\\/table><\\/form><\\/center>"
   +'$end_page_bookmark' );
   bmquery.document.close();
}

ENDUTILITY
}

sub serverform {
    return(<<ENDSERVERFORM);
<form name="server" action="/adm/logout" method="post" target="_top">
<input type="hidden" name="postdata" value="none" />
<input type="hidden" name="command" value="none" />
<input type="hidden" name="url" value="none" />
<input type="hidden" name="symb" value="none" />
</form>
ENDSERVERFORM
}

sub constspaceform {
    return(<<ENDCONSTSPACEFORM);
<form name="constspace" action="/adm/logout" method="post" target="_top">
<input type="hidden" name="filename" value="" />
</form>
<form name="cstrdelete" action="/adm/cfile" method="post" target="_top">
<input type="hidden" name="action" value="delete" /> 
<input type="hidden" name="filename" value="" />
</form>
<form name="cstrprint" action="/adm/printout" target="_parent" method="post">
<input type="hidden" name="postdata" value="" />
<input type="hidden" name="curseed" value="" />
<input type="hidden" name="problemtype" value="" />
</form>

ENDCONSTSPACEFORM
}


sub get_nav_status {
    my $navstatus="swmenu.w_loncapanav_flag=";
    if ($env{'environment.remotenavmap'} eq 'on') {
	$navstatus.="1";
    } else {
	$navstatus.="-1";
    }
    return $navstatus;
}

#FIXME this needs to move into mydesktab and the other locations 
# the text is generated
sub convert_menu_function {
    my ($rolename,$type) = @_;
    if ($type eq 'Group') {
        $rolename =~ s/student/member/g;
        $rolename =~ s/group/team/g;
        $rolename =~ s/course/group/g;
        $rolename =~ s/Course/Group/g;
    }
    return $rolename;
}


# ================================================================ Main Program

BEGIN {
    if (! defined($readdesk)) {
	{
	    my $tabfile = $Apache::lonnet::perlvar{'lonTabDir'}.'/mydesk.tab';
	    if ( CORE::open( my $config,"<$tabfile") ) {
		while (my $configline=<$config>) {
		    $configline=(split(/\#/,$configline))[0];
		    $configline=~s/^\s+//;
		    chomp($configline);
		    if ($configline) {
			push(@desklines,$configline);
		    }
		}
		CORE::close($config);
	    }
	}
	$readdesk='done';
    }
}

1;
__END__







