# The LearningOnline Network
# URL translation for encrypted filenames
#
# $Id: lonenc.pm,v 1.18 2006/12/08 22:04:57 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonenc;

use strict;
use Apache::lonnet;
use Crypt::IDEA;
use Time::HiRes qw(gettimeofday);
use LONCAPA;
 
sub encryptseed {
    my $seed=$env{'course.'.$env{'request.course.id'}.'.internal.encseed'};
    $seed=~s/[^0-9a-f]/0/g;
    $seed.='0123456789abcdef';
    $seed=substr($seed.$seed,0,32);
    return pack("H32",$seed);
}

sub unencrypted {
    my $uri=shift;
    $uri=~s/^\/enc\/(\d+)\///;
    my $cmdlength=$1;
    # strip any added extension
    $uri=~s/\.[^.]*//;
    my $seed=&encryptseed();
    unless ($seed) {
	return '/'.$uri;
    }
    $uri=&unescape($uri);
    my $cipher=new IDEA $seed;
    my $decuri='';
    for (my $encidx=0;$encidx<length($uri);$encidx+=16) {
	$decuri.=$cipher->decrypt(
				  pack("H16",substr($uri,$encidx,16))
				  );
    }
    $env{'request.enc'}=1;
    $decuri=&remove_noise($decuri);
    return substr($decuri,0,$cmdlength);
}

# add a randomish character after every 4th caharacter
sub add_noise {
    my ($uri)=@_;
    my @noise=split(/(.)/,(&gettimeofday())[1]);
    my $noisy;
    my $i;
    foreach my $chunk (split(/(....)/,$uri)) {
	$noisy.=$chunk;
	$noisy.=$noise[($i++)%(scalar@noise)];
    }
    return $noisy;
}

# remove every fifth character
sub remove_noise {
    my ($uri)=@_;
    my $clean;
    foreach my $chunk (split(/(....)./,$uri)) { $clean.=$chunk; }
    return $clean;
}

sub encrypted {
    my ($uri,$force_enc) = @_;
    if (!$force_enc && $env{'request.role.adv'}) { return($uri); }
    my $seed=&encryptseed();
    unless ($seed) {
	return $uri;
    }
    my $cmdlength=length($uri);
    # add noise before enc so that that same url's look different
    $uri=&add_noise($uri);
    my $noiselength=length($uri);
    $uri.=time;
    my $encuri='';
    my $cipher=new IDEA $seed;
    for (my $encidx=0;$encidx<=$noiselength;$encidx+=8) {
	$encuri.=unpack("H16",
			$cipher->encrypt(substr($uri,$encidx,8)));
    }
    return '/enc/'.$cmdlength.'/'.&escape($encuri);
}

sub check_encrypt {
    my $str=shift;
    if (ref($str)) {
        if ($env{'request.enc'}) { $$str = &Apache::lonenc::encrypted($$str); }
        return;
    } else {
        if ($env{'request.enc'}) { return &Apache::lonenc::encrypted($str); }
    }
    return $str;
}

sub check_decrypt {
    my ($str)=@_;
    if (ref($str)) {
	if ($$str=~m|^/enc/|) { $$str=&Apache::lonenc::unencrypted($$str); }
	return;
    }
    if ($str=~m|^/enc/|) { return &Apache::lonenc::unencrypted($str); }
    return $str;
}

sub encrypt_ref {
    my ($token,$elements,$force_enc)=@_;
    my $html;
    if ($force_enc || $env{'request.enc'}) {
	while (my ($name,$value)= each(%{ $elements })) {
	    if (!$value) { next; }
	    my $href=&Apache::lonnet::hreflocation($Apache::lonxml::pwd[-1],$value);
	    if ($href !~ /^http:/) {
		# IE really wants an extension
		my ($extension) = ($href =~ m/(\.[^.]*)$/);
		$href = &Apache::lonenc::encrypted($href,$force_enc);
		$href .= $extension;
	    }
	    $token->[2]->{$name}=$href;
	}
	delete($token->[2]->{'encrypturl'});
	$html = &Apache::edit::rebuild_tag($token);
    } else {
	$html = $token->[4];
    }
    return $html;
}
1;
__END__







