/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Color;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    Viewer viewer;
    Graphics3D g3d;
    int[] argbsCpk;
    byte paletteDefault = 0;
    Color colorSelection = Color.orange;
    short colixSelection = (short)2;
    Color colorRubberband = Color.pink;
    short colixRubberband = (short)19;
    boolean isBondAtomColor = true;
    Color colorBond = null;
    short colixBond = 0;
    Color colorHbond = null;
    short colixHbond = 0;
    Color colorSsbond = null;
    short colixSsbond = 0;
    Color colorLabel = Color.black;
    short colixLabel = 1;
    short colixDotsConvex = 0;
    short colixDotsConcave = 0;
    short colixDotsSaddle = 0;
    Color colorDistance = Color.white;
    short colixDistance = (short)5;
    Color colorAngle = Color.white;
    short colixAngle = (short)5;
    Color colorTorsion = Color.white;
    short colixTorsion = (short)5;
    Color colorBackground = Color.white;
    short colixBackground = (short)5;
    Color colorAxes = new Color(128, 128, 0);
    short colixAxes = (short)14;
    Color colorAxesText = this.colorAxes;
    short colixAxesText = (short)14;
    Color colorVector = Color.black;
    short colixVector = 1;
    final Vector3f vAB = new Vector3f();
    final Vector3f vAC = new Vector3f();
    final Vector3f vNormal = new Vector3f();
    final Vector3f vRotated = new Vector3f();

    ColorManager(Viewer viewer, Graphics3D g3d) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.argbsCpk = JmolConstants.argbsCpk;
    }

    void setDefaultColors(String colorScheme) {
        System.out.println("setting color scheme to:" + colorScheme);
        if (colorScheme.equals("jmol")) {
            this.argbsCpk = JmolConstants.argbsCpk;
            this.viewer.setColorBackground(Color.black);
            this.viewer.setColorMeasurement(null);
            this.viewer.setColorLabel(Color.white);
            this.viewer.setShapeColorProperty(7, null);
        } else if (colorScheme.equals("rasmol")) {
            int argb = JmolConstants.argbsCpkRasmol[0] | 0xFF000000;
            this.argbsCpk = new int[JmolConstants.argbsCpk.length];
            int i = JmolConstants.argbsCpk.length;
            while (--i >= 0) {
                this.argbsCpk[i] = argb;
            }
            i = JmolConstants.argbsCpkRasmol.length;
            while (--i >= 0) {
                argb = JmolConstants.argbsCpkRasmol[i];
                int atomNo = argb >> 24;
                this.argbsCpk[atomNo] = argb |= 0xFF000000;
                this.g3d.changeColixArgb((short)atomNo, argb);
            }
            this.viewer.setColorBackground(Color.black);
            this.viewer.setColorMeasurement(Color.white);
            this.viewer.setColorLabel(null);
            this.viewer.setShapeColorProperty(7, null);
        } else {
            System.out.println("unrecognized color scheme");
            return;
        }
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)i, this.argbsCpk[i]);
        }
    }

    void setPaletteDefault(byte palette) {
        this.paletteDefault = palette;
    }

    byte getPaletteDefault() {
        return this.paletteDefault;
    }

    void setColorSelection(Color c) {
        this.colorSelection = c;
        this.colixSelection = this.g3d.getColix(c);
    }

    Color getColorSelection() {
        return this.colorSelection;
    }

    short getColixSelection() {
        return this.colixSelection;
    }

    Color getColorRubberband() {
        return this.colorRubberband;
    }

    short getColixRubberband() {
        return this.colixRubberband;
    }

    void setColorRubberband(Color color) {
        if (color == null) {
            color = Color.pink;
        }
        this.colorRubberband = color;
        this.colixRubberband = this.g3d.getColix(color);
    }

    void setIsBondAtomColor(boolean isBondAtomColor) {
        this.isBondAtomColor = isBondAtomColor;
    }

    void setColorBond(Color c) {
        this.colorBond = c;
        this.colixBond = this.g3d.getColix(c);
    }

    void setColorHbond(Color c) {
        this.colorHbond = c;
        this.colixHbond = this.g3d.getColix(c);
    }

    void setColorSsbond(Color c) {
        this.colorSsbond = c;
        this.colixSsbond = this.g3d.getColix(c);
    }

    void setColorLabel(Color color) {
        this.colorLabel = color;
        this.colixLabel = this.g3d.getColix(color);
    }

    void setColorDotsConvex(Color color) {
        this.colixDotsConvex = this.g3d.getColix(color);
    }

    void setColorDotsConcave(Color color) {
        this.colixDotsConcave = this.g3d.getColix(color);
    }

    void setColorDotsSaddle(Color color) {
        this.colixDotsSaddle = this.g3d.getColix(color);
    }

    void setColorDistance(Color c) {
        this.colorDistance = c;
        this.colixDistance = this.g3d.getColix(c);
    }

    void setColorAngle(Color c) {
        this.colorAngle = c;
        this.colixAngle = this.g3d.getColix(c);
    }

    void setColorTorsion(Color c) {
        this.colorTorsion = c;
        this.colixTorsion = this.g3d.getColix(c);
    }

    void setColorMeasurement(Color c) {
        this.colorAngle = this.colorTorsion = c;
        this.colorDistance = this.colorTorsion;
        this.colixAngle = this.colixTorsion = this.g3d.getColix(c);
        this.colixDistance = this.colixTorsion;
    }

    void setColorBackground(Color bg) {
        this.colorBackground = bg == null ? Color.getColor("colorBackground") : bg;
        this.colixBackground = this.g3d.getColix(this.colorBackground);
        this.g3d.setBackground(this.colixBackground);
    }

    void setColorAxes(Color color) {
        this.colorAxes = color;
        this.colixAxes = this.g3d.getColix(color);
    }

    void setColorAxesText(Color color) {
        this.colorAxesText = color;
        this.colixAxesText = this.g3d.getColix(color);
    }

    void setColorVector(Color c) {
        this.colorVector = c;
        this.colixVector = this.g3d.getColix(c);
    }

    Color getColorVector() {
        return this.colorVector;
    }

    void setColorBackground(String colorName) {
        if (colorName != null && colorName.length() > 0) {
            this.setColorBackground(this.viewer.getColorFromString(colorName));
        }
    }

    short getColixAtom(Atom atom) {
        return this.getColixAtomPalette(atom, this.paletteDefault);
    }

    short getColixAtomPalette(Atom atom, byte palette) {
        int argb = 0;
        switch (palette) {
            case 0: {
                short id = atom.getElementNumber();
                return this.g3d.getChangableColix(id, this.argbsCpk[id]);
            }
            case 6: {
                int index = this.quantize(-1.0f, 1.0f, atom.getPartialCharge(), JmolConstants.argbsRwbScale.length);
                argb = JmolConstants.argbsRwbScale[index];
                break;
            }
            case 8: 
            case 9: {
                float hi;
                float lo;
                if (palette == 8) {
                    Frame frame = this.viewer.getFrame();
                    lo = frame.getBfactor100Lo();
                    hi = frame.getBfactor100Hi();
                } else {
                    lo = 0.0f;
                    hi = 10000.0f;
                }
                int index = this.quantize(lo, hi, atom.getBfactor100(), JmolConstants.argbsRwbScale.length);
                index = JmolConstants.argbsRwbScale.length - 1 - index;
                argb = JmolConstants.argbsRwbScale[index];
                break;
            }
            case 1: {
                int index = atom.getFormalCharge() - -4;
                argb = JmolConstants.argbsCharge[index];
                break;
            }
            case 2: {
                argb = JmolConstants.argbsStructure[atom.getProteinStructureType()];
                break;
            }
            case 3: {
                short index = atom.getGroupID();
                if (index >= 23) {
                    index = 0;
                }
                argb = JmolConstants.argbsAmino[index];
                break;
            }
            case 4: {
                short index = atom.getGroupID();
                if (index >= 36) {
                    index = 0;
                }
                argb = JmolConstants.argbsShapely[index];
                break;
            }
            case 5: {
                int chain = atom.getChainID() & 0x1F;
                if (chain >= JmolConstants.argbsChainAtom.length) {
                    chain %= JmolConstants.argbsChainAtom.length;
                }
                argb = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[chain];
                break;
            }
            case 10: {
                int index = this.quantize(0.0f, atom.getSelectedGroupCountWithinChain() - 1, atom.getSelectedGroupIndexWithinChain(), JmolConstants.argbsBlueRedRainbow.length);
                argb = JmolConstants.argbsBlueRedRainbow[index];
                break;
            }
            case 11: {
                int index = this.quantize(0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, atom.getSelectedMonomerIndexWithinPolymer(), JmolConstants.argbsBlueRedRainbow.length);
                argb = JmolConstants.argbsBlueRedRainbow[index];
            }
        }
        if (argb == 0) {
            return 19;
        }
        return this.g3d.getColix(argb);
    }

    int quantize(float lo, float hi, float val, int segmentCount) {
        float range = hi - lo;
        if (range <= 0.0f || Float.isNaN(val)) {
            return segmentCount / 2;
        }
        float t = val - lo;
        if (t <= 0.0f) {
            return 0;
        }
        float quanta = range / (float)segmentCount;
        int q = (int)(t / quanta + 0.5f);
        if (q >= segmentCount) {
            q = segmentCount - 1;
        }
        return q;
    }

    short getColixHbondType(short order) {
        int argbIndex = (order & 0x3C0) >> 6;
        return this.g3d.getColix(JmolConstants.argbsHbondType[argbIndex]);
    }

    void flushCachedColors() {
    }

    int calcSurfaceIntensity(Point3f pA, Point3f pB, Point3f pC) {
        int intensity;
        this.vAB.sub(pB, pA);
        this.vAC.sub(pC, pA);
        this.vNormal.cross(this.vAB, this.vAC);
        this.viewer.transformVector(this.vNormal, this.vRotated);
        int n = intensity = this.vRotated.z >= 0.0f ? this.calcIntensity(-this.vRotated.x, -this.vRotated.y, this.vRotated.z) : this.calcIntensity(this.vRotated.x, this.vRotated.y, -this.vRotated.z);
        if (intensity > Graphics3D.intensitySpecularSurfaceLimit) {
            intensity = Graphics3D.intensitySpecularSurfaceLimit;
        }
        return intensity;
    }

    private void flushCaches() {
        this.g3d.flushShadesAndImageCaches();
        this.viewer.refresh();
    }

    void setSpecular(boolean specular) {
        this.g3d.setSpecular(specular);
        this.flushCaches();
    }

    boolean getSpecular() {
        return this.g3d.getSpecular();
    }

    void setSpecularPower(int specularPower) {
        this.g3d.setSpecularPower(specularPower);
        this.flushCaches();
    }

    void setAmbientPercent(int ambientPercent) {
        this.g3d.setAmbientPercent(ambientPercent);
        this.flushCaches();
    }

    void setDiffusePercent(int diffusePercent) {
        this.g3d.setDiffusePercent(diffusePercent);
        this.flushCaches();
    }

    void setSpecularPercent(int specularPercent) {
        this.g3d.setSpecularPercent(specularPercent);
        this.flushCaches();
    }

    void setLightsourceZ(float dist) {
        this.g3d.setLightsourceZ(dist);
        this.flushCaches();
    }

    int calcIntensity(float x, float y, float z) {
        return Graphics3D.calcIntensity(x, y, z);
    }
}

