/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.FontMetrics;
import org.jmol.g3d.Font3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Labels;
import org.jmol.viewer.ShapeRenderer;

class LabelsRenderer
extends ShapeRenderer {
    byte fidPrevious;
    Font3D font3d;
    FontMetrics fontMetrics;
    int ascent;
    int descent;
    int msgHeight;
    int msgWidth;

    LabelsRenderer() {
    }

    void render() {
        this.fidPrevious = 0;
        Labels labels = (Labels)this.shape;
        String[] labelStrings = labels.strings;
        short[] colixes = labels.colixes;
        short[] bgcolixes = labels.bgcolixes;
        byte[] fids = labels.fids;
        short[] offsets = labels.offsets;
        if (labelStrings == null) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        int displayModelIndex = this.displayModelIndex;
        int i = labelStrings.length;
        while (--i >= 0) {
            int yOffset;
            int xOffset;
            short offset;
            byte fid;
            String label = labelStrings[i];
            if (label == null) continue;
            Atom atom = atoms[i];
            if (displayModelIndex >= 0 && displayModelIndex != atom.modelIndex) continue;
            short colix = colixes == null || i >= colixes.length ? (short)0 : colixes[i];
            short bgcolix = bgcolixes == null || i >= bgcolixes.length ? (short)0 : bgcolixes[i];
            byte by = fid = fids == null || i >= fids.length || fids[i] == 0 ? labels.defaultFont3D.fid : fids[i];
            if (fid != this.fidPrevious) {
                this.g3d.setFont(fid);
                this.fidPrevious = fid;
                this.font3d = this.g3d.getFont3DCurrent();
                this.fontMetrics = this.font3d.fontMetrics;
                this.ascent = this.fontMetrics.getAscent();
                this.descent = this.fontMetrics.getDescent();
                this.msgHeight = this.ascent + this.descent;
            }
            short s = offset = offsets == null || i >= offsets.length ? (short)0 : offsets[i];
            if (offset == 0) {
                xOffset = 4;
                yOffset = 4;
            } else if (offset == Short.MIN_VALUE) {
                yOffset = 0;
                xOffset = 0;
            } else {
                xOffset = offset >> 8;
                yOffset = (byte)(offset & 0xFF);
            }
            this.renderLabel(atom, label, colix, bgcolix, xOffset, yOffset);
        }
    }

    void renderLabel(Atom atom, String strLabel, short colix, short bgcolix, int labelOffsetX, int labelOffsetY) {
        int xBoxOffset;
        int msgWidth = this.fontMetrics.stringWidth(strLabel);
        int boxWidth = msgWidth + 8;
        int boxHeight = this.msgHeight + 8;
        int zBox = atom.getScreenZ() - atom.getScreenD() / 2 - 2;
        if (zBox < 1) {
            zBox = 1;
        }
        if (labelOffsetX > 0) {
            xBoxOffset = labelOffsetX;
        } else {
            xBoxOffset = -boxWidth;
            xBoxOffset = labelOffsetX == 0 ? (xBoxOffset /= 2) : (xBoxOffset += labelOffsetX);
        }
        int yBoxOffset = labelOffsetY < 0 ? labelOffsetY : (labelOffsetY == 0 ? boxHeight / 2 + 2 : boxHeight + labelOffsetY);
        int xBox = atom.getScreenX() + xBoxOffset;
        int yBox = atom.getScreenY() - yBoxOffset;
        if (colix == 0) {
            colix = atom.colixAtom;
        }
        if (bgcolix != 0) {
            this.g3d.fillRect(bgcolix, xBox, yBox, zBox, boxWidth, boxHeight);
            this.g3d.drawRect(colix, xBox + 1, yBox + 1, zBox - 1, boxWidth - 2, boxHeight - 2);
        }
        int msgX = xBox + 4;
        int msgYBaseline = yBox + 4 + this.ascent;
        this.g3d.drawString(strLabel, colix, msgX, msgYBaseline, zBox - 1);
    }
}

