# The LearningOnline Network
# Logout Handler
#
# $Id: lonlogout.pm,v 1.22 2006/11/23 01:49:41 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonlogout;

use strict;
use Apache::Constants qw(:common);
use Apache::File;
use Apache::lonnet;
use Apache::lonmenu;
use CGI::Cookie();
use Apache::lonlocal;

sub handler {
    my $r = shift;

    #Check for cookie
    my $requrl=$r->uri;
    my %cookies=CGI::Cookie->parse($r->header_in('Cookie'));
    my $lonid=$cookies{'lonID'};
    my $cookie;
    if (!$lonid) {
	return FORBIDDEN;
    }

    #check if cookie still valid
    my $handle=&LONCAPA::clean_handle($lonid->value);
    my $lonidsdir=$r->dir_config('lonIDsDir');
    if ((!-e "$lonidsdir/$handle.id") || ($handle eq '')) {
	$r->log_reason("Cookie $handle not valid", $r->filename); 
	return FORBIDDEN;
    }

    #we've got a valid user
    my @profile;
    &Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);
    unlink("$lonidsdir/$handle.id");
    my %temp=('logout' => time);
    &Apache::lonnet::put('email_status',\%temp);
    &Apache::lonnet::log($env{'user.domain'},
			 $env{'user.name'},
			 $env{'user.home'},
			 "Logout $ENV{'REMOTE_ADDR'}");
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
# -------------------------------------------------------- Menu script and info

    my $windowinfo=&Apache::lonmenu::close();
    $windowinfo.=&Apache::lonnavmaps::close();
# ---------------------------------------------------------------- Get handover
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['handover']);
    my $switch='';
    my $start_page='';
    my $relogmessage='';
    if ($env{'form.handover'}) {
	$switch='<meta HTTP-EQUIV="Refresh" CONTENT="0.5; url='.
	    $env{'form.handover'}.'">';
	$start_page=&Apache::loncommon::start_page('Switching Server ...',
						   $switch);
    } else {
	$start_page=&Apache::loncommon::start_page('Logged Out',undef,
						   {'no_inline_link' => 1,});
	my %lt=&Apache::lonlocal::texthash('gb' => 'Goodbye',
					   'cw' => 'close this window',
					   'li' => 'log in again',
					   'pe' => 'Please either',
					   'or' => 'or');
	my $login_url = '/adm/'.($env{'request.sso.login'} ? 'roles' 
                                                           : 'login');
	
	$relogmessage=(<<ENDRELOG);
	<h1>$lt{'gb'}!</h1>
	    $lt{'pe'} <a href="javascript:self.close();">$lt{'cw'}</a> $lt{'or'}
	<a href="$login_url?domain=$env{'user.domain'}">$lt{'li'}</a>.
ENDRELOG

        if ($env{'request.sso.login'}
	    && defined($r->dir_config('lonSSOUserLogoutMessageFile'))) {
	    open(my $fh,$r->dir_config('lonSSOUserLogoutMessageFile'));
	    $relogmessage.= join('',<$fh>);
	}

    }
    my $end_page=&Apache::loncommon::end_page();
# --------------------------------------------------------------- Screen Output
    $r->print(<<ENDDOCUMENT);
$start_page
$windowinfo
$relogmessage
$end_page
ENDDOCUMENT
    &Apache::lonnet::flushcourselogs();
    return OK; 
}

1;
__END__








