#!/usr/bin/perl -w
#
# The LearningOnline Network
#
# dump_db.pl - dump a GDBM database to standard output, unescaping if asked to.
#
# $Id: clean_db.pl,v 1.3 2006/06/27 14:35:24 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#################################################
use strict;
use Getopt::Long;
use GDBM_File;
use lib '/home/httpd/lib/perl/';
use LONCAPA;

#
# Options
my ($unesc,$help,$localize_times) = (0,0,0);
GetOptions(     "help"     => \$help);

#
# Help them out if they ask for it
if ($help) {
    print <<END;
clean_db.pl - clean a db of a certain key
Specify the database filename on the command line.
And the Key to remove.
Options:
   --help     Display this help.
   -t        Localize times when possible (human readable times)
Example: 
    dump_db.pl mydata.db "error:"
END
    exit;
}

my $fname = shift;
my $key_to_remove = shift;

my $dbref =&LONCAPA::locking_hash_tie($fname,&GDBM_WRCREAT());

if (! $dbref) {
    warn("Unable to tie to $fname");
    exit;
}
while (my ($key,$value) = each(%{$dbref})) {
    if ($key ne $key_to_remove) { next; }
    delete($dbref->{$key});
    if ($fname =~ m|/nohist_[^/]*.db|) { exit; }
    my $hist=$fname;
    $hist=~s/\.db$/.hist/;
    open(HIST,">>$hist");
    print HIST ("D:".time.":$key\n");
    close(HIST);
}
exit;

