#!/usr/bin/perl -w
#
# The LearningOnline Network
#
# excise_from_db.pl - Remove a key from a db file.
#
# $Id: excise_from_db.pl,v 1.3 2006/06/27 14:37:40 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#################################################
use strict;
use GDBM_File;
use lib '/home/httpd/lib/perl/';
use LONCAPA;

#
# Options
my $fname = shift;
my $key = shift;

if (! defined($fname) || ! defined($key)) {
    print "Specify db file and key on command line.".$/.
        'excise_from_db.pl roles.db "a very long key"'.$/;
    exit;
}

my $dbref =&LONCAPA::locking_hash_tie($fname,&GDBM_WRCREAT());
if (! $dbref) {
    warn "Unable to tie to $fname";
    next;
}
delete($dbref->{$key});
delete($dbref->{&escape($key)});

&LONCAPA::locking_hash_untie($dbref);

exit;

