# The LearningOnline Network with CAPA
# Construction Space Page Wrapper for Construction
#
# $Id: lonconstruct.pm,v 1.33 2006/04/11 18:58:22 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#

package Apache::lonconstruct;


use strict;
use Apache::Constants qw(:common :http :methods);
use Apache::lonnet;
use HTML::Entities();

my $DEBUG = 0;
=pod

=item Debug($request, $message)

  If debugging is enabled puts out a debuggin message determined by the
  caller.  The debug message goes to the Apache error log file. Debugging
  is enabled by ssetting the module global DEBUG variable to nonzero (TRUE).

 Parameters:

=over 4
 
=item $request - The curretn request operation.

=item $message - The message to put inthe log file.

=back
  
 Returns:
   nothing.

=cut

sub Debug {
    # Put out the indicated message but only if DEBUG is true.
    if ($DEBUG) {
	my ($r,$message) = @_;
	$r->log_reason($message);
    }
} 

# ================================================================ Main Handler

sub handler {
   my $r=shift;

# -------------------------------------------------------------- Build frameset

   &Apache::loncommon::content_type($r,'text/html');
   $r->send_http_header;
   return OK if $r->header_only;

   my $lowerframe=$r->path_info;
   &Debug($r, "Initial URL for lower frame: ".$lowerframe);
   $lowerframe=~s/^\//\/\~/;
   &Debug($r, "Lower frame URL afer ~ subst: ".$lowerframe);
   $lowerframe= &HTML::Entities::encode($lowerframe,'<>&"');
   &Debug($r, "Lower frame URL after quote subst: ".$lowerframe);

#
# Are we forcing edit mode?
#

   &Apache::loncommon::get_unprocessed_cgi
        ($ENV{'QUERY_STRING'},['forceedit']);
   if ($env{'form.forceedit'}) {
       $lowerframe.='?editmode=Edit&problemmode=EditXML';
   }	
   &Apache::loncommon::get_unprocessed_cgi
        ($ENV{'QUERY_STRING'},['forceColoredit']);
   if ($env{'form.forceColoredit'}) {
       $lowerframe.='?editmode=Edit&problemmode=Edit';
   }

#
# Checking to see if we should display the topframe
#
   my $toprows = 0;
   my $topsrc = '';
   if ($env{'environment.remote'} ne 'off') {
       $toprows = '110';
       $topsrc = '/adm/localize/adm/publisher.html';
   }

   my $js=qq|
<script type="text/javascript">
var lastknownpriv="$lowerframe";
</script>
    |;

   my $start_page=
       &Apache::loncommon::start_page('Construction Space',$js,
				      {'frameset'    => 1,
				       'add_entries' => {
					   'rows'   => "$toprows,*",
					   'border' => "0",}});
   my $end_page=
       &Apache::loncommon::end_page({'frameset' => 1});

   $r->print(<<ENDPAGE);
$start_page
<frame src='$topsrc' />
<frame src="$lowerframe" name="LONCAPAToBePublished" />
$end_page
ENDPAGE
   return OK;
}
1;
__END__

