/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class SpartanReader
extends AtomSetCollectionReader {
    SpartanReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("spartan");
        try {
            if (this.discardLinesUntilContains(reader, "Cartesian Coordinates (Ang") != null) {
                this.readAtoms(reader);
            }
            if (this.discardLinesUntilContains(reader, "Vibrational Frequencies") != null) {
                this.readFrequencies(reader);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        String line;
        this.discardLinesUntilBlank(reader);
        while ((line = reader.readLine()) != null && this.parseInt(line, 0, 3) > 0) {
            String elementSymbol = this.parseToken(line, 4, 6);
            String atomName = this.parseToken(line, 7, 13);
            float x = this.parseFloat(line, 17, 30);
            float y = this.parseFloat(line, 31, 44);
            float z = this.parseFloat(line, 45, 58);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            atom.x = x;
            atom.y = y;
            atom.z = z;
        }
    }

    void readFrequencies(BufferedReader reader) throws Exception {
        int totalFrequencyCount = 0;
        block0: while (true) {
            float frequency;
            int lineFreqCount;
            String line = this.discardLinesUntilNonBlank(reader);
            int lineBaseFreqCount = totalFrequencyCount;
            this.ichNextParse = 16;
            for (lineFreqCount = 0; lineFreqCount < 3 && !Float.isNaN(frequency = this.parseFloat(line, this.ichNextParse)); ++lineFreqCount) {
                if (++totalFrequencyCount <= 1) continue;
                this.atomSetCollection.cloneFirstAtomSet();
            }
            if (lineFreqCount == 0) {
                return;
            }
            Atom[] atoms = this.atomSetCollection.atoms;
            this.discardLines(reader, 2);
            int firstAtomSetAtomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
            int i = 0;
            while (true) {
                if (i >= firstAtomSetAtomCount) continue block0;
                line = reader.readLine();
                for (int j = 0; j < lineFreqCount; ++j) {
                    int ichCoords = j * 23 + 10;
                    float x = this.parseFloat(line, ichCoords, ichCoords + 7);
                    float y = this.parseFloat(line, ichCoords + 7, ichCoords + 14);
                    float z = this.parseFloat(line, ichCoords + 14, ichCoords + 21);
                    int atomIndex = (lineBaseFreqCount + j) * firstAtomSetAtomCount + i;
                    Atom atom = atoms[atomIndex];
                    atom.vectorX = x;
                    atom.vectorY = y;
                    atom.vectorZ = z;
                }
                ++i;
            }
            break;
        }
    }
}

