/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

final class Shade3D {
    static final int shadeMax = 64;
    static final int shadeLast = 63;
    static byte shadeNormal = (byte)52;
    static final float xLightsource = -1.0f;
    static final float yLightsource = -1.0f;
    static float zLightsource = 2.5f;
    static float magnitudeLight = (float)Math.sqrt(2.0f + zLightsource * zLightsource);
    static float xLight = -1.0f / magnitudeLight;
    static float yLight = -1.0f / magnitudeLight;
    static float zLight = zLightsource / magnitudeLight;
    static boolean specularOn = true;
    static float intensitySpecular = 0.22f;
    static int specularExponent = 6;
    static float intenseFraction = 0.4f;
    static float intensityDiffuse = 0.84f;
    static float ambientFraction = 0.45f;
    static final byte intensitySpecularSurfaceLimit = (byte)(shadeNormal + 4);
    private static int seed = 305419897;

    Shade3D() {
    }

    static int[] getShades(int rgb) {
        int[] shades = new int[64];
        int red = rgb >> 16 & 0xFF;
        int grn = rgb >> 8 & 0xFF;
        int blu = rgb & 0xFF;
        float ambientRange = 1.0f - ambientFraction;
        shades[Shade3D.shadeNormal] = Shade3D.rgb(red, grn, blu);
        for (int i = 0; i < shadeNormal; ++i) {
            float fraction = ambientFraction + ambientRange * (float)i / (float)shadeNormal;
            shades[i] = Shade3D.rgb((int)((float)red * fraction + 0.5f), (int)((float)grn * fraction + 0.5f), (int)((float)blu * fraction + 0.5f));
        }
        int nSteps = 64 - shadeNormal - 1;
        float redRange = (float)(255 - red) * intenseFraction;
        float grnRange = (float)(255 - grn) * intenseFraction;
        float bluRange = (float)(255 - blu) * intenseFraction;
        for (int i = 1; i <= nSteps; ++i) {
            shades[Shade3D.shadeNormal + i] = Shade3D.rgb(red + (int)(redRange * (float)i / (float)nSteps + 0.5f), grn + (int)(grnRange * (float)i / (float)nSteps + 0.5f), blu + (int)(bluRange * (float)i / (float)nSteps + 0.5f));
        }
        return shades;
    }

    private static final int rgb(int red, int grn, int blu) {
        return 0xFF000000 | red << 16 | grn << 8 | blu;
    }

    static String StringFromRgb(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int grn = rgb >> 8 & 0xFF;
        int blu = rgb & 0xFF;
        return "[" + red + "," + grn + "," + blu + "]";
    }

    static byte calcIntensity(float x, float y, float z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return (byte)(Shade3D.calcFloatIntensityNormalized((float)((double)x / magnitude), (float)((double)y / magnitude), (float)((double)z / magnitude)) * 63.0f + 0.5f);
    }

    static int calcFp8Intensity(float x, float y, float z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return (int)(Shade3D.calcFloatIntensityNormalized((float)((double)x / magnitude), (float)((double)y / magnitude), (float)((double)z / magnitude)) * 63.0f * 256.0f);
    }

    static float calcFloatIntensity(float x, float y, float z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return Shade3D.calcFloatIntensityNormalized((float)((double)x / magnitude), (float)((double)y / magnitude), (float)((double)z / magnitude));
    }

    static float calcFloatIntensityNormalized(float x, float y, float z) {
        float cosTheta = x * xLight + y * yLight + z * zLight;
        float intensity = 0.0f;
        if (cosTheta > 0.0f) {
            float dotProduct;
            intensity += cosTheta * intensityDiffuse;
            if (specularOn && (dotProduct = z * 2.0f * cosTheta - zLight) > 0.0f) {
                int n = specularExponent;
                while (--n >= 0 && dotProduct > 1.0E-4f) {
                    dotProduct *= dotProduct;
                }
                intensity += dotProduct * intensitySpecular;
            }
        }
        if (intensity > 1.0f) {
            return 1.0f;
        }
        return intensity;
    }

    static byte calcDitheredNoisyIntensity(float x, float y, float z) {
        int random16bit;
        int fp8Intensity = Shade3D.calcFp8Intensity(x, y, z);
        int intensity = fp8Intensity >> 8;
        if ((fp8Intensity & 0xFF) > Shade3D.nextRandom8Bit()) {
            ++intensity;
        }
        if ((random16bit = seed & 0xFFFF) < 21845 && intensity > 0) {
            --intensity;
        } else if (random16bit > 43690 && intensity < 63) {
            ++intensity;
        }
        return (byte)intensity;
    }

    static byte calcDitheredNoisyIntensity(float x, float y, float z, float r) {
        int random16bit;
        int fp8Intensity = (int)(Shade3D.calcFloatIntensityNormalized(x / r, y / r, z / r) * 63.0f * 256.0f);
        int intensity = fp8Intensity >> 8;
        if ((fp8Intensity & 0xFF) > Shade3D.nextRandom8Bit()) {
            ++intensity;
        }
        if ((random16bit = seed & 0xFFFF) < 21845 && intensity > 0) {
            --intensity;
        } else if (random16bit > 43690 && intensity < 63) {
            ++intensity;
        }
        return (byte)intensity;
    }

    static int nextRandom8Bit() {
        int t = seed;
        seed = t = (t << 16) + (t << 1) + t & Integer.MAX_VALUE;
        return t >> 23;
    }

    static void setSpecular(boolean specular) {
        specularOn = specular;
        Shade3D.dump();
    }

    static boolean getSpecular() {
        return specularOn;
    }

    static void setLightsourceZ(float z) {
        zLightsource = z;
        magnitudeLight = (float)Math.sqrt(2.0f + zLightsource * zLightsource);
        Shade3D.dump();
    }

    static void setSpecularPower(int specularPower) {
        if (specularPower >= 0) {
            intenseFraction = (float)specularPower / 100.0f;
        } else {
            specularExponent = -specularPower;
        }
        Shade3D.dump();
    }

    static void setAmbientPercent(int ambientPercent) {
        ambientFraction = (float)ambientPercent / 100.0f;
        Shade3D.dump();
    }

    static void setDiffusePercent(int diffusePercent) {
        intensityDiffuse = (float)diffusePercent / 100.0f;
        Shade3D.dump();
    }

    static void setSpecularPercent(int specularPercent) {
        intensitySpecular = (float)specularPercent / 100.0f;
        Shade3D.dump();
    }

    static void dump() {
        System.out.println("\n ambientPercent=" + ambientFraction + "\n diffusePercent=" + intensityDiffuse + "\n specularOn=" + specularOn + "\n specularPercent=" + intensitySpecular + "\n specularPower=" + intenseFraction + "\n specularExponent=" + specularExponent + "\n zLightsource=" + zLightsource + "\n shadeNormal=" + shadeNormal);
    }
}

