/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.Model;
import org.jmol.viewer.Util;

final class Chain {
    Frame frame;
    Model model;
    char chainID;
    int groupCount;
    int selectedGroupCount;
    BitSet bsSelectedGroups;
    private static final BitSet bsNull = new BitSet();
    Group[] groups = new Group[16];

    Chain(Frame frame, Model model, char chainID) {
        this.frame = frame;
        this.model = model;
        this.chainID = chainID;
    }

    void freeze() {
        this.groups = (Group[])Util.setLength(this.groups, this.groupCount);
    }

    void addGroup(Group group) {
        if (this.groupCount == this.groups.length) {
            this.groups = (Group[])Util.doubleLength(this.groups);
        }
        this.groups[this.groupCount++] = group;
    }

    Group getGroup(int groupIndex) {
        return this.groups[groupIndex];
    }

    int getGroupCount() {
        return this.groupCount;
    }

    void selectAtoms(BitSet bs) {
        Frame frame = this.model.mmset.frame;
        Atom[] atoms = frame.getAtoms();
        int i = frame.getAtomCount();
        while (--i >= 0) {
            Atom atom = atoms[i];
            if (atom.getChain() != this) continue;
            bs.set(i);
        }
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        this.selectedGroupCount = 0;
        if (this.bsSelectedGroups == null) {
            this.bsSelectedGroups = new BitSet();
        } else {
            this.bsSelectedGroups.and(bsNull);
        }
        int i = this.groupCount;
        while (--i >= 0) {
            if (!this.groups[i].isSelected(bsSelected)) continue;
            ++this.selectedGroupCount;
            this.bsSelectedGroups.set(i);
        }
    }

    int getSelectedGroupCount() {
        return this.selectedGroupCount;
    }

    int getSelectedGroupIndex(Group group) {
        int selectedGroupIndex = 0;
        for (int i = 0; i < this.groupCount; ++i) {
            if (!this.bsSelectedGroups.get(i)) continue;
            if (this.groups[i] == group) {
                return selectedGroupIndex;
            }
            ++selectedGroupIndex;
        }
        return -1;
    }
}

