%module capa
%{

%}

%typemap(perl5,in) char** reterror (char* cvalue) {
  SV* tempsv;
  int len;
  if (!SvROK($source)) {
    croak("expected a reference\n");
  }
  tempsv = SvRV($source);
  if ((!SvPOK(tempsv))) {
    croak("expected a double reference\n");
  }
  cvalue = SvPV(tempsv,len);
  $target = &cvalue;
}

%typemap(perl5,argout) char ** reterror {
  SV *tempsv;
  tempsv = SvRV($arg);
  if (($source!=NULL) && (*$source!=NULL)) {
    sv_setpv(tempsv, *$source);
    free(*$source);
  }
}

%typemap(perl5,in) double* scaled {
  double *temp;
  if (!SvROK($source)) {
    croak("expected a reference\n");
  }
  SV* tempsv;
  tempsv = SvRV($source);
  if (!SvPOK(tempsv) && !SvIOK(tempsv) && !SvNOK(tempsv)) {
    croak("expected a single reference to a scalar\n");
  }
  temp = malloc(sizeof(double));
  *temp = SvNV(tempsv);
  $target = temp;
}

%typemap(perl5,argout) double* scaled {
  SV *tempsv;
  tempsv = SvRV($arg);
  sv_setnv(tempsv, *$source);
  free($source);
}


extern int caparesponse_capa_check_answer(char *response,char *correct,
				   int type,int tol_type,double tolerance,
				   int sig_lbound,int sig_ubound, 
				   char *ans_fmt, char *unit_str,
				   int calc, char *id_list, char *pts_list,
				   char *rndseed, char** reterror);

extern int caparesponse_get_real_response(char* unit_str, char* answer,
					  double* scaled);
