#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::courseclassifier;

use strict;
use lib '/home/httpd/lib/perl/';
use Apache::lonnet;
use LONCAPA;

sub retrieve_instcodes {
    my ($coursecodes,$codedom,$totcodes) = @_;
    my %courses = &Apache::lonnet::courseiddump($codedom,'.',1,'.','.','.',                                                undef,undef,'Course');
    foreach my $course (keys %courses) {
        if ($courses{$course} =~ m/^[^:]*:([^:]+)/) {
            $$coursecodes{$course} = &unescape($1);
            $totcodes ++;
        }
    }
    return $totcodes;
}

sub sort_cats {
    my ($num,$cat_order,$codetitles,$idsarrayref,$sorted) = @_;
    my @unsorted = @{$idsarrayref};
    if (defined($$cat_order{$$codetitles[$num]})) {
        foreach my $item (@{$$cat_order{$$codetitles[$num]}}) {
            if (grep/^\Q$item\E$/,@unsorted) {
                push @{$sorted}, $item;
            }
        }
    } else {
        @{$sorted} = sort (@unsorted);
    }
}

sub recurse_list {
    my ($cid,$codetitles,$codes,$num,$idarrays) = @_;
    if ($num == 0) {
        if (!grep/^$$codes{$cid}{$$codetitles[0]}$/,@{$$idarrays{$$codetitles[0]}}) {
            push @{$$idarrays{$$codetitles[0]}}, $$codes{$cid}{$$codetitles[0]};
        }
    } elsif ($num == 1) {
        if (defined($$idarrays{$$codetitles[1]}{$$codes{$cid}{$$codetitles[0]}})) {
            if (!grep/^$$codes{$cid}{$$codetitles[1]}$/,@{$$idarrays{$$codetitles[1]}{$$codes{$cid}{$$codetitles[0]}}}) {
                push @{$$idarrays{$$codetitles[1]}{$$codes{$cid}{$$codetitles[0]}}}, $$codes{$cid}{$$codetitles[1]};
            }
        } else {
            @{$$idarrays{$$codetitles[1]}{$$codes{$cid}{$$codetitles[0]}}} = ("$$codes{$cid}{$$codetitles[1]}");
        }
    } elsif ($num == 2) {
        if (defined($$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}})) {
            if (defined($$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}})) {
                if (!grep/^$$codes{$cid}{$$codetitles[2]}$/,@{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}}) {
                    push @{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}}, $$codes{$cid}{$$codetitles[2]};
                }
            } else {
                @{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ("$$codes{$cid}{$$codetitles[2]}");            }
        } else {
            %{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}} = ();
            @{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ("$$codes{$cid}{$$codetitles[2]}");
        }
    } elsif ($num == 3) {
        if (defined($$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}})) {
            if (defined($$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}})) {
                if (defined($$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}})) {
                    if (!grep/^$$codes{$cid}{$$codetitles[3]}$/,@{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}}) {
                        push @{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}}, $$codes{$cid}{$$codetitles[3]};
                    }
                } else {
                    @{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ("$$codes{$cid}{$$codetitles[3]}");
                }
            } else {
                %{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ();
                @{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ("$$codes{$cid}{$$codetitles[3]}");
            }
        } else {
            %{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}} = ();
            %{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ();
            @{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ("$$codes{$cid}{$$codetitles[3]}");
        }
    } elsif ($num == 4) {
        if (defined($$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}})) {
            if (defined($$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}})) {
                if (defined($$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}})) {
                    if (defined($$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}})) {
                        if (!grep/^$$codes{$cid}{$$codetitles[4]}$/,@{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}}) {
                            push @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}}, $$codes{$cid}{$$codetitles[4]};
                        }
                    } else {
                        @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}} = ("$$codes{$cid}{$$codetitles[4]}");
                    }
                } else {
                    %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ();
                    @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}} = ("$$codes{$cid}{$$codetitles[4]}");
                }
            } else {
                %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ();
                %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ();                @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}} = ("$$codes{$cid}{$$codetitles[4]}");
            }
        } else {
            %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}} = ();
            %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ();
            %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ();
            @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[3]}}} = ("$$codes{$cid}{$$codetitles[3]}");
        }
    }
    $num ++;
    if ($num <@{$codetitles}) {
        &recurse_list($cid,$codetitles,$codes,$num,$idarrays);
    }
}

sub build_code_selections {
    my ($codes,$codetitles,$cat_titles,$cat_order,$idlist,$idnums,$idlist_titles) = @_;
    my %idarrays = ();
    for (my $i=1; $i<@{$codetitles}; $i++) {
        %{$idarrays{$$codetitles[$i]}} = ();
    }
    foreach my $cid (sort keys %{$codes}) {
        &recurse_list($cid,$codetitles,$codes,0,\%idarrays);
    }
    for (my $num=0; $num<@{$codetitles}; $num++) {
        if ($num == 0) {
            my @contents = ();
            my @contents_titles = ();
            &sort_cats($num,$cat_order,$codetitles,\@{$idarrays{$$codetitles[0]}},\@contents);
            if (defined($$cat_titles{$$codetitles[0]})) {
                foreach (@contents) {
                    push @contents_titles, $$cat_titles{$$codetitles[0]}{$_};
                }
            }
            $$idlist{$$codetitles[0]} = join('","',@contents);
            $$idnums{$$codetitles[0]} = scalar(@contents);
            if (defined($$cat_titles{$$codetitles[0]})) {
                $$idlist_titles{$$codetitles[0]} = join('","',@contents_titles);
            }
        } elsif ($num == 1) {
            %{$$idlist{$$codetitles[1]}} = ();
            %{$$idlist_titles{$$codetitles[1]}} = ();
            foreach my $key_a (keys %{$idarrays{$$codetitles[1]}}) {
                my @sorted_a = ();
                my @sorted_a_titles = ();
                &sort_cats($num,$cat_order,$codetitles,\@{$idarrays{$$codetitles[1]}{$key_a}},\@sorted_a);
                if (defined($$cat_titles{$$codetitles[1]})) {
                    foreach (@sorted_a) {
                        push @sorted_a_titles, $$cat_titles{$$codetitles[1]}{$_};
                    }
                }
                $$idlist{$$codetitles[1]}{$key_a} = join('","',@sorted_a);
                $$idnums{$$codetitles[1]}{$key_a} = scalar(@sorted_a);
                if (defined($$cat_titles{$$codetitles[1]})) {
                    $$idlist_titles{$$codetitles[1]}{$key_a} = join('","',@sorted_a_titles);
                }
            }
        } elsif ($num == 2) {
            %{$$idlist{$$codetitles[2]}} = ();
            %{$$idlist_titles{$$codetitles[2]}} = ();
            foreach my $key_a (keys %{$idarrays{$$codetitles[2]}}) {
                %{$$idlist{$$codetitles[2]}{$key_a}} = ();
                %{$$idlist_titles{$$codetitles[2]}{$key_a}} = ();
                foreach my $key_b (keys %{$idarrays{$$codetitles[2]}{$key_a}}) {
                    my @sorted_b = ();
                    my @sorted_b_titles = ();
                    &sort_cats($num,$cat_order,$codetitles,\@{$idarrays{$$codetitles[2]}{$key_a}{$key_b}},\@sorted_b);
                    if (defined($$cat_titles{$$codetitles[2]})) {
                        foreach (@sorted_b) {
                            push @sorted_b_titles, $$cat_titles{$$codetitles[2]}{$_};
                        }
                    }
                    $$idlist{$$codetitles[2]}{$key_a}{$key_b} = join('","',@sorted_b);
                    $$idnums{$$codetitles[2]}{$key_a}{$key_b} = scalar(@sorted_b);
                    if (defined($$cat_titles{$$codetitles[2]})) {
                        $$idlist_titles{$$codetitles[2]}{$key_a}{$key_b} = join('","',@sorted_b_titles);
                    }
                }
            }
        } elsif ($num == 3) {
            %{$$idlist{$$codetitles[3]}} = ();
            foreach my $key_a (keys %{$idarrays{$$codetitles[3]}}) {
                %{$$idlist{$$codetitles[3]}{$key_a}} = ();
                foreach my $key_b (keys %{$idarrays{$$codetitles[3]}{$key_a}}) {
                    %{$$idlist{$$codetitles[3]}{$key_a}{$key_b}} = ();
                    foreach my $key_c (keys %{$idarrays{$$codetitles[3]}{$key_a}{$key_b}}) {
                        my @sorted_c = ();
                        my @sorted_c_titles = ();
                        &sort_cats($num,$cat_order,$codetitles,\@{$idarrays{$$codetitles[3]}{$key_a}{$key_b}{$key_c}},\@sorted_c);
                        if (defined($$cat_titles{$$codetitles[3]})) {
                            foreach (@sorted_c) {
                                push @sorted_c_titles, $$cat_titles{$$codetitles[3]}{$_};
                            }
                        }
                        $$idlist{$$codetitles[3]}{$key_a}{$key_b}{$key_c} = join('","',@sorted_c);
                        $$idnums{$$codetitles[3]}{$key_a}{$key_b}{$key_c} = scalar(@sorted_c);
                        if (defined($$cat_titles{$$codetitles[3]})) {
                            $$idlist_titles{$$codetitles[2]}{$key_a}{$key_b} = join('","',@sorted_c_titles);
                        }
                    }
                }
            }
        } elsif ($num == 4) {
            %{$$idlist{$$codetitles[4]}} = ();
            foreach my $key_a (keys %{$idarrays{$$codetitles[4]}}) {
                %{$$idlist{$$codetitles[4]}{$key_a}} = ();
                foreach my $key_b (keys %{$idarrays{$$codetitles[4]}{$key_a}}) {
                    %{$$idlist{$$codetitles[4]}{$key_a}{$key_b}} = ();
                    foreach my $key_c (keys %{$idarrays{$$codetitles[4]}{$key_a}{$key_b}}) {
                        %{$$idlist{$$codetitles[4]}{$key_a}{$key_b}{$key_c}} = ();
                        foreach my $key_d (keys %{$idarrays{$$codetitles[4]}{$key_a}{$key_b}{$key_c}}) {
                            my @sorted_d = ();
                            my @sorted_d_titles = ();
                            &sort_cats($num,$cat_order,$codetitles,$idarrays{$$codetitles[4]}{$key_a}{$key_b}{$key_c}{$key_d},\@sorted_d);
                            if (defined($$cat_titles{$$codetitles[4]})) {
                                foreach (@sorted_d) {
                                    push @sorted_d_titles, $$cat_titles{$$codetitles[4]}{$_};
                                }
                            }
                            $$idlist{$$codetitles[4]}{$key_a}{$key_b}{$key_c}{$key_d} = join('","',@sorted_d);
                            $$idnums{$$codetitles[4]}{$key_a}{$key_b}{$key_c}{$key_d} = scalar(@sorted_d);
                        }
                    }
                }
            }
        }
    }
}

sub javascript_code_selections {
    my ($formname,@codetitles) = @_;
    my $numtitles = @codetitles;
    my $output = (<<END_OF_BLOCK);
 var display = new Array($numtitles)
 if (caller == "" || caller == "$codetitles[0]") {
     if (caller == "") {
         document.$formname.Year.length = 0
         document.$formname.Year.options[0] = new Option("Select","-1",true,true)
         display[0] = new Array(idyears.length)
         for (var i=0; i<idyears.length; i++) {
             display[0][i] = idyears[i]
             if (longtitles[0] == 1) {
                 if (idyearslongs[i] != "") {
                     display[0][i] = idyearslongs[i]
                 }
             }
             else {
                 if (idyearslongs[i] != "") {
                     display[0][i] = idyears[i]
                 }
             }
             document.$formname.Year.options[i+1] = new Option(display[0][i],idyears[i],false,false)
         }
         document.$formname.Year.selectedIndex = 0;
     }
     document.$formname.Semester.length = 0
     document.$formname.Department.length = 0;
     document.$formname.Number.length = 0
     document.$formname.Department.options[0] = new Option("<-Pick $codetitles[1]","-1",true,true)
     document.$formname.Number.options[0] = new Option("<-Pick $codetitles[2]","-1",true,true)
     if (idyr == 0 || caller == "") {
         document.$formname.Semester.options[0] = new Option("<-Pick $codetitles[0]","-1",true,true)
     }
     else {
         document.$formname.Semester.options[0] = new Option("Select","-1",true,true)
         display[1] = new Array(idsems[idyr-1].length)
         for (var i=0; i<idsems[idyr-1].length; i++) {
             display[1][i] = idsems[idyr-1][i]
             if (longtitles[1] == 1) {
                 if (idsemslongs[idyr-1][i] != "") {
                     display[1][i] = idsemslongs[idyr-1][i]
                 }
             }
             document.$formname.Semester.options[i+1] = new Option(display[1][i],idsems[idyr-1][i],false,false)
         }
     }
     document.$formname.Semester.selectedIndex = 0;
 }
 if (caller == "$codetitles[1]") {
   document.$formname.Department.length = 0
   document.$formname.Number.length = 0
   document.$formname.Number.options[0] = new Option("<-Pick $codetitles[2]","-1",true,true)
   if (idsem == 0) {
     document.$formname.Department.options[0] = new Option("<-Pick $codetitles[1]","-1",true,true)
   }
   else {
    document.$formname.Department.options[0] = new Option("Select","-1",true,true)
    display[2] = new Array(idcodes[idyr-1][idsem-1].length)
    for (var i=0; i<idcodes[idyr-1][idsem-1].length; i++) {
      display[2][i] = idcodes[idyr-1][idsem-1][i]
      if (longtitles[2] == 1) {
          if (idcodeslongs[idyr-1][idsem-1][i] != "") {
              display[2][i] = idcodeslongs[idyr-1][idsem-1][i]
          }
      }
      document.$formname.Department.options[i+1] = new Option(display[2][i],idcodes[idyr-1][idsem-1][i],false,false)
    }
   }
   document.$formname.Department.selectedIndex = 0
 }
 if (caller == "$codetitles[2]") {
   document.$formname.Number.length = 0
   if (iddept == 0) {
     document.$formname.Number.options[0] = new Option("<-Pick $codetitles[2]","-1",true,true)
   }
   else {
    document.$formname.Number.options[0] = new Option("Select","-1",true,true)
    display[3] = new Array (idcourses[idyr-1][idsem-1][iddept-1].length)
    for (var i=0; i<idcourses[idyr-1][idsem-1][iddept-1].length; i++) {
      display[3][i] = idcourses[idyr-1][idsem-1][iddept-1][i]
      if (longtitles[3] == 1) {
        if (idcourseslongs[idyr-1][idsem-1][iddept-1][i] != "") {
            display[3][i] = idcourseslongs[idyr-1][idsem-1][iddept-1][i]
        }
      }
      document.$formname.Number.options[i+1] = new Option(display[3][i],idcourses[idyr-1][idsem-1][iddept-1][i],false,false)
    }
   }
   document.$formname.Number.selectedIndex = 0
 }
}

function initialize_codes() {
    courseSet();
    return;
}
END_OF_BLOCK
}


sub javascript_definitions {
    my ($codetitles,$idlist,$idlist_titles,$idnums,$cat_titles) = @_;
    my $numtitles = @{$codetitles};
    my $longtitles = [];
    for (my $i=0; $i<$numtitles; $i++) {
       if (defined($cat_titles->{$codetitles->[$i]})) {
           $longtitles->[$i] = 1;
       } else {
           $longtitles->[$i] = 0;
       }
    }
    my $scripttext;
    if ($longtitles->[0]) {
        $scripttext =
          qq|      var idyearslongs = new Array("$idlist_titles->{$codetitles->[0]}")\n|;
    }
    $scripttext .=
          "      var idsems = new Array ($idnums->{$codetitles->[0]})\n";
    if ($longtitles->[1]) {
        $scripttext .=
          "      var idsemslongs = new Array ($idnums->{$codetitles->[0]})\n";    }
    $scripttext .=
          "      var idcodes = new Array ($idnums->{$codetitles->[0]})\n";
    if ($longtitles->[2]) {
        $scripttext .=
          "      var idcodeslongs = new Array ($idnums->{$codetitles->[0]})\n";
    }
    $scripttext .=
          "      var idcourses = new Array ($idnums->{$codetitles->[0]})\n";
    if ($longtitles->[3]) {
        $scripttext .=
          "      var idcourseslongs =  new Array ($idnums->{$codetitles->[0]})\n";
    }
    my @sort_a = split/","/,$idlist->{$codetitles->[0]};
    for (my $j=0; $j<@sort_a; $j++) {
        $scripttext .= qq| idsems[$j] = new Array("$idlist->{$codetitles->[1]}{$sort_a[$j]}")\n|;
        if ($longtitles->[1]) {
            $scripttext .= qq| idsemslongs[$j] = new Array("$idlist_titles->{$codetitles->[1]}{$sort_a[$j]}")\n|;
        }
        $scripttext .= qq| idcodes[$j] = new Array($idnums->{$codetitles->[1]}{$sort_a[$j]})\n|;
        if ($longtitles->[2]) {
            $scripttext .= qq| idcodeslongs[$j] = new Array($idnums->{$codetitles->[1]}{$sort_a[$j]})\n|;
        }
        $scripttext .= qq| idcourses[$j] = new Array($idnums->{$codetitles->[1]}{$sort_a[$j]})\n|;
        if ($longtitles->[3]) {
            $scripttext .= qq| idcourseslongs[$j] = new Array($idnums->{$codetitles->[1]}{$sort_a[$j]})\n|;
        }
        my @sort_b = split/","/,$idlist->{$codetitles->[1]}{$sort_a[$j]};
        for (my $k=0; $k<@sort_b; $k++) {
            my $idcode_entry = $idlist->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]};
            $scripttext .= qq| idcodes[$j][$k] = new Array("$idcode_entry")\n|;
            if ($longtitles->[2]) {
                my $idcodelong_entry = $idlist_titles->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]};
                $scripttext .= qq| idcodeslongs[$j][$k] = new Array("$idcodelong_entry")\n|;
            }
            $scripttext .= qq| idcourses[$j][$k] = new Array($idnums->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]})\n|;
            if ($longtitles->[3]) {
                $scripttext .= qq| idcourseslongs[$j][$k] = new Array($idnums->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]})\n|;
            }
            my @sort_c = split/","/,$idlist->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]};
            for (my $l=0; $l<@sort_c; $l++) {
                my $idcourse_entry = $idlist->{$codetitles->[3]}{$sort_a[$j]}{$sort_b[$k]}{$sort_c[$l]};
                $scripttext .= qq| idcourses[$j][$k][$l] = new Array("$idcourse_entry")\n|;
                if ($longtitles->[3]) {
                    my $idcourselong_entry = $idlist_titles->{$codetitles->[3]}{$sort_a[$j]}{$sort_b[$k]}{$sort_c[$l]};
                    $scripttext .= qq| idcourseslongs[$j][$k][$l] = new Array("$idcourselong_entry")\n|;
                }
            }
        }
    }
    return ($scripttext,$longtitles);
}

sub courseset_js_start {
    my ($formname,$longtitles_str,$allidlist) = @_;
    my $output = <<END;
function courseSet(caller) {
    var longtitles = new Array ("$longtitles_str");
    var idyr = document.$formname.Year.selectedIndex
    var idsem  = document.$formname.Semester.selectedIndex
    var iddept = document.$formname.Department.selectedIndex
    var idclass = document.$formname.Number.selectedIndex
    var idyears = new Array("$allidlist");
END
    return $output;
}

1;

