# The LearningOnline Network
# Internal Server Error Handler
#
# $Id: lonerrorhandler.pm,v 1.12 2006/09/02 20:49:20 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonerrorhandler;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonmsg();
use Apache::lonacc();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    &Apache::lonacc::get_posted_cgi($r);

    my $title = $env{'form.sendinfo'} ? 'Sending Error Report'
                                      : 'Could Not Process Request';
    $r->print(&Apache::loncommon::start_page($title));

    if ($env{'form.sendinfo'}) {
	my $repro='no';
# ------------------------------------------------------------------ Mail stuff
	if ($env{'form.reproducible'}) {
	    $repro='yes';
	}
	my $message=(<<ENDMESSAGE);
LON-CAPA Error Message
Reproducible: $repro
Version: $env{'form.version'}
Syllabus:
$env{'form.syllabus'}

Prior Action:
$env{'form.prioraction'}

Guesses:
$env{'form.guesses'}

Environment:
$env{'form.environment'}
ENDMESSAGE
	my $recipients=$r->dir_config('lonAdmEMail').','.
	    $r->dir_config('lonSysEMail'); 

        &Apache::lonmsg::sendemail($recipients,'ERROR REPORT',$message);
	$r->print('<h2>Report submitted</h2>Thank you!');
    } else {
# ------------------------------------------------------------- Get environment
	my $envkey;
	my $env='';
	my $syllabus='';

	foreach $envkey (sort(keys(%env))) {
	    $env.="$envkey: $env{$envkey}\n";
	}
	foreach $envkey (sort(keys(%ENV))) {
	    $env.="$envkey: $ENV{$envkey}\n";
	    if ($envkey=~/REDIRECT\_(REQUEST_URI|SCRIPT|ERROR)/) {
		$syllabus.="\n$1:\n$ENV{$envkey}";
	    }
	}

	$env=~s/\"/\'\'/g;

	my $version=$r->dir_config('lonVersion');

# ----------------------------------------------------------- Print error form
	$r->print(<<ENDDOCUMENT);
<h2>Somewhere something went wrong - please help us to find out what.</h2>
Please take a moment to fill out the form below. Your information, together
with internal debugging information, will be emailed to the system and server
administrators.
<form action="/adm/errorhandler" method="post">
<input type="submit" value="Send Information" />
<h3>Please describe what you did just before this screen came up</h3>
<textarea name="prioraction" cols="50" rows="5">
</textarea>
<h3>Is this problem reproducible?</h3>
<label>
<input type="checkbox" name="reproducible" value="yes" /> Yes!
</label>
<h3>Do you have any guesses why this might have happened?</h3>
<textarea name="guesses" cols="50" rows="5">
</textarea>
<input type="hidden" name="version" value="$version" />
<input type="hidden" name="environment" value="$env" />
<input type="hidden" name="syllabus" value="$syllabus" />
<input type="hidden" name="sendinfo" value="1" />
<p>
<input type="submit" value="Send Information" />
</p>
</form>
<h1>Thank you for your help!</h1>
<font size="-1">
<pre>
Internal info:
$syllabus
</pre>
</font>
ENDDOCUMENT
# -------------------------- Better terminate this in case something was sticky

        $r->child_terminate();
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
} 

1;
__END__
