# The LearningOnline Network with CAPA
# Souce Code handler
#
# $Id: lonsource.pm,v 1.17 2006/06/22 18:17:23 www Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###


package Apache::lonsource;

use strict;
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonhtmlcommon();
use Apache::lonsequence();
use Apache::Constants qw(:common :http);
use Apache::lonmeta;
use Apache::File;
use Apache::lonlocal;
use HTML::Entities;
use LONCAPA;

sub make_link {
    my ($filename, $listname) = @_;
    my $sourcelink = "/adm/source?filename=".$filename."&listname=".$listname;

    return $sourcelink;
}

sub stage_2 {
    my ($r, $filename, $author, $listname) = @_;
    $filename = $filename;
    &Apache::loncommon::content_type($r,'text/html');
    my ($uname, $udom) = &Apache::loncacc::constructaccess('/~'.$author.'/',$r->dir_config('lonDefDomain'));
    $r->send_http_header;
    $r->print(&Apache::loncommon::start_page('Problem source code moving operation'));
    $r->print("Please enter the directory that you would like the source code to go into, a default has also been 			provided <br />");
    $r->print("Also note, the path is in reference to the root of your construction space, and new directories will be 			automatically created. <br /><br />");
    $r->print('<form name="copy" action="/adm/source" target="_parent" method="post">
              <input type="hidden" name="filename" value="'.$filename.'" />
              <input type="hidden" name="listname" value="'.$listname.'" />
              <input type="hidden" name="action" value="copy_stage" />
              <input type="text" size="50" name="newpath" value="/shared_source/'.$author.'" />&nbsp;
              <input type="submit" value="Copy" />
              </form>');
    return OK;
}


sub copy_stage {
    my ($r, $filename, $listname, $newpath) = @_;
    my $role;
    my $domain;
    my $author_name;
#Figure out if we are author or co-author

    if($env{'request.role'} =~ m|ca.|) {
        ($role, $domain, $author_name) = split(/\//,$env{'request.role'});
    } else {
        $role = "au.";
        $domain = $env{'user.domain'};
        $author_name = $env{'user.name'};
    }

    my $path_to_new_file = '/home/'.$author_name.'/public_html/'.$newpath.'/'.$listname;
#Just checking again for access as we want to make sure that it is really ok now that we have the real path

    my ($uname,$udom)= &Apache::loncacc::constructaccess($path_to_new_file,$domain);
    unless (($uname) && ($udom)) {
        return HTTP_NOT_ACCEPTABLE;
    }
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    $r->print(&Apache::loncommon::start_page('Copying Source'));
    my $result = &Apache::loncfile::exists($uname, $udom, $path_to_new_file);
    $r->print($result);
    if(($result) && ($result =~ m|published|) ) {
        &delete_copy_file($r, $author_name, $newpath, $filename, $path_to_new_file, '1');
    } elsif(($result) && ($result =~ m|exists!|)) {
        &confirm($r, $author_name, $newpath, $filename, $path_to_new_file);
    } else {
        &copy_file($r, $author_name, $newpath, $filename, $path_to_new_file);
    }

    return OK;

}

sub confirm {
    my ($r, $author_name, $newpath, $filename, $path_to_new_file) = @_;
    $r->print("<b>Press delete to remove file and replace it with a copy of the source you are viewing</b><br /><br /	>");
    $r->print('<form name="delete_confirm" action="/adm/source" target="_parent" method="post">
              <input type="hidden" name="filename" value="'.$filename.'" />
              <input type="hidden" name="path" value="'.$path_to_new_file.'" />
              <input type="hidden" name="author" value="'.$author_name.'" />
              <input type="hidden" name="newpath" value="'.$newpath.'" />
              <input type="hidden" name="action" value="delete_confirm" />

              <input type="submit" value="Delete" />
              </form>');
}

sub delete_copy_file {
    my ($r, $author_name, $newpath, $filename, $path_to_new_file, $type) = @_;
    if($type eq '1') {
        $r->print("<b>Cannot delete non-obsolete published file</b><br />Please
              use the code view in previous window to use shared code<br /><br />");
        $r->print('<input type="button" value="Close Window" name="close" onClick="window.close()" />');
    } else {
        if(-e $path_to_new_file) {
            unless(unlink($path_to_new_file)) {
                $r->print('<font color="red">'.&mt('Error').': '.$!.'</font>');
                return 0;
            }
        } else {
            $r->print('<p> '.&mt('No such file').'. </p></form>');
            return 0;
        }
        &copy_file($r, $author_name, $newpath, $filename, $path_to_new_file);
    }
}

sub copy_file {
    my ($r, $author_name, $newpath, $filename, $path_to_new_file) = @_;
    $r->print("<b>Creating directories</b>");
    my $path = '/home/'.$author_name.'/public_html/';
    my @directories = split(/\//,$newpath);
    foreach my $now_checking (@directories) {
        if($now_checking ne '') {
            $path = $path.'/'.$now_checking;
            if(-e $path) {} #More moving along, isn't recursion fun'

            else {
                unless(mkdir($path, 02770)) {
                    $r->print('<font color="red">'.&mt('Error').': '.$!.'</font>');
                    return 0;
                }
                unless(chmod(02770, ($path))) {
                    $r->print('<font color="red"> '.&mt('Error').': '.$!.'</font>');
                    return 0;
                }
            }
        } else { } #Just move along

    }
    $r->print("<br /><b>Copying File</b>");
    my $problem_filename = $Apache::lonnet::perlvar{'lonDocRoot'}.$filename;
    my $file_output = &includemeta(&Apache::lonnet::getfile($problem_filename),$filename);
    my $fs=Apache::File->new(">$path_to_new_file");
    if (defined($fs)) {
        print $fs $file_output;
    }
    $r->print("<br /><br />");
    $r->print('<input type="button" value="Close Window" name="close" onClick="window.close()">');
    #Some 1.3'ish feature is to include the derivative feature, will go here..'
}

sub print_item {
    my ($r, $filename) = @_;
    my $file_output = &includemeta(&Apache::lonnet::getfile($Apache::lonnet::perlvar{'lonDocRoot'}.$filename),$filename);
    my $count=0;
    my $maxlength=-1;
    foreach (split ("\n", $file_output)) {
        $count+=int(length($_)/79);
        $count++;
        if (length($_) > $maxlength) {
            $maxlength = length($_);
        }
    }
    my $rows = $count;
    my $cols = $maxlength;
    $r->print('<textarea rows="'.$rows.'" cols="'.$cols.'" name="editxmltext">'.
              &HTML::Entities::encode($file_output,'<>&"').'</textarea>');
    return OK;

}

sub includemeta {
    my ($file_output,$orgfilename)=@_;
    my $escfilename=&escape($orgfilename);
    my $copytime=time;
    if ($file_output=~/\<meta\s*name\=\"isbasedonres\"/i) {
	$file_output=~s/(\<meta\s*name\=\"isbasedonres\"\s*content\=\"[^\"]*)\"/$1\,\Q$escfilename\E\"/i;
    } else {
	$file_output=~s/(\<(?:html|problem)[^\>]*\>)/$1\n\<meta name=\"isbasedonres\" content=\"\Q$escfilename\E\" \/\>/i;
    }
    if ($file_output=~/\<meta\s*name\=\"isbasedontime\"/i) {
	$file_output=~s/(\<meta\s*name\=\"isbasedontime\"\s*content\=\"[^\"]*)\"/$1\,\Q$copytime\E\"/i;
    } else {
	$file_output=~s/(\<(?:html|problem)[^\>]*\>)/$1\n\<meta name=\"isbasedontime\" content=\"\Q$copytime\E\" \/\>/i;
    }
    return $file_output;
}

sub handler {
    my $r=shift;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['filename','listname']);
    my $filename = $env{'form.filename'};
    my $listname = $env{'form.listname'};
    my $source = &Apache::lonnet::metadata($filename,'sourceavail');
    if ($source ne 'open') {
        $env{'user.error.msg'}="$filename:cre:1:1:Source code not available";
        return HTTP_NOT_ACCEPTABLE;
    } 
    unless ((&Apache::lonnet::allowed('bre',$filename)) &&
	    (&Apache::lonnet::allowed('cre','/'))) {
        $env{'user.error.msg'}="$filename:bre:1:1:Access to resource denied";
        return HTTP_NOT_ACCEPTABLE;
    } 
    if ($env{'form.action'} eq 'stage2') {
        my $author = &Apache::lonnet::metadata($filename,'authorspace');
        ($author) = split('@',$author); #strip the domain of the author name
        &stage_2($r, $env{'form.filename'}, $author, $listname);
    } elsif($env{'form.action'} eq 'copy_stage') {
        &copy_stage($r, $filename,$env{'form.listname'},$env{'form.newpath'});
    } elsif($env{'form.action'} eq 'delete_confirm') {
        &Apache::loncommon::content_type($r,'text/html');
        $r->send_http_header;
        &delete_copy_file($r, $env{'form.author'}, $env{'form.newpath'}, $env{'form.filename'}, $env{'form.path'}, '0');
    } else {
        &Apache::loncommon::content_type($r,'text/html');
        $r->send_http_header;
        $r->print('<form name="copy" action="/adm/source" target="_parent" method="post">
                  <input type="button" value="Close Window" name="close" onClick="window.close()" />
                  <input type="hidden" name="filename" value="'.$filename.'" />
                  <input type="hidden" name="listname" value="'.$listname.'" />
                  <input type="hidden" name="action" value="stage2" />
                  <input type="submit" value="Copy to CSTR" />
                  </form>');
        $r->print('<hr />');
        &print_item($r, $env{'form.filename'});
    }
    return OK;
}

1;


