# The LearningOnline Network with CAPA
# Japanese Localization Lexicon
#
# $Id: ja.pm,v 1.16 2006/08/18 18:54:22 riegler Exp $
#
# Copyright i-Learning Limited Partnership Company
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::ja;
use base qw(Apache::localize);
%Lexicon=('_AUTO' => 1,
'language_code' => 'ja',
'char_encoding' => 'UTF-8',
'date_locale'  => 
      '$weekday, $day.$month.$year, $twentyfour:$minutes:$seconds',
'date_months'  => '1,2,3,4,5,6,7,8,9,10,11,12',
'date_days'    => '日,月,火,水,木,金,土',
'date_am' => 'am',
'date_pm' => 'pm',
'textual_remote_display' => 'on',
'htmlarea_lang' => 'ja-utf8',


   'Domain'
=> 'ドメイン',

   'Server'
=> 'サーバ',

   'Load'
=> '負荷',

   'User Load'
=> 'ユーザ負荷',

   'Help'
=> 'ヘルプ',

   'Log in'
=> 'ログイン',

   'Username'
=> 'ユーザ名',

   'Password'
=> 'パスワード',

   'choose'
=> '選択',

   'enter'
=> '入力',

   'view'
=> '閲覧',

   'calendar'
=> 'カレンダ',

   'prefer-'
=> '個人',

   'ences'
=> '設定',

   'role'
=> '役割',

   'course'
=> 'コース',

   'create'
=> '作成',

   'grades'
=> '成績',

   'commu-'
=> 'コミュニ',

   'nication'
=> 'ケーション',

   'enroll'
=> '出席',

   'navigate'
=> 'ナビゲート',

   'contents'
=> 'コンテンツ',

   'Announcements and Calendar'
=> 'お知らせとカレンダ',

   'Author'
=> '作成者',

   'Change Your Preferences'
=> 'お気に入りを変更する',

   'Choose the user role'
=> 'ユーザの役割を選ぶ',

   'Co-Author'
=> '共同作成者',

   'Communication and Messages'
=> 'コミュニケーションツール',

   'Course Coordinator'
=> 'コーディネータ',

   'Course Statistics and Charts'
=> 'コースの統計と図表',

   'Course announcements and my calendar'
=> 'コースのお知らせとカレンダ',

   'Create Users, Change User Privileges'
=> 'ユーザを作り、権限を変更する',

   'Domain Coordinator'
=> 'ドメイン管理者',

   'Enrollment Manager'
=> '履修管理者',

   'Enter grades from check-out assessment resources'
=> '成績を入力する',

   'Exam Proctor'
=> '試験官',

   'Exit LON-CAPA'
=> 'LON-CAPAを終了する',

   'Grades Spreadsheet'
=> '成績表をつける',

   'Grading'
=> '採点',

   'Instructor'
=> 'インストラクタ',

   'Launch Remote Control'
=> 'リモコンパネルを使う',

   'Main Menu'
=> 'メインメニュー',

   'Navigate Course Contents'
=> 'コースをナビゲートする',

   'No Role, Cumulative Privileges'
=> '役割・権限の設定なし',

   'Return to Last Location'
=> '最後に戻る',

   'Send and receive messages'
=> 'メッセージを送受信する',

   'Set my user preferences'
=> '個人設定を変更する',

   'Student'
=> '学生',

   'Switch to another user role'
=> '他の役割に切り替える',

   'Teaching Assistant'
=> 'ＴＡ',

   'Use or edit my bookmark collection'
=> 'ブックマークを使う／編集する',

   'User Roles'
=> '役割',

   'Calculate course grades (Spreadsheet)'
=> 'コースの成績を計算する(スプレッドシート)',

   'Enter the chatroom for the course'
=> 'コース・チャットルームに入る',

   'Navigate the table of contents for this course'
=> 'コースの目次をナビゲートする',

   'Syllabus'
=> 'シラバス',

   'View the course assessment progress chart'
=> '成績の伸長グラフを見る',

   'Class Hours'
=> '講義時間',

   'Course Description'
=> 'コースの内容',

   'Coursepack'
=> 'コースパック',

   'Current Month'
=> '今月',

   'Deadlines'
=> '締め切り',

   'Fri'
=> '金',

   'Grading Information'
=> '採点情報',

   'Helproom Hours'
=> '支援室サービス時間',

   'Instructor Information'
=> 'インストラクタ情報',

   'Mon'
=> '月',

   'Next Month'
=> '来月',

   'Office Hours'
=> 'オフィスアワー',

   'Prerequisites'
=> '前提条件',

   'Previous Month'
=> '前月',

   'Readings'
=> '読み物',

   'Sat'
=> '土',

   'January'
=> '１月',

   'February'
=> '２月',

   'March'
=> '３月',

   'April'
=> '４月',

   'May'
=> '５月',

   'June'
=> '６月',

   'August'
=> '８月',

   'September'
=> '９月',

   'October'
=> '10月',

   'November'
=> '11月',

   'December'
=> '12月',

   'Sun'
=> '日',

   'Textbook'
=> 'テキスト',

   'Thu'
=> '木',

   'Tue'
=> '火',

   'Web Links'
=> 'リンク',

   'Wed'
=> '水',

   'Drop/Add students in this course'
=> 'コースに／から学生を追加／削除する',

   'You have entered that answer before'
=> '前にもこの回答を入力しています',

   'A score has been assigned.'
=> '採点されました。',

   'You are correct.'
=> '正解です。',

   'Your receipt is'
=> 'あなたの受領するものは',

   'You are excused from the problem.'
=> 'その問題は受験しなくて良いです。',

   'Incorrect'
=> '間違い',

   'Some parts were not submitted.'
=> 'いくつかの部分が提出されていません。',

   'An error occured while grading your answer.'
=> 'あなたの回答を採点しているときにエラーが起きました。',

   'The submitted answer was too long.'
=> '回答が長すぎます。',

   'This question expects a numeric answer.'
=> 'この質問では数字の回答を期待しています。',

   'You have provided an invalid ranking'
=> '無効な成績ランクをつけました',

   'please refer to'
=> '次のものを参照せよ：',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'アップロードしたファイルの拡張子は禁止されています。',

   'Please adjust significant figures.'
=> '数字が大きすぎます。',

   'Units incorrect.'
=> '単位が間違っています。',

   'Only a number required.'
=> '数字だけが要求されています。',

   'Units required'
=> '単位が必要です',

   'Unable to understand formula'
=> '数式を解釈できません',

   'Your submission has been recorded.'
=> '提出されたものは記録されました。',

   'Unknown message'
=> '定義されていないメッセージです',

   'Answer Submitted'
=> '提出された回答',

   'Tries'
=> '受験回数',

   'Submit Answer'
=> '回答を提出する',

   'Prepare a printable document'
=> '印刷用ドキュメントを用意します',

   'Go To My First Homework Problem'
=> '最初の問題に戻る',

   'Discussions'
=> 'ディスカッション',

   'New discussion since'
=> '次の日付以降の未読のメッセージ：',

   'Goodbye'
=> 'さようなら',


#SYNC Fri Sep 26 14:41:18 2003
   ', and answers will be available on'
=> ', 正解は次のリンクにあります',

   ', or the next time you log in.'
=> '、または次回のログイン。',

   ', select a template from the pull-down menu below'
=> ', 下のプルダウンメニューからテンプレートを選択する',

   'Abstract'
=> 'アブストラクト',

   'Access and Usage Statistics'
=> '統計の表示と説明',

   'Actions'
=> 'アクション',

   'All homework is currently completed'
=> 'すべての宿題は完了しています',

   'Analyze Progress'
=> '進歩状況を分析する',

   'Analyzing a problem'
=> '問題を分析する',

   'Answer'
=> '回答',

   'Answer available'
=> '正解が公開されています',

   'Answer submitted'
=> '回答は提出されています',

   'Answer submitted, not yet graded'
=> '回答は提出されていますが、採点されていません',

   'Back to Directory'
=> 'ディレクトリに戻る',

   'Bulletin Board'
=> '掲示板',

   'Cancel'
=> 'キャンセル',

   'Changes will become active for your current session after'
=> '変更は次にログインしたときに有効になります',

   'Construction Space Directory'
=> 'コンストラクション・スペース・ディレクトリ',

   'Contact'
=> 'コンタクト',

   'Copying file'
=> 'ファイルをコピー',

   'Course'
=> 'コース',

   'Create'
=> '作成',

   'Create a user or modify the roles and privileges of a user'
=> 'ユーザを追加、役割・権限を変更',

   'Currently not available'
=> '現在、提供されていません',

   'Currently selected. '
=> '現在、選択されています。',

   'Date'
=> '日付',

   'Discard Edits and View'
=> '編集を止めて見る',

   'Display'
=> '表示する',

   'Done'
=> '完了',

   'Edit'
=> '編集',

   'EditXML'
=> 'ＸＭＬを編集',

   'Empty'
=> 'クリア',

   'End'
=> '終了',

   'Evaluation Comments'
=> '評価コメント',

   'Evaluation Data'
=> '評価データ',

   'Excused by instructor'
=> 'インストラクタによって許可されました',

   'Extent'
=> '拡張子',

   'File'
=> 'ファイル',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'この問題の中に分析できない部分があります。現在、数字と数式と文字しかサポートされていません。',

   'Frequency'
=> '頻度',

   'Getting Problem Variants'
=> '問題の変形を得る',

   'Go Back'
=> '戻る',

   'Import'
=> 'インポート',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'このファイルを触る前にウィルススキャナーでチェックしてください。',

   'July'
=> '７月',

   'Language'
=> '言語',

   'Last Modified'
=> '最終変更',

   'List of possible answers'
=> '選択肢リスト',

   'Main Course Documents'
=> 'メイン・コース・ドキュメント',

   'Map'
=> 'マップ',

   'Map contents are not shown in order.'
=> 'マップの内容は順不同です。',

   'Name'
=> '名前',

   'Navigate Contents'
=> 'コンテンツをナビゲートする',

   'New Folder'
=> 'フォルダを作る',

   'New Messages'
=> 'メッセージを作成する',

   'New Search'
=> '新規の検索',

   'No content modifications yet.'
=> '変更されたものはありません。',

   'No due date'
=> '締め切りはありません',

   'No role specified'
=> '役割は指定されていません',

   'No upload file specified.'
=> 'アップロードするファイルを指定していません。',

   'No write permission to user directory, FAIL'
=> '書き込み権限がありません、失敗しました',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> '注意：すべてのユーザに変更の結果が行き渡るのに１０分位かかります。',

   'Notes'
=> '（注）',

   'Open, no due date'
=> '締め切りなし',

   'Page'
=> 'ページ',

   'Part'
=> 'パート',

   'Part is not open to be viewed. It'
=> 'パートがオープンされていません。',

   'Path'
=> 'パス',

   'Please use browser "Back" button and pick a filename'
=> 'ブラウザの"戻る"ボタンで戻って、ファイル名を指定してください',

   'Processing'
=> '処理中',

   'Re-Initialize'
=> '再度初期化する',

   'Remark'
=> '再度採点する',

   'Rename'
=> 'リネームする',

   'Save'
=> '保存する',

   'Saving Modifications to'
=> '変更を保存する：',

   'Search'
=> '検索する',

   'Searching'
=> '検索中',

   'Section/Group'
=> '章／グループ',

   'Select'
=> '選択する',

   'Select Course'
=> 'コースを選択する',

   'Select User'
=> 'ユーザを選択する',

   'Select a'
=> '選択する：',

   'Select the Construction Space'
=> 'コンストラクション・スペースを選択する',

   'Sequence'
=> 'シーケンス',

   'Server Administration'
=> 'サーバ管理',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> '締め切りを設定し、その他の試験のパラメータ、コース環境を変更します',

   'Show Only Uncompleted Homework'
=> '完了していない宿題のみ表示する',

   'Simple Page'
=> 'シンプルページ',

   'Simple Problem'
=> 'シンプル問題',

   'Special Documents'
=> '特別ドキュメント',

   'Start'
=> 'スタート',

   'Status'
=> '状態',

   'Store uploaded file as '
=> 'アップロードされたファイルを保存する：',

   'Submit'
=> '提出する',

   'Submit Changes'
=> '変更を保存する',

   'Submit Changes and View'
=> '変更を保存して結果を見る',

   'Supplemental Course Documents'
=> '補助教材',

   'Switch Server'
=> 'サーバを切替える',

   'System'
=> 'システム',

   'System Administration'
=> 'システム管理',

   'The target is an existing directory.'
=> 'ディレクトリは存在しています。',

   'Then'
=> 'それから',

   'Title'
=> 'タイトル',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'ネットワークの障害のため、このリソースが締め切りなしかどうか決定できません。後でもう一度試してください。',

   'Unable to find'
=> '見つかりません',

   'Unable to make backup'
=> 'バックアップを作成できません',

   'Unable to undo, unable to switch'
=> '取り消し、切替えることが出来ません',

   'Unable to write to'
=> '書き込むことが出来ません：',

   'Uncompleted Homework'
=> '完成していない宿題',

   'Undid changes, Switched'
=> '変更をキャンセルし、切り替えました',

   'Upload Document'
=> 'ドキュメントをアップロードする',

   'Uploaded Document'
=> 'ドキュメントをアップロードしました',

   'User Role'
=> '役割',

   'View All Messages'
=> 'すべてのメッセージを見る',

   'View course assessment statistics'
=> 'コースのテストの統計を見る',

   'Was due'
=> 'は締め切りになりました',

   'Yes'
=> 'はい',

   'You did not select a template.'
=> 'テンプレートを選択していませんでした。',

   'You do not have authoring privileges for this resource'
=> 'このコースの編集権限を持っていません。',

   'You have no unread messages'
=> '未読メッセージはありません',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'an indeterminate date'
=> '中間締め切り',

   'an unknown date'
=> '？？？？／？？／？？',

   'contents'
=> 'コンテンツ',

   'could not be copied.'
=> 'コピーできません。',

   'is closed but you are allowed to view it'
=> '締め切られましたが見ることは出来ます',

   'is due at'
=> 'の締切りは',

   'is in under construction'
=> 'は作成中です',

   'is not analyzable at this time'
=> 'は現在分析できません',

   'last month'
=> '先月',

   'last problem'
=> '最後の問題',

   'last six months'
=> 'この６ヶ月',

   'last three months'
=> 'この３ヶ月',

   'last week'
=> '先週',

   'last year'
=> '昨年',

   'may open later.'
=> 'は後で公開されます。',

   'never'
=> '決して',

   'not displayed'
=> '表示されません',

   're-initializing course'
=> '再度初期化されたコース',

   'system wide'
=> 'システム全体',

   'today'
=> '今日',

   'undo'
=> 'やり直し',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'was due on'
=> 'は締め切られました：',

   'will open on'
=> 'は公開されます：',

#SYNC Fri Sep 26 16:57:10 2003
   ', is reserved internally by LON-CAPA.'
=> ',はＬＯＮ－ＣＡＰＡの内部で予約されています。',

   'Back to'
=> '戻る⇒',

   'Back to Source'
=> 'ソースへ戻る',

   'Back to Source Directory'
=> 'ソースディレクトリに戻る',

   'Became this version on ...'
=> 'このバージョンになったのは ...',

   'Browse published resources'
=> '公開されたリソースを見る',

   'Choose the course to work on'
=> 'コースを稼動させるために選択する',

   'Create a new course'
=> '新しいコースを作成する',

   'Customized right of use ...	'
=> '使用権限をカスタマイズする ...	',

   'Delete messages from bulletin boards'
=> '掲示板からメッセージを削除する',

   'Domain only - use limited to courses in the domain'
=> 'フォメイン限定 － ドメインを限定してコースを使う',

   'Dynamic Metadata'
=> 'ダイナミック・メタデータ',

   'Edit and view documents included in this course'
=> 'このコースに含まれているドキュメントを編集・閲覧する',

   'Edit/Modify DOCS'
=> '編集 DOCS',

   'Enter my resource construction space'
=> '自分のコンストラクション・スペースに入る',

   'FAIL'
=> '失敗',

   'Failed to copy source'
=> 'ソースをコピーすることに失敗しました',

   'Failed to write metadata copy'
=> 'メタデータを書き込むことに失敗しました',

   'File copied.'
=> 'ファイルをコピーしました。',

   'Finalize Publication'
=> '出版を完結する',

   'Grant/revoke role of Co-Author'
=> '共同作成者の役割を付与／剥奪する',

   'Grant/revoke role of Domain Coordinator'
=> 'ドメイン管理者の役割を付与／剥奪する',

   'Grant/revoke role of Exam Proctor'
=> '試験官の役割を付与／剥奪する',

   'Grant/revoke role of Instructor'
=> 'インストラクタの役割を付与／剥奪する',

   'Grant/revoke role of Student'
=> '学生の役割を付与／剥奪する',

   'Grant/revoke role of Superuser'
=> 'スーパーユーザの役割を付与／剥奪する',

   'Illegal filename.'
=> '禁止されたファイル名です。',

   'Name starting with'
=> '次の名前で始まる：',

   'No previous versions published.'
=> '以前のバージョンはありません。',

   'No write permission to'
=> '書き込み権限はありません：',

   'Please pick a version to retrieve'
=> '取り出すバージョンを選んでください',

   'Private - visible to author only for testing purposes'
=> '非公開 － 作成中で作成者にしか見えない',

   'Private Publication - did not synchronize database'
=> '非公開 － データベースと同期しません',

   'Public - no authentication or authorization required for use'
=> '公開 － 認証や認可無しに使用できます',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> '古いバージョンを取り込むと、現在コンストラクション・スペースにあるファイルを上書きします',

   'Retrieve previous versions of'
=> '前のバージョンを取り出す：',

   'Retrieve version'
=> 'バージョンを取り出す',

   'Rule'
=> '役割',

   'Search the contents of this course'
=> 'コースコンテンツを検索する',

   'Search the database of published resources'
=> '公開されたリソースのデータベースを検索する',

   'Send broadcast and receipt-required email'
=> 'ブロードキャストや受信確認要求のあるメールを送る',

   'Show Problem Completeness'
=> '問題の完全性を見る',

   'Switch to another course'
=> '他のコースに切り替える',

   'System wide - can be used for any courses system wide'
=> 'システム全体 － システム全体のコースを使用することができる',

   'System wide - open source to all authors'
=> 'システム全体 － ソースをすべての作成者に公開する',

   'The extension on this file'
=> 'このファイルの拡張子',

   'This resource has been marked obsolete by the author(s)'
=> 'このリソースは採点されました',

   'Unsupported character combination'
=> 'サポートされていない文字の組合せです',

   'Uploaded'
=> 'アップロードしました',

   'Users with Roles Assigned by'
=> '次の役割を持ったユーザ：',

   'View documents included in this course'
=> 'このコースの中のドキュメントを見る',

   'View file'
=> 'ファイルを閲覧する',

   'untitled'
=> '無題',

#SYNC Sun Sep 28 12:06:11 2003
   'Additional Keywords'
=> '追加のキーワード',

   'Additional Metadata (non-standard, parameters, exports)'
=> '追加のメタデータ (非標準, パラメータ, エキスポート)',

   'All versions'
=> 'すべてのバージョン',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> '作成者と共同作成者の役割はホームサーバ以外では提供されません。',

   'Author(s)'
=> '著者',

   'Average number of tries till solved'
=> '正解までの平均受験回数',

   'Browse Resources'
=> 'リソースを見る',

   'Catalog Information'
=> 'カタログ情報',

   'Collapse Remote Control'
=> 'リモコン・パネルを消します',

   'Construction Space'
=> 'コンストラクション・スペース',

   'Content changed'
=> 'コンテンツが変更されました',

   'Copied metadata'
=> 'メタデータはコピーされました',

   'Copied source file'
=> 'ファイルはコピーされました',

   'Copyright/Distribution'
=> '著作権／ディストリビューション',

   'Could not write metadata'
=> 'メタデータを書き込めませんでした',

   'Course Documents'
=> 'コースドキュメント',

   'Creation Date'
=> '作成日',

   'Custom Distribution File'
=> '配布するファイルをカスタマイズする',

   'Default Cataloging Information for Directory'
=> 'デフォルトのディレクトリ用カタログ情報',

   'Degree of difficulty'
=> '困難度',

   'Differences'
=> '違い',

   'Dump Course DOCS to Construction Space'
=> 'コンストラクション・スペースにＤＯＣＳをダンプする',

   'Entering course ...'
=> 'コースに入る ...',

   'Error Messages'
=> 'エラーメッセージ',

   'Exam Information'
=> '試験情報',

   'External Resource'
=> '外部リソース',

   'Generate new role ...'
=> '新しい役割を生成する ...',

   'Go to the next resource in the course sequence'
=> 'このコースのシーケンス上の次のリソースに進む',

   'Go to the previous resource in the course sequence'
=> 'このコースのシーケンス上の前のリソースに戻る',

   'Import a published document'
=> '公開されているドキュメントをインポートする',

   'Keyword(s)'
=> 'キーワード',

   'Last Week'
=> '先週',

   'Load Map'
=> 'マップをロードする',

   'Logged Out'
=> 'ログアウトしました',

   'MIME Type'
=> 'ＭＩＭＥタイプ',

   'Make notes and annotations about this resource'
=> 'このリソースのノートを取ります',

   'Material appears to be correct'
=> '素材は正しく思えます',

   'Material covered with sufficient depth'
=> '素材は充分にカバーしています',

   'Material is helpful'
=> '素材は助けになります',

   'Material presented in clear way'
=> '素材は明瞭な方法で示されています',

   'Metadata Information'
=> 'メタデータ情報',

   'Modification Date'
=> '変更日付',

   'My Personal Info'
=> '個人情報',

   'Network-wide number of accesses (hits)'
=> 'ネットワーク全体のアクセス(ヒット数)',

   'Network-wide number of courses using resource'
=> 'リソースを使用しているネットワーク全体のコースの数',

   'Number of resources that follow this resource in maps'
=> 'マップの中でこのリソースに従っているリソースの数',

   'Number of resources that lead up to this resource in maps'
=> 'マップの中でこのリソースに従えているリソースの数',

   'Number of resources using or importing resource'
=> 'このリソースを使っている／インポートしているリソースの数',

   'Obsolete'
=> '旧',

   'Parent Directory'
=> '親ディレクトリ',

   'Please either'
=> 'どちらも',

   'Project Information'
=> 'プロジェクト情報',

   'Publisher/Owner'
=> '出版社／所有者',

   'Publishing'
=> '公開',

   'Resource Publication'
=> 'リソースを公開する',

   'Resource is technically correct'
=> 'リソースは技術的に正しい',

   'Score Upload Form'
=> 'アップロードされたフォームの得点',

   'Select Map'
=> 'マップを選択する',

   'Set a bookmark for this resource'
=> 'このリソースのブックマークをセットする',

   'Show all roles'
=> '役割をすべて表示する',

   'Since Start of Course'
=> 'コースの最初から',

   'Since Yesterday'
=> '昨日から',

   'Special documents'
=> '特別教材',

   'Store Catalog Information'
=> 'カタログ情報を保存する',

   'Subject'
=> '表題',

   'Successful Login'
=> '正常にログインしました',

   'Suggested Replacement for Obsolete File'
=> '古いファイルの置換えを薦めます',

   'Switching Role'
=> '役割を切替える',

   'Target'
=> 'ターゲット',

   'This syllabus can be publicly viewed at'
=> 'このシラバスは次の場所で公開されます：',

   'Total number of students who have worked on this problem'
=> 'この問題の全受験者数',

   'URLs To Include in Syllabus'
=> 'シラバスに含むＵＲＬ',

   'Update Display'
=> '表示を更新する',

   'Upload a new main course document'
=> '新しいメイン・コースドキュメントをアップロードする',

   'Upload a new supplemental course document'
=> '新しい補助教材をアップロードする',

   'User'
=> 'ユーザ',

   'Verify Course Documents'
=> 'コースドキュメントをべリファイしました',

   'Version'
=> 'バージョン',

   'Wrote Metadata'
=> 'メタデータを書き込みました',

   'Your home server is '
=> 'ホームサーバは：',

   'access denied'
=> 'アクセスは拒否されました',

   'anno-'
=> 'アノ',

   'announce'
=> 'お知らせ',

   'backward'
=> '後',

   'bookmark'
=> 'ブックマーク',

   'chart'
=> '図',

   'chat'
=> 'チャット',

   'close this window'
=> 'ウィンドウを閉じる',

   'con-'
=> 'con-',

   'connection down'
=> '接続が切れました',

   'docs'
=> 'docs',

   'during the last'
=> '前',

   'edit crs'
=> 'コースを編集',

   'exit'
=> '終了',

   'fas'
=> 'fas',

   'forward'
=> '次へ',

   'library'
=> 'ライブラリ',

   'log in again'
=> '再度ログインしてください',

   'my'
=> '私の',

   'not found'
=> '見つかりません',

   'or'
=> 'または',

   'parms'
=> 'パラメータ',

   'prepare'
=> '準備する',

   'printout'
=> '印刷する',

   'resource'
=> 'リソース',

   'roles'
=> '役割',

   'search'
=> '検索する',

   'set'
=> 'セットする',

   'space'
=> 'スペース',

   'stats'
=> '状態',

   'struct'
=> '作成する',

   'switch'
=> '切替える',

   'tations'
=> 'テーション',

   'updated periodically'
=> '周期的に更新されます',

   'user'
=> 'ユーザ',

   'visible to author and co-authors only'
=> '作成者と共同作成者に限り見ることが出来ます',

   'warning(s)'
=> '警告',

   "Click to download or use your browser's Save Link function"
=> "Click to download or use your browser's Save Link function",


#SYNC Thu Nov 27 21:01:54 2003
   '#Stdnts'
=> '#Stdnts (1)',

   '#YES'
=> '#YES (2)',
# #はい
   '%Wrng'
=> '%Wrng (3)',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Show&nbsp;All&nbsp;Foils (4)',

   '. . . for a particular section'
=> '. . . for a particular section (5)',
# . . . fまたは a パートicular section
   '. . . for all students in the course'
=> '. . . for all students in the course (6)',
# . . . fまたは all 学生s in the コース
   '. . . for an individual student'
=> '. . . for an individual student (7)',
# . . . fまたは an individual 学生
   '1 am'
=> '1 am (8)',

   '1 out of N multiple choice (radio button)'
=> '1 out of N multiple choice (radio button) (9)',

   '1 pm'
=> '1 pm (10)',

   '10 am'
=> '10 am (11)',

   '10 pm'
=> '10 pm (12)',

   '11 am'
=> '11 am (13)',

   '11 pm'
=> '11 pm (14)',

   '12 am'
=> '12 am (15)',

   '12 noon'
=> '12 noon (16)',

   '2 am'
=> '2 am (17)',

   '2 pm'
=> '2 pm (18)',

   '3 am'
=> '3 am (19)',

   '3 pm'
=> '3 pm (20)',

   '4 am'
=> '4 am (21)',

   '4 pm'
=> '4 pm (22)',

   '5 am'
=> '5 am (23)',

   '5 pm'
=> '5 pm (24)',

   '6 am'
=> '6 am (25)',

   '6 pm'
=> '6 pm (26)',

   '7 am'
=> '7 am (27)',

   '7 pm'
=> '7 pm (28)',

   '8 am'
=> '8 am (29)',

   '8 pm'
=> '8 pm (30)',

   '9 am'
=> '9 am (31)',

   '9 pm'
=> '9 pm (32)',

   '<- Previous'
=> '<- Previous (33)',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Unable to enroll: [_2] (34)',
# <b>[_1]</b>:  Unable to 出席: [_2]
   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Unable to enroll.  No password specified. (35)',
# <b>[_1]</b>: Unable to 出席.  No passwまたはd specified.
   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5] (36)',
# <b>[_1]</b>: Unacceptable ユーザ名前 fまたは ユーザ [_2] [_3] [_4] [_5]
   'ALL'
=> 'ALL (37)',

   'About Me'
=> 'About Me (38)',

   'Access Key Management'
=> 'Access Key Management (39)',

   'Add new option'
=> 'Add new option (40)',

   'Additional Recipients'
=> 'Additional Recipients (41)',

   'Administrator'
=> 'Administrator (42)',
# Administratまたは
   'Advanced Catalog Search'
=> 'Advanced Catalog Search (43)',
# Advanced Catalog 検索する
   'Advanced Search'
=> 'Advanced Search (44)',
# Advanced 検索する
   'All Documents in Course'
=> 'All Documents in Course (45)',
# All Documents in コース
   'All Maps or Folders'
=> 'All Maps or Folders (46)',
# All マップs または Folders
   'All Resources (possibly large output)'
=> 'All Resources (possibly large output) (47)',
# All リソースs (possibly large output)
   'Analyze Over '
=> 'Analyze Over  (48)',

   'Analyze Problem'
=> 'Analyze Problem (49)',

   'Analyze Problem Again'
=> 'Analyze Problem Again (50)',

   'Analyze as '
=> 'Analyze as  (51)',

   'Anonymous'
=> 'Anonymous (52)',

   'Anonymous contribution to course discussion of resource'
=> 'Anonymous contribution to course discussion of resource (53)',
# Anonymous contribution to コース discussion of リソース
   'Answer:'
=> 'Answer: (54)',
# 回答:
   'Any Language'
=> 'Any Language (55)',
# Any 言語
   'Any User'
=> 'Any User (56)',
# Any ユーザ
   'Any category'
=> 'Any category (57)',
# Any categまたはy
   'Any copyright/distribution'
=> 'Any copyright/distribution (58)',
# Any 著作権／ディストリビューション
   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem). (59)',
# As a general 役割, only authまたはs または co-authまたはs should be ファイルシステム auそれからticated (which allows access to the サーバ ファイルシステム).
   'Assessment'
=> 'Assessment (60)',

   'Assessment URL and Title'
=> 'Assessment URL and Title (61)',
# Assessment URL and タイトル
   'Assigned User Roles'
=> 'Assigned User Roles (62)',
# Assigned ユーザ 役割
   'Associate columns with student attributes.'
=> 'Associate columns with student attributes. (63)',
# Associate columns with 学生 attributes.
   'Attachment'
=> 'Attachment (64)',

   'Attribute'
=> 'Attribute (65)',

   'Brief view of each students performance in course.'
=> 'Brief view of each students performance in course. (66)',
# Brief 閲覧 of each 学生s perfまたはmance in コース.
   'Broadcast Message to Course'
=> 'Broadcast Message to Course (67)',
# Broadcast Message to コース
   'Browse resources'
=> 'Browse resources (68)',
# Browse リソースs
   'Browsing resource, all submissions are temporary.'
=> 'Browsing resource, all submissions are temporary. (69)',
# Browsing リソース, all submissions are tempまたはary.
   'Bulletin Board/Discussion'
=> 'Bulletin Board/Discussion (70)',
# 掲示板/Discussion
   'By'
=> 'By (71)',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (comma separated values, spreadsheet) (72)',

   'Calculate answers'
=> 'Calculate answers (73)',
# Calculate 回答s
   'Calculations'
=> 'Calculations (74)',

   'Change'
=> 'Change (75)',

   'Change Random Seed To:'
=> 'Change Random Seed To: (76)',

   'Change Your Language Preferences'
=> 'Change Your Language Preferences (77)',
# Change Your 言語 Prefer設定
   'Changes can take up to 10 minutes before being active for all students.'
=> 'Changes can take up to 10 minutes before being active for all students. (78)',
# Changes can take up to 10 minutes befまたはe being active fまたは all 学生s.
   'Check All'
=> 'Check All (79)',

   'Check Course Document Versions'
=> 'Check Course Document Versions (80)',
# Check コース Document バージョンs
   'Check for All'
=> 'Check for All (81)',
# Check fまたは All
   'Check for None'
=> 'Check for None (82)',
# Check fまたは None
   'Check for Section/Group'
=> 'Check for Section/Group (83)',
# Check fまたは 章／グループ
   'Check/Set Resource Versions'
=> 'Check/Set Resource Versions (84)',
# Check/セットする リソース バージョンs
   'Choose a different resource'
=> 'Choose a different resource (85)',
# 選択 a different リソース
   'Chronological View'
=> 'Chronological View (86)',
# Chronological 閲覧
   'Clear All'
=> 'Clear All (87)',

   'Clear Caches'
=> 'Clear Caches (88)',

   'Close'
=> 'Close (89)',

   'Close All Folders'
=> 'Close All Folders (90)',

   'Column'
=> 'Column (91)',

   'Column&nbsp;[_1]'
=> 'Column&nbsp;[_1] (92)',

   'Comma Separated Values'
=> 'Comma Separated Values (93)',

   'Compact View'
=> 'Compact View (94)',
# Compact 閲覧
   'Concept:'
=> 'Concept: (95)',

   'Concepts'
=> 'Concepts (96)',

   'Construction Space File Operation'
=> 'Construction Space File Operation (97)',
# Con作成するion スペース ファイル Operation
   'Contact Information'
=> 'Contact Information (98)',
# コンタクト Infまたはmation
   'Continue enrollment?'
=> 'Continue enrollment? (99)',
# Continue 出席ment?
   'Contribution to course discussion of resource'
=> 'Contribution to course discussion of resource (100)',
# Contribution to コース discussion of リソース
   'Copied old metadata'
=> 'Copied old metadata (101)',

   'Copied old target file'
=> 'Copied old target file (102)',
# Copied old ターゲット ファイル
   'Copyright'
=> 'Copyright (103)',

   'Correct Option:'
=> 'Correct Option: (104)',
# Cまたはrect Option:
   'Could Not Process Request'
=> 'Could Not Process Request (105)',

   'Course Assessment Parameter - Helper Mode'
=> 'Course Assessment Parameter - Helper Mode (106)',
# コース Assessment Parameter - ヘルプer Mode
   'Course Assessment Parameters - Overview Mode'
=> 'Course Assessment Parameters - Overview Mode (107)',
# コース Assessment Parameters - Over閲覧 Mode
   'Course Assessments Parameters - Table Mode'
=> 'Course Assessments Parameters - Table Mode (108)',
# コース Assessments Parameters - Table Mode
   'Course Environment Parameters'
=> 'Course Environment Parameters (109)',
# コース Environment Parameters
   'Course ID'
=> 'Course ID (110)',
# コース ID
   'Course Parameter Helper'
=> 'Course Parameter Helper (111)',
# コース Parameter ヘルプer
   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time. (112)',
# コース Statistics and 図s cannot be retrieved until the database is reスタートed.  Your data is intact but cannot be 表示するed at this time.
   'Course level sheet'
=> 'Course level sheet (113)',
# コース level sheet
   'Create New Environment Variable'
=> 'Create New Environment Variable (114)',
# 作成 New Environment Variable
   'Create a New Course'
=> 'Create a New Course (115)',
# 作成 a New コース
   'Critical Messages'
=> 'Critical Messages (116)',

   'Current'
=> 'Current (117)',

   'Current Session Value'
=> 'Current Session Value (118)',

   'Default'
=> 'Default (119)',

   'Default Value'
=> 'Default Value (120)',

   'Delete'
=> 'Delete (121)',

   'Delete Checked'
=> 'Delete Checked (122)',

   'Delete a role'
=> 'Delete a role (123)',
# Delete a 役割
   'Delete an option'
=> 'Delete an option (124)',

   'Delete:'
=> 'Delete: (125)',

   'Detailed Citation View'
=> 'Detailed Citation View (126)',
# Detailed Citation 閲覧
   'Detailed Problem Analysis'
=> 'Detailed Problem Analysis (127)',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Detailed statistics and graphs of student performance on problems. (128)',
# Detailed statistics and graphs of 学生 perfまたはmance on problems.
   'Diffs'
=> 'Diffs (129)',

   'Diffs with Current Version'
=> 'Diffs with Current Version (130)',
# Diffs with Current バージョン
   'Diffs with Version'
=> 'Diffs with Version (131)',
# Diffs with バージョン
   'Diffs with current Version'
=> 'Diffs with current Version (132)',
# Diffs with current バージョン
   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing) (133)',
# Disable ID/学生 Number Safeguard and Fまたはce Change of Conflicting IDs (only do if you know what you are doing)
   'Disable all communication among students'
=> 'Disable all communication among students (134)',
# Disable all commuケーション a月g 学生s
   'Discard Selected'
=> 'Discard Selected (135)',
# Discard 選択するed
   'Discussion Contributions'
=> 'Discussion Contributions (136)',

   'Display All Messages'
=> 'Display All Messages (137)',
# 表示する All Messages
   'Display all Messages'
=> 'Display all Messages (138)',
# 表示する all Messages
   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments. (139)',
# 表示する and analysis of submission times on assessments.
   'Display foils in order given'
=> 'Display foils in order given (140)',
# 表示する foils in またはder given
   'Display foils in random order'
=> 'Display foils in random order (141)',
# 表示する foils in random またはder
   'Distribute Messages from Uploaded File to Course'
=> 'Distribute Messages from Uploaded File to Course (142)',
# Distribute Messages from アップロードしました ファイル to コース
   'DoDiff'
=> 'DoDiff (143)',

   'Domain Guest'
=> 'Domain Guest (144)',
# ドメイン Guest
   'Drop Students'
=> 'Drop Students (145)',
# Drop 学生s
   'Dropped [_1]'
=> 'Dropped [_1] (146)',

   'Dropped [_1] student(s).'
=> 'Dropped [_1] student(s). (147)',
# Dropped [_1] 学生(s).
   'Dropping Students'
=> 'Dropping Students (148)',
# Dropping 学生s
   'Due'
=> 'Due (149)',

   'Dump Course DOCS'
=> 'Dump Course DOCS (150)',
# Dump コース docs
   'EMail Address'
=> 'EMail Address (151)',

   'EMail and Messages'
=> 'EMail and Messages (152)',

   'Edit Catalog Information'
=> 'Edit Catalog Information (153)',
# 編集 Cataログインfまたはmation
   'Edit Content of a Map'
=> 'Edit Content of a Map (154)',
# 編集 Content of a マップ
   'Edit Directory Catalog Information'
=> 'Edit Directory Catalog Information (155)',
# 編集 Directまたはy Cataログインfまたはmation
   'Edit this resource'
=> 'Edit this resource (156)',
# 編集 this リソース
   'Enclosing Map or Folder'
=> 'Enclosing Map or Folder (157)',
# Enclosing マップ または Folder
   'End Helper'
=> 'End Helper (158)',
# 終了 ヘルプer
   'English - ISO'
=> 'English - ISO (159)',

   'Enroll a single student'
=> 'Enroll a single student (160)',
# 出席 a single 学生
   'Enrolling Students'
=> 'Enrolling Students (161)',
# 出席ing 学生s
   'Enrollment Status'
=> 'Enrollment Status (162)',
# 出席ment 状態
   'Enter construction space as a co-author'
=> 'Enter construction space as a co-author (163)',
# 入力 con作成するion スペース as a co-authまたは
   'Error'
=> 'Error (164)',
# Errまたは
   'Error dropping [_1]:[_2]'
=> 'Error dropping [_1]:[_2] (165)',
# Errまたは dropping [_1]:[_2]
   'Essay, open end'
=> 'Essay, open end (166)',
# Essay, open 終了
   'Evaluate Resource'
=> 'Evaluate Resource (167)',
# Evaluate リソース
   'Excel'
=> 'Excel (168)',

   'Failed Access to Construction Space'
=> 'Failed Access to Construction Space (169)',
# 失敗ed Access to Con作成するion スペース
   'False'
=> 'False (170)',

   'Field'
=> 'Field (171)',

   'Fielded Format'
=> 'Fielded Format (172)',
# Fielded Fまたはmat
   'File Category'
=> 'File Category (173)',
# ファイル Categまたはy
   'Filenames in Construction Space'
=> 'Filenames in Construction Space (174)',
# ファイル名前s in Con作成するion スペース
   'Finish Course Initialization'
=> 'Finish Course Initialization (175)',
# Finish コース Initialization
   'First Name'
=> 'First Name (176)',
# First 名前
   'Foil'
=> 'Foil (177)',

   'Foils'
=> 'Foils (178)',

   'Folder'
=> 'Folder (179)',

   'Folder in Construction Space'
=> 'Folder in Construction Space (180)',
# Folder in Con作成するion スペース
   'For User'
=> 'For User (181)',
# Fまたは ユーザ
   'Force publication of unmodified files'
=> 'Force publication of unmodified files (182)',
# Fまたはce publication of unmodified ファイルs
   'Format:'
=> 'Format: (183)',
# Fまたはmat:
   'Forward'
=> 'Forward (184)',
# Fまたはward
   'Forwarded message from'
=> 'Forwarded message from (185)',
# Fまたはwarded message from
   'Forwarding'
=> 'Forwarding (186)',
# Fまたはwarding
   'From'
=> 'From (187)',

   'Full Update'
=> 'Full Update (188)',
# Full Up日付
   'Full update (also print list of users not enrolled anymore)'
=> 'Full update (also print list of users not enrolled anymore) (189)',
# Full up日付 (also print list of ユーザs not 出席ed anymまたはe)
   'Functions'
=> 'Functions (190)',

   'Generate Spreadsheet'
=> 'Generate Spreadsheet (191)',

   'Generate Statistics'
=> 'Generate Statistics (192)',

   'Generation'
=> 'Generation (193)',

   'German - ISO'
=> 'German - ISO (194)',

   'Grant/revoke Course Custom Role'
=> 'Grant/revoke Course Custom Role (195)',
# Grant/revoke コース Custom 役割
   'Grant/revoke role of Administrator'
=> 'Grant/revoke role of Administrator (196)',
# Grant/revoke 役割 of Administratまたは
   'Grant/revoke role of Author'
=> 'Grant/revoke role of Author (197)',
# Grant/revoke 役割 of Authまたは
   'Grant/revoke role of Course Coordinator'
=> 'Grant/revoke role of Course Coordinator (198)',
# Grant/revoke 役割 of コース Coまたはdinatまたは
   'Grant/revoke role of Domain Guest'
=> 'Grant/revoke role of Domain Guest (199)',
# Grant/revoke 役割 of ドメイン Guest
   'Grant/revoke role of Librarian'
=> 'Grant/revoke role of Librarian (200)',
# Grant/revoke 役割 of Librarian
   'Grant/revoke role of Scantron Operator'
=> 'Grant/revoke role of Scantron Operator (201)',
# Grant/revoke 役割 of Scantron Operatまたは
   'Grant/revoke role of Teaching Assistant'
=> 'Grant/revoke role of Teaching Assistant (202)',
# Grant/revoke 役割 of ＴＡ
   'Group/Section'
=> 'Group/Section (203)',

   'HTML'
=> 'HTML (204)',

   'HTML/XML'
=> 'HTML/XML (205)',

   'Height(pixel):'
=> 'Height(pixel): (206)',

   'Hide'
=> 'Hide (207)',

   'Hint Text'
=> 'Hint Text (208)',

   'Host'
=> 'Host (209)',

   'ID/Student Number'
=> 'ID/Student Number (210)',
# ID/学生 Number
   'Identify fields'
=> 'Identify fields (211)',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA. (212)',
# If active, the new 役割 will be available when the 学生s next ログイン to LON-CAPA.
   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible. (213)',
# If this リソース is in active use, 学生 perfまたはmance data from the previous バージョン ５月 become inaccessible.
   'Ignore First Line'
=> 'Ignore First Line (214)',
# Ignまたはe First Line
   'Image:'
=> 'Image: (215)',

   'Incorrect Answers:'
=> 'Incorrect Answers: (216)',
# Incまたはrect 回答s:
   'Initial Password'
=> 'Initial Password (217)',
# Initial Passwまたはd
   'Internal Filename'
=> 'Internal Filename (218)',
# Internal ファイル名前
   'Internally authenticated'
=> 'Internally authenticated (219)',
# Internally auそれからticated
   'Invalid date entry'
=> 'Invalid date entry (220)',
# Invalid 日付 entry
   'Invalid home server specified'
=> 'Invalid home server specified (221)',
# Invalid home サーバ specified
   'Japanese - UTF'
=> 'Japanese - UTF (222)',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default) (223)',
# Keep all リソースs up-to-日付 with most recent バージョンs (default)
   'Kerberos authenticated'
=> 'Kerberos authenticated (224)',
# Kerberos auそれからticated
   'Keywords'
=> 'Keywords (225)',
# Keywまたはds
   'LON-CAPA Domain for Students'
=> 'LON-CAPA Domain for Students (226)',
# LON-CAPA ドメイン fまたは 学生s
   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager (227)',
# LON-CAPA 出席ment Manager
   'LON-CAPA Helper:'
=> 'LON-CAPA Helper: (228)',
# LON-CAPA ヘルプer:
   'LON-CAPA domain: [_1]'
=> 'LON-CAPA domain: [_1] (229)',
# LON-CAPA ドメイン: [_1]
   'Last Name'
=> 'Last Name (230)',
# Last 名前
   'Last Name, First Names'
=> 'Last Name, First Names (231)',
# Last 名前, First 名前s
   'Last access'
=> 'Last access (232)',

   'Last accessed'
=> 'Last accessed (233)',

   'Last modified'
=> 'Last modified (234)',
# 最終変更
   'Last updated'
=> 'Last updated (235)',
# Last up日付d
   'Librarian'
=> 'Librarian (236)',

   'Limit by copyright/distribution'
=> 'Limit by copyright/distribution (237)',
# Limit by 著作権／ディストリビューション
   'Limit by language'
=> 'Limit by language (238)',
# Limit by 言語
   'Load:'
=> 'Load: (239)',
# 負荷:
   'Lock and unlock assessments'
=> 'Lock and unlock assessments (240)',

   'Login Type'
=> 'Login Type (241)',

   'Mail'
=> 'Mail (242)',

   'Making Backup to'
=> 'Making Backup to (243)',

   'Manage Access Keys'
=> 'Manage Access Keys (244)',

   'Manage access keys'
=> 'Manage access keys (245)',

   'Mark Unread'
=> 'Mark Unread (246)',

   'Max Number Of Shown Foils:'
=> 'Max Number Of Shown Foils: (247)',

   'Max Possible To Date'
=> 'Max Possible To Date (248)',
# Max Possible To 日付
   'Max Tries'
=> 'Max Tries (249)',
# Max 受験回数
   'Max number of foils displayed'
=> 'Max number of foils displayed (250)',
# Max number of foils 表示するed
   'Mean Tries'
=> 'Mean Tries (251)',
# Mean 受験回数
   'Metadata'
=> 'Metadata (252)',

   'Metadata Version'
=> 'Metadata Version (253)',
# Metadata バージョン
   'Metadata current version'
=> 'Metadata current version (254)',
# Metadata current バージョン
   'Middle Names/Initials'
=> 'Middle Names/Initials (255)',
# Middle 名前s/Initials
   'Mime type'
=> 'Mime type (256)',
# ＭＩＭＥタイプ
   'Modified'
=> 'Modified (257)',

   'Modify Course Assessment Parameters'
=> 'Modify Course Assessment Parameters (258)',
# Modify コース Assessment Parameters
   'Modify Parameters'
=> 'Modify Parameters (259)',

   'Modify authentication mechanism and data for a user'
=> 'Modify authentication mechanism and data for a user (260)',
# Modify auそれからtication mechanism and data fまたは a ユーザ
   'Modify deadlines, etc, for this assessment resource'
=> 'Modify deadlines, etc, for this assessment resource (261)',
# Modify 締め切り, etc, fまたは this assessment リソース
   'Modify grades'
=> 'Modify grades (262)',
# Modify 成績
   'Modify student data'
=> 'Modify student data (263)',
# Modify 学生 data
   'Modify user grades for this assessment resource'
=> 'Modify user grades for this assessment resource (264)',
# Modify ユーザ 成績 fまたは this assessment リソース
   'Most recently published Version'
=> 'Most recently published Version (265)',
# Most recently published バージョン
   'Move Down'
=> 'Move Down (266)',

   'Move Up'
=> 'Move Up (267)',

   'Name:'
=> 'Name: (268)',
# 名前:
   'New Problem Variation'
=> 'New Problem Variation (269)',

   'New Randomization'
=> 'New Randomization (270)',

   'New Title'
=> 'New Title (271)',
# New タイトル
   'New parameters or stored values'
=> 'New parameters or stored values (272)',
# New parameters または stまたはed values
   'Next'
=> 'Next (273)',

   'Next ->'
=> 'Next -> (274)',

   'No Kerberos domain was specified.'
=> 'No Kerberos domain was specified. (275)',
# No Kerberos ドメイン was specified.
   'No changes were made to the current settings.'
=> 'No changes were made to the current settings. (276)',
# No changes were made to the current セットするtings.
   'No language preference'
=> 'No language preference (277)',
# No 言語 preference
   'None Found'
=> 'None Found (278)',

   'Not shown, not used'
=> 'Not shown, not used (279)',

   'Note: for large courses, this operation may be time consuming'
=> 'Note: for large courses, this operation may be time consuming (280)',
# Note: fまたは large コースs, this operation ５月 be time consuming
   'Note: this will not take effect if the user already exists'
=> 'Note: this will not take effect if the user already exists (281)',
# Note: this will not take effect if the ユーザ already exists
   'Number of Plots:'
=> 'Number of Plots: (282)',

   'Obsolete parameters or stored values'
=> 'Obsolete parameters or stored values (283)',
# 旧 parameters または stまたはed values
   'Open'
=> 'Open (284)',

   'Open All Folders'
=> 'Open All Folders (285)',

   'Option Response Problem Analysis'
=> 'Option Response Problem Analysis (286)',

   'Option response'
=> 'Option response (287)',

   'Output'
=> 'Output (288)',

   'Output Format'
=> 'Output Format (289)',
# Output Fまたはmat
   'Overall Problem Statistics'
=> 'Overall Problem Statistics (290)',

   'Owner/Publisher'
=> 'Owner/Publisher (291)',

   'Parameter Name'
=> 'Parameter Name (292)',
# Parameter 名前
   'Parameter Type'
=> 'Parameter Type (293)',

   'Parameter in Effect'
=> 'Parameter in Effect (294)',

   'Per Page'
=> 'Per Page (295)',
# Per ページ
   'Personal Information'
=> 'Personal Information (296)',
# Personal Infまたはmation
   'Please do not reply to this address.'
=> 'Please do not reply to this address. (297)',

   'Please notify the server administrator '
=> 'Please notify the server administrator  (298)',
# Please notify the サーバ administratまたは 
   'Please select a problem to analyze'
=> 'Please select a problem to analyze (299)',
# Please 選択する： problem to analyze
   'Please select a report to generate'
=> 'Please select a report to generate (300)',
# Please 選択する： repまたはt to generate
   'Please select a report to generate.'
=> 'Please select a report to generate. (301)',
# Please 選択する： repまたはt to generate.
   'Portuguese - ISO'
=> 'Portuguese - ISO (302)',
# Pまたはtuguese - ISO
   'Position'
=> 'Position (303)',

   'Post anonymously'
=> 'Post anonymously (304)',

   'Post discussion on course resources'
=> 'Post discussion on course resources (305)',
# Post discussion on コース リソースs
   'Post system frontpage announcements'
=> 'Post system frontpage announcements (306)',
# Post システム frontページ お知らせments
   'Post to live chatrooms'
=> 'Post to live chatrooms (307)',
# Post to live チャットrooms
   'Preferred language'
=> 'Preferred language (308)',
# Preferred 言語
   'Preparing Excel Spreadsheet'
=> 'Preparing Excel Spreadsheet (309)',

   'Previous'
=> 'Previous (310)',

   'Printing Helper'
=> 'Printing Helper (311)',
# Printing ヘルプer
   'Privacy Note'
=> 'Privacy Note (312)',

   'Problem Status Chart'
=> 'Problem Status Chart (313)',
# Problem 状態 図
   'Problems'
=> 'Problems (314)',

   'Problems Not Contained In A Folder'
=> 'Problems Not Contained In A Folder (315)',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator. (316)',
# Problems creating new Excel ファイル.  This errまたは has been logged.  Please alert your LON-CAPA administratまたは.
   'Processed [_1] student(s).'
=> 'Processed [_1] student(s). (317)',
# Processed [_1] 学生(s).
   'Processing course structure'
=> 'Processing course structure (318)',
# 処理中 コース 作成するure
   'Processing first student'
=> 'Processing first student (319)',
# 処理中 first 学生
   'Produce Excel Output'
=> 'Produce Excel Output (320)',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Provide feedback messages or contribute to the course discussion about this resource (321)',
# Provide feedback messages または contribute to the コース discussion about this リソース
   'Provide my evaluation of this resource'
=> 'Provide my evaluation of this resource (322)',
# Provide 私の evaluation of this リソース
   'Publish'
=> 'Publish (323)',

   'Publish Directory'
=> 'Publish Directory (324)',
# Publish Directまたはy
   'Publish Directory and Sub Directories'
=> 'Publish Directory and Sub Directories (325)',
# Publish Directまたはy and Sub Directまたはies
   'Published'
=> 'Published (326)',

   'Question Text'
=> 'Question Text (327)',

   'Question Type'
=> 'Question Type (328)',

   'Quick Completed Problems Display'
=> 'Quick Completed Problems Display (329)',
# Quick Completed Problems 表示する
   'Random position'
=> 'Random position (330)',

   'Re'
=> 'Re (331)',

   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data. (332)',
# Re-出席ment will re-activate data.
   'Reading results from'
=> 'Reading results from (333)',

   'Record'
=> 'Record (334)',
# Recまたはd
   'Registering'
=> 'Registering (335)',

   'Related'
=> 'Related (336)',

   'Reply'
=> 'Reply (337)',

   'Reset Submissions'
=> 'Reset Submissions (338)',
# Reセットする Submissions
   'Resource Feedback and Discussion'
=> 'Resource Feedback and Discussion (339)',
# リソース Feedback and Discussion
   'Resource Level'
=> 'Resource Level (340)',
# リソース Level
   'Retrieve'
=> 'Retrieve (341)',

   'Retrieve Published Resources'
=> 'Retrieve Published Resources (342)',
# Retrieve Published リソースs
   'Revert to Last Saved'
=> 'Revert to Last Saved (343)',
# Revert to Last 保存するd
   'Revision Date'
=> 'Revision Date (344)',
# Revision 日付
   'Row'
=> 'Row (345)',

   'Russian - KOI'
=> 'Russian - KOI (346)',

   'S.D. tries'
=> 'S.D. tries (347)',
# S.D. 受験回数
   'Samples'
=> 'Samples (348)',

   'Save as'
=> 'Save as (349)',
# 保存する as
   'Save as & Make This Sheet the Default'
=> 'Save as & Make This Sheet the Default (350)',
# 保存する as & Make This Sheet the Default
   'Save as ...'
=> 'Save as ... (351)',
# 保存する as ...
   'Scantron Operator'
=> 'Scantron Operator (352)',
# Scantron Operatまたは
   'Search Complete'
=> 'Search Complete (353)',
# 検索する Complete
   'Section'
=> 'Section (354)',

   'Sections'
=> 'Sections (355)',

   'Select All'
=> 'Select All (356)',
# 選択する：ll
   'Select All Students'
=> 'Select All Students (357)',
# 選択する：ll 学生s
   'Select Date'
=> 'Select Date (358)',
# 選択する 日付
   'Select Enclosing Map or Folder'
=> 'Select Enclosing Map or Folder (359)',
# 選択する Enclosing マップ または Folder
   'Select Parameter Level'
=> 'Select Parameter Level (360)',
# 選択する Parameter Level
   'Select Spreadsheet File'
=> 'Select Spreadsheet File (361)',
# 選択する Spreadsheet ファイル
   'Select a course'
=> 'Select a course (362)',
# 選択する： コース
   'Selecting a User'
=> 'Selecting a User (363)',
# 選択するing a ユーザ
   'Send Message to User(s)'
=> 'Send Message to User(s) (364)',
# S終了 Message to ユーザ(s)
   'Send New'
=> 'Send New (365)',
# S終了 New
   'Send Reply'
=> 'Send Reply (366)',
# S終了 Reply
   'Send Scantron data to a course'
=> 'Send Scantron data to a course (367)',
# S終了 Scantron data to a コース
   'Send as critical message'
=> 'Send as critical message (368)',
# S終了 as critical message
   'Send internal email'
=> 'Send internal email (369)',
# S終了 internal email
   'Sequence or Folder'
=> 'Sequence or Folder (370)',
# シーケンス または Folder
   'Sequences and Folders'
=> 'Sequences and Folders (371)',
# Sequ設定 and Folders
   'Set Course Environment Parameters'
=> 'Set Course Environment Parameters (372)',
# セットする コース Environment Parameters
   'Set Date'
=> 'Set Date (373)',
# セットする 日付
   'Set Defaults for All Resources in Course'
=> 'Set Defaults for All Resources in Course (374)',
# セットする Defaults fまたは All リソースs in コース
   'Set Version to be used in Course'
=> 'Set Version to be used in Course (375)',
# セットする バージョン to be used in コース
   'Set Versions to be used in Course according to Selections below'
=> 'Set Versions to be used in Course according to Selections below (376)',
# セットする バージョンs to be used in コース accまたはding to 選択するions below
   'Set a due date'
=> 'Set a due date (377)',
# セットする a due 日付
   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions) (378)',
# セットする all リソース バージョンs to current バージョン (Fix バージョンs)
   'Set an answer open date'
=> 'Set an answer open date (379)',
# セットする an 回答 open 日付
   'Set an open date'
=> 'Set an open date (380)',
# セットする an open 日付
   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . . (381)',
# セットする opening 日付fまたは all problems in the コース fまたは. . .
   'Set the number of tries'
=> 'Set the number of tries (382)',
# セットする the number of 受験回数
   'Set the problem weight'
=> 'Set the problem weight (383)',
# セットする the problem weight
   'Set/Modify Course Assessment Parameter'
=> 'Set/Modify Course Assessment Parameter (384)',
# セットする/Modify コース Assessment Parameter
   'Set/Modify Course Assessment Parameters'
=> 'Set/Modify Course Assessment Parameters (385)',
# セットする/Modify コース Assessment Parameters
   'Set/Modify Course Parameters'
=> 'Set/Modify Course Parameters (386)',
# セットする/Modify コース Parameters
   'Shared by course faculty and staff'
=> 'Shared by course faculty and staff (387)',
# Shared by コース faculty and staff
   'Short string response'
=> 'Short string response (388)',
# Shまたはt string response
   'Show More Options'
=> 'Show More Options (389)',
# Show Mまたはe Options
   'Show Preview'
=> 'Show Preview (390)',
# Show Pre閲覧
   'Show always at bottom position'
=> 'Show always at bottom position (391)',

   'Show always at top position'
=> 'Show always at top position (392)',

   'Show catalog information'
=> 'Show catalog information (393)',
# Show cataログインfまたはmation
   'Show resource'
=> 'Show resource (394)',
# Show リソース
   'Significant figures are incorrect, submission was not graded.'
=> 'Significant figures are incorrect, submission was not graded. (395)',
# Significant figures are incまたはrect, submission was not graded.
   'Simple Problem Editor'
=> 'Simple Problem Editor (396)',
# シンプル問題 編集または
   'Size'
=> 'Size (397)',

   'Size:'
=> 'Size: (398)',

   'Skew Tries'
=> 'Skew Tries (399)',
# Skew 受験回数
   'Space separated'
=> 'Space separated (400)',
# スペース separated
   'Spreadsheet Computation'
=> 'Spreadsheet Computation (401)',

   'Spreadsheet Computation Status'
=> 'Spreadsheet Computation Status (402)',
# Spreadsheet Computation 状態
   'Starting'
=> 'Starting (403)',
# スタートing
   'Starting and Ending Dates'
=> 'Starting and Ending Dates (404)',
# スタートing and 終了ing 日付s
   'Statistics'
=> 'Statistics (405)',

   'Statistics and Problem Analysis'
=> 'Statistics and Problem Analysis (406)',

   'Store'
=> 'Store (407)',
# Stまたはe
   'Store Changes'
=> 'Store Changes (408)',
# Stまたはe Changes
   'Student Data Compilation Progress'
=> 'Student Data Compilation Progress (409)',
# 学生 Data Compilation Progress
   'Student Data Compilation Status'
=> 'Student Data Compilation Status (410)',
# 学生 Data Compilation 状態
   'Student Number'
=> 'Student Number (411)',
# 学生 Number
   'Student level sheet'
=> 'Student level sheet (412)',
# 学生 level sheet
   'Student performance statistics on all problems.'
=> 'Student performance statistics on all problems. (413)',
# 学生 perfまたはmance statistics on all problems.
   'Students Affected'
=> 'Students Affected (414)',
# 学生s Affected
   'Submission Time Analysis'
=> 'Submission Time Analysis (415)',

   'Submit Changes and Edit'
=> 'Submit Changes and Edit (416)',
# 変更を保存する and 編集
   'Summary'
=> 'Summary (417)',

   'Summary View'
=> 'Summary View (418)',
# Summary 閲覧
   'Synchronized SQL metadata database'
=> 'Synchronized SQL metadata database (419)',

   'Tabulator separated'
=> 'Tabulator separated (420)',
# Tabulatまたは separated
   'Task'
=> 'Task (421)',

   'TeXWidth(mm):'
=> 'TeXWidth(mm): (422)',

   'Template'
=> 'Template (423)',

   'Temporary Assembly Workspace'
=> 'Temporary Assembly Workspace (424)',
# Tempまたはary Assembly Wまたはkスペース
   'Text'
=> 'Text (425)',

   'Text Block'
=> 'Text Block (426)',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly. (427)',
# The infまたはmation you 提出する can be 閲覧ed by anybody who is logged into LON-CAPA. Do not provide infまたはmation that you are not ready to share publicly.
   'The optional email address field was not specified.'
=> 'The optional email address field was not specified. (428)',

   'The optional name field was not specified.'
=> 'The optional name field was not specified. (429)',
# The optional 名前 field was not specified.
   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified. (430)',
# The optional section または group field was not specified.
   'The optional student number field was not specified.'
=> 'The optional student number field was not specified. (431)',
# The optional 学生 number field was not specified.
   'There are currently no results'
=> 'There are currently no results (432)',

   'There are no students currently enrolled.'
=> 'There are no students currently enrolled. (433)',
# There are no 学生s currently 出席ed.
   'There is no student data for this problem.'
=> 'There is no student data for this problem. (434)',
# There is no 学生 data fまたは this problem.
   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen. (435)',
# This ヘルプer will assist you in セットするting the open, due, and 回答 日付s fまたは problems, または in セットするting the number of 受験回数 fまたは problems. You will be asked to 選択する which problems you wish to セットする the parameters fまたは, それから what parameter you wish to セットする, それから you will 選択する whom the セットするting affects. After the ヘルプer is 完了, you will be shown where in the advanced interface you would have gone to セットする the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, または 選択する &lt;- Previous to 戻る to the previous screen.
   'This is an automatic message generated by the LON-CAPA system.'
=> 'This is an automatic message generated by the LON-CAPA system. (436)',
# This is an automatic message generated by the LON-CAPA システム.
   'Threaded View'
=> 'Threaded View (437)',
# Threaded 閲覧
   'Time'
=> 'Time (438)',

   'To'
=> 'To (439)',

   'Topic'
=> 'Topic (440)',

   'Total'
=> 'Total (441)',

   'Total Parts In Course'
=> 'Total Parts In Course (442)',
# Total パートs In コース
   'Total number of records found in file: [_1].'
=> 'Total number of records found in file: [_1]. (443)',
# Total number of recまたはds found in ファイル: [_1].
   'True'
=> 'True (444)',

   'Turkish - ISO'
=> 'Turkish - ISO (445)',

   'Type'
=> 'Type (446)',

   'Type-in value'
=> 'Type-in value (447)',

   'UNIX authenticated'
=> 'UNIX authenticated (448)',
# UNIX auそれからticated
   'URL'
=> 'URL (449)',

   'USERS'
=> 'USERS (450)',
# ユーザS
   'Unable to connect to database!'
=> 'Unable to connect to database! (451)',

   'Unable to enroll students'
=> 'Unable to enroll students (452)',
# Unable to 出席 学生s
   'Uncheck All'
=> 'Uncheck All (453)',

   'Unit:'
=> 'Unit: (454)',

   'Unknown ID'
=> 'Unknown ID (455)',

   'Unknown user'
=> 'Unknown user (456)',
# Unknown ユーザ
   'Unpublished'
=> 'Unpublished (457)',

   'Unselect All'
=> 'Unselect All (458)',
# Un選択する：ll
   'Unselect All Students'
=> 'Unselect All Students (459)',
# Un選択する：ll 学生s
   'Unsuccessful Login'
=> 'Unsuccessful Login (460)',
# Un正常にログインしました
   'Up'
=> 'Up (461)',

   'Update Course Assessment Parameter Display'
=> 'Update Course Assessment Parameter Display (462)',
# Up日付 コース Assessment Parameter 表示する
   'Update Section or Specific User'
=> 'Update Section or Specific User (463)',
# Up日付 Section または Specific ユーザ
   'Update Student Data'
=> 'Update Student Data (464)',
# Up日付 学生 Data
   'Updating discussion time'
=> 'Updating discussion time (465)',

   'Upload Scantron data'
=> 'Upload Scantron data (466)',
# Up負荷 Scantron data
   'Upload a Photo'
=> 'Upload a Photo (467)',
# Up負荷 a Photo
   'Upload a class list'
=> 'Upload a class list (468)',
# Up負荷 a class list
   'Uploading Class List'
=> 'Uploading Class List (469)',
# Up負荷ing Class List
   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course (470)',
# ユーザ （注）, Recまたはds of Face-To-Face ディスカッション, and Critical Messages in コース
   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'User Notes, Records of Face-to-Face Discussions, and Critical Messages (471)',
# ユーザ （注）, Recまたはds of Face-to-Face ディスカッション, and Critical Messages
   'Value'
=> 'Value (472)',

   'Verify Content'
=> 'Verify Content (473)',

   'Verify Selection'
=> 'Verify Selection (474)',
# Verify 選択するion
   'Version Number'
=> 'Version Number (475)',
# バージョン Number
   'Version changes since Yesterday'
=> 'Version changes since Yesterday (476)',
# バージョン changes since はいterday
   'Version changes since last Month'
=> 'Version changes since last Month (477)',
# バージョン changes since 先月
   'Version changes since last Week'
=> 'Version changes since last Week (478)',
# バージョン changes since 先週
   'Version changes since start of Course'
=> 'Version changes since start of Course (479)',
# バージョン changes since スタート of コース
   'Version used in Course'
=> 'Version used in Course (480)',
# バージョン used in コース
   'View'
=> 'View (481)',
# 閲覧
   'View Class List'
=> 'View Class List (482)',
# 閲覧 Class List
   'View Critical Messages'
=> 'View Critical Messages (483)',
# 閲覧 Critical Messages
   'View Published Version'
=> 'View Published Version (484)',
# 閲覧 Published バージョン
   'View user submissions for this assessment resource'
=> 'View user submissions for this assessment resource (485)',
# 閲覧 ユーザ submissions fまたは this assessment リソース
   'Warning!'
=> 'Warning! (486)',

   'Web References'
=> 'Web References (487)',
# Web Refer設定
   'Welcome'
=> 'Welcome (488)',

   'Welcome to the Assignment Parameter Helper'
=> 'Welcome to the Assignment Parameter Helper (489)',
# Welcome to the Assignment Parameter ヘルプer
   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up (490)',
# Welcome to the Learning<i>Online</i> Netwまたはk with CAPA. Please wait while your session is being セットする up
   'What parameter do you want to set for all problems in the course?'
=> 'What parameter do you want to set for all problems in the course? (491)',
# What parameter do you want to セットする fまたは all problems in the コース?
   'What should the opening date be set to?'
=> 'What should the opening date be set to? (492)',
# What should the opening 日付 be セットする to?
   'Which Problem or Problems?'
=> 'Which Problem or Problems? (493)',
# Which Problem または Problems?
   'Which problems do you wish to set a parameter for?'
=> 'Which problems do you wish to set a parameter for? (494)',
# Which problems do you wish to セットする a parameter fまたは?
   'Width(pixel):'
=> 'Width(pixel): (495)',

   'Words'
=> 'Words (496)',
# Wまたはds
   'XML/SGML'
=> 'XML/SGML (497)',

   'You have no critical messages.'
=> 'You have no critical messages. (498)',

   'You must choose an authentication type.'
=> 'You must choose an authentication type. (499)',
# You must 選択 an auそれからtication type.
   'You must choose at least one student to continue.'
=> 'You must choose at least one student to continue. (500)',
# You must 選択 at least one 学生 to continue.
   'You must choose one or more choices to continue.'
=> 'You must choose one or more choices to continue. (501)',
# You must 選択 one または mまたはe choices to continue.
   'You need to choose another user role or enter a specific course for this function'
=> 'You need to choose another user role or enter a specific course for this function (502)',
# You need to 選択 another ユーザ 役割 または 入力 a specific コース fまたは this function
   'You need to specify the Kerberos domain.'
=> 'You need to specify the Kerberos domain. (503)',
# You need to specify the Kerberos ドメイン.
   'You need to specify the initial password.'
=> 'You need to specify the initial password. (504)',
# You need to specify the initial passwまたはd.
   'You need to specify the username field.'
=> 'You need to specify the username field. (505)',
# You need to specify the ユーザ名前 field.
   'Your Excel Spreadsheet'
=> 'Your Excel Spreadsheet (506)',

   'Your Version Settings have been Stored'
=> 'Your Version Settings have been Stored (507)',
# Your バージョン セットするtings have been Stまたはed
   '[_1] Do not change login data'
=> '[_1] Do not change login data (508)',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2]) (509)',
# [_1] ファイルシステム Auそれからticated (with initial passwまたはd [_2])
   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Internally authenticated (with initial password [_2]) (510)',
# [_1] Internally auそれからticated (with initial passwまたはd [_2])
   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5 (511)',
# [_1] Kerberos auそれからticated with ドメイン [_2] [_3] バージョン 4 [_4] バージョン 5
   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local Authentication with arguement [_2] (512)',
# [_1] Local Auそれからtication with arguement [_2]
   'a.m.'
=> 'a.m. (513)',

   'abstract'
=> 'abstract (514)',
# アブストラクト
   'acc keys'
=> 'acc keys (515)',

   'according to course preferences'
=> 'according to course preferences (516)',
# accまたはding to コース prefer設定
   'according to resource settings'
=> 'according to resource settings (517)',
# accまたはding to リソース セットするtings
   'according to user session state'
=> 'according to user session state (518)',
# accまたはding to ユーザ session state
   'all'
=> 'all (519)',

   'and return receipt'
=> 'and return receipt (520)',

   'anonymous'
=> 'anonymous (521)',

   'at'
=> 'at (522)',

   'at Domain'
=> 'at Domain (523)',
# at ドメイン
   'at domain'
=> 'at domain (524)',
# at ドメイン
   'audio'
=> 'audio (525)',

   'author'
=> 'author (526)',
# authまたは
   'bytes'
=> 'bytes (527)',

   'can not be accessed from your location.'
=> 'can not be accessed from your location. (528)',

   'catalog'
=> 'catalog (529)',

   'co con-'
=> 'co con- (530)',

   'co res'
=> 'co res (531)',

   'contacting'
=> 'contacting (532)',
# コンタクトing
   'copyright'
=> 'copyright (533)',

   'customdistributionfile'
=> 'customdistributionfile (534)',
# customdistributionファイル
   'default'
=> 'default (535)',

   'directory'
=> 'directory (536)',
# directまたはy
   'discuss'
=> 'discuss (537)',

   'edit'
=> 'edit (538)',
# 編集
   'evaluate'
=> 'evaluate (539)',

   'feedback'
=> 'feedback (540)',

   'for Enclosing Map or Folder'
=> 'for Enclosing Map or Folder (541)',
# fまたは Enclosing マップ または Folder
   'for Resource'
=> 'for Resource (542)',
# fまたは リソース
   'from Enclosing Map or Folder'
=> 'from Enclosing Map or Folder (543)',
# from Enclosing マップ または Folder
   'general'
=> 'general (544)',

   'in Course'
=> 'in Course (545)',
# in コース
   'in Section/Group'
=> 'in Section/Group (546)',
# in 章／グループ
   'info'
=> 'info (547)',

   'interface available'
=> 'interface available (548)',

   'keywords'
=> 'keywords (549)',
# keywまたはds
   'language'
=> 'language (550)',
# 言語
   'last student'
=> 'last student (551)',
# last 学生
   'loginproblems.html'
=> 'loginproblems.html (552)',

   'manage'
=> 'manage (553)',

   'midnight'
=> 'midnight (554)',

   'minutes'
=> 'minutes (555)',

   'missions'
=> 'missions (556)',

   'most recent'
=> 'most recent (557)',

   'movies'
=> 'movies (558)',

   'name only visible to course faculty'
=> 'name only visible to course faculty (559)',
# 名前 only visible to コース faculty
   'noon'
=> 'noon (560)',

   'notes'
=> 'notes (561)',
# （注）
   'num_override'
=> 'num_override (562)',

   'obsolete'
=> 'obsolete (563)',
# 旧
   'obsoletereplacement'
=> 'obsoletereplacement (564)',
# 旧replacement
   'of'
=> 'of (565)',

   'or ID'
=> 'or ID (566)',
# または ID
   'p.m.'
=> 'p.m. (567)',

   'pages'
=> 'pages (568)',
# ページs
   'part'
=> 'part (569)',
# パート
   'percent'
=> 'percent (570)',

   'pictures'
=> 'pictures (571)',

   'problem'
=> 'problem (572)',

   'problem statistics grouped by sequence'
=> 'problem statistics grouped by sequence (573)',
# problem statistics grouped by シーケンス
   'problem statistics ungrouped'
=> 'problem statistics ungrouped (574)',

   'problem statistics, Excel'
=> 'problem statistics, Excel (575)',

   'remaining'
=> 'remaining (576)',

   'resources'
=> 'resources (577)',
# リソースs
   'second'
=> 'second (578)',

   'seconds'
=> 'seconds (579)',

   'seconds for'
=> 'seconds for (580)',
# seconds fまたは
   'sequence'
=> 'sequence (581)',
# シーケンス
   'subject'
=> 'subject (582)',
# 表題
   'this'
=> 'this (583)',

   'title'
=> 'title (584)',
# タイトル
   'unless locked'
=> 'unless locked (585)',

   'users in'
=> 'users in (586)',
# ユーザs in
   'versions of this problem'
=> 'versions of this problem (587)',
# バージョンs of this problem
   'view sub-'
=> 'view sub- (588)',
# 閲覧 sub-
   'waiting on'
=> 'waiting on (589)',


# ----

   'calendar[_1]'
=> 'カレンダ',

   'announce[_1]'
=> 'お知らせ',


# ----

   'commu-[_1]'
=> 'コミュニ',

   'nication[_1]'
=> 'ケーション',


# ----

   'course[_10]'
=> 'コース',

   'chat[_1]'
=> 'チャット',


# ----

   'search[_1]'
=> '検索する',

   'course[_11]'
=> 'コース',


# ----

   'search[_2]'
=> '検索する',

   'library[_1]'
=> 'ライブラリ',


# ----

   'prefer-[_1]'
=> '個人',

   'ences[_1]'
=> '設定',


# ----

   'exit[_1]'
=> '終了',

   ' [_1]'
=> '',


# ----

   'switch[_2]'
=> '切替える',

   'role[_1]'
=> '役割',


# ----

   'choose[_2]'
=> '選択',

   'role[_2]'
=> '役割',


# ----

   'choose[_1]'
=> '選択',

   'course[_1]'
=> 'コース',


# ----

   'switch[_1]'
=> '切替える',

   'course[_2]'
=> 'コース',


# ----

   'course[_3]'
=> 'コース',

   'docs[_1]'
=> 'docs',


# ----

   'edit crs[_1]'
=> 'コースを編集',

   'docs[_2]'
=> 'docs',


# ----

   'navigate[_1]'
=> 'ナビゲート',

   'contents[_1]'
=> 'コンテンツ',


# ----

   'my[_1]'
=> '私の',

   'grades[_1]'
=> '成績',


# ----

   'course[_4]'
=> 'コース',

   'grades[_2]'
=> '成績',


# ----

   'course[_5]'
=> 'コース',

   'chart[_1]'
=> '図',


# ----

   'course[_6]'
=> 'コース',

   'stats[_1]'
=> '状態',


# ----

   'course[_7]'
=> 'コース',

   'enroll[_1]'
=> '出席',


# ----

   'manage[_1]'
=> 'manage (553)',

   'acc keys[_1]'
=> 'acc keys (515)',


# ----

   'user[_1]'
=> 'ユーザ',

   'roles[_1]'
=> '役割',


# ----

   'user[_1]'
=> 'ユーザ',

   'roles[_1]'
=> '役割',


# ----

   'user[_1]'
=> 'ユーザ',

   'roles[_1]'
=> '役割',


# ----

   'create[_1]'
=> '作成',

   'course[_8]'
=> 'コース',


# ----

   'course[_9]'
=> 'コース',

   'parms[_1]'
=> 'パラメータ',


# ----

   'con-[_1]'
=> 'con-',

   'struct[_1]'
=> '作成する',


# ----

   'co con-[_1]'
=> 'co con- (530)',

   'struct[_2]'
=> '作成する',


# ----

   'resource[_1]'
=> 'リソース',

   'space[_1]'
=> 'スペース',


# ----

   'co res[_1]'
=> 'co res (531)',

   'space[_2]'
=> 'スペース',


# ----

   'resource[_1]'
=> 'リソース',

   'space[_1]'
=> 'スペース',


# ----

   'enter[_1]'
=> '入力',

   'grades[_2]'
=> '成績',


# ----

   'send[_1]'
=> 'send',

   'scantron[_1]'
=> 'scantron',


# ----

   'view[_1]'
=> '閲覧',

   'bookmark[_1]'
=> 'ブックマーク',


#SYNC Tue Aug 15 14:23:28 2006
   ' [_1]'
=> ' [_1]',

   '"[_1]" for default hiding'
=> '"[_1]" for default hiding',
# "[_1]" fまたは Default (119) (535) hiding
   '"[_1]" for visible separation'
=> '"[_1]" for visible separation',
# "[_1]" fまたは visible separat (522)ion
   '"[_1]" if allowed, anything else if not'
=> '"[_1]" if allowed, anything else if not',
# "[_1]" if ALL (37) (519)o水, anything else if not
   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',
# "[_1]" To (439) disable, anything else if not
   '# Do not translate this line.  [_1] is a check box'
=> '# Do not translate this line.  [_1] is a check box',
# # Do not translat (522)e this (583) line.  [_1] is a check box
   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field',
# # Do not translat (522)e this (583) line.  [_1] is a check box, [_2] is a Text (425) entry Field (171)
   '# Do not translate this line.  [_1] is a column index.'
=> '# Do not translate this line.  [_1] is a column index.',
# # Do not translat (522)e this (583) line.  [_1] is a Column (91) index.
   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Do not translate this line.  [_1] is a drop-down box listing domains.',
# # Do not translat (522)e this (583) line.  [_1] is a drop-down box listing ドメインs.
   '# Do not translate this line.  [_1] is a username'
=> '# Do not translate this line.  [_1] is a username',
# # Do not translat (522)e this (583) line.  [_1] is a ユーザ名前
   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Do not translate this line.  [_1] is the number of students processed',
# # Do not translat (522)e this (583) line.  [_1] is the number of (565) 学生s processed
   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.',
# # Do not translat (522)e this (583) line.  [_1] is ユーザ名前, [_2] - [_5] aRe (331) first, middle, and last 名前s, and generat (522)ion.
   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Do not translate this line.  [_1] is username, [_2] is error message',
# # Do not translat (522)e this (583) line.  [_1] is ユーザ名前, [_2] is errまたは message
   '# Do not translate this line.  [_1] is username@domain'
=> '# Do not translate this line.  [_1] is username@domain',
# # Do not translat (522)e this (583) line.  [_1] is ユーザ名前@ドメイン
   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Do not translate this line.  [_1] is username@domain [_2] is the error message.',
# # Do not translat (522)e this (583) line.  [_1] is ユーザ名前@ドメイン [_2] is the errまたは message.
   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Do not translate this line.  [_1], [_3], and [_4] are check boxes',
# # Do not translat (522)e this (583) line.  [_1], [_3], and [_4] aRe (331) check boxes
   '# Do not translate this line.  [_2] is a text entry element'
=> '# Do not translate this line.  [_2] is a text entry element',
# # Do not translat (522)e this (583) line.  [_2] is a Text (425) entry element
   '# [_1] is a drop-down selection box'
=> '# [_1] is a drop-down selection box',
# # [_1] is a drop-down 選択するion box
   '# [_1] is a number [_2] is the current domain'
=> '# [_1] is a number [_2] is the current domain',
# # [_1] is a number [_2] is the curRe (331)nt ドメイン
   '# [_1] is an html link to the current file '
=> '# [_1] is an html link to the current file ',
# # [_1] is an HTML (204) link To (439) the curRe (331)nt ファイル 
   '# _1 is a selection dialog'
=> '# _1 is a selection dialog',
# #1 is a 選択するion dialog
   '# _1 is a server name'
=> '# _1 is a server name',
# #1 is a サーバ 名前
   '# _1 is search string'
=> '# _1 is search string',
# #1 is 検索する string
   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'",
# #1,3, and5 aRe (331) link anchまたはs,2,_4, and6 aRe (331) '</a>'
   '#[_1] is the foil name'
=> '#[_1] is the foil name',
# #[_1] is the Foil (177) 名前
   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 is the foil name, _2 is the current value of the foil',
# #_1 is the Foil (177) 名前,2 is the curRe (331)nt Value (472) of (565) the Foil (177)
   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.',
# &quot; [_1] &quot; is not an acceptable number of (565) 受験回数. 受験回数 must be a positive number with no decimal point.
   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.',

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',
# (入力 maximum [_1] collabまたはat (522)またはs using ユーザ名前 または ユーザ名前@ドメイン, e.g. smithje または smithje@[_2].)
   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',
# (Hand in a ファイル you have 準備するd on your computer)
   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',
# , 選択する： templat (522)e From (187) the pull-down menu below.
   '1 minute'
=> '1 minute',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',
# <*Re (331)sponse>s aRe (331) both inside of (565) <パート (569)> and outside of (565) <パート (569)>, this (583) is not a valid problem (572), errまたはs in 採点 ５月 occur.
   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',
# <b>HTML (204) ALL (37) (519)o水</b>: discuss (537)ion パート (569)icipants can use limited HTML (204) in their postings.
   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',
# <b>HTML (204) banned</b>: HTML (204) will not be ALL (37) (519)o水 in discuss (537)ion postings.
   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',
# <b>In作成するまたは</b> - in作成するまたはs will not be able To (439) パート (569)icipat (522)e in discuss (537)ions
   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',
# <b>In作成するまたは</b> - in作成するまたはs will not be able To (439) use または 閲覧 the チャット room
   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',
# <b>学生s</b> - 学生s will not be able To (439) パート (569)icipat (522)e in discuss (537)ions
   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',
# <b>学生s</b> - 学生s will not be able To (439) use または 閲覧 the チャット room.
   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',
# <b>ＴＡs</b> - ＴＡs will not be able To (439) パート (569)icipat (522)e in discuss (537)ions
   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',
# <b>ＴＡs</b> - ＴＡs will not be able use または 閲覧 the チャット room
   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>',
# <p>Your curRe (331)nt LON-CAPA ドメイン is &quot;<b>[_1]</b>&quot;.</p>
   'ABSTRACT'
=> 'ABSTRACT',
# アブストラクト (514)
   'Access Control'
=> 'Access Control',

   'Activate'
=> 'Activate',
# Activat (522)e
   'Add Roles'
=> 'Add Roles',
# Add 役割
   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",
# Add one クリア ページ/Column (91) after each 学生's assignment
   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",
# Add thRe (331)e クリア ページs (568)/Column (91) after each 学生's assignment
   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",
# Add two クリア ページs (568)/Column (91) after each 学生's assignment
   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',
# Additional セットするtings, if specified below, will override cloned セットするtings
   'Advanced Edit'
=> 'Advanced Edit',
# Advanced 編集 (538)
   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',
# Advanced: You can s終了 the feedback (540) From (187) diffeRe (331)nt Section (354)s (355) To (439) diffeRe (331)nt people, By (71) doing the following: Separat (522)e each entry with a comma. To (439) s終了 feedback (540) To (439) a certain addRe (331)ss fまたは diffeRe (331)nt Section (354)s (355), app終了 the Section (354) 名前 または 名前s (separat (522)ed By (71) semi-colons) in a paRe (331)ntheSize (397)d list after the ユーザ:ドメイン. Fまたは example, john102:msu(001;002;003),bob293:msu(004;005;006),madeUp (461)名前: (268)heRe (331)(007;008;009) will route コース feedback (540) To (439) &quot;john102&quot; fまたは Section (354)s (355), 2, and 3, To (439) &quot;bob293&quot; fまたは 4, 5, and 6, and To (439) &quot;madeUp (461)名前: (268)heRe (331)&quot; fまたは 7, 8, and 9. Note theRe (331) is no Re (331)quiRe (331)ment that (522) the addRe (331)sses be in any パート (569)icular ドメイン.
   'All Resources'
=> 'All Resources',
# ALL (37) (519) リソースs (577)
   'All Students'
=> 'All Students',
# ALL (37) (519) 学生s
   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.',
# ALL (37) (519) セットするtings which you can Change (75) with this (583) ヘルプer can also be Change (75)d By (71) going To (439) the Pa.m. (513)scRe (331)en and clicking on the &quot;セットする コース environment&quot; butTo (439)n. If you do not have experience coまたはdinat (522)ing LON-CAPA コースs または if you pRe (331)fer the ヘルプer interface, please click Next (273) -&gt;.
   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',
# ALL (37) (519)ow limited HTML (204) in discuss (537)ion posts
   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',
# ALL (37) (519)ow problem (572)s To (439) be split over ページs (568)
   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',
# ALL (37) (519)o水 ファイル Extensions fまたは アップロードしました ファイルs (アップロードしましたファイルType (446)s)
   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',
# ALL (37) (519)o水 ファイルType (446)s: <b>[_1]</b>
   'An error occured during the attempt to change the section for this student.'
=> 'An error occured during the attempt to change the section for this student.',
# An errまたは occuRe (331)d during the at (522)tempt To (439) Change (75) the Section (354) fまたは this (583) 学生.
   'An error occurred during the attempt to change the role information for this student.'
=> 'An error occurred during the attempt to change the role information for this student.',
# An errまたは occurRe (331)d during the at (522)tempt To (439) Change (75) the 役割 infまたはmat (522)ion fまたは this (583) 学生.
   'Analyzing Results'
=> 'Analyzing Results',
# Analyzing Re (331)sults
   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',
# 回答 Dat (522)e (回答dat (522)e)
   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',
# 回答 提出するted: Your final submission will be graded after the Due (149) dat (522)e.
   'Answerable'
=> 'Answerable',
# 回答able
   'Assessment Parameters'
=> 'Assessment Parameters',
# Assessment (60) Parameters
   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',
# AuTo (439)mat (522)ed 出席ment manage (553)r
   'Automated adds'
=> 'Automated adds',
# AuTo (439)mat (522)ed adds
   'Automated drops'
=> 'Automated drops',
# AuTo (439)mat (522)ed drops
   'Automated enrollment settings'
=> 'Automated enrollment settings',
# AuTo (439)mat (522)ed 出席ment セットするtings
   'Bad Filename'
=> 'Bad Filename',
# Bad ファイル名前
   'Begin Enrollment'
=> 'Begin Enrollment',
# Begin 出席ment
   'Binary File'
=> 'Binary File',
# Binary ファイル
   'Blank'
=> 'Blank',

   'Browse'
=> 'Browse',
# BRow (345)se
   'CSV format'
=> 'CSV format',
# CSV fまたはmat (522)
   'Cannot publish directory'
=> 'Cannot publish directory',
# Cannot Publish (323) diRe (331)ctまたはy
   'Cannot retrieve directory'
=> 'Cannot retrieve directory',
# Cannot Re (331)trieve (341) diRe (331)ctまたはy
   'Catalog Search'
=> 'Catalog Search',
# cat (522)alog (529) 検索する
   'Change User Privileges'
=> 'Change User Privileges',
# Change (75) ユーザ Privileges
   'Changed discussion view mode'
=> 'Changed discussion view mode',
# Change (75)d discuss (537)ion 閲覧 mode
   'Chat Participation'
=> 'Chat Participation',
# チャット パート (569)icipat (522)ion
   'Click here for FAQ'
=> 'Click here for FAQ',
# Click heRe (331) fまたは FAQ
   'Click here for help'
=> 'Click here for help',
# Click heRe (331) fまたは ヘルプ
   'Click here to report bugs'
=> 'Click here to report bugs',
# Click heRe (331) To (439) Re (331)pまたはt bugs
   'Click here to return to the chart.'
=> 'Click here to return to the chart.',
# Click heRe (331) To (439) Re (331)turn To (439) the 図.
   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',
# Click-On Text (425)s (comma sep):
   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',
# Client IP/名前 Access Control (acc)
   'Clone an existing course'
=> 'Clone an existing course',
# Clone an existing コース
   'Close This Window'
=> 'Close This Window',
# Close (89) this (583) Window
   'Closed'
=> 'Closed',
# Close (89)d
   'Communication'
=> 'Communication',
# Commuケーション
   'Compare versions of'
=> 'Compare versions of',
# CompaRe (331) バージョンs of (565)
   'Completed'
=> 'Completed',

   'Completely new course'
=> 'Completely new course',
# Completely new コース
   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.',
# Confirm that (522) this (583) infまたはmat (522)ion is cまたはRe (331)ct, それから click &quot;Finish ヘルプer&quot; To (439) complete セットするting the parameter.
   'Construction Space Version'
=> 'Construction Space Version',
# Con作成するion スペース バージョン
   'Continue'
=> 'Continue',

   'Copy current file to'
=> 'Copy current file to',
# Copy curRe (331)nt ファイル To (439)
   'Copy selected'
=> 'Copy selected',
# Copy 選択するed
   'Course Code'
=> 'Course Code',
# コース Code
   'Course Content'
=> 'Course Content',
# コース Content
   'Course Data'
=> 'Course Data',
# コース Dat (522)a
   'Course Home Server'
=> 'Course Home Server',
# コース Home サーバ
   'Course ID or number'
=> 'Course ID or number',
# コース ID または number
   'Course ID/Number'
=> 'Course ID/Number',
# コース ID/Number
   'Course Information'
=> 'Course Information',
# コース Infまたはmat (522)ion
   'Course Initialization Helper'
=> 'Course Initialization Helper',
# コース Initializat (522)ion ヘルプer
   'Course Level'
=> 'Course Level',
# コース Level
   'Course Search'
=> 'Course Search',
# コース 検索する
   'Course Title'
=> 'Course Title',
# コース タイトル (584)
   'Course default for all problems'
=> 'Course default for all problems',
# コース Default (119) (535) fまたは ALL (37) (519) problem (572)s
   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',
# コース members can provide feedback (540) about the コース. You can 選択 who will Re (331)ceive the feedback (540), such as a diffeRe (331)nt in作成するまたは または a TA. Please 入力 their LON-CAPA addRe (331)ss below, in the fまたはm ユーザ:ドメイン, wheRe (331) &quot;ユーザ&quot; and &quot;ドメイン&quot; aRe (331) both the LON-CAPA ユーザ名前 and LON-CAPA ドメイン, not an eMail (242) addRe (331)ss.
   'Courses'
=> 'Courses',
# コースs
   'Create New User'
=> 'Create New User',
# 作成 New ユーザ
   'Create User'
=> 'Create User',
# 作成 ユーザ
   'Creating a new'
=> 'Creating a new',
# CRe (331)at (522)ing a new
   'Crosslisted courses'
=> 'Crosslisted courses',
# Crosslisted コースs
   'Current Class List'
=> 'Current Class List',
# CurRe (331)nt Class List
   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',
# CurRe (331)nt 終了ing Dat (522)e: [_1]
   'Current Ending Date: not set'
=> 'Current Ending Date: not set',
# CurRe (331)nt 終了ing Dat (522)e: not セットする
   'Current Resource'
=> 'Current Resource',
# CurRe (331)nt リソース
   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',
# CurRe (331)nt スタートing (403) Dat (522)e: [_1]
   'Current Starting Date: not set'
=> 'Current Starting Date: not set',
# CurRe (331)nt スタートing (403) Dat (522)e: not セットする
   'Current Version'
=> 'Current Version',
# CurRe (331)nt バージョン
   'Currently no active roles or courses'
=> 'Currently no active roles or courses',
# CurRe (331)ntly no active 役割 または コースs
   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',
# CurRe (331)ntly no additional 役割 または コースs
   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',
# CurRe (331)ntly 提出するted: <tt>[_1]</tt>
   'Custom Role Editor'
=> 'Custom Role Editor',
# CusTo (439)m 役割 編集 (538)または
   'Cut selected'
=> 'Cut selected',
# Cut 選択するed
   'Decompress'
=> 'Decompress',
# DecompRe (331)ss
   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',
# Default (119) (535) Assessment (60) SpRe (331)adsheet
   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',
# Default (119) (535) コース SpRe (331)adsheet
   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',
# Default (119) (535) 学生 SpRe (331)adsheet
   'Default XML Style File'
=> 'Default XML Style File',
# Default (119) (535) XML Style ファイル
   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',
# Default (119) (535) beginning dat (522)e when 出席ing 学生s
   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',
# Default (119) (535) 終了ing dat (522)e when 出席ing 学生s
   'Default for new courses is'
=> 'Default for new courses is',
# Default (119) (535) fまたは new コースs is
   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',
# Default (119) (535) セットする of (565) options To (439) pass To (439) tth/m when converting tex
   'Default:'
=> 'Default:',
# Default (119) (535):
   'Define Role'
=> 'Define Role',
# Define 役割
   'Dependencies'
=> 'Dependencies',
# Dep終了encies
   'Description:'
=> 'Description:',

   'Disable display of problem receipts'
=> 'Disable display of problem receipts',
# Disable 表示する of (565) problem (572) Re (331)ceipts
   'Disable student resource discussion'
=> 'Disable student resource discussion',
# Disable 学生 リソース discuss (537)ion
   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',
# Disable 学生 use of (565) チャットrooms
   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',
# DisALL (37) (519)ow リソース discuss (537)ion fまたは 役割
   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',
# DisALL (37) (519)ow リソース discuss (537)ion fまたは ユーザs
   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',
# DisALL (37) (519)ow live チャットroom use fまたは 役割
   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',
# DisALL (37) (519)ow live チャットroom use fまたは ユーザs
   'Discussion Participation'
=> 'Discussion Participation',
# discuss (537)ion パート (569)icipat (522)ion
   'Display file attributes'
=> 'Display file attributes',
# 表示する ファイル at (522)tributes
   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',
# Do NOT generat (522)e as standard コース
   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',
# Do not show plain URL (449) (encryptURL (449))
   'Domain Level'
=> 'Domain Level',
# ドメイン Level
   "Don't Show Feedback"
=> "Don't Show Feedback",
# Don't Show feedback (540)
   'Due Date (contentclose)'
=> 'Due Date (contentclose)',
# Due (149) Dat (522)e (contentClose (89))
   'Due Date (duedate)'
=> 'Due Date (duedate)',
# Due (149) Dat (522)e (Due (149)dat (522)e)
   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',
# Durat (522)ion of (565) auTo (439)mat (522)ed classlist Up (461)dat (522)es
   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',
# Dynamic Metadat (522)a (周期的に更新されます)
   'ERROR'
=> 'ERROR',
# ERRまたは
   'Edit Custom Role Privileges'
=> 'Edit Custom Role Privileges',
# 編集 (538) CusTo (439)m 役割 Privileges
   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.',
# 編集 (538)または Errまたはs - these errまたはs might not effect the running of (565) the problem (572), but they will likely cause problem (572)s with further use of (565) the 編集 (538) mode. Please use the 編集 (538)XML mode To (439) fix these errまたはs.
   'End Time'
=> 'End Time',
# 終了 Time (438)
   'Ending Date'
=> 'Ending Date',
# 終了ing Dat (522)e
   'Enroll One Student'
=> 'Enroll One Student',
# 出席 One 学生
   'Enroll as student'
=> 'Enroll as student',
# 出席 as 学生
   'Enrolling'
=> 'Enrolling',
# 出席ing
   'Enrolling Student'
=> 'Enrolling Student',
# 出席ing 学生
   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',
# 入力 as many Field (171)s as you can. The システム will infまたはm you and bring you 戻る⇒ (439) this (583) ページ if the dat (522)a 選択するed is insufficient To (439) 出席 学生s in your class.
   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below',
# 入力 terms または phrases separat (522)ed By (71) AND, または, または NOT それから pRe (331)ss 検索する below
   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Enter terms or phrases separated by search operators such as AND, OR, or NOT',
# 入力 terms または phrases separat (522)ed By (71) 検索する operat (522)またはs such as AND, または, または NOT
   'Entering Construction Space'
=> 'Entering Construction Space',
# 入力ing Con作成するion スペース
   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',
# Errまたは: DiRe (331)ctまたはy Non クリア
   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',
# Errまたは: destinat (522)ion fまたは operat (522)ion is an existing diRe (331)ctまたはy.
   'Evaluation Error '
=> 'Evaluation Error ',
# Evaluat (522)ion Errまたは 
   'Every problem in a particular folder'
=> 'Every problem in a particular folder',
# Every problem (572) in a パート (569)icular Folder (179)
   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',
# Every problem (572) in a パート (569)icular Folder (179) (overrides コース Default (119) (535))
   'Every problem in the course'
=> 'Every problem in the course',
# Every problem (572) in the コース
   'Exam Problem'
=> 'Exam Problem',
# Exam problem (572)
   'Excel format'
=> 'Excel format',
# Excel (168) fまたはmat (522)
   'Exit'
=> 'Exit',
# 終了
   'Feedback Addresses for Course Content'
=> 'Feedback Addresses for Course Content',
# feedback (540) AddRe (331)sses fまたは コース Content
   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',
# feedback (540) AddRe (331)sses fまたは コース Content Comments
   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',
# feedback (540) AddRe (331)sses fまたは コース Policy
   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',
# feedback (540) AddRe (331)sses fまたは リソース Content Question
   'Finish Helper'
=> 'Finish Helper',
# Finish ヘルプer
   'First'
=> 'First',

   'First Resource'
=> 'First Resource',
# First リソース
   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',
# Foil (177) 名前 <b><tt>[_1]</tt></b> appears mまたはe than once. Foil (177) 名前s need To (439) be unique.
   'Folder/Map'
=> 'Folder/Map',
# Folder (179)/マップ
   'For one or more students'
=> 'For one or more students',
# Fまたは one または mまたはe 学生s
   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',
# Found a <*Re (331)sponse> outside of (565) a <パート (569)> in a <パート (569)>ed problem (572)
   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',
# Found no analyzable Re (331)spones in this (583) problem (572), curRe (331)ntly only Numerical, Fまたはmula and String Re (331)sponse styles aRe (331) sUp (461)pまたはted.
   'Generate messages from a file'
=> 'Generate messages from a file',
# Generat (522)e messages From (187) a ファイル
   'Go'
=> 'Go',

   'Go to ...'
=> 'Go to ...',
# Go To (439) ...
   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',
# HTML (204) can be ALL (37) (519)o水 または banned inside of (565) コース discuss (537)ion.
   'HTML in Discussions'
=> 'HTML in Discussions',
# HTML (204) in discuss (537)ions
   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Help on Creating Courses'
=> 'Help on Creating Courses',
# ヘルプ on CRe (331)at (522)ing コースs
   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',
# Hide (207) クリア Row (345)s in SpRe (331)adsheets
   'Home Server'
=> 'Home Server',
# Home サーバ
   'Homework problem'
=> 'Homework problem',
# Homewまたはk problem (572)
   'How do I create a CSV file from a spreadsheet'
=> 'How do I create a CSV file from a spreadsheet',
# How do I 作成 a CSV ファイル From (187) a spRe (331)adsheet
   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',
# How do I 作成 a class list From (187) a spRe (331)adsheet
   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',
# How many 受験回数 should be セットする fまたは ALL (37) (519) problem (572)s in the コース?
   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',
# How many 受験回数 should be セットする fまたは the 選択するed Folder (179)?
   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',
# How many 受験回数 should be セットする fまたは the 選択するed problem (572)?
   'How should the results be printed?'
=> 'How should the results be printed?',
# How should the Re (331)sults be printed?
   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',
# Immediat (522)ely expiRe (331) own 役割 as コース Coまたはdinat (522)または
   'Import and Paste Area'
=> 'Import and Paste Area',
# Impまたはt and Paste ARe (331)a
   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',
# Include Re (331)trieval of (565) 学生 phoTo (439)graphs?
   'Institutional Information'
=> 'Institutional Information',
# Institutional Infまたはmat (522)ion
   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',
# Interlingua (Internat (522)ional Auxiliary 言語 (550) Associat (522)ion) - ISO
   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',
# Invalid Significant figuRe (331)s detected
   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',
# Invalid characters in Re (331)quested 名前 have been Re (331)moved.
   'Invalid login mode or password.'
=> 'Invalid login mode or password.',
# Invalid login mode または passwまたはd.
   'Invalid username or domain'
=> 'Invalid username or domain',
# Invalid ユーザ名前 または ドメイン
   'KEYWORDS'
=> 'KEYWORDS',
# KEYWまたはDS
   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',
# LON-CAPA has live チャット functionality. this (583) コース will Re (331)ceive its own チャット room. You ５月 deny 学生s, TAs, または in作成するまたはs the right To (439) access the チャット room.
   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',
# LON-CAPA Host (209)s discuss (537)ions on ALL (37) (519) リソースs (577) in a コース. By (71) Default (119) (535), ALL (37) (519) ユーザs aRe (331) ALL (37) (519)o水 To (439) パート (569)icipat (522)e in these discuss (537)ions. If you do not wish certain Type (446)s of (565) ユーザs To (439) be able To (439) use the discuss (537)ion feat (522)uRe (331)s, 選択する those Type (446)s below. Note your class ５月 not have ALL (37) (519) of (565) these 役割; you ５月 safely ignまたはe 役割 you do not int終了 To (439) use. (Fまたは instance, &quot;Exam Proctまたは&quot; is general (544)ly useful only fまたは large コースs.) Type (446)s of (565) ユーザs not ALL (37) (519)o水 To (439) パート (569)icipat (522)e in discuss (537)ion can still 閲覧 any discuss (537)ion that (522) other ユーザs post.
   'LaTeX batchmode'
=> 'LaTeX batchmode',
# Lat (522)eX bat (522)chmode
   'LaTeX mode:'
=> 'LaTeX mode:',
# Lat (522)eX mode:
   'Languages used'
=> 'Languages used',
# 言語 (550)s used
   'Last'
=> 'Last',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',
# Leave blank on scまたはing fまたはm
   'List Directory'
=> 'List Directory',
# List DiRe (331)ctまたはy
   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',
# List of (565) hidden パート (569)s (hiddenパート (569)s)
   'Location'
=> 'Location',
# Locat (522)ion
   'Login Data'
=> 'Login Data',
# Login Dat (522)a
   'Logout'
=> 'Logout',

   'Make new directory'
=> 'Make new directory',
# Make new diRe (331)ctまたはy
   'Make new file'
=> 'Make new file',
# Make new ファイル
   'Manual Grading'
=> 'Manual Grading',
# Manual 採点
   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',
# マップ has branchings. Use advanced 編集 (538)または.
   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',
# マップ has conditions. Use advanced 編集 (538)または.
   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',
# マップ has リソース parameters. Use advanced 編集 (538)または.
   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',
# マップ has unconnected リソースs (577). Use advanced 編集 (538)または.
   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',
# Maximum Number of (565) Collabまたはat (522)またはs
   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',
# Maximum Number of (565) Collabまたはat (522)またはs (maxcollabまたはat (522)またはs)
   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',
# Maximum Number of (565) 受験回数 (max受験回数)
   'Messaging'
=> 'Messaging',

   'Middle'
=> 'Middle',

   'Middle Name'
=> 'Middle Name',
# Middle 名前
   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',
# Missing Kerberos ドメイン infまたはmat (522)ion.
   'Modification may make assessment data inaccessible'
=> 'Modification may make assessment data inaccessible',
# Modificat (522)ion ５月 make Assessment (60) dat (522)a inaccessible
   'Modify Enrollment for'
=> 'Modify Enrollment for',
# Modify 出席ment fまたは
   'Modify User'
=> 'Modify User',
# Modify ユーザ
   'Modify another students data'
=> 'Modify another students data',
# Modify another 学生s dat (522)a
   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',
# Modify 締め切り, etc, fまたは this (583) リソース
   'Modifying data for user'
=> 'Modifying data for user',
# Modifying dat (522)a fまたは ユーザ
   'Modifying this will make problems'
=> 'Modifying this will make problems',
# Modifying this (583) will make problem (572)s
   'Move current file to'
=> 'Move current file to',
# Move curRe (331)nt ファイル To (439)
   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',
# Must 作成 new subdiRe (331)ctまたはy inside a diRe (331)ctまたはy
   'Name of Role'
=> 'Name of Role',
# 名前 of (565) 役割
   'Navigate'
=> 'Navigate',
# ナビゲート
   'New Directory'
=> 'New Directory',
# New DiRe (331)ctまたはy
   'New HTML file'
=> 'New HTML file',
# New HTML (204) ファイル
   'New Resource'
=> 'New Resource',
# New リソース
   'New Role'
=> 'New Role',
# New 役割
   'New User'
=> 'New User',
# New ユーザ
   'New Value'
=> 'New Value',
# New Value (472)
   'New assembled page'
=> 'New assembled page',
# New assembled ページ
   'New assembled sequence'
=> 'New assembled sequence',
# New assembled シーケンス (581)
   'New custom rights file'
=> 'New custom rights file',
# New cusTo (439)m rights ファイル
   'New file'
=> 'New file',
# New ファイル
   'New problem'
=> 'New problem',
# New problem (572)
   'New style file'
=> 'New style file',
# New style ファイル
   'New subdirectory'
=> 'New subdirectory',
# New subdiRe (331)ctまたはy
   'Next    '
=> 'Next    ',
# Next (273)    
   'No'
=> 'No',

   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',
# No Access または Usages Stat (522)istics aRe (331) available fまたは this (583) リソース.
   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',
# No Assessment (60) Stat (522)istical Dat (522)a is available fまたは this (583) リソース
   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',
# No Evaluat (522)ion Dat (522)a is available fまたは this (583) リソース.
   'No new filename specified.'
=> 'No new filename specified.',
# No new ファイル名前 specified.
   'No section assigned'
=> 'No section assigned',
# No Section (354) assigned
   'No such file'
=> 'No such file',
# No such ファイル
   'Not Allowed'
=> 'Not Allowed',
# Not ALL (37) (519)o水
   'Not applicable - '
=> 'Not applicable - ',

   'Not open to be viewed'
=> 'Not open to be viewed',
# Not Open (284) To (439) be 閲覧ed
   'Not set - '
=> 'Not set - ',
# Not セットする - 
   'Notification of enrollment changes'
=> 'Notification of enrollment changes',
# Notificat (522)ion of (565) 出席ment Change (75)s
   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',
# Notificat (522)ion To (439) コース coまたはdinat (522)または via LON-CAPa.m. (513)ssage when 出席ment Change (75)s occur during the auTo (439)mat (522)ed Up (461)dat (522)e?
   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',
# Number of (565) 受験回数 befまたはe hints appear (hint受験回数)
   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',
# Number of (565) assignments printed at (522) the same Time (438):
   'Number of bubbles in exam mode (numbubbles)'
=> 'Number of bubbles in exam mode (numbubbles)',
# Number of (565) bubbles in exam mode (numbubbles)
   'Number of columns'
=> 'Number of columns',
# Number of (565) Column (91)s
   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',
# Numerical To (439)lerance (To (439)l)
   'Old Value'
=> 'Old Value',
# Old Value (472)
   'One particular problem'
=> 'One particular problem',
# One パート (569)icular problem (572)
   'One particular problem (overrides folder and course defaults)'
=> 'One particular problem (overrides folder and course defaults)',
# One パート (569)icular problem (572) (overrides Folder (179) and コース Default (119) (535)s)
   'Online Help'
=> 'Online Help',
# Online ヘルプ
   'Only Answers'
=> 'Only Answers',
# Only 回答s
   'Only domain coordinators can change a users password.'
=> 'Only domain coordinators can change a users password.',
# Only ドメイン coまたはdinat (522)またはs can Change (75) a ユーザs passwまたはd.
   'Open Course'
=> 'Open Course',
# Open (284) コース
   'Open all assessments'
=> 'Open all assessments',
# Open (284) ALL (37) (519) Assessment (60)s
   'Open and correct'
=> 'Open and correct',
# Open (284) and cまたはRe (331)ct
   'Open with full tries'
=> 'Open with full tries',
# Open (284) with full 受験回数
   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',
# Open (284)ing Dat (522)e (contenTo (439)pen)
   'Opening Date (opendate)'
=> 'Opening Date (opendate)',
# Open (284)ing Dat (522)e (Open (284)dat (522)e)
   'Output Format: [_1]'
=> 'Output Format: [_1]',
# Output (288) Fまたはmat (522): [_1]
   'Page layout'
=> 'Page layout',
# ページ layout
   'Paper type'
=> 'Paper type',
# Paper Type (446)
   'Parameter'
=> 'Parameter',

   'Part Description (display)'
=> 'Part Description (display)',
# パート (569) Description (表示する)
   'Paste after selected'
=> 'Paste after selected',
# Paste after 選択するed
   'Personal Data'
=> 'Personal Data',
# Personal Dat (522)a
   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',
# Please 選択 the Default (119) (535) auそれからticat (522)ion method To (439) be used By (71) new ユーザs added To (439) this (583) LON-CAPA ドメイン By (71) the auTo (439)mat (522)ed 出席ment process
   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',
# Please click Back on your bRow (345)ser and 選択する：nother ユーザ, または 
   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',
# Please コンタクト your LON-CAPA a.m. (513)nistrat (522)または Re (331)garding this (583) situat (522)ion.
   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',
# Please 選択する：n auそれからticat (522)ion mechanism
   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',
# Please 選択する the auそれからticat (522)ion mechanism
   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',
# Please 選択する the Section (354) you wish To (439) セットする the 回答 Open (284) dat (522)e fまたは:
   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',
# Please 選択する the Section (354) you wish To (439) セットする the Due (149) dat (522)e fまたは:
   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',
# Please 選択する the Section (354) you wish To (439) セットする the number of (565) 受験回数 fまたは:
   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',
# Please 選択する the Section (354) you wish To (439) セットする the Open (284)ing dat (522)e fまたは:
   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',
# Please 選択する the Section (354) you wish To (439) セットする the problem (572) weight fまたは:
   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',
# Please 選択する the 学生 you wish To (439) セットする the 回答 Open (284) dat (522)e fまたは:
   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',
# Please 選択する the 学生 you wish To (439) セットする the Due (149) dat (522)e fまたは:
   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',
# Please 選択する the 学生 you wish To (439) セットする the number of (565) 受験回数 fまたは:
   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',
# Please 選択する the 学生 you wish To (439) セットする the Open (284)ing dat (522)e fまたは:
   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',
# Please 選択する the 学生 you wish To (439) セットする the problem (572) weight fまたは:
   'Please stand by.'
=> 'Please stand by.',
# Please stand By (71).
   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",
# Please use bRow (345)ser 'Back' butTo (439)n and pick a ファイル名前
   'Preparing Printout'
=> 'Preparing Printout',
# PRe (331)paring 印刷する
   'Print'
=> 'Print',

   'Print Index:'
=> 'Print Index:',

   'Print Table of Contents:'
=> 'Print Table of Contents:',
# Print Table of (565) コンテンツ:
   'Print:'
=> 'Print:',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',
# Privileged ユーザs that (522) should not be hidden on staff listings
   'Problems from entire course'
=> 'Problems from entire course',
# problem (572)s From (187) entiRe (331) コース
   'Processed file'
=> 'Processed file',
# Processed ファイル
   'Publish this Resource'
=> 'Publish this Resource',
# Publish (323) this (583) リソース
   'Question Type (type)'
=> 'Question Type (type)',
# Question Type (328) (446) (Type (446))
   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',
# Random seed fまたは randomly picking number of (565) リソースs (577) (optional, only セットする if you know what (522) you aRe (331) doing) (randompickseed)
   'Randomization algorithm used'
=> 'Randomization algorithm used',
# Randomizat (522)ion algまたはithm used
   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',
# Randomly pick number of (565) リソースs (577) (randompick)
   'Reading results from [_1]'
=> 'Reading results from [_1]',
# Re (331)ading Re (331)sults From (187) (333) [_1]
   'Receipt algorithm used'
=> 'Receipt algorithm used',
# Re (331)ceipt algまたはithm used
   'Receiving results from [_1]'
=> 'Receiving results from [_1]',
# Re (331)ceiving Re (331)sults From (187) [_1]
   'Recent'
=> 'Recent',
# Re (331)cent
   'Rename current file to'
=> 'Rename current file to',
# リネームする curRe (331)nt ファイル To (439)
   'Report a Bug'
=> 'Report a Bug',
# Re (331)pまたはt a Bug
   'Resource'
=> 'Resource',
# リソース
   'Resource Differences'
=> 'Resource Differences',
# リソース Differ設定
   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',
# リソース Hidden From (187) 学生s (hiddenリソース)
   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',
# リソース alias 名前 fまたは conditions (マップalias)
   'Resources'
=> 'Resources',
# リソースs (577)
   'Resources from selected sequence in course'
=> 'Resources from selected sequence in course',
# リソースs (577) From (187) 選択するed シーケンス (581) in コース (545)
   'Response'
=> 'Response',
# Re (331)sponse
   'Retrieve Old Version'
=> 'Retrieve Old Version',
# Re (331)trieve (341) Old バージョン
   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',
# Re (331)trieving curRe (331)nt (most Re (331)cent (557)) バージョン
   'Return to DOCS'
=> 'Return to DOCS',
# Re (331)turn To (439) docs
   'Reverse Association'
=> 'Reverse Association',
# Re (331)verse Associat (522)ion
   'Revoke'
=> 'Revoke',
# Re (331)voke
   'Revoke Existing Roles'
=> 'Revoke Existing Roles',
# Re (331)voke Existing 役割
   'Role'
=> 'Role',
# 役割
   'Role Information'
=> 'Role Information',
# 役割 Infまたはmat (522)ion
   'Sample Points:'
=> 'Sample Points:',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',
# 保存する en受験回数 below as a draft 回答 (not 提出するting them fまたは cRe (331)dit (538) yet)
   'Search Complete [_1]'
=> 'Search Complete [_1]',
# 検索する Complete [_1]
   'Search: [_1]'
=> 'Search: [_1]',
# 検索する: [_1]
   'Select Action'
=> 'Select Action',
# 選択する：ction
   'Select All Files'
=> 'Select All Files',
# 選択する：ll (519) ファイルs
   'Select All Published'
=> 'Select All Published',
# 選択する：ll (519) Publish (323)ed (326)
   'Select All Resources'
=> 'Select All Resources',
# 選択する：ll (519) リソースs (577)
   'Select Folder'
=> 'Select Folder',
# 選択する Folder (179)
   'Select Only Current Students'
=> 'Select Only Current Students',
# 選択する Only CurRe (331)nt 学生s
   'Select Printing Options:'
=> 'Select Printing Options:',
# 選択する Printing Options:
   'Select Problem'
=> 'Select Problem',
# 選択する problem (572)
   'Select Problem(s) to print'
=> 'Select Problem(s) to print',
# 選択する problem (572)(s) To (439) print
   'Select Resource(s) to print'
=> 'Select Resource(s) to print',
# 選択する リソース(s) To (439) print
   'Select Resources To Print'
=> 'Select Resources To Print',
# 選択する リソースs (577) To (439) Print
   'Select Section'
=> 'Select Section',
# 選択する Section (354)
   'Select Sequence To Print From'
=> 'Select Sequence To Print From',
# 選択する シーケンス (581) To (439) Print From (187)
   'Select Student'
=> 'Select Student',
# 選択する 学生
   'Select Students and Resources'
=> 'Select Students and Resources',
# 選択する 学生s and リソースs (577)
   'Select Style File'
=> 'Select Style File',
# 選択する Style ファイル
   'Select a user name to modify the students information'
=> 'Select a user name to modify the students information',
# 選択する： ユーザ 名前 To (439) modify the 学生s infまたはmat (522)ion
   'Select a user name to view the users personal page.'
=> 'Select a user name to view the users personal page.',
# 選択する： ユーザ 名前 To (439) 閲覧 the ユーザs personal ページ.
   'Select for Section/Group'
=> 'Select for Section/Group',
# 選択する fまたは 章／グループ (461)
   'Select resources for the assignment'
=> 'Select resources for the assignment',
# 選択する リソースs (577) fまたは the assignment
   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',
# 選択する the Folder (179) you wish To (439) セットする the parameter fまたは:
   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',
# 選択する the problem (572) you wish To (439) セットする the parameter fまたは:
   'Set'
=> 'Set',
# セットする
   'Set Course Environment'
=> 'Set Course Environment',
# セットする コース Environment
   'Set End Date'
=> 'Set End Date',
# セットする 終了 Dat (522)e
   'Set Individual User Roles'
=> 'Set Individual User Roles',
# セットする Individual ユーザ 役割
   'Set Problem Tries'
=> 'Set Problem Tries',
# セットする problem (572) 受験回数
   'Set Problem Weight'
=> 'Set Problem Weight',
# セットする problem (572) Weight
   'Set Start Date'
=> 'Set Start Date',
# セットする スタート Dat (522)e
   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',
# セットする 回答 Open (284) dat (522)e fまたは ALL (37) (519) problem (572)s in the コース fまたは ...
   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',
# セットする 回答 Open (284) dat (522)e fまたは the 選択するed Folder (179) fまたは ...
   'Set answer open date for the selected problem for ...'
=> 'Set answer open date for the selected problem for ...',
# セットする 回答 Open (284) dat (522)e fまたは the 選択するed problem (572) fまたは ...
   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',
# セットする content feedback (540) To (439) コース Coまたはdinat (522)または
   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',
# セットする コース policy feedback (540) To (439) コース Coまたはdinat (522)または
   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',
# セットする Due (149) dat (522)e fまたは ALL (37) (519) problem (572)s in the コース fまたは ...
   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',
# セットする Due (149) dat (522)e fまたは the 選択するed Folder (179) fまたは ...
   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',
# セットする Due (149) dat (522)e fまたは the 選択するed problem (572) fまたは ...
   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',
# セットする number of (565) 受験回数 fまたは ALL (37) (519) problem (572)s in the コース fまたは ...
   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',
# セットする number of (565) 受験回数 fまたは the 選択するed Folder (179) fまたは ...
   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',
# セットする number of (565) 受験回数 fまたは the 選択するed problem (572) fまたは ...
   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',
# セットする Open (284)ing dat (522)e fまたは ALL (37) (519) problem (572)s in the コース fまたは ...
   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',
# セットする Open (284)ing dat (522)e fまたは ALL (37) (519) problem (572)s in the コース fまたは. . .
   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',
# セットする Open (284)ing dat (522)e fまたは the 選択するed Folder (179) fまたは ...
   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',
# セットする Open (284)ing dat (522)e fまたは the 選択するed problem (572) fまたは ...
   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',
# セットする problem (572) weight fまたは ALL (37) (519) problem (572)s in the コース fまたは ...
   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',
# セットする problem (572) weight fまたは the 選択するed Folder (179) fまたは ...
   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',
# セットする problem (572) weight fまたは the 選択するed problem (572) fまたは ...
   'Set to ...'
=> 'Set to ...',
# セットする To (439) ...
   'Set value to "[_1]" to allow'
=> 'Set value to "[_1]" to allow',
# セットする Value (472) To (439) "[_1]" To (439) ALL (37) (519)ow
   'Setting the [_1]'
=> 'Setting the [_1]',
# セットするting the [_1]
   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',
# セットするting the [_1] To (439) [_2]
   'Show Answer'
=> 'Show Answer',
# Show 回答
   'Show Feedback'
=> 'Show Feedback',
# Show feedback (540)
   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',
# Show problem (572) Stat (522)us (problem (572)stat (522)us)
   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',
# Show Units - Disable Entry (turnof (565)funit)
   'Show all rles'
=> 'Show all rles',
# Show ALL (37) (519) rles
   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Simple Edit'
=> 'Simple Edit',
# Simple 編集 (538)
   'Some items were not submitted'
=> 'Some items were not submitted',
# Some items weRe (331) not 提出するted
   'Start Time'
=> 'Start Time',
# スタート Time (438)
   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",
# スタート each 学生's assignment on a new ページ/Column (91) (add a ページfeed after each assignment)
   'Starting Date'
=> 'Starting Date',
# スタートing (403) Dat (522)e
   'Student ID'
=> 'Student ID',
# 学生 ID
   'Student Information'
=> 'Student Information',
# 学生 Infまたはmat (522)ion
   'Student Name'
=> 'Student Name',
# 学生 名前
   'Student Sheet Links'
=> 'Student Sheet Links',
# 学生 Sheet Links
   'Student Status'
=> 'Student Status',
# 学生 Stat (522)us
   'Student Status: [_1]'
=> 'Student Status: [_1]',
# 学生 Stat (522)us: [_1]
   'Student information updated successfully.'
=> 'Student information updated successfully.',
# 学生 infまたはmat (522)ion Up (461)dat (522)ed successfully.
   'Students need access key to enter course'
=> 'Students need access key to enter course',
# 学生s need access key To (439) 入力 コース
   'Students with expired roles'
=> 'Students with expired roles',
# 学生s with expiRe (331)d 役割
   'Subject:'
=> 'Subject:',
# 表題 (582):
   'Submissions'
=> 'Submissions',
# Submissions (556)
   'Submit Modifications'
=> 'Submit Modifications',
# 提出する Modificat (522)ions
   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',
# 提出する en受験回数 below as 回答 To (439) Re (331)ceive cRe (331)dit (538)
   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',
# S水ish Chef
   'System Level'
=> 'System Level',
# システム Level
   'Target Edit Map'
=> 'Target Edit Map',
# ターゲット 編集 (538) マップ
   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',
# TeX unconverted Due (149) To (439) errまたはs
   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',
# TeX unconverted Due (149) To (439) pRe (331)vious errまたはs
   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.',
# The &quot;コース Description&quot; is the 名前 of (565) the コース that (522) will be seen By (71) the 学生s. You ５月 now modify the description and hit &quot;Next (273) -&gt;&quot; To (439) continue.
   'The error reported was'
=> 'The error reported was',
# The errまたは Re (331)pまたはted was
   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',
# The following en受験回数 will be used To (439) identify the コース accまたはding To (439) the naming scheme adopted By (71) your institution. Your choices will be used To (439) マップ an internal LON-CAPA コース ID To (439) the cまたはRe (331)sponding コース Section (354) ID(s) used By (71) the of (565)fice Re (331)sponsible fまたは providing of (565)ficial class lists fまたは コースs at (522) your institution. this (583) マップping is Re (331)quiRe (331)d if you 選択 To (439) employ auTo (439)mat (522)ic populat (522)ion of (565) class lists.
   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",
# The following セットするtings control auTo (439)mat (522)ic 出席ment of (565) 学生s in this (583) class based on infまたはmat (522)ion available fまたは this (583) specific コース From (187) your institution's of (565)ficial classlists.
   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',
# The question can not be gotten cまたはRe (331)ct, the following Foil (177)s (178) in the &lt;optionRe (331)sponse&gt; have invalid cまたはRe (331)ct options
   'The requested file'
=> 'The requested file',
# The Re (331)quested ファイル
   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',
# The 学生 must log out and 再度ログインしてください To (439) see these Change (75)s.
   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',
# TheRe (331) aRe (331) curRe (331)ntly no Errまたは Messages fまたは this (583) リソース.
   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',
# TheRe (331) aRe (331) no Evaluat (522)ion Comments on this (583) リソース.
   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',
# TheRe (331) aRe (331) no curRe (331)ntly 出席ed 学生s in the コース.
   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',
# TheRe (331) aRe (331) no curRe (331)ntly 出席ed 学生s in the 選択するed Section (354)s (355).
   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',
# TheRe (331) aRe (331) no pRe (331)viously 出席ed 学生s in the コース.
   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',
# TheRe (331) aRe (331) no pRe (331)viously 出席ed 学生s in the 選択するed Section (354)s (355).
   'There are no students in the course.'
=> 'There are no students in the course.',
# TheRe (331) aRe (331) no 学生s in the コース.
   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',
# TheRe (331) aRe (331) no 学生s in the 選択するed Section (354)s (355).
   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',
# TheRe (331) was an errまたは determining the environment Value (472)s fまたは
   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',
# this (583) controls how Re (331)ceipt numbers aRe (331) generat (522)ed.
   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',
# this (583) ヘルプer will セットする Up (461) your LON-CAPA コース and 選択 which feat (522)uRe (331)s will be active.
   'To create a new'
=> 'To create a new',
# To (439) 作成 a new
   'Top Level Map'
=> 'Top Level Map',
# To (439)p Level マップ
   'Type Name Here'
=> 'Type Name Here',
# Type (446) 名前 HeRe (331)
   'Type in value'
=> 'Type in value',
# Type (446) in Value (472)
   'Type:'
=> 'Type:',
# Type (446):
   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',
# UN表示するABLE
   'Unable to enroll'
=> 'Unable to enroll',
# Unable To (439) 出席
   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',
# Unable To (439) Publish (323) ファイル, it contains dUp (461)licat (522)ed ID(s), ID(s) need To (439) be unique. The dUp (461)licat (522)ed ID(s) aRe (331)
   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',
# Unable To (439) Re (331)trieve (341) environment dat (522)a fまたは
   'Unable to set default dates for course'
=> 'Unable to set default dates for course',
# Unable To (439) セットする Default (119) (535) dat (522)es fまたは コース
   'Unavailable course'
=> 'Unavailable course',
# Unavailable コース
   'Undetermined - ISO'
=> 'Undetermined - ISO',

   'Unknown Action'
=> 'Unknown Action',

   'Unselect All Files'
=> 'Unselect All Files',
# Un選択する：ll (458) (519) ファイルs
   'Unselect All Published'
=> 'Unselect All Published',
# Un選択する：ll (458) (519) Publish (323)ed (326)
   'Unselect All Resources'
=> 'Unselect All Resources',
# Un選択する：ll (458) (519) リソースs (577)
   'Unselect for Section/Group'
=> 'Unselect for Section/Group',
# Un選択する fまたは 章／グループ (461)
   'Upload class list'
=> 'Upload class list',
# Up (461)負荷 class list
   'Upload file'
=> 'Upload file',
# Up (461)負荷 ファイル
   'Upload file to Construction Space'
=> 'Upload file to Construction Space',
# Up (461)負荷 ファイル To (439) Con作成するion スペース
   'VIEW'
=> 'VIEW',
# 閲覧
   'View the FAQ'
=> 'View the FAQ',
# 閲覧 the FAQ
   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',
# Visibly Separat (522)e Items on ページs (568)
   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',
# WARNING: The metadat (522)a table does not exist in the LON-CAPA dat (522)abase.
   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',
# Warning: Change (75) of (565) ＭＩＭＥタイプ (256) (446)!
   'Warning: target file exists!'
=> 'Warning: target file exists!',
# Warning: ターゲット ファイル exists!
   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',
# Warning: ターゲット ファイル exists, and has been Publish (323)ed (326)!
   'Weight (weight)'
=> 'Weight (weight)',

   'Welcome to Your New LON-CAPA Course'
=> 'Welcome to Your New LON-CAPA Course',
# Welcome (488) To (439) Your New LON-CAPA コース
   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',
# What (522) parameter do you want To (439) セットする fまたは the 選択するed Folder (179)?
   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',
# What (522) parameter do you want To (439) セットする fまたは the 選択するed problem (572)?
   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',
# What (522) should the 回答 Open (284) dat (522)e be セットする To (439)?
   'What should the due date be set to?'
=> 'What should the due date be set to?',
# What (522) should the Due (149) dat (522)e be セットする To (439)?
   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',
# What (522) weight should be セットする fまたは ALL (37) (519) problem (572)s in the コース?
   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',
# What (522) weight should be セットする fまたは the 選択するed Folder (179)?
   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',
# What (522) weight should be セットする fまたは the 選択するed problem (572)?
   'Width'
=> 'Width',

   'With Answers'
=> 'With Answers',
# With 回答s
   'Without Answers'
=> 'Without Answers',
# Without 回答s
   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',
# You aRe (331) wまたはking with an un保存するd バージョン of (565) your マップ.
   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',
# You Change (75)d the 学生s id but did not disable the ID Change (75) safeguard. The 学生s id will not be Change (75)d.
   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.',
# Your コース is now セットする Up (461). Please 選択する the Finish コース Initializat (522)ion butTo (439)n To (439) Re (331)-intialize the コース with your chosen セットするtings. Re (331)member that (522) ALL (37) (519) of (565) these セットするtings can be Modified (257) in the パラメータ scRe (331)en, By (71) pushing the コース Environment butTo (439)n.
   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',
# Your Re (331)quest To (439) Change (75) the 役割 infまたはmat (522)ion fまたは this (583) 学生 was Re (331)fused. You do not appear To (439) have sufficient authまたはity To (439) Change (75) 学生 infまたはmat (522)ion.
   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',
# [_1] (what (522) you just saw on the scRe (331)en)
   '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])'
=> '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])',
# [_1] ファイルシステム Auそれからticat (522)ed (mit Anfangspasswまたはt [_2])
   '[_1] Internally authenticated (mit Anfangspasswort [_2])'
=> '[_1] Internally authenticated (mit Anfangspasswort [_2])',
# [_1] InternALL (37) (519)y auそれからticat (522)ed (mit Anfangspasswまたはt [_2])
   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',
# [_1] Local Auそれからticat (522)ion with argument [_2]
   '[_1] Records per Page'
=> '[_1] Records per Page',
# [_1] Re (331)cまたはds Per ページ (295)
   '[_1] minutes'
=> '[_1] minutes',
# [_1] minutes (555)
   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',
# [_1] minutes (555), [_2] second (578)s (579)
   '[_1] with value [_2]'
=> '[_1] with value [_2]',
# [_1] with Value (472) [_2]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# [_1]pRe (331)v[_2] &nbsp; [_3]Re (331)負荷[_4] &nbsp; [_5]Next (273)[_6]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',
# [_1]pRe (331)v[_2] &nbsp; [_3]Re (331)負荷[_4] &nbsp; Next (273)
   '[_2] seconds'
=> '[_2] seconds',
# [_2] second (578)s (579)
   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',
# a comma separat (522)ed list of (565) コース Section (354)s (355) crosslisted with the curRe (331)nt コース, with each entry including the institutional コース Section (354) 名前 follo水 By (71) a colon and それから the (optional) groUp (461)ID To (439) be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2
   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',
# a comma separat (522)ed list of (565) institutional Section (354) numbers, each separat (522)ed By (71) a colon From (187) the (optional) cまたはRe (331)sponding 章／グループ (461) ID To (439) be used in LON-CAPA e.g., 001:1,002:2
   'after selected'
=> 'after selected',
# after 選択するed
   'all resources in the course'
=> 'all resources in the course',
# ALL (37) (519) リソースs (577) in the コース
   'all students in course'
=> 'all students in course',
# ALL (37) (519) 学生s in コース (545)
   'and'
=> 'and',

   'anno-[_1]'
=> 'anno-[_1]',
# アノ[_1]
   'anno.gif'
=> 'anno.gif',

   'anonymous students'
=> 'anonymous students',
# Anonymous (52) (521) 学生s
   'anot.gif'
=> 'anot.gif',

   'answer date'
=> 'answer date',
# 回答 dat (522)e
   'backward[_1]'
=> 'backward[_1]',
# 後[_1]
   'bchat.gif'
=> 'bchat.gif',
# bチャット.gif
   'between'
=> 'between',

   'bookmark[_2]'
=> 'bookmark[_2]',
# ブックマーク[_2]
   'button'
=> 'button',
# butTo (439)n
   'by'
=> 'by',
# By (71)
   'catalog.gif'
=> 'catalog.gif',
# cat (522)alog (529).gif
   'catalog[_1]'
=> 'catalog[_1]',
# cat (522)alog (529)[_1]
   'ccrs.gif'
=> 'ccrs.gif',

   'changes will not show until next login'
=> 'changes will not show until next login',
# Change (75)s will not show until Next (273) login
   'check all'
=> 'check all',
# Check ALL (37) (79) (519)
   'chmod error'
=> 'chmod error',
# chmod errまたは
   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'click on the',

   'com.gif'
=> 'com.gif',

   'contacting [_1]'
=> 'contacting [_1]',
# コンタクトing (532) [_1]
   'copy Error'
=> 'copy Error',
# copy Errまたは
   'courses.gif'
=> 'courses.gif',
# コースs.gif
   'cprv.gif'
=> 'cprv.gif',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'currently does not exist',
# curRe (331)ntly does not exist
   'custom'
=> 'custom',
# cusTo (439)m
   'custom distribution file'
=> 'custom distribution file',
# cusTo (439)m distribution ファイル
   'discuss[_1]'
=> 'discuss[_1]',
# discuss (537)[_1]
   'docs.gif'
=> 'docs.gif',

   'domain'
=> 'domain',
# ドメイン
   'due date'
=> 'due date',
# Due (149) dat (522)e
   'egrd.gif'
=> 'egrd.gif',

   'enrl.gif'
=> 'enrl.gif',

   'eval.gif'
=> 'eval.gif',

   'evaluate[_1]'
=> 'evaluate[_1]',
# evaluat (522)e (539)[_1]
   'expired or revoked'
=> 'expired or revoked',
# expiRe (331)d または Re (331)voked
   'extension'
=> 'extension',

   'external'
=> 'external',

   'fdbk.gif'
=> 'fdbk.gif',

   'feedback[_1]'
=> 'feedback[_1]',
# feedback (540)[_1]
   'file<br />extension'
=> 'file<br />extension',
# ファイル<br />extension
   'first name'
=> 'first name',
# first 名前
   'for'
=> 'for',
# fまたは
   'for <b>all resources in the course</b>'
=> 'for <b>all resources in the course</b>',
# fまたは <b>ALL (37) (519) リソースs (577) in the コース</b>
   'for <b>all students in course</b>'
=> 'for <b>all students in course</b>',
# fまたは <b>ALL (37) (519) 学生s in コース (545)</b>
   'for [_1]'
=> 'for [_1]',
# fまたは [_1]
   'for section [_1]'
=> 'for section [_1]',
# fまたは Section (354) [_1]
   'for the map named [_1]'
=> 'for the map named [_1]',
# fまたは the マップ 名前d [_1]
   'for the resource named [_1]'
=> 'for the resource named [_1]',
# fまたは the リソース 名前d [_1]
   'for visible separation'
=> 'for visible separation',
# fまたは visible separat (522)ion
   'forward[_1]'
=> 'forward[_1]',
# fまたはward[_1]
   'from'
=> 'from',
# From (187)
   'from current subdirectory'
=> 'from current subdirectory',
# From (187) curRe (331)nt subdiRe (331)ctまたはy
   'generation'
=> 'generation',
# generat (522)ion
   'grds.gif'
=> 'grds.gif',

   'have different numbers and answers'
=> 'have different numbers and answers',
# have diffeRe (331)nt numbers and 回答s
   'helper'
=> 'helper',
# ヘルプer
   'in'
=> 'in',

   'in domain'
=> 'in domain',
# in ドメイン
   'instructor'
=> 'instructor',
# in作成するまたは
   'internal'
=> 'internal',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',
# is in this (583) stat (522)e By (71) royal decRe (331)e.
   'is ready for download'
=> 'is ready for download',
# is Re (331)ady fまたは down負荷
   'keys.gif'
=> 'keys.gif',

   'last name'
=> 'last name',
# last 名前
   'logout.gif'
=> 'logout.gif',

   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',
# make these dat (522)es the Default (119) (535) fまたは futuRe (331) 出席ment
   'may be open from a different computer.'
=> 'may be open from a different computer.',
# ５月 be Open (284) From (187) a diffeRe (331)nt computer.
   'middle name'
=> 'middle name',
# middle 名前
   'name'
=> 'name',
# 名前
   'nav.gif'
=> 'nav.gif',

   'no ending date'
=> 'no ending date',
# no 終了ing dat (522)e
   'number'
=> 'number',

   'number of tries'
=> 'number of tries',
# number of (565) 受験回数
   'obsolete replacement'
=> 'obsolete replacement',
# 旧 (563) Re (331)placement
   'only check if you know what you are doing'
=> 'only check if you know what you are doing',
# only check if you know what (522) you aRe (331) doing
   'only search domain'
=> 'only search domain',
# only 検索する ドメイン
   'opening date'
=> 'opening date',
# Open (284)ing dat (522)e
   'optional'
=> 'optional',

   'or any other value'
=> 'or any other value',
# または any other Value (472)
   'parm.gif'
=> 'parm.gif',
# pa.m. (513)gif
   'pref.gif'
=> 'pref.gif',
# pRe (331)f.gif
   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# pRe (331)v &nbsp; [_3]Re (331)負荷[_4] &nbsp; [_5]Next (273)[_6]
   'private'
=> 'private',
# privat (522)e
   'problem weight'
=> 'problem weight',
# problem (572) weight
   'prt.gif'
=> 'prt.gif',

   'public'
=> 'public',

   'publisher<br />owner'
=> 'publisher<br />owner',
# Publish (323)er<br />owner
   'res.gif'
=> 'res.gif',
# Re (331)s.gif
   'role,role,...'
=> 'role,role,...',
# 役割,役割,...
   'roles.gif'
=> 'roles.gif',
# 役割.gif
   'sbkm.gif'
=> 'sbkm.gif',

   'section'
=> 'section',
# Section (354)
   'selected students'
=> 'selected students',
# 選択するed 学生s
   'set[_1]'
=> 'set[_1]',
# セットする[_1]
   'spacer.gif'
=> 'spacer.gif',
# スペースr.gif
   'spellcheck_lang'
=> 'spellcheck_lang',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'standard'
=> 'standard',

   'standard LaTeX mode'
=> 'standard LaTeX mode',
# standard Lat (522)eX mode
   'standard courses only'
=> 'standard courses only',
# standard コースs only
   'stat.gif'
=> 'stat.gif',
# stat (522).gif
   'student'
=> 'student',
# 学生
   'student name'
=> 'student name',
# 学生 名前
   'template'
=> 'template',
# templat (522)e
   'to'
=> 'to',
# To (439)
   'to [_1] ([_2])'
=> 'to [_1] ([_2])',
# To (439) [_1] ([_2])
   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',
# To (439) interface with institutional dat (522)a, e.g., fs03glg231 fまたは FALL (37) (519) 2003 Geology 231
   'unable to enroll'
=> 'unable to enroll',
# unable To (439) 出席
   'uncheck all'
=> 'uncheck all',
# UnCheck ALL (37) (79) (453) (519)
   'use related words'
=> 'use related words',
# use Re (331)lat (522)ed wまたはds
   'username'
=> 'username',
# ユーザ名前
   'vbkm.gif'
=> 'vbkm.gif',

   'versus'
=> 'versus',

   'waiting on [_1]'
=> 'waiting on [_1]',
# waiting on (589) [_1]
   'what you just saw on the screen'
=> 'what you just saw on the screen',
# what (522) you just saw on the scRe (331)en
   'with server'
=> 'with server',
# with サーバ
   'yes'
=> 'yes',
# はい


#SYNC Tue Aug 15 14:43:21 2006
   '# 16 Aug 14:45'
=> '# 16 Aug 14:45',
# # [_1]6 Aug [_1]4:45
   'Enter my portfolio space'
=> 'Enter my portfolio space',
# 入力 私の pまたはtfolio スペース
   'No syllabus information provided.'
=> 'No syllabus information provided.',
# No シラバス infまたはmat (522)ion provided.
   'Post Discussion'
=> 'Post Discussion',
# Post discuss (537)ion
   'Sorry ...'
=> 'Sorry ...',
# Sまたはry ...
   'This resource might be part of another course.'
=> 'This resource might be part of another course.',
# this (583) リソース might be パート (569) of (565) aNother コース.


#SYNC Tue Aug 15 16:12:12 2006
   '# mt fehlt'
=> '# mt fehlt',

   'Agree'
=> 'Agree',
# AgRe (331)e
   'Any comments? '
=> 'Any comments? ',

   'Copy this column'
=> 'Copy this column',
# Copy this (583) Column (91)
   'Disagree'
=> 'Disagree',
# DisagRe (331)e
   'General Intro'
=> 'General Intro',
# general (544) intro
   'Greek Symbols'
=> 'Greek Symbols',
# GRe (331)ek Symbols
   'HTML character enties'
=> 'HTML character enties',
# HTML (204) character enties
   'Highest Grade Level'
=> 'Highest Grade Level',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',
# If you aRe (331) 閲覧ing this (583) online, copy and paste the Text (425) From (187) any of (565) the right Column (91)s inTo (439) your Text (425) aRe (331)a To (439) get the symbol on the left.
   'LON-CAPA Help'
=> 'LON-CAPA Help',
# LON-CAPA ヘルプ
   'Landscape'
=> 'Landscape',

   'Launch navigation window'
=> 'Launch navigation window',
# Launch navigat (522)ion window
   'Lowest Grade Level'
=> 'Lowest Grade Level',

   'Mark all posts read'
=> 'Mark all posts read',
# Mark ALL (37) (519) posts Re (331)ad
   'My question/comment/feedback:'
=> 'My question/comment/feedback:',
# 私の question/comment/feedback (540):
   'Not set -'
=> 'Not set -',
# Not セットする -
   'Other Symbols'
=> 'Other Symbols',

   'Please check at least one of the following feedback types:'
=> 'Please check at least one of the following feedback types:',
# Please check at (522) least one of (565) the following feedback (540) Type (446)s:
   'Please rank the following criteria:'
=> 'Please rank the following criteria:',

   'Portrait'
=> 'Portrait',
# Pまたはtrait
   'Question about resource content'
=> 'Question about resource content',
# Question about リソース content
   'Question/Comment/Feedback about course policy'
=> 'Question/Comment/Feedback about course policy',
# Question/Comment/feedback (540) about コース policy
   'Select a Course to Enter'
=> 'Select a Course to Enter',
# 選択する： コース To (439) 入力
   'Sending Messages'
=> 'Sending Messages',
# S終了ing Messages
   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',
# Show Me 私の First Homewまたはk problem (572)
   'Standards'
=> 'Standards',

   'Strongly Agree'
=> 'Strongly Agree',
# Strongly AgRe (331)e
   'Strongly Disagree'
=> 'Strongly Disagree',
# Strongly DisagRe (331)e
   'Symbol'
=> 'Symbol',

   'The material appears to be correct '
=> 'The material appears to be correct ',
# The mat (522)erial appears To (439) be cまたはRe (331)ct 
   'The material is helpful '
=> 'The material is helpful ',
# The mat (522)erial is ヘルプful 
   'The material is presented in a clear way '
=> 'The material is presented in a clear way ',
# The mat (522)erial is pRe (331)sented in a clear way 
   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) ',
# The リソース is technicALL (37) (519)y cまたはRe (331)ct (負荷s fast eNough, does Not produce errまたはs, links wまたはk, etc) 


#SYNC Tue Aug 15 18:55:42 2006


#SYNC Fri Aug 18 20:46:55 2006
   'HTML character entities'
=> 'HTML character entities',
# HTML (204) character entities

#SYNCMARKER
);

1;


