# The LearningOnline Network with CAPA
# Russian Localization Lexicon
#
# $Id: x_chef.pm,v 1.2 2004/07/20 23:12:29 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::x_chef;
use base qw(Apache::localize);

%Lexicon=(
'char_encoding'=> 'ISO-8859-15',
'language_code'=> 'x_chef',
'date_locale'  =>
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds',
'date_months'  => 'Junooery,Febooery,Merch,Epreel,Mey,Joone-a,Jooly,Oogoost,September,Ooctuber,Nufember,December',
'date_days'    => 'So,Mu,To,Ve,Th,Fr,Se',
'date_am' => 'em',
'date_pm' => 'pm',
'textual_remote_display' => 'on',
'htmlarea_lang' => 'en'
);

sub init {
    my $lh = $_[0];  # a newborn handle
    $lh->SUPER::init();
    $lh->fail_with(\&fail);
    return;
}

sub fail {
    my ($lh,$key,@params) = @_;
    my $value = $lh->_compile(&chefify2($key));
    
    return $$value if ref($value) eq 'SCALAR';
    return $value unless ref($value) eq 'CODE';
    
    {
	local $SIG{'__DIE__'};
	eval { $value = &$value($lh, @params) };
    }
    return $value;
}


sub chefify {
    my ($str)=@_;
    $str=~s/\\/\\\\/g;
    $str=~s/\"/\\"/g; #"
    open(CHEF," echo \"$str\" | chef|");
    my $result;
    while (my $a=<CHEF>) { $result.=$a }
    chomp($result);
    $result=~s/\n/ /g;
    close CHEF;
    return $result;
}

# chef.pl by Teodor Zlatanov, tzz@iglou.com
# March 26, 2000
# adpated from chef.l by John Hagerman

sub create_parser {
    use Parse::RecDescent;

    $Parse::RecDescent::skip = '';          # skip nothing

    $lexer = new Parse::RecDescent q
{
 { my $niw = 0; my $i_seen = 0; } # set NIW , i_seen at start

 chef: token(s) /\z/

 token: end_of_sentence
        | Bbork
        | an | An
        | au | Au
        | ax | Ax
        | en
        | ew
        | edone
        | ex | Ex
        | f
        | ir
        | i
        | ow
        | o | O | xo
        | the | The | th
        | tion
        | u | U | v | V | w | W
        | NW   { $niw = 0; $i_seen = 0; $Apache::localize::x_chef::result .= $item[1] }
        | WC   { $niw = 1; $Apache::localize::x_chef::result .= $item[1] }
        | /\n/ { $niw = 0; $i_seen = 0; $Apache::localize::x_chef::result .= $item[1] }

 end_of_sentence: /[.?!]+/ /\s+/ { $niw = 0; $i_seen = 0; $Apache::localize::x_chef::result .= $item[1] . "\nBork Bork Bork!\n" }

 Bbork: <reject: $niw> /([Bb]ork)/ ...NW { $Apache::localize::x_chef::result .= "$1" }
 an: /an/ { $niw = 1; $Apache::localize::x_chef::result .= 'un' }
 An: /An/ { $niw = 1; $Apache::localize::x_chef::result .= 'Un' }
 au: /au/ { $niw = 1; $Apache::localize::x_chef::result .= 'oo' }
 Au: /Au/ { $niw = 1; $Apache::localize::x_chef::result .= 'Oo' }
 ax: /a/ ...WC { $niw = 1; $Apache::localize::x_chef::result .= "e" }
 Ax: /A/ ...WC { $niw = 1; $Apache::localize::x_chef::result .= "E" }
 en: /en/ ...NW { $niw = 1; $Apache::localize::x_chef::result .= "ee" }
 ew: <reject: !$niw> /ew/ { $niw = 1; $Apache::localize::x_chef::result .= "oo" }
 edone: <reject: !$niw> /e/ ...NW { $niw = 1; $Apache::localize::x_chef::result .= "e-a" }
 ex: <reject: $niw> /e/ { $niw = 1; $Apache::localize::x_chef::result .= "i" }
 Ex: <reject: $niw> /E/ { $niw = 1; $Apache::localize::x_chef::result .= "I" }
 f: <reject: !$niw> /f/ { $niw = 1; $Apache::localize::x_chef::result .= "ff" }
 ir: <reject: !$niw> /ir/ { $niw = 1; $Apache::localize::x_chef::result .= "ur" }
 i: <reject: !$niw> <reject: $i_seen> /i/ { $niw=1;$i_seen=1; $Apache::localize::x_chef::result .= "ee" }
 ow: <reject: !$niw> /ow/ { $niw = 1; $Apache::localize::x_chef::result .= "oo" }
 o: <reject: $niw> /o/ { $niw = 1; $Apache::localize::x_chef::result .= "oo" }
 O: <reject: $niw> /O/ { $niw = 1; $Apache::localize::x_chef::result .= "Oo" }
 xo: <reject: !$niw> /o/ { $niw = 1; $Apache::localize::x_chef::result .= "u" }
 the: /the/ { $niw = 1; $Apache::localize::x_chef::result .= 'zee' }
 The: /The/ { $niw = 1; $Apache::localize::x_chef::result .= 'Zee' }
 th: /th/ ...NW { $niw = 1; $Apache::localize::x_chef::result .= "t" }
 tion: <reject: !$niw> /tion/ { $niw = 1; $Apache::localize::x_chef::result .= "shun" }
 u: <reject: !$niw> /u/ { $niw = 1; $Apache::localize::x_chef::result .= "oo" }
 U: <reject: !$niw> /U/ { $niw = 1; $Apache::localize::x_chef::result .= "Oo" }
 v: /v/ { $niw = 1; $Apache::localize::x_chef::result .= 'f' }
 V: /V/ { $niw = 1; $Apache::localize::x_chef::result .= 'F' }
 w: /w/ { $niw = 1; $Apache::localize::x_chef::result .= 'v' }
 W: /W/ { $niw = 1; $Apache::localize::x_chef::result .= 'V' }

 WC: /[A-Za-z']/
 NW: /[^A-Za-z']/

};
}

sub chefify2 {
    my ($str) = @_;
    my $backup=$str;
    $Apache::localize::x_chef::result='';
    if (!defined($lexer)) { &create_parser(); }
    $lexer->chef(\$str);
    $Lexicon{$backup}=$Apache::localize::x_chef::result;
    return $Apache::localize::x_chef::result;
}

1;
