#   Implement a simple stack in terms of a list.
#
# $Id: Stack.pm,v 1.4 2003/04/24 15:12:40 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

=pod

=head1 Stack 

An object oriented implementation of a Stack data structure.
Stacks are first in last out data structures.

=head1 Member functions:

=cut

package Stack;

=pod

=head2 new  

    Creates a new instance of a stack. 
  
    my $stack = Stack->new();

=cut

sub new {
    my $class = shift;		# Class name.
    my $self  = [];		# Create an empty list to represent the stack.
    bless($self, $class);	# Turn this into an object and..
    return $self;		# Return it.
}

=pod

=head2 push

    takes an item and pushes it onto the back end of the stack.

    my $stack = Stack->new();
    $stack->push(something);

=cut

sub push {
    my $self = shift;		# Gets the list...
    my $item = shift;		# The item to push.
    push(@$self,$item);
}

=pod

=head2 pop

    Returns the item at the top of the stack: does a pop.

    my object = Stack->new();
    my $item = object->pop();

=cut

sub pop {
    my $self = shift;
    return pop(@$self);
}

=pod

=head 1

  Returns the number of items on the stack.

=cut

sub Count {
    my $self = shift;
    my $elements = scalar(@$self);
    return $elements;
}

1;

=pod

=head1 Internal implementation details

Stacks are implemented as lists.  Thus a stack is a thinly disguised
list with push and pop wrappers.  Since PERL is a dynamically typed
language, stacks can contain any data type ... including a
heterogenous collection of types.

=cut

