# The LearningOnline Network with CAPA
#
# Sequence Handler
#
# $Id: lonsequence.pm,v 1.30 2007/01/16 21:19:11 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonsequence;

use strict;
use Apache::lonnet;
use Apache::Constants qw(:common :http REDIRECT);
use GDBM_File;
use LONCAPA::map();
use Apache::lonpageflip();
use Apache::loncommon();
use Apache::lonlocal;
use HTML::Entities();

my %selhash;
my $successtied;

# ----------------------------------------- Attempt to read from resource space

sub attemptread {
    my $fn=shift;
    &Apache::lonnet::repcopy($fn);
    if (-e $fn) {
	return &LONCAPA::map::attemptread($fn);
    } else {
        return ();
    }
}

sub mapread {
    my $fn=shift;
    &Apache::lonnet::repcopy($fn);
    if (-e $fn) {
	return &LONCAPA::map::mapread($fn,'');
    } else {
        return ();
    }
}

# ---------------------------------------------------------------- View Handler

sub viewmap {
    my ($r,$url)=@_;

    my $js;
    if ($env{'form.forceselect'}) {
	$js = (<<ENDSCRIPT);
<script type="text/javascript">

function select_group() {
    window.location="/adm/groupsort?catalogmode=groupsec&mode=rat&acts="+document.forms.fileattr.acts.value;
}

function queue(val) {
    if (eval("document.forms."+val+".filelink.checked")) {
	var l=val.length;
	var v=val.substring(4,l);
	document.forms.fileattr.acts.value+='1a'+v+'b';
    }
    else {
	var l=val.length;
	var v=val.substring(4,l);
	document.forms.fileattr.acts.value+='0a'+v+'b';
    }
}

</script>
ENDSCRIPT
    }

    $r->print(&Apache::loncommon::start_page('Map Contents',$js).
	      '<h1>'.$url.'</h1>');
# ------------------ This is trying to select. Provide buttons and tie %selhash
    if ($env{'form.forceselect'}) { $r->print(<<ENDSELECT);
<form name=fileattr><input type=hidden name=acts value=''>
<input type="button" name="close" value='CLOSE' onClick="self.close()">
<input type="button" name="groupimport" value='GROUP IMPORT'
onClick="javascript:select_group()">
</form>   
ENDSELECT
    my $diropendb = 
    "/home/httpd/perl/tmp/$env{'user.domain'}\_$env{'user.name'}_sel_res.db";
        if (tie(%selhash,'GDBM_File',$diropendb,&GDBM_WRCREAT(),0640)) {
	    if ($env{'form.launch'} eq '1') {
	       &start_fresh_session();
	    }
            $successtied=1;

# - Evaluate actions from previous page (both cumulatively and chronologically)
        if ($env{'form.catalogmode'} eq 'import') {
	    my $acts=$env{'form.acts'};
	    my @Acts=split(/b/,$acts);
	    my %ahash;
	    my %achash;
	    my $ac=0;
	    # some initial hashes for working with data
	    foreach (@Acts) {
		my ($state,$ref)=split(/a/);
		$ahash{$ref}=$state;
		$achash{$ref}=$ac;
		$ac++;
	    }
	    # sorting through the actions and changing the tied database hash
	    foreach (sort {$achash{$a}<=>$achash{$b}} (keys %ahash)) {
		my $key=$_;
		if ($ahash{$key} eq '1') {
		    $selhash{'store_'.$selhash{'pre_'.$key.'_link'}}=
			$selhash{'pre_'.$key.'_title'};
		    $selhash{'storectr_'.$selhash{'pre_'.$key.'_link'}}=
			$selhash{'storectr'}+0;
		    $selhash{'storectr'}++;
		}
		if ($ahash{$key} eq '0') {
		    if ($selhash{'store_'.$selhash{'pre_'.$key.'_link'}}) {
		       delete $selhash{'store_'.$selhash{'pre_'.$key.'_link'}};
		    }
		}
	    }
	    # deleting the previously cached listing
	    foreach (keys %selhash) {
		if ($_ =~ /^pre_/ && $_ =~/link$/) {
		    my $key = $_;
		    $key =~ s/^pre_//;
		    $key =~ s/_[^_]*$//;
		    delete $selhash{'pre_'.$key.'_title'};
		    delete $selhash{'pre_'.$key.'_link'};
		}
	    }
	}
# -
        }
    }
# ----------------------------- successtied is now '1' if in working selectmode
    my ($errtext,$fatal)=&mapread(&Apache::lonnet::filelocation('',$url),'');
    if ($fatal==1) {
       $r->print('<p><b><font color="red">'.&mt('Map contents are not shown in order.').'</font></b></p><br />');
    }
    my $idx=0;
    foreach (&attemptread(&Apache::lonnet::filelocation('',$url))) {
	if (defined($_)) {
            $idx++;
            if ($successtied) { 
		$r->print('<form name="form'.$idx.'">');
            }
	    my ($title,$url)=split(/\:/,$_);
	    $title = &LONCAPA::map::qtescape($title);
	    unless ($title) { $title=(split(/\//,$url))[-1] };
            my $enc_title = &HTML::Entities::encode($title,'\'"<>&');
	    unless ($title) {
		$title='<i>'.&mt('Empty').'</i>';
		$enc_title = &mt('Empty');
	    }
	    $url  = &LONCAPA::map::qtescape($url);
            my $enc_url = &HTML::Entities::encode($url,'\'"<>&');
            if ($url) {
		if ($successtied) {
		    my $checked='';
	           if ($selhash{'store_'.$url}) {
	       	      $checked=" checked";
	           }
	           $selhash{"pre_${idx}_link"}=$url;
	           $selhash{"pre_${idx}_title"}=$title;
		    
		    $url  = &HTML::Entities::encode($url, '\'"<>&');
		    $r->print(<<ENDCHECKBOX);
<input type='checkbox' name='filelink' 
value='$enc_url' onClick='javascript:queue("form$idx")'$checked />
<input type='hidden' name='title' value='$enc_title' />
ENDCHECKBOX
                }
		$r->print('<a href="'.$enc_url.'">');
            }
            $r->print($enc_title);
            if ($url) { $r->print('</a>'); }
            if ($successtied) {
		$r->print('</form>');
            } else {
		$r->print('<br>');
            }
        }
    }
    $r->print(&Apache::loncommon::end_page());
    if ($successtied) {
	untie %selhash;
    }
}

# ----------------------------------------------------------- Clean out selhash
sub start_fresh_session {
    foreach (keys %selhash) {
	if ($_ =~ /^pre_/) {
	    delete $selhash{$_};
	}
	if ($_ =~ /^store/) {
	    delete $selhash{$_};
	}
    }
}


# ================================================================ Main Handler

sub handler {
   my $r=shift;

   if ($r->header_only) {
      &Apache::loncommon::content_type($r,'text/html');
      $r->send_http_header;
      return OK;
   }
 
   &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                          ['forceselect','launch']);

   my %hash;
   my %bighash;
   my $requrl=$r->uri;

   $successtied=0;
# ------------------------------------------------------------ Tie symb db file
  my $disurl='';
  my $dismapid='';
  my $exitdisid = '';
  my $arrow_dir = '';

  if (($env{'request.course.fn'}) && (!$env{'form.forceselect'})) {
       my $last;
       if (tie(%hash,'GDBM_File',$env{'request.course.fn'}.'_symb.db',
                    &GDBM_READER(),0640)) {
	   $last=$hash{'last_direction'};
           untie(%hash);
       }
       my $direction='';
       my $prevmap='';
       if ($last) {
	   ($prevmap,undef,$direction)=&Apache::lonnet::decode_symb($last);
       }
# ------------------------------------------------------------- Tie big db file
       if (tie(%bighash,'GDBM_File',$env{'request.course.fn'}.'.db',
                    &GDBM_READER(),0640)) {
	   my $disid='';
           my $randomout ='';

           if ($direction eq 'back') {
	       $disid=$bighash{'map_finish_'.$requrl};
           } else {
               $disid=$bighash{'map_start_'.$requrl};
           }
           if ($disid) {
	       $disurl=$bighash{'src_'.$disid};
               $dismapid=(split(/\./,$disid))[1];
	       if (!$env{'request.role.adv'}) {
		   $randomout = $bighash{'randomout_'.$disid};
	       }
           } elsif (tie(%hash,'GDBM_File',$env{'request.course.fn'}.'_symb.db',
                    &GDBM_READER(),0640)) {
               $last=$hash{'last_known'};
               untie(%hash);
           }


# ----------- If this is an empty one, or hidden, skip to next non-empty or non-hidden one
           while ( ((!$disurl) && ($disid)) || ($randomout && $disid) ) {
	       $direction=($direction?$direction:'forward');
               ($disid,$requrl)=
                         &Apache::lonpageflip::fullmove($disid,
                           &Apache::lonnet::declutter($requrl),$direction);
               if ($disid) {
	           $disurl=$bighash{'src_'.$disid};
                   $dismapid=(split(/\./,$disid))[1];
		   if (!$env{'request.role.adv'}) {
		       $randomout = $bighash{'randomout_'.$disid};
		   }
               }
 	   }
           $exitdisid = $disid;
           $arrow_dir = $direction;

# --------------------------------------- Untie hash, make sure to come by here
           untie(%bighash);
       }
   }

# now either disurl is set (going to first page), or we need another display
   if ($disurl) {
# -------------------------------------------------- Has first or last resource
      &Apache::lonnet::symblist($requrl,$disurl => [$disurl,$dismapid],
				'last_known' => [$disurl,$dismapid]); 
      &Apache::loncommon::content_type($r,'text/html');
      $r->header_out(Location => 'http://'.$ENV{'HTTP_HOST'}.$disurl);
      return REDIRECT;
   } else {
       &Apache::loncommon::content_type($r,'text/html');
       $r->send_http_header;
       if ($exitdisid eq '' && $arrow_dir ne '') {
           my %lt =&Apache::lonlocal::texthash(
                   'back' => 'beginning',
                   'forward' => 'end',
                   'nere' => 'Next resource could not be displayed',
                   'goba' => 'Go Back',
                   'nacc' => 'Navigate Course Content',
                          );
           my $warnmsg = &mt('As all folders and sequences ');
           if ($arrow_dir eq 'forward') {
               $warnmsg .= &mt('following the current resource were empty').',';
           } elsif ($arrow_dir eq 'back') {
               $warnmsg .= &mt('preceding the current resource were empty').',';
           }
           $warnmsg .= &mt('you have now reached the').' '.$lt{$arrow_dir}.' '.&mt('of the course.');
           my $start_page=
	       &Apache::loncommon::start_page('Empty Folder/Sequence');
           my $end_page=
	       &Apache::loncommon::end_page();
           $r->print(<<ENDNONE);
$start_page
<h3>$lt{'nere'}</h3>
<p>$warnmsg</p>
<ul>
  <li><a href="javascript:history.go(-1)">$lt{'goba'}</a></li>
  <li><a href="/adm/navmaps">$lt{'nacc'}</a></li>
</ul>
$end_page
ENDNONE
       } else {
           &viewmap($r,$requrl);
       }
       return OK;
   }
}

1;
__END__







