/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Vector;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Group;
import org.jmol.viewer.Token;

class Compiler {
    String filename;
    String script;
    short[] lineNumbers;
    short[] lineIndices;
    Token[][] aatokenCompiled;
    boolean error;
    String errorMessage;
    String errorLine;
    static final boolean logMessages = false;
    int cchScript;
    short lineCurrent;
    int ichToken;
    int cchToken;
    Token[] atokenCommand;
    int ichCurrentCommand;
    String[] loadFormats = new String[]{"alchemy ", "mol2 ", "mopac ", "nmrpdb ", "charmm ", "xyz ", "mdl ", "pdb "};
    Vector ltokenPostfix = null;
    Token[] atokenInfix;
    int itokenInfix;
    boolean residueSpecCodeGenerated;
    int seqcode;

    Compiler() {
    }

    private void log(String message) {
    }

    boolean compile(String filename, String script) {
        this.filename = filename;
        this.script = script;
        this.lineIndices = null;
        this.lineNumbers = null;
        this.aatokenCompiled = null;
        this.errorLine = null;
        this.errorMessage = null;
        if (this.compile0()) {
            return true;
        }
        int icharEnd = script.indexOf(13, this.ichCurrentCommand);
        if (icharEnd == -1 && (icharEnd = script.indexOf(10, this.ichCurrentCommand)) == -1) {
            icharEnd = script.length();
        }
        this.errorLine = script.substring(this.ichCurrentCommand, icharEnd);
        return false;
    }

    short[] getLineNumbers() {
        return this.lineNumbers;
    }

    short[] getLineIndices() {
        return this.lineIndices;
    }

    Token[][] getAatokenCompiled() {
        return this.aatokenCompiled;
    }

    String getErrorMessage() {
        String strError = this.errorMessage;
        strError = strError + " : " + this.errorLine + "\n";
        if (this.filename != null) {
            strError = strError + this.filename;
        }
        strError = strError + " line#" + this.lineCurrent;
        return strError;
    }

    /*
     * Unable to fully structure code
     */
    boolean compile0() {
        this.cchScript = this.script.length();
        this.ichToken = 0;
        this.lineCurrent = 1;
        lnLength = 8;
        this.lineNumbers = new short[lnLength];
        this.lineIndices = new short[lnLength];
        this.error = false;
        lltoken = new Vector<Token[]>();
        ltoken = new Vector<Token>();
        tokCommand = 0;
        while (true) {
            block29: {
                block30: {
                    if (this.lookingAtLeadingWhitespace() || this.lookingAtComment()) break block29;
                    endOfLine = this.lookingAtEndOfLine();
                    if (!endOfLine && !this.lookingAtEndOfStatement()) break block30;
                    if (tokCommand != 0) {
                        if (!this.compileCommand(ltoken)) {
                            return false;
                        }
                        lltoken.addElement(this.atokenCommand);
                        iCommand = lltoken.size();
                        if (iCommand == lnLength) {
                            lnT = new short[lnLength * 2];
                            System.arraycopy(this.lineNumbers, 0, lnT, 0, lnLength);
                            this.lineNumbers = lnT;
                            lnT = new short[lnLength * 2];
                            System.arraycopy(this.lineIndices, 0, lnT, 0, lnLength);
                            this.lineIndices = lnT;
                            lnLength *= 2;
                        }
                        this.lineNumbers[iCommand] = this.lineCurrent;
                        this.lineIndices[iCommand] = (short)this.ichCurrentCommand;
                        ltoken.setSize(0);
                        tokCommand = 0;
                    }
                    if (this.ichToken >= this.cchScript) break;
                    if (endOfLine) {
                        this.lineCurrent = (short)(this.lineCurrent + 1);
                    }
                    break block29;
                }
                if (tokCommand == 0) ** GOTO lbl-1000
                if (this.lookingAtString()) {
                    str = this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1);
                    ltoken.addElement(new Token(4, str));
                } else if (tokCommand == 262416 && this.lookingAtLoadFormat()) {
                    strFormat = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    strFormat = strFormat.toLowerCase();
                    ltoken.addElement(new Token(1, strFormat));
                } else if ((tokCommand & 262144) != 0 && this.lookingAtSpecialString()) {
                    str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    ltoken.addElement(new Token(4, str));
                } else if (this.lookingAtDecimal((tokCommand & 524288) != 0)) {
                    value = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
                    ltoken.addElement(new Token(3, new Float(value)));
                } else if (this.lookingAtSeqcode()) {
                    seqNum = Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                    insertionCode = this.script.charAt(this.ichToken + this.cchToken - 1);
                    seqcode = Group.getSeqcode(seqNum, insertionCode);
                    ltoken.addElement(new Token(5, seqcode, "seqcode"));
                } else if (this.lookingAtInteger((tokCommand & 524288) != 0)) {
                    intString = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    val = Integer.parseInt(intString);
                    ltoken.addElement(new Token(2, val, intString));
                } else if (this.lookingAtLookupToken()) {
                    ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    token = (Token)Token.map.get(ident = ident.toLowerCase());
                    if (token == null) {
                        token = new Token(1, ident);
                    }
                    tok = token.tok;
                    switch (tokCommand) {
                        case 0: {
                            this.ichCurrentCommand = this.ichToken;
                            tokCommand = tok;
                            if ((tokCommand & 256) != 0) break;
                            return this.commandExpected();
                        }
                        case 526623: {
                            if (ltoken.size() != 1) break;
                            if ((tok & 0x100000) != 0) {
                                tokCommand = tok;
                                ltoken.removeAllElements();
                                break;
                            }
                            if ((tok & 512) != 0 || tok == 1) break;
                            return this.cannotSet(ident);
                        }
                        case 288: {
                            if ((tok & 1024) != 0) break;
                            return this.cannotShow(ident);
                        }
                        case 8457: {
                            if (!(ltoken.size() == 1 ? tok != 1 && (tok & 65536) != 65536 : tok != 1 && tok != 526623 && (tok & 73728) == 0)) break;
                            return this.invalidExpressionToken(ident);
                        }
                        case 8473: 
                        case 8478: 
                        case 9476: {
                            if (tok == 1 || tok == 526623 || (tok & 73728) != 0) break;
                            return this.invalidExpressionToken(ident);
                        }
                    }
                    ltoken.addElement(token);
                } else {
                    if (ltoken.size() == 0) {
                        return this.commandExpected();
                    }
                    return this.unrecognizedToken();
                }
            }
            this.ichToken += this.cchToken;
        }
        this.aatokenCompiled = new Token[lltoken.size()][];
        lltoken.copyInto((Object[])this.aatokenCompiled);
        return true;
    }

    private static final boolean isSpaceOrTab(char ch) {
        return ch == ' ' || ch == '\t';
    }

    boolean lookingAtLeadingWhitespace() {
        int ichT;
        this.log("lookingAtLeadingWhitespace");
        for (ichT = this.ichToken; ichT < this.cchScript && Compiler.isSpaceOrTab(this.script.charAt(ichT)); ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        this.log("leadingWhitespace cchScript=" + this.cchScript + " cchToken=" + this.cchToken);
        return this.cchToken > 0;
    }

    boolean lookingAtComment() {
        char ch;
        int ichEnd;
        this.log("lookingAtComment ichToken=" + this.ichToken + " cchToken=" + this.cchToken);
        int ichFirstSharp = -1;
        for (ichEnd = this.ichToken; ichEnd < this.cchScript && (ch = this.script.charAt(ichEnd)) != ';' && ch != '\r' && ch != '\n'; ++ichEnd) {
            if (ch != '#' || ichFirstSharp != -1) continue;
            ichFirstSharp = ichEnd;
        }
        if (ichFirstSharp == -1) {
            return false;
        }
        if (this.cchScript - ichFirstSharp >= 3 && this.script.charAt(ichFirstSharp + 1) == 'j' && this.script.charAt(ichFirstSharp + 2) == 'c') {
            this.cchToken = ichEnd - this.ichToken;
            return true;
        }
        if (ichFirstSharp != this.ichToken) {
            return false;
        }
        if (this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && Compiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return true;
        }
        this.cchToken = ichEnd - this.ichToken;
        return true;
    }

    boolean lookingAtEndOfLine() {
        this.log("lookingAtEndOfLine");
        if (this.ichToken == this.cchScript) {
            return true;
        }
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT);
        if (ch == '\r') {
            if (++ichT < this.cchScript && this.script.charAt(ichT) == '\n') {
                ++ichT;
            }
        } else if (ch == '\n') {
            ++ichT;
        } else {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtEndOfStatement() {
        if (this.ichToken == this.cchScript || this.script.charAt(this.ichToken) != ';') {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    boolean lookingAtString() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        if (this.script.charAt(this.ichToken) != '\"') {
            return false;
        }
        int ichT = this.ichToken + 1;
        while (ichT < this.cchScript && this.script.charAt(ichT++) != '\"') {
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtLoadFormat() {
        int i = this.loadFormats.length;
        while (--i >= 0) {
            String strFormat = this.loadFormats[i];
            int cchFormat = strFormat.length();
            if (!this.script.regionMatches(true, this.ichToken, strFormat, 0, cchFormat)) continue;
            this.cchToken = cchFormat - 1;
            return true;
        }
        return false;
    }

    boolean lookingAtSpecialString() {
        char ch;
        int ichT;
        for (ichT = this.ichToken; ichT < this.cchScript && (ch = this.script.charAt(ichT)) != ';' && ch != '\r' && ch != '\n'; ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        this.log("lookingAtSpecialString cchToken=" + this.cchToken);
        return this.cchToken > 0;
    }

    boolean lookingAtDecimal(boolean allowNegative) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (this.script.charAt(ichT) == '-') {
            ++ichT;
        }
        boolean digitSeen = false;
        int ch = 88;
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Compiler.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT == this.cchScript || ch != 46) {
            return false;
        }
        if (ch == 46 && ichT + 1 < this.cchScript && Compiler.isAlphabetic(this.script.charAt(ichT + 1))) {
            return false;
        }
        ++ichT;
        while (ichT < this.cchScript && Compiler.isDigit(this.script.charAt(ichT))) {
            ++ichT;
            digitSeen = true;
        }
        this.cchToken = ichT - this.ichToken;
        return digitSeen;
    }

    static boolean isAlphabetic(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    boolean lookingAtSeqcode() {
        int ichT;
        char ch = ' ';
        for (ichT = this.ichToken; ichT < this.cchScript; ++ichT) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Compiler.isDigit(c)) break;
        }
        if (ichT == this.ichToken || ichT + 2 > this.cchScript || ch != '^') {
            return false;
        }
        if (!Compiler.isAlphabetic(ch = (char)this.script.charAt(++ichT))) {
            return false;
        }
        this.cchToken = ++ichT - this.ichToken;
        return true;
    }

    boolean lookingAtInteger(boolean allowNegative) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (allowNegative && this.script.charAt(this.ichToken) == '-') {
            ++ichT;
        }
        int ichBeginDigits = ichT;
        while (ichT < this.cchScript && Compiler.isDigit(this.script.charAt(ichT))) {
            ++ichT;
        }
        if (ichBeginDigits == ichT) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtLookupToken() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT++);
        switch (ch) {
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case '@': 
            case '[': 
            case ']': {
                break;
            }
            case '&': 
            case '|': {
                if (ichT >= this.cchScript || this.script.charAt(ichT) != ch) break;
                ++ichT;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (ichT >= this.cchScript || (ch = this.script.charAt(ichT)) != '<' && ch != '=' && ch != '>') break;
                ++ichT;
                break;
            }
            case '!': 
            case '/': {
                if (ichT >= this.cchScript || this.script.charAt(ichT) != '=') break;
                ++ichT;
                break;
            }
            default: {
                if ((ch < 'a' || ch > 'z') && ch < 'A' && ch > 'Z' && ch != '_') {
                    return false;
                }
            }
            case '?': {
                while (ichT < this.cchScript && (Compiler.isAlphabetic(ch = this.script.charAt(ichT)) || Compiler.isDigit(ch) || ch == '_' || ch == '?') || ch == '^' && ichT > this.ichToken && Compiler.isDigit(this.script.charAt(ichT - 1))) {
                    ++ichT;
                }
                break block0;
            }
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private boolean commandExpected() {
        return this.compileError("command expected");
    }

    private boolean cannotSet(String ident) {
        return this.compileError("cannot SET:" + ident);
    }

    private boolean cannotShow(String ident) {
        return this.compileError("cannot SHOW:" + ident);
    }

    private boolean invalidExpressionToken(String ident) {
        return this.compileError("invalid expression token:" + ident);
    }

    private boolean unrecognizedToken() {
        return this.compileError("unrecognized token");
    }

    private boolean badArgumentCount() {
        return this.compileError("bad argument count");
    }

    private boolean endOfExpressionExpected() {
        return this.compileError("end of expression expected");
    }

    private boolean leftParenthesisExpected() {
        return this.compileError("left parenthesis expected");
    }

    private boolean rightParenthesisExpected() {
        return this.compileError("right parenthesis expected");
    }

    private boolean commaExpected() {
        return this.compileError("comma expected");
    }

    private boolean unrecognizedExpressionToken() {
        return this.compileError("unrecognized expression token:" + this.valuePeek());
    }

    private boolean comparisonOperatorExpected() {
        return this.compileError("comparison operator expected");
    }

    private boolean integerExpected() {
        return this.compileError("integer expected");
    }

    private boolean numberOrKeywordExpected() {
        return this.compileError("number or keyword expected");
    }

    private boolean badRGBColor() {
        return this.compileError("bad [R,G,B] color");
    }

    private boolean identifierOrResidueSpecificationExpected() {
        return this.compileError("identifier or residue specification expected");
    }

    private boolean residueSpecificationExpected() {
        return this.compileError("3 letter residue specification expected");
    }

    private boolean invalidChainSpecification() {
        return this.compileError("invalid chain specification");
    }

    private boolean invalidModelSpecification() {
        return this.compileError("invalid model specification");
    }

    private boolean invalidAtomSpecification() {
        return this.compileError("invalid atom specification");
    }

    private boolean compileError(String errorMessage) {
        System.out.println("compileError(" + errorMessage + ")");
        this.error = true;
        this.errorMessage = errorMessage;
        return false;
    }

    private boolean compileCommand(Vector ltoken) {
        Token tokenCommand = (Token)ltoken.firstElement();
        int tokCommand = tokenCommand.tok;
        if ((tokenCommand.intValue & 0x800001) == 0x800001 && ltoken.size() == 1) {
            ltoken.addElement(Token.tokenOn);
        }
        if (tokCommand == 526623) {
            int size = ltoken.size();
            if (size < 2) {
                return this.badArgumentCount();
            }
            if (size == 2 && (((Token)ltoken.elementAt((int)1)).tok & 0x1000000) != 0) {
                ltoken.addElement(Token.tokenOn);
            }
        }
        this.atokenCommand = new Token[ltoken.size()];
        ltoken.copyInto(this.atokenCommand);
        if (tokCommand != 25861 && (tokCommand & 0x2000) != 0 && !this.compileExpression()) {
            return false;
        }
        if ((tokCommand & 0x20000) != 0 && !this.compileColorParam()) {
            return false;
        }
        if ((tokenCommand.intValue & 0x400000) == 0 && (tokenCommand.intValue & 7) + 1 != this.atokenCommand.length) {
            return this.badArgumentCount();
        }
        return true;
    }

    private boolean compileExpression() {
        int i = 1;
        if (this.atokenCommand[0].tok == 8457) {
            i = 2;
        }
        if (i >= this.atokenCommand.length) {
            return true;
        }
        return this.compileExpression(i);
    }

    boolean addTokenToPostfix(Token token) {
        this.ltokenPostfix.addElement(token);
        return true;
    }

    boolean compileExpression(int itoken) {
        this.ltokenPostfix = new Vector();
        for (int i = 0; i < itoken; ++i) {
            this.addTokenToPostfix(this.atokenCommand[i]);
        }
        this.atokenInfix = this.atokenCommand;
        this.itokenInfix = itoken;
        if (!this.clauseOr()) {
            return false;
        }
        if (this.itokenInfix != this.atokenInfix.length) {
            return this.endOfExpressionExpected();
        }
        this.atokenCommand = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenCommand);
        return true;
    }

    Token tokenNext() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix++];
    }

    Object valuePeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix].value;
    }

    int tokPeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return 0;
        }
        return this.atokenInfix[this.itokenInfix].tok;
    }

    boolean clauseOr() {
        if (!this.clauseAnd()) {
            return false;
        }
        while (this.tokPeek() == 8196) {
            Token tokenOr = this.tokenNext();
            if (!this.clauseAnd()) {
                return false;
            }
            this.addTokenToPostfix(tokenOr);
        }
        return true;
    }

    boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        while (this.tokPeek() == 8195) {
            Token tokenAnd = this.tokenNext();
            if (!this.clauseNot()) {
                return false;
            }
            this.addTokenToPostfix(tokenAnd);
        }
        return true;
    }

    boolean clauseNot() {
        if (this.tokPeek() == 8197) {
            Token tokenNot = this.tokenNext();
            if (!this.clauseNot()) {
                return false;
            }
            return this.addTokenToPostfix(tokenNot);
        }
        return this.clausePrimitive();
    }

    boolean clausePrimitive() {
        int tok = this.tokPeek();
        switch (tok) {
            case 8198: {
                return this.clauseWithin();
            }
            case 1: 
            case 2: 
            case 5: 
            case 8194: 
            case 8201: 
            case 8204: 
            case 8206: 
            case 12290: 
            case 12292: 
            case 77827: {
                return this.clauseResidueSpec();
            }
            default: {
                if ((tok & 0x6000) == 24576) {
                    return this.clauseComparator();
                }
                if ((tok & 0x10000) != 65536) break;
            }
            case 9227: 
            case 12293: {
                return this.addTokenToPostfix(this.tokenNext());
            }
            case 8192: {
                this.tokenNext();
                if (!this.clauseOr()) {
                    return false;
                }
                if (this.tokenNext().tok != 8193) {
                    return this.rightParenthesisExpected();
                }
                return true;
            }
        }
        return this.unrecognizedExpressionToken();
    }

    boolean clauseComparator() {
        Token tokenAtomProperty = this.tokenNext();
        Token tokenComparator = this.tokenNext();
        if ((tokenComparator.tok & 0xA000) == 0) {
            return this.comparisonOperatorExpected();
        }
        Token tokenValue = this.tokenNext();
        if (tokenValue.tok != 2) {
            return this.integerExpected();
        }
        int val = tokenValue.intValue;
        return this.addTokenToPostfix(new Token(tokenComparator.tok, tokenAtomProperty.tok, new Integer(val)));
    }

    boolean clauseWithin() {
        Object distance;
        this.tokenNext();
        if (this.tokenNext().tok != 8192) {
            return this.leftParenthesisExpected();
        }
        Token tokenDistance = this.tokenNext();
        switch (tokenDistance.tok) {
            case 2: {
                distance = new Float((float)(tokenDistance.intValue * 4) / 1000.0f);
                break;
            }
            case 3: 
            case 9220: 
            case 9221: 
            case 25861: {
                distance = tokenDistance.value;
                break;
            }
            default: {
                return this.numberOrKeywordExpected();
            }
        }
        if (this.tokenNext().tok != 8196) {
            return this.commaExpected();
        }
        if (!this.clauseOr()) {
            return false;
        }
        if (this.tokenNext().tok != 8193) {
            return this.rightParenthesisExpected();
        }
        return this.addTokenToPostfix(new Token(8198, distance));
    }

    boolean generateResidueSpecCode(Token token) {
        this.addTokenToPostfix(token);
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.residueSpecCodeGenerated = true;
        return true;
    }

    boolean clauseResidueSpec() {
        boolean specSeen = false;
        this.residueSpecCodeGenerated = false;
        int tok = this.tokPeek();
        if (tok == 8201 || tok == 8204 || tok == 1 || tok == 526623 || tok == 12290 || tok == 77827 || tok == 12292) {
            this.log("I see a residue name");
            if (!this.clauseResNameSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 8201 || tok == 8194 || tok == 2 || tok == 5) {
            this.log("I see a residue number");
            if (!this.clauseResNumSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 8206 || tok == 8201 || tok == 1 || tok == 12290 || tok == 77827 || tok == 12292 || tok == 2) {
            if (!this.clauseChainSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 8203) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 8206 || tok == 8207) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (!specSeen) {
            return this.residueSpecificationExpected();
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    boolean clauseResNameSpec() {
        int tokPeek = this.tokPeek();
        if (tokPeek == 8201) {
            this.tokenNext();
            return true;
        }
        Token tokenT = this.tokenNext();
        if (tokenT.tok == 8204) {
            int tok;
            this.log("I see a left square bracket");
            tokenT = this.tokenNext();
            if (tokenT == null) {
                return false;
            }
            String strSpec = "";
            if (tokenT.tok == 8199) {
                strSpec = "+";
                tokenT = this.tokenNext();
            }
            if ((tok = tokenT.tok) == 2) {
                strSpec = strSpec + tokenT.value;
                tokenT = this.tokenNext();
                if (tokenT == null) {
                    return false;
                }
                tok = tokenT.tok;
            }
            if (tok == 1 || tok == 526623 || tok == 12290 || tok == 77827 || tok == 12292) {
                strSpec = strSpec + tokenT.value;
                tokenT = this.tokenNext();
                if (tokenT == null) {
                    return false;
                }
                tok = tokenT.tok;
            }
            if (strSpec == "") {
                return this.residueSpecificationExpected();
            }
            short groupID = Group.lookupGroupID(strSpec = strSpec.toUpperCase());
            if (groupID != -1) {
                this.generateResidueSpecCode(new Token(4117, groupID, strSpec));
            } else {
                this.generateResidueSpecCode(new Token(4118, strSpec));
            }
            return tok == 8205;
        }
        return this.processIdentifier(tokenT);
    }

    boolean processIdentifier(Token tokenIdent) {
        String strUpper3;
        if (tokenIdent.tok != 1) {
            return this.identifierOrResidueSpecificationExpected();
        }
        String strToken = (String)tokenIdent.value;
        this.log("processing identifier:" + strToken);
        int cchToken = strToken.length();
        if (cchToken < 3) {
            return this.generateResidueSpecCode(tokenIdent);
        }
        for (int i = 3; i < cchToken - 1; ++i) {
            if (Character.isDigit(strToken.charAt(i))) continue;
            return this.generateResidueSpecCode(tokenIdent);
        }
        this.log("still here looking at:" + strToken);
        int seqcode = -1;
        char chain = '?';
        if (cchToken > 3) {
            String strResno;
            char chLast = strToken.charAt(cchToken - 1);
            this.log("the last character is:" + chLast);
            if (Character.isDigit(chLast)) {
                strResno = strToken.substring(3);
                this.log("strResNo=" + strResno);
            } else {
                chain = chLast;
                strResno = strToken.substring(3, cchToken - 1);
            }
            try {
                int sequenceNum = Integer.parseInt(strResno);
                this.log("I parsed sequenceNum=" + sequenceNum);
                seqcode = Group.getSeqcode(sequenceNum, ' ');
            }
            catch (NumberFormatException e) {
                return this.generateResidueSpecCode(tokenIdent);
            }
        }
        if ((strUpper3 = strToken.substring(0, 3).toUpperCase()).charAt(0) == '?' || strUpper3.charAt(1) == '?' || strUpper3.charAt(2) == '?') {
            this.generateResidueSpecCode(new Token(4118, strUpper3));
        } else {
            short groupID = Group.lookupGroupID(strUpper3);
            if (groupID != -1) {
                this.generateResidueSpecCode(new Token(4117, groupID, strUpper3));
            } else {
                return this.generateResidueSpecCode(tokenIdent);
            }
        }
        this.log(" I see a residue name:" + strUpper3 + " seqcode=" + seqcode + " chain=" + chain);
        if (seqcode != -1) {
            this.generateResidueSpecCode(new Token(4119, seqcode, "spec_seqcode"));
        }
        if (chain != '?') {
            this.generateResidueSpecCode(new Token(4121, chain, "spec_chain"));
        }
        return true;
    }

    boolean clauseResNumSpec() {
        this.log("clauseResNumSpec()");
        if (this.tokPeek() == 8201) {
            this.tokenNext();
            return true;
        }
        return this.clauseSequenceRange();
    }

    boolean clauseSequenceRange() {
        if (!this.clauseSequenceCode()) {
            return false;
        }
        if (this.tokPeek() == 8194) {
            this.tokenNext();
            int seqcodeMin = this.seqcode;
            if (!this.clauseSequenceCode()) {
                return false;
            }
            return this.generateResidueSpecCode(new Token(4120, seqcodeMin, new Integer(this.seqcode)));
        }
        return this.generateResidueSpecCode(new Token(4119, this.seqcode, "seqcode"));
    }

    boolean clauseSequenceCode() {
        boolean negative = false;
        int tokPeek = this.tokPeek();
        if (tokPeek == 8194) {
            this.tokenNext();
            negative = true;
            tokPeek = this.tokPeek();
        }
        if (tokPeek == 5) {
            this.seqcode = this.tokenNext().intValue;
        } else if (tokPeek == 2) {
            this.seqcode = Group.getSeqcode(this.tokenNext().intValue, ' ');
        } else {
            return false;
        }
        if (negative) {
            this.seqcode = -this.seqcode;
        }
        return true;
    }

    boolean clauseChainSpec() {
        int chain;
        if (this.tokPeek() == 8206) {
            this.tokenNext();
        }
        if (this.tokPeek() == 8201) {
            this.tokenNext();
            return true;
        }
        if (this.tokPeek() == 8206) {
            return true;
        }
        switch (this.tokPeek()) {
            case 0: 
            case 8203: 
            case 8206: {
                chain = 0;
                break;
            }
            case 2: {
                Token tokenChain = this.tokenNext();
                if (tokenChain.intValue < 0 || tokenChain.intValue > 9) {
                    return this.invalidChainSpecification();
                }
                chain = (char)(48 + tokenChain.intValue);
                break;
            }
            case 1: 
            case 12290: 
            case 12292: 
            case 77827: {
                Token tokenChain = this.tokenNext();
                String strChain = (String)tokenChain.value;
                if (strChain.length() != 1) {
                    return this.invalidChainSpecification();
                }
                chain = strChain.charAt(0);
                if (chain != 63) break;
                return true;
            }
            default: {
                return this.invalidChainSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(4121, chain, "spec_chain"));
    }

    boolean clauseModelSpec() {
        int tok = this.tokPeek();
        if (tok == 8206 || tok == 8207) {
            this.tokenNext();
        }
        if (this.tokPeek() == 8201) {
            this.tokenNext();
            return true;
        }
        Token tokenModel = this.tokenNext();
        switch (tokenModel.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 12290: 
            case 12292: 
            case 77827: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(4122, (String)tokenModel.value));
    }

    boolean clauseAtomSpec() {
        if (this.tokenNext().tok != 8203) {
            return this.invalidAtomSpecification();
        }
        Token tokenAtomSpec = this.tokenNext();
        if (tokenAtomSpec == null || tokenAtomSpec.tok == 8201) {
            return true;
        }
        if (tokenAtomSpec.tok != 1) {
            return this.invalidAtomSpecification();
        }
        String atomSpec = (String)tokenAtomSpec.value;
        if (this.tokPeek() == 8201) {
            this.tokenNext();
            atomSpec = atomSpec + "*";
        }
        return this.generateResidueSpecCode(new Token(4123, atomSpec));
    }

    boolean compileColorParam() {
        for (int i = 1; i < this.atokenCommand.length; ++i) {
            String id;
            int argb;
            Token token = this.atokenCommand[i];
            if (token.tok == 8204) {
                Token[] atokenNew = new Token[i + 1];
                System.arraycopy(this.atokenCommand, 0, atokenNew, 0, i);
                if (!this.compileRGB(this.atokenCommand, i, atokenNew)) {
                    return false;
                }
                this.atokenCommand = atokenNew;
                break;
            }
            if (token.tok != 1 || (argb = Graphics3D.getArgbFromString(id = (String)token.value)) == 0) continue;
            token.tok = 135188;
            token.intValue = argb;
        }
        return true;
    }

    boolean compileRGB(Token[] atoken, int i, Token[] atokenNew) {
        String hex;
        if (atoken.length == i + 7 && atoken[i].tok == 8204 && atoken[i + 1].tok == 2 && atoken[i + 2].tok == 8196 && atoken[i + 3].tok == 2 && atoken[i + 4].tok == 8196 && atoken[i + 5].tok == 2 && atoken[i + 6].tok == 8205) {
            int rgb = atoken[i + 1].intValue << 16 | atoken[i + 3].intValue << 8 | atoken[i + 5].intValue;
            atokenNew[i] = new Token(135188, rgb, "[R,G,B]");
            return true;
        }
        if (atoken.length == i + 3 && atoken[i].tok == 8204 && atoken[i + 1].tok == 1 && atoken[i + 2].tok == 8205 && (hex = (String)atoken[i + 1].value).length() == 7 && hex.charAt(0) == 'x') {
            try {
                int rgb = Integer.parseInt(hex.substring(1), 16);
                atokenNew[i] = new Token(135188, rgb, "[xRRGGBB]");
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return this.badRGBColor();
    }
}

