# The LearningOnline Network
# Switch Servers Handler
#
# $Id: switchserver.pm,v 1.11 2007/01/12 15:44:27 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::switchserver;

use strict;
use Apache::Constants qw(:common);
use Apache::lonnet;
use Apache::lonmenu;
use CGI::Cookie();
use Apache::lonlocal;

sub init_env {
    my ($r) = @_;
    
    if (-e $env{'user.environment'}) {
	return  $env{'user.environment'};
    }
    my $requrl=$r->uri;
    my %cookies=CGI::Cookie->parse($r->header_in('Cookie'));
    my $lonid=$cookies{'lonID'};
    my $cookie;
    if (!$lonid) { return undef; }

    my $handle=&LONCAPA::clean_handle($lonid->value);
    my $lonidsdir=$r->dir_config('lonIDsDir');
    if ((!-e "$lonidsdir/$handle.id") || ($handle eq '')) {
	$r->log_reason("Cookie $handle not valid", $r->filename); 
	return undef;
    }

    &Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);
    
    return $r->dir_config('lonIDsDir')."/$handle.id";
}

sub handler {
    my ($r) = @_;
    
    my $handle=&init_env($r);
    if (!defined($handle)) { return FORBIDDEN; }

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
					    ['otherserver','role']);

    my $switch_to=$Apache::lonnet::hostname{$env{'form.otherserver'}};
    if (!$env{'form.otherserver'}) {
	$env{'form.otherserver'}=&Apache::lonnet::spareserver(30000,undef,1);
	$switch_to=$Apache::lonnet::hostname{$env{'form.otherserver'}};
    }

    if (!defined($switch_to)) { return FORBIDDEN; }

    if ($env{'form.role'} && 
	!exists($env{'user.role.'.$env{'form.role'}})) { return FORBIDDEN; }

    #remove session env, and log event
    unlink($handle);
    my %temp=('switchserver' => time.':'.$env{'form.otherserver'},
	      $env{'form.role'});
    &Apache::lonnet::put('email_status',\%temp);
    &Apache::lonnet::log($env{'user.domain'},$env{'user.name'},
			 $env{'user.home'},
			 "Switch Server to $env{'form.otherserver'} with role $env{'form.role'} $ENV{'REMOTE_ADDR'}");

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
# -------------------------------------------------------- Menu script and info
	   
    my $windowinfo=&Apache::lonmenu::close();
    $windowinfo.=&Apache::lonnavmaps::close();
# ---------------------------------------------------------------- Get handover

    my %info=('ip'       => $ENV{'REMOTE_ADDR'},
	      'domain'   => $env{'user.domain'},
	      'username' => $env{'user.name'},
	      'role'     => $env{'form.role'},
	      'server'   => $r->dir_config('lonHostID'));
    if ($env{'request.sso.login'}) {
	$info{'sso.login'} = $env{'request.sso.login'};
    }
    if ($env{'request.sso.reloginserver'}) {
        $info{'sso.reloginserver'} = $env{'request.sso.reloginserver'};
    }
    my $token = &Apache::lonnet::tmpput(\%info,$env{'form.otherserver'});
    my $switch='<meta HTTP-EQUIV="Refresh" CONTENT="0.5; url=http://'.$switch_to.'/adm/login?domain='.$env{'user.domain'}.'&username='.$env{'user.name'}.'&token='.$token.'">';
    my $start_page = &Apache::loncommon::start_page('Switching Server ...',
						    $switch,
						    {'no_inline_link' => 1,});
    my $end_page   = &Apache::loncommon::end_page();
# --------------------------------------------------------------- Screen Output
    $r->print($start_page.$windowinfo.$end_page);

    &Apache::lonnet::flushcourselogs();
    return OK;
}

1;
__END__








