#!/usr/bin/perl
# Gets keywords from metadata database.
# $Id: metadata_keywords.pl,v 1.6 2003/09/01 03:37:27 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#


###############################################################################
##                                                                           ##
## ORGANIZATION OF THIS PERL CGI SCRIPT                                      ##
##                                                                           ##
## 1. Status of this code                                                    ##
## 2. Purpose and description of program                                     ##
## 3. Modules used by this script                                            ##
## 4. Print MIME Content-type and other initialization                       ##
## 5. Make sure database can be accessed and that this is a library server   ##
## 6. Loop through database records and print out keywords                   ##
##                                                                           ##
###############################################################################

# --------------------------------------------------------- Status of this code
#
# 1=horrible 2=poor 3=fair 4=good 5=excellent
# Organization 5
# Functionality 4
# Has it been tested? 4
#

# ------------------------------------------ Purpose and description of program
#
# This program outputs one line per database entry.
# The line is to be a list of keywords separated by commas.
# The file is to be output as a text file on a browser (text/plain).
# This provides initial data by which to study common and uncommon
# keywords being used.
# Note that the authoritative copy of metadata "keywords" is in the
# .meta files that are native to the library server.  We rely
# on the assumption that it is okay to use the MySQL server (which
# should reflect this information) instead.  This is a speedier approach.

# ------------------------------------------------- Modules used by this script

use lib '/home/httpd/lib/perl/';
use LONCAPA::Configuration;

use strict;
use DBI;

# ---------------------------- Print MIME Content-type and other initialization
$|=1;
print 'Content-type: text/plain'."\n\n";

# --- Make sure that database can be accessed and that this is a library server
# library server test

# By default, loncapa_apache.conf is also read by the read_conf subroutine.
my $perlvarref=LONCAPA::Configuration::read_conf('loncapa.conf');
my %perlvar=%{$perlvarref};
undef($perlvarref);

unless ($perlvar{'lonRole'} eq 'library') {
    print "This can only be run on a library server!\n";
    exit;
}
# database test
my $dbh;
{
    unless (
	    $dbh = DBI->connect("DBI:mysql:loncapa","www",
				$perlvar{'lonSqlAccess'},
				{ RaiseError =>0,PrintError=>0})
	    ) { 
	print "Cannot connect to database!\n";
	exit;
    }
}
%perlvar=(); # undefine it

# ------------------------ Loop through database records and print out keywords
my $sth=$dbh->prepare("select * from metadata");
$sth->execute();
my @row;
while (@row=$sth->fetchrow_array) {
    print $row[4]."\n";
}

# --------------------------------------------------- Close database connection
$dbh->disconnect();
