#!/usr/bin/perl -w
#
# The LearningOnline Network
#
# $Id: seed_accesscount.pl,v 1.5 2006/06/27 15:21:46 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#################################################
use strict;
use Getopt::Long;
use GDBM_File;
use lib '/home/httpd/lib/perl/';
use LONCAPA;

#
# Options
my ($verbose,$help) = (0);
GetOptions("v"    => \$verbose,
           "help" => \$help);

#
# Help them out if they ask for it
if ($help) {
    print <<END;
seed_accesscount.pl 
END
    exit;
}

#
# Loop through ARGV getting files.
$|=1;
while (my $resDBname = shift()) {
    my ($path) = ($resDBname =~ /^(.*)nohist_resevaldata.db$/);
    print STDERR $path.$/;
    my $resevalDB = &LONCAPA::locking_hash_tie($resDBname,&GDBM_READER());
    if (! $resevalDB) {
        warn "Unable to tie to $resDBname";
        next;
    }
    &LONCAPA::push_locking_hash_tie();
    #
    my $accessDBname = $path.'nohist_accesscount.db';
    my $accessDB = &LONCAPA::locking_hash_tie($accessDBname,&GDBM_WRCREAT());
    if (! $accessDB) {
        warn "Unable to tie to $accessDBname";
        next;
    }
    #
    my @Keys;
    my ($basekey,$value);
    #
    $! = 0;
    while (eval('($basekey,$value) = each(%{$resevalDB});')) {
        if ($!) {
            print STDERR $1.$/;
            $!=0;
        }
        my $key = &unescape($basekey);
        my $src;
        next if (! ((undef,$src) = ($key =~ /^(.*)___(.*)___count/)));
        my $value = &unescape($value);
        $src = &escape($src);
        if (exists($accessDB->{$src})) {
            $accessDB->{$src}+=$value;
        } else {
            $accessDB->{$src}=$value;
        }
        push (@Keys,$basekey);
    }
    #
    &LONCAPA::locking_hash_untie($accessDB);
    &LONCAPA::pop_locking_hash_tie();
    &LONCAPA::locking_hash_untie($resevalDB);
    system("chown www:www $accessDBname");
    # remove the keys we saved.
    next if (! scalar(@Keys)); # skip it if we did not get anything...
    my $dbptr = &LONCAPA::locking_hash_tie($resDBname,&GDBM_READER());
    if (! $dbptr ) {
        die "Unable to re-tie to $resDBname.  No deletes occured.";
    }
    foreach my $basekey (@Keys) {
        delete($resevalDB->{$basekey});
    }
    # Squish the file down
    &LONCAPA::locking_hash_untie($resevalDB);
    system("chown www:www $resDBname");
}
exit;

######################################

