#
# $Id: lonsupportreq.pm,v 1.42 2006/12/22 20:51:27 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonsupportreq;

use strict;
use MIME::Types;
use MIME::Lite;
use CGI::Cookie();
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonlocal;
use Apache::lonacc();
use Apache::courseclassifier;
use LONCAPA;
 

sub handler {
    my ($r) = @_;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

    if ($r->header_only) {
        return OK;
    }
    if ($r->uri eq '/adm/helpdesk') {
	&Apache::lonlocal::get_language_handle($r);
    }

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['origurl','function']);
    if ($r->uri eq '/adm/helpdesk') {
        &Apache::lonacc::get_posted_cgi($r);
    }
    my $function = $env{'form.function'};
    my $origurl = &unescape($env{'form.origurl'});
    my $action = $env{'form.action'};

    if ($action eq 'process') {
        &print_request_receipt($r,$origurl,$function);
    } else {
        &print_request_form($r,$origurl,$function);
    }
    return OK;
}
    
sub print_request_form {
    my ($r,$origurl,$function) = @_;
    my ($os,$browser,$bversion,$uhost,$uname,$udom,$uhome,$urole,$usec,$email,$cid,$cdom,$cnum,$ctitle,$ccode,$sectionlist,$lastname,$firstname,$server,$formname);
    my $tablecolor = &Apache::loncommon::designparm($function.'.tabbg');
    if (($tablecolor eq '') || ($tablecolor eq '#FFFFFF')) {
        $tablecolor = '#EEEE99';
    }
    $ccode = '';
    $os = $env{'browser.os'};
    $browser = $env{'browser.type'};
    $bversion = $env{'browser.version'};
    $uhost = $env{'request.host'};
    $uname = $env{'user.name'};
    $udom = $env{'user.domain'};
    $uhome = $env{'user.home'};
    $urole = $env{'request.role'};
    $usec = $env{'request.course.sec'};
    $cid = $env{'request.course.id'};
    $formname = 'logproblem';
    my $machine = &Apache::lonnet::absolute_url();
    if ($origurl =~ m-^https?://-) {
        $server = $origurl;
    } else {
        $server = $machine.$origurl;
    }
    my %lt = &Apache::lonlocal::texthash (
                  email => 'The e-mail address you entered',
                  notv => 'is not a valid e-mail address',
                  rsub => 'You must include a subject',
                  rdes => 'You must include a description',
                  name => 'Name',
                  subm => 'Submit Request',
                  emad => 'E-mail address',
                  unme => 'username',
                  doma => 'domain',
                  entr => 'Enter the username you use to log-in to your LON-CAPA system, and choose your domain.',
                  urlp => 'URL of page',
                  phon => 'Phone',
                  crsd => 'Course Details',
                  enin => 'Enter institutional course code',
                  pick => 'Pick',
                  enct => 'Enter course title',
                  secn => 'Section Number',
                  sele => 'Select',
                  titl => 'Title',
                  lsec => 'LON-CAPA sec',
                  subj => 'Subject',
                  detd => 'Detailed Description',
                  opfi => 'Optional file upload',
                  uplf => 'Upload a file (e.g., a screenshot) relevant to your support request (128 KB max. size)',
                  fini => 'Finish',
                  clfm => 'Clear Form',
    );
    my $scripttag = (<<"END");
function validate() {
    if (validmail(document.logproblem.email) == false) {
        alert("$lt{'email'}: "+document.logproblem.email.value+" $lt{'notv'}.");
        return;
    }
    if (document.logproblem.subject.value == '') {
        alert("$lt{'rsub'}.");
        return;
    }
    if (document.logproblem.description.value == '') {
        alert("$lt{'rdes'}.");
        return;
    }
    document.logproblem.submit();
}

END
    $scripttag .= <<'END';
function validmail(field) {
    var str = field.value;
    if (window.RegExp) {
        var reg1str = "(@.*@)|(\\.\\.)|(@\\.)|(\\.@)|(^\\.)";
        var reg2str = "^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$"; //"
        var reg1 = new RegExp(reg1str);
        var reg2 = new RegExp(reg2str);
        if (!reg1.test(str) && reg2.test(str)) {
            return true;
        }
        return false;
    }
    else
    {
        if(str.indexOf("@") >= 0) {
            return true;
        }
        return false;
    }
}
END

    if ($cid =~ m/_/) {
        ($cdom,$cnum) = split(/_/,$cid);
    }
    if ($cdom && $cnum) {
        my %csettings = &Apache::lonnet::get('environment',['description','internal.coursecode','internal.sectionnums'],$cdom,$cnum);
        $ctitle = $csettings{'description'};
        $ccode = $csettings{'internal.coursecode'};
        $sectionlist = $csettings{'internal.sectionnums'};
    }
    if ($env{'environment.critnotification'}) {
        $email = $env{'environment.critnotification'};
    }
    if (!$email && $env{'environment.notification'}) {
        $email = $env{'environment.notification'};
    }
    if ($env{'environment.lastname'}) {
        $lastname = $env{'environment.lastname'};
    }
    if ($env{'environment.firstname'}) {
        $firstname = $env{'environment.firstname'};
    }
    my @sections = split(/,/,$sectionlist);
    my %groupid;
    foreach my $section (@sections) {
        my ($sec,$grp) = split(/:/,$section);
        $groupid{$sec} = $grp;
    }
    my $codedom = $Apache::lonnet::perlvar{'lonDefDomain'};
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['codedom']);
    if (exists($env{'form.codedom'})) {
        $codedom = $env{'form.codedom'};
    }
    my $details_title;
    if ($codedom) {
        $details_title = '<br />('.$codedom.')';
    }
    my %coursecodes;
    my %codes;
    my @codetitles;
    my %cat_titles;
    my %cat_order;
    my %idlist;
    my %idnums;
    my %idlist_titles;
    my $caller = 'global';
    my $totcodes = 0;
    my $format_reply;
    my $jscript = '';
    my $loaditems = qq|
function initialize_codes() {
    return;
}
    |;
    if ($cdom) {
        $codedom = $cdom;
    }
    if ($cnum) {
        $coursecodes{$cnum} = $ccode;
        if ($ccode eq '') {
            $totcodes = &Apache::courseclassifier::retrieve_instcodes(\%coursecodes,$codedom,$totcodes);
        } else {
            $coursecodes{$cnum} = $ccode;
            $caller = $cnum;
            $totcodes ++;
        }
    } else { 
        $totcodes = &Apache::courseclassifier::retrieve_instcodes(\%coursecodes,$codedom,$totcodes);
    }
    if ($totcodes > 0) {
        if ($ccode eq '') {
            $format_reply = &Apache::lonnet::auto_instcode_format($caller,$codedom,\%coursecodes,\%codes,\@codetitles,\%cat_titles,\%cat_order);
            if ($format_reply eq 'ok') {
                my $numtypes = @codetitles;
                &Apache::courseclassifier::build_code_selections(\%codes,\@codetitles,\%cat_titles,\%cat_order,\%idlist,\%idnums,\%idlist_titles);
                my ($scripttext,$longtitles) = &Apache::courseclassifier::javascript_definitions(\@codetitles,\%idlist,\%idlist_titles,\%idnums,\%cat_titles);
                my $longtitles_str = join('","',@{$longtitles});
                my $allidlist = $idlist{$codetitles[0]};
                $jscript .= &Apache::courseclassifier::courseset_js_start($formname,$longtitles_str,$allidlist);
                $jscript .= $scripttext;
                $jscript .= &Apache::courseclassifier::javascript_code_selections($formname,@codetitles);
                $loaditems = '';
            }
        }
    }
	
    my $js = '<script type"text/javascript">'."\n$scripttag\n$jscript\n".
	'</script>';
    my %add_entries = (topmargin    => "0",
		       marginheight => "0",
		       onLoad       =>"initialize_codes()",);

    my $start_page =
	&Apache::loncommon::start_page('Support Request',$js,
				       { 'function'    => $function,
					 'add_entries' => \%add_entries,
					 'only_body'   => 1,});
    $r->print($start_page);

    if ($r->uri eq '/adm/helpdesk') {
        &print_header($r,$origurl);
    }
    $r->print(<<"END");
<form method="post" name="logproblem" enctype="multipart/form-data">
 <table width="580" border="0" cellpadding="0" cellspacing="0" bgcolor="#000000">
  <tr>
   <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="#000000">
     <tr>
      <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
        <tr>
         <td>
	  <table width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="#ffffff">
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'name'}:</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
END
    my $fullname = '';
    if ((defined($lastname) && $lastname ne '') && (defined($firstname) && $firstname ne '')) {
        $fullname = "$firstname $lastname"; 
        $r->print("$fullname<input type=\"hidden\" name=\"username\" value=\"$fullname\" />");
    } else {
        if (defined($firstname) && $firstname ne '') {
            $fullname = $firstname;
        } elsif (defined($lastname) && $lastname ne '') {
            $fullname= " $lastname";
        }
        $r->print('<input type="text" size="20" name="username" value="'.$fullname.'" />');
    }
    $r->print(<<END);
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="button" value="$lt{'subm'}" onClick="validate()" />&nbsp;
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'emad'}:</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
                <input type="text" size="20" name="email" value="$email" /><br />
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'unme'}/$lt{'doma'}:</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
END
    my $udom_input = '<input type="hidden" name="udom" value="'.$udom.'" />';
    my $uname_input = '<input type="hidden" name="uname" value="'.$uname.'" />'; 
    if (defined($uname) && defined($udom)) {
        $r->print('<i>'.$lt{'unme'}.'</i>:&nbsp;'.$uname.'&nbsp;&nbsp;<i>'.$lt{'doma'}.'</i>:&nbsp;'.$udom.$udom_input.$uname_input);
    } else {
        my $udomform = '';
        my $unameform = '';
        if (defined($udom)) {
            $udomform = '<i>'.$lt{'doma'}.'</i>:&nbsp;'.$udom.$udom_input;
        } elsif (defined($uname)) {
            $unameform = '<i>'.$lt{'unme'}.'</i>:&nbsp;'.$uname.'&nbsp;&nbsp;'.$uname_input;
        }
        if ($udomform eq '') {
            $udomform = '<i>'.$lt{'doma'}.'</i>:&nbsp;';
            $udomform .= &Apache::loncommon::select_dom_form($codedom,'udom');
        }
        if ($unameform eq '') {
            $unameform= '<i>'.$lt{'unme'}.'</i>:&nbsp;<input type="text" size="12" name="uname" value="'.$uname.'" />&nbsp;&nbsp;';
        }
        $r->print($unameform.$udomform.'<br />'.$lt{'entr'});
    }
    $r->print(<<END);
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'urlp'}:</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
                $server<input type="hidden" name="sourceurl" value="$server" />
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'phon'} #:</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
                <input type="text" size="15" name="phone"><br>
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'crsd'}:</b>$details_title
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table border="0" cellpadding="3" cellspacing="3">
              <tr>
               <td>
END
    if ($cnum) { 
        if ($coursecodes{$cnum}) {
            foreach my $item (@codetitles) {
                $r->print('<i>'.$item.'</i>:&nbsp;'.$codes{$cnum}{$item}.';&nbsp;');
            }
            $r->print('&nbsp;<input type="hidden" name="coursecode" value="'.$coursecodes{$cnum}.'" />');
        } else {
            $r->print($lt{'enin'}.':&nbsp;
                  <input type="text" name="coursecode" size="15" value="" />');
        }
    } else {
        if ($totcodes > 0) {
            my $numtitles = @codetitles;
            if ($numtitles == 0) {
                $r->print($lt{'enin'}.':&nbsp;
                  <input type="text" name="coursecode" size="15" value="" />');
            } else {
                my $lasttitle = $numtitles;
                if ($numtitles > 4) {
                    $lasttitle = 4;
                } 
                $r->print('<table><tr><td>'.$codetitles[0].'<br />'."\n".
                      '<select name="'.$codetitles[0].'" onChange="courseSet('."'$codetitles[0]'".')">'."\n".
                      ' <option value="-1" />'.$lt{'sele'}."\n");
                my @items = ();
                my @longitems = ();
                if ($idlist{$codetitles[0]} =~ /","/) {
                    @items = split(/","/,$idlist{$codetitles[0]});
                } else {
                    $items[0] = $idlist{$codetitles[0]};
                }
                if (defined($idlist_titles{$codetitles[0]})) {
                    if ($idlist_titles{$codetitles[0]} =~ /","/) {
                        @longitems = split(/","/,$idlist_titles{$codetitles[0]});
                    } else {
                        $longitems[0] = $idlist_titles{$codetitles[0]};
                    }
                    for (my $i=0; $i<@longitems; $i++) {
                        if ($longitems[$i] eq '') {
                            $longitems[$i] = $items[$i];
                        }
                    }
                } else {
                    @longitems = @items;
                }
                for (my $i=0; $i<@items; $i++) {
                    $r->print(' <option value="'.$items[$i].'">'.$longitems[$i].'</option>');
                }
                $r->print('</select></td>');
                for (my $i=1; $i<$numtitles; $i++) {
                    $r->print('<td>'.$codetitles[$i].'<br />'."\n".
                     '<select name="'.$codetitles[$i].'" onChange="courseSet('."'$codetitles[$i]'".')">'."\n".
                     '<option value="-1">&lt;-'.$lt{'pick'}.' '.$codetitles[$i-1].'</option>'."\n".
                     '</select>'."\n".
                     '</td>'
                    );
                }
                $r->print('</tr></table>');
                if ($numtitles > 4) {
                    $r->print('<br /><br />'.$codetitles[$numtitles].'<br />'."\n".
                          '<select name="'.$codetitles[$numtitles].'" onChange="courseSet('."'$codetitles[$numtitles]'".')">'."\n".
                          '<option value="-1">&lt;-'.$lt{'pick'}.' '.$codetitles[$numtitles-1].'</option>'."\n".
                          '</select>'."\n");
                }
            }
        } else {
            $r->print($lt{'enin'}.':&nbsp;
                  <input type="text" name="coursecode" size="15" value="" />');
        }
    }
    if ($ctitle) {
        $r->print('<br /><i>'.$lt{'titl'}.'</i>:&nbsp;'.$ctitle.'<input type="hidden" name="title" value="'.$ctitle.'" />');
    } else {
        $r->print('<br />'.$lt{'enct'}.':&nbsp;
                 <input type="text" name="title" size="25" value="" />');
    }
    $r->print(<<END);
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'secn'}: </b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
END
    if ($sectionlist) {
        $r->print("<select name=\"section\"\n>".
                  "  <option value=\"\" selected=\"selected\">$lt{'sele'}</option>\n");
        foreach my $id (sort(keys(%groupid))) {
            if ($id eq $groupid{$id} || $groupid{$id} eq '') {
                $r->print("  <option value=\"$id\" >$id</option>\n");
            } else {
                $r->print("  <option value=\"$id\" >$id - ($lt{'lsec'}: $groupid{$id})</option>\n");
            }
        }
        $r->print("</select>");
    } else {
        $r->print("<input type=\"text\" name=\"section\" size=\"10\"/>");
    }
    $r->print(<<END);
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'subj'}</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
                <input type="text" size="40" name="subject">
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'detd'}:</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
                <textarea rows="10" cols="45" name="description" wrap="virtual"></textarea>
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
	    <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
	    </td>
	   </tr>
END
    if (defined($env{'user.name'})) {
        $r->print(<<END);
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'opfi'}:</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
                <input type="file" name="screenshot" size="20" /><br />$lt{'uplf'}
               </td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
END
    }

    $r->print(<<END);
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'fini'}:</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
                <input type="hidden" name="action" value="process" />
                <input type="button" value="$lt{'subm'}" onClick="validate()"/> &nbsp;
               </td>
               <td>&nbsp;</td>
               <td>
                <input type="reset" value="$lt{'clfm'}">
               </td>
              </tr>
             </table>
            </td>
           </tr>
          </table>
         </td>
        </tr>
       </table>
      </td>
     </tr>
    </table>
   </td>
  </tr>
 </table>
</form>
END
    $r->print(&Apache::loncommon::end_page());
    return;
}

sub print_request_receipt {
    my ($r,$url,$function) = @_;
    my @ENVvars = ('HTTP_HOST','HTTP_USER_AGENT','REMOTE_ADDR','SERVER_ADDR','SERVER_NAME');
    my @envvars = ('browser.os','browser.type','browser.version','user.home','request.role');
    my @loncvars = ('user.name','user.domain','request.course.sec','request.course.id');
    my @cookievars = ('lonID');

    my $admin = $Apache::lonnet::perlvar{'lonAdminMail'};
    my $to =  $Apache::lonnet::perlvar{'lonSupportEMail'};
    my $from = $admin;
    my $reporttime = &Apache::lonlocal::locallocaltime(time);
    my $fontcolor = &Apache::loncommon::designparm($function.'.font');
    my $vlinkcolor = &Apache::loncommon::designparm($function.'.vlink');
    my $tablecolor = &Apache::loncommon::designparm($function.'.tabbg');
    my @formvars = ('username','email','uname','udom','sourceurl','phone','section','coursecode','title','subject','description','screenshot');

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},\@formvars);
    my $coursecode = $env{'form.coursecode'};
    if ($coursecode eq '') {
        if (defined($env{'form.Year'})) {
            $coursecode .= $env{'form.Year'};
        }
        if (defined($env{'form.Semester'})) {
            $coursecode .= $env{'form.Semester'};
        }
        if (defined($env{'form.Department'})) {
            $coursecode .= $env{'form.Department'};
        }
        if (defined($env{'form.Number'})) {
            $coursecode .= $env{'form.Number'};
        }
    }
    my %lt = &Apache::lonlocal::texthash (
                 name => 'Name',
                 email => 'Email',
                 unme => 'Username/domain',
                 tel => 'Tel',
                 crsi => 'Course Information',
                 subj => 'Subject',
                 desc => 'Description',
                 date => 'Date/Time',
                 secn => 'Section',
                 asup => 'A support request has been sent to',
                 warn => 'Warning: Problem with support e-mail address',
                 your => 'Your support request contained the following information',
                 sect => 'section',
                 info => 'Information supplied',
                 adin => 'Additional information recorded',
    );

    my $supportmsg = qq|
$lt{'name'}: $env{'form.username'}
$lt{'email'}: $env{'form.email'}
$lt{'unme'}: $env{'form.uname'} - $env{'form.udom'}
$lt{'tel'}: $env{'form.phone'}
$lt{'crsi'}: $env{'form.title'} - $coursecode - $lt{'secn'}: $env{'form.section'}
$lt{'subj'}: $env{'form.subject'}
$lt{'desc'}: $env{'form.description'}
URL: $env{'form.sourceurl'}
$lt{'date'}: $reporttime

    |;
    my $descrip = $env{'form.description'};
    $descrip =~ s#\n#<br />#g;
    my $displaymsg = qq|
<font color="$fontcolor">$lt{'name'}:</font><font color="$vlinkcolor"> $env{'form.username'}</font><br />
<font color="$fontcolor">$lt{'email'}: </font><font color="$vlinkcolor">$env{'form.email'}</font><br />
<font color="$fontcolor">$lt{'unme'}: </font><font color="$vlinkcolor">$env{'form.uname'} - $env{'form.udom'}</font><br />
<font color="$fontcolor">$lt{'tel'}: </font><font color="$vlinkcolor">$env{'form.phone'}</font><br />
<font color="$fontcolor">$lt{'crsi'}: </font><font color="$vlinkcolor">$env{'form.title'} - $coursecode - $lt{'sect'}: $env{'form.section'}</font><br />
<font color="$fontcolor">$lt{'subj'}: </font><font color="$vlinkcolor">$env{'form.subject'}</font><br />
<font color="$fontcolor">$lt{'desc'}: </font><font color="$vlinkcolor">$descrip</font><br />
<font color="$fontcolor">URL: </font><font color="$vlinkcolor">$env{'form.sourceurl'}</font><br />
<font color="$fontcolor">$lt{'date'}: </font><font color="$vlinkcolor">$reporttime</font><br />
    |;

    my $start_page = 
	&Apache::loncommon::start_page('Support request recorded',undef,
				       {'function'    => $function,
					'add_entries' => {
					    topmargin    => "0",
					    marginheight => "0",
					},
					'only_body'   => 1,});

    $r->print(<<"END");
$start_page
<form name="logproblem">
<input type="hidden" name="action" value="result" />
</form>
END
    if ($r->uri eq '/adm/helpdesk') {
        &print_header($r,$url,'process');
    }
    if ($to =~ m/^[^\@]+\@[^\@]+$/) {
        $r->print('<h3>'.$lt{'asup'}.' '.$to.'</h3>');
    } else {
        $to = $admin;
        if ($to =~ m/^[^\@]+\@[^\@]+$/) {
            $r->print('<h3>'.$lt{'asup'}.' '.$to.'</h3>');
        } else {
            $r->print('
 <h3>'.$lt{'warn'}.'</h3>'.
&mt('As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has <b>not</b> been sent to the LON-CAPA support staff or administrator at your institution.',$to).' '.&mt('Instead a copy has been sent to the LON-CAPA support team at Michigan State University.')); 
            $to = 'helpdesk@lon-capa.org';
        }
    }
    if (defined($env{'form.email'})) {
        if ($env{'form.email'} =~ m/^[^\@]+\@[^\@]+$/) {
            $from = $env{'form.email'};
        }
    }

    my $subject = $env{'form.subject'};
    $subject =~ s#(`)#'#g;
    $subject =~ s#\$#\(\$\)#g;
    $supportmsg =~ s#(`)#'#g;
    $supportmsg =~ s#\$#\(\$\)#g;
    $displaymsg =~ s#(`)#'#g;
    $displaymsg =~ s#\$#\(\$\)#g;
    my $fname;

    my $attachmentpath = '';
    my $attachmentsize = '';
    if (defined($env{'user.name'})) {
        if ($env{'form.screenshot.filename'}) {
            $attachmentsize = length($env{'form.screenshot'});
            if ($attachmentsize > 131072) {
                $displaymsg .= '<br />'.&mt('The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.',$attachmentsize);
            } else {
                $attachmentpath=&Apache::lonnet::userfileupload('screenshot',undef,'helprequests');
            }
        }
    }

    my %cookies;
    my $cookie=CGI::Cookie->parse($r->header_in('Cookie'));
    if ($$cookie{'lonID'} =~ /lonID=($LONCAPA::handle_re);/) {
        $cookies{'lonID'} = $1;
    }

    if ($attachmentpath =~ m-/([^/]+)$-) {
        $fname = $1;
        $displaymsg .= '<br />'.&mt('An uploaded screenshot file - [_1] ([_2] bytes) was included in the request sent by [_3] from LON-CAPA domain',$fname,$attachmentsize,$env{'user.name'}.': '.$env{'user.domain'});
        $supportmsg .= "\n";
        foreach my $var (@cookievars) {
            $supportmsg .= "$var: $cookies{$var}\n";
        }
        foreach my $var(@ENVvars) {
            $supportmsg .= "$var: $ENV{$var}\n";
        }
        foreach my $var (@envvars) {
            $supportmsg .= "$var: $env{$var}\n";
        }
    }
 
    my $msg = MIME::Lite->new(
                 From    => $from,
                 To      => $to,
                 Subject => $subject,
                 Type    =>'TEXT',
                 Data    => $supportmsg,
                 );

    if ($attachmentpath) {
        my ($type, $encoding) = MIME::Types::by_suffix($attachmentpath);
        $msg->attach(Type     => $type,
                     Path     => $attachmentpath,
                     Filename => $fname
                     );

    } else {
        my $envdata = '';
        foreach my $var (@cookievars) {
            $envdata .= "$var: $cookies{$var}\n";
        }
        foreach my $var (@ENVvars) {
            $envdata .= "$var: $ENV{$var}\n";
        }
        foreach my $var (@envvars) {
            $envdata .= "$var: $env{$var}\n";
        }
        foreach my $var (@loncvars) {
            $envdata .= "$var: $env{$var}\n";
        }
        $msg->attach(Type => 'TEXT',
                     Data => $envdata);
    }

### Send it:
    $msg->send('sendmail');

    if ($attachmentpath =~ m#$Apache::lonnet::perlvar{'lonDaemons'}/tmp/helprequests/(\d+)/[^/]+#) {
        unlink($attachmentpath);
    }
    $r->print(qq|
 <b>$lt{'your'}</b>:<br /><br />
 <table width="580" border="0" cellpadding="0" cellspacing="0" bgcolor="#000000">
  <tr>
   <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="#000000">
     <tr>
      <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="#ffffff">
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'info'}</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>$displaymsg</td>
              </tr>
             </table>
            </td>
           </tr>
           <tr>
            <td width="100%" colspan="2" bgcolor="#000000">
             <img src="/adm/lonMisc/blackdot.gif" /><br />
            </td>
           </tr>
           <tr>
            <td width="140" bgcolor="$tablecolor">
             <table width="140" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td align="right"><b>$lt{'adin'}</b>
               </td>
              </tr>
             </table>
            </td>
            <td width="100%" valign="top">
             <table width="100%" border="0" cellpadding="8" cellspacing="0">
              <tr>
               <td>
    |);
    foreach my $var (@cookievars) {
        unless($cookies{$var} eq '') {
            $r->print("$var:&nbsp;<font color='$vlinkcolor'>$cookies{$var}</font>, ");
        }
    }
    foreach my $var (@ENVvars) {
        unless($ENV{$var} eq '') {
            $r->print("$var:&nbsp;<font color='$vlinkcolor'>$ENV{$var}</font>, ");
        }
    }
    foreach my $var (@envvars) {
        unless($env{$var} eq '') { 
            $r->print("$var:&nbsp;<font color='$vlinkcolor'>$env{$var}</font>, ");
        }
    }
    $r->print("
               </td>
              </tr>
             </table>
            </td>
           </tr>
          </table>
         </td>
        </tr>
       </table>
      </td>
     </tr>
    </table>
   </td>
  </tr>
 </table>
    ");
    $r->print(&Apache::loncommon::end_page());
}

sub print_header {
    my ($r,$origurl,$action) = @_;
    my $location=&Apache::loncommon::lonhttpdurl("/adm");
    my $tablecolor = '#EEEE99';
    my ($component_url);
    my $helpdesk_link = '<a href="javascript:validate()">';
    if ($action eq 'process') {
        $helpdesk_link = '<a href="/adm/helpdesk">';
    }
    my %lt = &Apache::lonlocal::texthash (
                                           login => 'Log-in help',
                                           ask   => 'Ask helpdesk',
                                           getst => 'Getting started guide',
                                           back =>  'Back to last location'
                                         );
    my ($getstartlink,$getstarttext);
    if (-e $Apache::lonnet::perlvar{'lonDocRoot'}.'/adm/gettingstarted.html') {
        $getstartlink = qq|<td align="center">&nbsp;<b><a href="/adm/gettingstarted.html">$lt{'getst'}</a></td>|;
        $getstarttext = ' '.&mt('and the "Getting started" guide').' ';
    }
    $r->print(<<END);
<table width="620" border="0" cellspacing="0" cellpadding="0" height="55">   <tr height="50">    <td width='5'>&nbsp;</td>
   <td>
    <fieldset><legend><img src="$location/lonIcons/minilogo.gif" height='20' width='29' valign='bottom' />&nbsp;&nbsp;<b><font size="+1">LON-CAPA help/support</font></b></legend>
 <table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#000000">
  <tr>
   <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="#000000">
     <tr>
      <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="#ffffff">
           <tr bgcolor="$tablecolor">
            <td align="center"><img src="$location/help/gif/smallHelp.gif" border="0" alt="($lt{'login'})" valign="middle" />&nbsp;<b><a href="/adm/loginproblems.html">$lt{'login'}</a></td>
            <td align="center">&nbsp;<b>$helpdesk_link<img src="$location/lonIcons/helpdesk.gif" border="0" alt="($lt{'ask'})" valign="middle" />&nbsp;$lt{'ask'}</a></b>&nbsp;</td>$getstartlink
            <td align="center">&nbsp;<b><a href="$origurl" target="_top"><img src="$location/lonIcons/move_up.gif" border="0" alt="($lt{'back'})" valign="middle" />&nbsp;$lt{'back'}</a></b>&nbsp;</td>
           </tr>
          </table>
         </td>
        </tr>
       </table>
      </td>
     </tr>
    </table>
   </td>
  </tr>
 </table>
</fieldset>
  </td>
  <td width='5'>&nbsp;</td>
 </tr>
 <tr height='5'>
  <td colspan='3' height='5'>&nbsp;</td>
 </tr>
END
    unless ($action eq 'process') {
        $r->print('
 <tr>
  <td colspan="3">'.&mt('
Please review the information in "Log-in help"').$getstarttext.' '.&mt('if you are unable to log-in').'.  '.&mt('If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk').'.<br /><font size="-1"><b>'.&mt('Note').':</b> '.&mt('Student questions about course content should be directed to the course instructor').'.</font><br /><br />
  </td>
 </tr>');
    }
    $r->print('
</table>');
    return;
}

1;
