# The LearningOnline Network
# Communicate
#
# $Id: loncommunicate.pm,v 1.40 2006/12/23 06:58:17 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::loncommunicate;

use strict;
use Apache::Constants qw(:common);
use Apache::lonmsgdisplay();
use Apache::loncommon;
use Apache::lonlocal;
use Apache::lonnet;

sub menu {
    my $r=shift;
    my $crstype = 'Course';
    my $usertype = 'Student';
    if (defined($env{'course.'.$env{'request.course.id'}.'.type'})) {
        $crstype = $env{'course.'.$env{'request.course.id'}.'.type'};
        if ($crstype eq 'Group') {
            $usertype = 'Member';
        }   
    }
    my %lt=&Apache::lonlocal::texthash(
'vcm' => 'View Critical Messages',
'smu' => 'Send Message to User(s)',
'bmc' => "Broadcast Message to $crstype",
'dmu' => "Distribute Messages from Uploaded File to $crstype",
'unr' => 
     'User Notes, Records of Face-to-Face Discussions, and Critical Messages',

'cbs' => "Configure Blocking of $usertype Communication during Exams",
'blog' => 'Add or Edit Blog Entries' 

);
    my %help=();
    foreach ('Course_Face_To_Face_Records,Course_Critical_Message',
	     'Course_Broadcast_Message') {
	$help{$_}=&Apache::loncommon::help_open_topic($_);
    }
# ------------------------------------------------------------------------ Menu
    my ($can_srm,$can_dcm,$can_dff);
    if ($env{'request.course.id'}) {
        if ((&Apache::lonnet::allowed('srm',$env{'request.course.id'})) ||
            (&Apache::lonnet::allowed('srm',$env{'request.course.id'}.'/'.
                                           $env{'request.course.sec'}))) {
            $can_srm = 1;
        }
        if ((&Apache::lonnet::allowed('dcm',$env{'request.course.id'})) ||
            (&Apache::lonnet::allowed('dcm',$env{'request.course.id'}.'/'.
                                           $env{'request.course.sec'}))) {
            $can_dcm = 1;
        }
        if ((&Apache::lonnet::allowed('dff',$env{'request.course.id'})) ||
            (&Apache::lonnet::allowed('dff',$env{'request.course.id'}.'/'.
                                           $env{'request.course.sec'}))) {
            $can_dff = 1;
        }
    }   
    $r->print(<<END);
<table cellspacing="10" cellpadding="2">
<tr>
<td bgcolor="#FFFFAA">
  <b><a href="/adm/email?compose=individual">$lt{'smu'}</a></b>
</td>
<td bgcolor="#FFFFAA">
  <b><a href="/adm/$env{'user.domain'}/$env{'user.name'}/_rss.html">$lt{'blog'}</a></b>
</td>
</tr>
END
    if ($can_srm) {
        $r->print(<<END);
<tr>
<td bgcolor="#FFFFAA">
    <b><a href="/adm/email?compose=group">$lt{'bmc'}</a></b>$help{'Course_Broadcast_Message'}
</td>
<td bgcolor="#FFFFAA">
  <b><a href="/adm/email?compose=upload">$lt{'dmu'}</a></b>
</td></tr>
END
    }
    if ($can_dcm || $can_dff) {
        $r->print('<tr>');
    }
    if ($can_dff) {
        $r->print(<<END);
<td bgcolor="#FFFFAA">
<b><a href="/adm/email?recordftf=query">$lt{'unr'}</a></b>$help{'Course_Face_To_Face_Records,Course_Critical_Message'}
</td>
END
    }
    if ($can_dcm) {
        $r->print('
<td bgcolor="#FFFFAA">
  <b><a href="/adm/email?block=display">'.$lt{'cbs'}.'</a></b>
</td>');
    }
    if ($can_dff || $can_dcm) {
        $r->print('</tr>');
    }
    $r->print('</table>');
}

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
#
# Start document
#

# ----------------------------------------------------------------- Breadcrumbs
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"/adm/communicate",
          text=>"Communication/Messages",
          faq=>12,bug=>'Communication Tools',});

# ---------------------------------------------------------------------- Header
    &Apache::lonmsgdisplay::header($r);
    &menu($r);
    &Apache::lonmsgdisplay::disall($r);
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

1;
__END__
