# The LearningOnline Network with CAPA
# Handler to display the classlist 
#
# $Id: lonviewclasslist.pm,v 1.7 2006/08/25 03:26:05 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###############################################################
##############################################################

package Apache::lonviewclasslist;

use strict;
use Apache::loncoursedata();
use Apache::loncommon();
use Apache::lonhtmlcommon();
use Apache::Constants qw(:common :http REDIRECT);
use Apache::lonlocal;
use Apache::lonnet;


###################################################################
###################################################################

=pod

=item &handler

The typical handler you see in all these modules.  Takes $r, the
http request, as an argument.  

=cut

###################################################################
###################################################################
sub handler {
    my $r=shift;
    if ($r->header_only) {
        &Apache::loncommon::content_type($r,'text/html');
        $r->send_http_header;
        return OK;
    }
#    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
#                                            ['action','state']);
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"/adm/viewclasslist",
          text=>"View Classlist",
          faq=>9,bug=>'Instructor Interface',});
    #  Needs to be in a course
    if (! ($env{'request.course.fn'})) {
        $env{'user.error.msg'}=
            "/adm/viewclasslist:not in course role";
        return HTTP_NOT_ACCEPTABLE; 
    }
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    #
    my $start_page = &Apache::loncommon::start_page('Classlist');
    my $breadcrumbs= &Apache::lonhtmlcommon::breadcrumbs(undef,
							 'Enrollment Manager');
    $r->print(<<ENDHEADER);
$start_page
$breadcrumbs
ENDHEADER
    #
    # Print classlist
    my $cid = $env{'request.course.id'};
    my $viewpermission = 'course.'.$cid.'.student_classlist_view';
    if (&allowed_to_view_classlist()) {
        $r->print(&html_classlist());
    } else {
        $r->print('<h2>'.
                  &mt("You are not authorized to view the classlist for your course.").
                  '</h2>');
    }
    #
    # Finish up
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub allowed_to_view_classlist {
    return 0 if (! exists($env{'request.course.id'}));
    my $cid = $env{'request.course.id'};
    my $viewpermission = 'course.'.$cid.'.student_classlist_view';
    if (exists($env{$viewpermission}) &&
        $env{$viewpermission} =~ /^(all|section)$/) {
        return $env{$viewpermission};
    } else {
        return 0;
    }
}

sub html_classlist {
    my $limit_to_section = (&allowed_to_view_classlist()=~ /^section$/i);
    my $Str;
    if ($limit_to_section) {
        if ($env{'request.course.sec'} eq '') {
            $Str .= '<h2>'.
                &mt('Students with no section').'</h2>';
        } else {
            $Str.='<h2>'.
                &mt('Students in section "[_1]"',
                    $env{'request.course.sec'}).
                    '</h2>';
        }
    }
    # 
    my $classlist = &Apache::loncoursedata::get_classlist();
    #
    # Set up a couple variables.
    my $usernameidx = &Apache::loncoursedata::CL_SNAME();
    my $domainidx   = &Apache::loncoursedata::CL_SDOM();
    my $fullnameidx = &Apache::loncoursedata::CL_FULLNAME();
    my $sectionidx  = &Apache::loncoursedata::CL_SECTION();
    my $statusidx   = &Apache::loncoursedata::CL_STATUS();
    #
    # Sort the students
    my $sortby = $fullnameidx;
    my @Sorted_Students = sort {
        lc($classlist->{$a}->[$sortby])  cmp lc($classlist->{$b}->[$sortby])
        } (keys(%$classlist));
    $Str .= '<table>'.$/.
        '<tr>'.
        '<th></th>'. # for the count
        '<th>'.&mt('Student').'</th>'.
        '<th>'.&mt('Username').'</th>';
    if (! $limit_to_section) {
        $Str .= '<th>'.&mt('Section').'</th>';
    }
    $Str .='</tr>'.$/;
    my $count ++;
    foreach my $student (@Sorted_Students) {
        my $username = $classlist->{$student}->[$usernameidx];
        my $domain   = $classlist->{$student}->[$domainidx];
        my $fullname = $classlist->{$student}->[$fullnameidx];
        if ($fullname =~ /^\s*$/) {
            $fullname = &mt('Name not given');
        }
        my $section  = $classlist->{$student}->[$sectionidx];
        my $status   = $classlist->{$student}->[$statusidx];
        next if (lc($status) ne 'active');
        if ($limit_to_section) {
            if ($section ne $env{'request.course.sec'}) {
                next;
            }
        }
        $Str .= '<tr>'.
            '<td>'.$count++.'</td>'.
            '<td>'.&Apache::loncommon::aboutmewrapper($fullname,
                                                      $username,
                                                      $domain).'</td>'.
            '<td>'.('&nbsp;'x2).
            &Apache::loncommon::messagewrapper
            ('<img src="/adm/lonIcons/mailto.gif" border="0" />&nbsp;'.
             $username.'@'.$domain,$username,$domain).'</td>';
        if (! $limit_to_section) {
            $Str .= '<td>'.$section.'</td>';
        }
        $Str .= '</tr>'.$/;
    }
    $Str .= '</table>';
    return $Str;
}

###################################################################
###################################################################

1;
__END__


