/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.CifReader;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class CmlReader
extends AtomSetCollectionReader {
    CmlReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("cml");
        XMLReader xmlr = null;
        if (xmlr == null && System.getProperty("java.version").compareTo("1.4") >= 0) {
            xmlr = this.allocateXmlReader14();
        }
        if (xmlr == null) {
            xmlr = this.allocateXmlReaderAelfred2();
        }
        if (xmlr == null) {
            System.out.println("No XML reader found");
            this.atomSetCollection.errorMessage = "No XML reader found";
            return this.atomSetCollection;
        }
        InputSource is = new InputSource(reader);
        is.setSystemId("foo");
        CmlHandler cmlh = new CmlHandler();
        xmlr.setFeature("http://xml.org/sax/features/validation", false);
        xmlr.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlr.setEntityResolver(cmlh);
        xmlr.setContentHandler(cmlh);
        xmlr.setErrorHandler(cmlh);
        xmlr.parse(is);
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    XMLReader allocateXmlReader14() {
        XMLReader xmlr = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            xmlr = saxParser.getXMLReader();
            System.out.println("Using JAXP/SAX XML parser.");
        }
        catch (Exception e) {
            System.out.println("Could not instantiate JAXP/SAX XML reader: " + e.getMessage());
        }
        return xmlr;
    }

    XMLReader allocateXmlReaderAelfred2() {
        XMLReader xmlr = null;
        try {
            xmlr = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
            System.out.println("Using Aelfred2 XML parser.");
        }
        catch (Exception e) {
            System.out.println("Could not instantiate Aelfred2 XML reader!");
        }
        return xmlr;
    }

    class CmlHandler
    extends DefaultHandler
    implements ErrorHandler {
        Atom atom;
        float[] notionalUnitcell;
        int atomCount;
        Atom[] atomArray = new Atom[100];
        int bondCount;
        Bond[] bondArray = new Bond[100];
        int tokenCount;
        String[] tokens = new String[16];
        int elementContext;
        static final int UNSET = 0;
        static final int CRYSTAL = 1;
        static final int ATOM = 2;
        boolean keepChars;
        String chars;
        String dictRef;
        String title;
        int moleculeNesting = 0;

        CmlHandler() {
        }

        void breakOutTokens(String str) {
            StringTokenizer st = new StringTokenizer(str);
            this.tokenCount = st.countTokens();
            if (this.tokenCount > this.tokens.length) {
                this.tokens = new String[this.tokenCount];
            }
            for (int i = 0; i < this.tokenCount; ++i) {
                try {
                    this.tokens[i] = st.nextToken();
                    continue;
                }
                catch (NoSuchElementException nsee) {
                    this.tokens[i] = null;
                }
            }
        }

        int parseBondToken(String str) {
            if (str.length() == 1) {
                switch (str.charAt(0)) {
                    case 'S': {
                        return 1;
                    }
                    case 'D': {
                        return 2;
                    }
                    case 'T': {
                        return 3;
                    }
                    case 'A': {
                        return 4;
                    }
                }
                return CmlReader.this.parseInt(str);
            }
            float floatOrder = CmlReader.this.parseFloat(str);
            if ((double)floatOrder == 1.5) {
                return 4;
            }
            if (floatOrder == 2.0f) {
                return 2;
            }
            if (floatOrder == 3.0f) {
                return 3;
            }
            return 1;
        }

        void breakOutAtomTokens(String str) {
            this.breakOutTokens(str);
            this.checkAtomArrayLength(this.tokenCount);
        }

        void checkAtomArrayLength(int newAtomCount) {
            if (this.atomCount == 0) {
                if (newAtomCount > this.atomArray.length) {
                    this.atomArray = new Atom[newAtomCount];
                }
                int i = newAtomCount;
                while (--i >= 0) {
                    this.atomArray[i] = new Atom();
                }
                this.atomCount = newAtomCount;
            } else if (newAtomCount != this.atomCount) {
                throw new IndexOutOfBoundsException("bad atom attribute length");
            }
        }

        void breakOutBondTokens(String str) {
            this.breakOutTokens(str);
            this.checkBondArrayLength(this.tokenCount);
        }

        void checkBondArrayLength(int newBondCount) {
            if (this.bondCount == 0) {
                if (newBondCount > this.bondArray.length) {
                    this.bondArray = new Bond[newBondCount];
                }
                int i = newBondCount;
                while (--i >= 0) {
                    this.bondArray[i] = new Bond();
                }
                this.bondCount = newBondCount;
            } else if (newBondCount != this.bondCount) {
                throw new IndexOutOfBoundsException("bad bond attribute length");
            }
        }

        public void startDocument() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if ("molecule".equals(localName)) {
                if (++this.moleculeNesting > 1) {
                    return;
                }
                CmlReader.this.atomSetCollection.newAtomSet();
                String collectionName = null;
                int i = atts.getLength();
                while (--i >= 0) {
                    String attLocalName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    if ("title".equals(attLocalName)) {
                        collectionName = attValue;
                        continue;
                    }
                    if (!"id".equals(attLocalName) || collectionName != null) continue;
                    collectionName = attValue;
                }
                if (collectionName != null) {
                    CmlReader.this.atomSetCollection.setAtomSetName(collectionName);
                }
                return;
            }
            if ("atom".equals(localName)) {
                this.elementContext = 2;
                this.atom = new Atom();
                boolean coords3D = false;
                int i = atts.getLength();
                while (--i >= 0) {
                    String attLocalName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    if ("id".equals(attLocalName)) {
                        this.atom.atomName = attValue;
                        continue;
                    }
                    if ("x3".equals(attLocalName)) {
                        coords3D = true;
                        this.atom.x = CmlReader.this.parseFloat(attValue);
                        continue;
                    }
                    if ("y3".equals(attLocalName)) {
                        this.atom.y = CmlReader.this.parseFloat(attValue);
                        continue;
                    }
                    if ("z3".equals(attLocalName)) {
                        this.atom.z = CmlReader.this.parseFloat(attValue);
                        continue;
                    }
                    if ("x2".equals(attLocalName)) {
                        if (!Float.isNaN(this.atom.x)) continue;
                        this.atom.x = CmlReader.this.parseFloat(attValue);
                        continue;
                    }
                    if ("y2".equals(attLocalName)) {
                        if (!Float.isNaN(this.atom.y)) continue;
                        this.atom.y = CmlReader.this.parseFloat(attValue);
                        continue;
                    }
                    if ("elementType".equals(attLocalName)) {
                        this.atom.elementSymbol = attValue;
                        continue;
                    }
                    if (!"formalCharge".equals(attLocalName)) continue;
                    this.atom.formalCharge = CmlReader.this.parseInt(attValue);
                }
                if (!coords3D) {
                    this.atom.z = 0.0f;
                }
                return;
            }
            if ("atomArray".equals(localName)) {
                this.atomCount = 0;
                boolean coords3D = false;
                int i = atts.getLength();
                while (--i >= 0) {
                    int j;
                    String attLocalName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    if ("atomID".equals(attLocalName)) {
                        this.breakOutAtomTokens(attValue);
                        j = this.tokenCount;
                        while (--j >= 0) {
                            this.atomArray[j].atomName = this.tokens[j];
                        }
                        continue;
                    }
                    if ("x3".equals(attLocalName)) {
                        coords3D = true;
                        this.breakOutAtomTokens(attValue);
                        j = this.tokenCount;
                        while (--j >= 0) {
                            this.atomArray[j].x = CmlReader.this.parseFloat(this.tokens[j]);
                        }
                        continue;
                    }
                    if ("y3".equals(attLocalName)) {
                        this.breakOutAtomTokens(attValue);
                        j = this.tokenCount;
                        while (--j >= 0) {
                            this.atomArray[j].y = CmlReader.this.parseFloat(this.tokens[j]);
                        }
                        continue;
                    }
                    if ("z3".equals(attLocalName)) {
                        this.breakOutAtomTokens(attValue);
                        j = this.tokenCount;
                        while (--j >= 0) {
                            this.atomArray[j].z = CmlReader.this.parseFloat(this.tokens[j]);
                        }
                        continue;
                    }
                    if ("x2".equals(attLocalName)) {
                        this.breakOutAtomTokens(attValue);
                        j = this.tokenCount;
                        while (--j >= 0) {
                            this.atomArray[j].z = CmlReader.this.parseFloat(this.tokens[j]);
                        }
                        continue;
                    }
                    if ("y2".equals(attLocalName)) {
                        this.breakOutAtomTokens(attValue);
                        j = this.tokenCount;
                        while (--j >= 0) {
                            this.atomArray[j].z = CmlReader.this.parseFloat(this.tokens[j]);
                        }
                        continue;
                    }
                    if (!"elementType".equals(attLocalName)) continue;
                    this.breakOutAtomTokens(attValue);
                    j = this.tokenCount;
                    while (--j >= 0) {
                        this.atomArray[j].elementSymbol = this.tokens[j];
                    }
                }
                int j = this.atomCount;
                while (--j >= 0) {
                    Atom atom = this.atomArray[j];
                    if (coords3D) continue;
                    atom.z = 0.0f;
                }
                return;
            }
            if ("bond".equals(localName)) {
                int order = -1;
                int i = atts.getLength();
                while (--i >= 0) {
                    String attLocalName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    if ("atomRefs2".equals(attLocalName)) {
                        this.breakOutTokens(attValue);
                        continue;
                    }
                    if (!"order".equals(attLocalName)) continue;
                    order = this.parseBondToken(attValue);
                }
                if (this.tokenCount == 2 && order > 0) {
                    CmlReader.this.atomSetCollection.addNewBond(this.tokens[0], this.tokens[1], order);
                }
                return;
            }
            if ("bondArray".equals(localName)) {
                this.bondCount = 0;
                int i = atts.getLength();
                while (--i >= 0) {
                    int j;
                    String attLocalName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    if ("order".equals(attLocalName)) {
                        this.breakOutBondTokens(attValue);
                        j = this.tokenCount;
                        while (--j >= 0) {
                            this.bondArray[j].order = this.parseBondToken(this.tokens[j]);
                        }
                        continue;
                    }
                    if ("atomRef1".equals(attLocalName)) {
                        this.breakOutBondTokens(attValue);
                        j = this.tokenCount;
                        while (--j >= 0) {
                            this.bondArray[j].atomIndex1 = CmlReader.this.atomSetCollection.getAtomNameIndex(this.tokens[j]);
                        }
                        continue;
                    }
                    if (!"atomRef2".equals(attLocalName)) continue;
                    this.breakOutBondTokens(attValue);
                    j = this.tokenCount;
                    while (--j >= 0) {
                        this.bondArray[j].atomIndex2 = CmlReader.this.atomSetCollection.getAtomNameIndex(this.tokens[j]);
                    }
                }
                return;
            }
            if ("crystal".equals(localName)) {
                this.elementContext = 1;
                this.notionalUnitcell = new float[6];
                int i = 6;
                while (--i >= 0) {
                    this.notionalUnitcell[i] = Float.NaN;
                }
                return;
            }
            if ("scalar".equals(localName)) {
                int i = atts.getLength();
                while (--i >= 0) {
                    String attLocalName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    if ("title".equals(attLocalName)) {
                        this.title = attValue;
                        continue;
                    }
                    if (!"dictRef".equals(attLocalName)) continue;
                    this.dictRef = attValue;
                }
                this.keepChars = true;
                return;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.processEndElement(uri, localName, qName);
            this.keepChars = false;
            this.title = null;
            this.dictRef = null;
            this.chars = null;
        }

        void processEndElement(String uri, String localName, String qName) {
            if ("molecule".equals(localName)) {
                --this.moleculeNesting;
                return;
            }
            if ("atom".equals(localName)) {
                if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                    CmlReader.this.atomSetCollection.addAtomWithMappedName(this.atom);
                }
                this.atom = null;
                this.elementContext = 0;
                return;
            }
            if ("crystal".equals(localName)) {
                this.elementContext = 0;
                int i = 6;
                while (--i >= 0) {
                    if (!Float.isNaN(this.notionalUnitcell[i])) continue;
                    System.out.println("incomplete/unrecognized unitcell");
                    return;
                }
                CmlReader.this.atomSetCollection.notionalUnitcell = this.notionalUnitcell;
                return;
            }
            if ("scalar".equals(localName)) {
                if (this.elementContext == 1) {
                    int i;
                    if (this.title != null) {
                        i = 6;
                        while (--i >= 0 && !this.title.equals(AtomSetCollection.notionalUnitcellTags[i])) {
                        }
                        if (i >= 0) {
                            this.notionalUnitcell[i] = CmlReader.this.parseFloat(this.chars);
                        }
                    }
                    if (this.dictRef != null) {
                        i = 6;
                        while (--i >= 0 && !this.dictRef.equals("cif:" + CifReader.cellParamNames[i])) {
                        }
                        if (i >= 0) {
                            this.notionalUnitcell[i] = CmlReader.this.parseFloat(this.chars);
                        }
                    }
                    return;
                }
                if (this.elementContext == 2 && "jmol:charge".equals(this.dictRef)) {
                    this.atom.partialCharge = CmlReader.this.parseFloat(this.chars);
                }
                return;
            }
            if ("atomArray".equals(localName)) {
                for (int i = 0; i < this.atomCount; ++i) {
                    Atom atom = this.atomArray[i];
                    if (atom.elementSymbol == null || Float.isNaN(atom.z)) continue;
                    CmlReader.this.atomSetCollection.addAtomWithMappedName(atom);
                }
                return;
            }
            if ("bondArray".equals(localName)) {
                for (int i = 0; i < this.bondCount; ++i) {
                    CmlReader.this.atomSetCollection.addBond(this.bondArray[i]);
                }
                return;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.keepChars) {
                this.chars = this.chars == null ? new String(ch, start, length) : this.chars + new String(ch, start, length);
            }
        }

        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
            System.out.println("Not resolving this:");
            System.out.println("      name: " + name);
            System.out.println("  systemID: " + systemId);
            System.out.println("  publicID: " + publicId);
            System.out.println("   baseURI: " + baseURI);
            return null;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            System.out.println("Not resolving this:");
            System.out.println("  publicID: " + publicId);
            System.out.println("  systemID: " + systemId);
            return null;
        }

        public void error(SAXParseException exception) {
            System.out.println("SAX ERROR:" + exception.getMessage());
        }

        public void fatalError(SAXParseException exception) {
            System.out.println("SAX FATAL:" + exception.getMessage());
        }

        public void warning(SAXParseException exception) {
            System.out.println("SAX WARNING:" + exception.getMessage());
        }
    }
}

